/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.service.IContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractDetailSyncVO;
import com.ejianc.business.zdsmaterial.erp.vo.ContractSyncVO;
import com.ejianc.business.zdsmaterial.erp.vo.ContractVO;
import com.ejianc.business.zdsmaterial.material.bean.MatCheckerSettingEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatCheckerSettingService;
import com.ejianc.business.zdsmaterial.material.service.IMatFeeApplyService;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.material.api.IMatLinkerApi;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"contract"})
public class ContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ContractController.class);
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IContractService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IMatLinkerApi linkerApi;
    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IPurchasePlanService purchasePlanService;
    @Value(value="${erp.appId}")
    private String appId;
    @Value(value="${erp.secret}")
    private String secret;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Value(value="${erp.batchSize:100}")
    private String batchSize;
    private final String PUR_MATERIAL_CONTRACT_ERP_REQ_URL = "/cefoc/yql/getMEContractInfoInfo";
    private final String ERP_CACHE_PROJECT_PREFIX = "erp::project::";
    private final String emptySID = "00000000-0000-0000-0000-000000000000";
    @Autowired
    private IMatSupplierApi supplierApi;
    @Autowired
    private IMatLinkerApi matLinkerApi;
    @Autowired
    private IMatCheckerSettingService matCheckerSettingService;
    @Autowired
    private IMatFeeApplyService matFeeApplyService;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)this.service.selectById(id));
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Contract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"projectId"))));
            }
            if (_con.containsKey((Object)"sealedFlag")) {
                param.getParams().put("sealedFlag", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"sealedFlag"))));
            } else {
                param.getParams().put("sealedFlag", new Parameter("eq", (Object)"1"));
            }
        } else {
            param.getParams().put("sealedFlag", new Parameter("eq", (Object)"1"));
        }
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/deleteContract"})
    public CommonResponse<ContractVO> deleteContract(@RequestBody String sourceContractId) {
        ContractVO contract = this.service.getOneBySourceContractId(sourceContractId);
        if (null == contract) {
            return CommonResponse.error((String)"\u5408\u540c\u5728\u4f9b\u5e94\u94fe\u5e73\u53f0\u4e0d\u5b58\u5728");
        }
        CommonResponse quoteResp = this.billTypeApi.checkQuote("EJCBT202312000005", contract.getId());
        if (!quoteResp.isSuccess()) {
            return CommonResponse.error((String)(StringUtils.isNotBlank((CharSequence)quoteResp.getMsg()) ? quoteResp.getMsg() : "\u5220\u9664\u5931\u8d25, \u5408\u540c\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528"));
        }
        this.service.removeById(contract.getId(), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f", (Object)contract);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ContractEntity> checkSyncContractInfo(List<ContractSyncVO> contractVOs, List<ContractEntity> updateList, List<String> empSourceIds, List<String> supSourceIds, List<String> prjSourceIds, List<String> supLinkerSourceIds, Set<String> brandNames, Set<String> serialNos, boolean initFlag) {
        CommonResponse empResp;
        ArrayList<ContractDetailEntity> saveDetails = new ArrayList<ContractDetailEntity>();
        Map<Object, Object> supplierSourceMap = new HashMap();
        Map<Object, Object> projectSourceMap = new HashMap();
        Map<Object, Object> empSourceMap = new HashMap();
        Map<Object, Object> linkerSourceMap = new HashMap();
        ArrayList<ContractEntity> saveList = new ArrayList<ContractEntity>();
        ContractEntity saveContractInfo = null;
        ArrayList<Long> queryOrgIds = new ArrayList<Long>();
        Map<Object, Object> planDetailMap = new HashMap();
        PurchasePlanDetailVO planDetailVO = null;
        Map<String, BrandEntity> brandNameMap = null;
        if (CollectionUtils.isNotEmpty(brandNames)) {
            brandNameMap = this.brandService.getAllByNames(new ArrayList<String>(brandNames));
            logger.info("brandNameMap:{}", (Object)JSONObject.toJSONString(brandNameMap));
        }
        if (CollectionUtils.isNotEmpty(serialNos)) {
            List<PurchasePlanDetailVO> planDetails = this.purchasePlanDetailService.findAllByMaterialNos(new ArrayList<String>(serialNos));
            planDetailMap = planDetails.stream().collect(Collectors.toMap(item -> item.getMaterialSerialNo(), item -> item));
        }
        if (!(empResp = this.employeeApi.getAllBySourceIds(empSourceIds)).isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u63a5\u8d27\u4eba\u4e3b\u952e\u83b7\u53d6\u5339\u914d\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        empSourceMap = ((List)empResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        JSONObject supParams = new JSONObject();
        supParams.put("sourceIds", supSourceIds);
        CommonResponse supplierResp = this.supplierApi.getAllBySourceIds(supParams);
        if (!supplierResp.isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u4f9b\u5e94\u5546\u4e3b\u952e\u83b7\u53d6\u5339\u914d\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        supplierSourceMap = ((List)supplierResp.getData()).stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
        CommonResponse poolResp = this.projectPoolApi.getAllBySourceIds(prjSourceIds);
        if (!poolResp.isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u9879\u76ee\u4e3b\u952e\u83b7\u53d6\u5339\u914d\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        projectSourceMap = ((List)poolResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        CommonResponse linkerResp = this.linkerApi.getBySourceIds(supLinkerSourceIds);
        if (!linkerResp.isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4e3b\u952e\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        linkerSourceMap = ((List)linkerResp.getData()).stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
        for (ContractSyncVO contractVO : contractVOs) {
            EmployeeVO operator;
            if ("5".equals(contractVO.getErpStatus())) {
                logger.info("\u5408\u540csid-{}ERP\u4f5c\u5e9f\uff0c\u5728EL\u672a\u5165\u5e93\uff0c\u8df3\u8fc7\u540c\u6b65~", (Object)contractVO.getSourceContractId());
                continue;
            }
            saveContractInfo = new ContractEntity();
            if (StringUtils.isBlank((CharSequence)contractVO.getContractName())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u7cfb\u7edf\u5408\u540c\u540d\u79f0\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u7cfb\u7edf\u5408\u540c\u7f16\u7801\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                continue;
            }
            MatSupplierVO supplier = null;
            if (StringUtils.isBlank((CharSequence)contractVO.getSupplierCode()) && StringUtils.isBlank((CharSequence)contractVO.getSupplierId())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u4f9b\u5e94\u5546\u4e3b\u952e/\u7f16\u7801\u4e0d\u80fd\u90fd\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)contractVO.getSupplierId()) && null == (supplier = (MatSupplierVO)supplierSourceMap.get(contractVO.getSupplierId()))) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u5b58\u4e0eERP\u4f9b\u5e94\u5546\u4e3b\u952e\u5339\u914d\u7684\u4f9b\u5e94\u5546, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                continue;
            }
            ProjectPoolSetVO project = null;
            if (StringUtils.isBlank((CharSequence)contractVO.getProjectId()) || "00000000-0000-0000-0000-000000000000".equals(contractVO.getProjectId())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u9879\u76ee\u4e3b\u952e\u4e0d\u80fd\u90fd\u4e3a\u7a7a, \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == (project = (ProjectPoolSetVO)projectSourceMap.get(contractVO.getProjectId()))) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u5b58\u4e0eERP\u9879\u76ee\u4e3b\u952e\u5339\u914d\u7684\u9879\u76ee \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == contractVO.getPriceType()) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u8ba1\u4ef7\u65b9\u5f0f\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                continue;
            }
            if (!ZDSMaterialCommonEnums.\u5355\u4ef7\u5408\u540c.getCode().equals(contractVO.getPriceType()) && !ZDSMaterialCommonEnums.\u603b\u4ef7\u5408\u540c.getCode().equals(contractVO.getPriceType())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u7684\u5408\u540c\u8ba1\u4ef7\u65b9\u5f0f\uff1a{}, \u540c\u6b65\u4fe1\u606f:{}", (Object)contractVO.getPriceType(), (Object)JSONObject.toJSONString((Object)contractVO));
                continue;
            }
            if (ZDSMaterialCommonEnums.\u603b\u4ef7\u5408\u540c.getCode().equals(contractVO.getPriceType()) && CollectionUtils.isEmpty((Collection)contractVO.getDetailList())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u603b\u4ef7\u5408\u540c\u7269\u6599\u660e\u65ed\u4e0d\u80fd\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == contractVO.getSignDate()) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == contractVO.getEnableStatus()) {
                logger.error("\u540c\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u72b6\u6001\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (!ZDSMaterialCommonEnums.ERP\u5408\u540c\u505c\u542f\u7528_\u542f\u7528.getCode().equals(contractVO.getEnableStatus()) && !ZDSMaterialCommonEnums.ERP\u5408\u540c\u505c\u542f\u7528_\u505c\u7528.getCode().equals(contractVO.getEnableStatus())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u9519\u8bef\u7684\u5408\u540c\u72b6\u6001\uff1a{}, \u540c\u6b65\u4fe1\u606f:{}", (Object)contractVO.getEnableStatus(), (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == contractVO.getTaxMny()) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == contractVO.getMny()) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u91d1\u989d\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == contractVO.getTax()) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u7a0e\u989d\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            EmployeeVO masterPorter = null;
            if (StringUtils.isBlank((CharSequence)contractVO.getMasterPorterId())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u63a5\u8d27\u4eba\u4e3b\u952e\u4e0d\u80fd\u90fd\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == (masterPorter = (EmployeeVO)empSourceMap.get(contractVO.getMasterPorterId()))) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u5b58\u4e0eERP\u63a5\u8d27\u4eba\u4e3b\u952e\u5339\u914d\u7684\u4eba\u5458 \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            MatLinkerVO supplierManager = null;
            if (StringUtils.isBlank((CharSequence)contractVO.getSupplierManagerSID())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u4e59\u65b9\u8054\u7cfb\u4ebaSID\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == (supplierManager = (MatLinkerVO)linkerSourceMap.get(contractVO.getSupplierManagerSID()))) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u5b58\u4e0eERP\u4e59\u65b9\u8054\u7cfb\u4eba\u4e3b\u952e\u5339\u914d\u7684\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (StringUtils.isBlank((CharSequence)contractVO.getSupplierManagerPhone())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u4e59\u65b9\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            saveContractInfo.setSupplierManagerSid(contractVO.getSupplierManagerSID());
            saveContractInfo.setSupplierManagerName(contractVO.getSupplierManagerName());
            saveContractInfo.setSupplierManagerPhone(contractVO.getSupplierManagerPhone());
            if (null != supplierManager) {
                saveContractInfo.setSupplierManagerId(supplierManager.getId());
                saveContractInfo.setSupplierManagerName(supplierManager.getName());
                saveContractInfo.setSupplierManagerPhone(StringUtils.isNotBlank((CharSequence)contractVO.getSupplierManagerPhone()) ? contractVO.getSupplierManagerPhone() : supplierManager.getMobileLinkPhone());
                saveContractInfo.setSupplierManagerSupId(supplierManager.getSupUserId());
            }
            if (StringUtils.isBlank((CharSequence)contractVO.getErpEmployeeId())) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0cERP\u5408\u540c\u7ecf\u529e\u4eba\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null == (operator = (EmployeeVO)empSourceMap.get(contractVO.getErpEmployeeId()))) {
                logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u5b58\u4e0eERP\u5408\u540c\u7ecf\u529e\u4eba\u4e3b\u952e\u5339\u914d\u7684\u4eba\u5458 \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                if (!initFlag) continue;
            }
            if (null != operator) {
                saveContractInfo.setEmployeeId(operator.getId());
                saveContractInfo.setEmployeeCode(operator.getCode());
                saveContractInfo.setEmployeeName(operator.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)contractVO.getEmployeePhone())) {
                saveContractInfo.setEmployeePhone(contractVO.getEmployeePhone());
            } else if (null != operator) {
                saveContractInfo.setEmployeePhone(operator.getMobilePhone());
            }
            saveContractInfo.setSourceContractId(contractVO.getSourceContractId());
            saveContractInfo.setBillCode(contractVO.getBillCode());
            saveContractInfo.setContractCode(contractVO.getContractCode());
            saveContractInfo.setContractName(contractVO.getContractName());
            saveContractInfo.setTaxPointName(contractVO.getTaxPointName());
            saveContractInfo.setSupplierManagerSid(contractVO.getSupplierSid());
            saveContractInfo.setSupplierName(contractVO.getSupplierName());
            if (null != supplier) {
                saveContractInfo.setSupplierId(supplier.getId());
                saveContractInfo.setSupplierCode(supplier.getCode());
                saveContractInfo.setSupplierName(supplier.getName());
            }
            saveContractInfo.setProjectSid(contractVO.getProjectSid());
            saveContractInfo.setProjectName(contractVO.getProjectName());
            if (null != project) {
                saveContractInfo.setProjectId(project.getId());
                saveContractInfo.setProjectCode(project.getCode());
                saveContractInfo.setProjectName(project.getName());
                saveContractInfo.setOrgId(project.getProjectDepartmentId());
                saveContractInfo.setOrgCode(project.getProjectDepartmentCode());
                saveContractInfo.setOrgName(project.getProjectDepartmentName());
                saveContractInfo.setParentOrgCode(project.getOrgCode());
                saveContractInfo.setParentOrgId(project.getOrgId());
                saveContractInfo.setParentOrgName(project.getOrgName());
                saveContractInfo.setProjectManagementId(project.getProjectManagementId());
                saveContractInfo.setProjectManagementName(project.getProjectManagementName());
                saveContractInfo.setProjectManagementPhone(project.getProjectManagementPhone());
                saveContractInfo.setExecutCode(project.getCode());
                saveContractInfo.setExecutUnitName(project.getName());
                saveContractInfo.setExecutUnitId(project.getId().toString());
            }
            saveContractInfo.setExecutUnitSid(contractVO.getProjectId());
            if (StringUtils.isBlank((CharSequence)saveContractInfo.getOrgCode())) {
                queryOrgIds.add(saveContractInfo.getOrgId());
            }
            if (StringUtils.isBlank((CharSequence)saveContractInfo.getParentOrgCode())) {
                queryOrgIds.add(saveContractInfo.getParentOrgId());
            }
            saveContractInfo.setIsOfficialSeal(contractVO.getIsOfficialSeal());
            saveContractInfo.setPayMoney(contractVO.getPayMoney());
            saveContractInfo.setBillMoney(contractVO.getBillMoney());
            saveContractInfo.setPaymentStyleSid(contractVO.getPaymentStyleSid());
            saveContractInfo.setPaymentStyle(contractVO.getPaymentStyle());
            saveContractInfo.setPaymentWayCom(contractVO.getPaymentWayCom());
            saveContractInfo.setPaymentPeriodCom(contractVO.getPaymentPeriodCom());
            saveContractInfo.setContactBankAccount(contractVO.getContactBankAccount());
            saveContractInfo.setContactBank(contractVO.getContactBank());
            saveContractInfo.setPriceType(contractVO.getPriceType());
            saveContractInfo.setSignDate(contractVO.getSignDate());
            saveContractInfo.setEnableStatus(contractVO.getEnableStatus());
            saveContractInfo.setRate(contractVO.getRate());
            saveContractInfo.setTaxMny(contractVO.getTaxMny());
            saveContractInfo.setMny(contractVO.getMny());
            saveContractInfo.setTax(contractVO.getTax());
            if (null != masterPorter) {
                saveContractInfo.setMasterPorterId(masterPorter.getId());
                saveContractInfo.setMasterPorterName(masterPorter.getName());
                saveContractInfo.setMasterPorterCode(masterPorter.getCode());
            }
            saveContractInfo.setLinkPhone(StringUtils.isNotBlank((CharSequence)contractVO.getLinkPhone()) ? contractVO.getLinkPhone() : (null != masterPorter ? masterPorter.getMobilePhone() : null));
            saveContractInfo.setDeliveryDate(contractVO.getDeliveryDate());
            saveContractInfo.setDeliveryAddress(contractVO.getDeliveryAddress());
            saveContractInfo.setDeliveryRemark(contractVO.getDeliveryRemark());
            saveContractInfo.setRemark(contractVO.getRemark());
            saveContractInfo.setId(contractVO.getId());
            saveContractInfo.setContractType(contractVO.getContractType());
            saveContractInfo.setApplyFlag(contractVO.getApplyFlag());
            saveContractInfo.setMainContractSid(contractVO.getMainContractSid());
            saveContractInfo.setAdditionalTaxMny(contractVO.getAdditionalTaxMny());
            saveContractInfo.setIsOfficialSeal(contractVO.getIsOfficialSeal());
            saveContractInfo.setPaymentStyleSid(contractVO.getPaymentStyleSid());
            saveContractInfo.setPaymentStyle(contractVO.getPaymentStyle());
            saveContractInfo.setPaymentWayCom(contractVO.getPaymentWayCom());
            saveContractInfo.setPaymentPeriodCom(contractVO.getPaymentPeriodCom());
            if (ZDSMaterialCommonEnums.\u603b\u4ef7\u5408\u540c.getCode().equals(contractVO.getPriceType())) {
                ContractDetailEntity saveDetailVo = null;
                HashMap detailIdMap = new HashMap();
                boolean saveFlag = true;
                for (ContractDetailSyncVO detail : contractVO.getDetailList()) {
                    saveFlag = true;
                    if (!initFlag && StringUtils.isBlank((CharSequence)detail.getMaterialSerialNo())) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-\u7269\u8d44\u6d41\u6c34\u53f7\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    saveDetailVo = new ContractDetailEntity();
                    saveDetailVo.setId(IdWorker.getId());
                    saveDetailVo.setRowState("add");
                    if (null == detail.getSourceContractId()) {
                        saveFlag = false;
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-ERP\u4e3b\u8868\u4e3b\u952e\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        break;
                    }
                    if (null == detail.getSourceDetailId()) {
                        saveFlag = false;
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-ERP\u5b50\u8868\u4e3b\u952e\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        break;
                    }
                    if (null == detail.getPurNum()) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-\u6570\u91cf\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailPrice()) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-\u5355\u4ef7\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailTaxPrice()) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-\u5355\u4ef7(\u542b\u7a0e)\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailMny()) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-\u91d1\u989d\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailTaxMny()) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-\u91d1\u989d(\u542b\u7a0e)\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    if (null == detail.getDetailTaxRate()) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1a\u5408\u540c\u660e\u7ec6-\u7a0e\u7387\u4e3a\u7a7a \u540c\u6b65\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)contractVO));
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    if (!brandNameMap.containsKey(detail.getBrandName())) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u54c1\u724c-[{}]\u5728\u4f9b\u5e94\u94fe\u5e73\u53f0\u65e0\u5bf9\u5e94\u6570\u636e", (Object)detail.getBrandName());
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    if (!initFlag && !planDetailMap.containsKey(detail.getMaterialSerialNo())) {
                        logger.error("\u540c\u6b65\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u7269\u8d44\u6d41\u6c34\u53f7\u4e3a\uff1a\u3010{}\u3011\u7684\u7269\u8d44\u660e\u7ec6 ", (Object)detail.getMaterialSerialNo());
                        if (!initFlag) {
                            saveFlag = false;
                            break;
                        }
                    }
                    saveDetailVo.setSourceContractId(detail.getSourceContractId());
                    saveDetailVo.setSourceDetailId(detail.getSourceDetailId());
                    saveDetailVo.setPurNum(detail.getPurNum());
                    if (brandNameMap.containsKey(detail.getBrandName())) {
                        saveDetailVo.setBrandId(brandNameMap.get(detail.getBrandName()).getId());
                    }
                    saveDetailVo.setBrandName(detail.getBrandName());
                    saveDetailVo.setDetailPrice(detail.getDetailPrice());
                    saveDetailVo.setDetailTaxPrice(detail.getDetailTaxPrice());
                    saveDetailVo.setDetailMny(detail.getDetailMny());
                    saveDetailVo.setDetailTaxMny(detail.getDetailTaxMny());
                    saveDetailVo.setDetailTaxRate(detail.getDetailTaxRate());
                    saveDetailVo.setMaterialSerialNo(detail.getMaterialSerialNo());
                    if (null != detail.getDetailTax()) {
                        saveDetailVo.setDetailTax(detail.getDetailTax());
                    } else {
                        saveDetailVo.setDetailTax(ComputeUtil.safeSub((BigDecimal)saveDetailVo.getDetailTaxMny(), (BigDecimal)saveDetailVo.getDetailMny()));
                    }
                    saveDetailVo.setDetailRemark(detail.getDetailRemark());
                    planDetailVO = (PurchasePlanDetailVO)planDetailMap.get(saveDetailVo.getMaterialSerialNo());
                    if (null != planDetailVO) {
                        saveDetailVo.setMaterialSerialNo(planDetailVO.getMaterialSerialNo());
                        saveDetailVo.setMaterialId(planDetailVO.getMaterialId());
                        saveDetailVo.setMaterialCode(planDetailVO.getMaterialCode());
                        saveDetailVo.setMaterialName(planDetailVO.getMaterialName());
                        saveDetailVo.setMaterialTypeId(planDetailVO.getMaterialTypeId());
                        saveDetailVo.setMaterialTypeName(planDetailVO.getMaterialTypeName());
                        saveDetailVo.setMaterialTypeCode(planDetailVO.getMaterialTypeCode());
                        saveDetailVo.setDetailUnitId(planDetailVO.getUnitId());
                        saveDetailVo.setDetailUnitName(planDetailVO.getUnitName());
                        saveDetailVo.setPropertyValue(planDetailVO.getPropertyValue());
                        saveDetailVo.setProductCode(planDetailVO.getProductCode());
                    }
                    saveDetailVo.setContractId(saveContractInfo.getId());
                    saveContractInfo.getDetailList().add(saveDetailVo);
                }
                if (!saveFlag) continue;
            }
            if (CollectionUtils.isNotEmpty(saveContractInfo.getDetailList())) {
                saveDetails.addAll(saveContractInfo.getDetailList());
            }
            saveList.add(saveContractInfo);
        }
        ContractEntity tmpC2 = null;
        for (ContractEntity tmpC2 : saveList) {
            if (!ContractVO.CONTRACT_TYPE_MAIN.equals(tmpC2.getContractType())) continue;
            tmpC2.setMainContractId(tmpC2.getId());
        }
        if (CollectionUtils.isNotEmpty(queryOrgIds)) {
            CommonResponse orgResp = this.iOrgApi.findAllByIds(queryOrgIds);
            if (!orgResp.isSuccess()) {
                logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01", (Object)JSONObject.toJSONString(queryOrgIds));
                throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
            }
            Map orgIdMap = ((List)orgResp.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            for (ContractEntity c : saveList) {
                if (!orgIdMap.containsKey(c.getOrgId())) continue;
                if (StringUtils.isBlank((CharSequence)c.getOrgCode())) {
                    c.setOrgCode(((OrgVO)orgIdMap.get(c.getOrgId())).getCode());
                }
                if (!StringUtils.isBlank((CharSequence)c.getParentOrgCode())) continue;
                c.setParentOrgCode(((OrgVO)orgIdMap.get(c.getParentOrgId())).getCode());
            }
        }
        logger.info("\u672c\u6b21\u66f4\u65b0\u7269\u8d44\u5408\u540c\uff1a{}\u6761", (Object)updateList.size());
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.service.saveOrUpdateBatch(updateList, updateList.size(), false);
        }
        logger.info("\u672c\u6b21\u4fdd\u5b58\u7269\u8d44\u5408\u540c\uff1a{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
            this.orderService.saveByContracts(saveList);
        }
        logger.info("\u672c\u6b21\u4fdd\u5b58\u7269\u8d44\u5408\u540c\u5b57\u8868\u6570\u636e\uff1a{}\u6761", (Object)saveDetails.size());
        if (CollectionUtils.isNotEmpty(saveDetails)) {
            this.contractDetailService.saveOrUpdateBatch(saveDetails, saveDetails.size(), false);
        }
        return saveList;
    }

    private String getProjectSid(Long projectId) {
        String cachcKey = "erp::project::" + projectId.toString();
        if (null != this.cacheManager.get(cachcKey)) {
            return (String)((Object)this.cacheManager.get(cachcKey));
        }
        CommonResponse prjResp = this.projectPoolApi.queryProjectPoolById(projectId);
        if (!prjResp.isSuccess()) {
            throw new BusinessException("\u6839\u636e\u9879\u76eeId\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        ProjectPoolSetVO vo = (ProjectPoolSetVO)((JSONArray)prjResp.getData()).getObject(0, ProjectPoolSetVO.class);
        this.cacheManager.set(cachcKey, (Serializable)((Object)vo.getSourceId()));
        return vo.getSourceId();
    }

    @PostMapping(value={"/syncZdsContracts"})
    public CommonResponse<String> syncZdsContracts(@RequestBody JSONObject params) {
        logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb,\u53c2\u6570\uff1a{}*********************", (Object)params.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        HashMap<String, String> param = new HashMap<String, String>();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getMEContractInfoInfo";
        JSONObject reqJson = null;
        boolean initFlag = null != params && null != params.get((Object)"initFlag") ? params.getBoolean("initFlag") : true;
        boolean noDate = null != params && null != params.get((Object)"noDate") ? params.getBoolean("noDate") : false;
        String supplierSid = null != params && null != params.get((Object)"supplierSid") ? params.getString("supplierSid") : null;
        Object reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != params && null != params.get((Object)"startDate")) {
            startDateStr = params.getString("startDate");
            endDateStr = params.getString("endDate");
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        } else if (!noDate) {
            startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays(new Date(), -1)) + " 00:00:00";
            endDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 23:59:59";
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        }
        if (StringUtils.isNotBlank((CharSequence)supplierSid)) {
            reqUrl = reqUrl + "?CompanyOId=" + supplierSid;
        }
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers)});
                this.handleErpPage(reqJson, initFlag);
            } else {
                logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u4fe1\u606f\u5f02\u5e38");
        }
        logger.info("*********************\u4e2d\u7535\u56db-\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u540c\u6b65\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    private void handleErpPage(JSONObject dataJson, boolean initFlag) {
        HashMap<String, ContractSyncVO> contractSourceMap = new HashMap<String, ContractSyncVO>();
        ArrayList<String> sourceIds = new ArrayList<String>();
        JSONObject tmp = null;
        Object detailJson = null;
        ContractSyncVO contract = null;
        Object detail = null;
        HashSet<String> brandNames = new HashSet<String>();
        HashSet<String> materialSerialNos = new HashSet<String>();
        ArrayList<String> projectSourceIds = new ArrayList<String>();
        ArrayList<String> empSourceIds = new ArrayList<String>();
        ArrayList<String> supplierSourceIds = new ArrayList<String>();
        ArrayList<String> supLinkerSourceIds = new ArrayList<String>();
        JSONArray contractArr = dataJson.getJSONArray("MEContractList");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u6570\u636e\uff1a{}\u6761", (Object)contractArr.size());
        for (Object obj : contractArr) {
            tmp = (JSONObject)obj;
            contract = new ContractSyncVO();
            this.prepareSyncInfo(contract, tmp);
            contract.setDeliveryDate(null);
            contract.setApplyFlag(tmp.getString("IsApply"));
            contract.setMainContractSid(tmp.getString("Contract_PrarentSid"));
            contract.setAdditionalTaxMny(BigDecimal.ZERO);
            contract.setPayMoney(BigDecimal.ZERO);
            contract.setPaymentWayCom(tmp.getString("PaymentWayCom"));
            contract.setPaymentPeriodCom(tmp.getString("PaymentPeriodCom"));
            contract.setContractType("1");
            if (StringUtils.isNotBlank((CharSequence)contract.getProjectId()) && !projectSourceIds.contains(contract.getProjectId())) {
                projectSourceIds.add(contract.getProjectId());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getSupplierId()) && !supplierSourceIds.contains(contract.getSupplierId())) {
                supplierSourceIds.add(contract.getSupplierId());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getSupplierManagerSID()) && !supLinkerSourceIds.contains(contract.getSupplierManagerSID())) {
                supLinkerSourceIds.add(contract.getSupplierManagerSID());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getMasterPorterId()) && !empSourceIds.contains(contract.getMasterPorterId())) {
                empSourceIds.add(contract.getMasterPorterId());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getErpEmployeeId()) && !empSourceIds.contains(contract.getErpEmployeeId())) {
                empSourceIds.add(contract.getErpEmployeeId());
            }
            sourceIds.add(contract.getSourceContractId());
            if (StringUtils.isNotBlank((CharSequence)contract.getMainContractSid())) {
                sourceIds.add(contract.getMainContractSid());
            }
            contractSourceMap.put(contract.getSourceContractId(), contract);
        }
        JSONArray additionContractArr = dataJson.getJSONArray("MEContractFJs");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u7269\u8d44\u5408\u540c\uff1a{}\u6761", (Object)additionContractArr.size());
        for (Object obj : additionContractArr) {
            tmp = (JSONObject)obj;
            contract = new ContractSyncVO();
            contract.setContractType("2");
            this.prepareSyncInfo(contract, tmp);
            contract.setMainContractSid(tmp.getString("MEContractInfo_FK"));
            if (StringUtils.isNotBlank((CharSequence)contract.getMainContractSid())) {
                sourceIds.add(contract.getMainContractSid());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getProjectId()) && !projectSourceIds.contains(contract.getProjectId())) {
                projectSourceIds.add(contract.getProjectId());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getSupplierId()) && !supplierSourceIds.contains(contract.getSupplierId())) {
                supplierSourceIds.add(contract.getSupplierId());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getSupplierManagerSID()) && !supLinkerSourceIds.contains(contract.getSupplierManagerSID())) {
                supLinkerSourceIds.add(contract.getSupplierManagerSID());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getMasterPorterId()) && !empSourceIds.contains(contract.getMasterPorterId())) {
                empSourceIds.add(contract.getMasterPorterId());
            }
            if (StringUtils.isNotBlank((CharSequence)contract.getErpEmployeeId()) && !empSourceIds.contains(contract.getErpEmployeeId())) {
                empSourceIds.add(contract.getErpEmployeeId());
            }
            sourceIds.add(contract.getSourceContractId());
            if (StringUtils.isNotBlank((CharSequence)contract.getMainContractSid())) {
                sourceIds.add(contract.getMainContractSid());
            }
            contractSourceMap.put(contract.getSourceContractId(), contract);
        }
        if (CollectionUtils.isEmpty(sourceIds)) {
            logger.info("\u672c\u6b21\u5f85\u5904\u7406\u7269\u8d44\u4e3b\u5408\u540c\u3001\u7269\u8d44\u9644\u52a0\u5408\u540c\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return;
        }
        JSONArray applyArr = dataJson.getJSONArray("PanyMoneyApproval");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u7269\u8d44\u5408\u540c\u53d1\u7968\u767b\u8bb0\u91d1\u989d\uff1a{}\u6761", (Object)applyArr.size());
        if (applyArr.size() > 0) {
            for (Object obj : applyArr) {
                tmp = (JSONObject)obj;
                contract = (ContractSyncVO)contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if (null == contract) continue;
                contract.setApplyFlag("\u7533\u8bf7\u4e2d".equals(tmp.getString("Status")) ? "1" : "0");
            }
        }
        JSONArray mEBillArr = dataJson.getJSONArray("MEBill");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u7269\u8d44\u5408\u540c\u53d1\u7968\u767b\u8bb0\u91d1\u989d\uff1a{}\u6761", (Object)mEBillArr.size());
        if (mEBillArr.size() > 0) {
            for (Object obj : mEBillArr) {
                tmp = (JSONObject)obj;
                contract = (ContractSyncVO)contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if (null == contract) continue;
                contract.setBillMoney(tmp.getBigDecimal("BillMoney"));
            }
        }
        JSONArray additionConMnyArr = dataJson.getJSONArray("FuJiaMoney");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u7269\u8d44\u5408\u540c\u91d1\u989d\uff1a{}\u6761", (Object)additionConMnyArr.size());
        if (additionConMnyArr.size() > 0) {
            for (Object obj : additionConMnyArr) {
                tmp = (JSONObject)obj;
                contract = (ContractSyncVO)contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if (null == contract) continue;
                contract.setAdditionalTaxMny(tmp.getBigDecimal("FuJiaMoney"));
            }
        }
        JSONArray payHisArr = dataJson.getJSONArray("PaymentHistory");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u7269\u8d44\u5408\u540c\u5df2\u5ba1\u91d1\u989d\uff1a{}\u6761", (Object)payHisArr.size());
        if (payHisArr.size() > 0) {
            for (Object obj : payHisArr) {
                tmp = (JSONObject)obj;
                contract = (ContractSyncVO)contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if (null == contract) continue;
                contract.setApprovedTaxMny(tmp.getBigDecimal("HaveApprMoney"));
                contract.setBalanceTaxMny(tmp.getBigDecimal("ContractBalanceMoney"));
            }
        }
        JSONArray panyArr = dataJson.getJSONArray("PanyMoney");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u7269\u8d44\u5408\u540c\u5df2\u4ed8\u91d1\u989d\uff1a{}\u6761", (Object)panyArr.size());
        if (panyArr.size() > 0) {
            for (Object obj : panyArr) {
                tmp = (JSONObject)obj;
                contract = (ContractSyncVO)contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if (null == contract) continue;
                contract.setAdditionalTaxMny(tmp.getBigDecimal("PayMoney"));
            }
        }
        JSONArray payStyleArr = dataJson.getJSONArray("MEPaymentStyle");
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u7269\u8d44\u5408\u540c\u5df2\u4ed8\u91d1\u989d\uff1a{}\u6761", (Object)payStyleArr.size());
        if (payStyleArr.size() > 0) {
            for (Object obj : payStyleArr) {
                tmp = (JSONObject)obj;
                contract = (ContractSyncVO)contractSourceMap.get(tmp.getString("MEContractInfo_FK"));
                if (null == contract) continue;
                contract.setPaymentStyleSid(tmp.getString("PaymentStyle_Sid"));
                contract.setPaymentStyle(tmp.getString("PaymentStyle"));
            }
        }
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u4e3b\u5408\u540c\u5b57\u8868\u6570\u91cf\uff1a{}\u6761", (Object)dataJson.getJSONArray("MEContract_SubDList").size());
        this.handSubDetail(contractSourceMap, dataJson.getJSONArray("MEContract_SubDList"), materialSerialNos, brandNames);
        logger.info("\u672c\u6b21\u5f85\u5904\u7406\u9644\u52a0\u5408\u540c\u5b57\u8868\u6570\u91cf\uff1a{}\u6761", (Object)dataJson.getJSONArray("MEContract_SubDTwoList").size());
        this.handSubDetail(contractSourceMap, dataJson.getJSONArray("MEContract_SubDTwoList"), materialSerialNos, brandNames);
        List<ContractEntity> dbEntities = this.service.getBySourceIds(sourceIds);
        ArrayList<ContractEntity> updateList = new ArrayList<ContractEntity>();
        ArrayList<Long> delContractIds = new ArrayList<Long>();
        HashMap<String, ContractEntity> dbContractMap = new HashMap<String, ContractEntity>();
        if (CollectionUtils.isNotEmpty(dbEntities)) {
            dbContractMap.putAll(dbEntities.stream().collect(Collectors.toMap(item -> item.getSourceContractId(), item -> item)));
            for (ContractEntity item2 : dbEntities) {
                ContractSyncVO con = (ContractSyncVO)contractSourceMap.get(item2.getSourceContractId());
                if (null == con) continue;
                if ("5".equals(con.getErpStatus())) {
                    delContractIds.add(item2.getId());
                    continue;
                }
                item2.setSealedFlag(con.getSealedFlag());
                item2.setApprovedTaxMny(con.getApprovedTaxMny());
                item2.setBalanceTaxMny(con.getBalanceTaxMny());
                item2.setEnableStatus(con.getEnableStatus());
                item2.setIsOfficialSeal(con.getIsOfficialSeal());
                item2.setPayMoney(con.getPayMoney());
                item2.setBillMoney(con.getBillMoney());
                item2.setPaymentStyleSid(con.getPaymentStyleSid());
                item2.setPaymentStyle(con.getPaymentStyle());
                item2.setPaymentWayCom(con.getPaymentWayCom());
                item2.setPaymentPeriodCom(con.getPaymentPeriodCom());
                item2.setContactBankAccount(con.getContactBankAccount());
                item2.setContactBank(con.getContactBank());
                item2.setPurchaseType(con.getPurchaseType());
                item2.setSupplierManagerName(con.getSupplierManagerName());
                item2.setSupplierManagerSid(con.getSupplierManagerSID());
                item2.setContractType(con.getContractType());
                item2.setApplyFlag(con.getApplyFlag());
                item2.setMainContractSid(con.getMainContractSid());
                item2.setAdditionalTaxMny(con.getAdditionalTaxMny());
                item2.setIsOfficialSeal(con.getIsOfficialSeal());
                item2.setPaymentStyleSid(con.getPaymentStyleSid());
                item2.setPaymentStyle(con.getPaymentStyle());
                item2.setPaymentWayCom(con.getPaymentWayCom());
                item2.setPaymentPeriodCom(con.getPaymentPeriodCom());
                item2.setExecutUnitSid(con.getProjectId());
                item2.setExecutUnitName(con.getProjectName());
                item2.setExecutCode(con.getProjectCode());
                item2.setSysLastUpd(con.getSysLastUpd());
                item2.setExecutUnitId(null != item2.getProjectId() ? item2.getProjectId().toString() : null);
                if (StringUtils.isBlank((CharSequence)item2.getProjectSid()) && StringUtils.isNotBlank((CharSequence)con.getProjectSid())) {
                    item2.setProjectSid(con.getProjectSid());
                }
                if (StringUtils.isBlank((CharSequence)item2.getProjectName()) && StringUtils.isNotBlank((CharSequence)con.getProjectName())) {
                    item2.setProjectName(con.getProjectName());
                }
                if (StringUtils.isBlank((CharSequence)item2.getSupplierSid()) && StringUtils.isNotBlank((CharSequence)con.getSupplierSid())) {
                    item2.setSupplierSid(con.getSupplierSid());
                }
                if (StringUtils.isBlank((CharSequence)item2.getSupplierName()) && StringUtils.isNotBlank((CharSequence)con.getSupplierName())) {
                    item2.setSupplierName(con.getSupplierName());
                }
                item2.setTaxPointName(con.getTaxPointName());
                if (null == item2.getMainContractId() && dbContractMap.containsKey(con.getMainContractSid())) {
                    item2.setMainContractId(((ContractEntity)((Object)dbContractMap.get(con.getMainContractSid()))).getId());
                }
                updateList.add(item2);
                contractSourceMap.remove(item2.getSourceContractId());
            }
            Iterator it = contractSourceMap.keySet().iterator();
            while (it.hasNext()) {
                contract = (ContractSyncVO)contractSourceMap.get(it.next());
                if (!StringUtils.isNotBlank((CharSequence)contract.getMainContractSid())) continue;
                if (dbContractMap.containsKey(contract.getMainContractSid())) {
                    contract.setMainContractId(((ContractEntity)((Object)dbContractMap.get(contract.getMainContractSid()))).getId());
                    continue;
                }
                if (contractSourceMap.containsKey(contract.getMainContractSid())) {
                    contract.setMainContractId(((ContractSyncVO)contractSourceMap.get(contract.getMainContractSid())).getId());
                    continue;
                }
                logger.error("\u91c7\u8d2d\u5408\u540c\u5bf9\u5e94\u4e3b\u5408\u540c\u3010\u5408\u540c\u4fe1\u606f-{}\u3011\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728\uff01", (Object)JSONObject.toJSONString((Object)contract, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
        }
        logger.info("\u672c\u6b21\u4f5c\u5e9f\u5df2\u5728\u5e93\u7269\u8d44\u5408\u540c\uff1a{}\u6761", (Object)delContractIds.size());
        if (CollectionUtils.isNotEmpty(delContractIds)) {
            this.service.cancelBill(delContractIds);
        }
        logger.info("brandNames:{}", (Object)JSONObject.toJSONString(brandNames));
        this.checkSyncContractInfo(new ArrayList<ContractSyncVO>(contractSourceMap.values()), updateList, empSourceIds, supplierSourceIds, projectSourceIds, supLinkerSourceIds, brandNames, materialSerialNos, initFlag);
    }

    private void handSubDetail(Map<String, ContractSyncVO> contractSourceMap, JSONArray subArr, Set<String> materialSerialNos, Set<String> brandNames) {
        JSONObject detailJson = null;
        ContractDetailSyncVO detail = null;
        ContractSyncVO contract = null;
        for (Object detailObj : subArr) {
            detailJson = (JSONObject)detailObj;
            detail = new ContractDetailSyncVO();
            contract = contractSourceMap.get(detailJson.getString("MEContractInfo_FK"));
            if (null == contract) continue;
            detail.setSourceContractId(detailJson.getString("MEContractInfo_FK"));
            detail.setSourceDetailId(detailJson.getString("C_PS_MEContractInfo_SubDOID"));
            detail.setBrandName(detailJson.getString("Brand"));
            detail.setPurNum(detailJson.getBigDecimal("PurchaseAmount"));
            detail.setDetailTaxPrice(detailJson.getBigDecimal("PurchasePrice"));
            detail.setDetailPrice(detailJson.getBigDecimal("NoTaxPointPrice"));
            detail.setDetailMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detail.getPurNum(), (BigDecimal)detail.getDetailPrice())));
            detail.setDetailTaxMny(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detail.getPurNum(), (BigDecimal)detail.getDetailTaxPrice())));
            detail.setDetailRemark(detailJson.getString("Memo"));
            detail.setDetailTax(ComputeUtil.safeSub((BigDecimal)detail.getDetailTaxMny(), (BigDecimal)detail.getDetailMny()));
            detail.setMaterialSerialNo(detailJson.getString("ListMaterialCode"));
            detail.setDetailTaxRate(contract.getRate());
            if (StringUtils.isNotBlank((CharSequence)detail.getMaterialSerialNo())) {
                materialSerialNos.add(detail.getMaterialSerialNo());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getBrandName())) {
                brandNames.add(detail.getBrandName());
            }
            detail.setContractId(contract.getId());
            contract.getDetailList().add(detail);
        }
    }

    private void prepareSyncInfo(ContractSyncVO contract, JSONObject dataJson) {
        contract.setSourceContractId(dataJson.getString("C_PS_MEContractInfoOID"));
        contract.setContractCode(dataJson.getString("contractid"));
        contract.setBillCode(dataJson.getString("Ma_Id"));
        contract.setContractName(dataJson.getString("Contract_Title"));
        contract.setProjectId(dataJson.getString("Account_Project_Sid"));
        contract.setProjectSid(dataJson.getString("Account_Project_Sid"));
        contract.setProjectName(dataJson.getString("Project_Name"));
        contract.setSupplierId(dataJson.getString("Contract_PartyB_Sid"));
        contract.setSupplierSid(dataJson.getString("Contract_PartyB_Sid"));
        contract.setSupplierName(dataJson.getString("Contract_PartyB"));
        contract.setPriceType(dataJson.getInteger("Contract_Type"));
        contract.setSignDate(dataJson.getDate("Contract_SignDate"));
        contract.setEnableStatus(dataJson.getInteger("Contract_Status"));
        contract.setRate(null != dataJson.get((Object)"TaxPoint") && StringUtils.isNotBlank((CharSequence)dataJson.getString("TaxPoint")) ? new BigDecimal(dataJson.getString("TaxPoint").replace("%", "")) : null);
        contract.setTaxMny(dataJson.getBigDecimal("Contract_Money"));
        contract.setMny(dataJson.getBigDecimal("NoTaxPointSum"));
        contract.setTax(dataJson.getBigDecimal("TaxPointSum"));
        contract.setTaxPointName(dataJson.getString("TaxPointName"));
        contract.setMasterPorterId(StringUtils.isNotBlank((CharSequence)dataJson.getString("ReceiverSid")) ? dataJson.getString("ReceiverSid").toLowerCase() : null);
        contract.setMasterPorterSid(StringUtils.isNotBlank((CharSequence)dataJson.getString("ReceiverSid")) ? dataJson.getString("ReceiverSid").toLowerCase() : null);
        contract.setMasterPorterName(dataJson.getString("Receiver"));
        contract.setLinkPhone(dataJson.getString("Receiver_Phone"));
        contract.setDeliveryAddress(dataJson.getString("DeliveryPlace"));
        contract.setDeliveryRemark(dataJson.getString("ArrivalArrangement"));
        contract.setErpEmployeeId(dataJson.getString("sys_createdby"));
        contract.setSupplierManagerName(dataJson.getString("Company_Contact"));
        contract.setSupplierManagerSID(StringUtils.isNotBlank((CharSequence)dataJson.getString("Company_ContactSid")) ? dataJson.getString("Company_ContactSid").toLowerCase() : null);
        contract.setSupplierManagerPhone(dataJson.getString("Contact_Mobile"));
        contract.setInvoiceType(dataJson.getString("BillType"));
        contract.setSealedFlag(StringUtils.isNotEmpty((CharSequence)dataJson.getString("IsOfficial_Seal")) ? ("true".equals(dataJson.getString("IsOfficial_Seal")) ? "1" : "0") : null);
        contract.setContactBankAccount(dataJson.getString("Contact_BankAccount"));
        contract.setContactBank(dataJson.getString("Contact_Bank"));
        contract.setPurchaseType(dataJson.getString("PurchaseType "));
        contract.setSysLastUpd(dataJson.getString("SYS_LAST_UPD"));
        contract.setErpStatus(dataJson.getString("status"));
        contract.setId(Long.valueOf(IdWorker.getId()));
    }

    @PostMapping(value={"/createByPlan"})
    public CommonResponse<ContractVO> createByPlan(@RequestBody JSONObject param) {
        QueryWrapper countQuery = new QueryWrapper();
        countQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        int count = this.service.count((Wrapper)countQuery);
        PurchasePlanEntity plan = (PurchasePlanEntity)((Object)this.purchasePlanService.selectById(param.getLong("planId")));
        ContractSyncVO sync = new ContractSyncVO();
        sync.setSourceContractId("MATERIAL_CONTRACT_" + (count += 10));
        sync.setContractName(plan.getPlanName() + "-\u6d4b\u8bd5\u7269\u8d44\u5408\u540c-" + count);
        sync.setBillCode("MATERIAL_CONTRACT_" + count);
        sync.setContractCode("MATERIAL_CONTRACT_" + count);
        sync.setSupplierId(StringUtils.isNotBlank((CharSequence)param.getString("supplierId")) ? param.getString("supplierId") : "SUPPLY-2022060700004");
        sync.setProjectId(plan.getProjectId().toString());
        sync.setPriceType(ZDSMaterialCommonEnums.\u603b\u4ef7\u5408\u540c.getCode());
        sync.setSignDate(new Date());
        sync.setEnableStatus(ZDSMaterialCommonEnums.ERP\u5408\u540c\u505c\u542f\u7528_\u542f\u7528.getCode());
        sync.setRate(new BigDecimal("9"));
        sync.setMasterPorterId(StringUtils.isNotBlank((CharSequence)param.getString("masterPorterId")) ? param.getString("masterPorterId") : "xz001");
        sync.setDeliveryAddress("W\u6d4b\u8bd5\u591a\u76ee\u6807\u6210\u672c\u9879\u76ee\u6d4b\u8bd5\u63a5\u8d27\u5730\u5740");
        sync.setDeliveryDate(new Date());
        sync.setSupplierManagerSID(StringUtils.isNotBlank((CharSequence)param.getString("supplierManagerSID")) ? param.getString("supplierManagerSID") : "3");
        sync.setSupplierManagerName(StringUtils.isNotBlank((CharSequence)param.getString("supplierManagerName")) ? param.getString("supplierManagerName") : "\u4f9b\u5e94\u5546\u6d4b\u8bd5\u4e13\u5458\u5218\u5cf0");
        sync.setSupplierManagerPhone(StringUtils.isNotBlank((CharSequence)param.getString("supplierManagerPhone")) ? param.getString("supplierManagerPhone") : "15589635596");
        sync.setErpEmployeeId(plan.getCreateUserSid());
        int idx = 0;
        int rate = 0;
        int taxPrice = 0;
        BigDecimal mny = BigDecimal.ZERO;
        BigDecimal taxMny = BigDecimal.ZERO;
        Random rd = new Random();
        for (PurchasePlanDetailEntity pd : plan.getDetailList()) {
            rate = rd.nextInt(15);
            taxPrice = rd.nextInt(200);
            ContractDetailSyncVO detail = new ContractDetailSyncVO();
            detail.setMaterialSerialNo(pd.getMaterialSerialNo());
            detail.setPurNum(pd.getRequirementNum());
            detail.setSourceContractId("MATERIAL_CONTRACT_" + count);
            detail.setSourceDetailId("erp-material-detail-" + count + ++idx);
            detail.setBrandName(pd.getBrandName());
            detail.setDetailTaxRate(new BigDecimal(rate + ""));
            detail.setDetailTaxPrice(new BigDecimal(taxPrice + ""));
            detail.setDetailPrice(ComputeUtil.safeSub((BigDecimal)detail.getDetailTaxPrice(), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detail.getDetailTaxPrice(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)detail.getDetailTaxRate(), (BigDecimal)new BigDecimal("100")))));
            detail.setDetailMny(ComputeUtil.safeMultiply((BigDecimal)detail.getDetailPrice(), (BigDecimal)detail.getPurNum()));
            detail.setDetailTaxMny(ComputeUtil.safeMultiply((BigDecimal)detail.getDetailTaxPrice(), (BigDecimal)detail.getPurNum()));
            detail.setBrandId(pd.getBrandId().toString());
            mny = ComputeUtil.safeAdd((BigDecimal)mny, (BigDecimal)detail.getDetailMny());
            taxMny = ComputeUtil.safeAdd((BigDecimal)taxMny, (BigDecimal)detail.getDetailTaxMny());
            detail.setDetailRemark("\u540c\u6b65\u6d4b\u8bd5\u660e\u7ec6" + count + idx);
            sync.getDetailList().add(detail);
        }
        sync.setTaxMny(taxMny);
        sync.setMny(mny);
        sync.setTax(ComputeUtil.safeSub((BigDecimal)taxMny, (BigDecimal)mny));
        return this.syncContract(sync);
    }

    public CommonResponse<ContractVO> syncContract(@RequestBody ContractSyncVO contractVO) {
        Object resp = null;
        logger.info("****** \u63a5\u6536\u5230\u540c\u6b65\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        if (StringUtils.isBlank((CharSequence)contractVO.getSourceContractId())) {
            return CommonResponse.error((String)"\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\uff1aERP\u7cfb\u7edf\u5408\u540c\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        ContractVO saveContractInfo = this.service.getOneBySourceContractId(contractVO.getSourceContractId());
        ArrayList<String> empSourceIds = new ArrayList<String>();
        ArrayList<String> supSourceIds = new ArrayList<String>();
        ArrayList<String> prjSourceIds = new ArrayList<String>();
        ArrayList<String> supLinkerSourceIds = new ArrayList<String>();
        HashSet<String> brandNames = new HashSet<String>();
        HashSet<String> serialNos = new HashSet<String>();
        supSourceIds.add(contractVO.getSupplierId());
        if (StringUtils.isNotBlank((CharSequence)contractVO.getMasterPorterId())) {
            empSourceIds.add(contractVO.getMasterPorterId());
        }
        if (StringUtils.isNotBlank((CharSequence)contractVO.getErpEmployeeId())) {
            empSourceIds.add(contractVO.getErpEmployeeId());
        }
        if (StringUtils.isNotBlank((CharSequence)contractVO.getProjectId())) {
            prjSourceIds.add(contractVO.getProjectId());
        }
        if (StringUtils.isNotBlank((CharSequence)contractVO.getSupplierId())) {
            prjSourceIds.add(contractVO.getSupplierId());
        }
        if (StringUtils.isNotBlank((CharSequence)contractVO.getSupplierManagerSID())) {
            supLinkerSourceIds.add(contractVO.getSupplierManagerSID());
        }
        contractVO.getDetailList().stream().forEach(detail -> {
            if (StringUtils.isNotBlank((CharSequence)detail.getMaterialSerialNo())) {
                serialNos.add(detail.getMaterialSerialNo());
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getBrandName())) {
                brandNames.add(detail.getBrandName());
            }
        });
        if (null == saveContractInfo) {
            saveContractInfo = new ContractVO();
        }
        ArrayList<ContractSyncVO> s = new ArrayList<ContractSyncVO>();
        s.add(contractVO);
        List<ContractEntity> contracts = this.checkSyncContractInfo(s, new ArrayList<ContractEntity>(), empSourceIds, supSourceIds, prjSourceIds, supLinkerSourceIds, brandNames, serialNos, false);
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01", null);
    }

    @RequestMapping(value={"/tobeSignedNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Integer> tobeSignedNum(@RequestParam(value="supplierTenantId") Long supplierTenantId, @RequestParam(value="supplierManagerSupId") Long supplierManagerSupId, @RequestParam(value="status") String status) {
        QueryWrapper queryWrapper = new QueryWrapper();
        MatLinkerVO linker = this.getLlinkerInfo(supplierManagerSupId, supplierTenantId);
        if (null == linker) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)0);
        }
        queryWrapper.eq((Object)"supplier_id", (Object)linker.getSupplierId());
        queryWrapper.and(q -> (QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"supplier_manager_sup_id", (Object)linker.getId())).or()).eq((Object)"supplier_manager_sid", (Object)linker.getThirdSourceId()));
        if (null != status) {
            queryWrapper.eq((Object)"sealed_flag", (Object)status);
        }
        int count = this.service.count((Wrapper)queryWrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)count);
    }

    @RequestMapping(value={"/signAContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> signAContract(@RequestParam(value="supplierManagerSupId") Long supplierManagerSupId, @RequestParam(value="supTenant") Long supTenant) {
        JSONObject jsonObject = new JSONObject();
        MatLinkerVO linker = this.getLlinkerInfo(supplierManagerSupId, supTenant);
        jsonObject.put("performanceNum", (Object)(null != linker ? this.service.performanceNum(linker.getId(), linker.getThirdSourceId()) : 0));
        jsonObject.put("finishedNum", (Object)(null != linker ? this.service.finishedNum(linker.getId(), linker.getThirdSourceId()) : 0));
        jsonObject.put("thisYearApplyMny", (Object)(null != linker ? this.matFeeApplyService.thisYearApplyMny(linker.getId(), linker.getThirdSourceId()) : Integer.valueOf(0)));
        jsonObject.put("thisYearContractMny", (Object)(null != linker ? this.service.thisYearContractMny(linker.getId(), linker.getThirdSourceId()) : Integer.valueOf(0)));
        jsonObject.put("contractIds", null != linker ? this.service.thisYearContract(linker.getId(), linker.getThirdSourceId()) : Integer.valueOf(0));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)jsonObject);
    }

    private MatLinkerVO getLlinkerInfo(Long supplierManagerSupId, Long supTenant) {
        CommonResponse linkerResp = this.matLinkerApi.getSupUserIdAndTenant(supplierManagerSupId, supTenant);
        if (!linkerResp.isSuccess() || null == linkerResp.getData()) {
            logger.error("\u6839\u636e\u7269\u8d44\u8054\u7cfb\u4eba\u4f9b\u65b9\u7528\u6237Id-{},\u4f9b\u65b9\u79df\u6237Id-{}\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25,{}", new Object[]{supplierManagerSupId, supTenant, JSONObject.toJSONString((Object)linkerResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
            return null;
        }
        return (MatLinkerVO)linkerResp.getData();
    }

    @RequestMapping(value={"/performanceContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> performanceContract(@RequestParam(value="supplierTenantId") Long supplierTenantId, @RequestParam(value="supplierManagerSupId") Long supplierManagerSupId, @RequestParam(value="pageNumber") Integer pageNumber, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="status", required=false, defaultValue="1") Integer status, @RequestParam(value="isOrder", required=false) Integer isOrder, @RequestParam(required=false) String projectCode, @RequestParam(required=false) String projectName, @RequestParam(required=false) String projectManagerName, @RequestParam(required=false) String contractCreatorName, @RequestParam(required=false) String contractName) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setPageIndex(pageNumber.intValue());
        Long supplierId = null;
        String supplierLinkerSid = null;
        if (null != supplierTenantId && null != supplierManagerSupId) {
            MatLinkerVO linker = this.getLlinkerInfo(supplierManagerSupId, supplierTenantId);
            if (null == linker) {
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
            }
            supplierId = linker.getSupplierId();
            supplierLinkerSid = linker.getThirdSourceId();
        }
        if (null == supplierId && null != supplierTenantId) {
            CommonResponse supplierResp = this.supplierApi.getByTenantId(Long.valueOf(supplierTenantId));
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u79df\u6237Id-{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25:{}\uff01", (Object)supplierTenantId, (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
            }
            supplierId = ((MatSupplierVO)supplierResp.getData()).getId();
        }
        if (null == supplierId && StringUtils.isBlank(supplierLinkerSid)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u6216\u8054\u7cfb\u4eba\u4fe1\u606f");
        }
        if (null != supplierId) {
            queryParam.getParams().put("supplier_id", new Parameter("eq", (Object)supplierId));
        }
        if (StringUtils.isNotBlank(supplierLinkerSid)) {
            queryParam.getParams().put("supplier_manager_sid", new Parameter("eq", (Object)supplierLinkerSid));
        }
        if (StringUtils.isNotBlank((CharSequence)projectCode)) {
            queryParam.getParams().put("projectCode", new Parameter("like", (Object)projectCode));
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            queryParam.getParams().put("projectName", new Parameter("like", (Object)projectName));
        }
        if (StringUtils.isNotBlank((CharSequence)projectManagerName)) {
            queryParam.getParams().put("projectManagementName", new Parameter("like", (Object)projectManagerName));
        }
        if (StringUtils.isNotBlank((CharSequence)contractCreatorName)) {
            queryParam.getParams().put("employeeName", new Parameter("like", (Object)contractCreatorName));
        }
        if (StringUtils.isNotBlank((CharSequence)contractName)) {
            queryParam.getParams().put("contractName", new Parameter("like", (Object)contractName));
        }
        if (null != status) {
            queryParam.getParams().put("sealed_flag", new Parameter("eq", (Object)status));
        }
        if (null != isOrder && isOrder == 3) {
            queryParam.getParams().put("contract_type", new Parameter("eq", (Object)"3"));
        } else if (null != isOrder && isOrder == 2) {
            queryParam.getParams().put("contract_type", new Parameter("in", Arrays.asList(1, 2)));
        }
        queryParam.getOrderMap().put("sign_date", "desc");
        IPage page = this.service.queryPage(queryParam);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"syncSupplierContracts"})
    public CommonResponse<String> syncSupplierContracts(@RequestBody Long supTenant) {
        CommonResponse supplierResp = this.supplierApi.getByTenantId(Long.valueOf(supTenant));
        if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
            logger.error("\u6839\u636e\u4f9b\u5e94\u5546\u79df\u6237Id-{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25:{}\uff01", (Object)supTenant, (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff01");
        }
        JSONObject params = new JSONObject();
        params.put("supplierSid", (Object)((MatSupplierVO)supplierResp.getData()).getThirdSourceId());
        params.put("noDate", (Object)true);
        return this.syncZdsContracts(params);
    }

    @RequestMapping(value={"/refContractBill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractBill(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject, @RequestParam(required=false) String searchText, @RequestParam(required=false) String tenantId) {
        MatSupplierVO shareSupplierVO;
        QueryParam param = new QueryParam();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25");
        }
        CommonResponse listCommonResponse = this.supplierApi.getByTenantId(Long.valueOf(tenantId));
        if (listCommonResponse.isSuccess() && null != (shareSupplierVO = (MatSupplierVO)listCommonResponse.getData())) {
            param.getParams().put("supplierId", new Parameter("eq", (Object)shareSupplierVO.getId()));
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"projectId"))));
            }
            if (_con.containsKey((Object)"contractTypes")) {
                param.getParams().put("contractType", new Parameter("in", (Object)Lists.newArrayList((Object[])_con.getString("contractTypes").split(","))));
            }
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("", new Parameter("sql", (Object)("(main_contract_id = " + _con.get((Object)"contractId") + " or id =" + _con.get((Object)"contractId") + ")")));
            }
            if (_con.containsKey((Object)"supplierManagerSupId")) {
                Long supplierManagerSupId = _con.getLong("supplierManagerSupId");
                CommonResponse supUserIdAndTenant = this.matLinkerApi.getSupUserIdAndTenant(supplierManagerSupId, Long.valueOf(tenantId));
                logger.error(JSONObject.toJSONString((Object)supUserIdAndTenant));
                if (supUserIdAndTenant.isSuccess()) {
                    param.getParams().put("supplierManagerId", new Parameter("eq", (Object)((MatLinkerVO)supUserIdAndTenant.getData()).getId()));
                } else {
                    throw new BusinessException("\u67e5\u8be2\u5408\u540c\u5217\u8868\u5931\u8d25\uff0c\u83b7\u53d6\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25");
                }
            }
            if (_con.containsKey((Object)"sealedFlag")) {
                param.getParams().put("sealed_flag", new Parameter("eq", (Object)String.valueOf(_con.get((Object)"sealedFlag"))));
            } else {
                param.getParams().put("sealed_flag", new Parameter("eq", (Object)"1"));
            }
        }
        param.getOrderMap().put("create_time", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List contractVOS = BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class);
        Set orgIds = contractVOS.stream().map(ContractVO::getParentOrgId).collect(Collectors.toSet());
        CommonResponse orgResp = this.iOrgApi.findAllByIds(new ArrayList(orgIds));
        if (!orgResp.isSuccess() || null == orgResp.getData()) {
            logger.error("\u6839\u636e\u7ec4\u7ec7id\u5217\u8868-{}\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString(orgIds), (Object)JSONObject.toJSONString((Object)orgResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap<Long, Long> secondOrgIdMap = new HashMap<Long, Long>();
        String[] tmpOrgIdArr = null;
        for (OrgVO org : (List)orgResp.getData()) {
            tmpOrgIdArr = org.getInnerCode().split("\\|");
            secondOrgIdMap.put(org.getId(), tmpOrgIdArr.length > 2 ? Long.valueOf(tmpOrgIdArr[1]) : Long.valueOf(tmpOrgIdArr[tmpOrgIdArr.length - 1]));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(MatCheckerSettingEntity::getOrgId, secondOrgIdMap.keySet());
        List list = this.matCheckerSettingService.list((Wrapper)queryWrapper);
        HashMap checkIdsByOrgMap = new HashMap();
        HashMap checkNamesByOrgMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List tmpList = null;
            Map checkMapByOrg = list.stream().collect(Collectors.groupingBy(MatCheckerSettingEntity::getOrgId, Collectors.toList()));
            for (Long orgId : checkMapByOrg.keySet()) {
                tmpList = checkMapByOrg.get(orgId);
                if (!CollectionUtils.isNotEmpty(tmpList)) continue;
                checkIdsByOrgMap.put(secondOrgIdMap.get(orgId), tmpList.stream().map(item -> item.getEmployeeId().toString()).collect(Collectors.joining(",")));
                checkNamesByOrgMap.put(secondOrgIdMap.get(orgId), tmpList.stream().map(item -> item.getEmployeeName()).collect(Collectors.joining(",")));
            }
        }
        logger.info("\u5408\u540c\u4e8c\u7ea7\u5355\u4f4d\u7ec4\u7ec7\u6620\u5c04\uff1a{}", (Object)JSONObject.toJSONString(secondOrgIdMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        logger.info("\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(checkIdsByOrgMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        contractVOS.stream().forEach(contractVO -> {
            contractVO.setSystemId(((String)ejcCloudSystemCode.getData()).toString());
            switch (contractVO.getContractType()) {
                case "1": {
                    contractVO.setContractTypeName("\u4e3b\u5408\u540c");
                    break;
                }
                case "2": {
                    contractVO.setContractTypeName("\u9644\u52a0\u5408\u540c");
                    break;
                }
                case "3": {
                    contractVO.setContractTypeName("\u8ba2\u5355");
                }
            }
            contractVO.setPriceTypeName(contractVO.getPriceType() == 1 ? "\u5355\u4ef7\u5408\u540c" : "\u603b\u4ef7\u5408\u540c");
            if (secondOrgIdMap.containsKey(contractVO.getParentOrgId()) && checkIdsByOrgMap.containsKey(secondOrgIdMap.get(contractVO.getParentOrgId()))) {
                contractVO.setCheckIds((String)checkIdsByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
                contractVO.setCheckNames((String)checkNamesByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
            }
        });
        pageData.setRecords(contractVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ZDSInterfaceCommonUtil.getErpHeaders("b6a70a2af8ea494fbda7c9ae118500ea", "11658934fd26400985e1e9d83f6ac7cf"));
    }
}

