/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpInvoiceVO;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"erpInvoice"})
public class ErpInvoiceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IErpInvoiceService service;
    @Autowired
    private IErpInvoiceDetailService detailService;
    private final String INVOICE_ERP_REQ_URL = "/cefoc/yql/getMEBillList";
    private final String MAT_INVOICE_QUOTE_URL = "/cefoc/yql/getMEBillSubList";
    private final String SUB_INVOICE_QUOTE_URL = "/cefoc/yql/getSubBillSubList";

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ErpInvoiceVO> queryDetail(Long id) {
        ErpInvoiceEntity entity = (ErpInvoiceEntity)((Object)this.service.selectById(id));
        ErpInvoiceVO vo = (ErpInvoiceVO)BeanMapper.map((Object)((Object)entity), ErpInvoiceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ErpInvoiceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("number");
        fuzzyFields.add("saleTaxNumber");
        fuzzyFields.add("saleName");
        fuzzyFields.add("invoiceTitle");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("usedFlag")) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("AND");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("OR");
            c2.getParams().put("quoteFlag", new Parameter("eq", ((Parameter)param.getParams().get("usedFlag")).getValue()));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("OR");
            c2.getParams().put("erpQuoteFlag", new Parameter("eq", ((Parameter)param.getParams().get("usedFlag")).getValue()));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);
            param.getParams().remove("usedFlag");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ErpInvoiceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("number");
        fuzzyFields.add("saleTaxNumber");
        fuzzyFields.add("saleName");
        fuzzyFields.add("invoiceTitle");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("usedFlag")) {
            ComplexParam c1 = new ComplexParam();
            c1.setLogic("AND");
            ComplexParam c2 = new ComplexParam();
            c2.setLogic("OR");
            c2.getParams().put("quoteFlag", new Parameter("eq", ((Parameter)param.getParams().get("usedFlag")).getValue()));
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("OR");
            c2.getParams().put("erpQuoteFlag", new Parameter("eq", ((Parameter)param.getParams().get("usedFlag")).getValue()));
            c1.getComplexParams().add(c2);
            c1.getComplexParams().add(c3);
            param.getComplexParams().add(c1);
            param.getParams().remove("usedFlag");
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ErpInvoice-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refErpInvoiceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ErpInvoiceVO>> refErpInvoiceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        this.logger.error("refErpInvoiceData condition " + condition);
        this.logger.error("refErpInvoiceData searchText " + searchText);
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("statusName");
        param.getFuzzyFields().add("typeName");
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("number");
        param.getFuzzyFields().add("saleTaxNumber");
        param.getFuzzyFields().add("saleName");
        param.getFuzzyFields().add("invoiceTitle");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject searchJson = JSONObject.parseObject((String)searchObject);
            if (searchJson.containsKey((Object)"usedFlag")) {
                if ("1".equals(searchJson.get((Object)"usedFlag"))) {
                    param.getParams().put("quoteFlag", new Parameter("sql", (Object)" (quote_flag = '1' or erp_quote_flag = '1')"));
                } else {
                    param.getParams().put("quoteFlag", new Parameter("sql", (Object)" (quote_flag = '0' or erp_quote_flag = '0')"));
                }
                searchJson.remove((Object)"usedFlag");
            }
            if (!searchJson.isEmpty()) {
                param.setSearchObject(JSONObject.toJSONString((Object)searchJson));
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (StringUtils.isNotBlank((CharSequence)_con.getString("saleName"))) {
                param.getParams().put("saleName", new Parameter("eq", (Object)_con.getString("saleName")));
            }
            if (StringUtils.isNotBlank((CharSequence)_con.getString("number"))) {
                param.getParams().put("number", new Parameter("eq", (Object)_con.getString("number")));
            }
            if (_con.containsKey((Object)"usedFlag")) {
                if ("1".equals(_con.get((Object)"usedFlag"))) {
                    param.getParams().put("quoteFlag", new Parameter("sql", (Object)" (quote_flag = '1' or erp_quote_flag = '1')"));
                } else {
                    param.getParams().put("quoteFlag", new Parameter("sql", (Object)" (quote_flag = '0' or erp_quote_flag = '0')"));
                }
                param.getParams().remove("usedFlag");
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ErpInvoiceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/zdsInvoiceSync"})
    public CommonResponse<String> zdsInvoiceSync(@RequestBody JSONObject reqParam) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u9886\u822a\u53d1\u7968\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = null != reqParam.get((Object)"pageNum") ? reqParam.getInteger("pageNum") : 0;
        Integer pageSize = null != reqParam.get((Object)"pageSize") ? reqParam.getInteger("pageSize") : Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        JSONObject param = new JSONObject();
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getMEBillList";
        boolean hasNext = true;
        Map<String, String> headers = null;
        Integer reqErrorTimes = null != reqParam.get((Object)"reqErrorTimes") ? reqParam.getInteger("reqErrorTimes") : 0;
        reqParam.remove((Object)"reqErrorTimes");
        Object reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != reqParam.get((Object)"startDate")) {
            startDateStr = reqParam.getString("startDate");
            endDateStr = reqParam.getString("endDate");
        } else {
            startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays(new Date(), -2)) + " 00:00:00";
            endDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 23:59:59";
        }
        param.put("BeginDateTime", (Object)startDateStr);
        param.put("EndDateTime", (Object)endDateStr);
        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", (Object)pageSize);
            JSONObject reqJson = null;
            Object pageData = null;
            pageNum = pageNum + 1;
            param.put("PageNum", (Object)pageNum);
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString((Object)param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            reqErrorTimes = 0;
            this.logger.info("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u9886\u822a\u53d1\u7968\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.info("\u4e2d\u7535\u56db\u9886\u822a\u53d1\u7968\u540c\u6b65,\u8bf7\u6c42\u6210\u529f\uff0c\u5171{}\u6761\u6570\u636e", (Object)reqJson.getString("allCount"));
                this.handleErpPageData(reqJson);
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u9886\u822a\u53d1\u7968\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u9886\u822a\u53d1\u7968\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            Integer pageData = reqErrorTimes;
            Integer n = reqErrorTimes = Integer.valueOf(reqErrorTimes + 1);
            if (reqErrorTimes >= 3) {
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u9886\u822a\u53d1\u7968\u4fe1\u606f\u5f02\u5e38");
            }
            try {
                this.logger.info("\u540c\u6b65\u4e2d\u7535\u56db\u9886\u822a\u53d1\u7968\u5f02\u5e38\uff0c5s\u540e\u91cd\u8bd5.........,\u5f53\u524d\u5df2\u540c\u6b65{}\u6570\u636e", (Object)(param.getInteger("PageNum") - 1));
                Thread.sleep(5000L);
                param.put("pageSize", (Object)param.getInteger("PageSize"));
                param.put("pageNum", (Object)(param.getInteger("PageNum") - 1));
                param.put("reqErrorTimes", (Object)reqErrorTimes);
                return this.zdsInvoiceSync(param);
            }
            catch (Exception e1) {
                this.logger.error("\u91cd\u542f\u4e2d\u7535\u56db\u9886\u822a\u53d1\u7968\u540c\u6b65\u63a5\u53e3\u5f02\u5e38,", (Throwable)e1);
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u9886\u822a\u53d1\u7968\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u9886\u822a\u53d1\u7968\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u9886\u822a\u53d1\u7968\u540c\u6b65\u5b8c\u6210\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleErpPageData(JSONObject dataJson) {
        List<ErpInvoiceEntity> dbListByNum;
        List<ErpInvoiceEntity> dbListBySourceId;
        JSONObject tmp = null;
        JSONObject detailTmp = null;
        ErpInvoiceEntity tmpEntity = null;
        ErpInvoiceDetailEntity tmpDetailEntity = null;
        HashMap<String, ErpInvoiceEntity> dataMap = new HashMap<String, ErpInvoiceEntity>();
        ArrayList<ErpInvoiceEntity> saveList = new ArrayList<ErpInvoiceEntity>();
        ArrayList<ErpInvoiceDetailEntity> saveDetailList = new ArrayList<ErpInvoiceDetailEntity>();
        JSONArray pageData = dataJson.getJSONArray("MEBillList");
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u53d1\u7968\u4e3b\u8868\u6570\u636e\uff1a{}\u6761", (Object)pageData.size());
        if (pageData.size() == 0) {
            this.logger.info("\u672c\u6b21\u5f85\u5904\u7406\u53d1\u7968\u4e3b\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return;
        }
        ArrayList<String> invoiceNumList = new ArrayList<String>();
        HashMap<String, String> numSourceMap = new HashMap<String, String>();
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            tmpEntity = new ErpInvoiceEntity();
            tmpEntity.setSourceId(tmp.getString("C_PS_InvoiceInfoOID"));
            tmpEntity.setTypeCode(tmp.getString("FPZLDM"));
            tmpEntity.setTypeName(tmp.getString("FPZLDM_Value"));
            tmpEntity.setStatusCode(tmp.getString("FPZTDM"));
            tmpEntity.setStatusName(tmp.getString("FPZTDM_Value"));
            tmpEntity.setCode(tmp.getString("FPDM"));
            tmpEntity.setNumber(tmp.getString("FPHM"));
            tmpEntity.setMny(tmp.getBigDecimal("JE"));
            tmpEntity.setSaleName(tmp.getString("XFMC"));
            tmpEntity.setSaleTaxNumber(tmp.getString("XFSBH"));
            tmpEntity.setMemo(tmp.getString("BZ"));
            tmpEntity.setInvoiceTitle(tmp.getString("GFMC"));
            tmpEntity.setId(IdWorker.getId());
            tmpEntity.setErpQuoteFlag("0");
            tmpEntity.setQuoteFlag("0");
            try {
                if (StringUtils.isNotBlank((CharSequence)tmp.getString("KPRQ"))) {
                    tmpEntity.setInvoiceDate(DateFormatUtil.parseDate((String)"yyyy-MM-dd HH:mm:ss", (String)tmp.getString("KPRQ").replace("T", " ")));
                }
            }
            catch (Exception e) {
                this.logger.info("\u683c\u5f0f\u5316\u4e2d\u7535\u56db\u53d1\u7968\u65f6\u95f4\u51fa\u9519\uff01{}", (Object)tmp.toJSONString(), (Object)e);
            }
            if (StringUtils.isNotBlank((CharSequence)tmpEntity.getNumber()) && !invoiceNumList.contains(tmpEntity.getNumber())) {
                invoiceNumList.add(tmpEntity.getNumber());
            }
            numSourceMap.put(tmpEntity.getNumber(), tmpEntity.getSourceId());
            dataMap.put(tmpEntity.getSourceId(), tmpEntity);
        }
        JSONArray detailArray = dataJson.getJSONArray("InvoiceGoodsList");
        if (null != detailArray && detailArray.size() > 0) {
            for (Object detailObj : detailArray) {
                detailTmp = (JSONObject)detailObj;
                tmpEntity = (ErpInvoiceEntity)((Object)dataMap.get(detailTmp.getString("C_PS_InvoiceInfo_FK")));
                if (null == tmpEntity) continue;
                tmpDetailEntity = new ErpInvoiceDetailEntity();
                tmpDetailEntity.setPid(tmpEntity.getId());
                tmpDetailEntity.setInvoiceSid(detailTmp.getString("C_PS_InvoiceInfo_FK"));
                tmpDetailEntity.setDetailName(detailTmp.getString("SPMC"));
                tmpDetailEntity.setDetailSpec(detailTmp.getString("GGXH"));
                tmpDetailEntity.setDetailUnitName(detailTmp.getString("JLDW"));
                tmpDetailEntity.setDetailNum(detailTmp.getBigDecimal("SL"));
                tmpDetailEntity.setDetailMny(detailTmp.getBigDecimal("SPJE"));
                tmpDetailEntity.setDetailTax(detailTmp.getBigDecimal("SPSE"));
                tmpDetailEntity.setDetailRate(detailTmp.getBigDecimal("SLV"));
                tmpDetailEntity.setInvoiceMny(detailTmp.getBigDecimal("FPJE"));
                tmpEntity.getDetailList().add(tmpDetailEntity);
            }
        }
        if (CollectionUtils.isNotEmpty(dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(dataMap.keySet())))) {
            for (ErpInvoiceEntity erpInvoiceEntity : dbListBySourceId) {
                tmpEntity = (ErpInvoiceEntity)((Object)dataMap.get(erpInvoiceEntity.getSourceId()));
                erpInvoiceEntity.setStatusCode(tmpEntity.getStatusCode());
                erpInvoiceEntity.setStatusName(tmpEntity.getStatusName());
                erpInvoiceEntity.setInvoiceDate(tmpEntity.getInvoiceDate());
                dataMap.remove(tmpEntity.getSourceId());
                saveList.add(erpInvoiceEntity);
                if (!invoiceNumList.contains(erpInvoiceEntity.getNumber())) continue;
                invoiceNumList.remove(erpInvoiceEntity.getNumber());
            }
        }
        if (CollectionUtils.isNotEmpty(invoiceNumList) && CollectionUtils.isNotEmpty(dbListByNum = this.service.getAllByInvoiceNums(invoiceNumList))) {
            for (ErpInvoiceEntity dbEntity : dbListByNum) {
                tmpEntity = (ErpInvoiceEntity)((Object)dataMap.get(numSourceMap.get(dbEntity.getNumber())));
                if (StringUtils.isBlank((CharSequence)dbEntity.getSourceId()) && CollectionUtils.isNotEmpty(tmpEntity.getDetailList())) {
                    tmpEntity.getDetailList().forEach(detail -> detail.setPid(dbEntity.getId()));
                    saveDetailList.addAll(tmpEntity.getDetailList());
                }
                dbEntity.setInvoiceDate(tmpEntity.getInvoiceDate());
                dbEntity.setSourceId(tmpEntity.getSourceId());
                dbEntity.setTypeCode(tmpEntity.getTypeCode());
                dbEntity.setTypeName(tmpEntity.getTypeName());
                dbEntity.setStatusCode(tmpEntity.getStatusCode());
                dbEntity.setStatusName(tmpEntity.getStatusName());
                dbEntity.setCode(tmpEntity.getCode());
                dbEntity.setNumber(tmpEntity.getNumber());
                dbEntity.setMny(tmpEntity.getMny());
                dbEntity.setSaleName(tmpEntity.getSaleName());
                dbEntity.setSaleTaxNumber(tmpEntity.getSaleTaxNumber());
                dbEntity.setMemo(tmpEntity.getMemo());
                dbEntity.setInvoiceTitle(tmpEntity.getInvoiceTitle());
                dbEntity.setQuoteFlag("1");
                dataMap.remove(tmpEntity.getSourceId());
                saveList.add(dbEntity);
            }
        }
        if (!dataMap.isEmpty()) {
            for (ErpInvoiceEntity erpInvoiceEntity : dataMap.values()) {
                saveList.add(erpInvoiceEntity);
                saveDetailList.addAll(erpInvoiceEntity.getDetailList());
            }
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u53d1\u7968\u4e3b\u8868\u6570\u636e-{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u53d1\u7968\u5b50\u8868\u6570\u636e-{}\u6761", (Object)saveDetailList.size());
        if (CollectionUtils.isNotEmpty(saveDetailList)) {
            this.detailService.saveOrUpdateBatch(saveDetailList, saveDetailList.size(), false);
        }
    }

    @GetMapping(value={"syncMatUsedInvoice"})
    public CommonResponse<String> syncMatUsedInvoice(@RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, @RequestParam(required=false) Integer pageSize, @RequestParam(required=false) Integer pageNum) {
        return this.syncUsedInvoice(beginDate, endDate, pageSize, pageNum, "/cefoc/yql/getMEBillSubList", 0);
    }

    @GetMapping(value={"syncSubUsedInvoice"})
    public CommonResponse<String> syncSubUsedInvoice(@RequestParam(required=false) String beginDate, @RequestParam(required=false) String endDate, @RequestParam(required=false) Integer pageSize, @RequestParam(required=false) Integer pageNum) {
        return this.syncUsedInvoice(beginDate, endDate, pageSize, pageNum, "/cefoc/yql/getSubBillSubList", 0);
    }

    private CommonResponse<String> syncUsedInvoice(String beginDate, String endDate, Integer pageSize, Integer pageNum, String reqUrl, Integer reqErrorTimes) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        String url = ZDSInterfaceCommonUtil.getErpReqHost() + reqUrl;
        Map<String, String> headers = null;
        JSONObject param = new JSONObject();
        param.put("BeginDateTime", (Object)(StringUtils.isNotBlank((CharSequence)beginDate) ? beginDate : DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays(new Date(), -1)) + " 00:00:00"));
        param.put("EndDateTime", (Object)(StringUtils.isNotBlank((CharSequence)endDate) ? endDate : DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 23:59:59"));
        Integer PageSize = null != pageSize ? pageSize : 100;
        Integer PageNum = null != pageNum ? pageNum : 1;
        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", (Object)PageSize);
            JSONObject reqJson = null;
            param.put("PageNum", (Object)PageNum);
            String reqResp = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString((Object)param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            reqErrorTimes = 0;
            if ("ok".equals(reqJson.getString("status"))) {
                this.logger.info("\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u540c\u6b65\u4efb\u52a1\u540c\u6b65,\u8bf7\u6c42\u6210\u529f\uff0c\u5171{}\u6761\u6570\u636e", (Object)reqJson.getString("allCount"));
                this.handleErpUsedInvoiceData(reqJson);
            } else {
                this.logger.error("\u8bf7\u6c42\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{url, JSONObject.toJSONString((Object)param), JSONObject.toJSONString(headers), reqResp});
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{url, JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            Integer reqResp = reqErrorTimes;
            Integer n = reqErrorTimes = Integer.valueOf(reqErrorTimes + 1);
            if (reqErrorTimes >= 3) {
                return CommonResponse.error((String)"\u540c\u6b65\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u5f02\u5e38");
            }
            try {
                this.logger.info("\u540c\u6b65\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u5f02\u5e38\uff0c5s\u540e\u91cd\u8bd5.........,\u5f53\u524d\u5df2\u540c\u6b65{}\u6570\u636e", (Object)(param.getInteger("PageNum") - 1));
                Thread.sleep(5000L);
                param.put("reqErrorTimes", (Object)reqErrorTimes);
                return this.syncUsedInvoice(beginDate, endDate, pageSize, pageNum, reqUrl, reqErrorTimes);
            }
            catch (Exception e1) {
                this.logger.error("\u91cd\u542f\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u540c\u6b65\u63a5\u53e3\u5f02\u5e38,", (Throwable)e1);
                return CommonResponse.error((String)"\u540c\u6b65\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u5f15\u7528\u53d1\u7968\u4fe1\u606f\u540c\u6b65\u6210\u529f\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleErpUsedInvoiceData(JSONObject dataJson) {
        JSONObject tmp = null;
        JSONArray pageData = dataJson.getJSONArray("data");
        ArrayList<ErpInvoiceEntity> updateList = new ArrayList<ErpInvoiceEntity>();
        ArrayList<ErpInvoiceEntity> saveList = new ArrayList<ErpInvoiceEntity>();
        this.logger.info("\u672c\u6b21\u5f85\u5904\u7406ERP\u5f15\u7528\u53d1\u7968\u4e3b\u8868\u6570\u636e\uff1a{}\u6761", (Object)pageData.size());
        if (pageData.size() == 0) {
            this.logger.info("\u672c\u6b21\u5f85\u5904\u7406ERP\u5f15\u7528\u53d1\u7968\u4e3b\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return;
        }
        HashMap<String, JSONObject> invoiceMap = new HashMap<String, JSONObject>();
        for (Object obj : pageData) {
            tmp = (JSONObject)obj;
            invoiceMap.put(tmp.getString("InvoiceHM"), tmp);
        }
        ErpInvoiceEntity tmpInvoice = null;
        if (!invoiceMap.isEmpty()) {
            List<ErpInvoiceEntity> dbInvoiceList = this.service.getAllByInvoiceNums(new ArrayList<String>(invoiceMap.keySet()));
            for (ErpInvoiceEntity dbItem : dbInvoiceList) {
                tmp = (JSONObject)invoiceMap.get(dbItem.getNumber());
                if (null == tmp) continue;
                dbItem.setErpQuoteFlag("1");
                dbItem.setGoodsName(tmp.getString("GoodsName"));
                dbItem.setErpCreateTime(tmp.getString("SYS_Created"));
                dbItem.setErpRegisterName(tmp.getString("Register_Name"));
                dbItem.setErpQuoteBillCode(tmp.getString("Ma_id"));
                invoiceMap.remove(dbItem.getNumber());
                updateList.add(dbItem);
            }
        }
        if (!invoiceMap.isEmpty()) {
            for (JSONObject tmpInvoiceJson : invoiceMap.values()) {
                tmpInvoice = new ErpInvoiceEntity();
                tmpInvoice.setErpQuoteFlag("1");
                tmpInvoice.setGoodsName(tmpInvoiceJson.getString("GoodsName"));
                tmpInvoice.setErpCreateTime(tmpInvoiceJson.getString("SYS_Created"));
                tmpInvoice.setErpRegisterName(tmpInvoiceJson.getString("Register_Name"));
                tmpInvoice.setNumber(tmpInvoiceJson.getString("InvoiceHM"));
                tmpInvoice.setInvoiceTitle(tmpInvoiceJson.getString("InvoiceTT"));
                tmpInvoice.setCode(tmpInvoiceJson.getString("InvoiceDM"));
                tmpInvoice.setErpQuoteBillCode(tmpInvoiceJson.getString("Ma_id"));
                saveList.add(tmpInvoice);
            }
        }
        this.logger.info("\u672c\u6b21\u540c\u6b65\u5f15\u7528\u53d1\u7968\uff0c\u66f4\u65b0\u6570\u91cf\uff1a{}\u6761", (Object)updateList.size());
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.service.saveOrUpdateBatch(updateList, updateList.size(), false);
        }
        this.logger.info("\u672c\u6b21\u540c\u6b65\u5f15\u7528\u53d1\u7968\uff0c\u4fdd\u5b58\u6570\u91cf\uff1a{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
    }
}

