/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractVO;
import com.ejianc.business.zdssupplier.material.api.IMatLinkerApi;
import com.ejianc.business.zdssupplier.material.vo.MatLinkerVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zdscongtract/"})
public class ContractApi {
    @Autowired
    private IContractService service;
    @Autowired
    private IMatLinkerApi matLinkerApi;

    @GetMapping(value={"getContractDetail"})
    CommonResponse<ContractVO> getContractDetail(@RequestParam Long contractId) {
        ContractEntity contract = (ContractEntity)((Object)this.service.selectById(contractId));
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)contract), ContractVO.class));
    }

    @PostMapping(value={"pageContractAndOrder"})
    public CommonResponse<JSONObject> pageContractAndOrder(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        Long linkerSupUserId = params.getLong("supUserId");
        Long supTenant = params.getLong("supTenant");
        String billType = params.getString("billType");
        Integer pageSize = null != params.getInteger("pageSize") ? params.getInteger("pageSize") : 10;
        Integer pageNum = null != params.getInteger("pageNum") ? params.getInteger("pageNum") : 1;
        Long contractId = params.getLong("contractId");
        Integer startLine = (pageNum < 1 ? 0 : pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);
        resp.put("size", (Object)pageSize);
        resp.put("current", (Object)pageNum);
        if (null == linkerSupUserId) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u4f9b\u65b9\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (null == supTenant) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u4e59\u65b9\u8054\u7cfb\u4eba\u79df\u6237ID\u4e3a\u7a7a");
        }
        CommonResponse linkerResp = this.matLinkerApi.getSupUserIdAndTenant(linkerSupUserId, supTenant);
        if (!linkerResp.isSuccess() || null == linkerResp.getData()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u4e59\u65b9\u8054\u7cfb\u4eba\u4fe1\u606f\u5931\u8d25\uff01");
        }
        MatLinkerVO linker = (MatLinkerVO)linkerResp.getData();
        queryParam.put("linkerId", linker.getId());
        queryParam.put("linkerSid", linker.getThirdSourceId());
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            queryParam.put("billTypes", billType.split(","));
        }
        if (null != contractId) {
            ContractEntity contract = (ContractEntity)((Object)this.service.selectById(contractId));
            queryParam.put("contractId", contract.getId());
            queryParam.put("contractSid", contract.getSourceContractId());
            if (PlanConstant.INTEGER_YES.equals(contract.getPriceType())) {
                if (null != contract.getMainContractId()) {
                    queryParam.put("parentContractId", contract.getMainContractId());
                }
                if (StringUtils.isNotBlank((CharSequence)contract.getMainContractSid()) && !"00000000-0000-0000-0000-000000000000".equals(contract.getMainContractSid())) {
                    queryParam.put("parentContractSid", contract.getMainContractSid());
                }
            } else {
                queryParam.put("billTypes", new Integer[]{1, 2});
            }
        }
        if (StringUtils.isBlank((CharSequence)params.getString("searchText"))) {
            queryParam.put("searchText", params.getString("searchText"));
        }
        if (StringUtils.isBlank((CharSequence)params.getString("projectName"))) {
            queryParam.put("projectName", params.getString("projectName"));
        }
        if (StringUtils.isBlank((CharSequence)params.getString("billCode"))) {
            queryParam.put("billCode", params.getString("billCode"));
        }
        if (StringUtils.isBlank((CharSequence)params.getString("contractName"))) {
            queryParam.put("contractName", params.getString("contractName"));
        }
        if (StringUtils.isBlank((CharSequence)params.getString("contractCode"))) {
            queryParam.put("contractCode", params.getString("contractCode"));
        }
        if (StringUtils.isBlank((CharSequence)params.getString("sealFlag"))) {
            queryParam.put("sealFlag", params.getString("sealFlag"));
        } else {
            queryParam.put("sealFlag", "1");
        }
        int count = this.service.countContractAndOrder(queryParam);
        resp.put("total", (Object)count);
        if (count == 0) {
            resp.put("records", new ArrayList());
            return CommonResponse.success((Object)resp);
        }
        List<Map> records = this.service.pageContractAndOrder(queryParam);
        resp.put("records", records);
        return CommonResponse.success((Object)resp);
    }
}

