/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.bean.MaPushErpRecordsEntity;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationFlowEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.BrandRelationMapper;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationFlowService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="brandRelationService")
public class BrandRelationServiceImpl
extends BaseServiceImpl<BrandRelationMapper, BrandRelationEntity>
implements IBrandRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Lazy
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IBrandRelationFlowService relationFlowService;
    @Autowired
    private IMatSupplierApi supplierApi;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;

    @Override
    public List<BrandRelationEntity> checkRelation(List<BrandRelationEntity> saveRelations) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.and(q -> {
            saveRelations.stream().forEach(r -> q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"material_type_id", (Object)r.getMaterialTypeId())).eq((Object)"brand_id", (Object)r.getBrandId())));
            return q;
        });
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandRelationEntity> getAllByCategoryId(Long categoryId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"material_type_id", (Object)categoryId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandRelationEntity> getByBrandId(Long brandId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"brand_id", (Object)brandId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandRelationEntity> getAllByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public void syncRelationToErp(DataPushErpParam pushParam) {
        this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u63a8\u9001ERP-------------\u5f00\u59cb----------------");
        this.logger.info("\u672c\u6b21\u63a8\u9001ERP\u54c1\u724c\u4fe1\u606f\uff1a{}, \u63a8\u9001\u7c7b\u578b: {}", (Object)JSONObject.toJSONString((Object)pushParam.getPushData()), (Object)pushParam.getBillType());
        CommonResponse userResp = this.userApi.findUserByUserId(pushParam.getOperatorId());
        if (!userResp.isSuccess() || null == userResp.getData()) {
            this.logger.error("\u67e5\u8be2\u4eba\u5458id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)pushParam.getOperatorId(), (Object)JSONObject.toJSONString((Object)userResp));
            throw new BusinessException("\u67e5\u8be2\u64cd\u4f5c\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        UserVO operator = (UserVO)userResp.getData();
        String pushResult = null;
        String reqUrl = this.reqHost + ("brandRelationAdd".equals(pushParam.getPushType()) ? "/cefoc/yql/addBrandLibraryRelation" : "/cefoc/yql/upBrandLibraryRelation");
        MaPushErpRecordsEntity record = new MaPushErpRecordsEntity();
        record.setData(JSONObject.toJSONString((Object)pushParam.getPushData()));
        record.setOperatorId(pushParam.getOperatorId());
        record.setOperatorName(operator.getUserName());
        record.setBillType(pushParam.getBillType());
        record.setPushDate(new Date());
        record.setUrl(reqUrl);
        ArrayList<JSONObject> pushParams = new ArrayList<JSONObject>();
        JSONObject syncItem = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        for (BrandRelationVO relation : pushParam.getPushData()) {
            if (!PlanConstant.INTEGER_YES.equals(relation.getDbSupplierFlag())) {
                this.logger.info("\u4f9b\u5e94\u5546-{}\u4e0d\u5728\u5e93\uff0c\u54c1\u724c\u5173\u7cfbid-{}\u8df3\u8fc7\u63a8\u9001\uff01", (Object)relation.getSupplierName(), (Object)relation.getId());
                continue;
            }
            syncItem = new JSONObject();
            syncItem.put("C_PS_BrandLibraryRelationOID", (Object)relation.getSourceId());
            syncItem.put("SYS_Deleted", (Object)("1".equals(relation.getDelFlag()) ? 1 : 0));
            syncItem.put("SYS_Created", (Object)sdf.format(relation.getCreateTime()));
            syncItem.put("SYS_LAST_UPD", null != relation.getUpdateTime() ? sdf.format(relation.getUpdateTime()) : null);
            syncItem.put("Enabled", (Object)relation.getRelationEnabled());
            syncItem.put("BrandSid", (Object)relation.getBrandSid());
            syncItem.put("Memo", (Object)relation.getMemo());
            syncItem.put("CategorySid", (Object)relation.getMaterialTypeSid());
            syncItem.put("CategoryName", (Object)relation.getMaterialTypeName());
            syncItem.put("CategoryTwoSid", (Object)relation.getMaterialTypePsid());
            syncItem.put("CategoryTwoName", (Object)relation.getMaterialTypePname());
            syncItem.put("SupplierSid", (Object)relation.getSupplierSid());
            syncItem.put("SupplierCharacter", (Object)relation.getSupplierCharacter());
            syncItem.put("ApprHuman_sid", (Object)operator.getSourceId());
            syncItem.put("ApprHuman", (Object)operator.getUserName());
            pushParams.add(syncItem);
        }
        Map<String, String> headers = null;
        try {
            Stopwatch start = Stopwatch.createStarted();
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(pushParams), headers, (Integer)180000, (Integer)180000);
            this.logger.info("\u7269\u8d44\u4f9b\u5e94\u5546\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(pushParams, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
            Stopwatch stop = start.stop();
            record.setErpResult(reqResp);
            record.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
            this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u63a8\u9001ERP\u8017\u65f6\uff1a{}\u79d2", (Object)record.getErpHandleSeconds());
            JSONObject reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pushResult = "1";
            } else {
                pushResult = "0";
                record.setFailType("ERP\u6570\u636e\u5904\u7406\u5931\u8d25\uff01");
            }
            record.setSucFlag(pushResult);
        }
        catch (Exception e) {
            this.logger.error("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u540c\u6b65ERP\u5f02\u5e38\uff0c", (Throwable)e);
            record.setSucFlag("0");
            pushResult = "0";
            record.setFailType("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u540c\u6b65ERP\uff0c\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        this.updateRelationPushFlag(pushParam.getPushData().stream().map(BaseVO::getId).collect(Collectors.toList()), pushResult);
        this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)record)));
        this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u63a8\u9001ERP-------------\u7ed3\u675f----------------");
    }

    @Override
    public List<BrandRelationEntity> getAllByCategoryIds(List<Long> categoryIds, String brandName, String supplierName) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"material_type_id", categoryIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)brandName)) {
            query.like((Object)"brand_name", (Object)brandName);
        }
        if (StringUtils.isNotBlank((CharSequence)supplierName)) {
            query.like((Object)"supplier_name", (Object)supplierName);
        }
        query.orderByAsc((Object[])new String[]{"material_type_code", "brand_name", "supplier_name"});
        return super.list((Wrapper)query);
    }

    @Override
    public String saveOrUpdateRelations(List<BrandRelationVO> relations) {
        BrandRelationFlowEntity flow;
        List<BrandRelationEntity> supplierRelations = this.getAllBySupplierId(relations.get(0).getSupplierId());
        ArrayList<Long> categoryIds = new ArrayList<Long>(relations.stream().map(BrandRelationVO::getMaterialTypeId).collect(Collectors.toSet()));
        boolean generateFlow = relations.get(0).isGenerateFlowFlag();
        Long operator = relations.get(0).getOperatorId();
        String operateType = relations.get(0).getOperateType();
        List<MaterialCategoryVO> categorys = this.categoryService.getAllByIds(categoryIds);
        ArrayList<Long> categoryPids = new ArrayList<Long>(categorys.stream().map(MaterialCategoryVO::getParentId).collect(Collectors.toSet()));
        List<MaterialCategoryVO> categtoryParents = this.categoryService.getAllByIds(categoryPids);
        Map<Long, MaterialCategoryVO> categtoryParentsMap = categtoryParents.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, MaterialCategoryVO> categtoryMap = categorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, BrandRelationVO> relationMap = relations.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item));
        Map<String, BrandRelationVO> relationKeyMap = relations.stream().collect(Collectors.toMap(item -> item.getMaterialTypeId().toString() + item.getBrandId().toString(), item -> item));
        ArrayList<Long> brandIds = new ArrayList<Long>(relations.stream().map(BrandRelationVO::getBrandId).collect(Collectors.toSet()));
        List<BrandVO> brandList = this.brandService.getAllByIds(brandIds);
        Map<Long, BrandVO> brandMap = brandList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        ArrayList<BrandRelationEntity> saveList = new ArrayList<BrandRelationEntity>();
        ArrayList<BrandRelationEntity> updateList = new ArrayList<BrandRelationEntity>();
        ArrayList<BrandRelationEntity> delList = new ArrayList<BrandRelationEntity>();
        BrandRelationVO tmp = null;
        MaterialCategoryVO category = null;
        MaterialCategoryVO categoryP = null;
        BrandVO brand = null;
        BrandRelationEntity relation = null;
        ArrayList<BrandRelationFlowEntity> flowList = new ArrayList<BrandRelationFlowEntity>();
        Long operatorId = relations.get(0).getOperatorId();
        UserVO user = null;
        if (null != operatorId) {
            CommonResponse userResp = this.userApi.findUserByUserId(operatorId);
            if (!userResp.isSuccess() || null == userResp.getData()) {
                this.logger.error("\u67e5\u8be2\u4eba\u5458id-{}\u4fe1\u606f\u5931\u8d25", (Object)operatorId);
            } else {
                user = (UserVO)userResp.getData();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)relations.get(0).getSupplierSid()) && null != relations.get(0).getSupplierId()) {
            CommonResponse supplierResp = this.supplierApi.getOneById(relations.get(0).getSupplierId());
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                this.logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)supplierResp));
            } else {
                MatSupplierVO supplierVO = (MatSupplierVO)supplierResp.getData();
                relations.forEach(r -> r.setSupplierSid(supplierVO.getThirdSourceId()));
            }
        }
        if (CollectionUtils.isNotEmpty(supplierRelations)) {
            for (BrandRelationEntity dbRelation : supplierRelations) {
                relation = null;
                tmp = null;
                if (null != dbRelation.getSourceDetailId() && relationMap.containsKey(dbRelation.getSourceDetailId())) {
                    relation = dbRelation;
                    tmp = relationMap.get(dbRelation.getSourceDetailId());
                }
                if (null == relation && relationKeyMap.containsKey(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString())) {
                    relation = dbRelation;
                    tmp = relationKeyMap.get(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString());
                }
                if (null == tmp) {
                    dbRelation.setDelFlag("1");
                    delList.add(dbRelation);
                    continue;
                }
                if ("1".equals(tmp.getDelFlag())) {
                    dbRelation.setDelFlag("1");
                    delList.add(dbRelation);
                } else if (!dbRelation.getMaterialTypeId().equals(tmp.getMaterialTypeId()) || !dbRelation.getBrandId().equals(tmp.getBrandId())) {
                    dbRelation.setPushErpFlag(PlanConstant.INTEGER_NO);
                    dbRelation.setMaterialTypeId(tmp.getMaterialTypeId());
                    category = categtoryMap.get(dbRelation.getMaterialTypeId());
                    dbRelation.setMaterialTypeCode(category.getCode());
                    dbRelation.setMaterialTypeName(category.getName());
                    dbRelation.setMaterialTypeSid(category.getSourceId());
                    categoryP = categtoryParentsMap.get(category.getParentId());
                    dbRelation.setMaterialTypePid(categoryP.getId());
                    dbRelation.setMaterialTypePname(categoryP.getName());
                    dbRelation.setMaterialTypePsid(categoryP.getSourceId());
                    brand = brandMap.get(tmp.getBrandId());
                    dbRelation.setBrandId(brand.getId());
                    dbRelation.setBrandName(brand.getBrandName());
                    dbRelation.setBrandSid(brand.getSourceId());
                    dbRelation.setSupplierName(tmp.getSupplierName());
                    dbRelation.setSupplierCode(tmp.getSupplierCode());
                    dbRelation.setSupplierSid(tmp.getSupplierSid());
                    dbRelation.setBrandLabel(null);
                    dbRelation.setDbSupplierFlag(PlanConstant.INTEGER_YES);
                    updateList.add(dbRelation);
                }
                if (null != tmp) {
                    if (CollectionUtils.isNotEmpty((Collection)tmp.getDetailList())) {
                        flowList.addAll(BeanMapper.mapList((Iterable)tmp.getDetailList(), BrandRelationFlowEntity.class));
                    } else if (generateFlow) {
                        flow = new BrandRelationFlowEntity();
                        flow.setSourceBillId(tmp.getSourceMainId());
                        flow.setSourceBillDetailId(tmp.getSourceDetailId());
                        flow.setRelationId(relation.getId());
                        flow.setOperateTime(new Date());
                        flow.setOperateUserId(operator);
                        flow.setOperateType(operateType + "-\u66f4\u65b0\u54c1\u724c\u5173\u7cfb");
                        flow.setBillPcUrl(tmp.getPcUrl());
                        if (null != user) {
                            flow.setOperateUserCode(user.getUserCode());
                            flow.setOperateUserName(user.getUserName());
                        }
                        flowList.add(flow);
                    }
                } else if (null != relation && generateFlow) {
                    flow = new BrandRelationFlowEntity();
                    flow.setSourceBillId(relation.getSourceMainId());
                    flow.setSourceBillDetailId(relation.getSourceDetailId());
                    flow.setRelationId(relation.getId());
                    flow.setOperateTime(new Date());
                    flow.setOperateUserId(operator);
                    flow.setOperateType(operateType + "-\u5220\u9664\u54c1\u724c\u5173\u7cfb");
                    if (null != user) {
                        flow.setOperateUserCode(user.getUserCode());
                        flow.setOperateUserName(user.getUserName());
                    }
                    flowList.add(flow);
                }
                relationMap.remove(tmp.getSourceDetailId());
            }
        }
        if (MapUtils.isNotEmpty(relationMap)) {
            for (BrandRelationVO newRelation : relationMap.values()) {
                relation = new BrandRelationEntity();
                relation.setPushErpFlag(PlanConstant.INTEGER_NO);
                relation.setMaterialTypeId(newRelation.getMaterialTypeId());
                category = categtoryMap.get(relation.getMaterialTypeId());
                relation.setMaterialTypeCode(category.getCode());
                relation.setMaterialTypeName(category.getName());
                relation.setMaterialTypeSid(category.getSourceId());
                categoryP = categtoryParentsMap.get(category.getParentId());
                relation.setMaterialTypePid(categoryP.getId());
                relation.setMaterialTypePname(categoryP.getName());
                relation.setMaterialTypePsid(categoryP.getSourceId());
                brand = brandMap.get(newRelation.getBrandId());
                if (null == brand) {
                    this.logger.info("\u4f9b\u5e94\u5546id-{}\u5bf9\u5e94\u54c1\u724c\u3010id-{},brandName-{}\u3011\u4fe1\u606f\u65e0\u5339\u914d\u4fe1\u606f\u6216\u5df2\u88ab\u5220\u9664", new Object[]{newRelation.getSupplierId(), newRelation.getBrandId(), newRelation.getBrandName()});
                    continue;
                }
                relation.setBrandId(brand.getId());
                relation.setBrandName(brand.getBrandName());
                relation.setBrandSid(brand.getSourceId());
                relation.setBrandLabel(null);
                relation.setDbSupplierFlag(PlanConstant.INTEGER_YES);
                relation.setRelationEnabled(PlanConstant.INTEGER_YES);
                relation.setSupplierId(newRelation.getSupplierId());
                relation.setSupplierSid(newRelation.getSupplierSid());
                relation.setSupplierCode(newRelation.getSupplierCode());
                relation.setSupplierName(newRelation.getSupplierName());
                relation.setSourceMainId(newRelation.getSourceMainId());
                relation.setSourceDetailId(newRelation.getSourceDetailId());
                relation.setId(IdWorker.getId());
                relation.setSourceId(ZDSInterfaceCommonUtil.changeLongToGUID(relation.getId()));
                if (CollectionUtils.isNotEmpty((Collection)newRelation.getDetailList())) {
                    flowList.addAll(BeanMapper.mapList((Iterable)newRelation.getDetailList(), BrandRelationFlowEntity.class));
                } else if (generateFlow) {
                    flow = new BrandRelationFlowEntity();
                    flow.setSourceBillId(newRelation.getSourceMainId());
                    flow.setSourceBillDetailId(newRelation.getSourceDetailId());
                    flow.setRelationId(relation.getId());
                    flow.setOperateTime(new Date());
                    flow.setOperateUserId(newRelation.getOperatorId());
                    flow.setOperateType(newRelation.getOperateType() + "-\u65b0\u589e\u54c1\u724c\u5173\u7cfb");
                    flow.setBillPcUrl(newRelation.getPcUrl());
                    if (null != user) {
                        flow.setOperateUserCode(user.getUserCode());
                        flow.setOperateUserName(user.getUserName());
                    }
                    flowList.add(flow);
                }
                saveList.add(relation);
            }
        }
        String billType = relations.get(0).getBillType();
        this.logger.info("\u672c\u6b21\u65b0\u589e\u4f9b\u5e94\u5546\u54c1\u724c\u5173\u7cfb\uff1a{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            super.saveOrUpdateBatch(saveList, saveList.size(), false);
            List syncList = saveList.stream().filter(item -> null != item.getSupplierSid()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(syncList)) {
                this.queueUtils.sendMq("data_push_erp_queue_" + this.profile, JSONObject.toJSONString((Object)new DataPushErpParam(BeanMapper.mapList(syncList, BrandRelationVO.class), operatorId, "brandRelationAdd", billType)));
            }
        }
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u4f9b\u5e94\u5546\u54c1\u724c\u5173\u7cfb\uff1a{}\u6761", (Object)updateList.size());
        if (CollectionUtils.isNotEmpty(updateList)) {
            super.saveOrUpdateBatch(updateList, updateList.size(), false);
            this.queueUtils.sendMq("data_push_erp_queue_" + this.profile, JSONObject.toJSONString((Object)new DataPushErpParam(BeanMapper.mapList(updateList, BrandRelationVO.class), operatorId, "brandRelationChange", billType)));
        }
        this.logger.info("\u672c\u6b21\u5220\u9664\u4f9b\u5e94\u5546\u54c1\u724c\u5173\u7cfb\uff1a{}\u6761", (Object)delList.size());
        if (CollectionUtils.isNotEmpty(delList)) {
            super.removeByIds((Collection)delList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            this.queueUtils.sendMq("data_push_erp_queue_" + this.profile, JSONObject.toJSONString((Object)new DataPushErpParam(BeanMapper.mapList(delList, BrandRelationVO.class), operatorId, "brandRelationChange", billType)));
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6d41\u6c34\uff1a{}\u6761", (Object)flowList.size());
        if (CollectionUtils.isNotEmpty(flowList)) {
            this.relationFlowService.saveOrUpdateBatch(flowList, flowList.size(), false);
        }
        return null;
    }

    @Override
    public List<BrandRelationEntity> getAllBySupplierId(Long supplierId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"supplier_id", (Object)supplierId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    private void updateRelationPushFlag(List<Long> ids, String pushResult) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"push_erp_flag", (Object)pushResult);
        super.update((Wrapper)update);
    }

    private void initContext(Long userId) {
        String initContextUrl = this.environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId=" + userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        try {
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if (null != userContext) {
                    authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                }
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

