/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.bean.MaPushErpRecordsEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.BrandMapper;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.base.Stopwatch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class BrandServiceImpl
extends BaseServiceImpl<BrandMapper, BrandEntity>
implements IBrandService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BrandMapper mapper;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private IBrandRelationService brandRelationService;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Autowired
    private IUserApi userApi;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;

    @Override
    public Map<String, BrandEntity> getAllByNames(List<String> brandNames) {
        Map<String, BrandEntity> resp = new HashMap<String, BrandEntity>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"brand_name", brandNames);
        List brandList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)brandList)) {
            resp = brandList.stream().collect(Collectors.toMap(item -> item.getBrandName(), item -> item));
        }
        return resp;
    }

    @Override
    public Map<String, BrandVO> getAllVoMapByNames(List<String> names) {
        Map<String, BrandVO> resp = new HashMap<String, BrandVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"brand_name", names);
        List brandList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)brandList)) {
            List vos = BeanMapper.mapList((Iterable)brandList, BrandVO.class);
            resp = vos.stream().collect(Collectors.toMap(item -> item.getBrandName(), item -> item));
        }
        return resp;
    }

    @Override
    public BrandEntity getOneByName(String name) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"brand_name", (Object)name);
        List brandList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)brandList)) {
            BrandEntity brandEntity = (BrandEntity)((Object)brandList.get(0));
            return brandEntity;
        }
        return null;
    }

    @Override
    public List<BrandEntity> getAllBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_id", sourceIds);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandVO> getAllByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<BrandVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, BrandVO.class);
        }
        return resp;
    }

    @Override
    @Async(value="maContextCommonTask")
    public void pushBrandToErp(DataPushErpParam pushParam) {
        this.logger.info("\u54c1\u724c\u4fe1\u606f\u63a8\u9001ERP-------------\u5f00\u59cb----------------");
        this.logger.info("\u672c\u6b21\u63a8\u9001ERP\u54c1\u724c\u4fe1\u606f\uff1a{}, \u63a8\u9001\u7c7b\u578b: {}", (Object)JSONObject.toJSONString((Object)pushParam.getPushData()), (Object)pushParam.getBillType());
        if (null == InvocationInfoProxy.getUserid() && null != pushParam.getOperatorId()) {
            this.initContext(pushParam.getOperatorId());
        }
        String pushResult = null;
        String reqUrl = this.reqHost + ("brandAdd".equals(pushParam.getPushType()) ? "/cefoc/yql/addBrand" : "/cefoc/yql/updateBrand");
        CommonResponse userResp = this.userApi.findUserByUserId(pushParam.getOperatorId());
        if (!userResp.isSuccess() || null == userResp.getData()) {
            this.logger.error("\u67e5\u8be2\u4eba\u5458id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)pushParam.getOperatorId(), (Object)JSONObject.toJSONString((Object)userResp));
            throw new BusinessException("\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25");
        }
        UserVO user = (UserVO)userResp.getData();
        MaPushErpRecordsEntity record = new MaPushErpRecordsEntity();
        record.setData(JSONObject.toJSONString((Object)pushParam.getPushData()));
        record.setOperatorId(pushParam.getOperatorId());
        record.setOperatorName(user.getUserName());
        record.setBillType(pushParam.getBillType());
        record.setPushDate(new Date());
        record.setUrl(reqUrl);
        ArrayList<JSONObject> pushParams = new ArrayList<JSONObject>();
        JSONObject syncItem = null;
        ArrayList<Long> brandIds = new ArrayList<Long>();
        for (BrandRelationVO brand : pushParam.getPushData()) {
            if (brandIds.contains(brand.getBrandId())) continue;
            syncItem = new JSONObject();
            syncItem.put("C_PS_BrandLibraryOID", (Object)brand.getBrandSid());
            syncItem.put("Title_ID", (Object)brand.getBrandId());
            syncItem.put("Title", (Object)brand.getBrandName());
            syncItem.put("Sort_ID", (Object)brand.getBrandSequence());
            syncItem.put("IsEnable", (Object)brand.getBrandEnabled());
            syncItem.put("Memo", (Object)brand.getMemo());
            syncItem.put("BrandLabel", (Object)brand.getBrandLabel());
            syncItem.put("Factory", (Object)brand.getSupplierName());
            syncItem.put("CategoryName", (Object)brand.getMaterialTypeName());
            syncItem.put("CategorySid", (Object)brand.getMaterialTypeSid());
            brandIds.add(brand.getBrandId());
            pushParams.add(syncItem);
        }
        Map<String, String> headers = null;
        try {
            Stopwatch start = Stopwatch.createStarted();
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(pushParams), headers, (Integer)180000, (Integer)180000);
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(pushParams, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
            Stopwatch stop = start.stop();
            record.setErpResult(reqResp);
            record.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
            this.logger.info("\u54c1\u724c\u4fe1\u606f\u63a8\u9001ERP\u8017\u65f6\uff1a{}\u79d2", (Object)record.getErpHandleSeconds());
            JSONObject reqJson = JSONObject.parseObject((String)reqResp);
            if ("true".equals(reqJson.getString("status"))) {
                pushResult = "1";
            } else {
                pushResult = "0";
                record.setFailType("ERP\u6570\u636e\u5904\u7406\u5931\u8d25\uff01");
            }
            record.setSucFlag(pushResult);
        }
        catch (Exception e) {
            this.logger.error("\u54c1\u724c\u4fe1\u606f\u540c\u6b65ERP\u5f02\u5e38\uff0c", (Throwable)e);
            record.setSucFlag("0");
            pushResult = "0";
            record.setFailType("\u54c1\u724c\u4fe1\u606f\u540c\u6b65ERP\uff0c\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        this.updateBrandPushFlag(new ArrayList<Long>(pushParam.getPushData().stream().map(BrandRelationVO::getBrandId).collect(Collectors.toSet())), pushResult);
        this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)record)));
        this.logger.info("\u54c1\u724c\u4fe1\u606f\u63a8\u9001ERP-------------\u7ed3\u675f----------------");
    }

    private void updateBrandPushFlag(List<Long> ids, String pushResult) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"push_erp_flag", (Object)pushResult);
        super.update((Wrapper)update);
    }

    private void initContext(Long userId) {
        String initContextUrl = this.environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId=" + userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        try {
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if (null != userContext) {
                    authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                }
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public void updateBrandEnable(BrandVO brand) {
        BrandEntity entity = (BrandEntity)((Object)super.selectById((Serializable)brand.getId()));
        entity.setEnabled(brand.getEnabled());
        ArrayList<BrandRelationEntity> pushList = new ArrayList<BrandRelationEntity>();
        pushList.add(this.getBrandRelation(entity, brand.getRelationId()));
        this.pushBrandToErp(new DataPushErpParam(BeanMapper.mapList(pushList, BrandRelationVO.class), InvocationInfoProxy.getUserid(), "brandChange", "EJCBT202408000002"));
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public long countBrandPool(Map<String, Object> param) {
        return this.mapper.countBrandPool(param);
    }

    @Override
    public List<BrandVO> pageBrandPool(Map<String, Object> param) {
        return this.mapper.pageBrandPool(param);
    }

    private BrandRelationEntity getBrandRelation(BrandEntity brand, Long relationId) {
        BrandRelationEntity relation = null;
        if (null != relationId) {
            relation = (BrandRelationEntity)((Object)this.brandRelationService.selectById(relationId));
        } else {
            List<BrandRelationEntity> relations = this.brandRelationService.getByBrandId(brand.getId());
            if (CollectionUtils.isNotEmpty(relations)) {
                relation = relations.get(0);
            }
        }
        if (null == relation) {
            relation = new BrandRelationEntity();
        }
        relation.setBrandSequence(brand.getSequence());
        relation.setBrandSid(brand.getSourceId());
        relation.setBrandName(brand.getBrandName());
        relation.setBrandId(brand.getId());
        return relation;
    }
}

