/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.ContractMapper;
import com.ejianc.business.zdsmaterial.erp.service.IContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractDetailService detailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private ContractMapper contractMapper;

    @Override
    public ContractVO getOneBySourceContractId(String sourceContractId) {
        ContractVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_contract_id", (Object)sourceContractId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        ContractEntity e = (ContractEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            e.setDetailList(this.detailService.getByAllContractId(e.getId()));
            resp = (ContractVO)BeanMapper.map((Object)((Object)e), ContractVO.class);
        }
        return resp;
    }

    @Override
    public ContractVO getOneByCode(String contractCode) {
        ContractVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)contractCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        ContractEntity e = (ContractEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            e.setDetailList(this.detailService.getByAllContractId(e.getId()));
            resp = (ContractVO)BeanMapper.map((Object)((Object)e), ContractVO.class);
        }
        return resp;
    }

    @Override
    public ContractVO saveContract(ContractVO saveContractInfo) {
        ContractEntity saveEntity = (ContractEntity)((Object)BeanMapper.map((Object)saveContractInfo, ContractEntity.class));
        boolean addFlag = null == saveEntity.getId();
        super.saveOrUpdate((Object)saveEntity, false);
        if (ZDSMaterialCommonEnums.\u603b\u4ef7\u5408\u540c.getCode().equals(saveEntity.getPriceType())) {
            this.orderService.saveByContract(saveEntity, addFlag);
        }
        return (ContractVO)BeanMapper.map((Object)((Object)saveEntity), ContractVO.class);
    }

    @Override
    public List<ContractEntity> getBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"source_contract_id", sourceIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public Integer performanceNum(Long linkerId, String linkerSid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)1);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.and(q -> (QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"supplier_manager_id", (Object)linkerId)).or()).eq((Object)"supplier_manager_sid", (Object)linkerSid));
        int count = super.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public Integer finishedNum(Long linkerId, String linkerSid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)2);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.and(q -> (QueryWrapper)((QueryWrapper)((QueryWrapper)q.eq((Object)"supplier_manager_id", (Object)linkerId)).or()).eq((Object)"supplier_manager_sid", (Object)linkerSid));
        int count = super.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public String thisYearContract(Long linkerId, String linkerSid) {
        ArrayList collect = new ArrayList();
        List<ContractEntity> list = this.contractMapper.queryNowYearList(linkerId, linkerSid);
        StringJoiner joiner = new StringJoiner(",");
        if (CollectionUtils.isNotEmpty(list)) {
            for (ContractEntity e : list) {
                joiner.add(String.valueOf(e.getId()));
            }
        }
        String idsStr = joiner.toString();
        return idsStr;
    }

    @Override
    public int countContractAndOrder(Map<String, Object> queryParam) {
        return this.contractMapper.countContractAndOrder(queryParam);
    }

    @Override
    public List<Map> pageContractAndOrder(Map<String, Object> queryParam) {
        return this.contractMapper.pageContractAndOrder(queryParam);
    }

    @Override
    public BigDecimal thisYearContractMny(Long linkerId, String linkerSid) {
        return this.contractMapper.thisYearContractMny(linkerId, linkerSid);
    }

    @Override
    @Async(value="maContextCommonTask")
    public void cancelBill(List<Long> delContractIds) {
        List<Long> mainContractIds;
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", delContractIds);
        query.eq((Object)"price_type", (Object)2);
        List mainCons = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)mainCons) && CollectionUtils.isNotEmpty(mainContractIds = mainCons.stream().map(BaseEntity::getId).collect(Collectors.toList()))) {
            this.orderService.cancelOrderByContractId(mainContractIds);
        }
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", delContractIds);
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        update.set((Object)"dr", (Object)1);
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"remark", (Object)"ERP-\u4f5c\u5e9f\u5220\u9664");
        super.update((Wrapper)update);
        this.detailService.cancelByContractIds(delContractIds);
    }
}

