/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.OrderDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.material.vo.OrderQueryVo;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="orderDetailService")
public class OrderDetailServiceImpl
extends BaseServiceImpl<OrderDetailMapper, OrderDetailEntity>
implements IOrderDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Lazy
    @Autowired
    private IOrderService orderService;
    @Autowired
    private OrderDetailMapper mapper;

    @Override
    public List<OrderDetailEntity> getAllByOrderId(Long id) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"order_id", (Object)id);
        return super.list((Wrapper)query);
    }

    @Override
    public Map<Long, BigDecimal> queryHandleAcceptNum(List<Long> ids) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", ids);
        List list = super.list((Wrapper)queryWrapper);
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(BaseEntity::getId, OrderDetailEntity::getHandAcceptNum));
        return collect;
    }

    @Override
    public void returnAcceptedNum(List<DeliveryDetailEntity> list, boolean addFlag) {
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(DeliveryDetailEntity::getSourceDetailId, DeliveryDetailEntity::getCheckNum));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", collect.keySet());
        List orderDetailEntities = super.list((Wrapper)queryWrapper);
        for (OrderDetailEntity detail : orderDetailEntities) {
            if (!collect.containsKey(detail.getId())) continue;
            BigDecimal acceptedNum = detail.getAcceptedNum();
            BigDecimal decimal = addFlag ? ComputeUtil.safeAdd((BigDecimal)acceptedNum, (BigDecimal)collect.get(detail.getId())) : ComputeUtil.safeSub((BigDecimal)acceptedNum, (BigDecimal)collect.get(detail.getId()));
            detail.setAcceptedNum(decimal);
        }
        super.saveOrUpdateBatch((Collection)orderDetailEntities);
    }

    @Override
    public void returnDeliveryNum(Map<Long, BigDecimal> returnOrderMap, boolean addFlag) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", returnOrderMap.keySet());
        List orderDetailEntities = super.list((Wrapper)queryWrapper);
        BigDecimal deliveryTaxMny = BigDecimal.ZERO;
        BigDecimal deliveryMny = BigDecimal.ZERO;
        Long orderId = null;
        for (OrderDetailEntity detail : orderDetailEntities) {
            if (null == orderId) {
                orderId = detail.getOrderId();
            }
            if (!returnOrderMap.containsKey(detail.getId())) continue;
            BigDecimal deliveredNum = detail.getDeliveredNum();
            BigDecimal decimal = addFlag ? ComputeUtil.safeSub((BigDecimal)deliveredNum, (BigDecimal)returnOrderMap.get(detail.getId())) : ComputeUtil.safeAdd((BigDecimal)deliveredNum, (BigDecimal)returnOrderMap.get(detail.getId()));
            BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)decimal, (BigDecimal)detail.getDetailTaxPrice());
            BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)decimal, (BigDecimal)detail.getDetailPrice());
            deliveryTaxMny = ComputeUtil.safeAdd((BigDecimal)deliveryTaxMny, (BigDecimal)taxMny);
            deliveryMny = ComputeUtil.safeAdd((BigDecimal)deliveryMny, (BigDecimal)mny);
            detail.setDeliveredNum(decimal);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", orderId);
        updateWrapper.set((Object)"delivered_tax_mny", (Object)deliveryTaxMny);
        updateWrapper.set((Object)"delivered_mny", (Object)deliveryMny);
        this.orderService.update((Wrapper)updateWrapper);
        super.saveOrUpdateBatch((Collection)orderDetailEntities);
    }

    @Override
    public void returnHandAcceptNum(AcceptEntity entity, boolean addFlag) {
        HashMap<Long, AcceptDetailEntity> detailNumMapNew = new HashMap<Long, AcceptDetailEntity>();
        for (AcceptDetailEntity detail : entity.getDetailList()) {
            detailNumMapNew.put(detail.getSourceDetailId(), detail);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", detailNumMapNew.keySet());
        List orderDetailEntities = super.list((Wrapper)queryWrapper);
        for (OrderDetailEntity detail : orderDetailEntities) {
            if (!detailNumMapNew.containsKey(detail.getId())) continue;
            BigDecimal checkNum = ((AcceptDetailEntity)((Object)detailNumMapNew.get(detail.getId()))).getDetailNum();
            BigDecimal handAcceptNum = detail.getHandAcceptNum();
            if (addFlag) {
                if ("del".equals(((AcceptDetailEntity)((Object)detailNumMapNew.get(detail.getId()))).getRowState())) {
                    checkNum = ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)checkNum);
                }
                handAcceptNum = ComputeUtil.safeAdd((BigDecimal)handAcceptNum, (BigDecimal)checkNum);
            } else {
                handAcceptNum = ComputeUtil.safeSub((BigDecimal)handAcceptNum, (BigDecimal)checkNum);
            }
            detail.setHandAcceptNum(handAcceptNum);
        }
        super.saveOrUpdateBatch((Collection)orderDetailEntities);
    }

    @Override
    public List<PurchaseAnalysisVo> countNum(Map<String, Object> params) {
        return this.mapper.countNum(params);
    }

    @Override
    public List<OrderQueryVo> orderList(Map<String, Object> params) {
        return this.mapper.orderList(params);
    }

    @Override
    public List<Map<String, Object>> getMaterialOrderNums(Long projectId, List<Long> materialIds) {
        return this.mapper.getMaterialOrderNums(projectId, materialIds);
    }

    @Override
    @Async(value="maContextCommonTask")
    public void cancelByOrderIds(List<Long> orderIds) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"order_id", orderIds);
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        update.set((Object)"dr", (Object)1);
        update.set((Object)"update_time", (Object)new Date());
        super.update((Wrapper)update);
    }
}

