/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceFileEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatInvoiceMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatCheckerSettingService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceService;
import com.ejianc.business.zdsmaterial.material.vo.MatInvoiceVO;
import com.ejianc.business.zdsmaterial.util.BillLockUtil;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="matInvoiceService")
public class MatInvoiceServiceImpl
extends BaseServiceImpl<MatInvoiceMapper, MatInvoiceEntity>
implements IMatInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "EJCBT202404000001";
    private static final String BILL_NAME = "\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matInvoice/supSignSync";
    private static final String BILL_CODE = "MAT_INVOICE";
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IMatSupplierApi matSupplierApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IErpInvoiceService erpInvoiceService;
    @Autowired
    private PushFileUtil pushFileUtil;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IErpInvoiceDetailService invoiceDetailService;
    @Autowired
    private IMatCheckerSettingService matCheckerSettingService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveSyncBill(HttpServletRequest request) {
        CommonResponse ejcCloudSystemCode;
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        this.logger.info("\u8fdb\u5165\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String fileStrList = request.getParameter("fileList");
        List fileList = JSONArray.parseArray((String)fileStrList, AttachmentVO.class);
        this.logger.info("\u63a5\u6536\u5230\u6570\u636etransData\uff1a{}\uff0cfileList\uff1a{},", (Object)transData, (Object)fileStrList);
        MatInvoiceVO vo = (MatInvoiceVO)JSONObject.parseObject((String)transData, MatInvoiceVO.class);
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        MatInvoiceEntity saveEntity = (MatInvoiceEntity)((Object)BeanMapper.map((Object)vo, MatInvoiceEntity.class));
        EmployeeVO craetor = null;
        Long checkerId = this.matCheckerSettingService.getByContractId(saveEntity.getContractId());
        if (null == checkerId) {
            this.logger.error("\u6839\u636e\u91c7\u8d2d\u5408\u540cid-{}\uff0c\u67e5\u8be2\u5bf9\u5e94\u91c7\u8d2d\u53d1\u7968\u4eba\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)saveEntity.getContractId());
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
        }
        CommonResponse creatorResp = this.employeeApi.getById(checkerId);
        if (!creatorResp.isSuccess()) {
            this.logger.error("\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u5931\u8d25,{}", (Object)saveEntity.getAdminId(), (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
        }
        if (null == creatorResp.getData()) {
            this.logger.error("\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba-{}\u4fe1\u606f\u4e3a\u7a7a,{}", (Object)saveEntity.getAdminId(), (Object)JSONObject.toJSONString((Object)creatorResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25,\u67e5\u8be2\u53d1\u7968\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25!");
        }
        craetor = (EmployeeVO)creatorResp.getData();
        if (!checkerId.equals(saveEntity.getAdminId())) {
            saveEntity.setAdminId(craetor.getId().toString());
            saveEntity.setAdminCode(craetor.getCode());
            saveEntity.setAdminName(craetor.getName());
        }
        if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo))).isSuccess()) {
            saveEntity.setBillCode((String)billCode.getData());
        }
        saveEntity.setSourceId(saveEntity.getId());
        saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        saveEntity.setSignState(Integer.valueOf("0"));
        CommonUtils.clearInvalidData(saveEntity);
        saveEntity.setCreateUserName(craetor.getUserName());
        saveEntity.setCreateUserId(craetor.getUserId());
        saveEntity.setCreateUserCode(craetor.getCode());
        saveEntity.setPushErpFlag("0");
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        List<Object> invoiceNums = new ArrayList();
        for (MatInvoiceDetailEntity detail : saveEntity.getDetailList()) {
            detail.setSourceId(detail.getId());
            detail.setSourceMainId(detail.getMainId());
            CommonUtils.clearInvalidData(detail);
            detail.setCreateUserCode(craetor.getUserCode());
            invoiceIds.add(detail.getInvoiceId());
        }
        if (CollectionUtils.isNotEmpty(invoiceIds)) {
            Object quotedInvoiceNums;
            List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(invoiceIds);
            invoiceNums = invoiceList.stream().map(ErpInvoiceEntity::getNumber).collect(Collectors.toList());
            List quotedList = invoiceList.stream().filter(invoice -> "1".equals(invoice.getQuoteFlag()) || "1".equals(invoice.getErpQuoteFlag())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(quotedList)) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quotedList.stream().map(ErpInvoiceEntity::getNumber).collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
            }
            if (CollectionUtils.isNotEmpty(saveEntity.getDetailList()) && CollectionUtils.isNotEmpty((Collection)(quotedInvoiceNums = this.erpInvoiceService.checkQuote(new ArrayList<String>(saveEntity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet())), "mat")))) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a\u3010" + quotedInvoiceNums.stream().collect(Collectors.joining(",")) + "\u3011\u7684\u53d1\u7968\u5df2\u88ab\u4f7f\u7528\uff01");
            }
            invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag("1"));
            this.erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
        }
        if (!(ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode()).isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)saveEntity.getSourceId(), (Object)ejcCloudSystemCode.getMsg());
        }
        saveEntity.setSystemId((String)ejcCloudSystemCode.getData());
        if (CollectionUtils.isNotEmpty(saveEntity.getDetailList())) {
            saveEntity.setInvoiceHeader(saveEntity.getDetailList().get(0).getInvoiceHeader());
        }
        List<MatInvoiceFileEntity> subFileList = saveEntity.getFileList();
        for (MatInvoiceFileEntity file : subFileList) {
            file.setSourceId(file.getId());
            file.setSourceMainId(file.getMainId());
            CommonUtils.clearInvalidData(file);
            file.setCreateUserCode(craetor.getUserCode());
            file.setId(IdWorker.getId());
            Long fileId = this.pushFileUtil.uploadFileFormNet(BILL_TYPE, file.getId(), "file01", file.getFileId());
            file.setFileId(fileId);
            file.setFileUrl(this.BASE_HOST + "/ejc-file-web/attachment/filePreview?fileId=" + fileId);
        }
        super.saveOrUpdate((Object)saveEntity, false);
        this.logger.info("\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4, \u5411\u53d1\u7968\u7ba1\u7406\u5458id-{}\u53d1\u9001\u6d88\u606f", (Object)saveEntity.getAdminId());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("\u3010\u53d1\u7968\u5ba1\u6838\u3011\uff1a\u3010" + saveEntity.getBillCode() + "\u3011\uff0c\u3010" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + "\u3011\u9700\u8981\u60a8\u5ba1\u6838\uff01\uff01");
        StringBuilder content = new StringBuilder();
        content.append("\u3010").append(saveEntity.getBillCode()).append("\u3011\uff0c\u3010").append(saveEntity.getProjectName()).append("\u3011\uff0c\u3010").append(saveEntity.getContractName()).append("\u3011\uff0c\u3010").append(saveEntity.getSupplierName()).append("\u3011\u63d0\u4ea4\u4e86\u53d1\u7968\uff0c\u8bf7\u60a8\u5ba1\u6838\uff01");
        parameter.setContent(content.toString());
        parameter.setPcUrl(this.BASE_HOST + CommonConstants.\u7269\u8d44\u53d1\u7968\u767b\u8bb0\u5ba1\u6838PC\u8be6\u60c5 + saveEntity.getId().toString());
        String[] recIds = new String[]{saveEntity.getAdminId()};
        parameter.setReceivers(recIds);
        this.sendMsg(parameter, saveEntity.getId(), "\u4f9b\u65b9\u53d1\u7968\u63d0\u4ea4 \u5411\u53d1\u7968\u7ba1\u7406\u5458\u53d1\u9001\u6d88\u606f");
        this.logger.info("\u4fdd\u5b58\u63a5\u53e3\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return saveEntity.getId();
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("{}-\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u5355\u636eId-{}\uff0c\u53d1\u9001\u6d88\u606f\u7ed3\u679c-{}", new Object[]{oprMsg, billId, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("{}-\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)oprMsg);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MatInvoiceVO confirmSign(Long id, boolean isConfirm, String rejectReason) {
        UserContext user = this.sessionManager.getUserContext();
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)super.selectById((Serializable)id));
        try {
            BillLockUtil.getLock(BILL_TYPE, entity.getId());
            HashMap nameSourceTypeMapping = new HashMap();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
            params.put("billId", String.valueOf(entity.getSourceId()));
            params.put("operateId", String.valueOf(user.getUserId()));
            params.put("operateName", user.getUserName());
            params.put("signState", isConfirm ? "1" : "2");
            if (StringUtils.isNotBlank((CharSequence)rejectReason)) {
                params.put("rejectReason", rejectReason);
            }
            this.logger.info("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\uff0c\u901a\u77e5\u5355\u636e\u63a8\u9001\u65b9systemId-{},\u53c2\u6570-{}", new Object[]{BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params)});
            CommonResponse backResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), null);
            this.logger.error("\u5355\u636e-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u7ed3\u679c\uff0c{}", (Object)BILL_NAME, (Object)JSONObject.toJSONString((Object)backResp));
            if (!backResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), backResp.getMsg()});
                throw new BusinessException("\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0\u66f4\u65b0\u72b6\u6001\u56de\u5199\u53d1\u9001\u8bf7\u6c42\u5931\u8d25");
            }
            if ("\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01".equals(backResp.getData())) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u7cfb\u7edf-{}\u5931\u8d25, {}", new Object[]{BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData()});
                throw new BusinessException((String)backResp.getData());
            }
            CommonResponse operateResp = (CommonResponse)JSONObject.parseObject((String)((String)backResp.getData()), CommonResponse.class);
            if (!operateResp.isSuccess()) {
                this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25\uff0c{}", new Object[]{BILL_NAME, entity.getId(), operateResp.getMsg()});
                throw new BusinessException("\u66f4\u65b0\u72b6\u6001\u56de\u8c03\u5904\u7406\u5931\u8d25");
            }
            if (!isConfirm && CollectionUtils.isNotEmpty(entity.getDetailList())) {
                List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceId).collect(Collectors.toList()));
                invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag("0"));
                this.erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
            }
            super.saveOrUpdate((Object)entity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636e-{}id-{}\u66f4\u65b0\u72b6\u6001\u5f02\u5e38\uff0c", new Object[]{BILL_NAME, entity.getId(), e});
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        finally {
            BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(MatInvoiceEntity::getSignState, (Object)(isConfirm ? "1" : "2"));
        this.update((Wrapper)updateWrapper);
        return (MatInvoiceVO)BeanMapper.map((Object)this.selectById(id), MatInvoiceVO.class);
    }

    @Override
    public void syncToErp(Long id) {
        this.logger.info("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}\u81f3ERP   start*********", (Object)id);
        Map<String, String> headers = null;
        try {
            MatInvoiceEntity entity = (MatInvoiceEntity)((Object)super.selectById((Serializable)id));
            if (this.checkInvoiceQuoteInfo(entity)) {
                this.logger.info("\u63a8\u9001\u7ec8\u6b62\uff0c\u53d1\u7968\u767b\u8bb0id-{}\u4e2d\u4f7f\u7528\u5df2\u88ab\u5f15\u7528", (Object)id);
                return;
            }
            JSONArray syncData = this.transferToErpParam(entity);
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)(ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/AddProcureMEBillLists"), (String)JSONObject.toJSONString((Object)syncData), headers, (Integer)180000, (Integer)180000);
            this.logger.info("\u91c7\u8d2d\u53d1\u7968\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{"/cefoc/yql/AddProcureMEBillLists", JSONObject.toJSONString((Object)syncData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
            JSONObject reqJson = JSONObject.parseObject((String)reqResp);
            if ("true".equals(reqJson.getString("status"))) {
                this.logger.info("\u4e2d\u7535\u56db \u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}\u63a8\u9001ERP\u6210\u529f!", (Object)id);
            } else {
                this.logger.error("\u4e2d\u7535\u56db \u91c7\u8d2d\u53d1\u7968\u767b\u8bb0id-{}\u63a8\u9001ERP\u5931\u8d25!", (Object)id);
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968id-{}\u5f02\u5e38\uff0c", (Object)id, (Object)e);
        }
        this.logger.info("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968id-{}\u81f3ERP   end*********", (Object)id);
    }

    @Override
    public String validateMny(Long id) {
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)super.selectById((Serializable)id));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)entity.getContractId()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = super.queryList(param);
        list.add(entity);
        BigDecimal invoiceMny = list.stream().map(e -> e.getTotalTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        if (contract == null) {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u8be5\u5408\u540c\uff01");
            return "\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01";
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.and(e -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.eq(ContractEntity::getMainContractId, (Object)contract.getId())).or()).eq(ContractEntity::getMainContractSid, (Object)contract.getSourceContractId()));
        List contList = this.contractService.list((Wrapper)ew);
        contList.add(contract);
        BigDecimal contractMny = contList.stream().map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        if (ComputeUtil.isGreaterThan(invoiceMny, contractMny)) {
            this.logger.info("\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u3010{}\u3011\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\u3010{}\u3011\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01", (Object)invoiceMny.toPlainString(), (Object)contractMny.toPlainString());
            return "\u7d2f\u8ba1\u53d1\u7968\u91d1\u989d\u8d85\u8fc7\u4e86\u5408\u540c\u91d1\u989d\uff0c\u5ba1\u6838\u8bf7\u6ce8\u610f\uff01";
        }
        return null;
    }

    private boolean checkInvoiceQuoteInfo(MatInvoiceEntity entity) {
        boolean quoteFlag = false;
        JSONArray josnArr = this.erpInvoiceService.syncTodayQuotedInvoice("mat");
        Map<String, List<MatInvoiceDetailEntity>> detailMap = entity.getDetailList().stream().collect(Collectors.groupingBy(MatInvoiceDetailEntity::getInvoiceNumber));
        if (null != josnArr && josnArr.size() > 0) {
            JSONObject json = null;
            for (Object obj : josnArr) {
                json = (JSONObject)obj;
                if (!detailMap.containsKey(json.getString("InvoiceHM"))) continue;
                quoteFlag = true;
                for (MatInvoiceDetailEntity detail : detailMap.get(json.getString("InvoiceHM"))) {
                    detail.setErpQuoteBillCode(json.getString("Ma_id"));
                }
            }
        }
        if (quoteFlag) {
            entity.setPushErpFlag("2");
            super.saveOrUpdate((Object)entity, false);
        }
        return quoteFlag;
    }

    private JSONArray transferToErpParam(MatInvoiceEntity entity) {
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add((Object)data);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        CommonResponse prjResp = this.projectPoolApi.getById(contract.getProjectId());
        if (!prjResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76eeid-{}\u4fe1\u606f\u5931\u8d25\uff01", (Object)entity.getProjectId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ProjectPoolSetVO project = (ProjectPoolSetVO)prjResp.getData();
        if (null == project) {
            this.logger.error("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76eeid-{}\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)entity.getProjectId());
            throw new BusinessException("\u63a8\u9001\u5206\u5305\u53d1\u7968\u767b\u8bb0\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        CommonResponse supplierResp = this.matSupplierApi.getOneById(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getSupplierId(), (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-" + entity.getSupplierId() + "\u4fe1\u606f\u5931\u8d25");
        }
        MatSupplierVO supplier = (MatSupplierVO)supplierResp.getData();
        if (null == supplier) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-{}\u4e3a\u7a7a", (Object)entity.getSupplierId());
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u4f9b\u5e94\u5546id-" + entity.getSupplierId() + "\u4fe1\u606f\u4e3a\u7a7a");
        }
        CommonResponse empResp = this.employeeApi.getById(Long.valueOf(entity.getAdminId()));
        if (!empResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)entity.getAdminId(), (Object)JSONObject.toJSONString((Object)supplierResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-" + entity.getAdminId() + "\u4fe1\u606f\u5931\u8d25");
        }
        EmployeeVO emp = (EmployeeVO)empResp.getData();
        if (null == emp) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-{}\u4e3a\u7a7a", (Object)entity.getAdminId());
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u6838\u51c6\u4ebaid-" + entity.getAdminId() + "\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        entity.getDetailList().stream().forEach(detail -> {
            if (!invoiceIds.contains(detail.getInvoiceId())) {
                invoiceIds.add(detail.getInvoiceId());
            }
        });
        List<ErpInvoiceEntity> invoiceList = this.erpInvoiceService.getAllByIds(invoiceIds);
        List<ErpInvoiceDetailEntity> invoiceDetailList = this.invoiceDetailService.getAllByInvoiceIds(invoiceIds);
        if (CollectionUtils.isEmpty(invoiceList)) {
            this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968ids-{}\u4fe1\u606f\u4e3a\u7a7a", (Object)JSONObject.toJSONString(invoiceIds));
            throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u83b7\u53d6\u5bf9\u5e94\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
        HashMap<Long, ErpInvoiceDetailEntity> invoiceDetailMap = new HashMap<Long, ErpInvoiceDetailEntity>();
        HashMap<Long, ErpInvoiceEntity> invoiceMap = new HashMap<Long, ErpInvoiceEntity>();
        if (CollectionUtils.isNotEmpty(invoiceDetailList)) {
            invoiceDetailMap.putAll(invoiceDetailList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        if (CollectionUtils.isNotEmpty(invoiceList)) {
            invoiceMap.putAll(invoiceList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        data.put("Company_Sid", (Object)supplier.getThirdSourceId());
        data.put("MeContract_Money", (Object)ComputeUtil.safeAdd(entity.getMainContMny(), entity.getChildContMny()).toPlainString());
        data.put("MeOrderMoney", (Object)ComputeUtil.safeAdd(entity.getOrderMny(), BigDecimal.ZERO).toPlainString());
        data.put("BillTitle", (Object)entity.getInvoiceHeader());
        data.put("IsDK", (Object)entity.getTaxCreateState().toString());
        data.put("IsDKValue", (Object)(Integer.valueOf("1").equals(entity.getTaxCreateState()) ? "\u662f" : "\u5426"));
        data.put("BillType", PlanConstant.INVOICE_TYPE.get(entity.getInvoiceCty()));
        data.put("TaxType", (Object)entity.getTaxCtyName());
        data.put("TaxRate", (Object)ComputeUtil.safeAdd(entity.getInvoiceRate(), BigDecimal.ZERO).toPlainString());
        data.put("NoTaxAmount", (Object)ComputeUtil.safeAdd(entity.getTotalMny(), BigDecimal.ZERO).toPlainString());
        data.put("TaxAmount", (Object)ComputeUtil.safeAdd(entity.getTotalTax(), BigDecimal.ZERO).toPlainString());
        data.put("BillMoney", (Object)ComputeUtil.safeAdd(entity.getTotalTaxMny(), BigDecimal.ZERO).toPlainString());
        data.put("IsAdvancePayment", (Object)entity.getPreState());
        data.put("IsAdvancePaymentValue", (Object)(Integer.valueOf(1).equals(entity.getPreState()) ? "\u662f" : "\u5426"));
        data.put("Memo", (Object)entity.getMemo());
        data.put("Ma_id", (Object)entity.getBillCode());
        data.put("Register_Name", (Object)entity.getOperateName());
        data.put("SYS_Created", (Object)sdf.format(entity.getCreateTime()));
        data.put("ApprHuman", (Object)emp.getName());
        data.put("ApprHuman_sid", (Object)emp.getSourceId());
        data.put("CON_EMP_NUM", (Object)emp.getCode());
        data.put("ApprDate", (Object)sdf.format(null != entity.getUpdateTime() ? entity.getUpdateTime() : new Date()));
        data.put("Position_Name", (Object)emp.getPostName());
        data.put("Division_Name", (Object)emp.getDeptName());
        data.put("Org_Name", (Object)emp.getOrgName());
        data.put("YQL_SID", (Object)entity.getId());
        data.put("SubContractInfo_Sid", (Object)contract.getSourceContractId());
        data.put("Project_Id", (Object)project.getCode());
        data.put("Project_Name", (Object)project.getName());
        data.put("Account_Project_Sid", (Object)project.getSourceId());
        data.put("Company_Name", (Object)contract.getSupplierName());
        JSONArray detailList = new JSONArray();
        data.put("MEBill_SubCList", (Object)detailList);
        JSONObject detailJson = null;
        ErpInvoiceDetailEntity tmpDetail = null;
        ErpInvoiceEntity invoice = null;
        for (MatInvoiceDetailEntity detail2 : entity.getDetailList()) {
            detailJson = new JSONObject();
            tmpDetail = (ErpInvoiceDetailEntity)((Object)invoiceDetailMap.get(detail2.getInvoiceDetailId()));
            if (null == tmpDetail) {
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968[id-" + detail2.getMainId() + "]\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u53d1\u7968\u8be6\u60c5id-" + detail2.getInvoiceDetailId() + "\u4fe1\u606f");
            }
            invoice = (ErpInvoiceEntity)((Object)invoiceMap.get(detail2.getInvoiceId()));
            if (null == invoice) {
                throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0[id-" + detail2.getMainId() + "]\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u53d1\u7968id-" + detail2.getInvoiceId() + "\u4fe1\u606f");
            }
            detailJson.put("InvoiceDM", (Object)invoice.getCode());
            detailJson.put("InvoiceHM", (Object)invoice.getNumber());
            detailJson.put("KPDate", (Object)(null != invoice.getInvoiceDate() ? sdf.format(invoice.getInvoiceDate()) : ""));
            detailJson.put("InvoiceTT", (Object)invoice.getInvoiceTitle());
            detailJson.put("GoodsName", (Object)tmpDetail.getDetailName());
            detailJson.put("InvoiceType", (Object)invoice.getTypeCode());
            detailJson.put("InvoiceTypeValue", (Object)invoice.getTypeName());
            detailJson.put("ModelNorm", (Object)tmpDetail.getDetailSpec());
            detailJson.put("MeteringUnit", (Object)tmpDetail.getDetailUnitName());
            detailJson.put("Quantity", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailNum(), BigDecimal.ZERO).toPlainString());
            detailJson.put("Price", (Object)ComputeUtil.safeDiv(tmpDetail.getDetailMny(), tmpDetail.getDetailNum()).toPlainString());
            detailJson.put("TaxRate", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailRate(), BigDecimal.ZERO).toPlainString());
            detailJson.put("Money", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailMny(), BigDecimal.ZERO).toPlainString());
            detailJson.put("TaxMoney", (Object)ComputeUtil.safeAdd(tmpDetail.getDetailTax(), BigDecimal.ZERO).toPlainString());
            detailJson.put("MoneyTax", (Object)ComputeUtil.safeAdd(tmpDetail.getInvoiceMny(), BigDecimal.ZERO).toPlainString());
            detailJson.put("PS_InvoiceInfo_FK", (Object)tmpDetail.getInvoiceSid());
            detailJson.put("YQL_SID", (Object)detail2.getId());
            detailList.add((Object)detailJson);
        }
        JSONArray attaches = new JSONArray();
        data.put("ArchivesInforList", (Object)attaches);
        JSONObject tmpFileJson = null;
        if (CollectionUtils.isNotEmpty(entity.getFileList())) {
            List sourceIds = entity.getFileList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            JSONObject params = new JSONObject();
            params.put("sourceIds", sourceIds);
            CommonResponse attachResp = this.attachmentApi.queryAllBySourceIdList(params);
            if (!attachResp.isSuccess()) {
                this.logger.error("\u6839\u636esourceId\u5217\u8868-{}\u67e5\u8be2\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(sourceIds), (Object)JSONObject.toJSONString((Object)attachResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            } else {
                HashMap<Long, AttachmentVO> attachMap = new HashMap<Long, AttachmentVO>();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)attachResp.getData()))) {
                    attachMap.putAll(((List)attachResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
                }
                AttachmentVO tmpAttach = null;
                for (MatInvoiceFileEntity tmpFile : entity.getFileList()) {
                    tmpAttach = (AttachmentVO)attachMap.get(tmpFile.getId());
                    if (null == tmpAttach) {
                        this.logger.error("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5sourceId-{}\u4fe1\u606f", (Object)tmpFile.getId());
                        throw new BusinessException("\u63a8\u9001\u91c7\u8d2d\u53d1\u7968\u5931\u8d25\uff0c\u6ca1\u6709\u5339\u914d\u7684\u5e94\u53d1\u7968\u9644\u4ef6\u8be6\u60c5\u4fe1\u606f");
                    }
                    tmpFileJson = new JSONObject();
                    tmpFileJson.put("Attach_Name", (Object)(StringUtils.isBlank((CharSequence)tmpFile.getFileName()) ? tmpAttach.getFileName() : tmpFile.getFileName() + (tmpFile.getFileName().indexOf(".") < 0 ? tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")) : "")));
                    tmpFileJson.put("Attach_Type", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".") + 1));
                    tmpFileJson.put("Attach_Extension", (Object)tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")));
                    tmpFileJson.put("AttachBase64", (Object)(this.BASE_HOST + "filepreview/" + tmpAttach.getFilePath()));
                    tmpFileJson.put("YQL_SID", (Object)tmpFile.getId());
                    tmpFileJson.put("Is_Add_Del", (Object)1);
                    try {
                        if (StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Name")) && StringUtils.isNotBlank((CharSequence)tmpFileJson.getString("Attach_Extension")) && !tmpFileJson.getString("Attach_Name").toLowerCase().endsWith(tmpFileJson.getString("Attach_Extension").toLowerCase())) {
                            tmpFileJson.put("Attach_Name", (Object)(tmpFileJson.getString("Attach_Name") + tmpFileJson.getString("Attach_Extension")));
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u91c7\u8d2d\u53d1\u7968\u9644\u4ef6id-{}\u5904\u7406\u540e\u7f00\u540d\u79f0\u5f02\u5e38:", (Object)tmpFile.getId(), (Object)e);
                    }
                    attaches.add((Object)tmpFileJson);
                }
            }
        }
        return resp;
    }
}

