/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialPropertyRelationEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialSourceEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialMapper;
import com.ejianc.business.zdsmaterial.material.service.ICommonSNService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialPropertyRelationService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialSourceService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.util.DetailIndexExcelReader2;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="materialService")
public class MaterialServiceImpl
extends BaseServiceImpl<MaterialMapper, MaterialEntity>
implements IMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialPropertyRelationService materialPropertyRelationService;
    @Autowired
    private MaterialMapper mapper;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_TYPE_CODE = "EJCBT202311000003";
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ICommonSNService commonSNService;
    private final String propertySeperator = "\uff1b";
    private final String propertyNameValueSep = "\uff1a";
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;
    private final String MATERIAL_NEED_AUDIT_PARAM = "P-GS7K600001";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IMaterialSourceService materialSourceService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Override
    public List<MaterialVO> queryListByCategoryId(List<Long> categoryIds) {
        List<Object> resp = new ArrayList<MaterialVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialVO> getByCodes(List<String> codes) {
        List<Object> resp = new ArrayList<MaterialVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"code", codes);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        List list = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resp = BeanMapper.mapList((Iterable)list, MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialVO> checkUnitAndProperty(List<MaterialVO> saveOrUpdateVOs, boolean checkId) {
        Map<Long, List<MaterialVO>> categoryUnitIdMap = saveOrUpdateVOs.stream().collect(Collectors.groupingBy(MaterialVO::getCategoryId));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.and(q -> {
            for (Long categoryId : categoryUnitIdMap.keySet()) {
                q.or(qs -> (QueryWrapper)((QueryWrapper)qs.eq((Object)"category_id", (Object)categoryId)).and(qss -> {
                    for (MaterialVO m : (List)categoryUnitIdMap.get(categoryId)) {
                        if (null != m.getId() && checkId) {
                            qss.or(qssi -> {
                                ((QueryWrapper)((QueryWrapper)qssi.eq((Object)"name", (Object)m.getName())).eq((Object)"unit_id", (Object)m.getUnitId())).ne((Object)"id", (Object)m.getId());
                                if (StringUtils.isNotBlank((CharSequence)m.getPropertyShowName())) {
                                    qssi.isNull((Object)"property_show_name");
                                } else {
                                    qssi.eq((Object)"property_show_name", (Object)m.getPropertyShowName());
                                }
                                return qssi;
                            });
                            continue;
                        }
                        qss.or(qssi -> {
                            ((QueryWrapper)qssi.eq((Object)"name", (Object)m.getName())).eq((Object)"unit_id", (Object)m.getUnitId());
                            if (StringUtils.isNotBlank((CharSequence)m.getPropertyShowName())) {
                                qssi.isNull((Object)"property_show_name");
                            } else {
                                qssi.eq((Object)"property_show_name", (Object)m.getPropertyShowName());
                            }
                            return qssi;
                        });
                    }
                    return qss;
                }));
            }
            return q;
        });
        List dbList = super.list((Wrapper)query);
        return BeanMapper.mapList((Iterable)dbList, MaterialVO.class);
    }

    @Override
    public List<MaterialVO> saveOrUpdateMaterials(List<MaterialVO> saveOrUpdateVOs) {
        boolean saveRelationSuc;
        ArrayList<Long> delRelationMaterialIds = new ArrayList<Long>();
        saveOrUpdateVOs.stream().forEach(item -> {
            if (null != item.getId()) {
                delRelationMaterialIds.add(item.getId());
            } else {
                item.setId(Long.valueOf(IdWorker.getId()));
                item.setValidFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode());
            }
            item.getRelationList().forEach(r -> {
                r.setMaterialId(item.getId());
                r.setId(null);
                r.setCreateUserCode(null);
                r.setCreateTime(null);
                r.setUpdateUserCode(null);
                r.setUpdateTime(null);
                r.setRowState("add");
            });
        });
        if (CollectionUtils.isNotEmpty(delRelationMaterialIds)) {
            this.materialPropertyRelationService.deleteByMaterialIds(delRelationMaterialIds);
        }
        List saveList = BeanMapper.mapList(saveOrUpdateVOs, MaterialEntity.class);
        ArrayList saveRelations = new ArrayList();
        saveList.stream().filter(s -> CollectionUtils.isNotEmpty(s.getRelationList())).forEach(m -> saveRelations.addAll(m.getRelationList()));
        boolean saveSuc = super.saveOrUpdateBatch(saveList, saveList.size(), false);
        if (!saveSuc) {
            throw new BusinessException("\u4fdd\u5b58\u7269\u8d44\u660e\u7ec6\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty(saveRelations) && !(saveRelationSuc = this.materialPropertyRelationService.saveOrUpdateBatch(saveRelations, saveList.size(), false))) {
            throw new BusinessException("\u4fdd\u5b58\u7269\u8d44\u660e\u7ec6\u5c5e\u6027\u5173\u7cfb\u5931\u8d25\uff01");
        }
        return BeanMapper.mapList((Iterable)saveList, MaterialVO.class);
    }

    @Override
    public void deleteBatch(List<Long> ids) {
        this.materialPropertyRelationService.deleteByMaterialIds(ids);
        super.removeByIds(ids);
    }

    @Override
    public List<MaterialVO> queryDetailList(List<Long> ids, boolean queryRelations) {
        List<MaterialPropertyRelationVO> relations;
        ArrayList<MaterialVO> resp = new ArrayList();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        List entities = super.list((Wrapper)query);
        resp = BeanMapper.mapList((Iterable)entities, MaterialVO.class);
        if (queryRelations && CollectionUtils.isNotEmpty(relations = this.materialPropertyRelationService.getAllByMaterialIds(ids))) {
            Map<Long, List<MaterialPropertyRelationVO>> materialRelationMap = relations.stream().collect(Collectors.groupingBy(MaterialPropertyRelationVO::getMaterialId));
            resp.stream().forEach(m -> {
                if (materialRelationMap.containsKey(m.getId())) {
                    m.setRelationList((List)materialRelationMap.get(m.getId()));
                }
                m.setOldUnitId(m.getUnitId());
                m.setOldPropertyShowName(m.getPropertyShowName());
            });
        }
        return resp;
    }

    @Override
    public long countMaterial(Map<String, Object> params) {
        return this.mapper.countMaterial(params);
    }

    @Override
    public List<MaterialVO> pageList(Map<String, Object> params) {
        return this.mapper.pageList(params);
    }

    @Override
    public List<MaterialVO> materialCheck(List<MaterialVO> checkVos, boolean generateCode) {
        List<MaterialVO> codeList;
        Iterator<String> ite;
        List<String> codes;
        List<MaterialVO> matchVos = this.checkUnitAndProperty(checkVos, false);
        Map<String, MaterialVO> matchMap = matchVos.parallelStream().collect(Collectors.toMap(item -> item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)item.getPropertyShowName()) ? item.getPropertyShowName() : ""), item -> item));
        ArrayList<MaterialVO> resp = new ArrayList<MaterialVO>();
        ArrayList<MaterialVO> emptyCodeList = new ArrayList<MaterialVO>();
        MaterialVO matchVo = null;
        HashMap codeMap = new HashMap();
        List checkIds = checkVos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", checkIds);
        List dbList = super.list((Wrapper)query);
        List dbIdList = dbList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        HashMap<String, String> materialCodeMap = new HashMap<String, String>();
        for (MaterialVO material : checkVos) {
            matchVo = matchMap.get(material.getName() + material.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)material.getPropertyShowName()) ? material.getPropertyShowName() : ""));
            if (null != matchVo) {
                matchVo.setMatchFlag(true);
                matchVo.setHasNewPropertyVal(Integer.valueOf(0));
                resp.add(matchVo);
                continue;
            }
            material.setMatchFlag(false);
            material.setId(Long.valueOf(IdWorker.getId()));
            emptyCodeList.add(material);
            resp.add(material);
        }
        if (generateCode && emptyCodeList.size() > 0) {
            String code = ((MaterialVO)emptyCodeList.get(0)).getCategoryCode();
            if (StringUtils.isBlank((CharSequence)code)) {
                Long categoryId = ((MaterialVO)emptyCodeList.get(0)).getCategoryId();
                MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.materialCategoryService.selectById(categoryId));
                code = category.getCode();
            }
            codes = this.generateMaterialCodeBatch(code, emptyCodeList.size());
            ite = codes.iterator();
            for (MaterialVO item2 : emptyCodeList) {
                if (StringUtils.isBlank((CharSequence)item2.getCategoryCode())) {
                    item2.setCategoryCode(code);
                }
                if (materialCodeMap.containsKey(item2.getCategoryId().toString() + item2.getName() + item2.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)item2.getPropertyShowName()) ? item2.getPropertyShowName() : ""))) {
                    item2.setCode((String)materialCodeMap.get(item2.getCategoryId().toString() + item2.getName() + item2.getUnitId().toString() + item2.getPropertyShowName()));
                    continue;
                }
                item2.setCode(ite.next());
                materialCodeMap.put(item2.getCategoryId().toString() + item2.getName() + item2.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)item2.getPropertyShowName()) ? item2.getPropertyShowName() : ""), item2.getCode());
            }
        }
        if (MapUtils.isNotEmpty(codeMap) && CollectionUtils.isNotEmpty(codeList = this.getByCodes(new ArrayList<String>(codeMap.keySet())))) {
            codes = this.generateMaterialCodeBatch(codeList.get(0).getCategoryCode(), codeList.size());
            ite = codes.iterator();
            codeList.stream().forEach(item -> ((MaterialVO)codeMap.get(item.getCode())).setCode((String)ite.next()));
        }
        return resp;
    }

    @Override
    public void updateMaterialStatusByCategory(List<Long> categoryIds, Integer blockStatus, Integer enabled, Integer beforeBlockStatus, String newCategoryName, List<Long> excludeMaterialIds) {
        this.mapper.updateMaterialStatusByCategory(categoryIds, blockStatus, enabled, beforeBlockStatus, newCategoryName, CollectionUtils.isNotEmpty(excludeMaterialIds) ? excludeMaterialIds : null, InvocationInfoProxy.getUsercode());
    }

    @Override
    public void updateCategoryName(Long categoryId, String newCategoryName, List<Long> noIncludeMaterialIds) {
        this.mapper.updateCategoryName(categoryId, newCategoryName, CollectionUtils.isNotEmpty(noIncludeMaterialIds) ? noIncludeMaterialIds : null, InvocationInfoProxy.getUsercode());
    }

    @Override
    public List<Long> updateMaterialByProperty(List<Long> stopUsePropertyIds, String newCategoryName, Integer enabled, Integer blockFlag) {
        List<Object> materialIds = new ArrayList();
        List<MaterialPropertyRelationVO> relations = this.materialPropertyRelationService.getAllByPropertyIds(stopUsePropertyIds);
        materialIds = relations.stream().map(MaterialPropertyRelationVO::getMaterialId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialIds)) {
            this.mapper.updateMaterialEnableStatus(materialIds, newCategoryName, enabled, blockFlag, InvocationInfoProxy.getUsercode());
        }
        return materialIds;
    }

    @Override
    public List<MaterialVO> addNewMaterialsFromBill(List<MaterialVO> dataList) {
        this.logger.info("\u5f85\u5904\u7406\u65b0\u589e\u7269\u8d44\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString(dataList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        ArrayList<MaterialVO> resp = new ArrayList<MaterialVO>();
        List<MaterialVO> exsistList = this.checkUnitAndProperty(dataList, false);
        ArrayList<MaterialVO> saveList = new ArrayList<MaterialVO>();
        Map<String, MaterialVO> exsitMap = exsistList.stream().collect(Collectors.toMap(item -> item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)item.getPropertyShowName()) ? item.getPropertyShowName() : ""), item -> item));
        ArrayList<Object> saveSourceVos = new ArrayList<Object>();
        ArrayList<String> codeList = new ArrayList<String>(dataList.stream().map(MaterialVO::getCode).collect(Collectors.toSet()));
        Set<Object> existsCode = new HashSet();
        if (CollectionUtils.isNotEmpty(codeList)) {
            List<MaterialVO> dbCodeList = this.getByCodes(codeList);
            existsCode = dbCodeList.stream().map(MaterialVO::getCode).collect(Collectors.toSet());
        }
        Integer materialValidFlag = ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode();
        CommonResponse response = this.paramConfigApi.getByCode("P-GS7K600001");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u83b7\u53d6\u4e1a\u52a1\u5355\u636e\u63a8\u9001\u6765\u7684\u7269\u8d44\u662f\u5426\u9700\u8981\u51c6\u5165\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        } else {
            materialValidFlag = "1".equals(((ParamRegisterSetVO)response.getData()).getValueData()) ? ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u5426.getCode() : ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode();
        }
        MaterialVO tmpMaterial = null;
        MaterialSourceVO sourceInfo = null;
        ArrayList<MaterialVO> emptyCodeList = new ArrayList<MaterialVO>();
        ArrayList<Long> validPropertyValIds = new ArrayList<Long>();
        ArrayList saveRelationVos = new ArrayList();
        HashSet<Long> sourceIds = new HashSet<Long>();
        ArrayList<String> repeatItem = new ArrayList<String>();
        for (MaterialVO material : dataList) {
            tmpMaterial = exsitMap.get(material.getName() + material.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)material.getPropertyShowName()) ? material.getPropertyShowName() : ""));
            if (null != tmpMaterial) {
                resp.add(tmpMaterial);
                tmpMaterial.setUpdateTime(new Date());
                tmpMaterial.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                saveList.add(tmpMaterial);
                if (ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode().equals(tmpMaterial.getValidFlag())) continue;
                tmpMaterial.setValidFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u5426.getCode());
                sourceInfo = (MaterialSourceVO)material.getSourceList().get(0);
                sourceInfo.setMaterialId(tmpMaterial.getId());
                saveSourceVos.add(sourceInfo);
                sourceIds.add(sourceInfo.getSourcePid());
                continue;
            }
            if (repeatItem.contains(material.getName() + material.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)material.getPropertyShowName()) ? material.getPropertyShowName() : ""))) continue;
            repeatItem.add(material.getName() + material.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)material.getPropertyShowName()) ? material.getPropertyShowName() : ""));
            material.setValidFlag(materialValidFlag);
            if (CollectionUtils.isNotEmpty((Collection)material.getRelationList())) {
                material.getRelationList().stream().forEach(relation -> {
                    relation.setMaterialId(material.getId());
                    relation.setCategoryId(material.getCategoryId());
                    if (null != relation.getHasNewPropertyVal() && 1 == relation.getHasNewPropertyVal()) {
                        validPropertyValIds.add(relation.getPropertyItemId());
                    }
                    saveRelationVos.add(relation);
                });
            }
            if (existsCode.contains(material.getCode())) {
                material.setCode(null);
            } else {
                existsCode.add(material.getCode());
            }
            if (StringUtils.isBlank((CharSequence)material.getCode())) {
                emptyCodeList.add(material);
            }
            saveSourceVos.add(material.getSourceList().get(0));
            saveList.add(material);
            sourceIds.add(((MaterialSourceVO)material.getSourceList().get(0)).getSourcePid());
        }
        if (CollectionUtils.isNotEmpty(sourceIds)) {
            this.materialSourceService.deleteBySourceIds(new ArrayList<Long>(sourceIds));
        }
        if (CollectionUtils.isNotEmpty(emptyCodeList)) {
            List<String> codes = this.generateMaterialCodeBatch(((MaterialVO)emptyCodeList.get(0)).getCategoryCode(), emptyCodeList.size());
            Iterator<String> ite = codes.iterator();
            emptyCodeList.stream().forEach(item -> item.setCode((String)ite.next()));
        }
        if (CollectionUtils.isNotEmpty(saveRelationVos)) {
            this.materialPropertyRelationService.saveOrUpdateBatch(BeanMapper.mapList(saveRelationVos, MaterialPropertyRelationEntity.class), saveRelationVos.size(), false);
        }
        if (CollectionUtils.isNotEmpty(saveSourceVos)) {
            Set<String> userCodes = saveSourceVos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getSourceCreateUserCode()) && StringUtils.isBlank((CharSequence)item.getSourceCreateUserName())).map(item -> item.getSourceCreateUserCode()).collect(Collectors.toSet());
            HashMap<String, String> userNameMap = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty(userCodes)) {
                CommonResponse userResp = this.userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
                if (!userResp.isSuccess() || null == userResp.getData()) {
                    this.logger.info("\u6839\u636e\u7528\u6237\u7f16\u7801\u5217\u8868-{}\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString(userCodes));
                } else {
                    userNameMap.putAll(((List)userResp.getData()).stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item.getUserName())));
                }
            }
            if (!userNameMap.isEmpty()) {
                saveSourceVos.stream().filter(item -> userNameMap.containsKey(item.getSourceCreateUserCode())).forEach(item -> item.setSourceCreateUserName((String)userNameMap.get(item.getSourceCreateUserCode())));
            }
            this.materialSourceService.saveOrUpdateBatch(BeanMapper.mapList(saveSourceVos, MaterialSourceEntity.class), saveSourceVos.size(), false);
        }
        if (CollectionUtils.isNotEmpty(validPropertyValIds)) {
            this.propertySubItemService.updatePropertyItemsValidFlag(validPropertyValIds, ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u662f.getCode());
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            List materials = BeanMapper.mapList(saveList, MaterialEntity.class);
            super.saveOrUpdateBatch(materials, materials.size(), false);
            resp.addAll(BeanMapper.mapList((Iterable)materials, MaterialVO.class));
        }
        return resp;
    }

    @Override
    public List<MaterialVO> deleteMaterialsFromBill(List<Long> sourceIds) {
        ArrayList<MaterialVO> resp = new ArrayList<MaterialVO>();
        this.materialSourceService.deleteBySourceIds(sourceIds);
        return resp;
    }

    @Override
    public List<String> generateMaterialCodeBatch(String categoryCode, int count) {
        return this.commonSNService.generateSnList(categoryCode, count, null);
    }

    @Override
    public List<Long> updatePropertyAndValues(List<MaterialCategoryPropertyEntity> changedProperty, List<MaterialCategoryPropertySubItemEntity> changeNameValues, List<Long> delPropertyValueIds, String newCategoryName) {
        ArrayList<Long> updateMaterialIds = new ArrayList<Long>();
        ArrayList updateList = new ArrayList();
        HashMap propertyMap = new HashMap();
        HashMap propertyValueMap = new HashMap();
        Set materialIds = null;
        HashSet<Long> stopUseMaterialIds = new HashSet<Long>();
        HashSet<Long> blockedMaterialIds = new HashSet<Long>();
        ArrayList<Long> quoteMaterialIds = new ArrayList<Long>();
        ArrayList<MaterialPropertyRelationVO> relationUpdateList = new ArrayList<MaterialPropertyRelationVO>();
        if (CollectionUtils.isNotEmpty(changedProperty)) {
            propertyMap.putAll(changedProperty.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity())));
        }
        if (CollectionUtils.isNotEmpty(changeNameValues)) {
            propertyValueMap.putAll(changeNameValues.parallelStream().collect(Collectors.toMap(item -> item.getId(), Function.identity())));
        }
        List<MaterialPropertyRelationVO> relations = null;
        if (MapUtils.isNotEmpty(propertyMap)) {
            relations = this.materialPropertyRelationService.getAllByCategoryId(changedProperty.get(0).getCategoryId());
        } else if (MapUtils.isNotEmpty(propertyValueMap)) {
            relations = this.materialPropertyRelationService.getAllByCategoryId(changeNameValues.get(0).getCategoryId());
        }
        if (CollectionUtils.isNotEmpty(relations)) {
            List<MaterialCategoryPropertyVO> allPropertys = this.propertyService.getAllByCategoryId(relations.get(0).getCategoryId(), ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            Map<Long, MaterialCategoryPropertyVO> propertysMap = allPropertys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            if (CollectionUtils.isNotEmpty(relations)) {
                materialIds = relations.stream().filter(item -> propertyMap.containsKey(item.getPropertyId()) || propertyValueMap.containsKey(item.getPropertyItemId())).map(MaterialPropertyRelationVO::getMaterialId).collect(Collectors.toSet());
                CommonResponse quoteResp = this.billTypeApi.checkQuotes(BILL_TYPE_CODE, new ArrayList(materialIds));
                if (!quoteResp.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u7269\u8d44\u5f15\u7528\u60c5\u51b5\u5931\u8d25");
                }
                Map quoteResult = (Map)quoteResp.getData();
                this.logger.debug("*****\u67e5\u8be2\u5230\u7269\u8d44\u5f15\u7528\u60c5\u51b5****\uff1a{}", (Object)JSONObject.toJSONString((Object)quoteResult));
                for (String billId : quoteResult.keySet()) {
                    if (!"true".equals(quoteResult.get(billId))) continue;
                    quoteMaterialIds.add(Long.valueOf(billId));
                }
                MaterialCategoryPropertyEntity property = null;
                MaterialCategoryPropertySubItemEntity propertyValue = null;
                for (MaterialPropertyRelationVO relation : relations) {
                    if (!propertysMap.containsKey(relation.getPropertyId())) continue;
                    relation.setPropertyName(propertysMap.get(relation.getPropertyId()).getName());
                    property = (MaterialCategoryPropertyEntity)((Object)propertyMap.get(relation.getPropertyId()));
                    propertyValue = (MaterialCategoryPropertySubItemEntity)((Object)propertyValueMap.get(relation.getPropertyItemId()));
                    if (null != property) {
                        relation.setPropertyName(property.getName());
                        relation.setPropertySequence(property.getSequence());
                        relation.setProductCodeFlag(property.getProductCodeFlag());
                        relationUpdateList.add(relation);
                    }
                    if (null == propertyValue) continue;
                    if (delPropertyValueIds.contains(relation.getPropertyItemId())) {
                        stopUseMaterialIds.add(relation.getMaterialId());
                        if (!quoteMaterialIds.contains(relation.getMaterialId())) continue;
                        blockedMaterialIds.add(relation.getMaterialId());
                        continue;
                    }
                    if (quoteMaterialIds.contains(relation.getMaterialId())) {
                        stopUseMaterialIds.add(relation.getMaterialId());
                        blockedMaterialIds.add(relation.getMaterialId());
                        continue;
                    }
                    relation.setProductCode(propertyValue.getProductCode());
                    relation.setPropertyValue(propertyValue.getName());
                    if (relationUpdateList.contains(relation)) continue;
                    relationUpdateList.add(relation);
                }
                Map<Long, String> materialRelationMap = relations.stream().map(item -> {
                    if (null == item.getPropertySequence()) {
                        item.setPropertySequence(((MaterialCategoryPropertyVO)propertysMap.get(item.getPropertyId())).getSequence());
                    }
                    return item;
                }).sorted(Comparator.comparingInt(MaterialPropertyRelationVO::getPropertySequence)).collect(Collectors.groupingBy(MaterialPropertyRelationVO::getMaterialId, Collectors.mapping(item -> item.getPropertyName() + "\uff1a" + item.getPropertyValue(), Collectors.joining("\uff1b"))));
                Map<Long, String> materialProductMap = relations.stream().map(item -> {
                    if (null == item.getPropertySequence()) {
                        item.setPropertySequence(((MaterialCategoryPropertyVO)propertysMap.get(item.getPropertyId())).getSequence());
                    }
                    return item;
                }).filter(item -> ZDSMaterialCommonEnums.\u5c5e\u6027\u5206\u7c7b\u662f\u5426\u542f\u7528\u4ea7\u54c1\u4ee3\u7801_\u662f.getCode().equals(item.getProductCodeFlag()) && StringUtils.isNotBlank((CharSequence)item.getProductCode())).sorted(Comparator.comparingInt(MaterialPropertyRelationVO::getPropertySequence)).collect(Collectors.groupingBy(MaterialPropertyRelationVO::getMaterialId, Collectors.mapping(item -> item.getProductCode(), Collectors.joining())));
                QueryWrapper query = new QueryWrapper();
                query.in((Object)"id", materialIds);
                query.in((Object)"blocked_flag", new Object[]{ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode()});
                List materialList = super.list((Wrapper)query);
                materialList.stream().filter(item -> materialRelationMap.containsKey(item.getId())).forEach(material -> {
                    if (stopUseMaterialIds.contains(material.getId())) {
                        material.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode());
                    }
                    if (blockedMaterialIds.contains(material.getId())) {
                        material.setBlockedFlag(ZDSMaterialCommonEnums.\u5c01\u5b58_\u5c01\u5b58.getCode());
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)newCategoryName)) {
                            material.setCategoryName(newCategoryName);
                        }
                        material.setPropertyShowName((String)materialRelationMap.get(material.getId()));
                        if (ZDSMaterialCommonEnums.\u7269\u6599\u81ea\u5b9a\u4e49\u4ea7\u54c1\u4ee3\u7801_\u5426.getCode().equals(material.getProductCodeCustomFlag())) {
                            material.setProductCode(materialProductMap.containsKey(material.getId()) ? (String)materialProductMap.get(material.getId()) : null);
                        }
                    }
                    updateList.add(material);
                    updateMaterialIds.add(material.getId());
                });
            }
            if (CollectionUtils.isNotEmpty(relationUpdateList)) {
                this.materialPropertyRelationService.saveOrUpdateBatch(BeanMapper.mapList(relationUpdateList, MaterialPropertyRelationEntity.class), relationUpdateList.size(), false);
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                super.saveOrUpdateBatch(updateList, updateList.size(), false);
            }
        }
        return updateMaterialIds;
    }

    @Override
    public List<Long> updateByPropertyValueDel(List<Long> delPropertyValueIds) {
        ArrayList<Long> resp = new ArrayList<Long>();
        List<MaterialPropertyRelationVO> relations = this.materialPropertyRelationService.getAllByPropertyValueIds(delPropertyValueIds);
        if (CollectionUtils.isNotEmpty(relations)) {
            List materialIds = relations.stream().map(item -> item.getMaterialId()).collect(Collectors.toList());
            ArrayList<Long> quoteMaterialIds = new ArrayList<Long>();
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"id", materialIds);
            query.in((Object)"blocked_flag", new Object[]{ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode()});
            List materialList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)materialList)) {
                CommonResponse quoteResp = this.billTypeApi.checkQuotes(BILL_TYPE_CODE, new ArrayList(materialIds));
                if (!quoteResp.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u7269\u8d44\u5f15\u7528\u60c5\u51b5\u5931\u8d25");
                }
                Map quoteResult = (Map)quoteResp.getData();
                this.logger.debug("*****\u67e5\u8be2\u5230\u7269\u8d44\u5f15\u7528\u60c5\u51b5****\uff1a{}", (Object)JSONObject.toJSONString((Object)quoteResult));
                for (String billId : quoteResult.keySet()) {
                    if (!"true".equals(quoteResult.get(billId))) continue;
                    quoteMaterialIds.add(Long.valueOf(billId));
                }
                for (MaterialEntity material : materialList) {
                    material.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u505c\u7528.getCode());
                    if (quoteMaterialIds.contains(material.getId())) {
                        material.setBlockedFlag(ZDSMaterialCommonEnums.\u5c01\u5b58_\u5c01\u5b58.getCode());
                    }
                    resp.add(material.getId());
                }
                super.saveOrUpdateBatch(materialList, materialList.size(), false);
            }
        }
        return resp;
    }

    @Override
    public void saveExcelImport(List<MaterialVO> saveImportVos) {
        ArrayList relationList = new ArrayList();
        ArrayList emptyCodeList = new ArrayList();
        saveImportVos.stream().forEach(material -> {
            material.setValidFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode());
            material.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            material.setBlockedFlag(ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode());
            relationList.addAll(material.getRelationList().stream().map(item -> {
                item.setMaterialId(material.getId());
                return item;
            }).collect(Collectors.toList()));
            if (StringUtils.isBlank((CharSequence)material.getCode())) {
                emptyCodeList.add(material);
            }
        });
        if (CollectionUtils.isNotEmpty(emptyCodeList)) {
            List<String> codes = this.commonSNService.generateSnList(((MaterialVO)emptyCodeList.get(0)).getCategoryCode(), emptyCodeList.size(), 9);
            Iterator<String> item = codes.iterator();
            for (MaterialVO m : emptyCodeList) {
                m.setCode(item.next());
            }
        }
        if (CollectionUtils.isNotEmpty(relationList)) {
            this.materialPropertyRelationService.saveOrUpdateBatch(BeanMapper.mapList(relationList, MaterialPropertyRelationEntity.class), relationList.size(), false);
        }
        super.saveOrUpdateBatch(BeanMapper.mapList(saveImportVos, MaterialEntity.class), saveImportVos.size(), false);
    }

    @Override
    public MaterialVO queryExitFlag(String name, String propertyShowName, String unitName, Long categoryId) {
        MaterialVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"name", (Object)name);
        query.eq((Object)"property_show_name", (Object)propertyShowName);
        query.eq((Object)"unit_name", (Object)unitName);
        query.eq((Object)"category_id", (Object)categoryId);
        MaterialEntity e = (MaterialEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            resp = (MaterialVO)BeanMapper.map((Object)((Object)e), MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialVO> queryExcelFlag(String name, String propertyShowName, String unitName, String categoryName) {
        List<Object> resp = new ArrayList<MaterialVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"name", (Object)name);
        query.eq((Object)"property_show_name", (Object)propertyShowName);
        query.eq((Object)"unit_name", (Object)unitName);
        query.eq((Object)"category_name", (Object)categoryName);
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<Long> getAllInvalidMaterialCategoryIds(String categoryName) {
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"DISTINCT(category_id) as category_id"});
        query.eq((Object)"valid_flag", (Object)ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u5426.getCode());
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)categoryName)) {
            query.like((Object)"category_name", (Object)categoryName);
        }
        return super.listObjs((Wrapper)query, item -> Long.valueOf(item.toString()));
    }

    @Override
    public void delInvalidMaterial(List<Long> ids) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"valid_flag", (Object)ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u4f5c\u5e9f.getCode());
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        super.update((Wrapper)update);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void materialBatchValid(List<Long> ids) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"valid_flag", (Object)ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode());
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        List<Long> getInValidPropertyItemIds = this.propertySubItemService.getInValidPropertyItemIds(ids);
        if (CollectionUtils.isNotEmpty(getInValidPropertyItemIds)) {
            this.propertySubItemService.validPropertyItems(getInValidPropertyItemIds);
        }
        super.update((Wrapper)update);
    }

    @Override
    public List<MaterialVO> saveFromInvalidMaterial(List<MaterialVO> saveList) {
        ArrayList<MaterialVO> resp = new ArrayList<MaterialVO>();
        List<Long> abandonIds = saveList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<MaterialVO> repeatList = this.checkUnitAndProperty(saveList, true);
        if (CollectionUtils.isNotEmpty(repeatList)) {
            if (repeatList.stream().filter(r -> ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode().equals(r.getValidFlag())).count() == 0L) {
                repeatList.stream().forEach(r -> r.setValidFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode()));
                this.saveOrUpdateBatch(BeanMapper.mapList(repeatList, MaterialEntity.class));
                resp.addAll(repeatList);
                Set repeatKey = repeatList.stream().map(item -> item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)item.getPropertyShowName()) ? item.getPropertyShowName() : "")).collect(Collectors.toSet());
                saveList = saveList.stream().filter(r -> !repeatKey.contains(r.getName() + r.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)r.getPropertyShowName()) ? r.getPropertyShowName() : ""))).collect(Collectors.toList());
                abandonIds.removeAll(saveList.stream().map(BaseVO::getId).collect(Collectors.toList()));
                repeatList.clear();
            }
            if (CollectionUtils.isNotEmpty(repeatList)) {
                String tip = repeatList.stream().filter(r -> ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode().equals(r.getValidFlag())).map(material -> {
                    StringBuilder sp = new StringBuilder();
                    return sp.append("\u540d\u79f0\uff1a").append(material.getName()).append(", \u5355\u4f4d\uff1a").append(material.getUnitName()).append(", \u5c5e\u6027\uff1a").append(material.getPropertyShowName()).toString();
                }).collect(Collectors.joining("; "));
                this.logger.error("\u672a\u751f\u6548\u7269\u8d44\u65b0\u589e\u4fdd\u5b58\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u7269\u8d44\uff1a{}", (Object)tip);
                throw new BusinessException("\u7269\u8d44\u3010" + tip + "\u3011\u5206\u7c7b\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            ArrayList<MaterialVO> saveData = new ArrayList<MaterialVO>();
            ArrayList updateData = new ArrayList();
            saveList.stream().forEach(item -> {
                item.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                item.setUpdateTime(new Date());
                if (item.getOldUnitId().equals(item.getUnitId()) && StringUtils.equals((CharSequence)item.getPropertyShowName(), (CharSequence)item.getOldPropertyShowName())) {
                    abandonIds.remove(item.getId());
                    item.setValidFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode());
                    updateData.add(item);
                } else {
                    this.clearInvalidData((BaseVO)item);
                    item.setValidFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode());
                    saveData.add((MaterialVO)item);
                }
            });
            if (CollectionUtils.isNotEmpty(saveData)) {
                resp.addAll(this.saveOrUpdateMaterials(saveData));
            }
            if (CollectionUtils.isNotEmpty(updateData)) {
                super.saveOrUpdateBatch((Collection)BeanMapper.mapList(updateData, MaterialEntity.class));
                resp.addAll(updateData);
            }
            if (CollectionUtils.isNotEmpty(abandonIds)) {
                this.delInvalidMaterial(abandonIds);
            }
        }
        return resp;
    }

    @Override
    public Long pageCount(Map<String, Object> pageParams) {
        return this.mapper.pageCount(pageParams);
    }

    @Override
    public List<MaterialVO> queryPage(Map<String, Object> pageParams) {
        return this.mapper.queryPage(pageParams);
    }

    private void clearInvalidData(BaseVO entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCreateUserCode(null);
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        boolean isFailed = false;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
        this.excelImportInfoData(resList.get(0));
        this.excelImportInfoData(resList.get(1));
        this.excelImportInfoData(resList.get(2));
        this.excelImportInfoData(resList.get(3));
        return CommonResponse.success((String)"\u5bfc\u51fa\u6210\u529f");
    }

    @Override
    public String beforeValidCheck(List<Long> ids) {
        return null;
    }

    private void excelImportInfoData(List<List<String>> result) {
        if (result != null && result.size() > 0) {
            HashMap<Long, String> idMap = new HashMap<Long, String>();
            ArrayList<MaterialCategoryPropertySubItemEntity> detailList = new ArrayList<MaterialCategoryPropertySubItemEntity>();
            for (int i = 0; i < result.size(); ++i) {
                List<String> dataList = result.get(i);
                Long id = Long.valueOf(dataList.get(2));
                String name = dataList.get(3);
                idMap.put(id, name);
                String detailName = dataList.get(4);
                String detailSort = dataList.get(5);
                MaterialCategoryPropertySubItemEntity detail = new MaterialCategoryPropertySubItemEntity();
                detail.setName(detailName);
                detail.setSequence(Integer.valueOf(detailSort));
                detail.setPropertyId(id);
                detail.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
                detail.setValidFlag(ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u662f.getCode());
                detailList.add(detail);
            }
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"id", new ArrayList(idMap.keySet()));
            List propertyList = this.propertyService.list((Wrapper)query);
            HashMap categoryIdMap = new HashMap();
            propertyList.stream().forEach(item -> {
                item.setName((String)idMap.get(item.getId()));
                categoryIdMap.put(item.getId(), item.getCategoryId());
            });
            this.propertyService.saveOrUpdateBatch(propertyList, propertyList.size(), false);
            detailList.stream().forEach(item -> item.setCategoryId((Long)categoryIdMap.get(item.getPropertyId())));
            this.propertySubItemService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
    }
}

