/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.out.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.out.bean.DisposeDetailEntity;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dispose/erp"})
public class DisposeErpController {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IDisposeService service;
    @Autowired
    private IDisposeDetailService detailService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IEmployeeApi employeeApi;
    private final String SYNC_ERP_REC_MNY_URL = "/cefoc/yql/getCollectionList";

    @PostMapping(value={"/pageList"})
    public CommonResponse<JSONObject> pageSyncList(@RequestBody JSONObject param) {
        List<MaterialCategoryVO> categorys;
        List empList;
        CommonResponse empResp;
        JSONObject resp = new JSONObject();
        this.logger.info("ERP\u67e5\u8be2\u5e9f\u65e7\u7269\u6599\u5904\u7f6e\u7533\u8bf7\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        Integer pageSize = null != param && null != param.getInteger("PageSize") ? param.getInteger("PageSize") : 10;
        Integer pageNum = null != param && null != param.getInteger("PageNum") ? param.getInteger("PageNum") : 1;
        String BeginDateTime = null != param && null != param.getString("BeginDateTime") ? param.getString("BeginDateTime") : null;
        String EndDateTime = null != param && null != param.getString("EndDateTime") ? param.getString("EndDateTime") : null;
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)BeginDateTime)) {
            queryParam.put("beginDateTime", BeginDateTime);
        }
        if (StringUtils.isNotBlank((CharSequence)EndDateTime)) {
            queryParam.put("endDateTime", EndDateTime);
        }
        int count = this.service.pageCount(queryParam);
        resp.put("total", (Object)count);
        resp.put("pageSize", (Object)pageSize);
        resp.put("pageNum", (Object)pageNum);
        if (count == 0) {
            resp.put("records", new ArrayList());
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
        }
        Integer startLine = pageNum - 1 < 0 ? pageSize : (pageNum - 1) * pageSize;
        queryParam.put("startLine", startLine);
        queryParam.put("pageSize", pageSize);
        List<JSONObject> pageList = this.service.pageList(queryParam);
        ArrayList projectIds = new ArrayList();
        ArrayList<Long> pIds = new ArrayList<Long>();
        ArrayList empIds = new ArrayList();
        ArrayList empCodes = new ArrayList();
        pageList.stream().forEach(item -> {
            if (!projectIds.contains(item.getLong("projectId"))) {
                projectIds.add(item.getLong("projectId"));
            }
            if (!pIds.contains(item.getLong("YQL_SID"))) {
                pIds.add(item.getLong("YQL_SID"));
            }
            if (!empIds.contains(item.getLong("ApplyHumanId"))) {
                empIds.add(item.getLong("ApplyHumanId"));
            }
            if (!empCodes.contains(item.getString("ApprHumanCode"))) {
                empCodes.add(item.getString("ApprHumanCode"));
            }
            item.put("DisposalMode", (Object)("1".equals(item.getString("DisposalMode")) ? "\u6218\u7565" : "\u8be2\u6bd4\u4ef7"));
        });
        CommonResponse projectResp = this.projectPoolApi.queryProjectByIds(projectIds);
        if (!projectResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u9879\u76eeId\u5217\u8868-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(projectIds), (Object)JSONObject.toJSONString((Object)projectResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        HashMap<Long, String> projectSidMap = new HashMap<Long, String>();
        List projectList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)projectResp.getData()), ProjectPoolSetVO.class);
        if (CollectionUtils.isNotEmpty((Collection)projectList)) {
            projectSidMap.putAll(projectList.stream().collect(Collectors.toMap(BaseVO::getId, ProjectPoolSetVO::getSourceId)));
        }
        HashMap empIdMap = new HashMap();
        HashMap empCodeMap = new HashMap();
        if (CollectionUtils.isNotEmpty(empIds)) {
            empResp = this.employeeApi.getByIds(empIds);
            if (!empResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u4eba\u5458id\u5217\u8868-{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(empIds), (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            empList = (List)empResp.getData();
            if (CollectionUtils.isNotEmpty((Collection)empList)) {
                empIdMap.putAll(empList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity())));
            }
        }
        if (CollectionUtils.isNotEmpty(empCodes)) {
            empResp = this.employeeApi.getAllByEmployeeCodes(empCodes);
            if (!empResp.isSuccess()) {
                this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25\uff0c\u6839\u636e\u4eba\u5458\u5de5\u53f7\u5217\u8868-{}\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(empCodes), (Object)JSONObject.toJSONString((Object)empResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            empList = (List)empResp.getData();
            if (CollectionUtils.isNotEmpty((Collection)empList)) {
                empCodeMap.putAll(empList.stream().collect(Collectors.toMap(EmployeeVO::getCode, Function.identity())));
            }
        }
        Map<Long, List<DisposeDetailEntity>> subDetailMap = this.detailService.getAllBySettleIds(pIds);
        HashMap<Long, String> categorySidMap = new HashMap<Long, String>();
        ArrayList<Long> categoryIds = new ArrayList<Long>(subDetailMap.values().stream().flatMap(Collection::stream).map(DisposeDetailEntity::getMaterialTypeId).collect(Collectors.toSet()));
        if (CollectionUtils.isNotEmpty(categoryIds) && CollectionUtils.isNotEmpty(categorys = this.categoryService.getAllByIds(categoryIds))) {
            categorySidMap.putAll(categorys.stream().collect(Collectors.toMap(BaseVO::getId, MaterialCategoryVO::getSourceId)));
        }
        EmployeeVO emp = null;
        for (JSONObject settle : pageList) {
            settle.put("Account_Project_Sid", projectSidMap.get(settle.getLong("projectId")));
            settle.remove((Object)"projectId");
            emp = (EmployeeVO)empIdMap.get(settle.getLong("ApplyHumanId"));
            settle.put("ApplyHuman_Sid", (Object)emp.getSourceId());
            settle.put("ApplyHuman", (Object)emp.getName());
            settle.remove((Object)"ApplyHumanId");
            emp = (EmployeeVO)empCodeMap.get(settle.getString("ApprHumanCode"));
            settle.put("ApprHuman_Sid", (Object)emp.getSourceId());
            settle.put("ApprHuman", (Object)emp.getName());
            settle.put("ApprDate", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settle.getDate("ApprDate")));
            settle.put("AppliyDate", (Object)DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)settle.getDate("AppliyDate")));
            JSONArray subDetailArr = new JSONArray();
            settle.put("SubDetailList", (Object)subDetailArr);
            if (null == subDetailMap.get(settle.getLong("YQL_SID"))) continue;
            JSONObject detailJson = null;
            int idx = 1;
            for (DisposeDetailEntity detail : subDetailMap.get(settle.getLong("YQL_SID"))) {
                detailJson = new JSONObject();
                detailJson.put("Number", (Object)idx++);
                detailJson.put("MaterialType", (Object)detail.getMaterialTypeName());
                detailJson.put("MaterialType_Sid", categorySidMap.get(detail.getMaterialTypeId()));
                detailJson.put("MaterialCode", (Object)detail.getMaterialCode());
                detailJson.put("MaterialName", (Object)detail.getMaterialName());
                detailJson.put("ProductCode", (Object)detail.getProductCode());
                detailJson.put("SpecificationsModels", (Object)detail.getPropertyValue());
                detailJson.put("MeteringUnit", (Object)(StringUtils.isNotBlank((CharSequence)detail.getUnitName()) ? detail.getUnitName() : ""));
                detailJson.put("MeteringUnitSid", (Object)(null != detail.getUnitId() ? ZDSInterfaceCommonUtil.changeLongToGUID(detail.getUnitId()) : "00000000-0000-0000-0000-000000000000"));
                detailJson.put("BrandName", (Object)detail.getBrandName());
                detailJson.put("Num", (Object)detail.getNum().toPlainString());
                detailJson.put("EstimatedDisposalTaxMny", (Object)detail.getTaxMny().toPlainString());
                detailJson.put("Quantity", null != detail.getSurplusNum() ? detail.getSurplusNum().toPlainString() : Integer.valueOf(0));
                detailJson.put("YQL_SID", (Object)detail.getId());
                subDetailArr.add((Object)detailJson);
            }
        }
        resp.put("records", pageList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"syncZdsDisposeRecMny"})
    public CommonResponse<String> syncZdsDisposeRecMny(@RequestBody JSONObject params) {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u73b0\u573a\u6536\u6b3e\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb,\u53c2\u6570\uff1a{}*********************", (Object)params.toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        HashMap<String, String> param = new HashMap<String, String>();
        boolean noDate = null != params && null != params.get((Object)"noDate") ? params.getBoolean("noDate") : false;
        Integer pageNum = null != params.get((Object)"pageNum") ? params.getInteger("pageNum") : 1;
        Integer pageSize = null != params.get((Object)"pageSize") ? params.getInteger("pageSize") : Integer.valueOf(ZDSInterfaceCommonUtil.getErpDataBatchSize());
        Object reqDateStr = null;
        String startDateStr = null;
        String endDateStr = null;
        if (null != params && null != params.get((Object)"startDate")) {
            startDateStr = params.getString("startDate");
            endDateStr = params.getString("endDate");
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        } else if (!noDate) {
            startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtil.addDays(new Date(), -1)) + " 00:00:00";
            endDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date()) + " 23:59:59";
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        }
        JSONObject reqJson = null;
        JSONArray pageData = null;
        boolean hasNext = true;
        try {
            Map<String, String> headers = ZDSInterfaceCommonUtil.getErpHeaders();
            param.put("PageSize", pageSize.toString());
            param.put("PageNum", pageNum.toString());
            while (hasNext) {
                this.logger.info("\u8bf7\u6c42ERP\u73b0\u573a\u6536\u6b3e\uff1aurl-{},\u53c2\u6570-{}", (Object)(ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getCollectionList"), (Object)JSONObject.toJSONString(param));
                String reqResp = HttpTookit.postByJson((String)(ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getCollectionList"), (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
                reqJson = JSONObject.parseObject((String)reqResp);
                if ("ok".equals(reqJson.getString("status"))) {
                    pageData = reqJson.getJSONArray("data");
                    if (null != pageData && pageData.size() > 0) {
                        this.logger.info("\u4e2d\u7535\u73b0\u573a\u6536\u6b3e\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                        this.handleErpPage(pageData);
                        if (pageData.size() < pageNum) {
                            hasNext = false;
                        }
                    } else {
                        this.logger.info("\u4e2d\u7535\u56db\u73b0\u573a\u6536\u6b3e\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                        hasNext = false;
                    }
                } else {
                    this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u73b0\u573a\u6536\u6b3e\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{"/cefoc/yql/getCollectionList", JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                }
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u73b0\u573a\u6536\u6b3e\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{"/cefoc/yql/getCollectionList", JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u73b0\u573a\u6536\u6b3e\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u73b0\u573a\u6536\u6b3e\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u73b0\u573a\u6536\u6b3e\u540c\u6b65\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    private void handleErpPage(JSONArray reqJsonArr) {
        JSONObject tmp = null;
        HashMap<Long, BigDecimal> applyIdMap = new HashMap<Long, BigDecimal>();
        if (null != reqJsonArr && reqJsonArr.size() > 0) {
            for (Object obj : reqJsonArr) {
                tmp = (JSONObject)obj;
                applyIdMap.put(tmp.getLong("YQL_SID"), ComputeUtil.safeAdd(tmp.getBigDecimal("EstimatedDisposalAmount"), (BigDecimal)applyIdMap.get(tmp.getLong("YQL_SID"))));
            }
            List<DisposeEntity> dbEntities = this.service.getAllByIds(new ArrayList<Long>(applyIdMap.keySet()));
            ArrayList<DisposeEntity> saveList = new ArrayList<DisposeEntity>();
            if (CollectionUtils.isNotEmpty(dbEntities)) {
                for (DisposeEntity item : dbEntities) {
                    if (!applyIdMap.containsKey(item.getId())) continue;
                    item.setRecDate(new Date());
                    item.setRecMny((BigDecimal)applyIdMap.get(item.getId()));
                    item.setRecMnyFlag("1");
                    saveList.add(item);
                }
            }
            this.logger.info("\u672c\u6b21\u66f4\u65b0\u5904\u7f6e\u7533\u8bf7\uff1a{}\u6761", (Object)saveList.size());
            if (CollectionUtils.isNotEmpty(saveList)) {
                this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
            }
        }
    }
}

