/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pick.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.zdsmaterial.pick.bean.ProSubPickerEntity;
import com.ejianc.business.zdsmaterial.pick.mapper.ProSubPickerMapper;
import com.ejianc.business.zdsmaterial.pick.service.IProSubPickerService;
import com.ejianc.business.zdsmaterial.pick.vo.ProSubPickerVO;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="proSubPickerService")
public class ProSubPickerServiceImpl
extends BaseServiceImpl<ProSubPickerMapper, ProSubPickerEntity>
implements IProSubPickerService {
    @Autowired
    private ISubSupplierApi supplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String REQ_URL = "/ejc-oms-web/openapi/enterprise/createOrUpdateUser";
    private final String REQ_DEL_URL = "/ejc-idm-web/openapi/api/user/removeUserAccRole";
    @Value(value="${eachLink.host}")
    private String host;
    @Value(value="${eachLink.appId}")
    private String appId;
    @Value(value="${eachLink.secret}")
    private String secret;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void resultDelList(List<ProSubPickerEntity> delPickerList) {
        ArrayList resultList = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_id", (Object)delPickerList.get(0).getSupplierId());
        queryWrapper.notIn((Object)"id", delPickerList.stream().map(BaseEntity::getId).toArray());
        List list = super.list((Wrapper)queryWrapper);
        if (list.size() > 0) {
            Map<Long, ProSubPickerEntity> collect = list.stream().collect(Collectors.toMap(e -> e.getSupUserId(), e -> e));
            CommonResponse supplierCommonResponse = this.supplierApi.getOneById(delPickerList.get(0).getSupplierId());
            this.logger.info("\u67e5\u8be2\u5206\u5305\u4f9b\u5e94\u5546:{}", (Object)JSONObject.toJSONString((Object)supplierCommonResponse));
            if (!supplierCommonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5206\u5305\u4f9b\u5e94\u5546\u5931\u8d25!");
            }
            SupplierVO supplierVo = (SupplierVO)supplierCommonResponse.getData();
            Long tenant = supplierVo.getTenant();
            for (ProSubPickerEntity entity : delPickerList) {
                if (collect.containsKey(entity.getSupUserId())) continue;
                this.delRoleByPicker(entity, tenant);
            }
        }
    }

    @Override
    public CommonResponse<ProSubPickerVO> querySupByPhone(ProSubPickerVO proSubPickerVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_emp_phone", (Object)proSubPickerVO.getSupplierEmpPhone());
        List list = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", null);
        }
        ProSubPickerEntity entity = (ProSubPickerEntity)((Object)list.get(0));
        proSubPickerVO.setSupplierEmpName(entity.getSupplierEmpName());
        proSubPickerVO.setSupplierEmpCard(entity.getSupplierEmpCard());
        proSubPickerVO.setSupplierEmpPhone(entity.getSupplierEmpPhone());
        proSubPickerVO.setPickerMemo(entity.getPickerMemo());
        proSubPickerVO.setSupplierEmpFileId(entity.getSupplierEmpFileId());
        proSubPickerVO.setSupUserId(entity.getSupUserId());
        proSubPickerVO.setSupTenantId(entity.getSupTenantId());
        proSubPickerVO.setCoordination(entity.getCoordination());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)proSubPickerVO);
    }

    @Override
    public CommonResponse<ProSubPickerVO> accCoordination(ProSubPickerVO proSubPickerVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supplier_emp_phone", (Object)proSubPickerVO.getSupplierEmpPhone());
        queryWrapper.eq((Object)"supplier_id", (Object)proSubPickerVO.getSupplierId());
        queryWrapper.eq((Object)"contract_id", (Object)proSubPickerVO.getContractId());
        List list = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5f53\u524d\u4eba\u5458\u5728\u5f53\u524d\u5408\u540c\u4e0b\u5df2\u7ecf\u5b58\u5728\u4e86\uff01");
        }
        if (null != proSubPickerVO.getCoordination() && "0".equals(proSubPickerVO.getCoordination())) {
            CommonResponse supplierCommonResponse = this.supplierApi.getOneById(proSubPickerVO.getSupplierId());
            this.logger.info("\u67e5\u8be2\u5206\u5305\u4f9b\u5e94\u5546:{}", (Object)JSONObject.toJSONString((Object)supplierCommonResponse));
            if (!supplierCommonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5206\u5305\u4f9b\u5e94\u5546\u5931\u8d25!");
            }
            SupplierVO supplierVo = (SupplierVO)supplierCommonResponse.getData();
            if (null == supplierVo.getCoordination() || !"1".equals(supplierVo.getCoordination())) {
                this.supplierApi.accCoordination(supplierVo);
            }
            ProSubPickerVO supAccount = this.createSupAccount((ProSubPickerEntity)((Object)BeanMapper.map((Object)proSubPickerVO, ProSubPickerEntity.class)), supplierVo.getTenant());
            return CommonResponse.success((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)supAccount);
        }
        return CommonResponse.success((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)proSubPickerVO);
    }

    public ProSubPickerVO createSupAccount(ProSubPickerEntity entity, Long supTenantId) {
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("linkMobile", entity.getSupplierEmpPhone());
        reqParam.put("linkName", entity.getSupplierEmpName());
        reqParam.put("linkSupType", "sub");
        reqParam.put("supplierAccRole", "\u5206\u5305\u9886\u6599\u4eba");
        reqParam.put("supplierTenantId", supTenantId.toString());
        CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithUniversal("/ejc-oms-web/openapi/enterprise/createOrUpdateUser", RequestMethod.POST, JSONObject.toJSONString(reqParam), this.appId, this.secret, this.host);
        if (!syncReqResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u9886\u6599\u8bbe\u7f6e\u9886\u6599\u4eba\u624b\u673a\u53f7-{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)syncReqResp)});
            throw new BusinessException("\u5206\u5305\u9886\u6599\u8bbe\u7f6e\u9886\u6599\u4eba\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff01");
        }
        CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
        if (!resp.isSuccess()) {
            this.logger.error("\u5206\u5305\u9886\u6599\u8bbe\u7f6e\u9886\u6599\u4eba\u624b\u673a\u53f7-{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)resp)});
            throw new BusinessException("\u751f\u6210\u4f9b\u65b9\u534f\u540c\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        entity.setCoordination("1");
        entity.setSupUserId(((JSONObject)resp.getData()).getLong("userId"));
        entity.setSupTenantId(((JSONObject)resp.getData()).getLong("tenantId"));
        super.saveOrUpdate((Object)entity, false);
        return (ProSubPickerVO)BeanMapper.map((Object)((Object)entity), ProSubPickerVO.class);
    }

    public void delRoleByPicker(ProSubPickerEntity entity, Long supTenantId) {
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("userId", entity.getSupUserId().toString());
        reqParam.put("tenantId", supTenantId.toString());
        reqParam.put("accRole", "\u5206\u5305\u9886\u6599\u4eba");
        CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithUniversal("/ejc-idm-web/openapi/api/user/removeUserAccRole", RequestMethod.POST, JSONObject.toJSONString(reqParam), this.appId, this.secret, this.host);
        if (!syncReqResp.isSuccess()) {
            this.logger.error("\u5206\u5305\u9886\u6599\u8bbe\u7f6e\u9886\u6599\u4eba\u5220\u9664\u624b\u673a\u53f7-{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)syncReqResp)});
            throw new BusinessException("\u5206\u5305\u9886\u6599\u8bbe\u7f6e\u9886\u6599\u4eba\u5220\u9664\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff01");
        }
        CommonResponse resp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
        if (!resp.isSuccess()) {
            this.logger.error("\u5206\u5305\u9886\u6599\u8bbe\u7f6e\u9886\u6599\u4eba\u5220\u9664\u624b\u673a\u53f7-{}\u751f\u6210\u534f\u540c\u8d26\u6237\u5931\u8d25\uff0c\u53c2\u6570\uff1a{}, \u7ed3\u679c\uff1a{}", new Object[]{entity.getSupplierEmpPhone(), JSONObject.toJSONString(reqParam), JSONObject.toJSONString((Object)resp)});
            throw new BusinessException("\u751f\u6210\u4f9b\u65b9\u534f\u540c\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
    }
}

