/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"controlPlan"})
public class ControlPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IControlPlanService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ControlPlanVO> saveOrUpdate(@RequestBody ControlPlanVO saveOrUpdateVO) {
        ControlPlanVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ControlPlanVO> queryDetail(Long id) {
        ControlPlanEntity entity = (ControlPlanEntity)((Object)this.service.selectById(id));
        ControlPlanVO vo = (ControlPlanVO)BeanMapper.map((Object)((Object)entity), ControlPlanVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ControlPlanVO controlPlanVO : vos) {
            }
        }
        this.service.deleteByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("projectId")) {
            param.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_CHANGE));
        } else {
            param.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_NEW));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("billName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("engineerName");
        fuzzyFields.add("managerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (param.getParams().containsKey("projectId")) {
            param.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_CHANGE));
        } else {
            param.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_NEW));
        }
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, ControlPlanVO.class);
        records.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().export("ControlPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refControlPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ControlPlanVO>> refControlPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ControlPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validateParentTypeId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, MaterialCategoryEntity>> validateParentTypeId(@RequestBody ControlPlanVO saveOrUpdateVO) {
        Map<Long, MaterialCategoryEntity> map = this.service.validateParentTypeId(saveOrUpdateVO, true);
        return CommonResponse.success((String)"\u6821\u9a8c\u4e8c\u7ea7\u5206\u7c7b\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/getParentMaterialType"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, MaterialCategoryEntity>> getParentMaterialType(@RequestBody List<Long> materialTypeIds) {
        Map<Long, MaterialCategoryEntity> map = this.service.getParentMaterialTypeMap(materialTypeIds);
        return CommonResponse.success((String)"\u83b7\u53d6\u4e8c\u7ea7\u5206\u7c7b\u6210\u529f\uff01", map);
    }
}

