/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanImportEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanImportService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="controlPlan")
public class ControlPlanBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IControlPlanService service;
    @Autowired
    private IControlPlanDetailService detailService;
    @Autowired
    private IControlPlanImportService importService;
    @Autowired
    private IPurchasePlanService purchaseService;
    @Autowired
    private IPurchasePlanDetailService purchaseDetailService;
    @Autowired
    private IControlPlanSumService sumService;
    @Autowired
    private IControlPlanSumDetailService sumDetailService;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ControlPlanEntity entity = (ControlPlanEntity)((Object)this.service.selectById(billId));
        this.pushToSum(entity);
        this.pushToImport(entity);
        return CommonResponse.success();
    }

    private void pushToImport(ControlPlanEntity entity) {
        List detailList = entity.getDetailList().stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getDescription())).collect(Collectors.toList());
        QueryWrapper ew = new QueryWrapper();
        ew.and(q -> {
            for (ControlPlanDetailEntity f : detailList) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"material_id", (Object)f.getMaterialId())).eq((Object)"description", (Object)f.getDescription()));
            }
            return q;
        });
        List list = this.importService.list((Wrapper)ew);
        Set set = list.stream().map(x -> x.getMaterialId() + "@" + x.getDescription()).collect(Collectors.toSet());
        List<ControlPlanImportEntity> saveList = BeanMapper.mapList(detailList, ControlPlanImportEntity.class);
        saveList = saveList.stream().filter(x -> !set.contains(x.getMaterialId() + "@" + x.getDescription())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(saveList)) {
            saveList.forEach(vo -> {
                vo.setId(null);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
                vo.setVersion(null);
                vo.setRowState("add");
            });
            this.importService.saveOrUpdateBatch(saveList);
        }
    }

    private void pushToMaterial(ControlPlanEntity entity) {
        List<ControlPlanDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isEmpty(detailList = detailList.stream().filter(x -> PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType())).collect(Collectors.toList()))) {
            return;
        }
        List typeIds = detailList.stream().map(ControlPlanDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", typeIds));
        List typeList = this.categoryService.queryList(param);
        Map<Long, MaterialCategoryEntity> typeMap = typeList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        ArrayList<MaterialVO> saveList = new ArrayList<MaterialVO>();
        detailList.forEach(data -> {
            MaterialVO vo = new MaterialVO();
            vo.setId(data.getMaterialId());
            vo.setCode(data.getMaterialCode());
            vo.setName(data.getMaterialName());
            vo.setCategoryId(data.getMaterialTypeId());
            vo.setCategoryCode(((MaterialCategoryEntity)((Object)((Object)typeMap.get(data.getMaterialTypeId())))).getCode());
            vo.setCategoryName(data.getMaterialTypeName());
            vo.setUnitId(data.getUnitId());
            vo.setUnitName(data.getUnitName());
            vo.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            vo.setBlockedFlag(ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode());
            vo.setSystemId("sys");
            vo.setProductCode(data.getProductCode());
            vo.setSourceId(String.valueOf(data.getId()));
            vo.setPropertyShowName(data.getPropertyValue());
            vo.setRelationList(JSONArray.parseArray((String)data.getProperty(), MaterialPropertyRelationVO.class));
            ArrayList<MaterialSourceVO> sourceList = new ArrayList<MaterialSourceVO>();
            MaterialSourceVO materialSourceVO = new MaterialSourceVO();
            materialSourceVO.setMaterialId(data.getMaterialId());
            materialSourceVO.setBillType("EJCBT202311000004");
            materialSourceVO.setBillTypeName("\u7269\u8d44\u603b\u63a7\u8ba1\u5212\u7f16\u5236");
            materialSourceVO.setSourceBillCode(entity.getBillCode());
            materialSourceVO.setSourcePid(entity.getId());
            materialSourceVO.setSourceDetailId(data.getId());
            materialSourceVO.setSourceBillPcUrl(this.baseHost + "ejc-zdsmaterial-frontend/#/controlPlan/card");
            materialSourceVO.setSourceCreateUserCode(entity.getCreateUserCode());
            materialSourceVO.setSourceCreateUserName(entity.getCreateUserName());
            materialSourceVO.setSourceCreateTime(entity.getCreateTime());
            materialSourceVO.setSourceCreateTime(entity.getCreateTime());
            materialSourceVO.setSourceOrgName(entity.getOrgName());
            sourceList.add(materialSourceVO);
            vo.setSourceList(sourceList);
            saveList.add(vo);
        });
        List<MaterialVO> materialVOS = this.materialService.addNewMaterialsFromBill(saveList);
        Map<String, List<MaterialVO>> map = materialVOS.stream().collect(Collectors.groupingBy(s -> s.getName() + '-' + (StringUtils.isNotBlank((CharSequence)s.getPropertyShowName()) ? s.getPropertyShowName() : "") + '-' + s.getUnitId()));
        for (ControlPlanDetailEntity controlPlanDetailEntity : detailList) {
            String key = controlPlanDetailEntity.getMaterialName() + "-" + (StringUtils.isNotBlank((CharSequence)controlPlanDetailEntity.getPropertyValue()) ? controlPlanDetailEntity.getPropertyValue() : "") + "-" + controlPlanDetailEntity.getUnitId();
            if (!map.containsKey(key)) continue;
            MaterialVO materialVOS1 = map.get(key).get(0);
            controlPlanDetailEntity.setMaterialId(materialVOS1.getId());
            controlPlanDetailEntity.setMaterialCode(materialVOS1.getCode());
        }
        this.detailService.saveOrUpdateBatch(detailList);
    }

    private ControlPlanSumEntity pushToSum(ControlPlanEntity entity) {
        List<ControlPlanSumDetailEntity> detailList;
        this.logger.info("--> \u5355\u636e\uff1a" + entity.getId() + "\u6c47\u603b\u5f00\u59cb");
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(ControlPlanSumEntity::getProjectId, (Object)entity.getProjectId());
        List sumList = this.sumService.list((Wrapper)ew);
        ControlPlanSumEntity sum = null;
        if (CollectionUtils.isEmpty((Collection)sumList)) {
            sum = this.getSumVO(entity);
            detailList = sum.getDetailList();
            if (CollectionUtils.isNotEmpty(detailList)) {
                detailList.forEach(vo -> {
                    vo.setSourceId(String.valueOf(entity.getId()));
                    vo.setSourceDetailId(String.valueOf(vo.getId()));
                    vo.setBillType(entity.getBillType());
                    vo.setSumNum(vo.getNum());
                    vo.setId(null);
                    vo.setCreateTime(null);
                    vo.setCreateUserCode(null);
                    vo.setUpdateTime(null);
                    vo.setUpdateUserCode(null);
                    vo.setVersion(null);
                    vo.setRowState("add");
                });
            }
        } else {
            sum = (ControlPlanSumEntity)((Object)this.sumService.selectById(((ControlPlanSumEntity)((Object)sumList.get(0))).getId()));
            if (PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())) {
                sum.setLastTime(entity.getCreateTime());
            } else {
                sum.setChangeStatus(PlanConstant.CHANGE_OVER);
                sum.setChangeVersion(sum.getChangeVersion() + 1);
            }
            detailList = sum.getDetailList();
            List<ControlPlanSumDetailEntity> saveList = entity.getDetailList().stream().filter(x -> PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).map(x -> (ControlPlanSumDetailEntity)((Object)((Object)BeanMapper.map((Object)x, ControlPlanSumDetailEntity.class)))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(saveList)) {
                saveList.forEach(vo -> {
                    vo.setSourceId(String.valueOf(entity.getId()));
                    vo.setSourceDetailId(String.valueOf(vo.getId()));
                    vo.setBillType(entity.getBillType());
                    if (PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())) {
                        vo.setSumNum(vo.getNum());
                    } else {
                        vo.setSumNum(BigDecimal.ZERO);
                    }
                    vo.setId(null);
                    vo.setCreateTime(null);
                    vo.setCreateUserCode(null);
                    vo.setUpdateTime(null);
                    vo.setUpdateUserCode(null);
                    vo.setVersion(null);
                    vo.setRowState("add");
                });
            }
            Map<Long, ControlPlanDetailEntity> updateMap = entity.getDetailList().stream().filter(x -> PlanConstant.ROW_TYPE_CHANGE.equals(x.getRowType())).collect(Collectors.toMap(ControlPlanDetailEntity::getMaterialId, x -> x));
            detailList.forEach(vo -> {
                if (updateMap.containsKey(vo.getMaterialId())) {
                    vo.setNum(((ControlPlanDetailEntity)((Object)((Object)updateMap.get(vo.getMaterialId())))).getAfterNum());
                    vo.setRowType(PlanConstant.ROW_TYPE_CHANGE);
                } else {
                    vo.setRowType(PlanConstant.ROW_TYPE_UNCHANGE);
                }
            });
            detailList.addAll(saveList);
        }
        this.logger.info("--> \u6c47\u603b\u540eVO\uff1a" + JSONObject.toJSONString((Object)((Object)sum)));
        sum = this.sumService.saveOrUpdateEntity(sum);
        String sourceBillType = "EJCBT202311000004";
        if (PlanConstant.BILL_TYPE_CHANGE.equals(entity.getBillType())) {
            sourceBillType = "EJCBT202311000010";
        }
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "uploadFile", String.valueOf(sum.getId()), "EJCBT202311000011", "bill");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), sourceBillType, "bill", String.valueOf(sum.getId()), "EJCBT202311000011", "bill");
        return sum;
    }

    private ControlPlanSumEntity getSumVO(ControlPlanEntity entity) {
        ControlPlanSumEntity vo = (ControlPlanSumEntity)((Object)BeanMapper.map((Object)((Object)entity), ControlPlanSumEntity.class));
        vo.setId(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setVersion(null);
        vo.setFirstTime(entity.getCreateTime());
        vo.setLastTime(entity.getCreateTime());
        vo.setChangeStatus(PlanConstant.CHANGE_NO);
        vo.setChangeVersion(0);
        vo.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        return vo;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ControlPlanEntity entity = (ControlPlanEntity)((Object)this.service.selectById(billId));
        if (PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())) {
            this.validateNew(entity);
        } else {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
            queryParam.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_CHANGE));
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
            List dataList = this.service.queryList(queryParam);
            if (dataList.stream().anyMatch(x -> !"1,3".contains(String.valueOf(x.getBillState())))) {
                throw new BusinessException("\u9879\u76ee\u4e0b\u5b58\u5728\u672a\u751f\u6548\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1!");
            }
            Integer max = dataList.stream().map(ControlPlanEntity::getChangeVersion).max(Integer::compareTo).orElse(null);
            if (max != null && entity.getChangeVersion() <= max) {
                throw new BusinessException("\u975e\u6700\u65b0\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1!");
            }
        }
        this.validatePurchase(entity);
        return CommonResponse.success();
    }

    private void validatePurchase(ControlPlanEntity entity) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        List purchaseList = this.purchaseService.queryList(queryParam);
        Map<Long, String> dataMap = purchaseList.stream().collect(Collectors.toMap(BaseEntity::getId, PurchasePlanEntity::getBillCode));
        if (CollectionUtils.isNotEmpty((Collection)purchaseList)) {
            List planIds = purchaseList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<ControlPlanDetailEntity> detailList = entity.getDetailList();
            List ids = detailList.stream().filter(x -> PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).map(ControlPlanDetailEntity::getMaterialId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            QueryParam param = new QueryParam();
            param.getParams().put("planId", new Parameter("in", planIds));
            param.getParams().put("materialId", new Parameter("in", ids));
            List list = this.purchaseDetailService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                StringBuilder msg = new StringBuilder();
                msg.append("\u91c7\u8d2d\u8ba1\u5212");
                for (PurchasePlanDetailEntity detail : list) {
                    msg.append("\u3010" + dataMap.get(detail.getPlanId()) + "\u3011-\u3010" + detail.getMaterialName() + "\u3011\uff0c");
                }
                msg.append("\u5df2\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
                throw new BusinessException(msg.toString());
            }
        }
    }

    private void validateNew(ControlPlanEntity entity) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        queryParam.getParams().put("billType", new Parameter("eq", (Object)PlanConstant.BILL_TYPE_CHANGE));
        List dataList = this.service.queryList(queryParam);
        Map<Long, String> dataMap = dataList.stream().collect(Collectors.toMap(BaseEntity::getId, ControlPlanEntity::getBillCode));
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            List planIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<ControlPlanDetailEntity> detailList = entity.getDetailList();
            List ids = detailList.stream().map(ControlPlanDetailEntity::getMaterialId).collect(Collectors.toList());
            QueryParam param = new QueryParam();
            param.getParams().put("planId", new Parameter("in", planIds));
            param.getParams().put("materialId", new Parameter("in", ids));
            List list = this.detailService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                StringBuilder msg = new StringBuilder();
                msg.append("\u53d8\u66f4\u5355");
                for (ControlPlanDetailEntity detail : list) {
                    msg.append("\u3010" + dataMap.get(detail.getPlanId()) + "\u3011-\u3010" + detail.getMaterialName() + "\u3011\uff0c");
                }
                msg.append("\u5df2\u53d1\u751f\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
                throw new BusinessException(msg.toString());
            }
        }
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ControlPlanEntity entity = (ControlPlanEntity)((Object)this.service.selectById(billId));
        this.withdrawSum(entity);
        List<ControlPlanDetailEntity> detailList = entity.getDetailList();
        List<Long> sourceIds = detailList.stream().filter(x -> PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sourceIds)) {
            this.materialService.deleteMaterialsFromBill(sourceIds);
        }
        return CommonResponse.success();
    }

    private ControlPlanSumEntity withdrawSum(ControlPlanEntity entity) {
        this.logger.info("--> \u5355\u636e\uff1a" + entity.getId() + "\u53d6\u6d88\u6c47\u603b\u5f00\u59cb");
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        List sumList = this.sumService.queryList(param);
        ControlPlanSumEntity sum = (ControlPlanSumEntity)((Object)this.sumService.selectById(((ControlPlanSumEntity)((Object)sumList.get(0))).getId()));
        if (PlanConstant.BILL_TYPE_NEW.equals(entity.getBillType())) {
            param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
            param.getOrderMap().put("createTime", "desc");
            List newList = this.service.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)newList)) {
                sum.setLastTime(((ControlPlanEntity)((Object)newList.get(0))).getCreateTime());
            }
        } else {
            sum.setChangeStatus(PlanConstant.CHANGE_ING);
            sum.setChangeVersion(sum.getChangeVersion() - 1);
        }
        List<ControlPlanSumDetailEntity> detailList = sum.getDetailList();
        Map<Long, ControlPlanDetailEntity> saveMap = entity.getDetailList().stream().filter(x -> PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).collect(Collectors.toMap(ControlPlanDetailEntity::getMaterialId, x -> x));
        Map<Long, ControlPlanDetailEntity> updateMap = entity.getDetailList().stream().filter(x -> PlanConstant.ROW_TYPE_CHANGE.equals(x.getRowType())).collect(Collectors.toMap(ControlPlanDetailEntity::getMaterialId, x -> x));
        detailList.forEach(vo -> {
            if (saveMap.containsKey(vo.getMaterialId())) {
                vo.setRowState("del");
            }
            if (updateMap.containsKey(vo.getMaterialId())) {
                vo.setNum(((ControlPlanDetailEntity)((Object)((Object)updateMap.get(vo.getMaterialId())))).getBeforeNum());
                vo.setRowState("edit");
            }
        });
        Integer row = (int)detailList.stream().filter(x -> !"del".equals(x.getRowState())).count();
        if (row > 0) {
            this.logger.info("--> \u6c47\u603b\u540eVO\uff1a" + JSONObject.toJSONString((Object)((Object)sum)));
            this.sumService.saveOrUpdate((Object)sum, false);
        } else {
            this.logger.info("--> \u6c47\u603b\u5355VO\uff1a" + sum.getId() + "\u5df2\u5220\u9664");
            this.sumService.removeById(sum.getId(), true);
        }
        String sourceBillType = "EJCBT202311000004";
        if (PlanConstant.BILL_TYPE_CHANGE.equals(entity.getBillType())) {
            sourceBillType = "EJCBT202311000010";
        }
        List<AttachmentVO> fileList = this.queryListBySourceId(entity.getId(), sourceBillType, "uploadFile");
        List<AttachmentVO> sumFileList = this.queryListBySourceId(sum.getId(), "EJCBT202311000011", "bill");
        List<AttachmentVO> fileList2 = this.queryListBySourceId(entity.getId(), sourceBillType, "bill");
        fileList.addAll(fileList2);
        if (CollectionUtils.isNotEmpty(fileList) && CollectionUtils.isNotEmpty(sumFileList)) {
            Map fileMap = fileList.stream().collect(Collectors.toMap(AttachmentVO::getFilePath, Function.identity()));
            ArrayList<String> ids = new ArrayList<String>();
            for (AttachmentVO vo2 : sumFileList) {
                if (!fileMap.containsKey(vo2.getFilePath())) continue;
                ids.add(String.valueOf(vo2.getId()));
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                this.attachmentApi.delete(String.join((CharSequence)",", ids));
            }
        }
        return sum;
    }

    private List<AttachmentVO> queryListBySourceId(Long sourceId, String billType, String sourceType) {
        CommonResponse response = this.attachmentApi.queryListBySourceId(sourceId, billType, sourceType, null);
        if (!response.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38\uff0c", (Object)response.getMsg());
            return new ArrayList<AttachmentVO>();
        }
        return (List)response.getData();
    }
}

