/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.control.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.mapper.ControlPlanSumMapper;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanSumVO;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="controlPlanSumService")
public class ControlPlanSumServiceImpl
extends BaseServiceImpl<ControlPlanSumMapper, ControlPlanSumEntity>
implements IControlPlanSumService {
    private static final String BILL_CODE = "ZDS_MATERIAL_CONTROL_PLAN_SUM";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IPurchasePlanService purchasePlanService;
    @Autowired
    private IControlPlanSumDetailService controlPlanSumDetailService;
    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialCategoryService categoryService;

    @Override
    public ControlPlanSumVO saveOrUpdate(ControlPlanSumVO saveOrUpdateVO) {
        ControlPlanSumEntity entity = (ControlPlanSumEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ControlPlanSumEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        }
        List detailList = saveOrUpdateVO.getDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        if (entity.getCreateUserId() == null) {
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }
        super.saveOrUpdate((Object)entity, false);
        this.pushToMaterial(entity);
        this.updateQuoteType(entity);
        ControlPlanSumVO vo = (ControlPlanSumVO)BeanMapper.map((Object)((Object)entity), ControlPlanSumVO.class);
        return vo;
    }

    private void pushToMaterial(ControlPlanSumEntity entity) {
        List<ControlPlanSumDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isEmpty(detailList = detailList.stream().filter(x -> PlanConstant.SOURCE_TYPE_NEW.equals(x.getSourceType()) && !PlanConstant.ROW_TYPE_CHANGE.equals(x.getRowType()) && !PlanConstant.ROW_TYPE_UNCHANGE.equals(x.getRowType())).collect(Collectors.toList()))) {
            return;
        }
        List typeIds = detailList.stream().map(ControlPlanSumDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", typeIds));
        List typeList = this.categoryService.queryList(param);
        Map<Long, MaterialCategoryEntity> typeMap = typeList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        ArrayList<MaterialVO> saveList = new ArrayList<MaterialVO>();
        detailList.forEach(data -> {
            MaterialVO vo = new MaterialVO();
            vo.setId(data.getMaterialId());
            vo.setCode(data.getMaterialCode());
            vo.setName(data.getMaterialName());
            vo.setCategoryId(data.getMaterialTypeId());
            vo.setCategoryCode(((MaterialCategoryEntity)((Object)((Object)typeMap.get(data.getMaterialTypeId())))).getCode());
            vo.setCategoryName(data.getMaterialTypeName());
            vo.setUnitId(data.getUnitId());
            vo.setUnitName(data.getUnitName());
            vo.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            vo.setBlockedFlag(ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode());
            vo.setSystemId("sys");
            vo.setProductCode(data.getProductCode());
            vo.setSourceId(String.valueOf(data.getSourceId()));
            vo.setPropertyShowName(data.getPropertyValue());
            vo.setRelationList(JSONArray.parseArray((String)data.getProperty(), MaterialPropertyRelationVO.class));
            ArrayList<MaterialSourceVO> sourceList = new ArrayList<MaterialSourceVO>();
            MaterialSourceVO materialSourceVO = new MaterialSourceVO();
            materialSourceVO.setMaterialId(data.getMaterialId());
            materialSourceVO.setBillType("EJCBT202311000011");
            materialSourceVO.setBillTypeName("\u7269\u8d44\u603b\u63a7\u8ba1\u5212\u6c47\u603b");
            materialSourceVO.setSourceBillCode(entity.getBillCode());
            materialSourceVO.setSourcePid(entity.getId());
            materialSourceVO.setSourceDetailId(data.getId());
            materialSourceVO.setSourceBillPcUrl(this.baseHost + "ejc-zdsmaterial-frontend/#/controlPlanSum/card");
            materialSourceVO.setSourceCreateUserCode(entity.getCreateUserCode());
            materialSourceVO.setSourceCreateUserName(entity.getCreateUserName());
            materialSourceVO.setSourceOrgName(entity.getOrgName());
            sourceList.add(materialSourceVO);
            vo.setSourceList(sourceList);
            saveList.add(vo);
        });
        List<MaterialVO> materialVOS = this.materialService.addNewMaterialsFromBill(saveList);
        Map<String, List<MaterialVO>> map = materialVOS.stream().collect(Collectors.groupingBy(s -> s.getName() + '-' + (StringUtils.isNotBlank((CharSequence)s.getPropertyShowName()) ? s.getPropertyShowName() : "") + '-' + s.getUnitId()));
        for (ControlPlanSumDetailEntity controlPlanSumDetailEntity : detailList) {
            String key = controlPlanSumDetailEntity.getMaterialName() + "-" + (StringUtils.isNotBlank((CharSequence)controlPlanSumDetailEntity.getPropertyValue()) ? controlPlanSumDetailEntity.getPropertyValue() : "") + "-" + controlPlanSumDetailEntity.getUnitId();
            if (!map.containsKey(key)) continue;
            MaterialVO materialVOS1 = map.get(key).get(0);
            controlPlanSumDetailEntity.setMaterialId(materialVOS1.getId());
            controlPlanSumDetailEntity.setMaterialCode(materialVOS1.getCode());
        }
        this.controlPlanSumDetailService.saveOrUpdateBatch(detailList);
    }

    private void updateQuoteType(ControlPlanSumEntity entity) {
        LambdaQueryWrapper lambdaPurchase = Wrappers.lambdaQuery();
        lambdaPurchase.eq(PurchasePlanEntity::getProjectId, (Object)entity.getProjectId());
        lambdaPurchase.in(PurchasePlanEntity::getBillState, new Object[]{1, 3});
        List purchasePlanEntities = this.purchasePlanService.list((Wrapper)lambdaPurchase);
        Map<Object, Object> numMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)purchasePlanEntities)) {
            List<Object> purchaseId = new ArrayList();
            purchaseId = purchasePlanEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaPurchaseDetail = Wrappers.lambdaQuery();
            lambdaPurchaseDetail.in(PurchasePlanDetailEntity::getPlanId, purchaseId);
            List purchasePlanDetailEntities = this.purchasePlanDetailService.list((Wrapper)lambdaPurchaseDetail);
            numMap = purchasePlanDetailEntities.stream().collect(Collectors.groupingBy(PurchasePlanDetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getRequirementNum()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        }
        List<ControlPlanSumDetailEntity> detailList = entity.getDetailList();
        for (ControlPlanSumDetailEntity controlPlanSumDetailEntity : detailList) {
            if (numMap.containsKey(controlPlanSumDetailEntity.getMaterialId())) {
                BigDecimal bigDecimal = (BigDecimal)numMap.get(controlPlanSumDetailEntity.getMaterialId());
                controlPlanSumDetailEntity.setPlanNum(bigDecimal);
                controlPlanSumDetailEntity.setQuoteType(2);
                continue;
            }
            controlPlanSumDetailEntity.setPlanNum(null);
            controlPlanSumDetailEntity.setQuoteType(1);
        }
        this.controlPlanSumDetailService.updateBatchById(detailList);
    }

    @Override
    public ControlPlanSumEntity saveOrUpdateEntity(ControlPlanSumEntity entity) {
        ControlPlanSumVO saveOrUpdateVO = (ControlPlanSumVO)BeanMapper.map((Object)((Object)entity), ControlPlanSumVO.class);
        ControlPlanSumVO result = this.saveOrUpdate(saveOrUpdateVO);
        return (ControlPlanSumEntity)((Object)BeanMapper.map((Object)result, ControlPlanSumEntity.class));
    }
}

