/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.purchase.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.vo.QuerySumVO;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.SupPurchasePlanVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchasePlan"})
public class PurchasePlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZDS-PUR-PLAN";
    @Autowired
    private IPurchasePlanService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasePlanVO> saveOrUpdate(@RequestBody PurchasePlanVO saveOrUpdateVO) {
        PurchasePlanVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasePlanVO> updateDetail(@RequestBody PurchasePlanVO saveOrUpdateVO) {
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchasePlanEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasePlanVO> queryDetail(Long id) {
        return this.service.queryDetail(id);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasePlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PurchasePlanVO purchasePlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> queryList(@RequestBody QueryParam param) {
        String authOrgIds;
        UserContext userContextCache;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("chiefEngineerName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")) {
            if (((Parameter)param.getParams().get("queryCoverage")).getValue().equals("1")) {
                param.getParams().put("createUserCode", new Parameter("eq", (Object)UserContext.getUserContext().getUserCode()));
                userContextCache = this.sessionManager.getUserContext();
                authOrgIds = userContextCache.getAuthOrgIds();
                List orgVOList = null;
                orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        } else {
            userContextCache = this.sessionManager.getUserContext();
            authOrgIds = userContextCache.getAuthOrgIds();
            List orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            param.setBillTypeId(null);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List orgVOList;
        String authOrgIds;
        UserContext userContextCache;
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("planName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("chiefEngineerName");
        fuzzyFields.add("projectManagerName");
        fuzzyFields.add("createUserName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("queryCoverage")) {
            if (((Parameter)param.getParams().get("queryCoverage")).getValue().equals("1")) {
                param.getParams().put("createUserCode", new Parameter("eq", (Object)UserContext.getUserContext().getUserCode()));
            } else {
                userContextCache = this.sessionManager.getUserContext();
                authOrgIds = userContextCache.getAuthOrgIds();
                orgVOList = null;
                orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
            param.getParams().remove("queryCoverage");
        } else {
            userContextCache = this.sessionManager.getUserContext();
            authOrgIds = userContextCache.getAuthOrgIds();
            orgVOList = null;
            orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            param.getParams().put("orgId", new Parameter("in", orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param, false);
        List records = BeanMapper.mapList((Iterable)list, PurchasePlanVO.class);
        records.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().export("PurchasePlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchasePlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasePlanVO>> refPurchasePlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasePlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody PurchasePlanVO planVO) {
        CommonResponse projectResp = this.projectApi.queryProjectPoolById(planVO.getProjectId());
        if (!projectResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u6570\u636e\u51fa\u9519\uff01");
        }
        ProjectPoolSetVO p = (ProjectPoolSetVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONArray)projectResp.getData()).get(0)), ProjectPoolSetVO.class);
        if (PlanConstant.INTEGER_NO.equals(p.getControlPurPlanFlag())) {
            return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)new ParamsCheckVO());
        }
        if (null != p.getPlanVersion() && p.getPlanVersion().equals("1")) {
            return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)new ParamsCheckVO());
        }
        ParamsCheckVO response = this.service.checkParams(planVO);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)response);
    }

    @RequestMapping(value={"/queryMaterialListSum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, PurchasePlanDetailVO>> queryMaterialListSum(@RequestBody QuerySumVO querySumVO) {
        return this.service.queryMaterialListSum(querySumVO.getMaterialIds(), querySumVO.getProjectId());
    }

    @RequestMapping(value={"/queryAllotOrgSum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryAllotOrgSum(@RequestBody QuerySumVO querySumVO) {
        return this.service.queryAllotOrgSum(querySumVO.getMaterialCodes(), querySumVO.getProjectId());
    }

    @RequestMapping(value={"/queryAllotOtherSum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BigDecimal> queryAllotOtherSum(@RequestBody QuerySumVO querySumVO) {
        return this.service.queryAllotOtherSum(querySumVO.getMaterialCode(), querySumVO.getBrandId(), querySumVO.getProjectId());
    }

    @GetMapping(value={"supQueryList"})
    @ResponseBody
    public CommonResponse<IPage<SupPurchasePlanVo>> supQueryList(@RequestParam(required=false) Map<String, Object> params) {
        IPage<SupPurchasePlanVo> dataList = this.service.supQueryList(params);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", dataList);
    }
}

