/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.purchase.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategorySettingsEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategorySettingsService;
import com.ejianc.business.zdsmaterial.material.vo.ArchivesInforVo;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.mapper.PurchasePlanDetailMapper;
import com.ejianc.business.zdsmaterial.plan.purchase.mapper.PurchasePlanMapper;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.SupPurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.SupPurchasePlanVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamsCheckDsVO;
import com.ejianc.foundation.support.vo.ParamsCheckVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasePlanService")
public class PurchasePlanServiceImpl
extends BaseServiceImpl<PurchasePlanMapper, PurchasePlanEntity>
implements IPurchasePlanService {
    private static final String BILL_CODE = "ZDS-PUR-PLAN";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialCategorySettingsService categorySettingsService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IControlPlanSumDetailService sumDetailService;
    @Autowired
    private IPurchasePlanDetailService detailService;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IControlPlanDetailService controlPlanDetailService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private PurchasePlanMapper mapper;
    @Autowired
    private PurchasePlanDetailMapper detailMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Override
    public void validatePlanNum(PurchasePlanEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<Long> materialIds = this.controlPlanDetailService.getAllMaterialByProject(entity.getProjectId());
            if (CollectionUtils.isEmpty(materialIds)) {
                return;
            }
            HashMap detailNumMap = new HashMap();
            HashMap materialMap = new HashMap();
            HashSet negativeNumMaterialIds = new HashSet();
            entity.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && materialIds.contains(item.getMaterialId())).forEach(detail -> {
                detailNumMap.put(detail.getMaterialId(), ComputeUtil.safeAdd((BigDecimal)((BigDecimal)detailNumMap.get(detail.getMaterialId())), (BigDecimal)detail.getRequirementNum()));
                if (BigDecimal.ZERO.compareTo(detail.getRequirementNum()) > 0) {
                    negativeNumMaterialIds.add(detail.getMaterialId());
                }
                materialMap.put(detail.getMaterialId(), detail);
            });
            if (CollectionUtils.isNotEmpty(negativeNumMaterialIds)) {
                List<Map<String, Object>> totalRequiredNumByMaterial = this.detailMapper.totalRequiredNumByMaterial(new ArrayList<Long>(negativeNumMaterialIds), entity.getProjectId(), entity.getId());
                HashMap<Long, BigDecimal> effectNum = new HashMap<Long, BigDecimal>();
                if (CollectionUtils.isNotEmpty(totalRequiredNumByMaterial)) {
                    effectNum.putAll(totalRequiredNumByMaterial.stream().filter(item -> null != item.get("materialId")).collect(Collectors.toMap(item -> Long.valueOf(item.get("materialId").toString()), item -> null != item.get("totalNum") ? new BigDecimal(item.get("totalNum").toString()) : BigDecimal.ZERO)));
                }
                PurchasePlanDetailEntity tmpDetail = null;
                BigDecimal totalNum = null;
                for (Long materialId : materialMap.keySet()) {
                    tmpDetail = (PurchasePlanDetailEntity)((Object)materialMap.get(materialId));
                    totalNum = ComputeUtil.safeAdd((BigDecimal)((BigDecimal)detailNumMap.get(materialId)), (BigDecimal)((BigDecimal)effectNum.get(materialId)));
                    if (BigDecimal.ZERO.compareTo(totalNum) <= 0) continue;
                    throw new BusinessException("\u7269\u8d44\u3010\u7f16\u7801\uff1a" + tmpDetail.getMaterialCode() + "\uff0c\u540d\u79f0\uff1a" + tmpDetail.getMaterialName() + "\u3011\u8d1f\u6570\u53ef\u51b2\u62b5\u91cf\uff1a" + (null != effectNum.get(materialId) ? ((BigDecimal)effectNum.get(materialId)).setScale(2, 4).toPlainString() : BigDecimal.ZERO.setScale(2, 4).toPlainString()) + "\uff0c\u5df2\u8d85\uff1a" + totalNum.negate().setScale(2, 4).toPlainString() + "\uff0c\u8bf7\u8c03\u6574\uff01");
                }
            }
        }
    }

    @Override
    public PurchasePlanVO saveOrUpdate(PurchasePlanVO saveOrUpdateVO) {
        List<PurchasePlanDetailEntity> detailList;
        List<Long> collect;
        ArrayList<Long> materialTypeIds;
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PurchasePlanEntity.class));
        this.validatePlanNum(entity);
        boolean b = this.checkUpdateDetailParams(saveOrUpdateVO);
        if (b) {
            saveOrUpdateVO.setExcessBpmFlag(Integer.valueOf(1));
            entity.setExcessBpmFlag(1);
        } else {
            saveOrUpdateVO.setExcessBpmFlag(Integer.valueOf(0));
            entity.setExcessBpmFlag(0);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setPushStatus(0);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            CommonResponse employeeVOCommonResponse = this.employeeApi.queryEmployeByUserId(InvocationInfoProxy.getUserid());
            if (employeeVOCommonResponse.isSuccess()) {
                EmployeeVO data = (EmployeeVO)employeeVOCommonResponse.getData();
                entity.setUserPostName(data.getPostName());
                entity.setUserDepartName(data.getDeptName());
                entity.setUserOrgName(data.getOrgName());
                entity.setCreateUserId(InvocationInfoProxy.getUserid());
                entity.setExcessFlag(0);
            }
        }
        List details = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState())).collect(Collectors.toList());
        for (PurchasePlanDetailVO vo : details) {
            if (vo.getExcessDetailFlag() != 1) continue;
            entity.setExcessFlag(1);
            break;
        }
        entity.getDetailList().stream().filter(item -> null == item.getMaterialId()).forEach(item -> item.setMaterialId(IdWorker.getId()));
        List emptyTypeCodeList = entity.getDetailList().stream().filter(item -> StringUtils.isBlank((CharSequence)item.getMaterialTypeCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(emptyTypeCodeList) && CollectionUtils.isNotEmpty(materialTypeIds = new ArrayList<Long>(emptyTypeCodeList.stream().map(PurchasePlanDetailEntity::getMaterialTypeId).collect(Collectors.toSet())))) {
            HashMap<Long, String> categoryCodeMap = new HashMap<Long, String>();
            List<MaterialCategoryVO> materialCategorys = this.materialCategoryService.getAllByIds(materialTypeIds);
            categoryCodeMap.putAll(materialCategorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getCode())));
            emptyTypeCodeList.stream().filter(item -> categoryCodeMap.containsKey(item.getMaterialTypeId())).forEach(item -> item.setMaterialTypeCode((String)categoryCodeMap.get(item.getMaterialTypeId())));
        }
        if (CollectionUtils.isNotEmpty(collect = (detailList = entity.getDetailList()).stream().filter(e -> 1 == e.getWorkPlanFlag() && (null == e.getRowState() || !e.getRowState().equals("del"))).map(e -> e.getMaterialId()).collect(Collectors.toList()))) {
            this.checkMaterialSumPlan(collect, entity.getProjectId());
        }
        String materialTypeNames = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(PurchasePlanDetailVO::getMaterialTypeName).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        this.detailService.setMaterialNo(entity.getDetailList());
        super.saveOrUpdate((Object)entity, false);
        return (PurchasePlanVO)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class);
    }

    @Override
    public PurchasePlanEntity setSid(PurchasePlanEntity purchasePlanEntity) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (purchasePlanEntity.getCommitUserId() != null) {
            ids.add(purchasePlanEntity.getCommitUserId());
        }
        if (purchasePlanEntity.getProjectManagerId() != null) {
            ids.add(purchasePlanEntity.getProjectManagerId());
        }
        if (purchasePlanEntity.getEngineerId() != null) {
            ids.add(purchasePlanEntity.getEngineerId());
        }
        if (purchasePlanEntity.getChiefEngineerId() != null) {
            ids.add(purchasePlanEntity.getChiefEngineerId());
        }
        if (purchasePlanEntity.getCreateUserId() != null) {
            ids.add(purchasePlanEntity.getCreateUserId());
        }
        if (purchasePlanEntity.getProjectManagerId() != null) {
            ids.add(purchasePlanEntity.getProjectManagerId());
        }
        if (purchasePlanEntity.getPurchaseWorkerId() != null) {
            ids.add(purchasePlanEntity.getPurchaseWorkerId());
        }
        if (purchasePlanEntity.getApproveUserId() != null) {
            ids.add(purchasePlanEntity.getApproveUserId());
        }
        List collect = ids.stream().distinct().collect(Collectors.toList());
        CommonResponse byIds = this.employeeApi.getJustByIds(collect);
        System.out.println(byIds);
        if (byIds.isSuccess()) {
            List data = (List)byIds.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (EmployeeVO vo : data) {
                    if (vo.getSourceId() == null) continue;
                    if (purchasePlanEntity.getCreateUserId().equals(vo.getId())) {
                        purchasePlanEntity.setCommitUserSid(vo.getSourceId());
                    }
                    if (purchasePlanEntity.getEngineerId().equals(vo.getId())) {
                        purchasePlanEntity.setEngineerSid(vo.getSourceId());
                    }
                    if (purchasePlanEntity.getProjectManagerId() != null && purchasePlanEntity.getProjectManagerId().equals(vo.getId())) {
                        purchasePlanEntity.setProjectManagerSid(vo.getSourceId());
                    }
                    if (purchasePlanEntity.getChiefEngineerId() != null && purchasePlanEntity.getChiefEngineerId().equals(vo.getId())) {
                        purchasePlanEntity.setChiefEngineerSid(vo.getSourceId());
                    }
                    if (purchasePlanEntity.getCreateUserId().equals(vo.getId())) {
                        purchasePlanEntity.setCreateUserSid(vo.getSourceId());
                    }
                    if (purchasePlanEntity.getPurchaseWorkerId().equals(vo.getId())) {
                        purchasePlanEntity.setPurchaseWorkerSid(vo.getSourceId());
                    }
                    if (!purchasePlanEntity.getApproveUserId().equals(vo.getId())) continue;
                    purchasePlanEntity.setApproveUserSid(vo.getSourceId());
                }
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u4eba\u5458\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List<Long> collect1 = purchasePlanEntity.getDetailList().stream().map(e -> e.getMaterialTypeId()).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> materialCategoryVOS = this.materialCategoryService.queryCategoryListByIds(collect1);
        Map<Long, String> idMap = materialCategoryVOS.stream().filter(e -> null != e.getSourceId()).collect(Collectors.toMap(e -> e.getId(), e -> e.getSourceId()));
        if (idMap != null) {
            for (PurchasePlanDetailEntity detail : purchasePlanEntity.getDetailList()) {
                if (!idMap.containsKey(detail.getMaterialTypeId())) continue;
                detail.setMaterialTypeSid(idMap.get(detail.getMaterialTypeId()));
            }
        }
        return purchasePlanEntity;
    }

    @Override
    public CommonResponse<PurchasePlanVO> queryDetail(Long id) {
        Map<Long, List<PurchasePlanDetailVO>> collect;
        Map mapCommonResponse;
        PurchasePlanEntity entity = (PurchasePlanEntity)((Object)super.selectById((Serializable)id));
        PurchasePlanVO vo = (PurchasePlanVO)BeanMapper.map((Object)((Object)entity), PurchasePlanVO.class);
        List detailList = vo.getDetailList();
        ArrayList newDetailList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList) && null != (mapCommonResponse = (Map)this.queryMaterialListSum(new ArrayList<Long>((collect = detailList.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialId))).keySet()), vo.getProjectId()).getData()) && mapCommonResponse.size() > 0) {
            for (Map.Entry<Long, List<PurchasePlanDetailVO>> entry : collect.entrySet()) {
                if (!mapCommonResponse.containsKey(entry.getKey())) continue;
                List<PurchasePlanDetailVO> value = entry.getValue();
                for (PurchasePlanDetailVO vo1 : value) {
                    PurchasePlanDetailVO detailVO = (PurchasePlanDetailVO)mapCommonResponse.get(entry.getKey());
                    vo1.setNum(detailVO.getNum());
                    vo1.setResidueNum(detailVO.getResidueNum() == null ? BigDecimal.ZERO : detailVO.getResidueNum());
                }
            }
            for (List list : collect.values()) {
                newDetailList.addAll(list);
            }
            Map<Long, BigDecimal> collect1 = newDetailList.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialId, Collectors.reducing(BigDecimal.ZERO, PurchasePlanDetailVO::getRequirementNum, BigDecimal::add)));
            for (PurchasePlanDetailVO detailVO : newDetailList) {
                if (!collect1.containsKey(detailVO.getMaterialId())) continue;
                if (ComputeUtil.isGreaterThan((BigDecimal)collect1.get(detailVO.getMaterialId()), (BigDecimal)detailVO.getResidueNum())) {
                    detailVO.setExcessResidueDetailFlag(Integer.valueOf(1));
                } else {
                    detailVO.setExcessResidueDetailFlag(Integer.valueOf(0));
                }
                if (ComputeUtil.isGreaterThan((BigDecimal)collect1.get(detailVO.getMaterialId()), (BigDecimal)detailVO.getNum())) {
                    detailVO.setExcessDetailFlag(Integer.valueOf(1));
                }
                detailVO.setExcessDetailFlag(Integer.valueOf(0));
            }
            vo.setDetailList(newDetailList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public ParamsCheckVO checkParams(PurchasePlanVO planVo) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        String[] alertArray = new String[]{"\u4ec5\u63d0\u793a", "\u8d85\u91cf\u5ba1\u6279", "\u4e0d\u53ef\u63d0\u4ea4"};
        if (CollectionUtils.isNotEmpty((Collection)planVo.getDetailList())) {
            List filterList;
            List detailList = planVo.getDetailList();
            List noPlanList = detailList.stream().filter(e -> !"del".equals(e.getRowState()) && 0 == e.getWorkPlanFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noPlanList)) {
                Map<Long, List<PurchasePlanDetailVO>> collect1 = noPlanList.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialTypeId));
                Map<Long, List<MaterialCategorySettingsEntity>> longListMap = this.categorySettingsService.returnSettings(new ArrayList<Long>(collect1.keySet()));
                for (Map.Entry<Long, List<PurchasePlanDetailVO>> entry : collect1.entrySet()) {
                    if (!longListMap.containsKey(entry.getKey())) continue;
                    for (PurchasePlanDetailVO detailVO : entry.getValue()) {
                        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                        ParamsCheckVO paramsCheck = new ParamsCheckVO();
                        paramsCheck.setWarnType(paramsArray[2]);
                        ParamsCheckDsVO checkVO = new ParamsCheckDsVO();
                        checkVO.setOrgName(planVo.getOrgName());
                        checkVO.setWarnItem("\u4e25\u7ba1\u6750\u6599\u65e0\u603b\u63a7\u8ba1\u5212\uff0c\u8bf7\u7f16\u5236/\u53d8\u66f4\u603b\u63a7\u8ba1\u5212");
                        checkVO.setWarnName("\u4e25\u7ba1\u6750\u6599\u65e0\u603b\u63a7\u8ba1\u5212\uff0c\u8bf7\u7f16\u5236/\u53d8\u66f4\u603b\u63a7\u8ba1\u5212");
                        String stringBuffer = "\u3010\u6750\u6599\u5206\u7c7b\uff1a" + detailVO.getMaterialTypeName() + "\u7269\u8d44\u7f16\u7801\uff1a" + detailVO.getMaterialCode() + "\u7269\u8d44\u540d\u79f0\uff1a" + detailVO.getMaterialName() + "\u5c5e\u6027\u503c\uff1a" + detailVO.getPropertyShowName() + "\u578b\u53f7\uff1a" + detailVO.getMaterialCode() + "\u3011\u4e25\u7ba1\u6750\u6599\u65e0\u603b\u63a7\u8ba1\u5212\uff0c\u8bf7\u7f16\u5236/\u53d8\u66f4\u603b\u63a7\u8ba1\u5212";
                        checkVO.setContent(stringBuffer);
                        checkDsVOS.add(checkVO);
                        paramsCheck.setDataSource(checkDsVOS);
                        paramsCheckVOList.add(paramsCheck);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(filterList = detailList.stream().filter(e -> !"del".equals(e.getRowState()) && 1 == e.getExcessResidueDetailFlag()).collect(Collectors.toList()))) {
                Map<Long, List<PurchasePlanDetailVO>> collectByTypeId = filterList.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialTypeId));
                ArrayList<Long> categoryIds = new ArrayList<Long>(collectByTypeId.keySet());
                Map<Long, List<MaterialCategorySettingsEntity>> categoryIdSettings = this.categorySettingsService.returnSettings(categoryIds);
                for (Map.Entry<Long, List<MaterialCategorySettingsEntity>> entry : categoryIdSettings.entrySet()) {
                    List<PurchasePlanDetailVO> purchasePlanDetailVO = collectByTypeId.get(entry.getKey());
                    Map<String, List<PurchasePlanDetailVO>> collect = purchasePlanDetailVO.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialCode));
                    for (Map.Entry<String, List<PurchasePlanDetailVO>> sumDetail : collect.entrySet()) {
                        BigDecimal requirementNum = sumDetail.getValue().stream().collect(Collectors.reducing(BigDecimal.ZERO, PurchasePlanDetailVO::getRequirementNum, BigDecimal::add));
                        BigDecimal num = sumDetail.getValue().get(0).getNum();
                        BigDecimal totalRequirementNum = sumDetail.getValue().get(0).getTotalRequirementNum();
                        BigDecimal useAdd = ComputeUtil.safeAdd((BigDecimal)totalRequirementNum, (BigDecimal)requirementNum);
                        BigDecimal bigDecimal1 = ComputeUtil.safeSub((BigDecimal)useAdd, (BigDecimal)num);
                        BigDecimal bigDecimal = ComputeUtil.bigDecimalPercent((BigDecimal)bigDecimal1, (BigDecimal)num, (int)4);
                        if (null == entry.getValue()) continue;
                        List<MaterialCategorySettingsEntity> value = entry.getValue();
                        List sortCollect = value.stream().sorted(Comparator.comparing(MaterialCategorySettingsEntity::getControlMode)).collect(Collectors.toList());
                        for (MaterialCategorySettingsEntity settingsEntity : sortCollect) {
                            Integer controlMode1 = settingsEntity.getControlMode();
                            boolean checkFlag = false;
                            String warnType = "";
                            if (controlMode1 == 1 || controlMode1 == 2) {
                                if (ComputeUtil.isGreaterThan((BigDecimal)bigDecimal, (BigDecimal)settingsEntity.getMinControlRation()) && ComputeUtil.isLessOrEqual((BigDecimal)bigDecimal, (BigDecimal)settingsEntity.getMaxControlRation())) {
                                    checkFlag = true;
                                    warnType = paramsArray[1];
                                }
                            } else if (ComputeUtil.isGreaterThan((BigDecimal)bigDecimal, (BigDecimal)settingsEntity.getMinControlRation())) {
                                checkFlag = true;
                                warnType = paramsArray[2];
                            }
                            if (!checkFlag) continue;
                            for (PurchasePlanDetailVO detailVO : sumDetail.getValue()) {
                                ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                                ParamsCheckVO paramsCheck = new ParamsCheckVO();
                                paramsCheck.setWarnType(warnType);
                                Integer controlMode = settingsEntity.getControlMode();
                                ParamsCheckDsVO checkVO = new ParamsCheckDsVO();
                                checkVO.setOrgName(planVo.getOrgName());
                                checkVO.setWarnItem(alertArray[controlMode - 1]);
                                checkVO.setWarnName(alertArray[controlMode - 1].equals("\u4e0d\u53ef\u63d0\u4ea4") ? "\u4e0d\u53ef\u63d0\u4ea4,\u8bf7\u53d8\u66f4\u603b\u63a7\u8ba1\u5212!" : alertArray[controlMode - 1]);
                                String stringBuffer = "\u3010\u6750\u6599\u5206\u7c7b\uff1a" + detailVO.getMaterialTypeName() + "\u7269\u8d44\u7f16\u7801\uff1a" + detailVO.getMaterialCode() + "\u7269\u8d44\u540d\u79f0\uff1a" + detailVO.getMaterialName() + "\u5c5e\u6027\u503c\uff1a" + detailVO.getPropertyShowName() + "\u578b\u53f7\uff1a" + detailVO.getMaterialCode() + "\u3011\u603b\u63a7\u91cf" + detailVO.getNum() + "\u7d2f\u8ba1\u8d85\u91cf" + bigDecimal1;
                                checkVO.setContent(stringBuffer);
                                checkDsVOS.add(checkVO);
                                paramsCheck.setDataSource(checkDsVOS);
                                paramsCheckVOList.add(paramsCheck);
                            }
                        }
                    }
                }
            }
        }
        Map<String, List<ParamsCheckVO>> checkListMap = paramsCheckVOList.stream().filter(e -> e.getDataSource().size() > 0 && null != e.getWarnType()).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            paramsCheckVO.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            paramsCheckVO.setWarnType("warn");
        } else {
            paramsCheckVO.setWarnType("none");
        }
        for (ParamsCheckVO p : result) {
            paramsCheckVO.getDataSource().addAll(p.getDataSource());
        }
        return paramsCheckVO;
    }

    public boolean checkUpdateDetailParams(PurchasePlanVO planVo) {
        boolean flag = false;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        String[] alertArray = new String[]{"\u4ec5\u63d0\u793a", "\u8d85\u91cf\u5ba1\u6279", "\u4e0d\u53ef\u63d0\u4ea4"};
        ArrayList errList = new ArrayList();
        CommonResponse projectResp = this.projectPoolApi.queryProjectPoolById(planVo.getProjectId());
        if (!projectResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u6570\u636e\u51fa\u9519\uff01");
        }
        ProjectPoolSetVO p = (ProjectPoolSetVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((JSONArray)projectResp.getData()).get(0)), ProjectPoolSetVO.class);
        if (CollectionUtils.isNotEmpty((Collection)planVo.getDetailList())) {
            List filterList;
            List<PurchasePlanDetailEntity> controlPlanSumDetailEntities;
            HashMap<Long, BigDecimal> controlNum = new HashMap<Long, BigDecimal>();
            List<Long> materialIds = planVo.getDetailList().stream().filter(item -> !"del".equals(item.getRowState()) && null != item.getMaterialId()).map(PurchasePlanDetailVO::getMaterialId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(materialIds) && CollectionUtils.isNotEmpty(controlPlanSumDetailEntities = this.sumDetailService.queryList(materialIds, planVo.getProjectId()))) {
                controlNum.putAll(controlPlanSumDetailEntities.stream().collect(Collectors.toMap(item -> item.getMaterialId(), item -> item.getNum())));
            }
            if (CollectionUtils.isNotEmpty(filterList = planVo.getDetailList().stream().filter(e -> !"del".equals(e.getRowState()) && 1 == e.getExcessResidueDetailFlag()).collect(Collectors.toList()))) {
                Map<Long, List<PurchasePlanDetailVO>> collectByTypeId = filterList.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialTypeId));
                ArrayList<Long> categoryIds = new ArrayList<Long>(collectByTypeId.keySet());
                Map<Long, List<MaterialCategorySettingsEntity>> categoryIdSettings = this.categorySettingsService.returnSettings(categoryIds);
                for (Map.Entry<Long, List<MaterialCategorySettingsEntity>> entry : categoryIdSettings.entrySet()) {
                    List<PurchasePlanDetailVO> purchasePlanDetailVO = collectByTypeId.get(entry.getKey());
                    Map<String, List<PurchasePlanDetailVO>> collect = purchasePlanDetailVO.stream().collect(Collectors.groupingBy(PurchasePlanDetailVO::getMaterialCode));
                    for (Map.Entry<String, List<PurchasePlanDetailVO>> sumDetail : collect.entrySet()) {
                        BigDecimal requirementNum = sumDetail.getValue().stream().collect(Collectors.reducing(BigDecimal.ZERO, PurchasePlanDetailVO::getRequirementNum, BigDecimal::add));
                        BigDecimal num = sumDetail.getValue().get(0).getNum();
                        BigDecimal totalRequirementNum = sumDetail.getValue().get(0).getTotalRequirementNum();
                        BigDecimal useAdd = ComputeUtil.safeAdd((BigDecimal)totalRequirementNum, (BigDecimal)requirementNum);
                        BigDecimal bigDecimal1 = ComputeUtil.safeSub((BigDecimal)useAdd, (BigDecimal)num);
                        if (ComputeUtil.isGreaterThan((BigDecimal)bigDecimal1, (BigDecimal)num)) {
                            sumDetail.getValue().stream().forEach(e -> {
                                if (StringUtils.isBlank((CharSequence)e.getExcessCause()) && !errList.contains(e.getMaterialCode()) && (controlNum.containsKey(e.getMaterialId()) || PlanConstant.INTEGER_YES.equals(p.getControlPurPlanFlag()))) {
                                    errList.add(e.getMaterialCode());
                                }
                            });
                        }
                        BigDecimal bigDecimal = ComputeUtil.bigDecimalPercent((BigDecimal)bigDecimal1, (BigDecimal)num, (int)4);
                        if (null == entry.getValue()) continue;
                        List<MaterialCategorySettingsEntity> value = entry.getValue();
                        List sortCollect = value.stream().sorted(Comparator.comparing(MaterialCategorySettingsEntity::getControlMode)).collect(Collectors.toList());
                        for (MaterialCategorySettingsEntity settingsEntity : sortCollect) {
                            Integer controlMode1 = settingsEntity.getControlMode();
                            boolean checkFlag = false;
                            String warnType = "";
                            if (controlMode1 == 1 || controlMode1 == 2) {
                                if (ComputeUtil.isGreaterThan((BigDecimal)bigDecimal, (BigDecimal)settingsEntity.getMinControlRation()) && ComputeUtil.isLessOrEqual((BigDecimal)bigDecimal, (BigDecimal)settingsEntity.getMaxControlRation())) {
                                    checkFlag = true;
                                    warnType = paramsArray[1];
                                }
                            } else if (ComputeUtil.isGreaterThan((BigDecimal)bigDecimal, (BigDecimal)settingsEntity.getMinControlRation())) {
                                checkFlag = true;
                                warnType = paramsArray[2];
                            }
                            if (!checkFlag) continue;
                            for (PurchasePlanDetailVO detailVO : sumDetail.getValue()) {
                                ArrayList checkDsVOS = new ArrayList();
                                ParamsCheckVO paramsCheck = new ParamsCheckVO();
                                paramsCheck.setWarnType(warnType);
                                Integer controlMode = settingsEntity.getControlMode();
                                if (controlMode != 2) continue;
                                flag = true;
                                return true;
                            }
                        }
                    }
                    if (!CollectionUtils.isNotEmpty(errList)) continue;
                    throw new BusinessException("\u8bf7\u586b\u5199\u5bf9\u5e94\u7269\u8d44\u7f16\u7801" + errList.stream().collect(Collectors.joining(",")) + "\u7684\u8d85\u91cf\u539f\u56e0\uff01");
                }
            }
        }
        return false;
    }

    @Override
    public CommonResponse<Map<Long, PurchasePlanDetailVO>> queryMaterialListSum(List<Long> materialIds, Long projectId) {
        if (CollectionUtils.isNotEmpty(materialIds)) {
            List<PurchasePlanDetailEntity> controlPlanSumDetailEntities = this.sumDetailService.queryList(materialIds, projectId);
            List<PurchasePlanDetailVO> purchasePlanDetailVOS = this.detailService.selectPlanSumByMaterialIds(materialIds, projectId);
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal decimal1 = null;
            if (CollectionUtils.isNotEmpty(controlPlanSumDetailEntities)) {
                List purchasePlanVOS = BeanMapper.mapList(controlPlanSumDetailEntities, PurchasePlanDetailVO.class);
                Map<Long, PurchasePlanDetailVO> collect = purchasePlanVOS.stream().collect(Collectors.toMap(PurchasePlanDetailVO::getMaterialId, e -> e));
                for (PurchasePlanDetailVO entry : purchasePlanDetailVOS) {
                    if (collect.containsKey(entry.getMaterialId())) {
                        collect.get(entry.getMaterialId()).setResidueNum(ComputeUtil.isGreaterThan((BigDecimal)(decimal1 = ComputeUtil.safeSub((BigDecimal)(num = collect.get(entry.getMaterialId()).getNum()), (BigDecimal)entry.getRequirementNum())), (BigDecimal)BigDecimal.ZERO) ? decimal1 : BigDecimal.ZERO);
                        continue;
                    }
                    entry.setResidueNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)entry.getRequirementNum()));
                    collect.put(entry.getMaterialId(), entry);
                }
                return CommonResponse.success(collect);
            }
            if (CollectionUtils.isNotEmpty(purchasePlanDetailVOS)) {
                Iterator<PurchasePlanDetailVO> iterator = purchasePlanDetailVOS.iterator();
                while (iterator.hasNext()) {
                    PurchasePlanDetailVO entry;
                    decimal1 = ComputeUtil.safeSub((BigDecimal)num, (BigDecimal)(entry = iterator.next()).getRequirementNum());
                    entry.setResidueNum(ComputeUtil.isGreaterThan((BigDecimal)decimal1, (BigDecimal)BigDecimal.ZERO) ? decimal1 : BigDecimal.ZERO);
                }
                return CommonResponse.success(purchasePlanDetailVOS.stream().collect(Collectors.toMap(item -> item.getMaterialId(), item -> item)));
            }
        }
        return CommonResponse.success(new HashMap());
    }

    @Override
    public CommonResponse<Map<String, BigDecimal>> queryAllotOrgSum(List<String> materialCodes, Long projectId) {
        if (CollectionUtils.isNotEmpty(materialCodes)) {
            CommonResponse projectVOCommonResponse = this.projectPoolApi.queryDetailById(projectId);
            ProjectVO data = (ProjectVO)projectVOCommonResponse.getData();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"org_id", (Object)data.getOrgId());
            queryWrapper.in((Object)"material_code", materialCodes);
            List list = this.goodsService.list((Wrapper)queryWrapper);
            HashMap<String, BigDecimal> collect = new HashMap<String, BigDecimal>();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Map<String, List<GoodsEntity>> collect1 = list.stream().collect(Collectors.groupingBy(GoodsEntity::getMaterialCode));
                for (Map.Entry<String, List<GoodsEntity>> entity : collect1.entrySet()) {
                    if (!CollectionUtils.isNotEmpty((Collection)entity.getValue())) continue;
                    List<GoodsEntity> value = entity.getValue();
                    BigDecimal num = BigDecimal.ZERO;
                    for (GoodsEntity e : value) {
                        num = ComputeUtil.safeSub((BigDecimal)num, (BigDecimal)e.getNum());
                    }
                    collect.put(entity.getKey(), num);
                }
            }
            return CommonResponse.success(collect);
        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<BigDecimal> queryAllotOtherSum(String materialCode, Long brandId, Long projectId) {
        CommonResponse projectVOCommonResponse = this.projectPoolApi.queryDetailById(projectId);
        ProjectVO data = (ProjectVO)projectVOCommonResponse.getData();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ne((Object)"org_id", (Object)data.getOrgId());
        queryWrapper.eq((Object)"material_code", (Object)materialCode);
        queryWrapper.eq((Object)"brand_id", (Object)brandId);
        List list = this.goodsService.list((Wrapper)queryWrapper);
        BigDecimal num = BigDecimal.ZERO;
        for (GoodsEntity entity : list) {
            num = ComputeUtil.safeSub((BigDecimal)num, (BigDecimal)entity.getNum());
        }
        return CommonResponse.success((Object)num);
    }

    @Override
    public void checkMaterialSumPlan(List<Long> materialIds, Long projectId) {
        ArrayList materialNames = new ArrayList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.in((Object)"bill_type", new Object[]{PlanConstant.CHANGE_ING});
        queryWrapper.notIn((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.controlPlanService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            QueryWrapper queryParam = new QueryWrapper();
            queryParam.in((Object)"plan_id", (Collection)list.stream().map(e -> e.getId()).collect(Collectors.toList()));
            List detailList = this.controlPlanDetailService.list((Wrapper)queryParam);
            if (CollectionUtils.isNotEmpty((Collection)detailList)) {
                detailList.stream().forEach(e -> {
                    if (materialIds.indexOf(e.getMaterialId()) > -1) {
                        materialNames.add(e.getMaterialName());
                    }
                });
                if (CollectionUtils.isNotEmpty(materialNames)) {
                    throw new BusinessException("\u5f53\u524d\u7269\u6599" + String.join((CharSequence)", ", materialNames) + "\u5728\u603b\u63a7\u8ba1\u5212\u6c47\u603b\u4e2d\u5904\u4e8e\u53d8\u66f4\u4e2d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u6216\u63d0\u4ea4\u91c7\u8d2d\u8ba1\u5212\uff01");
                }
            }
        }
    }

    @Override
    public void planToSum(PurchasePlanEntity plan, boolean addFlag) {
        if (CollectionUtils.isNotEmpty(plan.getDetailList())) {
            List<PurchasePlanDetailEntity> detailList = plan.getDetailList();
            List collect = detailList.stream().filter(e -> e.getWorkPlanFlag() == 1).collect(Collectors.toList());
            this.logger.info("collect" + JSONObject.toJSONString(collect));
            if (CollectionUtils.isNotEmpty(collect)) {
                Map<Long, List<PurchasePlanDetailEntity>> collect1 = collect.stream().collect(Collectors.groupingBy(PurchasePlanDetailEntity::getMaterialId));
                this.logger.info("collect1" + JSONObject.toJSONString(collect1));
                QueryWrapper detailEntityQueryWrapper = new QueryWrapper();
                detailEntityQueryWrapper.in((Object)"material_id", collect1.keySet());
                List<ControlPlanSumDetailEntity> list = this.sumDetailService.queryListBySum(collect.stream().map(PurchasePlanDetailEntity::getMaterialId).collect(Collectors.toList()), plan.getProjectId());
                if (CollectionUtils.isNotEmpty(list)) {
                    for (ControlPlanSumDetailEntity e2 : list) {
                        if (collect1.containsKey(e2.getMaterialId())) {
                            List<PurchasePlanDetailEntity> purchasePlanDetailEntities = collect1.get(e2.getMaterialId());
                            BigDecimal decimal = purchasePlanDetailEntities.stream().map(PurchasePlanDetailEntity::getRequirementNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal getPlanNum = e2.getPlanNum();
                            if (addFlag) {
                                e2.setPlanNum(ComputeUtil.safeAdd((BigDecimal)decimal, (BigDecimal)getPlanNum));
                            } else {
                                e2.setPlanNum(ComputeUtil.safeSub((BigDecimal)getPlanNum, (BigDecimal)decimal));
                            }
                        }
                        if (e2.getPlanNum() != null && e2.getPlanNum().compareTo(BigDecimal.ZERO) == 1) {
                            e2.setQuoteType(2);
                            continue;
                        }
                        e2.setQuoteType(1);
                    }
                    this.sumDetailService.saveOrUpdateBatch(list);
                }
            }
        }
    }

    @Override
    public IPage<SupPurchasePlanVo> supQueryList(Map<String, Object> params) {
        Page page = new Page();
        ArrayList<SupPurchasePlanVo> voList = new ArrayList<SupPurchasePlanVo>();
        if (!params.containsKey("pageNumber")) {
            throw new BusinessException("pageNumber \u672a\u4f20\u5165!");
        }
        if (!params.containsKey("pageSize")) {
            throw new BusinessException("pageSize \u672a\u4f20\u5165!");
        }
        page.setCurrent((long)Integer.valueOf(params.get("pageNumber").toString()).intValue());
        page.setSize((long)Integer.valueOf(params.get("pageSize").toString()).intValue());
        long total = this.mapper.count(params);
        page.setTotal(total);
        if (total == 0L) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1L ? 0L : page.getCurrent() - 1L) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        List<PurchasePlanEntity> list = this.mapper.getList(params);
        List<Long> collect1 = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        Map<Long, String> collect = list.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getCreateUserSid()));
        JSONObject paramStr = new JSONObject();
        paramStr.put("sourceIds", collect1);
        paramStr.put("orderType", (Object)"desc");
        ArrayList<Object> inforVos = new ArrayList<Object>();
        CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(paramStr);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            for (AttachmentVO vo : data) {
                ArchivesInforVo archivesInforVo = new ArchivesInforVo();
                if (collect.containsKey(vo.getSourceId())) {
                    archivesInforVo.setAttach_Uploader_Sid(collect.get(vo.getSourceId()));
                }
                archivesInforVo.setAttach_Uploader(vo.getUploadUserName());
                archivesInforVo.setAttach_Name(vo.getFileName().replaceAll(" ", ""));
                archivesInforVo.setAttach_Extension(vo.getFileName());
                archivesInforVo.setAttachBase64(vo.getTruePath());
                archivesInforVo.setAttach_UploadDateTime(vo.getCreateTime());
                archivesInforVo.setSourceId(vo.getSourceId().toString());
                archivesInforVo.setPS_PurchasePlan_FK(new UUID(vo.getSourceId(), vo.getSourceId() >> 64).toString());
                inforVos.add(archivesInforVo);
            }
        }
        Map<String, List<ArchivesInforVo>> fileCollect = inforVos.stream().collect(Collectors.groupingBy(ArchivesInforVo::getSourceId));
        List<PurchasePlanDetailEntity> supPurchasePlanDetailVOS = this.detailMapper.selectPlanByPIds(collect1);
        ArrayList<SupPurchasePlanDetailVO> detailVOS = new ArrayList<SupPurchasePlanDetailVO>();
        for (PurchasePlanDetailEntity detail : supPurchasePlanDetailVOS) {
            SupPurchasePlanDetailVO supPurchasePlanDetailVO = this.returnSubDetail(detail);
            detailVOS.add(supPurchasePlanDetailVO);
        }
        Map<String, List<SupPurchasePlanDetailVO>> collect2 = detailVOS.stream().collect(Collectors.groupingBy(SupPurchasePlanDetailVO::getPS_PurchasePlan_FK));
        for (PurchasePlanEntity entity : list) {
            String planGuid = new UUID(entity.getId(), entity.getId() >> 64).toString();
            SupPurchasePlanVo vo = this.returnSubEntity(entity);
            if (collect2.containsKey(planGuid)) {
                List<SupPurchasePlanDetailVO> detailVOS1 = collect2.get(planGuid);
                Integer[] arr = new Integer[]{1};
                List cc = detailVOS1.stream().peek(e -> {
                    Integer n = arr[0];
                    Integer n2 = arr[0] = Integer.valueOf(arr[0] + 1);
                    e.setSortID(n.toString());
                }).collect(Collectors.toList());
                vo.setDetails(cc);
            }
            if (fileCollect.containsKey(vo.getYQL_SID())) {
                vo.setArchivesInfor(fileCollect.get(vo.getYQL_SID()));
            }
            voList.add(vo);
        }
        page.setRecords(voList);
        return page;
    }

    public SupPurchasePlanDetailVO returnSubDetail(PurchasePlanDetailEntity detail) {
        SupPurchasePlanDetailVO supPurchasePlanDetailVO = new SupPurchasePlanDetailVO();
        supPurchasePlanDetailVO.setYQL_SID(detail.getId().toString());
        supPurchasePlanDetailVO.setMaterialClass(detail.getMaterialTypeName());
        supPurchasePlanDetailVO.setListMaterialCodeT(detail.getMaterialCode());
        supPurchasePlanDetailVO.setMaterialName(detail.getMaterialName() + "." + detail.getPropertyValue());
        supPurchasePlanDetailVO.setMaterialClassSid(null == detail.getMaterialTypeSid() ? null : detail.getMaterialTypeSid());
        supPurchasePlanDetailVO.setMaterialClass_FK(new UUID(detail.getMaterialId(), detail.getMaterialId() >> 64).toString());
        supPurchasePlanDetailVO.setMeteringUnit(detail.getUnitName());
        supPurchasePlanDetailVO.setBuyAmount(detail.getRequirementNum().toString());
        supPurchasePlanDetailVO.setPS_PurchasePlan_FK(new UUID(detail.getPlanId(), detail.getPlanId() >> 64).toString());
        supPurchasePlanDetailVO.setSupplyTime(detail.getPlanInDate());
        supPurchasePlanDetailVO.setMemo(detail.getMemo());
        supPurchasePlanDetailVO.setModelNorm(detail.getPropertyValue());
        supPurchasePlanDetailVO.setListMaterialCode(detail.getMaterialSerialNo());
        supPurchasePlanDetailVO.setMaterialCode(detail.getCostCodingName());
        supPurchasePlanDetailVO.setSystemClassifyName(detail.getSystemClassifyName());
        supPurchasePlanDetailVO.setInventoryClassifyCode(detail.getInventoryClassifyCode());
        supPurchasePlanDetailVO.setNewPropertyVal(detail.getSourceType() == 2 ? "1" : "0");
        return supPurchasePlanDetailVO;
    }

    public SupPurchasePlanVo returnSubEntity(PurchasePlanEntity entity) {
        SupPurchasePlanVo vo = new SupPurchasePlanVo();
        vo.setYQL_SID(entity.getId().toString());
        vo.setMa_id(entity.getBillCode());
        vo.setStatus("2");
        vo.setAccount_Project_Id(entity.getProjectCode());
        vo.setAccountingProjectSet_FK(entity.getProjectSid());
        vo.setAccount_Project_Shortname(entity.getProjectName());
        vo.setProjectManager(entity.getProjectManagerName());
        vo.setProjectManager_Sid(null == entity.getProjectManagerSid() ? null : entity.getProjectManagerSid().toString());
        vo.setResponsibleEngineer(entity.getEngineerName());
        vo.setResponsibleEngineer_Sid(null == entity.getEngineerSid() ? null : entity.getEngineerSid().toString());
        vo.setPurchaseEngineer(entity.getPurchaseWorkerName());
        vo.setPurchaseEngineer_Sid(null == entity.getPurchaseWorkerSid() ? null : entity.getPurchaseWorkerSid().toString());
        vo.setMajor(entity.getJobSpecialtyName());
        vo.setMajorSid(entity.getJobSpecialtyCode());
        vo.setProjectChiefEngineer(entity.getChiefEngineerName());
        vo.setProjectChiefEngineer_Sid(null == entity.getChiefEngineerSid() ? null : entity.getChiefEngineerSid().toString());
        vo.setBusContractName(entity.getBusinessContractName());
        vo.setBuContractSID(null == entity.getBusinessContractId() ? null : entity.getBusinessContractId().toString());
        vo.setBusContractCode(entity.getBusinessContractCode());
        vo.setPurchaseContent(entity.getMemo());
        vo.setSYS_Created(entity.getCreateTime());
        vo.setApprDate(entity.getEffectDate());
        vo.setRegister_Name(entity.getCreateUserName());
        vo.setPosition_Name(entity.getUserPostName());
        vo.setDivision_Name(entity.getUserDepartName());
        vo.setOrg_Name(entity.getUserOrgName());
        vo.setApprHuman_sid(null == entity.getApproveUserSid() ? null : entity.getApproveUserSid().toString());
        vo.setAccount_Project_Fullname(entity.getProjectName());
        vo.setApprHuman(entity.getApproveUserName());
        vo.setSYS_CreatedBy(entity.getCreateUserSid());
        return vo;
    }
}

