package com.ejianc.business.zdsmaterial.cloudstore.apply.controller;

import java.io.Serializable;

import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.AllotApplyDetailEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyDetailVO;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.zdsmaterial.cloudstore.apply.bean.AllotApplyEntity;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IAllotApplyService;
import com.ejianc.business.zdsmaterial.cloudstore.apply.vo.AllotApplyVO;

/**
 * 调拨申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("allotApply")
public class AllotApplyController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ALLOT_ACCEPT";//此处需要根据实际修改

    @Autowired
    private IAllotApplyService service;

    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private IGoodsService goodsService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllotApplyVO> saveOrUpdate(@RequestBody AllotApplyVO saveOrUpdateVO) {
    	AllotApplyEntity entity = BeanMapper.map(saveOrUpdateVO, AllotApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        List<AllotApplyDetailEntity> detailList = entity.getDetailList();
    	if (CollectionUtils.isNotEmpty(detailList)){
            List<Long> collect = detailList.stream().map(e -> e.getSourceId()).collect(Collectors.toList());
            Map<Long, BigDecimal> allotableNum = goodsService.getAllotableNum(collect);
            for (AllotApplyDetailEntity detail: detailList){
                if (allotableNum.containsKey(detail.getSourceId())){
                    BigDecimal decimal = allotableNum.get(detail.getSourceId());
                    if (ComputeUtil.isGreaterThan(detail.getAllotNum(),decimal)){
                        return CommonResponse.error("物资："+detail.getMaterialName()+"调拨量大于上架数量!");
                    }
                }
            }
        }

        BigDecimal decimal = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty(x.getMaterialTypeName())).collect(Collectors.reducing(BigDecimal.ZERO, AllotApplyDetailVO::getAllotTaxMny, BigDecimal::add));
        entity.setTaxMny(decimal);
        String materialTypeNames = saveOrUpdateVO.getDetailList().stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty(x.getMaterialTypeName())).map(AllotApplyDetailVO::getMaterialTypeName).collect(Collectors.toSet()).stream().distinct().collect(Collectors.joining(","));
        entity.setMaterialNames(materialTypeNames);
    	service.saveOrUpdate(entity, false);
    	AllotApplyVO vo = BeanMapper.map(entity, AllotApplyVO.class);
        return queryDetail(entity.getId());
    }



    /**
     * @Description saveOrUpdate 根据集市新增调拨
     */
    @RequestMapping(value = "/addAllotApplyByGoods", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AllotApplyVO> addAllotApplyByGoods(@RequestBody GoodsVO goodsVO){
        AllotApplyVO allotApplyVO = service.addAllotApplyByGoods(goodsVO);
        return CommonResponse.success(allotApplyVO);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AllotApplyVO> queryDetail(Long id) {
        return service.queryDetail(id);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AllotApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (AllotApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AllotApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AllotApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("purUserName");
        fuzzyFields.add("inProjectCode");
        fuzzyFields.add("purUserPhone");
        fuzzyFields.add("materialNames");
//        项目名称、单据编号、联系人、单据编码、项目编码、联系电话、物资分类
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("inParentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("inOrgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<AllotApplyEntity> page = service.queryPage(param,false);
        IPage<AllotApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), AllotApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<AllotApplyVO>  records = new ArrayList<>();
        CommonResponse<IPage<AllotApplyVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()){
             records = iPageCommonResponse.getData().getRecords();
        }
        records.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("AllotApply-export.xlsx", beans, response);
    }

}
