package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cloudstore.constants.CommonConstants;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.*;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceFileEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceOcrEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MatInvoiceMapper;
import com.ejianc.business.zdsmaterial.material.service.IMatCheckerSettingService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceDetailService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceService;
import com.ejianc.business.zdsmaterial.material.vo.MatInvoiceVO;
import com.ejianc.business.zdsmaterial.util.*;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 采购发票登记
 *
 * @author generator
 *
 */
@Service("matInvoiceService")
public class MatInvoiceServiceImpl extends BaseServiceImpl<MatInvoiceMapper, MatInvoiceEntity> implements IMatInvoiceService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = PlanConstant.MAT_INVOICE_BILL_TYPE;
    private static final String BILL_NAME = "采购发票登记";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/matInvoice/supSignSync";
    private static final String BILL_CODE = "MAT_INVOICE";

    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Value("${common.env.base-host}")
    private String BASE_HOST;

    @Autowired
    private IPushMessageApi pushMessageApi;


    @Autowired
    private IMatSupplierApi matSupplierApi;

    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IErpInvoiceService erpInvoiceService;

    @Autowired
    private PushFileUtil pushFileUtil;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IContractService contractService;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IErpInvoiceDetailService invoiceDetailService;

    @Autowired
    private IMatCheckerSettingService matCheckerSettingService;

    @Autowired
    private IMessageInfoService messageInfoService;

    @Autowired
    private IErpInvoiceDetailService erpInvoiceDetailService;

    private final String COMPANY_SOCIAL_CODE = "company_social_code";
    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IContractManagerService contractManagerService;

    @Autowired
    private IMatInvoiceDetailService detailService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveSyncBill(HttpServletRequest request) {
        logger.info("进入保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String fileStrList = request.getParameter("fileList");
        List<AttachmentVO> fileList = JSONArray.parseArray(fileStrList, AttachmentVO.class);
        logger.info("接收到数据transData：{}，fileList：{},", transData, fileStrList);
        MatInvoiceVO vo = JSONObject.parseObject(transData, MatInvoiceVO.class);
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("单据信息为空！");
        }
        MatInvoiceEntity saveEntity = BeanMapper.map(vo, MatInvoiceEntity.class);

        try {
            boolean lock  = BillLockUtil.getLock(BILL_TYPE, vo.getId(), 600);
            if(!lock) {
                throw new BusinessException("单据信息处理中，请勿重复操作！");
            }

            saveEntity.setPrintFlag(PlanConstant.INTEGER_NO);//默认未打印

            //查询审核人信息,讲审核人(合同的录入人)作为单据的创建人
            EmployeeVO craetor = null;
//        if(StringUtils.isBlank(saveEntity.getAdminId())) {
//            throw new BusinessException("操作失败,未获取到发票审核人信息!");
//        }

            if("1".equals(saveEntity.getOpenOcrState())){// 制单时已开启OCR识别
                Set<String> inValidNumbers= saveEntity.getDetailList().stream().filter(x->!"del".equals(x.getRowState()) && !"1".equals(x.getOcrState()))
                        .map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
                if(CollectionUtils.isNotEmpty(inValidNumbers)) {
                    throw new BusinessException("操作失败, 号码为【"+ inValidNumbers.stream().collect(Collectors.joining("、")) + "】的发票未上传发票附件！");
                }
                inValidNumbers= saveEntity.getDetailList().stream().filter(x->!"del".equals(x.getRowState()) && !"查验通过".equals(x.getOcrCheckMsg()))
                        .map(x -> x.getInvoiceNumber()).collect(Collectors.toSet());
                if(CollectionUtils.isNotEmpty(inValidNumbers)) {
                    throw new BusinessException("操作失败, 发票【"+ inValidNumbers.stream().collect(Collectors.joining("、")) + "】下存在查验未通过的清单！");
                }
            } else if(CollectionUtils.isEmpty(saveEntity.getFileList())) {
                throw new BusinessException("操作失败, 未上传发票附件!");
            }

            //验证发票抬头和对应合同的甲方名称是否一致，不一致则不允许供方提交
            ContractEntity contract= contractService.selectById(saveEntity.getContractId());
            if(null == contract) {
                logger.error("根据采购合同id-{}，查询对应采购合同信息为空！", saveEntity.getContractId());
                throw new BusinessException("操作失败, 查询发票对应合同信息失败!");
            }

            if(CollectionUtils.isEmpty(saveEntity.getDetailList())) {
                throw new BusinessException("操作失败，发票清单为空！");
            }

            if(StringUtils.isNotBlank(contract.getContractPartyA())) {
                String partA = contract.getContractPartyA();
                Set<String> invoiceNumers = saveEntity.getDetailList().stream().filter(item -> !partA.replaceAll("（", "(").replaceAll("）", ")")
                        .equals(item.getInvoiceHeader().replaceAll("（", "(").replaceAll("）", ")"))).map(item -> item.getInvoiceNumber()).collect(Collectors.toSet());
                if(CollectionUtils.isNotEmpty(invoiceNumers)) {
                    throw new BusinessException("操作失败，发票【"+ invoiceNumers.stream().collect(Collectors.joining("、")) +"】抬头与合同甲方信息不一致！");
                }
                //查验甲方同意社会信用代码
                if("1".equals(saveEntity.getOpenOcrState()) && CollectionUtils.isNotEmpty(saveEntity.getOcrList())) {// 制单时已开启OCR识别
                    String socialCode = null;
                    CommonResponse<List<DefdocDetailVO>> defDetails = defdocApi.detailListByDetailNamesAndDocCode(new String[]{partA}, COMPANY_SOCIAL_CODE);
                    if(!defDetails.isSuccess() || CollectionUtils.isEmpty(defDetails.getData())) {
                        logger.info("*******获取甲方：{}对应社会统一信用代码失败或为空*********！");
                    }

                    List<DefdocDetailVO> companySocialVos = defDetails.getData().stream().filter(item -> item.getName().equals(partA)).collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(companySocialVos)) {
                        socialCode = companySocialVos.get(0).getCode();
                    }

                    JSONObject identifyResult = null;
                    for(MatInvoiceOcrEntity item : saveEntity.getOcrList()) {
                        identifyResult = JSONObject.parseObject(item.getIdentifyResult());

                        if(StringUtils.isNotBlank(partA) && !partA.replaceAll("（", "(").replaceAll("）", ")")
                                .equals(identifyResult.getString("purchaserName").replaceAll("（", "(").replaceAll("）", ")"))) {
                            throw new BusinessException("操作失败：购买方与合同甲方信息不一致");
                        }
                        if(StringUtils.isNotBlank(socialCode) && !socialCode.equalsIgnoreCase(identifyResult.getString("purchaserTaxNumber"))) {
                            throw new BusinessException("操作失败：购买方社会统一信用代码错误");
                        }

                    }
                }
            }

            //查询合同对应审核人
            Long checkerId = contractManagerService.getContractOperator(saveEntity.getContractId(), "1");
            if(null == checkerId) {
                checkerId = matCheckerSettingService.getByContractId(saveEntity.getContractId());
            }

            if(null == checkerId && StringUtils.isNotBlank(saveEntity.getAdminId())) {
                checkerId = Long.valueOf(saveEntity.getAdminId());
            }
            if(null == checkerId) {
                logger.error("根据采购合同id-{}，查询对应采购发票人信息为空！", saveEntity.getContractId());
                throw new BusinessException("操作失败,发票未设置对应审核人!");
            }
            CommonResponse<EmployeeVO> creatorResp = employeeApi.getById(checkerId);
            if(!creatorResp.isSuccess()) {
                logger.error("查询发票审核人-{}信息失败,{}", checkerId, JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("操作失败,查询发票审核人信息失败!");
            }

            if(null == creatorResp.getData()) {
                logger.error("查询发票审核人-{}信息为空,{}", checkerId, JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("操作失败,查询发票审核人信息失败!");
            }
            craetor = creatorResp.getData();

            if(!checkerId.equals(saveEntity.getAdminId())) {
                saveEntity.setAdminId(craetor.getId().toString());
                saveEntity.setAdminCode(craetor.getCode());
                saveEntity.setAdminName(craetor.getName());
            }

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                saveEntity.setBillCode(billCode.getData());
            }
            saveEntity.setSourceId(saveEntity.getId());
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            saveEntity.setSignState(Integer.valueOf(PlanConstant.CHECK_STATE_UN));
            CommonUtils.clearInvalidData(saveEntity);// 初始化数据
            saveEntity.setRejectReason(null); //清空驳回原因
            saveEntity.setCreateUserName(craetor.getUserName());
            saveEntity.setCreateUserId(craetor.getUserId());
            saveEntity.setCreateUserCode(craetor.getCode());
            saveEntity.setPushErpFlag(PlanConstant.STRING_NO); //未推送ERP

            List<Long> invoiceIds = new ArrayList<>();
            List<String> invoiceNums = new ArrayList<>();
            for(MatInvoiceDetailEntity detail : saveEntity.getDetailList()){
                detail.setSourceId(detail.getId());
                detail.setSourceMainId(detail.getMainId());
                CommonUtils.clearInvalidData(detail);// 初始化数据
                detail.setCreateUserCode(craetor.getUserCode());
                invoiceIds.add(detail.getInvoiceId());
            }

            //查询发票引用状态 && 发票设置为引用状态
            if(CollectionUtils.isNotEmpty(invoiceIds)) {
                List<ErpInvoiceEntity> invoiceList = erpInvoiceService.getAllByIds(invoiceIds);
                invoiceNums = invoiceList.stream().map(ErpInvoiceEntity::getNumber).collect(Collectors.toList());
                List<ErpInvoiceEntity> list = erpInvoiceService.getAllByInvoiceNums(invoiceNums);
                logger.info("采购: 根据发票号：{}, EL查询到发票数：{}", JSONObject.toJSONString(invoiceNums), list.size());
                Set<String> quoteNumList = new HashSet<>();
                for(ErpInvoiceEntity e : list) {
                    logger.info("采购发票id-{},number-{}, ERP引用标识：{}", e.getId(), e.getNumber(), e.getErpQuoteFlag());
                    if(PlanConstant.STRING_YES.equals(e.getQuoteFlag()) || PlanConstant.STRING_YES.equals(e.getErpQuoteFlag())) {
                        quoteNumList.add(e.getNumber());
                    }
                }

                if(CollectionUtils.isNotEmpty(quoteNumList)) {
                    throw new BusinessException("操作失败，号码为【"+quoteNumList.stream().collect(Collectors.joining(","))+"】的发票已被使用！");
                }

                //查询ERP最新发票信息，验证发票是否被引用
                if(CollectionUtils.isNotEmpty(saveEntity.getDetailList())) {
                    List<String> quotedInvoiceNums = erpInvoiceService.checkQuote(
                            new ArrayList<>(saveEntity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet())),
                            "mat");
                    if(CollectionUtils.isNotEmpty(quotedInvoiceNums)) {
                        throw new BusinessException("操作失败，号码为【"+quotedInvoiceNums.stream().collect(Collectors.joining(","))+"】的发票已被使用！");
                    }
                }

                //查询是否存在登记单引用了该发票
                List<String> quotedNums = getQuoteInfoByInvoiceNums(invoiceNums, null);
                if(CollectionUtils.isNotEmpty(quotedNums)) {
                    throw new BusinessException("操作失败，号码为【"+quotedNums.stream().collect(Collectors.joining(","))+"】的发票已被使用！");
                }


                invoiceList.stream().forEach(invoice -> invoice.setQuoteFlag(PlanConstant.STRING_YES));
                erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
            }

            //设置单据当前系统信息
            CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                logger.error("推送单据-{}失败，获取当前系统编码失败,{}", saveEntity.getSourceId(), ejcCloudSystemCode.getMsg());
            }
            //设置当前系统ID
            saveEntity.setSystemId(ejcCloudSystemCode.getData());

            //设置发票抬头
            if(CollectionUtils.isNotEmpty(saveEntity.getDetailList())) {
                saveEntity.setInvoiceHeader(saveEntity.getDetailList().get(0).getInvoiceHeader());
            }

            //保存单据中附件并获取到上传后附件的Id
            List<MatInvoiceFileEntity> subFileList = saveEntity.getFileList();
            for(MatInvoiceFileEntity file : subFileList){
                file.setSourceId(file.getId());
                file.setSourceMainId(file.getMainId());
                CommonUtils.clearInvalidData(file);// 初始化数据
                file.setCreateUserCode(craetor.getUserCode());
                file.setId(IdWorker.getId());
                if(null != file.getFileId()) {
                    Long fileId = pushFileUtil.uploadFileFormNet(BILL_TYPE, file.getId(), PlanConstant.MAT_INVOICE_FILE_SOURCE_TYPE, file.getFileId());
                    file.setFileId(fileId);
                    file.setFileUrl(BASE_HOST+"/ejc-file-web/attachment/filePreview?fileId="+fileId);
                } else {
                    file.setFileId(null);
                    file.setFileUrl(null);
                }
            }
            //保存单据中附件并获取到上传后附件的Id
            List<MatInvoiceOcrEntity> ocrList = saveEntity.getOcrList();
            for(MatInvoiceOcrEntity file : ocrList){
                file.setSourceId(file.getId());
                file.setSourceMainId(file.getMainId());
                CommonUtils.clearInvalidData(file);// 初始化数据
                file.setCreateUserCode(craetor.getUserCode());
                file.setId(IdWorker.getId());
                if(null != file.getFileId()) {
                    Long fileId = pushFileUtil.uploadFileFormNet(BILL_TYPE, file.getId(), PlanConstant.MAT_INVOICE_FILE_SOURCE_TYPE, file.getFileId());
                    file.setFileId(fileId);
                    file.setFileUrl(BASE_HOST+"/ejc-file-web/attachment/filePreview?fileId="+fileId);
                } else {
                    file.setFileId(null);
                    file.setFileUrl(null);
                }
            }
            //设置来源方式
            saveEntity.setSourceType(PlanConstant.SOURCE_TYPE_SUPPLIER);

            //赋值电子发票信息
            Map<Long, ErpInvoiceDetailEntity> invoiceDetailMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(saveEntity.getDetailList())){
                List<MatInvoiceDetailEntity> detailList = saveEntity.getDetailList();
                List<Long> invoiceDetailIds = detailList.stream().map(MatInvoiceDetailEntity::getInvoiceDetailId).collect(Collectors.toList());
                LambdaQueryWrapper<ErpInvoiceDetailEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.in(ErpInvoiceDetailEntity::getId, invoiceDetailIds);
                List<ErpInvoiceDetailEntity> invoiceDetailEntityList = erpInvoiceDetailService.list(queryWrapper);
                if(CollectionUtils.isNotEmpty(invoiceDetailEntityList)){
                    invoiceDetailMap = invoiceDetailEntityList.stream().collect(Collectors.toMap(ErpInvoiceDetailEntity::getId, Function.identity()));
                }
                for (MatInvoiceDetailEntity matInvoiceDetailEntity : detailList){
                    if (invoiceDetailMap.containsKey(matInvoiceDetailEntity.getInvoiceDetailId())){
                        ErpInvoiceDetailEntity erpInvoiceDetailEntity = invoiceDetailMap.get(matInvoiceDetailEntity.getInvoiceDetailId());
                        matInvoiceDetailEntity.setInvoiceDetailSpec(erpInvoiceDetailEntity.getDetailSpec());
                        matInvoiceDetailEntity.setInvoiceDetailUnitName(erpInvoiceDetailEntity.getDetailUnitName());
                        matInvoiceDetailEntity.setInvoiceDetailNum(erpInvoiceDetailEntity.getDetailNum());
                        matInvoiceDetailEntity.setInvoiceDetailMny(erpInvoiceDetailEntity.getDetailMny());
                        matInvoiceDetailEntity.setInvoiceDetailPrice(com.ejianc.framework.core.util.ComputeUtil.safeDiv(erpInvoiceDetailEntity.getDetailMny(),erpInvoiceDetailEntity.getDetailNum()));
                    }
                }
                saveEntity.setDetailList(detailList);
            }
            super.saveOrUpdate(saveEntity, false);

            //向发票管理员发送消息
            // 标题：【发票审核】，【单据编号】，【时间】需要您审核
            // 内容：【单据编号】，【项目名称】，【合同名称】，【供应商名称】提交了发票，请您审核！
            logger.info("供方发票提交, 向发票管理员id-{}发送消息", saveEntity.getAdminId());
            PushMsgParameter parameter = new PushMsgParameter();
            parameter.setSubject("【发票审核】：【"+saveEntity.getBillCode()+"】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()) +"】需要您审核！！");
            StringBuilder content = new StringBuilder();
            content.append("【").append(saveEntity.getBillCode()).append("】，【")
                    .append(saveEntity.getProjectName()).append("】，【")
                    .append(saveEntity.getContractName()).append("】，【").append(saveEntity.getSupplierName()).append("】提交了发票，请您审核！");
            parameter.setContent(content.toString());
            parameter.setPcUrl(BASE_HOST + CommonConstants.物资发票登记审核PC详情 + saveEntity.getId().toString());

            String[] recIds = new String[]{saveEntity.getAdminId()}; //发票管理员
            parameter.setReceivers(recIds);
            sendMsg(parameter, saveEntity.getId(), "供方发票提交 向发票管理员发送消息");
            //发送待办消息
            messageInfoService.sendTodo(Arrays.asList(saveEntity.getAdminId().split(",")),saveEntity.getId().toString(),PlanConstant.MAT_INVOICE_BILL_TYPE
                    ,content.toString() , craetor.getId().toString(),BASE_HOST + CommonConstants.物资发票登记审核PC详情 + saveEntity.getId().toString()
                    ,null,"待办","0","供方推送物资发票登记",null,null);
            logger.info("保存接口结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        } catch (Exception e) {
            logger.error("采购发票单据sourceId-{}处理异常", vo.getId(), e);
            throw new BusinessException(null != e.getMessage() ? e.getMessage() : "操作失败，处理单据失败！");
        } finally {
            BillLockUtil.releaseLock(BILL_TYPE, vo.getId());
        }

        return saveEntity.getId();
    }

    private List<String> getQuoteInfoByInvoiceNums(List<String> invoiceNums, List<Long> exIncludMainIds) {
        List<String> resp = new ArrayList<>();
        QueryWrapper<MatInvoiceDetailEntity> detailQuery = new QueryWrapper<>();
        detailQuery.eq("dr", BaseVO.DR_UNDELETE);
        detailQuery.in("invoice_number", invoiceNums);
        List<MatInvoiceDetailEntity> detailList = detailService.list(detailQuery);

        if(CollectionUtils.isNotEmpty(detailList)) {
            List<Long> mainIds = new ArrayList<>(detailList.stream().map(MatInvoiceDetailEntity::getMainId).collect(Collectors.toSet()));
            QueryWrapper<MatInvoiceEntity> query = new QueryWrapper<>();
            query.in("id", mainIds);
            query.eq("dr", BaseVO.DR_UNDELETE);
            if(CollectionUtils.isNotEmpty(exIncludMainIds)) {
                query.notIn("id", exIncludMainIds);
            }
            query.ne("sign_state", Integer.valueOf(PlanConstant.CHECK_STATE_BACK));

            List<MatInvoiceEntity> mainEntity = super.list(query);
            if(CollectionUtils.isNotEmpty(mainEntity)) {
              Map<Long, List<MatInvoiceDetailEntity>> detailMap =  detailList.stream().collect(Collectors.groupingBy(MatInvoiceDetailEntity::getMainId));
              for(MatInvoiceEntity m : mainEntity) {
                  for(MatInvoiceDetailEntity d : detailMap.get(m.getId())) {
                      if(!resp.contains(d.getInvoiceNumber())) {
                          resp.add(d.getInvoiceNumber());
                      }
                  }
              }
            }
        }
        return resp;
    }

    public void sendMsg(PushMsgParameter parameter, Long billId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS, PushMsgParameter.CHANNEL_TYPE_EMAIL});

        CommonResponse<String> sendResp = pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            logger.error("{}-发送消息失败，单据Id-{}，发送消息结果-{}", oprMsg, billId, JSONObject.toJSONString(sendResp, SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue));
        } else {
            logger.info("{}-发送消息成功！", oprMsg);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MatInvoiceVO confirmSign(Long id, boolean isConfirm, String rejectReason) {
        UserContext user = sessionManager.getUserContext();
        MatInvoiceEntity entity = super.selectById(id);
        //分供方推送的发票 需发送信息给分供方 自制的只需回写状态
        if (PlanConstant.SOURCE_TYPE_SUPPLIER == entity.getSourceType()) {
            try {
                //对单据进行加锁
                BillLockUtil.getLock(BILL_TYPE, entity.getId());
                Map<String, String> nameSourceTypeMapping = new HashMap<>();


                //如果是确认操作， 则查询是否存在 相同来源的 且已确认的发票单据
                if(isConfirm) {
//                    QueryWrapper<MatInvoiceEntity> query = new QueryWrapper<>();
//                    query.eq("source_id", entity.getSourceId());
//                    query.eq("sign_state", PlanConstant.CHECK_STATE_FINISH);
//                    query.ne("id", entity.getId());
//                    List<MatInvoiceEntity> dbList = super.list(query);
//                    if(CollectionUtils.isNotEmpty(dbList)) {
//                        logger.error("采购发票登记单据-{}id-{}确认操作失败，存在重复发票号且已确认的单据【ids-{}】", entity.getId(),
//                                StringUtils.join(dbList.stream().map(MatInvoiceEntity::getId).collect(Collectors.toSet()), ","));
//                        throw new BusinessException("操作失败，存在发票号相同且已确认的单据【"+StringUtils.join(dbList.stream()
//                                .map(MatInvoiceEntity::getBillCode).collect(Collectors.toSet()), ",")+"】");
//                    }

                    List<String> invoiceNums = entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toList());
                    //查询是否存在登记单引用了该发票
                    List<String> quotedNums = getQuoteInfoByInvoiceNums(invoiceNums, Collections.singletonList(id));
                    if(CollectionUtils.isNotEmpty(quotedNums)) {
                        throw new BusinessException("操作失败，号码为【"+quotedNums.stream().collect(Collectors.joining(","))+"】的发票已被使用！");
                    }
                }

                // 回写参数
                Map<String, String> params = new HashMap<>();
                params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
                params.put("billId", String.valueOf(entity.getSourceId()));
                params.put("operateId", String.valueOf(user.getUserId()));
                params.put("operateName", user.getUserName());
                params.put("signState", isConfirm ? PlanConstant.CHECK_STATE_FINISH : PlanConstant.CHECK_STATE_BACK);
                if (StringUtils.isNotBlank(rejectReason)) {
                    params.put("rejectReason", rejectReason);
                }

                //回写单据签字状态
                logger.info("单据-{}id-{}更新状态，通知单据推送方systemId-{},参数-{}", BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params));
                CommonResponse<String> backResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), null);
                logger.error("单据-{}更新状态回写发送请求结果，{}", BILL_NAME, JSONObject.toJSONString(backResp));
                if (!backResp.isSuccess()) {
                    logger.error("单据-{}id-{}更新状态回写发送请求失败，{}", BILL_NAME, entity.getId(), backResp.getMsg());
                    throw new BusinessException(BILL_NAME + "更新状态回写发送请求失败");
                }
                if (PlanConstant.noPower.equals(backResp.getData())) {
                    logger.error("发送请求URL-{}给系统-{}失败, {}", BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData());
                    throw new BusinessException(backResp.getData());
                }
                CommonResponse<String> operateResp = JSONObject.parseObject(backResp.getData(), CommonResponse.class);
                if (!operateResp.isSuccess()) {
                    logger.error("单据-{}id-{}更新状态回调处理失败，{}", BILL_NAME, entity.getId(), operateResp.getMsg());
                    throw new BusinessException("更新状态回调处理失败");
                }

                if (!isConfirm && CollectionUtils.isNotEmpty(entity.getDetailList())) {
                    //发票引用状态调整为未引用
                    List<ErpInvoiceEntity> invoiceList = erpInvoiceService.getAllByIds(entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceId)
                            .collect(Collectors.toList()));
                    invoiceList.stream().forEach(invoice -> {
                        invoice.setQuoteFlag(PlanConstant.STRING_NO); //发票设置为未引用
                    });
                    erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
                }

                //更新单据
                super.saveOrUpdate(entity, false);
            } catch (Exception e) {
                logger.error("单据-{}id-{}更新状态异常，", BILL_NAME, entity.getId(), e);
                throw new BusinessException(StringUtils.isNotBlank(e.getMessage()) ? e.getMessage() : "操作失败！");
            } finally {
                BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
            }
        } else {
            if (!isConfirm && CollectionUtils.isNotEmpty(entity.getDetailList())) {
                //发票引用状态调整为未引用
                List<ErpInvoiceEntity> invoiceList = erpInvoiceService.getAllByIds(entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceId)
                        .collect(Collectors.toList()));
                invoiceList.stream().forEach(invoice -> {
                    invoice.setQuoteFlag(PlanConstant.STRING_NO); //发票设置为未引用
                });
                erpInvoiceService.saveOrUpdateBatch(invoiceList, invoiceList.size(), false);
            }
        }
        LambdaUpdateWrapper<MatInvoiceEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(MatInvoiceEntity::getId, id);
        updateWrapper.set(MatInvoiceEntity::getSignState, isConfirm ? PlanConstant.CHECK_STATE_FINISH : PlanConstant.CHECK_STATE_BACK);
        updateWrapper.set(MatInvoiceEntity::getRejectReason, rejectReason);
        updateWrapper.set(MatInvoiceEntity::getUpdateTime, new Date());
        updateWrapper.set(MatInvoiceEntity::getUpdateUserCode, InvocationInfoProxy.getUsercode());
        update(updateWrapper);
        //发送已办消息
        messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")),entity.getId().toString(),PlanConstant.MAT_INVOICE_BILL_TYPE,null , entity.getOperateId().toString(),null
                ,null,"已办","1","物资发票登记审核", isConfirm ?"同意":"不同意",isConfirm ?"1":"2");
        return BeanMapper.map(selectById(id), MatInvoiceVO.class);
    }

    @Override
    public MatInvoiceVO commitReview(Long id) {
        MatInvoiceEntity entity = super.selectById(id);
        if (PlanConstant.SOURCE_TYPE_EL == entity.getSourceType() && CollectionUtils.isNotEmpty(entity.getDetailList())) {
            List<String> numbers = new ArrayList<>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank(item.getInvoiceNumber())).map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
            //查询发票
            if (CollectionUtils.isNotEmpty(numbers)) {
                List<ErpInvoiceEntity> list = erpInvoiceService.getAllByInvoiceNums(numbers);
                logger.info("采购: 根据发票号：{}, EL查询到发票数：{}", JSONObject.toJSONString(numbers), list.size());
                Set<String> quoteNumList = new HashSet<>();
                for(ErpInvoiceEntity e : list) {
                    logger.info("采购发票id-{},number-{}, ERP引用标识：{}", e.getId(), e.getNumber(), e.getErpQuoteFlag());
                    if(PlanConstant.STRING_YES.equals(e.getQuoteFlag()) || PlanConstant.STRING_YES.equals(e.getErpQuoteFlag())) {
                        quoteNumList.add(e.getNumber());
                    }
                }

                if(CollectionUtils.isNotEmpty(quoteNumList)) {
                    throw new BusinessException("操作失败，号码为【"+quoteNumList.stream().collect(Collectors.joining(","))+"】的发票已被使用！");
                }

                //查询ERP最新发票信息，验证发票是否被引用
                if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
                    List<String> quotedInvoiceNums = erpInvoiceService.checkQuote(
                            new ArrayList<>(entity.getDetailList().stream().map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet())),
                            "mat");
                    if(CollectionUtils.isNotEmpty(quotedInvoiceNums)) {
                        throw new BusinessException("操作失败，号码为【"+quotedInvoiceNums.stream().collect(Collectors.joining(","))+"】的发票已被使用！");
                    }
                }

                list.stream().forEach(invoice -> invoice.setQuoteFlag(PlanConstant.STRING_YES));
                erpInvoiceService.saveOrUpdateBatch(list, list.size(), false);
            }
            LambdaUpdateWrapper<MatInvoiceEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(MatInvoiceEntity::getId, id);
            updateWrapper.set(MatInvoiceEntity::getSignState, PlanConstant.CHECK_STATE_UN);
            updateWrapper.set(MatInvoiceEntity::getUpdateTime, new Date());
            updateWrapper.set(MatInvoiceEntity::getUpdateUserCode, InvocationInfoProxy.getUsercode());
            update(updateWrapper);
        }

        if(null == entity.getAdminId()) {

            Long checkerId = contractManagerService.getContractOperator(entity.getContractId(), "1");
            if(null == checkerId) {
                checkerId = matCheckerSettingService.getByContractId(entity.getContractId());
            }

            if(null == checkerId && StringUtils.isNotBlank(entity.getAdminId())) {
                checkerId = Long.valueOf(entity.getAdminId());
            }

            if(null == checkerId) {
                throw new BusinessException("未获取到发票审核人信息，请检查是否配置了对应的发票审核人！");
            }

            CommonResponse<EmployeeVO> creatorResp = employeeApi.getById(checkerId);
            if(!creatorResp.isSuccess()) {
                logger.error("查询发票审核人-{}信息失败,{}", checkerId, JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("操作失败,查询发票审核人信息失败!");
            }

            if(null == creatorResp.getData()) {
                logger.error("查询发票审核人-{}信息为空,{}", checkerId, JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("操作失败,查询发票审核人信息失败!");
            }
            EmployeeVO craetor = creatorResp.getData();

            //更新发票审核人信息
            LambdaUpdateWrapper<MatInvoiceEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(MatInvoiceEntity::getId, entity.getId());
            updateWrapper.set(MatInvoiceEntity::getAdminId, craetor.getId());
            updateWrapper.set(MatInvoiceEntity::getAdminCode, craetor.getCode());
            updateWrapper.set(MatInvoiceEntity::getAdminName, craetor.getName());
            update(updateWrapper);
        }

        //向发票管理员发送消息
        // 标题：【发票审核】，【单据编号】，【时间】需要您审核
        // 内容：【单据编号】，【项目名称】，【合同名称】，【供应商名称】提交了发票，请您审核！
        logger.info("供方发票提交, 向发票管理员id-{}发送消息", entity.getAdminId());
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setSubject("【发票审核】：【"+entity.getBillCode()+"】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()) +"】需要您审核！！");
        StringBuilder content = new StringBuilder();
        content.append("【").append(entity.getBillCode()).append("】，【")
                .append(entity.getProjectName()).append("】，【")
                .append(entity.getContractName()).append("】，【").append(entity.getSupplierName()).append("】提交了发票，请您审核！");
        parameter.setContent(content.toString());
        parameter.setPcUrl(BASE_HOST + CommonConstants.物资自制发票登记审核PC详情 + entity.getId().toString());

        String[] recIds = new String[]{entity.getAdminId()}; //发票管理员
        parameter.setReceivers(recIds);
        sendMsg(parameter, entity.getId(), "自制发票提交 向发票管理员发送消息");
        //发送待办消息
        messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")),entity.getId().toString(),PlanConstant.MAT_INVOICE_BILL_TYPE,content.toString() , entity.getOperateId().toString(),BASE_HOST + CommonConstants.物资自制发票登记审核PC详情 + entity.getId().toString()
                ,null,"待办","0","物资自制发票登记",null,null);
        return BeanMapper.map(selectById(id), MatInvoiceVO.class);
    }

    @Override
    public String changeAminEmp(JSONObject changeParam) {
        List<Long> billIds = JSONArray.parseArray(JSONObject.toJSONString(changeParam.get("ids")), Long.class);
        Long adminId = changeParam.getLong("adminId");
        String adminCode = changeParam.getString("adminCode");
        String adminName = changeParam.getString("adminName");
        List<MatInvoiceEntity> billList = (List<MatInvoiceEntity>) super.listByIds(billIds);

        if(CollectionUtils.isNotEmpty(billList)) {
            for(MatInvoiceEntity entity : billList) {
                PushMsgParameter parameter = new PushMsgParameter();
                parameter.setSubject("【发票审核】：【"+entity.getBillCode()+"】，【"+ DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date()) +"】需要您审核！！");
                StringBuilder content = new StringBuilder();
                content.append("【").append(entity.getBillCode()).append("】，【")
                        .append(entity.getProjectName()).append("】，【")
                        .append(entity.getContractName()).append("】，【").append(entity.getSupplierName()).append("】提交了发票，请您审核！");
                parameter.setContent(content.toString());
                parameter.setPcUrl(BASE_HOST +  (null!= entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ?
                        CommonConstants.物资自制发票登记审核PC详情 : CommonConstants.物资发票登记审核PC详情) + entity.getId().toString());

                String[] recIds = new String[]{entity.getAdminId()}; //发票管理员
                parameter.setReceivers(recIds);
                sendMsg(parameter, entity.getId(), "物资发票登记转签 向发票管理员发送消息");

                //将原有审核人代办设置为已办
                messageInfoService.sendTodo(Arrays.asList(entity.getAdminId().split(",")),entity.getId().toString(),PlanConstant.MAT_INVOICE_BILL_TYPE, content.toString() , entity.getOperateId().toString(),BASE_HOST + CommonConstants.物资自制发票登记审核PC详情 + entity.getId().toString()
                        ,null,"已办","1","物资发票登记转签","物资发票登记转签","1");
                //给新的审核人发送代办消息
                messageInfoService.sendTodo(Collections.singletonList(adminId.toString()),entity.getId().toString(),PlanConstant.MAT_INVOICE_BILL_TYPE,content.toString() , entity.getOperateId().toString(),BASE_HOST + CommonConstants.物资自制发票登记审核PC详情 + entity.getId().toString()
                        ,null,"待办","0","物资发票登记转签",null,null);
                //更新单据审核人信息
                entity.setAdminId(adminId.toString());
                entity.setAdminCode(adminCode);
                entity.setAdminName(adminName);
            }

            super.saveOrUpdateBatch(billList, billList.size(), false);
        }

        return null;
    }

    @Override
    public void updateBillPrintInfo(List<Long> ids) {
        UserContext user = sessionManager.getUserContext();
        LambdaUpdateWrapper<MatInvoiceEntity> update = new LambdaUpdateWrapper<>();
        update.in(MatInvoiceEntity::getId, ids)
                .set(MatInvoiceEntity::getPrintFlag, PlanConstant.INTEGER_YES)
                .set(MatInvoiceEntity::getLastPrintUserId, user.getUserId())
                .set(MatInvoiceEntity::getLastPrintUserCode, user.getUserCode())
                .set(MatInvoiceEntity::getLastPrintUserName, user.getUserName());
        super.update(update);
    }

    @Override
    public String pushToErp(Long id) {
        logger.info("推送采购发票登记id-{}至ERP   start*********", id);
        Map<String, String> headers = null;
        MatInvoiceEntity entity =super.selectById(id);
        String pushErpFlag = PlanConstant.INVOICE_PUSH_ERP_FLAG_UN_PUSH; //未推送

        //验证发票是否被引用
        try {
            if(checkInvoiceQuoteInfo(entity)) {
                logger.info("推送终止，发票登记id-{}中发票已被引用",id);
                return "推送终止，发票登记单中存在已被引用的发票或查询引用异常";
            }
        } catch (Exception e) {
            logger.error("查询采购发票登记id-{}ERP当前引用情况异常 发票终止推送,", entity.getId());
            logger.error("查询采购发票登记ERP当前引用情况异常,", e);
            pushErpFlag = PlanConstant.INVOICE_PUSH_ERP_FLAG_PUSH_FAIL; //推送失败
        }


        try {
            if(PlanConstant.INVOICE_PUSH_ERP_FLAG_UN_PUSH.equals(pushErpFlag)) {
                JSONArray syncData = transferToErpParam(entity);
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                String reqResp = HttpTookit.postByJson(ZDSInterfaceCommonUtil.getErpReqHost()+PlanConstant.SYNC_MAT_INVOICE_TO_ERP_URL, JSONObject.toJSONString(syncData),
                        headers, ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);

                logger.info("采购发票推送ERP：url-{}, 参数：{}，结果：{}", PlanConstant.SYNC_MAT_INVOICE_TO_ERP_URL,
                        JSONObject.toJSONString(syncData, SerializerFeature.PrettyFormat), reqResp);

                JSONObject reqJson = JSONObject.parseObject(reqResp);

                if("true".equals(reqJson.getString("status"))) {
                    logger.info("中电四 采购发票登记id-{}推送ERP成功!", id);
                    pushErpFlag = PlanConstant.INVOICE_PUSH_ERP_FLAG_SUCCESS; //推送成功
                } else {
                    logger.error("中电四 采购发票登记id-{}推送ERP失败!", id);
                    pushErpFlag = PlanConstant.INVOICE_PUSH_ERP_FLAG_PUSH_FAIL; //推送失败
                }
            }

        } catch (Exception e) {
            logger.error("推送采购发票id-{}异常，", id, e);
            pushErpFlag = PlanConstant.INVOICE_PUSH_ERP_FLAG_PUSH_FAIL; //推送失败
        }

        //更新发票推送状态
        LambdaUpdateWrapper<MatInvoiceEntity> update = new LambdaUpdateWrapper<>();
        update.eq(MatInvoiceEntity::getId, id)
                .set(MatInvoiceEntity::getPushErpFlag, pushErpFlag);
        super.update(update);

        if(PlanConstant.INVOICE_PUSH_ERP_FLAG_PUSH_FAIL.equals(pushErpFlag)) {
            //发送预警消息
            messageInfoService.sendWarnMsg("采购发票推送ERP，ERP处理失败", (null!= entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ? "【自制】" : "【供方申请】") +"的采购发票登记【"+entity.getBillCode()+"】推送ERP，ERP处理失败，请及时处理！",
                    BASE_HOST +  (null!= entity.getSourceType() && Integer.valueOf(1).equals(entity.getSourceType()) ?
                            CommonConstants.物资自制发票登记审核PC详情 : CommonConstants.物资发票登记审核PC详情) + entity.getId().toString());
        }
        logger.info("推送采购发票id-{}至ERP   end*********", id);
        return PlanConstant.INVOICE_PUSH_ERP_FLAG_PUSH_FAIL.equals(pushErpFlag) ? "ERP处理失败！":"推送ERP成功！";
    }

    private void initContext(Long userId) {
        logger.info("*****************初始化用户id-{}上下文 START*****************");
        String initContextUrl = BASE_HOST + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        if(null != userId) {
            initContextUrl = initContextUrl + "&userId="+userId.toString();
        }

        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if(userContextResponse.isSuccess()) {
                JSONObject userContext =userContextResponse.getData().getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if(null != userContext) {
                    authtoken.append("userType=").append(userContext.get("userType"))
                            .append(";userCode=").append(userContext.get("userCode"))
                            .append(";orgId=").append(userContext.get("orgId"))
                            .append(";tenantid=").append(userContext.get("tenantid"))
                            .append(";token=").append(userContext.get("token"))
                            .append(";u_logints=").append(userContext.get("u_logints"))
                            .append(";u_usercode=").append(userContext.get("u_usercode"))
                            .append(";userId=").append(userContext.get("userId"));
                }
                if(authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
                    InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authtoken.toString());
                }
                if(null != userContext) {
                    InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid(userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));
                }
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：",e);
        }

        logger.info("*****************初始化用户id-{}上下文 END*****************");
    }

    @Override
    @Async(value = "maCommonTask")
    public void syncToErp(Long id, Long curUserId) {
        logger.info("推送采购发票登记id-{}至ERP   start*********", id);
        initContext(curUserId);
        pushToErp(id);
        logger.info("推送采购发票id-{}至ERP   end*********", id);
    }

    @Override
    public String validateMny(Long id) {
        MatInvoiceEntity entity = super.selectById(id);
        // 累计发票金额
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, entity.getContractId()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<MatInvoiceEntity> list = super.queryList(param);
        list.add(entity);
        BigDecimal invoiceMny = list.stream().map(e -> e.getTotalTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);

        ContractEntity contract = contractService.selectById(entity.getContractId());
        if(contract == null){
            logger.info("未查询到该合同！");
            return "累计发票金额超过了合同金额，审核请注意！";
        }
        // 附加合同
        LambdaQueryWrapper<ContractEntity> ew = new LambdaQueryWrapper<>();
        ew.and(e -> e.eq(ContractEntity::getMainContractId, contract.getId()).
                or().eq(ContractEntity::getMainContractSid, contract.getSourceContractId()));
        List<ContractEntity> contList = contractService.list(ew);
        contList.add(contract);
        BigDecimal contractMny = contList.stream().map(e -> e.getTaxMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        if(ComputeUtil.isGreaterThan(invoiceMny, contractMny)){
            logger.info("累计发票金额【{}】超过了合同金额【{}】，审核请注意！", invoiceMny.toPlainString(), contractMny.toPlainString());
            return "累计发票金额超过了合同金额，审核请注意！";
        }
        return null;
    }

    private boolean checkInvoiceQuoteInfo(MatInvoiceEntity entity) {
        boolean quoteFlag = false;
        List<String> numbers = new ArrayList<>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank(item.getInvoiceNumber())).map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));

        //查询发票
        if(CollectionUtils.isNotEmpty(numbers)) {
            List<ErpInvoiceEntity> list = erpInvoiceService.getAllByInvoiceNums(numbers);
            logger.info("采购: 根据发票号：{}, EL查询到发票数：{}", JSONObject.toJSONString(numbers), list.size());
            for(ErpInvoiceEntity e : list) {
                logger.info("采购发票id-{},number-{}, ERP引用标识：{}", e.getId(), e.getNumber(), e.getErpQuoteFlag());
                if(PlanConstant.STRING_YES.equals(e.getErpQuoteFlag())) {
                    quoteFlag  = true;
                }
            }

            if(quoteFlag) {
                return quoteFlag;
            }
        }

        try {
            JSONArray josnArr = erpInvoiceService.syncTodayQuotedInvoice("mat");
            Map<String, List<MatInvoiceDetailEntity>> detailMap = entity.getDetailList().stream()
                    .collect(Collectors.groupingBy(MatInvoiceDetailEntity::getInvoiceNumber));
            if(null != josnArr && josnArr.size() > 0) {
                JSONObject json = null;
                for(Object obj : josnArr) {
                    json = (JSONObject) obj;
                    if(detailMap.containsKey(json.getString("InvoiceHM"))) {//根据发票号码匹配
                        quoteFlag = true;
                        for(MatInvoiceDetailEntity detail : detailMap.get(json.getString("InvoiceHM"))) {
                            detail.setErpQuoteBillCode(json.getString("Ma_id"));
                        }
                    }
                }
            }
        }catch (Exception e) {
            logger.error("采购: 根据发票号：{}, 查询ERP引用情况异常", numbers);
            logger.error("采购发票查询ERP引用情况异常", e);

            entity.setPushErpFlag(PlanConstant.INVOICE_PUSH_ERP_FLAG_PUSH_FAIL); //发票被引用 不推送
            //更新发票登记单据
            super.saveOrUpdate(entity, false);
            return true;
        }

        if(quoteFlag) {
            entity.setPushErpFlag(PlanConstant.INVOICE_PUSH_ERP_FLAG_UN_PUSH_WITH_QUOTE); //发票被引用 不推送
            //更新发票登记单据
            super.saveOrUpdate(entity, false);
        }

        return quoteFlag;
    }

    private JSONArray transferToErpParam(MatInvoiceEntity entity) {
        JSONArray resp = new JSONArray();
        JSONObject data = new JSONObject();
        resp.add(data);

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        //查询物资合同信息
        ContractEntity contract = contractService.selectById(entity.getContractId());

        //查询项目信息
        CommonResponse<ProjectPoolSetVO> prjResp = projectPoolApi.getById(contract.getProjectId());
        if(!prjResp.isSuccess()) {
            logger.error("推送分包发票登记失败，获取对应项目id-{}信息失败！", entity.getProjectId());
            throw new BusinessException("推送分包发票登记失败，获取对应项目信息失败！");
        }
        ProjectPoolSetVO project = prjResp.getData();
        if(null == project) {
            logger.error("推送分包发票登记失败，获取对应项目id-{}信息为空！", entity.getProjectId());
            throw new BusinessException("推送分包发票登记失败，获取对应项目信息为空！");
        }

        //查询供应商信息
        CommonResponse<MatSupplierVO> supplierResp = matSupplierApi.getOneById(entity.getSupplierId());
        if(!supplierResp.isSuccess()) {
            logger.error("推送采购发票失败，获取对应供应商id-{}信息失败，{}", entity.getSupplierId(), JSONObject.toJSONString(supplierResp, SerializerFeature.PrettyFormat));
            throw new BusinessException("推送采购发票失败，获取对应供应商id-"+entity.getSupplierId()+"信息失败");
        }

        MatSupplierVO supplier = supplierResp.getData();
        if(null == supplier) {
            logger.error("推送采购发票失败，获取对应供应商id-{}为空", entity.getSupplierId());
            throw new BusinessException("推送采购发票失败，获取对应供应商id-"+entity.getSupplierId()+"信息为空");
        }

        //查询发票核准人信息
        CommonResponse<EmployeeVO> empResp = employeeApi.getById(Long.valueOf(entity.getAdminId()));
        if(!empResp.isSuccess()) {
            logger.error("推送采购发票失败，获取对应发票核准人id-{}信息失败，{}", entity.getAdminId(), JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
            throw new BusinessException("推送采购发票失败，获取对应发票核准人id-"+entity.getAdminId()+"信息失败");
        }
        EmployeeVO emp = empResp.getData();
        if(null == emp) {
            logger.error("推送采购发票失败，获取对应发票核准人id-{}为空", entity.getAdminId());
            throw new BusinessException("推送采购发票失败，获取对应发票核准人id-"+entity.getAdminId()+"信息为空");
        }

        //查询发票最终审核信息
        EmployeeVO finalEmp = null;
        if(null != entity.getFinalApproveUserId()) {
            CommonResponse<EmployeeVO> finalEmpResp = employeeApi.getById(Long.valueOf(entity.getFinalApproveUserId()));
            if(!finalEmpResp.isSuccess()) {
                logger.error("推送采购发票失败，获取对应发票最终核准人id-{}信息失败，{}", entity.getFinalApproveUserId(), JSONObject.toJSONString(finalEmpResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("推送采购发票失败，获取对应发票最终核准人id-"+entity.getFinalApproveUserId()+"信息失败");
            }
            finalEmp = finalEmpResp.getData();
            if(null == finalEmp) {
                logger.error("推送采购发票失败，获取对应发票最终核准人id-{}为空", entity.getFinalApproveUserId());
                throw new BusinessException("推送采购发票失败，获取对应发票最终核准人id-"+entity.getFinalApproveUserId()+"信息为空");
            }
        }


        //查询ERP发票信息
        List<Long> invoiceIds = new ArrayList<>();
        entity.getDetailList().stream().forEach(detail -> {
            if(!invoiceIds.contains(detail.getInvoiceId())) {
                invoiceIds.add(detail.getInvoiceId());
            }
        });
        List<ErpInvoiceEntity> invoiceList = erpInvoiceService.getAllByIds(invoiceIds);
        List<ErpInvoiceDetailEntity> invoiceDetailList = invoiceDetailService.getAllByInvoiceIds(invoiceIds);
        if(CollectionUtils.isEmpty(invoiceList)) {
            logger.error("推送采购发票失败，获取对应发票ids-{}信息为空", JSONObject.toJSONString(invoiceIds));
            throw new BusinessException("推送采购发票失败，获取对应发票信息为空");
        }
        Map<Long, ErpInvoiceDetailEntity> invoiceDetailMap = new HashMap<>();
        Map<Long, ErpInvoiceEntity> invoiceMap = new HashMap<>();

        if(CollectionUtils.isNotEmpty(invoiceDetailList)) {
            invoiceDetailMap.putAll(invoiceDetailList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }
        if(CollectionUtils.isNotEmpty(invoiceList)) {
            invoiceMap.putAll(invoiceList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        }

        //设置供应商信息
        data.put("Company_Sid", supplier.getThirdSourceId()); //供应商SID
        data.put("MeContract_Money", ComputeUtil.safeAdd(entity.getMainContMny(), entity.getChildContMny()).toPlainString()); //主附合同金额
        data.put("MeOrderMoney", ComputeUtil.safeAdd(entity.getOrderMny(), BigDecimal.ZERO).toPlainString()); //订单金额
        data.put("BillTitle", entity.getInvoiceHeader());//发票抬头
        data.put("IsDK", entity.getTaxCreateState().toString()); //是否税务局代开
        data.put("IsDKValue", Integer.valueOf("1").equals(entity.getTaxCreateState()) ? "是" : "否"); //是否税务局代开Value
        data.put("BillType", PlanConstant.INVOICE_TYPE.get(entity.getInvoiceCty())); //发票种类
//        data.put("BillNumber", invoice.getNumber()); //发票号码
        data.put("TaxType", entity.getTaxCtyName()); //税收分类
        data.put("TaxRate", ComputeUtil.safeAdd(entity.getInvoiceRate(), BigDecimal.ZERO).toPlainString()); //发票税率
        data.put("NoTaxAmount", ComputeUtil.safeAdd(entity.getTotalMny(), BigDecimal.ZERO).toPlainString()); //不含税金额
        data.put("TaxAmount", ComputeUtil.safeAdd(entity.getTotalTax(), BigDecimal.ZERO).toPlainString()); //税额
        data.put("BillMoney", ComputeUtil.safeAdd(entity.getTotalTaxMny(), BigDecimal.ZERO).toPlainString()); //发票金额
        data.put("IsAdvancePayment", entity.getPreState()); //是否预付款
        data.put("IsAdvancePaymentValue", Integer.valueOf(1).equals(entity.getPreState()) ? "是" : "否"); //是否预付款value
        data.put("Memo", entity.getMemo()); //备注
        data.put("Ma_id", entity.getBillCode()); //单据编号
        data.put("Register_Name", entity.getOperateName()); //录入人
        data.put("SYS_Created", sdf.format(entity.getCreateTime())); //创建日期
        data.put("ApprHuman", emp.getName()); //核准人
        data.put("ApprHuman_sid", emp.getSourceId()); //核准人SID
        data.put("CON_EMP_NUM", emp.getCode()); //核准人编码
//        data.put("BillDate", null != invoice.getInvoiceDate() ? sdf.format(invoice.getInvoiceDate()) : ""); //开票日期
        data.put("ApprDate", sdf.format(null != entity.getUpdateTime() ? entity.getUpdateTime() : new Date())); //核准日期
        data.put("Position_Name", emp.getPostName()); //核准人岗位名称
        data.put("Division_Name", emp.getDeptName()); //核准人部门名称
        data.put("Org_Name", emp.getOrgName()); //核准人组织名称
        data.put("YQL_SID", entity.getId()); //核准人组织名称

        data.put("SubContractInfo_Sid", contract.getSourceContractId()); //分包合同ERP主键
        data.put("Project_Id", project.getCode()); //项目编码
        data.put("Project_Name", project.getName()); //项目名称
        data.put("Account_Project_Sid", project.getSourceId()); //项目ERP主键
        data.put("Company_Name", contract.getSupplierName()); //项目ERP主键

        if(null != finalEmp) {
            data.put("Reviewer", finalEmp.getName()); //最终审核人
            data.put("ReviewerSid", finalEmp.getSourceId()); //最终审核人
        }
        data.put("ReviewTime", sdf.format(null != entity.getEffectiveDate() ? entity.getEffectiveDate() : new Date())); //最终审批时间

        JSONArray detailList = new JSONArray();
        data.put("MEBill_SubCList", detailList);
        JSONObject detailJson = null;
        ErpInvoiceDetailEntity tmpDetail = null;
        ErpInvoiceEntity invoice = null;
        for(MatInvoiceDetailEntity detail : entity.getDetailList()) {
            detailJson = new JSONObject();
            tmpDetail = invoiceDetailMap.get(detail.getInvoiceDetailId());
            if(null == tmpDetail) {
                throw new BusinessException("推送采购发票[id-"+detail.getMainId()+"]失败，没有匹配的发票详情id-"+detail.getInvoiceDetailId()+"信息");
            }
            invoice = invoiceMap.get(detail.getInvoiceId());
            if(null == invoice) {
                throw new BusinessException("推送采购发票登记[id-"+detail.getMainId()+"]失败，没有匹配的发票id-"+detail.getInvoiceId()+"信息");
            }
            detailJson.put("InvoiceDM", invoice.getCode()); //发票代码
            detailJson.put("InvoiceHM", invoice.getNumber()); //发票号码
            detailJson.put("KPDate", null != invoice.getInvoiceDate() ? sdf.format(invoice.getInvoiceDate()) : ""); //开票日期
            detailJson.put("InvoiceTT", invoice.getInvoiceTitle()); //发票抬头
            detailJson.put("GoodsName", tmpDetail.getDetailName()); //货物名称
            detailJson.put("InvoiceType", invoice.getTypeCode()); //发票种类
            detailJson.put("InvoiceTypeValue", invoice.getTypeName()); //发票种类value
            detailJson.put("ModelNorm", tmpDetail.getDetailSpec()); //规格型号
            detailJson.put("MeteringUnit", tmpDetail.getDetailUnitName()); //单位
            detailJson.put("Quantity", ComputeUtil.safeAdd(tmpDetail.getDetailNum(), BigDecimal.ZERO).toPlainString()); //数量
            detailJson.put("Price", ComputeUtil.safeDiv(tmpDetail.getDetailMny(), tmpDetail.getDetailNum()).toPlainString()); //单价
            detailJson.put("TaxRate", ComputeUtil.safeAdd(tmpDetail.getDetailRate(), BigDecimal.ZERO).toPlainString()); //税率
            detailJson.put("Money", ComputeUtil.safeAdd(tmpDetail.getDetailMny(), BigDecimal.ZERO).toPlainString()); //不含税金额
            detailJson.put("TaxMoney", ComputeUtil.safeAdd(tmpDetail.getDetailTax(), BigDecimal.ZERO).toPlainString()); //税额
            detailJson.put("MoneyTax", ComputeUtil.safeAdd(tmpDetail.getInvoiceMny(), BigDecimal.ZERO).toPlainString()); //发票金额
            detailJson.put("PS_InvoiceInfo_FK", tmpDetail.getInvoiceSid()); //发票信息外键
            detailJson.put("YQL_SID", detail.getId()); //益企联主键

            detailList.add(detailJson);
        }
        //附件信息
        JSONArray attaches = new JSONArray();
        data.put("ArchivesInforList", attaches);

        JSONObject tmpFileJson = null;
        if(CollectionUtils.isNotEmpty(entity.getFileList())) {
            //查询附件信息
            List<Long> sourceIds = entity.getFileList().stream().map(MatInvoiceFileEntity::getId).collect(Collectors.toList());
            JSONObject params = new JSONObject();
            params.put("sourceIds", sourceIds);
            CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryAllBySourceIdList(params);
            if(!attachResp.isSuccess()) {
                logger.error("根据sourceId列表-{}查询对应附件信息失败，", JSONObject.toJSONString(sourceIds),
                        JSONObject.toJSONString(attachResp, SerializerFeature.PrettyFormat));
            } else {
                Map<Long, AttachmentVO> attachMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(attachResp.getData())) {
                    attachMap.putAll(attachResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
                }
                AttachmentVO tmpAttach = null;
                for(MatInvoiceFileEntity tmpFile : entity.getFileList()) {
                    if(null == tmpFile.getFileId()) {
                        continue;
                    }
                    tmpAttach = attachMap.get(tmpFile.getId());
                    if(null == tmpAttach) {
                        logger.error("推送采购发票失败，没有匹配的应发票附件详情sourceId-{}信息", tmpFile.getId());
                        throw new BusinessException("推送采购发票失败，没有匹配的应发票附件详情信息");
                    }
                    tmpFileJson = new JSONObject();
                    tmpFileJson.put("Attach_Name",
                            StringUtils.isBlank(tmpFile.getFileName()) ? tmpAttach.getFileName() : tmpFile.getFileName() + (tmpFile.getFileName().indexOf(".") < 0 ? tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")) : "")); //附件名称
                    tmpFileJson.put("Attach_Type", tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")+1)); //附件名称
                    tmpFileJson.put("Attach_Extension", tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf("."))); //附件扩展名
                    tmpFileJson.put("AttachBase64", BASE_HOST + "filepreview/"+tmpAttach.getFilePath()); //下载地址
                    tmpFileJson.put("YQL_SID", tmpFile.getId()); //益企联主键
                    tmpFileJson.put("Is_Add_Del", 1); //1新增 2删除

                    try {
                        if(StringUtils.isNotBlank(tmpFileJson.getString("Attach_Name")) && StringUtils.isNotBlank(tmpFileJson.getString("Attach_Extension"))) {
                            if(!tmpFileJson.getString("Attach_Name").toLowerCase().endsWith(tmpFileJson.getString("Attach_Extension").toLowerCase())) {
                                tmpFileJson.put("Attach_Name", tmpFileJson.getString("Attach_Name")+tmpFileJson.getString("Attach_Extension"));
                            }
                        }
                    } catch (Exception e) {
                        logger.error("采购发票附件id-{}处理后缀名称异常:", tmpFile.getId(), e);
                    }


                    attaches.add(tmpFileJson);
                }
            }
        }

        if(CollectionUtils.isNotEmpty(entity.getOcrList())) {
            //查询附件信息ge
            List<Long> sourceIds = entity.getOcrList().stream().map(MatInvoiceOcrEntity::getId).collect(Collectors.toList());
            JSONObject params = new JSONObject();
            params.put("sourceIds", sourceIds);
            CommonResponse<List<AttachmentVO>> attachResp = attachmentApi.queryAllBySourceIdList(params);

            if(!attachResp.isSuccess()) {
                logger.error("根据sourceId列表-{}查询对应附件信息失败，", JSONObject.toJSONString(sourceIds),
                        JSONObject.toJSONString(attachResp, SerializerFeature.PrettyFormat));
            } else {
                Map<Long, AttachmentVO> attachMap = new HashMap<>();
                if(CollectionUtils.isNotEmpty(attachResp.getData())) {
                    attachMap.putAll(attachResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
                }
                AttachmentVO tmpAttach = null;
                for(MatInvoiceOcrEntity tmpFile : entity.getOcrList()) {
                    if(null == tmpFile.getFileId()) {
                        continue;
                    }
                    tmpAttach = attachMap.get(tmpFile.getId());
                    if(null == tmpAttach) {
                        logger.error("推送采购发票登记失败，没有匹配的应发票附件详情sourceId-{}信息", tmpFile.getId());
                        throw new BusinessException("推送采购发票登记失败，没有匹配的应发票附件详情信息");
                    }
                    tmpFileJson = new JSONObject();
                    tmpFileJson.put("Attach_Name", StringUtils.isNotBlank(tmpFile.getFileName()) ? tmpFile.getFileName() + (tmpFile.getFileName().indexOf(".") < 0 ? tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")) : "") : tmpAttach.getFileName()); //附件名称
                    tmpFileJson.put("Attach_Extension", tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf("."))); //附件扩展名
                    tmpFileJson.put("Attach_Type", tmpAttach.getFileName().substring(tmpAttach.getFileName().indexOf(".")+1)); //下载地址
                    tmpFileJson.put("AttachBase64", BASE_HOST + "filepreview/"+tmpAttach.getFilePath()); //下载地址
                    tmpFileJson.put("YQL_SID", tmpFile.getId()); //益企联主键
                    tmpFileJson.put("Is_Add_Del", 1); //1新增2删除
                    try {
                        if(StringUtils.isNotBlank(tmpFileJson.getString("Attach_Name")) && StringUtils.isNotBlank(tmpFileJson.getString("Attach_Extension"))) {
                            if(!tmpFileJson.getString("Attach_Name").toLowerCase().endsWith(tmpFileJson.getString("Attach_Extension").toLowerCase())) {
                                tmpFileJson.put("Attach_Name", tmpFileJson.getString("Attach_Name")+tmpFileJson.getString("Attach_Extension"));
                            }
                        }
                    } catch (Exception e) {
                        logger.error("采购发票附件id-{}处理后缀名称异常:", tmpFile.getId(), e);
                    }
                    attaches.add(tmpFileJson);
                }
            }
        }

        return resp;
    }
}
