package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.*;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialMapper;
import com.ejianc.business.zdsmaterial.material.service.*;
import com.ejianc.business.zdsmaterial.material.vo.*;
import com.ejianc.business.zdsmaterial.util.DetailIndexExcelReader2;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 材料明细
 * 
 * @author generator
 * 
 */
@Service("materialService")
public class MaterialServiceImpl extends BaseServiceImpl<MaterialMapper, MaterialEntity> implements IMaterialService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialPropertyRelationService materialPropertyRelationService;

    @Autowired
    private MaterialMapper mapper;

    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String BILL_TYPE_CODE = "EJCBT202311000003";

    @Autowired
    private IUserApi userApi;

    @Autowired
    private ICommonSNService commonSNService;

    private final String propertySeperator = "；";
    private final String propertyNameValueSep = "：";

    @Autowired
    private IMaterialCategoryPropertyService propertyService;

    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;

    private final String MATERIAL_NEED_AUDIT_PARAM = "P-GS7K600001";

    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IMaterialSourceService materialSourceService;

    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Override
    public List<MaterialVO> queryListByCategoryId(List<Long> categoryIds) {
        List<MaterialVO> resp = new ArrayList<>();
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.in("category_id", categoryIds);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("blocked_flag", 0); //排除掉封存物料
        query.eq("dr", BaseVO.DR_UNDELETE);

        List<MaterialEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialVO> getByCodes(List<String> codes) {
        List<MaterialVO> resp = new ArrayList<>();
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.in("code", codes);
        query.eq("blocked_flag", 0); //排除掉封存物料
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());

        List<MaterialEntity> list = super.list(query);
        if(CollectionUtils.isNotEmpty(list)) {
            resp = BeanMapper.mapList(list, MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialVO> checkUnitAndProperty(List<MaterialVO> saveOrUpdateVOs, boolean checkId) {
        //1、先查询分类下属性相同的材料
        Map<Long, List<MaterialVO>> categoryUnitIdMap = saveOrUpdateVOs.stream()
                .collect(Collectors.groupingBy(MaterialVO::getCategoryId));

        //2、判断单位项目的项是否属性相同
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("blocked_flag", 0); //排除掉封存的物料

        //检查统一分类下是否存在名称、单位、属性相同的明细
        query.and(q -> {
            for(Long categoryId : categoryUnitIdMap.keySet()) {
                q.or(qs -> qs.eq("category_id", categoryId).and(qss -> {
                    for(MaterialVO m : categoryUnitIdMap.get(categoryId)) {
                        if(null != m.getId() && checkId) {
                            qss.or(qssi -> {
                                qssi.eq("name", m.getName()).eq("unit_id", m.getUnitId()).ne("id", m.getId());
                                if(StringUtils.isBlank(m.getPropertyShowName())) {
                                    qssi.isNull("property_show_name");
                                } else {
                                    qssi.eq("property_show_name", m.getPropertyShowName());
                                }
                                return qssi;
                            });
                        } else {
                            qss.or(qssi -> {
                                qssi.eq("name", m.getName()).eq("unit_id", m.getUnitId());
                                if(StringUtils.isBlank(m.getPropertyShowName())) {
                                    qssi.isNull("property_show_name");
                                } else {
                                    qssi.eq("property_show_name", m.getPropertyShowName());
                                }
                                return qssi;
                            });
                        }

                    }
                    return qss;
                }));
            }
            return q;
        });

        List<MaterialEntity> dbList = super.list(query);

        return BeanMapper.mapList(dbList, MaterialVO.class);
    }

    @Override
    public List<MaterialVO> saveOrUpdateMaterials(List<MaterialVO> saveOrUpdateVOs) {

        //设置新的关系
        List<Long> delRelationMaterialIds = new ArrayList<>();
        saveOrUpdateVOs.stream().forEach(item -> {
            if(null != item.getId()) {
                delRelationMaterialIds.add(item.getId());
            } else {
                item.setId(IdWorker.getId());
                item.setValidFlag(ZDSMaterialCommonEnums.物资是否生效_是.getCode());
            }
            item.getRelationList().forEach(r -> {
                r.setMaterialId(item.getId());
                r.setId(null);
                r.setCreateUserCode(null);
                r.setCreateTime(null);
                r.setUpdateUserCode(null);
                r.setUpdateTime(null);
                r.setRowState("add");
            });
        });

        if(CollectionUtils.isNotEmpty(delRelationMaterialIds)) {
            //删除物资已有的属性关系
            materialPropertyRelationService.deleteByMaterialIds(delRelationMaterialIds);
        }

        List<MaterialEntity> saveList = BeanMapper.mapList(saveOrUpdateVOs, MaterialEntity.class);
        List<MaterialPropertyRelationEntity> saveRelations = new ArrayList<>();
        saveList.stream().filter(s -> CollectionUtils.isNotEmpty(s.getRelationList())).forEach(m -> {
            saveRelations.addAll(m.getRelationList());
        });

        boolean saveSuc = super.saveOrUpdateBatch(saveList, saveList.size(), false);
        if(!saveSuc) {
            throw new BusinessException("保存物资明细失败！");
        }
        if(CollectionUtils.isNotEmpty(saveRelations)) {
            boolean saveRelationSuc = materialPropertyRelationService.saveOrUpdateBatch(saveRelations, saveList.size(), false);
            if(!saveRelationSuc) {
                throw new BusinessException("保存物资明细属性关系失败！");
            }
        }

        return BeanMapper.mapList(saveList, MaterialVO.class);
    }

    @Override
    public void deleteBatch(List<Long> ids) {
        //删除物资已有的属性关系
        materialPropertyRelationService.deleteByMaterialIds(ids);
        //删除物资明细
        super.removeByIds(ids);
    }

    @Override
    public List<MaterialVO> queryDetailList(List<Long> ids, boolean queryRelations) {
        List<MaterialVO> resp = new ArrayList<>();
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        List<MaterialEntity> entities = super.list(query);

        resp = BeanMapper.mapList(entities, MaterialVO.class);
        if(queryRelations) {
            List<MaterialPropertyRelationVO> relations = materialPropertyRelationService.getAllByMaterialIds(ids);
            if(CollectionUtils.isNotEmpty(relations)) {
                Map<Long, List<MaterialPropertyRelationVO>> materialRelationMap = relations.stream().collect(Collectors.groupingBy(MaterialPropertyRelationVO::getMaterialId));
                resp.stream().forEach(m -> {
                    if(materialRelationMap.containsKey(m.getId())) {
                        m.setRelationList(materialRelationMap.get(m.getId()));
                    }
                    m.setOldUnitId(m.getUnitId());
                    m.setOldPropertyShowName(m.getPropertyShowName());
                });
            }
        }

        return resp;
    }

    @Override
    public long countMaterial(Map<String, Object> params) {
        return mapper.countMaterial(params);
    }

    @Override
    public List<MaterialVO> pageList(Map<String, Object> params) {
        return mapper.pageList(params);
    }

    @Override
    public List<MaterialVO> materialCheck(List<MaterialVO> checkVos, boolean generateCode) {
        List<MaterialVO> matchVos = checkUnitAndProperty(checkVos, false);
        Map<String, MaterialVO> matchMap = matchVos.parallelStream()
                .collect(Collectors.toMap(item -> item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank(item.getPropertyShowName()) ? item.getPropertyShowName() : ""),
                        item -> item, (o,n) -> {
                            if(null != o.getValidFlag() && Integer.valueOf("1").equals(o.getValidFlag())) {
                                return o;
                            } else if(null != n.getValidFlag() && Integer.valueOf("1").equals(n.getValidFlag())) {
                                return n;
                            }
                            return o;
                        }));

        List<MaterialVO> resp = new ArrayList<>();
        List<MaterialVO> emptyCodeList = new ArrayList<>();
        MaterialVO matchVo = null;
        Map<String, MaterialVO> codeMap = new HashMap<>();

        //生成编码
        if(generateCode) {
            generateMaterialCodeBatchNew(checkVos);
        }

        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.in("code", new ArrayList<>(checkVos.stream().map(MaterialVO::getCode).collect(Collectors.toSet())));
        query.in("dr", BaseVO.DR_UNDELETE);
        query.in("blocked_flag", 0);
        List<MaterialEntity> dbList = super.list(query);


        Map<String, List<MaterialVO>> materialCodeMap = new HashMap<>();
        List<MaterialVO> repeatVos = null;
        if(CollectionUtils.isNotEmpty(dbList)) {
            List<MaterialVO> vos = BeanMapper.mapList(dbList, MaterialVO.class);
            materialCodeMap.putAll(vos.stream().collect(Collectors.groupingBy(MaterialVO::getCode, Collectors.toList())));
        }

        for(MaterialVO material : checkVos) {
            matchVo = matchMap.get(material.getName() + material.getUnitId().toString() + (StringUtils.isNotBlank(material.getPropertyShowName()) ? material.getPropertyShowName() : ""));
            if(null != matchVo) {
                matchVo.setMatchFlag(true);
                matchVo.setHasNewPropertyVal(0);
                resp.add(matchVo);
            } else {
                material.setMatchFlag(false);
                material.setId(IdWorker.getId());
                //重新生成编码，避免编码重复
//                emptyCodeList.add(material);
                resp.add(material);
            }

            repeatVos = materialCodeMap.get(material.getCode());
            if(CollectionUtils.isNotEmpty(repeatVos)) {
                for(MaterialVO repeatVo : repeatVos) {
                    if(!StringUtils.equals(
                            material.getName() + material.getUnitName() + (StringUtils.isNotBlank(material.getPropertyShowName())? material.getPropertyShowName() : ""),
                            repeatVo.getName() + repeatVo.getUnitName() + (StringUtils.isNotBlank(repeatVo.getPropertyShowName()) ? repeatVo.getPropertyShowName() : ""))) {
                        //编码相同，属性不相同
                        throw new BusinessException("操作失败，存在编码["+material.getCode()+"]相同，单位/规格型号不同的物料！");
                    }
                }
            } else {
                materialCodeMap.put(material.getCode(), new ArrayList<>());
            }
            materialCodeMap.get(material.getCode()).add(material);
        }

//        if(generateCode && emptyCodeList.size() > 0) {
//            String code = emptyCodeList.get(0).getCategoryCode();
//            if(StringUtils.isBlank(code)) {
//                Long categoryId = emptyCodeList.get(0).getCategoryId();
//                MaterialCategoryEntity category = materialCategoryService.selectById(categoryId);
//                code = category.getCode();
//            }
//            //编码为空的物资生成编码
//            generateMaterialCodeBatchNew(emptyCodeList);
////            Iterator<String> ite = codes.iterator();
////            for(MaterialVO item : emptyCodeList) {
////                if(StringUtils.isBlank(item.getCategoryCode())) {
////                    item.setCategoryCode(code);
////                }
////                if(materialCodeMap.containsKey(item.getCategoryId().toString()+item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank(item.getPropertyShowName()) ? item.getPropertyShowName() :""))) {
////                    item.setCode(materialCodeMap.get(item.getCategoryId().toString()+item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank(item.getPropertyShowName()) ? item.getPropertyShowName() :"")));
////                } else {
////                    //相同分类下 属性相同的物料使用相同物料编码
////                    item.setCode(ite.next());
////                    materialCodeMap.put(item.getCategoryId().toString()+item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank(item.getPropertyShowName()) ? item.getPropertyShowName(): ""), item.getCode());
////                }
////            }
//        }
        //检查有编码的是否重复 重复的也重新生成编码
//        if(MapUtils.isNotEmpty(codeMap)) {
//            List<MaterialVO> codeList = this.getByCodes(new ArrayList<>(codeMap.keySet()));
//            if(CollectionUtils.isNotEmpty(codeList)) {
//                List<String> codes = generateMaterialCodeBatch(codeList.get(0).getCategoryCode(), codeList.size());
//                Iterator<String> ite = codes.iterator();
//                codeList.stream().forEach(item -> {
//                    codeMap.get(item.getCode()).setCode(ite.next());
//                });
//            }
//        }

        return resp;
    }

    /**
     * @description: 检查是否存在编码相同 规格型号不同的物料
     * @param checkVos
     * @author CJ
     * @date: 2025/4/17 11:16
     */
    private void materialCodeCheck(List<MaterialVO> checkVos) {
        List<String> codeList = checkVos.stream().map(MaterialVO::getCode).collect(Collectors.toList());
        List<MaterialVO> dbCodeList = this.getByCodes(codeList);
        if(CollectionUtils.isNotEmpty(dbCodeList)) {
            Map<String, MaterialVO> dbCodeMap = dbCodeList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item, (v1,v2) -> v1));
            MaterialVO dbVo = null;
            for(MaterialVO m :checkVos) {
                dbVo = dbCodeMap.get(m.getCode());

                if(null != dbVo && !StringUtils.equals(
                        m.getName() + m.getUnitName() + (StringUtils.isNotBlank(m.getPropertyShowName())? m.getPropertyShowName() : ""),
                        dbVo.getName() + dbVo.getUnitName() + (StringUtils.isNotBlank(dbVo.getPropertyShowName()) ? dbVo.getPropertyShowName() : ""))) {
                    //存在编码相同，但规格型号不同的物料
                    throw new BusinessException("存在编码["+m.getCode()+"]相同，单位/规格型号不同的物料！");
                }
            }
        }
    }

    /**
     * 物料编码生成规则新
     * 按照属性排序，将属性下属性值序号拼接在一起作为编码
     *
     * @param emptyCodeList
     */
    @Override
    public void generateMaterialCodeBatchNew(List<MaterialVO> emptyCodeList) {
        List<Long> categoryIds = new ArrayList<>(emptyCodeList.stream().map(item -> item.getCategoryId()).collect(Collectors.toSet()));
        List<MaterialCategoryVO> categoryVOS = materialCategoryService.getAllByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), Function.identity()));
        Map<Long, List<MaterialCategoryPropertyVO>> propertyMap = propertyService.getAllByCategoryIds(categoryIds, 1);
        Map<Long, List<MaterialCategoryPropertySubItemVO>> itemMap = propertySubItemService.getAllByCategoryIds(categoryIds, 1);


        //分类下属性已排序的分类Id
        Set<Long> seqedCategory = new HashSet<>();
        List<MaterialCategoryPropertyVO> propertyList = null;
        MaterialCategoryVO category = null;
        StringBuffer sp = new StringBuffer();
        Map<Long, MaterialPropertyRelationVO> materialPropertyMap = new HashMap<>();
        Map<Long, MaterialCategoryPropertySubItemVO> itemIdMap = new HashMap<>();
        MaterialCategoryPropertySubItemVO tmpItem = null;
        MaterialPropertyRelationVO tmpRelation = null;
        Map<String, String> materialCodeMap = new HashMap<>();
        for(MaterialVO material : emptyCodeList) {
                //清空
                sp.setLength(0);
                materialPropertyMap.clear();
                itemIdMap.clear();

                //相同分类下 属性相同的物料使用相同物料编码
                if(materialCodeMap.containsKey(material.getCategoryId().toString()+material.getName() + (null != material.getUnitId() ?material.getUnitId().toString():"") +
                        (StringUtils.isNotBlank(material.getPropertyShowName()) ? material.getPropertyShowName() :""))) {
                    material.setCode(materialCodeMap.get(material.getCategoryId().toString()+material.getName() +
                            (null != material.getUnitId() ?material.getUnitId().toString():"") + (StringUtils.isNotBlank(material.getPropertyShowName()) ? material.getPropertyShowName() :"")));
                    continue;
                }

                category = categoryMap.get(material.getCategoryId());
                propertyList = propertyMap.get(material.getCategoryId());
                if(StringUtils.isBlank(material.getCategoryCode())) {
                    material.setCategoryCode(category.getCode());
                }
                if(StringUtils.isBlank(material.getCategoryName())) {
                    material.setCategoryName(category.getName());
                }
                if(!seqedCategory.contains(material.getCategoryId())) {
                    //按照属性序号排序
                    propertyList = propertyList.stream().sorted((v1,v2) -> v1.getSequence() - v2.getSequence()).collect(Collectors.toList());
                    propertyMap.put(category.getId(), propertyList);
                }

                //获取到物料属性值列表
                if(CollectionUtils.isNotEmpty(material.getRelationList())) {
                    materialPropertyMap = material.getRelationList().stream().collect(Collectors.toMap(item -> item.getPropertyId(), Function.identity()));
                }

                sp.append(category.getCode());
                try {
                    for(MaterialCategoryPropertyVO property : propertyList) {
                        if(materialPropertyMap.containsKey(property.getId())) {
                            //物料属性有选择当前 属性分类下的属性值，则拼接对应属性值的序号
                            itemIdMap.putAll(itemMap.get(property.getId()).stream()
                                    .collect(Collectors.toMap(item -> item.getId(), Function.identity())));
                            tmpRelation = materialPropertyMap.get(property.getId());
                            if(null != tmpRelation && null != tmpRelation.getPropertyItemId() && itemIdMap.containsKey(tmpRelation.getPropertyItemId())) {
                                tmpItem = itemIdMap.get(tmpRelation.getPropertyItemId());
                                if(null == tmpItem) {
                                    logger.error("属性：{}下未找到Id:{}的属性值", property.getId(), JSONObject.toJSONString(materialPropertyMap.get(property.getId())));
                                    return;
                                }
                                if(tmpItem.getSequence() < 10) {
                                    sp.append("0");
                                }
                                sp.append(tmpItem.getSequence());
                            } else {
                                //物料为选择当前属性下属性值  使用00作为占位符
                                sp.append("00");
                            }
                        } else {
                            //物料为选择当前属性下属性值  使用00作为占位符
                            sp.append("00");
                        }
                    }

                    material.setCode(sp.toString());
                    materialCodeMap.put(material.getCategoryId().toString()+material.getName()
                            + (null != material.getUnitId() ?material.getUnitId().toString():"") +
                            (StringUtils.isNotBlank(material.getPropertyShowName()) ? material.getPropertyShowName(): ""), material.getCode());
                } catch (Exception e) {
                    logger.error("ERR--------物料AI识别 编码生成失败：{}, itemIds:{}", JSONObject.toJSONString(material),
                            JSONObject.toJSONString(itemIdMap.keySet()));
                    logger.error("ERR--------物料AI识别 编码生成异常：", e);
                    material.setCode("编码生成失败！");
                }
        }
    }

    @Override
    public void updateMaterialStatusByCategory(List<Long> categoryIds, Integer blockStatus,
                                               Integer enabled, Integer beforeBlockStatus, String newCategoryName, List<Long> excludeMaterialIds) {
        mapper.updateMaterialStatusByCategory(categoryIds, blockStatus, enabled, beforeBlockStatus,
                newCategoryName, CollectionUtils.isNotEmpty(excludeMaterialIds) ? excludeMaterialIds : null, InvocationInfoProxy.getUsercode());
    }

    @Override
    public void updateCategoryName(Long categoryId, String newCategoryName, List<Long> noIncludeMaterialIds) {
        mapper.updateCategoryName(categoryId, newCategoryName, CollectionUtils.isNotEmpty(noIncludeMaterialIds) ? noIncludeMaterialIds : null,
                InvocationInfoProxy.getUsercode());
    }

    @Override
    public List<Long> updateMaterialByProperty(List<Long> stopUsePropertyIds, String newCategoryName, Integer enabled, Integer blockFlag) {
        List<Long> materialIds = new ArrayList<>();
        List<MaterialPropertyRelationVO> relations = materialPropertyRelationService.getAllByPropertyIds(stopUsePropertyIds);
        materialIds = relations.stream().map(MaterialPropertyRelationVO::getMaterialId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(materialIds)) {
            mapper.updateMaterialEnableStatus(materialIds, newCategoryName,enabled, blockFlag, InvocationInfoProxy.getUsercode());
        }
        return materialIds;
    }

    @Override
    public List<MaterialVO> addNewMaterialsFromBill(List<MaterialVO> dataList) {
        logger.info("待处理新增物资列表：{}", JSONObject.toJSONString(dataList, SerializerFeature.PrettyFormat));
        List<MaterialVO> resp = new ArrayList<>();
        List<MaterialVO> exsistList = checkUnitAndProperty(dataList, false);
        List<MaterialVO> saveList = new ArrayList<>();
        Map<String, MaterialVO> exsitMap = exsistList.stream().collect(Collectors.toMap(item -> item.getName() +
                        item.getUnitId().toString() + (StringUtils.isNotBlank(item.getPropertyShowName()) ? item.getPropertyShowName() : ""),
                item -> item, (o,n) -> {
                    if(null != o.getValidFlag() && Integer.valueOf("1").equals(o.getValidFlag())) {
                        return o;
                    } else if(null != n.getValidFlag() && Integer.valueOf("1").equals(n.getValidFlag())) {
                        return n;
                    }
                    return o;
                }));
        List<MaterialSourceVO> saveSourceVos = new ArrayList<>();

        List<String> codeList = new ArrayList<>(dataList.stream().map(MaterialVO::getCode).collect(Collectors.toSet()));
        Set<String> existsCode = new HashSet<>();
        if(CollectionUtils.isNotEmpty(codeList)) {
            List<MaterialVO> dbCodeList = getByCodes(codeList);
            existsCode = dbCodeList.stream().map(MaterialVO::getCode).collect(Collectors.toSet());
        }

        //查询系统参数，业务单据推送来的物资是否需要准入: 0-否，1-是
        Integer materialValidFlag = ZDSMaterialCommonEnums.物资是否生效_是.getCode();
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(MATERIAL_NEED_AUDIT_PARAM);
        if (!response.isSuccess() || response.getData() == null) {
            logger.error("获取业务单据推送来的物资是否需要准入参数请求失败，失败原因：" + response.getMsg());
        } else {
            materialValidFlag = "1".equals(response.getData().getValueData()) ? ZDSMaterialCommonEnums.物资是否生效_否.getCode() : ZDSMaterialCommonEnums.物资是否生效_是.getCode();
        }

        MaterialVO tmpMaterial = null;
        MaterialSourceVO sourceInfo = null;
        List<MaterialVO> emptyCodeList = new ArrayList<>();
        List<Long> validPropertyValIds = new ArrayList<>();
        List<MaterialPropertyRelationVO> saveRelationVos = new ArrayList<>();
        Set<Long> sourceIds= new HashSet<>();

        List<String> repeatItem = new ArrayList<>();
        for(MaterialVO material : dataList) {
            tmpMaterial = exsitMap.get(material.getName() + material.getUnitId().toString() +
                    (StringUtils.isNotBlank(material.getPropertyShowName()) ? material.getPropertyShowName() : ""));
            if(null != tmpMaterial) {
                resp.add(tmpMaterial); //档案库已存在，则将存在的物资档案返回

                //设置更新时间
                tmpMaterial.setUpdateTime(new Date());
                tmpMaterial.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                saveList.add(tmpMaterial);
                if(!ZDSMaterialCommonEnums.物资是否生效_是.getCode().equals(tmpMaterial.getValidFlag())) {
                    tmpMaterial.setValidFlag(ZDSMaterialCommonEnums.物资是否生效_否.getCode());
                    //如果物资档案未生效，则将当前的物资档案来源信息记录
                    sourceInfo = material.getSourceList().get(0);
                    sourceInfo.setMaterialId(tmpMaterial.getId());
                    saveSourceVos.add(sourceInfo);
                    //若存在旧的来源记录，则将旧的来源记录删除
                    sourceIds.add(sourceInfo.getSourcePid());
                }
                continue;
            } else if(repeatItem.contains(material.getName() + material.getUnitId().toString() +
                    (StringUtils.isNotBlank(material.getPropertyShowName()) ? material.getPropertyShowName() : ""))) {
                continue;
            }
            repeatItem.add(material.getName() + material.getUnitId().toString() + (StringUtils.isNotBlank(material.getPropertyShowName()) ? material.getPropertyShowName() : ""));

            //若不存在匹配度的物资档案
            material.setValidFlag(materialValidFlag);
            if(StringUtils.isNotBlank(material.getPropertyShowName())) {
                if(CollectionUtils.isNotEmpty(material.getRelationList())) {
                    material.getRelationList().stream().forEach(relation -> {
                        relation.setId(IdWorker.getId());
                        relation.setMaterialId(material.getId());
                        relation.setCategoryId(material.getCategoryId());
                        if(null != relation.getHasNewPropertyVal() && 1 == relation.getHasNewPropertyVal()) {
                            validPropertyValIds.add(relation.getPropertyItemId());
                        }
                        saveRelationVos.add(relation);
                    });
                } else {
                    //生成物料关系
                    List<MaterialPropertyRelationEntity> relations = analyMaterialRelation(material);
                    if(CollectionUtils.isNotEmpty(relations)) {
                        relations.stream().forEach(relation -> {
                            relation.setId(IdWorker.getId());
                            relation.setMaterialId(material.getId());
                            relation.setCategoryId(material.getCategoryId());
                            validPropertyValIds.add(relation.getPropertyItemId());
                            saveRelationVos.add(BeanMapper.map(relation, MaterialPropertyRelationVO.class));
                        });
                    }
                }
            }

            if(existsCode.contains(material.getCode())) {
                material.setCode(null);
            } else {
                existsCode.add(material.getCode());
            }
            if(StringUtils.isBlank(material.getCode())) {
                emptyCodeList.add(material);
            }

            saveSourceVos.add(material.getSourceList().get(0));
            saveList.add(material);
            sourceIds.add(material.getSourceList().get(0).getSourcePid());
        }

        //根据来源删除旧的来源关系
        if(CollectionUtils.isNotEmpty(sourceIds)) {
            materialSourceService.deleteBySourceIds(new ArrayList<>(sourceIds));
        }

        if(CollectionUtils.isNotEmpty(emptyCodeList)) {
            //编码为空的物资生成编码
            generateMaterialCodeBatchNew(emptyCodeList);
//            List<String> codes = generateMaterialCodeBatch(emptyCodeList.get(0).getCategoryCode(), emptyCodeList.size());
//            Iterator<String> ite = codes.iterator();
//            emptyCodeList.stream().forEach(item -> {
//                item.setCode(ite.next());
//            });
        }

        if(CollectionUtils.isNotEmpty(saveRelationVos)) {
            //保存物资 属性关系
            materialPropertyRelationService.saveOrUpdateBatch(
                    BeanMapper.mapList(saveRelationVos, MaterialPropertyRelationEntity.class), saveRelationVos.size(), false);
        }
        //保存物资来源信息表
        if(CollectionUtils.isNotEmpty(saveSourceVos)) {
            //存在创建人名称为空的数据 进行填充
            Set<String> userCodes = saveSourceVos.stream().filter(item -> StringUtils.isNotBlank(item.getSourceCreateUserCode()) &&
                    StringUtils.isBlank(item.getSourceCreateUserName())).map(item -> item.getSourceCreateUserCode()).collect(Collectors.toSet());

            Map<String, String> userNameMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(userCodes)) {
               CommonResponse<List<UserVO>> userResp = userApi.queryUserByUserCodes(userCodes.toArray(new String[userCodes.size()]));
               if(!userResp.isSuccess() || null == userResp.getData()) {
                   logger.info("根据用户编码列表-{}获取用户信息失败", JSONObject.toJSONString(userCodes));
               } else {
                   userNameMap.putAll(userResp.getData().stream().collect(Collectors.toMap(item -> item.getUserCode(), item -> item.getUserName())));
               }
            }
            if(!userNameMap.isEmpty()) {
                saveSourceVos.stream().filter(item -> userNameMap.containsKey(item.getSourceCreateUserCode()))
                        .forEach(item -> item.setSourceCreateUserName(userNameMap.get(item.getSourceCreateUserCode())));
            }

            materialSourceService.saveOrUpdateBatch(BeanMapper.mapList(saveSourceVos, MaterialSourceEntity.class),
                    saveSourceVos.size(), false);
        }
        if(CollectionUtils.isNotEmpty(validPropertyValIds)) {
            propertySubItemService.updatePropertyItemsValidFlag(validPropertyValIds, ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode());
        }

        //存在新增待保存的物资
        if(CollectionUtils.isNotEmpty(saveList)) {
            List<MaterialEntity> materials = BeanMapper.mapList(saveList, MaterialEntity.class);
            super.saveOrUpdateBatch(materials, materials.size(), false);
            resp.addAll(BeanMapper.mapList(materials, MaterialVO.class));
        }

        return resp;
    }

    @Override
    public List<MaterialVO> deleteMaterialsFromBill(List<Long> sourceIds) {
        List<MaterialVO> resp = new ArrayList<>();

        //根据来源删除旧的来源关系
        materialSourceService.deleteBySourceIds(sourceIds);

        return resp;
    }

    @Override
    public List<String> generateMaterialCodeBatch(String categoryCode, int count) {
        return commonSNService.generateSnList(categoryCode, count, null);
    }

    @Override
    public List<Long> updatePropertyAndValues(List<MaterialCategoryPropertyEntity> changedProperty,
                                        List<MaterialCategoryPropertySubItemEntity> changeNameValues,
                                        List<Long> delPropertyValueIds,
                                        String newCategoryName) {
        //本次更新的物资Id
        List<Long> updateMaterialIds = new ArrayList<>();
        //更次更新的物资列表
        List<MaterialEntity> updateList = new ArrayList<>();
        Map<Long, MaterialCategoryPropertyEntity> propertyMap = new HashMap<>();
        Map<Long, MaterialCategoryPropertySubItemEntity> propertyValueMap = new HashMap<>();

        Set<Long> materialIds = null;
        Set<Long> stopUseMaterialIds = new HashSet<>();
        Set<Long> blockedMaterialIds = new HashSet<>();
        List<Long> quoteMaterialIds = new ArrayList<>();
        List<MaterialPropertyRelationVO> relationUpdateList = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(changedProperty)) {
            propertyMap.putAll(changedProperty.stream()
                    .collect(Collectors.toMap(MaterialCategoryPropertyEntity::getId, Function.identity())));
        }
        if(CollectionUtils.isNotEmpty(changeNameValues)) {
            propertyValueMap.putAll(changeNameValues.parallelStream().collect(Collectors.toMap(item -> item.getId(), Function.identity())));
        }

        List<MaterialPropertyRelationVO> relations = null;
        if(MapUtils.isNotEmpty(propertyMap)) {
            relations = materialPropertyRelationService.getAllByCategoryId(changedProperty.get(0).getCategoryId());
        } else if(MapUtils.isNotEmpty(propertyValueMap)) {
            relations = materialPropertyRelationService.getAllByCategoryId(changeNameValues.get(0).getCategoryId());
        }

        if(CollectionUtils.isNotEmpty(relations)) {
            List<MaterialCategoryPropertyVO> allPropertys = propertyService.getAllByCategoryId(relations.get(0).getCategoryId(), ZDSMaterialCommonEnums.停启用_启用.getCode());
            Map<Long, MaterialCategoryPropertyVO> propertysMap = allPropertys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));

            if(CollectionUtils.isNotEmpty(relations)) {
                //只取出本次涉及到的物资明细
                materialIds = relations.stream().filter(item -> propertyMap.containsKey(item.getPropertyId()) || propertyValueMap.containsKey(item.getPropertyItemId()))
                        .map(MaterialPropertyRelationVO::getMaterialId).collect(Collectors.toSet());
                //查询物资明细引用情况
                CommonResponse<Map<String, String>> quoteResp = billTypeApi.checkQuotes(BILL_TYPE_CODE, new ArrayList<>(materialIds));
                if(!quoteResp.isSuccess()) {
                    throw new BusinessException("查询物资引用情况失败");
                }
                Map<String, String> quoteResult = quoteResp.getData();
                logger.debug("*****查询到物资引用情况****：{}", JSONObject.toJSONString(quoteResult));
                for(String billId : quoteResult.keySet()) {
                    if("true".equals(quoteResult.get(billId))) {
                        quoteMaterialIds.add(Long.valueOf(billId));
                    }
                }

                MaterialCategoryPropertyEntity property = null;
                MaterialCategoryPropertySubItemEntity propertyValue = null;
                for(MaterialPropertyRelationVO relation : relations) {
                    if(!propertysMap.containsKey(relation.getPropertyId())) {
                        continue;
                    }
                    relation.setPropertyName(propertysMap.get(relation.getPropertyId()).getName());
                    property = propertyMap.get(relation.getPropertyId());
                    propertyValue = propertyValueMap.get(relation.getPropertyItemId());

                    //更新属性分类信息
                    if(null != property) {
                        relation.setPropertyName(property.getName());
                        relation.setPropertySequence(property.getSequence());
                        relation.setProductCodeFlag(property.getProductCodeFlag());

                        relationUpdateList.add(relation);
                    }
                    if(null != propertyValue) {
                        if(delPropertyValueIds.contains(relation.getPropertyItemId())) {
                            //属性值删除
                            stopUseMaterialIds.add(relation.getMaterialId());
                            //未被引用的物料明细：改为停用、正常，修改属性值后可启用。
                            //2、已被引用的物料明细：改为停用、封存。
                            if(quoteMaterialIds.contains(relation.getMaterialId())) {
                                blockedMaterialIds.add(relation.getMaterialId());
                            }
                        } else {
                            if(quoteMaterialIds.contains(relation.getMaterialId())) {
                                //属性值修改
                                //、已被引用的物料明细：改为停用、封存。
                                stopUseMaterialIds.add(relation.getMaterialId());
                                blockedMaterialIds.add(relation.getMaterialId());
                            } else {
                                //属性值修改
                                //、未被引用的物料明细：直接对应修改属性值、产品代码。
                                relation.setProductCode(propertyValue.getProductCode());
                                relation.setPropertyValue(propertyValue.getName());
                                if(!relationUpdateList.contains(relation)) {
                                    relationUpdateList.add(relation);
                                }
                            }
                        }
                    }
                }

                //将属性分组排序 然后将拼接成展示的属性名
                Map<Long, String> materialRelationMap = relations.stream().map(item -> {
                    if(null == item.getPropertySequence()) {
                        item.setPropertySequence(propertysMap.get(item.getPropertyId()).getSequence());
                    }
                    return item;
                }).sorted(Comparator.comparingInt(MaterialPropertyRelationVO::getPropertySequence))
                        .collect(Collectors.groupingBy(MaterialPropertyRelationVO::getMaterialId,
                                Collectors.mapping(item -> item.getPropertyName() + propertyNameValueSep + item.getPropertyValue(), Collectors.joining(propertySeperator))));

                //将属性分组排序 然后将拼接成展示的产品代码
                Map<Long, String> materialProductMap = relations.stream().map(item -> {
                    if(null == item.getPropertySequence()) {
                        item.setPropertySequence(propertysMap.get(item.getPropertyId()).getSequence());
                    }
                    return item;
                }).filter(item -> //过滤掉不启用产品代码 或 产品代码为空的关系列表
                    ZDSMaterialCommonEnums.属性分类是否启用产品代码_是.getCode().equals(item.getProductCodeFlag())
                            && StringUtils.isNotBlank(item.getProductCode())
                ).sorted(Comparator.comparingInt(MaterialPropertyRelationVO::getPropertySequence))
                        .collect(Collectors.groupingBy(MaterialPropertyRelationVO::getMaterialId,
                                Collectors.mapping(item ->  item.getProductCode(), Collectors.joining())));

                QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
                query.in("id", materialIds);
                query.in("blocked_flag", ZDSMaterialCommonEnums.封存_正常.getCode());
                List<MaterialEntity> materialList = super.list(query);

                materialList.stream().filter(item -> materialRelationMap.containsKey(item.getId())).forEach(material -> {
                    if(stopUseMaterialIds.contains(material.getId())) {
                        material.setEnabled(ZDSMaterialCommonEnums.停启用_停用.getCode());
                    }
                    if(blockedMaterialIds.contains(material.getId())) {
                        material.setBlockedFlag(ZDSMaterialCommonEnums.封存_封存.getCode());
                    } else {
                        //非封存的明细刷新属性展示名、产品代码、分类名称
                        if(StringUtils.isNotBlank(newCategoryName)) {
                            material.setCategoryName(newCategoryName);
                        }
                        material.setPropertyShowName(materialRelationMap.get(material.getId()));
                        if(ZDSMaterialCommonEnums.物料自定义产品代码_否.getCode().equals(material.getProductCodeCustomFlag())) {
                            //更新产品代码非自定义明细的产品代码
                            material.setProductCode(materialProductMap.containsKey(material.getId()) ? materialProductMap.get(material.getId()) : null);
                        }
                    }
                    updateList.add(material);
                    updateMaterialIds.add(material.getId());
                });
            }

            if(CollectionUtils.isNotEmpty(relationUpdateList)) {
                //更新物资 属性关系列表
                materialPropertyRelationService.saveOrUpdateBatch(BeanMapper.mapList(relationUpdateList, MaterialPropertyRelationEntity.class), relationUpdateList.size(), false);
            }

            if(CollectionUtils.isNotEmpty(updateList)) {
                super.saveOrUpdateBatch(updateList, updateList.size(), false);
            }
        }

        return updateMaterialIds;
    }

    @Override
    public List<Long> updateByPropertyValueDel(List<Long> delPropertyValueIds) {
        List<Long> resp = new ArrayList<>();
        List<MaterialPropertyRelationVO> relations = materialPropertyRelationService.getAllByPropertyValueIds(delPropertyValueIds);

        if(CollectionUtils.isNotEmpty(relations)) {
            List<Long> materialIds = relations.stream().map(item -> item.getMaterialId()).collect(Collectors.toList());
            List<Long> quoteMaterialIds = new ArrayList<>();

            QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
            query.in("id", materialIds);
            query.in("blocked_flag", ZDSMaterialCommonEnums.封存_正常.getCode());
            List<MaterialEntity> materialList = super.list(query);

            if(CollectionUtils.isNotEmpty(materialList)) {
                //查询物资明细引用情况
                CommonResponse<Map<String, String>> quoteResp = billTypeApi.checkQuotes(BILL_TYPE_CODE, new ArrayList<>(materialIds));
                if(!quoteResp.isSuccess()) {
                    throw new BusinessException("查询物资引用情况失败");
                }
                Map<String, String> quoteResult = quoteResp.getData();
                logger.debug("*****查询到物资引用情况****：{}", JSONObject.toJSONString(quoteResult));
                for(String billId : quoteResult.keySet()) {
                    if("true".equals(quoteResult.get(billId))) {
                        quoteMaterialIds.add(Long.valueOf(billId));
                    }
                }

                for(MaterialEntity material : materialList) {
                    material.setEnabled(ZDSMaterialCommonEnums.停启用_停用.getCode());
                    if(quoteMaterialIds.contains(material.getId())) {
                        material.setBlockedFlag(ZDSMaterialCommonEnums.封存_封存.getCode());
                    }
                    resp.add(material.getId());
                }

                super.saveOrUpdateBatch(materialList, materialList.size(), false);
            }
        }
        return resp;
    }

    @Override
    public void saveExcelImport(List<MaterialVO> saveImportVos) {
        List<MaterialPropertyRelationVO> relationList = new ArrayList<>();

        List<MaterialVO> emptyCodeList = new ArrayList<>();
        saveImportVos.stream().forEach(material -> {
            material.setValidFlag(ZDSMaterialCommonEnums.物资是否生效_是.getCode());
            material.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
            material.setBlockedFlag(ZDSMaterialCommonEnums.封存_正常.getCode());
            relationList.addAll(material.getRelationList().stream().map(item -> {
                item.setMaterialId(material.getId());
                return item;
            }).collect(Collectors.toList()));
            if(StringUtils.isBlank(material.getCode())) {
                emptyCodeList.add(material);
            }
        });

        //编码为空的物料自动生成编码
        if(CollectionUtils.isNotEmpty(emptyCodeList)) {
            generateMaterialCodeBatchNew(emptyCodeList);
//            List<String> codes = commonSNService.generateSnList(emptyCodeList.get(0).getCategoryCode(), emptyCodeList.size(), 9);
//            Iterator<String> item = codes.iterator();
//            for(MaterialVO m : emptyCodeList) {
//                m.setCode(item.next());
//            }
        }

        if(CollectionUtils.isNotEmpty(relationList)) {
            materialPropertyRelationService.saveOrUpdateBatch(BeanMapper.mapList(relationList, MaterialPropertyRelationEntity.class), relationList.size(), false);
        }
        super.saveOrUpdateBatch(BeanMapper.mapList(saveImportVos, MaterialEntity.class), saveImportVos.size(), false);
    }

    @Override
    public MaterialVO queryExitFlag(String name, String propertyShowName, String unitName, Long categoryId) {
        MaterialVO resp = null;
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("name", name);
        query.eq("property_show_name", propertyShowName);
        query.eq("unit_name", unitName);
        query.eq("category_id", categoryId);
        MaterialEntity e = super.getOne(query);
        if(null != e) {
            resp = BeanMapper.map(e, MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialVO> queryExcelFlag(String name, String propertyShowName, String unitName, String categoryName) {
        List<MaterialVO> resp = new ArrayList<>();
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("name", name);
        query.eq("property_show_name", propertyShowName);
        query.eq("unit_name", unitName);
        query.eq("category_name", categoryName);
        List<MaterialEntity> eList = super.list(query);

        if(CollectionUtils.isNotEmpty(eList)) {
            resp = BeanMapper.mapList(eList, MaterialVO.class);
        }
        return resp;
    }

    @Override
    public List<Long> getAllInvalidMaterialCategoryIds(String categoryName) {
        QueryWrapper<MaterialEntity> query = new QueryWrapper<>();
        query.select("DISTINCT(category_id) as category_id");
        query.eq("valid_flag", ZDSMaterialCommonEnums.物资是否生效_否.getCode());
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        if(StringUtils.isNotBlank(categoryName)) {
            query.like("category_name", categoryName);
        }

        return super.listObjs(query, item -> Long.valueOf(item.toString()));
    }

    @Override
    public void delInvalidMaterial(List<Long> ids) {
        UpdateWrapper<MaterialEntity> update = new UpdateWrapper<>();
        update.in("id", ids);
        update.set("valid_flag", ZDSMaterialCommonEnums.物资是否生效_作废.getCode());
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());
        super.update(update);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void materialBatchValid(List<Long> ids) {
        UpdateWrapper<MaterialEntity> update = new UpdateWrapper<>();
        update.in("id", ids);
        update.set("valid_flag", ZDSMaterialCommonEnums.物资是否生效_是.getCode());
        update.set("update_time", new Date());
        update.set("update_user_code", InvocationInfoProxy.getUsercode());

        List<Long> getInValidPropertyItemIds = propertySubItemService.getInValidPropertyItemIds(ids);
        if(CollectionUtils.isNotEmpty(getInValidPropertyItemIds)) {
            propertySubItemService.validPropertyItems(getInValidPropertyItemIds);
        }
        super.update(update);
    }

    @Override
    public List<MaterialVO> saveFromInvalidMaterial(List<MaterialVO> saveList) {
        List<MaterialVO> resp = new ArrayList<>();
        List<Long> abandonIds = saveList.stream().map(MaterialVO::getId).collect(Collectors.toList());

        //验证 名称 + 单位 + 属性 是否重复
        List<MaterialVO> repeatList = checkUnitAndProperty(saveList, true);
        if(CollectionUtils.isNotEmpty(repeatList)) {
            //若存在重复的物资，则判断重复物资是否都是未生效的
            //如果都是未生效的物资 则将未生效的物资置为生效状态，对应数据不做保存处理
            //如果存在已生效的物资，则提示物资重复无法保存
            if (repeatList.stream().filter(r -> ZDSMaterialCommonEnums.物资是否生效_是.getCode().equals(r.getValidFlag())).count() == 0) {
                repeatList.stream().forEach(r -> r.setValidFlag(ZDSMaterialCommonEnums.物资是否生效_是.getCode()));

                saveOrUpdateBatch(BeanMapper.mapList(repeatList, MaterialEntity.class));
                resp.addAll(repeatList);

                Set<String> repeatKey = repeatList.stream().map(item -> item.getName() + item.getUnitId().toString() +
                        (StringUtils.isNotBlank(item.getPropertyShowName()) ? item.getPropertyShowName() : "")).collect(Collectors.toSet());

                //将重复物资从待保存列表中去掉
                saveList = saveList.stream().filter(r -> !repeatKey.contains(r.getName() + r.getUnitId().toString() +
                        (StringUtils.isNotBlank(r.getPropertyShowName()) ? r.getPropertyShowName() : ""))).collect(Collectors.toList());

                //若匹配物资是本次调整范围内的，则将其重作废列表中排除
                abandonIds.removeAll(saveList.stream().map(MaterialVO::getId).collect(Collectors.toList()));
                repeatList.clear();
            }

            if(CollectionUtils.isNotEmpty(repeatList)) {
                String tip = repeatList.stream().filter(r -> ZDSMaterialCommonEnums.物资是否生效_是.getCode().equals(r.getValidFlag())).map(material -> {
                    StringBuilder sp = new StringBuilder();
                    return sp.append("名称：").append(material.getName()).append(", 单位：").append(material.getUnitName()).append(", 属性：").append(material.getPropertyShowName()).toString();
                }).collect(Collectors.joining("; "));
                logger.error("未生效物资新增保存失败，存在重复物资：{}", tip);
                throw new BusinessException("物资【" + tip + "】分类下已存在，请勿重复添加");
            }
        }

        //待保存列表
        if(CollectionUtils.isNotEmpty(saveList)) {
            List<MaterialVO> saveData= new ArrayList<>();
            List<MaterialVO> updateData = new ArrayList<>();
            saveList.stream().forEach(item -> {
                item.setUpdateUserCode(InvocationInfoProxy.getUsercode());
                item.setUpdateTime(new Date());

                if(item.getOldUnitId().equals(item.getUnitId()) && StringUtils.equals(item.getPropertyShowName(), item.getOldPropertyShowName())) {
                    //做物资未做调整，则将物资直接置为生效状态
                    abandonIds.remove(item.getId());
                    item.setValidFlag(ZDSMaterialCommonEnums.物资是否生效_是.getCode());
                    updateData.add(item);
                } else {
                    //若物资属性发生变化，原始物资标记为作废
                    clearInvalidData(item);
                    item.setValidFlag(ZDSMaterialCommonEnums.物资是否生效_是.getCode());
                    saveData.add(item);
                }
            });

            if(CollectionUtils.isNotEmpty(saveData)) {
                resp.addAll(saveOrUpdateMaterials(saveData));
            }
            if(CollectionUtils.isNotEmpty(updateData)) {
                super.saveOrUpdateBatch(BeanMapper.mapList(updateData, MaterialEntity.class));
                resp.addAll(updateData);
            }
            if(CollectionUtils.isNotEmpty(abandonIds)) {
                delInvalidMaterial(abandonIds);
            }
        }


        return resp;
    }

    @Override
    public Long pageCount(Map<String, Object> pageParams) {
        return mapper.pageCount(pageParams);
    }

    @Override
    public List<MaterialVO> queryPage(Map<String, Object> pageParams) {
        return mapper.queryPage(pageParams);
    }

    private void clearInvalidData(BaseVO entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCreateUserCode(null);
    }
    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        boolean isFailed = false;

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader2.readExcel(mf);
            excelImportInfoData(resList.get(0));
            excelImportInfoData(resList.get(1));
            excelImportInfoData(resList.get(2));
            excelImportInfoData(resList.get(3));
        }
        return CommonResponse.success("导出成功");
    }

    @Override
    public String beforeValidCheck(List<Long> ids) {
        //TODO

//        List<MaterialVO> materialVOS = this.queryDetailList(ids, true);
//        if(CollectionUtils.isNotEmpty(materialVOS)) {
//            Map<Long, MaterialCategoryEntity> categoryMap = new HashMap<>();
//            Map<Long, List<MaterialCategoryPropertyEntity>> propertyMap = new HashMap<>();
//            Map<Long, List<MaterialCategoryPropertySubItemEntity>> propertyItemMap = new HashMap<>();
//
//            List<Long> categoryIds = new ArrayList<>(materialVOS.stream().map(MaterialVO::getCategoryId).collect(Collectors.toSet()));
//
//            for(MaterialVO material : materialVOS) {
//                materialCategoryService.queryCategoryListByIds();
//            }
//        }

        return null;
    }

    //数据组装 材料分类属性带id 执行更新 propertyService
    //数据组装 材料分类属性可选值 执行插入 propertySubItemService
    private void excelImportInfoData(List<List<String>> result) {
        if (result != null && result.size() > 0) {

            Map<Long, String> idMap = new HashMap<>();
            List<MaterialCategoryPropertySubItemEntity> detailList = new ArrayList<>();
            for (int i = 0; i < result.size(); i++) {
                List<String> dataList = result.get(i);
                Long id = Long.valueOf(dataList.get(2));//属性类别主键
                String name = dataList.get(3);//属性类别名称
                idMap.put(id, name);
                String detailName = dataList.get(4);//属性值
                String detailSort = dataList.get(5);//排序
                MaterialCategoryPropertySubItemEntity detail = new MaterialCategoryPropertySubItemEntity();
                detail.setName(detailName);
                detail.setSequence(Integer.valueOf(detailSort));
                detail.setPropertyId(id);
                detail.setEnabled(ZDSMaterialCommonEnums.停启用_启用.getCode());
                detail.setValidFlag(ZDSMaterialCommonEnums.分类设置属性值是否生效_是.getCode());
                detailList.add(detail);
            }
            QueryWrapper<MaterialCategoryPropertyEntity> query = new QueryWrapper<>();
            query.in("id", new ArrayList<>(idMap.keySet()));
            List<MaterialCategoryPropertyEntity> propertyList = propertyService.list(query);
            Map<Long, Long> categoryIdMap = new HashMap<>();
            propertyList.stream().forEach(item -> {
                item.setName(idMap.get(item.getId()));
                categoryIdMap.put(item.getId(), item.getCategoryId());
            });
            propertyService.saveOrUpdateBatch(propertyList,propertyList.size(), false);
            detailList.stream().forEach(item -> {
                item.setCategoryId(categoryIdMap.get(item.getPropertyId()));
            });
            propertySubItemService.saveOrUpdateBatch(detailList,detailList.size(), false);
        }
    }

    @Override
    public void handAdd(MaterialEntity material) {

        logger.info("处理物料：{}", JSONObject.toJSONString(material));
        material.setSourceId("0");
        if(StringUtils.isNotBlank(material.getPropertyShowName())) {

            List<MaterialPropertyRelationEntity> relations = analyMaterialRelation(BeanMapper.map(material, MaterialVO.class));

            if(CollectionUtils.isNotEmpty(relations)) {
                logger.info("保存物料关系：{}",  relations.size());
                materialPropertyRelationService.saveOrUpdateBatch(relations, relations.size(), false);
                material.setSourceId("1");
            }
        }
        super.saveOrUpdate(material, false);
    }

    private List<MaterialPropertyRelationEntity> analyMaterialRelation(MaterialVO material) {
        List<MaterialCategoryPropertyVO> property = propertyService.getAllByCategoryId(material.getCategoryId(), null);
        Map<String, MaterialCategoryPropertyVO> propertyNameMap = property.stream().collect(Collectors.toMap(MaterialCategoryPropertyVO::getName, Function.identity()));

        List<MaterialCategoryPropertySubItemVO> subItem = propertySubItemService.getAllByCategoryId(material.getCategoryId(), true);
        Map<String, MaterialCategoryPropertySubItemVO> subItemMap = subItem.stream().collect(Collectors.toMap(item -> item.getPropertyId().toString() + item.getName(), item -> item));

        MaterialCategoryPropertyVO tmpProperty = null;
        MaterialCategoryPropertySubItemVO tmpItem = null;
        MaterialPropertyRelationEntity  tmpRelation = null;
        List<MaterialPropertyRelationEntity> relations = new ArrayList<>();
        for(String attr : material.getPropertyShowName().split("；")) {
            tmpProperty = propertyNameMap.get(attr.split("：")[0]);
            if(null == tmpProperty) {
                relations.clear();
                break;
            }
            tmpRelation = new MaterialPropertyRelationEntity();
            tmpRelation.setPropertyId(tmpProperty.getId());
            tmpRelation.setCategoryId(material.getCategoryId());
            tmpRelation.setMaterialId(material.getId());
            tmpRelation.setPropertySequence(tmpProperty.getSequence());

            tmpItem = subItemMap.get(tmpProperty.getId().toString() + attr.split("：")[1]);
            if(null == tmpItem) {
                relations.clear();
                break;
            }
            tmpRelation.setPropertyItemId(tmpItem.getId());
            tmpRelation.setProductCode(tmpItem.getProductCode());
            tmpRelation.setProductCodeFlag(tmpProperty.getProductCodeFlag());
            tmpRelation.setPropertyValue(tmpItem.getName());
            relations.add(tmpRelation);
        }

        return relations;
    }
}
