package com.ejianc.business.zdsmaterial.pricelib.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: caojie
 * @CreateTime:2025-07-04 11:32
 * @Version: 1.0
 */
public class DefaultPricingEngine extends BasePricingEngine {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public BigDecimal calcPrice(PriceLibVO priceLibVO, List<MaterialPriceCalcSubConditionVO> conditions) throws Exception {
        logger.info("物料：{}  未匹配到计算公式，使用默认计算规则！", JSONObject.toJSONString(priceLibVO));
        priceLibVO.setCalcContent("未计算：未匹配到计算公式");
        return BigDecimal.ZERO;
    }
}
