package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.consumer.LinkerAccCooListener;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.service.IContractManagerService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.erp.vo.ContractManagerVO;
import com.ejianc.business.zdsmaterial.erp.vo.LinkerAccCooVO;
import com.ejianc.business.zdsmaterial.erp.vo.SubContractDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.SubContractVO;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyDetailVO;
import com.ejianc.business.zdsmaterial.sub.setting.bean.SubCheckerSettingEntity;
import com.ejianc.business.zdsmaterial.sub.setting.service.ISubCheckerSettingService;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分包合同
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("subContract")
public class SubContractController implements Serializable {
	private static final long serialVersionUID = 1L;
    @Value("${erp.appId}")
    private String appId;

    @Value("${erp.secret}")
    private String secret;

    @Value("${erp.reqHost}")
    private String reqHost;

    @Value("${erp.batchSize:100}")
    private String batchSize;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    private final String CONTRACT_ERP_REQ_URL = "/cefoc/yql/getSubContractList";
    private final String ERP_CACHE_PROJECT_PREFIX = "erp::project::";
    private final String ERP_CACHE_SUPPLIER_PREFIX = "erp::supplier::";
    private final String ERP_CACHE_EMPLOYEE_PREFIX = "erp::employee::";
    private final String ERP_CACHE_BRAND_PREFIX = "erp::brand::";


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private ISubContractService service;
    @Autowired
    private ISubContractDetailService detailService;
    @Autowired
    private ISubFeeApplyDetailService applyDetailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private ISubSupplierApi supplierApi;
    @Autowired
    private ISubLinkerApi subLinkerApi;
    @Autowired
    private ISubCheckerSettingService subCheckerSettingService;

    @Autowired
    private ISubFeeApplyService subFeeApplyService;

    @Autowired
    private QueueUtils queueUtils;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    private final String emptySID = "00000000-0000-0000-0000-000000000000";

    @Autowired
    private IContractManagerService contractManagerService;

    @PostMapping(value = "syncZdsContractBySid")
    public void syncZdsContractBySid() {
        logger.info("*********************中电四-单个分包合同信息同步任务 开始*********************");

        List<String> syncList = service.getSyncList();
        CommonResponse<String> result = null;
        while (CollectionUtils.isNotEmpty(syncList)) {
            for(String sourceContractId : syncList) {
                try {
                    result = syncErpContracts(null, null, true, true, null, sourceContractId);
                } catch (Exception e) {
                    logger.error("根据SID: "+sourceContractId+" 同步分包合同信息异常", e);
                    result = CommonResponse.error("合同同步失败");
                }
                service.updateSyncResult(sourceContractId, result.isSuccess() ? "1" : "2");
            }
            syncList = service.getSyncList();
        }

        logger.info("*********************中电四-单个合同信息同步任务 结束*********************");
    }

    /**
     * 中电四分包合同同步
     *
     * @param beginDate
     * @param endDate
     * @param initFlag
     * @param noDate
     * @param supplierSid
     * @return
     */
    @GetMapping(value = "syncErpContracts")
    public CommonResponse<String> syncErpContracts(@RequestParam(required = false) String beginDate,
                                                   @RequestParam(required = false) String endDate,
                                                   @RequestParam(required = false, defaultValue = "true") boolean initFlag,
                                                   @RequestParam(required = false, defaultValue = "false") boolean noDate,
                                                   @RequestParam(required = false) String supplierSid,
                                                   @RequestParam(required = false) String sourceContractId) {
        logger.info("*********************中电四-分包合同信息同步任务 开始*********************");
        Integer pageNum = 0;
        Map<String, String> param = new HashMap<>();
        String reqUrl = reqHost + CONTRACT_ERP_REQ_URL;
        try {
            Map<String, String> headers = new HashMap<>();
            String nowStr = DateFormatUtil.formatDate("yyyy-MM-dd HH:mm:ss", new Date());
            String yesterday = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtil.addDays(new Date(), -1)) + " 00:00:00";//获取昨天日期
            String nowDay = DateFormatUtil.formatDate("yyyy-MM-dd", new Date()) + " 23:59:59";
            headers.put("appid", toMD5(appId));
            headers.put("ticket", nowStr);
            headers.put("sign", toMD5(secret + toMD5(appId) + toMD5(nowStr)));
            if(!noDate) {
                param.put("BeginDateTime", StringUtils.isNotBlank(beginDate) ? beginDate : yesterday);
                param.put("EndDateTime", StringUtils.isNotBlank(endDate) ? endDate : nowDay);
            }
            if(StringUtils.isNotBlank(supplierSid)) {
                reqUrl = reqUrl + "?CompanyOId="+supplierSid;
            }
            if(StringUtils.isNotBlank(sourceContractId)) {
                reqUrl = reqUrl + "?keyword="+sourceContractId;
                param.remove("BeginDateTime");
                param.remove("EndDateTime");
            }
            param.put("PageSize", "50");
            JSONObject reqJson = null;
            JSONArray pageData =null;

            param.put("PageNum", String.valueOf(++pageNum));
            String reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);
            if("ok".equals(reqJson.getString("status"))) {
                logger.error("请求中电四获取分包合同成功：请求地址-{},参数-{},header-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers));
                handleContractErpPage(reqJson, initFlag);
            } else {
                logger.error("请求中电四获取分包合同结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
            }

        } catch (Exception e) {
            logger.error("获取中电四分包合同信息异常, 请求地址：{}, 请求参数：{},异常：{}", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat),e);
            return CommonResponse.error("同步中电四分包合同信息异常");
        }

        logger.info("*********************中电四-分包合同信息同步任务 结束*********************");
        return CommonResponse.success("中电四分包合同同步完成！");
    }
    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());

        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xff) + 0x100, 16).substring(1));
        }

        return sb.toString().toLowerCase();
    }



    /**
     * 该函数接收一个JSONArray类型的参数，解析其中的合同信息，
     * 并根据这些信息更新或插入数据库中的合同实体及其详细信息。
     * 通过遍历、转换和映射数据，最终将待保存的合同列表批量保存到数据库中。
     * @param dataJson
     * @param initFlag 初始同步标识，若为初始同步 则不生成订单
     * @throws ParseException
     */
    private void handleContractErpPage(JSONObject dataJson, boolean initFlag) throws ParseException {
        JSONObject tmp = null;
        SubContractEntity tmpContract = null;
        Map<String, SubContractEntity> contractSourceMap = new HashMap<>();
        List<SubContractEntity> saveList = new ArrayList<>();
        JSONObject sub = null;
        SubContractDetailEntity detail = null;
        Map<String, SubContractDetailEntity> subDetailSourceIdMap = new HashMap<>();
        List<SubContractDetailEntity> saveDetailList = new ArrayList<>();
        Set<String> brandNames = new HashSet<>();

        List<String> projectSourceIds = new ArrayList<>();//项目来源id
        List<String> supplierSourceIds = new ArrayList<>();//供应商来源id
        List<String> empSourceIds = new ArrayList<>();//人员来源id
        List<String> supLinkerSourceIds = new ArrayList<>();//乙方联系人来源id
        List<String> sourceDetailIds = new ArrayList<>();//明细来源id


        //主合同
        JSONArray mainContractArr = dataJson.getJSONArray("SubContractList");
        logger.info("本次待处理分包主合同：{}条", mainContractArr.size());
        handleTblData(mainContractArr,
                projectSourceIds, supplierSourceIds, supLinkerSourceIds, empSourceIds, contractSourceMap, 1);

        //附加合同
        JSONArray addiContractArr = dataJson.getJSONArray("SubContractInfoSub");
        logger.info("本次待处理分包附加合同：{}条", addiContractArr.size());
        handleTblData(addiContractArr,
                projectSourceIds, supplierSourceIds, supLinkerSourceIds, empSourceIds, contractSourceMap, 2);

        if(MapUtils.isEmpty(contractSourceMap)) {
            logger.info("************待处理分包合同数据为空，分包合同同步任务结束************");
            return;
        }

        //合同结算金额  tmpContract.setSettleSumMoney(tmp.getBigDecimal("Settle_SumMoney"));
        JSONArray settleArr = dataJson.getJSONArray("SubSettleList");
        logger.info("本次待处理结算数据：{}", settleArr.size());
        JSONObject tmpSettle = null;
        for(Object obj : settleArr) {
            tmpSettle = (JSONObject) obj;
            if(contractSourceMap.containsKey(tmpSettle.getString("SubContractInfo_FK"))) {
                contractSourceMap.get(tmpSettle.getString("SubContractInfo_FK")).setSettleSumMoney(tmpSettle.getBigDecimal("Settle_SumMoney"));
                if(contractSourceMap.get(tmpSettle.getString("SubContractInfo_FK")).getSettleSumMoney().compareTo(BigDecimal.ZERO) > 0) {
                    contractSourceMap.get(tmpSettle.getString("SubContractInfo_FK")).setIsSett(PlanConstant.STRING_YES); //有结算金额代表已结算
                }
            }
        }

        //已审金额 tmpContract.setAppearMoney(tmp.getBigDecimal("ApprMoney"));
        JSONArray approveArr = dataJson.getJSONArray("SubPaymentHistoryList");
        logger.info("本次待处理已审合同数据：{}", approveArr.size());
        JSONObject tmpApprove = null;
        for(Object obj : approveArr) {
            tmpApprove = (JSONObject) obj;
            if(contractSourceMap.containsKey(tmpApprove.getString("SubContractInfo_FK"))) {
                contractSourceMap.get(tmpApprove.getString("SubContractInfo_FK")).setAppearMoney(tmpApprove.getBigDecimal("ApprMoney"));
                contractSourceMap.get(tmpApprove.getString("SubContractInfo_FK")).setPayMoney(tmpApprove.getBigDecimal("PayMoney"));
            }
        }

        //是否有申请中分包费用 0没有 1有 tmpContract.setIsApply(tmp.getInteger("IsApply"));
        JSONArray applyArr = dataJson.getJSONArray("SubPaymentList");
        logger.info("本次待处理费用申请中合同数据：{}", applyArr.size());
        JSONObject tmpApply = null;
        for(Object obj : applyArr) {
            tmpApply = (JSONObject) obj;
            if(contractSourceMap.containsKey(tmpApply.getString("SubContractInfo_FK"))) {
                contractSourceMap.get(tmpApply.getString("SubContractInfo_FK")).setIsApply("是".equals(tmpApply.getString("IsApply")) ? 1 : 0);
            }
        }

        //完工状态 0未 1已完成 tmpContract.setIsFinish(tmp.getString("IsFinish"));
        JSONArray finishArr = dataJson.getJSONArray("SubPaymentList");
        logger.info("本次待处理完工合同数据：{}", finishArr.size());
        JSONObject tmpFinish = null;
        for(Object obj : finishArr) {
            tmpFinish = (JSONObject) obj;
            if(contractSourceMap.containsKey(tmpFinish.getString("SubContractInfo_FK"))) {
                contractSourceMap.get(tmpFinish.getString("SubContractInfo_FK")).setIsFinish(tmpFinish.getString("IsFinish"));
            }
        }

        //合同字表
        handleSubTblData(dataJson.getJSONArray("ContractInfo_SubDModels"),
                contractSourceMap, sourceDetailIds, brandNames, subDetailSourceIdMap);

        //附加合同字表
        handleSubTblData(dataJson.getJSONArray("ContractInfo_SubDModelsTwo"),
                contractSourceMap, sourceDetailIds, brandNames, subDetailSourceIdMap);

        //查询合同信息是否存在
        List<String> contractSids = new ArrayList<>(contractSourceMap.keySet());
        //获取字表中主合同SID
        Set<String> parentSids = contractSourceMap.values().stream().filter(item -> "2".equals(item.getSubContractFlag())).map(SubContractEntity::getSubContractParentSid)
                .collect(Collectors.toSet());
        contractSids.addAll(parentSids);

        List<SubContractEntity> dbEntities = service.getAllBySourceIds(contractSids);
        Map<String, SubContractEntity> dbContractMap = new HashMap<>();
        List<Long> delContractIds = new ArrayList<>();

        if(CollectionUtils.isNotEmpty(dbEntities)) {

            Map<String, SubContractDetailEntity> detailDbMap = new HashMap<>();
            List<SubContractDetailEntity> detailDbEntities = detailService.getAllBySourceIds(sourceDetailIds);
            if(CollectionUtils.isNotEmpty(detailDbEntities)) {
                detailDbMap.putAll(detailDbEntities.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item, (v1, v2)->v2)));
            }
            //已存在，更新合同状态
            SubContractEntity syncContractVO = null;

            for(SubContractEntity item : dbEntities) {
                syncContractVO = contractSourceMap.get(item.getSourceContractId());
                if(null != syncContractVO) {
                    if("5".equals(syncContractVO.getErpStatus())) {
                        //ERP单据作废 单据删除
                        delContractIds.add(item.getId());
                        contractSourceMap.remove(item.getSourceContractId());
                        continue;
                    }

                    //合同更新
                    //更新金额
                    item.setContractMoney(syncContractVO.getContractMoney());
                    //更新最后更新时间
                    item.setSystemLastUpdateTime(syncContractVO.getSystemLastUpdateTime());
                    //更新附加合同额
                    item.setFuJiaMoney(syncContractVO.getFuJiaMoney());
                    //更新合同内容
                    item.setContractContent(syncContractVO.getContractContent());
                    item.setTaxPointName(syncContractVO.getTaxPointName());
                    item.setPurchaseType(syncContractVO.getPurchaseType());
                    //更新专业类别
                    item.setSpecialtyType(syncContractVO.getSpecialtyType());
                    item.setIsFinish(syncContractVO.getIsFinish());
                    item.setIsSett(syncContractVO.getIsSett());
                    item.setPayMoney(syncContractVO.getPayMoney());
                    item.setPartyContactSId(syncContractVO.getPartyContactSId());
                    item.setProManagerSidPartyBId(syncContractVO.getProManagerSidPartyBId());
                    item.setProManagerTelPartyB(syncContractVO.getProManagerTelPartyB());
                    item.setSubContractParentSid(syncContractVO.getSubContractParentSid());
                    item.setProManagerPartyB(syncContractVO.getProManagerPartyB());//乙方项目经理
                    item.setIdCardPartyB(syncContractVO.getIdCardPartyB());
                    item.setSysLastUpd(syncContractVO.getSysLastUpd());

                    //更新 合同类型  定价方式
                    item.setSubContractFlag(syncContractVO.getSubContractFlag());
                    item.setSpecialtyType(syncContractVO.getSpecialtyType());
                    item.setSettleSumMoney(syncContractVO.getSettleSumMoney());
                    item.setAppearMoney(syncContractVO.getAppearMoney());
                    item.setSubContractParentSid(syncContractVO.getSubContractParentSid());
                    item.setIsApply(syncContractVO.getIsApply());
                    item.setBillType(syncContractVO.getBillType());
                    item.setIsOfficialSeal(syncContractVO.getIsOfficialSeal());
                    item.setBillCode(syncContractVO.getBillCode());
                    item.setTaxRate(syncContractVO.getTaxRate());
                    item.setSubContractParentSid(syncContractVO.getSubContractParentSid());
                    item.setSupplierName(syncContractVO.getSupplierName());
                    saveList.add(item);
//                    for(SubContractDetailEntity syncDetail : syncContractVO.getDetailList()) {
//                        if(!detailDbMap.containsKey(syncDetail.getSourceDetailId())) {
//                            syncDetail.setSubContractSid(item.getSubContractParentSid());
//                            syncDetail.setContractId(item.getId());
//                            syncDetail.setSubContractId(null != item.getContractId() ? item.getContractId().toString() : null);
//                            item.getDetailList().add(syncDetail);
//                        } else {
//                            //更新费用包编码
//                            detailDbMap.get(syncDetail.getSourceDetailId()).setProjectContent(syncDetail.getProjectContent());
//                            detailDbMap.get(syncDetail.getSourceDetailId()).setCostCodingName(syncDetail.getCostCodingName());
//                            item.getDetailList().add(detailDbMap.get(syncDetail.getSourceDetailId()));
//                        }
//                    }
                    contractSourceMap.remove(item.getSourceContractId());
                } else {
                    dbContractMap.put(item.getSourceContractId(), item);
                }
            }
            for(Iterator<String> it =contractSourceMap.keySet().iterator(); it.hasNext();) {
                tmpContract = contractSourceMap.get(it.next());

                if(tmpContract.getSubContractFlag()==2&&StringUtils.isNotBlank(tmpContract.getSubContractParentSid())) {
                    if(dbContractMap.containsKey(tmpContract.getSubContractParentSid())) {
                        tmpContract.setContractId(dbContractMap.get(tmpContract.getSubContractParentSid()).getId());
                    } else {
                        logger.error("分包合同对应主合同【合同信息：{}】在系统不存在！", JSONObject.toJSONString(tmpContract, SerializerFeature.PrettyFormat));
                    }
                }
            }
        }
        saveList.addAll(contractSourceMap.values());

        logger.info("本次同步分包，作废入库分包合同：{}条", delContractIds.size());
        if(CollectionUtils.isNotEmpty(delContractIds)) {
            service.cancelContract(delContractIds);
        }

        checkSyncContractInfo(saveList,
                empSourceIds, supplierSourceIds, projectSourceIds, supLinkerSourceIds, brandNames,sourceDetailIds,initFlag);
    }

    /**
     * 中电四分包合同同步-主表数据处理
     *
     * @param contractArr
     * @param projectSourceIds
     * @param supplierSourceIds
     * @param supLinkerSourceIds
     * @param empSourceIds
     * @param contractSourceMap
     * @param subContractFlag
     */
    private void handleTblData(JSONArray contractArr, List<String> projectSourceIds,
                               List<String> supplierSourceIds, List<String> supLinkerSourceIds, List<String> empSourceIds,
                               Map<String, SubContractEntity> contractSourceMap, Integer subContractFlag) {
        JSONObject tmp = null;
        SubContractEntity tmpContract= null;
        for(Object obj : contractArr) {
            tmp = (JSONObject) obj;
            tmpContract = new SubContractEntity();
            //记录信息
            //项目
            tmpContract.setSourceProjectId(tmp.getString("Account_Project_Sid"));
            tmpContract.setProjectName(tmp.getString("Project_Name"));
            projectSourceIds.add(tmpContract.getSourceProjectId());
            tmpContract.setErpStatus(tmp.getString("status"));
            //分包联系人
            tmpContract.setPartyContacts(StringUtils.isNotBlank(tmp.getString("PartBContacts")) ? tmp.getString("PartBContacts").toLowerCase() : null); //乙方联系人
            tmpContract.setPartyContactSId(tmp.getString("PartBContactsOID")); //乙方联系人SID
            if(StringUtils.isNotBlank(tmpContract.getPartyContactSId())) {
                supLinkerSourceIds.add(tmpContract.getPartyContactSId());
            }
            //人员
            tmpContract.setSourceCompileId(tmp.getString("sys_createdby"));
            tmpContract.setCompileName(tmp.getString("Register_Name"));
            empSourceIds.add(tmpContract.getSourceCompileId());
            tmpContract.setId(IdWorker.getId());
            tmpContract.setBillCode(tmp.getString("Contract_ID"));
            tmpContract.setContractName(tmp.getString("Contract_Title"));
            tmpContract.setSourceContractId(tmp.getString("C_PS_SubContractInfoOID"));
            tmpContract.setContractMoney(tmp.getBigDecimal("Contract_Money"));
            tmpContract.setContractPartyA(tmp.getString("Contract_PartyA"));//合同甲方
            tmpContract.setContractContent(tmp.getString("ContractContent"));//合同内容

            //匹配项目经理
            tmpContract.setProManagerPartyB(tmp.getString("ProManager_PartyB"));//乙方项目经理
            tmpContract.setProManagerSidPartyB(StringUtils.isNotBlank(tmp.getString("ProManagerSid_PartyB")) ? tmp.getString("ProManagerSid_PartyB").toLowerCase() : null);
            tmpContract.setProManagerTelPartyB(tmp.getString("ProManagerTel_PartyB"));
            tmpContract.setIdCardPartyB(tmp.getString("IDCard_PartyB"));
            tmpContract.setFuJiaMoney(BigDecimal.ZERO);

            tmpContract.setSysLastUpd(tmp.getString("SYS_LAST_UPD")); //ERP最后更新时间
            tmpContract.setSupplierName(tmp.getString("Contract_PartyB")); //供应商名称

            //设置供应商信息
            tmpContract.setSourceSupplierId(StringUtils.isNotBlank(tmp.getString("contract_partyb_sid")) ? tmp.getString("contract_partyb_sid").toLowerCase() : null);
            supplierSourceIds.add(tmp.getString("contract_partyb_sid"));
            String sys_last_upd = tmp.getString("SYS_LAST_UPD");
            try {
                tmpContract.setSystemLastUpdateTime(DateFormatUtil.parseDate("yyyy-MM-dd HH:mm:ss",sys_last_upd.replace("T", " ")));
            } catch (Exception e) {
                logger.error("合同日期格式化异常, 合同信息-{}", JSONObject.toJSONString(tmp, SerializerFeature.PrettyFormat) , e);
            }
            //新补充信息
            tmpContract.setSpecialtyType(tmp.getString("SpecialtyType"));
            tmpContract.setContractType(tmp.getString("Contract_Type"));

            tmpContract.setSubContractFlag(subContractFlag); //主合同
            if(subContractFlag == 2) {//附加合同
                tmpContract.setSubContractParentSid(tmp.getString("SubContract_PrarentSid"));
            }

            tmpContract.setBillType(tmp.getString("BillType"));
            tmpContract.setIsOfficialSeal(StringUtils.isNotBlank(tmp.getString("IsOfficial_Seal")) ?
                    "true".equals(tmp.getString("IsOfficial_Seal").toLowerCase()) ? 1 : 0 : null);

//            tmpContract.setIsSett(tmp.getString("isSett"));

            //合同税率
            tmpContract.setTaxRate(null != tmp.get("TaxPointName") && StringUtils.isNotBlank(tmp.getString("TaxPointName")) ? ComputeUtil.safeDiv(new BigDecimal(tmp.getString("TaxPointName").replace("%", "")), new BigDecimal("100")) : null); //税率

            contractSourceMap.put(tmpContract.getSourceContractId(), tmpContract);
        }
    }

    /**
     * 中电四分包合同同步-字表数据处理
     *
     * @param subArr
     * @param contractSourceMap
     * @param sourceDetailIds
     * @param brandNames
     * @param subDetailSourceIdMap
     */
    private void handleSubTblData(JSONArray subArr,
                               Map<String, SubContractEntity> contractSourceMap,
                               List<String> sourceDetailIds,
                               Set<String> brandNames,
                               Map<String, SubContractDetailEntity> subDetailSourceIdMap) {
        logger.info("本次待处理字表数据：{}条", subArr.size());
        JSONObject sub = null;
        SubContractEntity tmpContract= null;
        SubContractDetailEntity detail= null;
        if (null!=subArr && subArr.size() > 0){
            for(Object subD : subArr) {
                sub = (JSONObject) subD;
                tmpContract = contractSourceMap.get(sub.getString("SubContractInfo_FK"));
                if(null != tmpContract) {
                    Integer subContractFlag = tmpContract.getSubContractFlag();
                    detail = new SubContractDetailEntity();
                    detail.setProjectContent(sub.getString("ProjectContent"));
                    detail.setSourceDetailId(sub.getString("C_PS_SubContractInfo_SubDOID"));
                    sourceDetailIds.add(detail.getSourceDetailId());
                    detail.setPropertyValue(sub.getString("SpeModel"));
                    detail.setDetailUnitName(sub.getString("Unit"));
                    detail.setDetailNum(new BigDecimal(sub.getString("Number")));
                    detail.setMaterialTaxPrice(new BigDecimal(sub.getString("MaterialPrice")));
                    detail.setHumanTaxPrice(new BigDecimal(sub.getString("ManPrice")));
                    detail.setCompareTaxPrice(new BigDecimal(sub.getString("ComprePrice")));
                    detail.setSumTaxMoney(new BigDecimal(sub.getString("SumMoney")));
                    detail.setSumTaxConMoney(new BigDecimal(sub.getString("SubConMoney")));
                    detail.setBrandName(sub.getString("Brand"));
                    if(StringUtils.isNotBlank(detail.getBrandName())) {
                        brandNames.add(detail.getBrandName());
                    }
                    detail.setDetailRemark(sub.getString("Meno"));
                    detail.setCostCodingName(sub.getString("PacketCode"));
                    detail.setSortId(Integer.valueOf(sub.getString("SortID")));
                    detail.setSubContractSid(tmpContract.getSourceContractId());
                    detail.setSourceContractId(tmpContract.getSourceContractId());
                    if (subContractFlag==2){
                        //附件合同记录合同id
                        detail.setSubContractSid(tmpContract.getSubContractParentSid());
                    }else {
                        detail.setSubContractSid(tmpContract.getSourceContractId());
                    }
                    detail.setSourceType(subContractFlag);
                    tmpContract.getDetailList().add(detail);
                    subDetailSourceIdMap.put(detail.getSourceDetailId(), detail);
                }
            }
        }
    }

    /**
     * 中电四分包合同同步-新增数据转化，数据保存更新
     *
     * @param contractVOs
     * @param empSourceIds
     * @param supSourceIds
     * @param prjSourceIds
     * @param supLinkerSourceIds
     * @param brandNames
     * @param detailSourceIdS
     * @param initFlag
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public List<SubContractEntity> checkSyncContractInfo(List<SubContractEntity> contractVOs,
                                                      List<String> empSourceIds, List<String> supSourceIds,
                                                      List<String> prjSourceIds, List<String> supLinkerSourceIds,
                                                         Set<String> brandNames,List<String> detailSourceIdS, boolean initFlag) {

        List<SubContractDetailEntity> saveDetails = new ArrayList<>();
        Map<String, SupplierVO> supplierSourceMap = new HashMap<>();
        Map<String, ProjectPoolSetVO> projectSourceMap = new HashMap<>();
        Map<String, EmployeeVO> empSourceMap = new HashMap<>();
        Map<String, LinkerVO> linkerSourceMap = new HashMap<>();
        Map<String, SubContractDetailEntity> detailSourceIdMap = new HashMap<>();
        List<SubContractEntity> saveList = new ArrayList<>();
        SubContractEntity saveContractInfo = null;
        List<Long> queryOrgIds = new ArrayList<>();
        Map<String, PurchasePlanDetailVO> planDetailMap = null;

        //待开通协同账号联系人
        Set<Long> coorLinkerIdSet = new HashSet<>();

        //查询品牌信息
        Map<String, BrandEntity> brandNameMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(brandNames)) {
            brandNameMap = brandService.getAllByNames(new ArrayList<>(brandNames));
        }
        //查询人员信息
        if(!empSourceIds.isEmpty()) {
            CommonResponse<List<EmployeeVO>> empResp = employeeApi.getAllBySourceIds(empSourceIds);
            if(!empResp.isSuccess()) {
                logger.error("分包合同同步失败，获取ERP接货人信息失败， {}", JSONObject.toJSONString(empResp, SerializerFeature.PrettyFormat));
//                throw new BusinessException("同步失败，根据ERP接货人主键获取匹配人员信息失败！");
            }
            empSourceMap = empResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        }

        //查询供应商信息
        if(!supSourceIds.isEmpty()) {
            JSONObject supParams = new JSONObject();
            supParams.put("sourceIds", supSourceIds);
            List<SupplierVO> supplierVos = null;
            CommonResponse<List<SupplierVO>> supplierResp = supplierApi.getAllBySourceIds(supParams);
            if(!supplierResp.isSuccess()) {
                logger.error("分包合同同步失败，获取ERP供应商信息失败， {}", JSONObject.toJSONString(supplierResp, SerializerFeature.PrettyFormat));
                supplierVos = service.getAllSubSupInfoBySourceIds(supSourceIds);
            } else {
                supplierVos = supplierResp.getData();
            }

            if(CollectionUtils.isEmpty(supplierVos)) {
                throw new BusinessException("同步失败，根据ERP供应商主键获取匹配供应商信息失败！");
            }
            supplierSourceMap = supplierVos.stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
        }

        //查询合同明细
        List<SubContractDetailEntity> allBySourceIds = detailService.getAllBySourceIds(detailSourceIdS);
        if(CollectionUtils.isNotEmpty(allBySourceIds)) {
            detailSourceIdMap = allBySourceIds.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item));
        }
        //查询项目信息
        CommonResponse<List<ProjectPoolSetVO>> poolResp = projectPoolApi.getAllBySourceIds(prjSourceIds);
        if(!poolResp.isSuccess()) {
            throw new BusinessException("同步失败，根据ERP项目主键获取匹配项目信息失败！");
        }
        projectSourceMap = poolResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));

        //查询乙方联系人信息
        if(!supLinkerSourceIds.isEmpty()) {
            CommonResponse<List<LinkerVO>> linkerResp = subLinkerApi.getBySourceIds(supLinkerSourceIds);
            if(!linkerResp.isSuccess()) {
                logger.error("分包合同同步失败，获取ERP乙方联系人信息失败， {}", JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("同步失败，根据ERP供应商联系人主键获取联系人信息失败！");
            }
            linkerSourceMap = linkerResp.getData().stream().collect(Collectors.toMap(item -> item.getThirdSourceId(), item -> item));
        }

        //TODO 查询乙方项目经理
        for(SubContractEntity contractVO : contractVOs) {
            saveContractInfo = null != contractVO.getCreateTime() ? BeanMapper.map(contractVO, SubContractEntity.class) : new SubContractEntity();
            saveContractInfo.setId(contractVO.getId());
            saveContractInfo.setSysLastUpd(contractVO.getSysLastUpd());
            if(StringUtils.isBlank(contractVO.getContractName())) {
                logger.error("同步失败，参数：ERP系统合同名称为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                continue;
            }
            if(StringUtils.isBlank(contractVO.getBillCode())) {
                logger.error("同步失败，参数：ERP系统合同编码为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                if(!initFlag) {
                    continue;
                }
                contractVO.setBillCode(contractVO.getSourceContractId());
            }

            SupplierVO supplier = null;
            if(StringUtils.isBlank(contractVO.getSupplierCode()) && StringUtils.isBlank(contractVO.getSourceSupplierId())) {
                logger.error("同步失败，参数：ERP供应商主键/编码不能都为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                if(!initFlag) {
                    continue;
                }
            }
            //TODO 供应商同步
            if(StringUtils.isNotBlank(contractVO.getSourceSupplierId())) {
                supplier = supplierSourceMap.get(contractVO.getSourceSupplierId());
                if(null == supplier) {
                    logger.error("同步失败，不存与ERP供应商主键匹配的供应商, 同步信息:{}", JSONObject.toJSONString(contractVO));
                } else {
                    //供应商信息
                    saveContractInfo.setSupplierId(supplier.getId());
                    saveContractInfo.setSupplierCode(supplier.getCode());
                    saveContractInfo.setSupplierName(supplier.getName());
                }
                saveContractInfo.setSourceSupplierId(contractVO.getSourceSupplierId());
            }

            //项目信息
            ProjectPoolSetVO project = null;
            if(StringUtils.isBlank(contractVO.getSourceProjectId()) || emptySID.equals(contractVO.getProjectId())) {
                logger.error("同步失败，参数：ERP项目主键不能都为空, 同步信息:{}", JSONObject.toJSONString(contractVO));
                if(!initFlag) {
                    continue;
                }
            }
            project = projectSourceMap.get(contractVO.getSourceProjectId());
//            if(null == project) {
//                logger.error("同步失败，不存与ERP项目主键匹配的项目 同步信息:{}", JSONObject.toJSONString(contractVO));
//                if(!initFlag) {
//                    continue;
//                }
//            }
//            if(null == contractVO.getSubContractFlag()) {
//                logger.error("同步失败，参数：合同标识为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                continue;
//            }
//            if(!ZDSMaterialCommonEnums.主合同.getCode().equals(contractVO.getSubContractFlag()) && !ZDSMaterialCommonEnums.附加合同.getCode().equals(contractVO.getSubContractFlag())) {
//                logger.error("同步失败，错误的合同标识：{}, 同步信息:{}", contractVO.getSubContractFlag(), JSONObject.toJSONString(contractVO));
//                continue;
//            }
            LinkerVO supplierManager = null;

//            //乙方联系人 SID linkerSourceMap 目前为了方便测试 不设置
            if(StringUtils.isNotBlank(contractVO.getPartyContactSId())) {
//                logger.error("同步失败，参数：乙方联系人SID为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                continue;

                supplierManager =linkerSourceMap.get(contractVO.getPartyContactSId());
                saveContractInfo.setPartyContactSId(contractVO.getPartyContactSId());
                saveContractInfo.setPartyContacts(contractVO.getPartyContacts());
                if(null == supplierManager) {
//                    logger.error("不存与ERP乙方联系人主键匹配的供应商联系人信息 同步信息:{}", JSONObject.toJSONString(contractVO));
//                    continue;
                } else {
                    saveContractInfo.setPartyContactId(supplierManager.getId());
                    saveContractInfo.setPartySupContactId(supplierManager.getSupUserId());
                }
            }

            //经办人
            if(StringUtils.isBlank(contractVO.getSourceCompileId())) {
//                logger.error("同步失败，ERP合同编制人主键不能为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                if(!initFlag) {
//                    continue;
//                }
            }
            EmployeeVO operator = empSourceMap.get(contractVO.getSourceCompileId());
            if(null == operator) {
//                logger.error("同步失败，不存与ERP合同经办人主键匹配的人员 同步信息:{}", JSONObject.toJSONString(contractVO));
//                if(!initFlag) {
//                    continue;
//                }
            }
            // 合同编码
            saveContractInfo.setBillCode(contractVO.getBillCode());
            // 合同名称
            saveContractInfo.setContractName(contractVO.getContractName());
            // 合同来源主键
            saveContractInfo.setSourceContractId(contractVO.getSourceContractId());
            saveContractInfo.setTaxPointName(contractVO.getTaxPointName());
            saveContractInfo.setPurchaseType(contractVO.getPurchaseType());
            saveContractInfo.setTaxRate(contractVO.getTaxRate());

            //项目信息
            if(null != project) {
                saveContractInfo.setProjectId(project.getId());
                saveContractInfo.setProjectCode(project.getCode());
                saveContractInfo.setProjectName(project.getName());
                saveContractInfo.setOrgId(project.getProjectDepartmentId());
                saveContractInfo.setOrgCode(project.getProjectDepartmentCode());
                saveContractInfo.setOrgName(project.getProjectDepartmentName());
                saveContractInfo.setParentOrgCode(project.getOrgCode());
                saveContractInfo.setParentOrgId(project.getOrgId());
                saveContractInfo.setParentOrgName(project.getOrgName());
                saveContractInfo.setProjectManagementId(project.getProjectManagementId());
                saveContractInfo.setProjectManagementName(project.getProjectManagementName());
                saveContractInfo.setProjectManagementPhone(project.getProjectManagementPhone());
                saveContractInfo.setExecutCode(project.getCode());
                saveContractInfo.setExecutUnitId(project.getId().toString());
                saveContractInfo.setExecutUnitName(project.getName());
            }
            saveContractInfo.setSourceProjectId(contractVO.getSourceProjectId());

            //编制人信息
            if(null != operator) {
                saveContractInfo.setCompileId(operator.getId());
                saveContractInfo.setCompileName(operator.getName());
                saveContractInfo.setCompileCode(operator.getCode());
            }

            // 最后更新时间
            saveContractInfo.setSystemLastUpdateTime(contractVO.getSystemLastUpdateTime());
            //附加合同额
            saveContractInfo.setFuJiaMoney(contractVO.getFuJiaMoney());
            if(StringUtils.isBlank(saveContractInfo.getOrgCode())) {
                //查询项目部信息
                queryOrgIds.add(saveContractInfo.getOrgId());
            }
            if(StringUtils.isBlank(saveContractInfo.getParentOrgCode())) {
                //查询项目部所属组织信息
                queryOrgIds.add(saveContractInfo.getParentOrgId());
            }
            //合同内容
            saveContractInfo.setContractContent(contractVO.getContractContent());
            //专业类别
            saveContractInfo.setSpecialtyType(contractVO.getSpecialtyType());
            //合同类型  定价方式
            saveContractInfo.setContractType(contractVO.getContractType());

            //分包结算金额
            saveContractInfo.setSettleSumMoney(contractVO.getSettleSumMoney());
            //累积已批金额
            saveContractInfo.setAppearMoney(contractVO.getAppearMoney());
            //合同标识 1 主合同,2 附加合同
            saveContractInfo.setSubContractFlag(contractVO.getSubContractFlag());
            if(Integer.valueOf("1").equals(saveContractInfo.getSubContractFlag())) {
                saveContractInfo.setContractId(saveContractInfo.getId());
            }
            //附加合同对应的主合同主键
            saveContractInfo.setSubContractParentSid(contractVO.getSubContractParentSid());
            //是否有申请中分包费用 0没有 1有
            saveContractInfo.setIsApply(contractVO.getIsApply());
            //发票类型
            saveContractInfo.setBillType(contractVO.getBillType());
            //签章状态 0否1已签
            saveContractInfo.setIsOfficialSeal(contractVO.getIsOfficialSeal());
            //合同金额
            saveContractInfo.setContractMoney(contractVO.getContractMoney());
            //合同甲方
            saveContractInfo.setContractPartyA(contractVO.getContractPartyA());
            //乙方项目经理
            saveContractInfo.setProManagerPartyB(contractVO.getProManagerPartyB());
            //乙方项目经理
            saveContractInfo.setProManagerSidPartyB(contractVO.getContractPartyA());
            //乙方项目经理
            saveContractInfo.setProManagerSidPartyBId(contractVO.getProManagerSidPartyBId());
            //乙方项目经理
            saveContractInfo.setProManagerTelPartyB(contractVO.getProManagerTelPartyB());
            //乙方项目经理
            saveContractInfo.setIdCardPartyB(contractVO.getIdCardPartyB());

            saveContractInfo.setIsFinish(contractVO.getIsFinish());
            saveContractInfo.setIsSett(contractVO.getIsSett());

            saveContractInfo.setContractType(contractVO.getContractType());
            saveContractInfo.setContractId(contractVO.getContractId());
            saveContractInfo.setBillType(contractVO.getBillType());
            saveContractInfo.setPaymentStyleSid(contractVO.getPaymentStyleSid());
            saveContractInfo.setPaymentStyle(contractVO.getPaymentStyle());
            saveContractInfo.setSignStatusCode(contractVO.getSignStatusCode());
            saveContractInfo.setSignStatusName(contractVO.getSignStatusName());

            //合同税率
            saveContractInfo.setTaxRate(contractVO.getTaxRate());

            SubContractDetailEntity saveDetailVo = null;
            Map<String, SubContractDetailEntity> detailIdMap = new HashMap<>();
            boolean saveFlag = true;
            for(SubContractDetailEntity detail : contractVO.getDetailList()) {
                saveFlag = true;
                //新增项
                saveDetailVo = detailSourceIdMap.get(detail.getSourceDetailId());
                if(null == saveDetailVo) {
                    saveDetailVo = new SubContractDetailEntity();
                    saveDetailVo.setId(IdWorker.getId());
                    saveDetailVo.setRowState("add");
                }
                if(null == detail.getSourceContractId()) {
                    saveFlag = false;
                    logger.error("同步失败，参数：合同明细-ERP主表主键为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    break;
                }
                if(null == detail.getSourceDetailId()) {
                    saveFlag = false;
                    logger.error("同步失败，参数：合同明细-ERP子表主键为空 同步信息:{}", JSONObject.toJSONString(contractVO));
                    break;
                }
                if(null == detail.getDetailNum()) {
//                    logger.error("同步失败，参数：合同明细-数量为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                    if(!initFlag) {
//                        saveFlag = false;
//                        break;
//                    }
                }
                if(null == detail.getDetailPrice()) {
//                    logger.error("同步失败，参数：合同明细-单价为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                    if(!initFlag) {
//                        saveFlag = false;
//                        break;
//                    }
                }
                if(null == detail.getDetailTaxPrice()) {
//                    logger.error("同步失败，参数：合同明细-单价(含税)为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                    if(!initFlag) {
//                        saveFlag = false;
//                        break;
//                    }
                }
                if(null == detail.getDetailMny()) {
//                    logger.error("同步失败，参数：合同明细-金额为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                    if(!initFlag) {
//                        saveFlag = false;
//                        break;
//                    }
                }
                if(null == detail.getDetailTaxMny()) {
//                    logger.error("同步失败，参数：合同明细-金额(含税)为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                    if(!initFlag) {
//                        saveFlag = false;
//                        break;
//                    }
                }
                if(null == detail.getDetailTaxRate()) {
//                    logger.error("同步失败，参数：合同明细-税率为空 同步信息:{}", JSONObject.toJSONString(contractVO));
//                    if(!initFlag) {
//                        saveFlag = false;
//                        break;
//                    }
                }
                if(!brandNameMap.containsKey(detail.getBrandName())) {
//                    logger.error("同步失败，品牌-[{}]在供应链平台无对应数据", detail.getBrandName());
//                    if(!initFlag) {
//                        saveFlag = false;
//                        break;
//                    }
                }
                //来源 主子表Id
                saveDetailVo.setSourceContractId(detail.getSourceContractId());
                saveDetailVo.setSourceDetailId(detail.getSourceDetailId());
                saveDetailVo.setProjectContent(detail.getProjectContent());
                saveDetailVo.setPropertyValue(detail.getPropertyValue());
                saveDetailVo.setDetailUnitId(detail.getDetailUnitId());
                saveDetailVo.setDetailUnitName(detail.getDetailUnitName());
                //数量
                saveDetailVo.setDetailNum(detail.getDetailNum());
                saveDetailVo.setMaterialTaxPrice(detail.getMaterialTaxPrice());
                saveDetailVo.setHumanTaxPrice(detail.getHumanTaxPrice());
                saveDetailVo.setCompareTaxPrice(detail.getCompareTaxPrice());
                saveDetailVo.setSumMoney(detail.getSumMoney());
                saveDetailVo.setSumTaxMoney(detail.getSumTaxConMoney());
                saveDetailVo.setSumConMoney(detail.getSumConMoney());
                saveDetailVo.setSumTaxConMoney(detail.getSumTaxConMoney());
                //品牌
                saveDetailVo.setBrandId(brandNameMap.containsKey(detail.getBrandName()) ? brandNameMap.get(detail.getBrandName()).getId() : null);
                saveDetailVo.setBrandName(detail.getBrandName());
                saveDetailVo.setDetailRemark(detail.getDetailRemark());
                saveDetailVo.setCostCodingId(detail.getCostCodingId());
                saveDetailVo.setSortId(detail.getSortId());
                saveDetailVo.setDetailPrice(detail.getDetailPrice());
                saveDetailVo.setDetailTaxPrice(detail.getDetailTaxPrice());
                saveDetailVo.setDetailMny(detail.getDetailMny());
                saveDetailVo.setDetailTaxMny(detail.getDetailTaxMny());
                saveDetailVo.setDetailTaxRate(detail.getDetailTaxRate());
                String detailCode = StringUtils.isNotBlank(saveContractInfo.getBillCode()) ? saveContractInfo.getBillCode().length() > 3 ? saveContractInfo.getBillCode().substring(saveContractInfo.getBillCode().length() - 3) : saveContractInfo.getBillCode() :
                        saveDetailVo.getId().toString();
                saveDetailVo.setDetailCode(detailCode+"-"+saveDetailVo.getSortId());
                saveDetailVo.setSubContractSid(Integer.valueOf("1").equals(saveContractInfo.getSubContractFlag()) ? saveContractInfo.getSourceContractId():saveContractInfo.getSubContractParentSid());
                saveDetailVo.setSubContractId(Integer.valueOf("1").equals(saveContractInfo.getSubContractFlag()) ? saveContractInfo.getId().toString(): null != saveContractInfo.getContractId() ? saveContractInfo.getContractId().toString() : null);
                saveDetailVo.setSourceType(saveContractInfo.getSubContractFlag());
                if(null != detail.getDetailTax()) {
                    saveDetailVo.setDetailTax(detail.getDetailTax());
                } else {
                    saveDetailVo.setDetailTax(ComputeUtil.safeSub(saveDetailVo.getDetailTaxMny(), saveDetailVo.getDetailMny()));
                }
                saveDetailVo.setCostCodingName(detail.getCostCodingName());
                saveDetailVo.setCostCodingId(detail.getCostCodingId());
                //备注
                saveDetailVo.setContractId(saveContractInfo.getId());
                saveContractInfo.getDetailList().add(saveDetailVo);
            }
            if(!saveFlag) {
                continue;
            }
            if(CollectionUtils.isNotEmpty(saveContractInfo.getDetailList())) {
                saveDetails.addAll(saveContractInfo.getDetailList());
            }
            saveList.add(saveContractInfo);
            //若合同乙方联系人未开通协同账号，则给乙方联系人开通协同账号
            if(null != supplierManager && !PlanConstant.STRING_YES.equals(supplierManager.getCoordination())) {
                coorLinkerIdSet.add(supplierManager.getId());
            }
        }
        //设置主合同Id
        SubContractEntity tmpC = null;
        for(Iterator<SubContractEntity> it = saveList.iterator(); it.hasNext(); ) {
            tmpC = it.next();
            if(ZDSMaterialCommonEnums.主合同.equals(tmpC.getSubContractFlag())) {
                tmpC.setContractId(tmpC.getId());
            }
        }

        if(CollectionUtils.isNotEmpty(queryOrgIds)) {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findAllByIds(queryOrgIds);
            if(!orgResp.isSuccess()) {
                logger.error("根据组织Id-{}，获取组织信息失败！", JSONObject.toJSONString(queryOrgIds));
                throw new BusinessException("同步失败，获取组织信息失败");
            }
            Map<Long, OrgVO> orgIdMap = orgResp.getData().stream().collect(Collectors.toMap(OrgVO::getId, Function.identity()));

            for(SubContractEntity c : saveList) {
                if(orgIdMap.containsKey(c.getOrgId())) {
                    if(StringUtils.isBlank(c.getOrgCode())) {
                        c.setOrgCode(orgIdMap.get(c.getOrgId()).getCode());
                    }
                    if(StringUtils.isBlank(c.getParentOrgCode())) {
                        c.setParentOrgCode(orgIdMap.get(c.getParentOrgId()).getCode());
                    }
                }
            }
        }

        logger.info("本次保存分包合同主表数据-{}条", saveList.size());
        if(CollectionUtils.isNotEmpty(saveList)) {
            service.saveOrUpdateBatch(saveList, saveList.size(), false);
        }

        logger.info("本次保存分包合同主子数据-{}条", saveDetails.size());
        if(CollectionUtils.isNotEmpty(saveDetails)) {
            detailService.saveOrUpdateBatch(saveDetails, saveDetails.size(), false);
        }

        logger.info("本次待开通采购协同账号联系人数据：{}条", coorLinkerIdSet.size());
        if(CollectionUtils.isNotEmpty(coorLinkerIdSet)) {
            queueUtils.sendMq(LinkerAccCooListener.LINKER_ACC_QUEUE+"_"+profile,
                    JSONObject.toJSONString(new LinkerAccCooVO(LinkerAccCooVO.LINKER_TYPE_SUB, new ArrayList<>(coorLinkerIdSet))));
        }

        return saveList;
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubContractVO> saveOrUpdate(@RequestBody SubContractVO saveOrUpdateVO) {
    	SubContractEntity entity = BeanMapper.map(saveOrUpdateVO, SubContractEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SubContractVO vo = BeanMapper.map(entity, SubContractVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubContractVO> queryDetail(Long id) {
    	SubContractEntity entity = service.selectById(id);
    	SubContractVO vo = BeanMapper.map(entity, SubContractVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubContractVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubContractVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SubContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<SubContractEntity> page = service.queryPage(param,false);
        IPage<SubContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
        private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
            if(isMustSuc && !resp.isSuccess()) {
                throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
            }
            return resp.getData();
        }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubContractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubContract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> refSubContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));
            }
            if (_con.containsKey("auditWorkerFlag")) {
                param.getParams().put("", new Parameter(QueryParam.SQL,"audit_worker_id is null"));
            }
            if (_con.containsKey("subContractFlag")) {
                param.getParams().put("subContractFlag", new Parameter(QueryParam.EQ, _con.getInteger("subContractFlag")));
            }
            String excludeSourceIds = _con.getString("excludeSourceIds");
            if (StringUtils.isNotBlank(excludeSourceIds)) {
                param.getParams().put("id", new Parameter(QueryParam.NOT_IN, Lists.newArrayList(excludeSourceIds.split(","))));
            }
            if (_con.containsKey("supplierId")) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("supplierId"))));
            }
            if (_con.containsKey("auditWorkerId")) {
                param.getParams().put("auditWorkerId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("auditWorkerId"))));
            }
            if (_con.containsKey("compileId")) {
                param.getParams().put("compileId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("compileId"))));
            }
            if (_con.containsKey("status")) {
                param.getParams().put("is_official_seal", new Parameter(QueryParam.EQ, String.valueOf(_con.get("status"))));
            } else {
                param.getParams().put("is_official_seal", new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
            }
        } else {
            param.getParams().put("is_official_seal", new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("systemLastUpdateTime", QueryParam.DESC);
        IPage<SubContractEntity> page = service.queryPage(param,false);
        IPage<SubContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(CollectionUtils.isEmpty(page.getRecords())){
            return CommonResponse.success("查询数据为空！", pageData);
        }
        List<SubContractVO> contractVOS = BeanMapper.mapList(page.getRecords(), SubContractVO.class);
        Set<Long> orgIds = contractVOS.stream().map(SubContractVO::getParentOrgId).collect(Collectors.toSet());

        Set<Long> contractIds = contractVOS.stream().map(SubContractVO::getId).collect(Collectors.toSet());
        //获取合同履约人
        Map<Long, ContractManagerVO> contractManagerMap = contractManagerService.getByContractIds(contractIds, "2");

        //获取二级单位组织Id
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findAllByIds(new ArrayList<>(orgIds));
        if(!orgResp.isSuccess() || null == orgResp.getData()) {
            logger.error("根据组织id列表-{}查询组织信息失败, {}", JSONObject.toJSONString(orgIds), JSONObject.toJSONString(orgResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询组织信息失败！");
        }
        //Map<合同上级单位Id, 合同对应二级单位Id>
        Map<Long, Long> secondOrgIdMap = new HashMap<>();
        String[] tmpOrgIdArr = null;
        Long secOrgId = null;
        for(OrgVO org : orgResp.getData()) {
            tmpOrgIdArr = org.getInnerCode().split("\\|");
            secondOrgIdMap.put(org.getId(), tmpOrgIdArr.length > 2 ? Long.valueOf(tmpOrgIdArr[1]) : Long.valueOf(tmpOrgIdArr[tmpOrgIdArr.length-1]));
        }

        //查询发票审核人
        LambdaQueryWrapper<SubCheckerSettingEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(SubCheckerSettingEntity::getOrgId, secondOrgIdMap.values());
        List<SubCheckerSettingEntity> list = subCheckerSettingService.list(queryWrapper);
        //Map<合同对应二级单位Id, 审核人Id>
        Map<Long, String> checkIdsByOrgMap = new HashMap<>();
        //Map<合同对应二级单位Id, 审核人名称>
        Map<Long, String> checkNamesByOrgMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            List<SubCheckerSettingEntity> tmpList = null;
            Map<Long, List<SubCheckerSettingEntity>> checkMapByOrg = list.stream().collect(Collectors.groupingBy(SubCheckerSettingEntity::getOrgId, Collectors.toList()));
            for(Long orgId : checkMapByOrg.keySet()) {
                tmpList = checkMapByOrg.get(orgId);
                if(CollectionUtils.isNotEmpty(tmpList)) {
                    checkIdsByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeId().toString()).collect(Collectors.joining(",")));
                    checkNamesByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeName()).collect(Collectors.joining(",")));
                }
            }
        }

        logger.info("合同二级单位组织映射：{}", JSONObject.toJSONString(secondOrgIdMap, SerializerFeature.PrettyFormat));
        logger.info("发票审核人信息：{}", JSONObject.toJSONString(checkIdsByOrgMap, SerializerFeature.PrettyFormat));


        for(SubContractVO contractVO : contractVOS) {
            if(null != contractManagerMap.get(contractVO.getId()) && null != contractManagerMap.get(contractVO.getId()).getOperatorId()) {
                contractVO.setCheckIds(contractManagerMap.get(contractVO.getId()).getOperatorId().toString());
                contractVO.setCheckNames(contractManagerMap.get(contractVO.getId()).getOperatorName());
            } else if(secondOrgIdMap.containsKey(contractVO.getParentOrgId()) &&
                    checkIdsByOrgMap.containsKey(secondOrgIdMap.get(contractVO.getParentOrgId()))) {
                contractVO.setCheckIds(checkIdsByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
                contractVO.setCheckNames(checkNamesByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
            }
        }
        pageData.setRecords(contractVOS);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/refSubContractDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubContractDetailVO>> refSubContractDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {

        QueryParam param = new QueryParam();
        String contractId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("sub_contract_id", new Parameter(QueryParam.EQ,String.valueOf(_con.get("contractId"))));
            }
        }
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sort_id",QueryParam.DESC);
        IPage<SubContractDetailEntity> page = detailService.queryPage(param,false);
        // 查询分包费用本期前累计数据
        List<Long> infoIds = page.getRecords().stream().map(SubContractDetailEntity::getId).collect(Collectors.toList());
        Map<Long, SubFeeApplyDetailVO> applyDetailMap = applyDetailService.getApproveDetailMap(infoIds);

        IPage<SubContractDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty(page.getRecords())){
            List<SubContractDetailVO> subContractDetailVOS = BeanMapper.mapList(page.getRecords(), SubContractDetailVO.class);
            subContractDetailVOS.stream().forEach(subContractDetailVO -> {
                subContractDetailVO.setSourceTypeName((subContractDetailVO.getSourceType()==null||subContractDetailVO.getSourceType()==1)?"主合同":"附加合同");
                if(applyDetailMap.containsKey(subContractDetailVO.getId())){
                    SubFeeApplyDetailVO vo = applyDetailMap.get(subContractDetailVO.getId());
                    subContractDetailVO.setLastNum(vo.getLastNum());
                    subContractDetailVO.setSumNum(vo.getLastNum());
                    subContractDetailVO.setLastTaxMny(vo.getLastTaxMny());
                    subContractDetailVO.setSumTaxMny(vo.getSumTaxMny());
                }
            });
            pageData.setRecords(subContractDetailVOS);
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

     /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubContractBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> refSubContractBill(HttpServletRequest request) {
        String transData = StringEscapeUtils.unescapeJava(request.getParameter("transData"));
        logger.error("refSubContractBill condition " + transData);
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        Object condition = jsonObject.get("condition");
        String searchText = (String) jsonObject.get("searchText");
        Integer pageNumber = (Integer) jsonObject.get("pageNumber");
        Integer pageSize =  (Integer)jsonObject.get("pageSize");
        String searchObject =  (String)jsonObject.get("searchObject");
        String tenantId =  (String)jsonObject.get("tenantId");
        QueryParam param = new QueryParam();
        //根据 tenantId 查询对应供商id
        CommonResponse<SupplierVO> listCommonResponse = supplierApi.getByTenantId(Long.valueOf(tenantId));
        if(!listCommonResponse.isSuccess() || null == listCommonResponse.getData()){
            logger.error("根据分包商租户Id-{}查询分包商信息失败, 重试获取分包商信息", tenantId);

            SupplierVO supplierVO  =  service.getSubSupInfoByTenant(Long.valueOf(tenantId));
            if(null == supplierVO) {
                throw new BusinessException("查询分包商信息失败！");
            }
        } else {
            SupplierVO shareSupplierVO = listCommonResponse.getData();
            if (null != shareSupplierVO){
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, shareSupplierVO.getId()));
            }
        }
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(null != condition){
            /** 处理condition */
            JSONObject _con = (JSONObject) condition;
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("projectId"))));
            }
            if (_con.containsKey("supplierId")) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("supplierId"))));
            }
            if (_con.containsKey("compileId")) {
                param.getParams().put("compileId", new Parameter(QueryParam.EQ, String.valueOf(_con.get("compileId"))));
            }
            if (_con.containsKey("supplierManagerSupId")) {
                Long supplierManagerSupId = _con.getLong("supplierManagerSupId");
//                CommonResponse<LinkerVO> supUserIdAndTenant = subLinkerApi.getSupUserIdAndTenant(supplierManagerSupId, Long.valueOf(tenantId));
//                logger.error(JSONObject.toJSONString(supUserIdAndTenant));
//                if (supUserIdAndTenant.isSuccess() && null != supUserIdAndTenant.getData()) {
//                    param.getParams().put("partyContactId", new Parameter(QueryParam.EQ, supUserIdAndTenant.getData().getId()));
//                } else {
//                    logger.error("未查询到该分包联系人信息-{}", supplierManagerSupId);
//                    param.getParams().put("0", new Parameter(QueryParam.EQ, 1));
//                }

                List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, Long.valueOf(tenantId));
                if(CollectionUtils.isNotEmpty(linkerList)){
                    List<Long> ids = linkerList.stream().map(x->x.getId()).collect(Collectors.toList());

                    boolean isAdmin = false;
                    //当前联系人是否为管理员
                    List<LinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
                    if(CollectionUtils.isNotEmpty(curLinker)) {
                        LinkerVO linker = curLinker.get(0);
                        if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                            isAdmin = true;
                        }
                    }
                    if(!isAdmin) {
                        param.getParams().put("partyContactId", new Parameter(QueryParam.IN, ids));
                    }
                } else {
                    logger.error("未查询到该分包联系人信息-{}", supplierManagerSupId);
                    param.getParams().put("0", new Parameter(QueryParam.EQ, 1));
                }
            }
            if (_con.containsKey("contractTypes")) {
                param.getParams().put("contractType", new Parameter(QueryParam.IN, Lists.newArrayList(_con.getString("contractTypes").split(","))));
            }
            if (_con.containsKey("subContractFlags")) {
                param.getParams().put("subContractFlag", new Parameter(QueryParam.IN, Lists.newArrayList(_con.getString("subContractFlags").split(","))));
            }
            if (_con.containsKey("status")) {
                param.getParams().put("is_official_seal", new Parameter(QueryParam.EQ, String.valueOf(_con.get("status"))));
            } else {
                param.getParams().put("is_official_seal", new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
            }
        } else {
            param.getParams().put("is_official_seal", new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
        }
        param.getOrderMap().put("systemLastUpdateTime",QueryParam.DESC);
        IPage<SubContractEntity> page = service.queryPage(param,false);
        IPage<SubContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if(CollectionUtils.isEmpty(page.getRecords())){
            return CommonResponse.success("查询数据为空！", pageData);
        }
        List<SubContractVO> contractVOS = BeanMapper.mapList(page.getRecords(), SubContractVO.class);
        Set<Long> orgIds = contractVOS.stream().map(SubContractVO::getParentOrgId).collect(Collectors.toSet());
        //获取二级单位组织Id
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findAllByIds(new ArrayList<>(orgIds));
        if(!orgResp.isSuccess() || null == orgResp.getData()) {
            logger.error("根据组织id列表-{}查询组织信息失败, {}", JSONObject.toJSONString(orgIds), JSONObject.toJSONString(orgResp, SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询组织信息失败！");
        }

        Set<Long> contractIds = contractVOS.stream().map(SubContractVO::getId).collect(Collectors.toSet());
        //获取合同履约人
        Map<Long, ContractManagerVO> contractManagerMap = contractManagerService.getByContractIds(contractIds, "2");

        //Map<合同上级单位Id, 合同对应二级单位Id>
        Map<Long, Long> secondOrgIdMap = new HashMap<>();
        String[] tmpOrgIdArr = null;
        Long secOrgId = null;
        for(OrgVO org : orgResp.getData()) {
            tmpOrgIdArr = org.getInnerCode().split("\\|");
            secondOrgIdMap.put(org.getId(), tmpOrgIdArr.length > 2 ? Long.valueOf(tmpOrgIdArr[1]) : Long.valueOf(tmpOrgIdArr[tmpOrgIdArr.length-1]));
        }

        //查询发票审核人
        LambdaQueryWrapper<SubCheckerSettingEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(SubCheckerSettingEntity::getOrgId, secondOrgIdMap.values());
        List<SubCheckerSettingEntity> list = subCheckerSettingService.list(queryWrapper);
        //Map<合同对应二级单位Id, 审核人Id>
        Map<Long, String> checkIdsByOrgMap = new HashMap<>();
        //Map<合同对应二级单位Id, 审核人名称>
        Map<Long, String> checkNamesByOrgMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            List<SubCheckerSettingEntity> tmpList = null;
            Map<Long, List<SubCheckerSettingEntity>> checkMapByOrg = list.stream().collect(Collectors.groupingBy(SubCheckerSettingEntity::getOrgId, Collectors.toList()));
            for(Long orgId : checkMapByOrg.keySet()) {
                tmpList = checkMapByOrg.get(orgId);
                if(CollectionUtils.isNotEmpty(tmpList)) {
                    checkIdsByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeId().toString()).collect(Collectors.joining(",")));
                    checkNamesByOrgMap.put(orgId, tmpList.stream().map(item -> item.getEmployeeName()).collect(Collectors.joining(",")));
                }
            }
        }

        logger.info("合同二级单位组织映射：{}", JSONObject.toJSONString(secondOrgIdMap, SerializerFeature.PrettyFormat));
        logger.info("发票审核人信息：{}", JSONObject.toJSONString(checkIdsByOrgMap, SerializerFeature.PrettyFormat));

        for(SubContractVO contractVO : contractVOS) {
            if(null != contractManagerMap.get(contractVO.getId()) && null != contractManagerMap.get(contractVO.getId()).getOperatorId()) {
                contractVO.setCheckIds(contractManagerMap.get(contractVO.getId()).getOperatorId().toString());
                contractVO.setCheckNames(contractManagerMap.get(contractVO.getId()).getOperatorName());
            } else if(secondOrgIdMap.containsKey(contractVO.getParentOrgId()) &&
                    checkIdsByOrgMap.containsKey(secondOrgIdMap.get(contractVO.getParentOrgId()))) {
                contractVO.setCheckIds(checkIdsByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
                contractVO.setCheckNames(checkNamesByOrgMap.get(secondOrgIdMap.get(contractVO.getParentOrgId())));
            }
        }
        pageData.setRecords(contractVOS);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    @RequestMapping(value = "/querySubContractDetailBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SubContractDetailVO>> querySubContractDetailBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        String condition = (String) jsonObject.get("condition");
        String searchText = (String) jsonObject.get("searchText");
        Integer pageNumber = (Integer) jsonObject.get("pageNumber");
        Integer pageSize =  (Integer)jsonObject.get("pageSize");
        String searchObject =  (String)jsonObject.get("searchObject");
        QueryParam param = new QueryParam();

        String contractId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("sub_contract_id", new Parameter(QueryParam.EQ, String.valueOf(_con.get("contractId"))));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sort_id",QueryParam.DESC);
        List<SubContractDetailEntity> page = detailService.queryList(param,false);
        List<SubContractDetailVO> subContractDetailVOS = BeanMapper.mapList(page, SubContractDetailVO.class);
        return CommonResponse.success("查询参照数据成功！",subContractDetailVOS);
    }



    @RequestMapping(value = "/refSubContractDetailBill", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubContractDetailVO>> refSubContractDetailBill(HttpServletRequest request) {
        String transData = request.getParameter("transData");
        JSONObject jsonObject = JSONObject.parseObject(transData, JSONObject.class);
        String condition = jsonObject.getString("condition");
        String searchText = jsonObject.getString("searchText");
        Integer pageNumber = jsonObject.getInteger("pageNumber");
        Integer pageSize =  jsonObject.getInteger("pageSize");
        String searchObject =  jsonObject.getString("searchObject");
        QueryParam param = new QueryParam();

        String contractId = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("sub_contract_id", new Parameter(QueryParam.EQ, String.valueOf(_con.get("contractId"))));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sort_id",QueryParam.DESC);
        IPage<SubContractDetailEntity> page = detailService.queryPage(param,false);
        // 查询分包费用本期前累计数据
        List<Long> infoIds = page.getRecords().stream().map(SubContractDetailEntity::getId).collect(Collectors.toList());
        Map<Long, SubFeeApplyDetailVO> applyDetailMap = applyDetailService.getApproveDetailMap(infoIds);

        IPage<SubContractDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty(page.getRecords())){
            List<SubContractDetailVO> subContractDetailVOS = BeanMapper.mapList(page.getRecords(), SubContractDetailVO.class);
            subContractDetailVOS.stream().forEach(subContractDetailVO -> {
                subContractDetailVO.setSourceTypeName((subContractDetailVO.getSourceType()==null||subContractDetailVO.getSourceType()==1)?"主合同":"附加合同");
                if(applyDetailMap.containsKey(subContractDetailVO.getId())){
                    SubFeeApplyDetailVO vo = applyDetailMap.get(subContractDetailVO.getId());
                    subContractDetailVO.setLastNum(vo.getLastNum());
                    subContractDetailVO.setSumNum(vo.getLastNum());
                    subContractDetailVO.setLastTaxMny(vo.getLastTaxMny());
                    subContractDetailVO.setSumTaxMny(vo.getSumTaxMny());
                }
            });
            pageData.setRecords(subContractDetailVOS);
        }
        return CommonResponse.success("查询参照数据成功！",pageData);
    }
    @RequestMapping(value = "/excelExportDetail", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportDetail(@RequestBody QueryParam param, HttpServletResponse response) {
        JSONObject jsonObject = new JSONObject();
        String condition = null;
        if (param.getParams().containsKey("contractId")){
            String contractId = param.getParams().get("contractId").getValue().toString();
            jsonObject.put("contractId", contractId);
             condition = jsonObject.toString();
        }
        CommonResponse<IPage<SubContractDetailVO>> iPageCommonResponse = refSubContractDetailData(1, -1, condition, null, null);
        if (iPageCommonResponse.isSuccess()){
             Map<String, Object> beans = new HashMap<>();
            if (CollectionUtils.isNotEmpty(iPageCommonResponse.getData().getRecords())){
                List<SubContractDetailVO> subContractDetailVOS = iPageCommonResponse.getData().getRecords();
                subContractDetailVOS.stream().forEach(subContractDetailVO -> {
                    subContractDetailVO.setSourceTypeName(subContractDetailVO.getSourceType()==1?"主合同":"附加合同");
                });
                beans.put("records", subContractDetailVOS);
            }
            ExcelExport.getInstance().export("contract-detail.xlsx", beans, response);
        }
    }


    /**
     * 查询合同匹配签章状态的数量
     *
     * @param supplierTenantId 分包商供方租户I滴
     * @param supplierManagerSupId 分包联系人供方用户Id
     * @param status 签章状态 0未签 1已签
     * @return
     */
    @RequestMapping(value = "/tobeSignedNum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> tobeSignedNum(@RequestParam("supplierTenantId") Long supplierTenantId,
                                                 @RequestParam("supplierManagerSupId") Long supplierManagerSupId,
                                                 @RequestParam("status") String status) {
        QueryWrapper<SubContractEntity> queryWrapper = new QueryWrapper<>();

        //查询物资联系人信息
//        LinkerVO linker = getLlinkerInfo(supplierManagerSupId, supplierTenantId);
//        if(null == linker) {
//            return CommonResponse.error("查询失败，获取供应商联系人信息失败！");
//        }
//        queryWrapper.eq("supplier_id", linker.getSupplierId());
//        queryWrapper.and(q -> q.eq("party_contact_s_id", linker.getThirdSourceId()).or().eq("party_contact_id", linker.getId()));

        List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supplierTenantId);
        if(CollectionUtils.isEmpty(linkerList)){
            return CommonResponse.error("查询失败，获取供应商联系人信息失败！");
        }

        boolean isAdmin = false;
        //当前联系人是否为管理员
        List<LinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(curLinker)) {
            LinkerVO linker = curLinker.get(0);
            if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                isAdmin = true;
            }
        }

        if(!isAdmin) {
            queryWrapper.and(q -> {
                for(LinkerVO linker : linkerList) {
                    q.or(iq -> iq.eq("supplier_id", linker.getSupplierId()).
                            and(jq->jq.eq("party_contact_id", linker.getId()).or().
                                    eq("party_contact_s_id", linker.getThirdSourceId())));
                }
                return q;
            });
        } else {
            queryWrapper.eq("supplier_id", linkerList.get(0).getSupplierId());
        }
        queryWrapper.eq("is_official_seal", status);

        int count = service.count(queryWrapper);
        return CommonResponse.success("查询成功！", count);
    }

    /**
     * 分包商门户查询
     *
     * @param supplierManagerSupId
     * @param supTenant
     * @return
     */
    @RequestMapping(value = "/signAContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> signAContract(@RequestParam("supplierManagerSupId") Long supplierManagerSupId, @RequestParam("supTenant") Long supTenant) {
        JSONObject jsonObject = new JSONObject();

//        LinkerVO linker = getLlinkerInfo(supplierManagerSupId, supTenant);
//        jsonObject.put("performanceNum", null != linker ? service.performanceNum(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("finishSettleNum", null != linker ? service.finishSettleNum(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("settleNum", null != linker ? service.settleNum(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("thisYearContractMny", null != linker ? service.thisYearContractMny(linker.getId(), linker.getThirdSourceId()) : 0);
//        jsonObject.put("thisYearApplyMny", null != linker ? subFeeApplyService.thisYearApplyMny(linker.getId(), linker.getThirdSourceId()) : 0);

        List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supTenant);

        Long supplierId = null;
        //当前联系人是否为管理员
        List<LinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(curLinker)) {
            LinkerVO linker = curLinker.get(0);
            if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                supplierId = linker.getSupplierId();
            }
        }

        Integer performanceNum = 0;
        Integer finishSettleNum = 0;
        Integer settleNum = 0;
        BigDecimal thisYearContractMny = BigDecimal.ZERO;
        BigDecimal thisYearApplyMny = BigDecimal.ZERO;
        if(null != supplierId) {
            performanceNum = service.performanceNum(null, null, supplierId);
            finishSettleNum = service.finishSettleNum(null, null, supplierId);
            settleNum = service.settleNum(null, null, supplierId);
            thisYearContractMny = service.thisYearContractMny(null, null, supplierId);
            thisYearApplyMny = subFeeApplyService.thisYearApplyMny(null, null, supplierId);
        } else {
            for(LinkerVO linker : linkerList){
                performanceNum = performanceNum + service.performanceNum(linker.getId(), linker.getThirdSourceId(), supplierId);
                finishSettleNum = finishSettleNum + service.finishSettleNum(linker.getId(), linker.getThirdSourceId(), supplierId);
                settleNum = settleNum + service.settleNum(linker.getId(), linker.getThirdSourceId(), supplierId);
                thisYearContractMny = ComputeUtil.safeAdd(thisYearContractMny, service.thisYearContractMny(linker.getId(), linker.getThirdSourceId(), supplierId));
                thisYearApplyMny = ComputeUtil.safeAdd(thisYearApplyMny, subFeeApplyService.thisYearApplyMny(linker.getId(), linker.getThirdSourceId(), supplierId));
            }
        }

        jsonObject.put("performanceNum", performanceNum);
        jsonObject.put("finishSettleNum", finishSettleNum);
        jsonObject.put("settleNum", settleNum);
        jsonObject.put("thisYearContractMny", ComputeUtil.isNotEmpty(thisYearContractMny) ? thisYearContractMny : 0);
        jsonObject.put("thisYearApplyMny", ComputeUtil.isNotEmpty(thisYearApplyMny) ? thisYearApplyMny : 0);
        return CommonResponse.success("查询成功！", jsonObject);
    }

    private LinkerVO getLlinkerInfo(Long supplierManagerSupId, Long supTenant) {
        //查询乙方联系人信息
        CommonResponse<LinkerVO> linkerResp = subLinkerApi.getSupUserIdAndTenant(supplierManagerSupId, supTenant);
        if(!linkerResp.isSuccess() || null == linkerResp.getData()) {
            logger.error("根据分包联系人供方用户Id-{},供方租户Id-{}查询联系人信息失败,{}", supplierManagerSupId, supTenant, JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
            return null;
        }
        return linkerResp.getData();
    }

    /**
     * 包含被委托人
     * @param supplierManagerSupId
     * @param supTenant
     * @return
     */
    private List<LinkerVO> getLinkerListInfo(Long supplierManagerSupId, Long supTenant) {
        // 查询乙方联系人信息
        CommonResponse<List<LinkerVO>> linkerResp = subLinkerApi.getEntrustUserIdAndTenant(supplierManagerSupId, supTenant);
        if(!linkerResp.isSuccess() || null == linkerResp.getData()) {
            logger.error("根据分包联系人供方用户Id-{},供方租户Id-{}查询联系人信息失败,{}", supplierManagerSupId, supTenant,
                    JSONObject.toJSONString(linkerResp, SerializerFeature.PrettyFormat));
            return null;
        }
        return linkerResp.getData();
    }

    @RequestMapping(value = "/performanceContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubContractVO>> performanceContract(@RequestParam("supplierTenantId") Long supplierTenantId,
                                                                    @RequestParam("supplierManagerSupId") Long supplierManagerSupId,
                                                                    @RequestParam("pageNumber") Integer pageNumber,
                                                                    @RequestParam("pageSize") Integer pageSize,
                                                                    @RequestParam( value = "status" ,required=false, defaultValue = "1") Integer status,
                                                                    @RequestParam(required = false) String projectCode,
                                                                    @RequestParam(required = false) String projectName,
                                                                    @RequestParam(required = false) String projectManagerName,
                                                                    @RequestParam(required = false) String contractCreatorName,
                                                                    @RequestParam(required = false) String contractName) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        //查询物资联系人信息
        Long supplierId = null;
        String supplierLinkerSid = null;
        //查询物资联系人信息
//        if(null != supplierManagerSupId && null != supplierTenantId) {
//            LinkerVO linker = getLlinkerInfo(supplierManagerSupId, supplierTenantId);
//            if(null == linker) {
//                return CommonResponse.error("查询失败，获取供应商联系人信息失败！");
//            }
//            supplierId = linker.getSupplierId();
//            supplierLinkerSid = linker.getThirdSourceId();
//        }
        boolean isAdmin = false;
        if(null != supplierTenantId && null != supplierManagerSupId) {
            List<LinkerVO> linkerList = this.getLinkerListInfo(supplierManagerSupId, supplierTenantId);
            if(CollectionUtils.isEmpty(linkerList)) {
                return CommonResponse.error("查询失败，获取供应商联系人信息失败！");
            }
            supplierId = linkerList.get(0).getSupplierId();
            supplierLinkerSid = linkerList.stream().map(x->x.getThirdSourceId()).filter(Objects::nonNull).collect(Collectors.joining(","));

            //当前联系人是否为管理员
            List<LinkerVO> curLinker = linkerList.stream().filter(item -> null != item.getSupUserId() && supplierManagerSupId.equals(item.getSupUserId())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(curLinker)) {
                LinkerVO linker = curLinker.get(0);
                if(null != linker.getTypeId() && !Integer.valueOf("2").equals(linker.getTypeId())) {
                    isAdmin = true;
                }
            }
        }

        if(null == supplierId && null != supplierTenantId) {
            //根据 tenantId 查询对应供商id
            CommonResponse<SupplierVO> supplierResp = supplierApi.getByTenantId(Long.valueOf(supplierTenantId));
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                logger.error("根据供应商租户Id-{}获取供应商信息失败:{}！", supplierTenantId, JSONObject.toJSONString(supplierResp,
                        SerializerFeature.PrettyFormat));
                return CommonResponse.error("查询失败，获取供应商信息失败！");
            }
            supplierId = supplierResp.getData().getId();
        }

        if(null == supplierId && StringUtils.isBlank(supplierLinkerSid)) {
            return CommonResponse.error("查询失败，未获取到供应商或联系人信息");
        }
        if (null != supplierId) {
            queryParam.getParams().put("supplier_id",new Parameter(QueryParam.EQ, supplierId));
        }
        if(!isAdmin) {
            if(StringUtils.isNotBlank(supplierLinkerSid)) {
//            queryParam.getParams().put("party_contact_s_id",new Parameter(QueryParam.EQ, supplierLinkerSid));
                queryParam.getParams().put("party_contact_s_id",new Parameter(QueryParam.IN, supplierLinkerSid));
            }
        }

        if(null!=status){
            queryParam.getParams().put("is_official_seal",new Parameter(QueryParam.EQ, status));
        }
        if(StringUtils.isNotBlank(projectCode)) {
            queryParam.getParams().put("projectCode",new Parameter(QueryParam.LIKE, projectCode));
        }
        if(StringUtils.isNotBlank(projectName)) {
            queryParam.getParams().put("projectName",new Parameter(QueryParam.LIKE, projectName));
        }
        if(StringUtils.isNotBlank(projectManagerName)) {
            queryParam.getParams().put("projectManagementName",new Parameter(QueryParam.LIKE, projectManagerName));
        }
        if(StringUtils.isNotBlank(contractCreatorName)) {
            queryParam.getParams().put("compileName",new Parameter(QueryParam.LIKE, contractCreatorName));
        }
        if(StringUtils.isNotBlank(contractName)) {
            queryParam.getParams().put("contractName",new Parameter(QueryParam.LIKE, contractName));
        }

//        queryParam.getParams().put("party_sup_contact_id",new Parameter(QueryParam.EQ, supplierManagerSupId));
        queryParam.getOrderMap().put("system_last_update_time",QueryParam.DESC);
        IPage<SubContractEntity> page = service.queryPage(queryParam);
        IPage<SubContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubContractVO.class));
        return CommonResponse.success("查询成功！", pageData);
    }


    /**
     * 同步供应商下的合同
     *
     * @param supTenant 供应商供方租户Id
     * @return
     */
    @PostMapping(value = "syncSupplierContracts")
    public CommonResponse<String> syncSupplierContracts(@RequestBody Long supTenant) {
        //根据 tenantId 查询对应供商id
        CommonResponse<SupplierVO> supplierResp = supplierApi.getByTenantId(Long.valueOf(supTenant));
        if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
            logger.error("根据分包商租户Id-{}获取分包商信息失败:{}！", supTenant, JSONObject.toJSONString(supplierResp,
                    SerializerFeature.PrettyFormat));
            return CommonResponse.error("查询失败，获取分包商信息失败！");
        }
        return syncErpContracts(null, null, false, true, supplierResp.getData().getThirdSourceId(), null);
    }

}
