package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IPurchaseAnalysisService;
import com.ejianc.business.zdsmaterial.material.vo.OrderQueryVo;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目采购分析
 *
 * @author ljl
 */
@Controller
@RequestMapping("purchaseAnalysisNew")
public class PurchaseAnalysisNewController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDisposeDetailService disposeDetailService;
    @Autowired
    private IControlPlanService controlPlanService;
    @Autowired
    private IPurchaseAnalysisService service;
    @Autowired
    private IDisposeService disposeService;
    @Autowired
    private IStoreManageApi storeManageApi;

    @GetMapping(value = "/querySurPlusList")
    @ResponseBody
    public CommonResponse<List<SurplusVO>> querySurPlusList(@RequestParam Long projectId,
                                                       @RequestParam(required = false) Long materialId,
                                                       @RequestParam(required = false) String categoryGroup) {
        QueryParam surplusQuery = new QueryParam();
        if(null != materialId) {
            surplusQuery.getParams().put("materialId", new Parameter(QueryParam.EQ, materialId));
        }

        if(StringUtils.isNotBlank(categoryGroup)) {
            List<String> categoryCode = new ArrayList<>();
            Map<String, String> tmpMap = JSONObject.parseObject(categoryGroup, Map.class);
            Map<String, List<String>> typeNameGroupCodeMap = new HashMap<>();
            List<String> codes = null;
            for(String typeName : tmpMap.keySet()) {
                codes= new ArrayList<>(Arrays.asList(tmpMap.get(typeName).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds =  categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = categoryService.getAllLeafByPids(parentCategoryIds, 1);
            List<Long> childCategoryIds = childCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            surplusQuery.getParams().put("materialCategoryId", new Parameter(QueryParam.IN, childCategoryIds));
        }

        surplusQuery.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        surplusQuery.getParams().put("storeType", new Parameter(QueryParam.EQ, PlanConstant.ATTR_FLAG_MAIN));
        CommonResponse<List<SurplusVO>> surplusResponse = storeManageApi.queryOrgSurplusBatch(surplusQuery);

        //过滤出库存余量大于0 或者限制数量大于0的
        List<SurplusVO> surList = surplusResponse.getData().stream().filter(item -> {
            if(null != item.getSurplusNum() && item.getSurplusNum().compareTo(BigDecimal.ZERO) > 0) {
                return true;
            }
            if(null != item.getIdleNum() && item.getIdleNum().compareTo(BigDecimal.ZERO) > 0) {
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if(surplusResponse.isSuccess()) {
            return CommonResponse.success("查询失败！", surList);
        } else {
            return CommonResponse.error("查询失败！");
        }
    }

    @GetMapping(value = "/queryMaterialList")
    @ResponseBody
    public CommonResponse<List<PurchaseAnalysisVo>> queryMaterialList(@RequestParam(required = false) Map<String, Object> params) {
        List<Long> childCategoryIds = null;
        Map<String, PurchaseAnalysisVo> vosByCategoryCode = new HashMap<>();
        Map<String, String> codeNameMap = new HashMap<>();
        Map<Long, String> categoryCodeMap = new HashMap<>();
        PurchaseAnalysisVo tmp = null;
        String groupType = null != params.get("groupType") ? params.get("groupType").toString() : null;

        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        params.put("todayStr", sdf.format(new Date()));

        Long projectId = null;
        if (params.containsKey("projectId")){
            projectId = params.get("projectId") == null ? null : Long.valueOf(params.get("projectId").toString());
        }
        List<Long> orgIds = null;
        //查询组织下直属子组织
        Map<Long, OrgVO> belongOrgMap = new HashMap<>();
        //项目部与查询组织下直属子组织对应关系
        Map<Long, Long> orgBelongMap = new HashMap<>();
        if(params.containsKey("orgType") && params.containsKey("orgId")) {
            if(!OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(params.get("orgType").toString()))) {
                CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                        Arrays.asList(new Integer[]{1,2,3,5}),null, Long.valueOf(params.get("orgId").toString()));
                if(!orgResp.isSuccess()) {
                    logger.error("根据组织id-{}查询本下项目部信息失败", params.get("orgId"), JSONObject.toJSONString(orgResp));
                    return CommonResponse.error("查询组织信息失败！");
                }
                if(CollectionUtils.isNotEmpty(orgResp.getData())) {
                    orgIds = new ArrayList<>();
                    for(OrgVO org : orgResp.getData()) {
                        if(!"1".equals(params.get("orgType")) && Long.valueOf(params.get("orgId").toString()).equals(org.getParentId())) {
                            belongOrgMap.put(org.getId(), org);
                        }
                        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(org.getOrgType()) && !orgIds.contains(org.getId())) {
                            orgIds.add(org.getId());
                            if("1".equals(params.get("orgType"))) {
                                belongOrgMap.put(org.getId(), org);
                                orgBelongMap.put(org.getId(), org.getId());
                            } else {
                                orgBelongMap.put(org.getId(), Long.valueOf(org.getInnerCode()
                                        .substring(org.getInnerCode().indexOf(params.get("orgId").toString())+(params.get("orgId").toString().length()+1)).split("\\|")[0]));
                            }
                        }
                    }
                    params.put("orgIds", orgIds);
                } else {
                    return CommonResponse.success("查询成功！", new ArrayList<>());
                }
            } else {
                CommonResponse<OrgVO> orgResp = orgApi.getOneById(Long.valueOf(params.get("orgId").toString()));
                if(!orgResp.isSuccess()) {
                    logger.error("根据组织id-{}查询信息失败", params.get("orgId"), JSONObject.toJSONString(orgResp));
                    return CommonResponse.error("查询组织信息失败！");
                }
                orgBelongMap.put(orgResp.getData().getId(), orgResp.getData().getId());
                belongOrgMap.put(orgResp.getData().getId(), orgResp.getData());
                params.put("orgIds", Arrays.asList(new Long[]{Long.valueOf(params.get("orgId").toString())}));
            }
            params.remove("orgType");
            params.remove("orgId");
        }

        if(null != params.get("categoryGroup") || null != params.get("queryCategoryGroup")) {

//            Map<分类名称，List<分类编码>>
            List<String> categoryCode = new ArrayList<>();
            Map<String, String> tmpMap = JSONObject.parseObject(null != params.get("categoryGroup") ? params.get("categoryGroup").toString()
                    : params.get("queryCategoryGroup").toString(), Map.class);
            Map<String, List<String>> typeNameGroupCodeMap = new HashMap<>();
            List<String> codes = null;
            for(String typeName : tmpMap.keySet()) {
                codes= new ArrayList<>(Arrays.asList(tmpMap.get(typeName).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds =  categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());

            if(null != params.get("categoryGroup")) {
                categoyCk:for(MaterialCategoryEntity category : childCategorys) {
                    categoryCodeMap.put(category.getId(), category.getCode());
                    typeCk:for(String typeName : typeNameGroupCodeMap.keySet()) {
                        if(null == vosByCategoryCode.get(typeName)) {
                            if("org".equals(groupType)) {
                                for(Long orgId : belongOrgMap.keySet()) {
                                    tmp = new PurchaseAnalysisVo();
                                    tmp.setMaterialTypeName(typeName);
                                    tmp.setValidFlag(false);
                                    vosByCategoryCode.put(typeName+"-"+orgId.toString(), tmp);
                                }
                            } else {
                                tmp = new PurchaseAnalysisVo();
                                tmp.setValidFlag(true);
                                tmp.setMaterialTypeName(typeName);
                                vosByCategoryCode.put(typeName, tmp);
                            }
                        }
                        for(String parentCategoryCode : typeNameGroupCodeMap.get(typeName)) {
                            if(category.getCode().contains(parentCategoryCode)) {
                                codeNameMap.put(category.getCode(), typeName);
                                break typeCk;
                            }
                        }
                    }
                }
            }

            params.put("categoryIds", childCategoryIds);
        }

        List<PurchaseAnalysisVo> voList = new ArrayList<>();
        List<PurchaseAnalysisVo> list = service.getList(params);

        OrgVO belongOrg = null;
        for (PurchaseAnalysisVo vo :list){
            belongOrg = belongOrgMap.get(orgBelongMap.get(vo.getOrgId()));
            if(null != belongOrg) {
                vo.setBelongOrgCode(belongOrg.getCode());
                vo.setBelongOrgId(belongOrg.getId());
                vo.setBelongOrgName(belongOrg.getName());
                vo.setBelongOrgType(belongOrg.getOrgType());
            } else {
                logger.error("无匹配的组织id-{}信息", orgBelongMap.get(vo.getOrgId()));
            }

            if(null == vo.getOutMny()) {
                vo.setOutMny(BigDecimal.ZERO);
            }
            if(null == vo.getInventoryMny()) {
                vo.setInventoryMny(BigDecimal.ZERO);
            }
            if(null == vo.getEntryMny()) {
                vo.setEntryMny(BigDecimal.ZERO);
            }
            vo.setPurchaseRate(ComputeUtil.bigDecimalPercent(ComputeUtil.safeAdd(vo.getOrderNum(), vo.getHandAcceptNum()),vo.getNum(),2));
            vo.setOutRate(ComputeUtil.bigDecimalPercent(vo.getAlreadyOutNum(),vo.getAlreadyEntryNum(),2));


            if(!codeNameMap.isEmpty()) {
                if("org".equals(groupType)) {
                    tmp = vosByCategoryCode.get(codeNameMap.get(vo.getMaterialTypeCode())+"-"+vo.getBelongOrgId());
                    if(null == tmp) {
                        continue;
                    }
                    if(null == tmp.getMaterialId()) {
                        tmp.setMaterialId(vo.getMaterialId());
                        tmp.setMaterialCode(vo.getMaterialCode());
                        tmp.setMaterialName(vo.getMaterialName());
                        tmp.setMaterialTypeCode(vo.getMaterialTypeCode());
                        tmp.setMaterialTypeName(vo.getMaterialTypeName());
                        tmp.setMaterialTypeId(vo.getMaterialTypeId());
                        tmp.setPropertyValue(vo.getPropertyValue());
                    }
                } else {
                    tmp = vosByCategoryCode.get(codeNameMap.get(vo.getMaterialTypeCode()));
                }
                if(null == tmp) {
                    continue;
                }
                tmp.setValidFlag(true);
                if(null == tmp.getBelongOrgId() && null != vo.getBelongOrgId()) {
                    tmp.setBelongOrgType(vo.getBelongOrgType());
                    tmp.setBelongOrgName(vo.getBelongOrgName());
                    tmp.setBelongOrgId(vo.getBelongOrgId());
                    tmp.setBelongOrgCode(vo.getBelongOrgCode());
                }
                if(null == tmp.getOrgId() && null != vo.getOrgId()) {
                    tmp.setOrgCode(vo.getOrgCode());
                    tmp.setOrgId(vo.getOrgId());
                    tmp.setOrgName(vo.getOrgName());
                    tmp.setParentOrgId(vo.getParentOrgId());
                    if(OrgVO.ORG_TYPE_DEPARTMENT.equals(vo.getBelongOrgType())) {
                        tmp.setProjectId(vo.getProjectId());
                        tmp.setProjectName(vo.getProjectName());
                        tmp.setProjectCode(vo.getProjectCode());
                    }
                }
                if(codeNameMap.containsKey(tmp.getMaterialTypeCode())) {
                    tmp.setMaterialTypeName(codeNameMap.get(tmp.getMaterialTypeCode()));
                }
                tmp.setSumNum(ComputeUtil.safeAdd(tmp.getSumNum(), vo.getSumNum()));
                tmp.setNum(ComputeUtil.safeAdd(tmp.getNum(), vo.getNum()));
                tmp.setPlanNum(ComputeUtil.safeAdd(tmp.getPlanNum(), vo.getPlanNum()));
                tmp.setOrderNum(ComputeUtil.safeAdd(tmp.getOrderNum(), vo.getOrderNum()));
                tmp.setDeliveryNum(ComputeUtil.safeAdd(tmp.getDeliveryNum(), vo.getDeliveryNum()));
                tmp.setAlreadyEntryNum(ComputeUtil.safeAdd(tmp.getAlreadyEntryNum(), vo.getAlreadyEntryNum()));
                tmp.setAlreadyOutNum(ComputeUtil.safeAdd(tmp.getAlreadyOutNum(), vo.getAlreadyOutNum()));
                tmp.setInventoryNum(ComputeUtil.safeAdd(tmp.getInventoryNum(), vo.getInventoryNum()));
                tmp.setUnarchivedQuantityNum(ComputeUtil.safeAdd(tmp.getUnarchivedQuantityNum(), vo.getUnarchivedQuantityNum()));
                tmp.setChangeNum(ComputeUtil.safeAdd(tmp.getChangeNum(), vo.getChangeNum()));
                tmp.setExcessNum(ComputeUtil.safeAdd(tmp.getExcessNum(), vo.getExcessNum()));
                tmp.setChangeAmount(ComputeUtil.safeAdd(tmp.getChangeAmount(), vo.getChangeAmount()));
                tmp.setExcessAmount(ComputeUtil.safeAdd(tmp.getExcessAmount(), vo.getExcessAmount()));
                tmp.setEntryMny(ComputeUtil.safeAdd(tmp.getEntryMny(), vo.getEntryMny()));
                tmp.setOutMny(ComputeUtil.safeAdd(tmp.getOutMny(), vo.getOutMny()));
                tmp.setInventoryMny(ComputeUtil.safeAdd(tmp.getInventoryMny(), vo.getInventoryMny()));
                tmp.setOutRate(ComputeUtil.bigDecimalPercent(tmp.getAlreadyOutNum(),tmp.getAlreadyEntryNum(),2));
                tmp.setPurchaseRate(ComputeUtil.bigDecimalPercent(ComputeUtil.safeAdd(tmp.getOrderNum(), tmp.getHandAcceptNum()),tmp.getNum(),2));
                if("org".equals(groupType)) {
                    vosByCategoryCode.put(codeNameMap.get(vo.getMaterialTypeCode())+"-"+vo.getBelongOrgId(), tmp);
                } else {
                    vosByCategoryCode.put(codeNameMap.get(vo.getMaterialTypeCode()), tmp);
                }
            }

            voList.add(vo);
        }
        if (CollectionUtils.isNotEmpty(voList)){
            if(codeNameMap.isEmpty()) {
                voList = voList.stream().filter(item -> !Boolean.FALSE.equals(item.getValidFlag())).sorted(Comparator.comparing(PurchaseAnalysisVo::getPurchaseRate, Comparator.nullsLast(BigDecimal::compareTo))).collect(Collectors.toList());
                return CommonResponse.success("查询成功！", voList);
            }

            return CommonResponse.success("查询成功！", new ArrayList<>(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
        }

        if(codeNameMap.isEmpty()) {
            return CommonResponse.success("查询成功！", voList);
        } else {
            return CommonResponse.success("查询成功！", new ArrayList<>(vosByCategoryCode.values().stream().filter(PurchaseAnalysisVo::getValidFlag).collect(Collectors.toList())));
        }
    }

    @RequestMapping(value = "/getPurchaseMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getPurchaseMny(@RequestParam(required = false) Long projectId,
                                                     @RequestParam(required = false) Long orgId,
                                                     @RequestParam(required = false) Integer orgType,
                                                     @RequestParam(required = false) String categoryGroup) {
        JSONObject json = new JSONObject();
        Map<String, Object> params = new HashMap<>();
        List<Long> orgIds = null;
        if(null == projectId && null == orgId) {
            return CommonResponse.error("查询失败，项目信息、组织信息不能同时为空");
        }
        if(null != projectId) {
            params.put("projectId",projectId);
        }
        if(null != orgId) {
            if(!OrgVO.ORG_TYPE_DEPARTMENT.equals(orgType)) {
                CommonResponse<List<OrgVO>> orgResp = orgApi.findOrgByTypesAndOrgId(InvocationInfoProxy.getTenantid(),
                        Arrays.asList(new Integer[]{OrgVO.ORG_TYPE_DEPARTMENT}),null, orgId);
                if(!orgResp.isSuccess()) {
                    logger.error("根据组织id-{}查询本下项目部信息失败", orgId, JSONObject.toJSONString(orgResp));
                    return CommonResponse.error("查询组织信息失败！");
                }
                if(CollectionUtils.isNotEmpty(orgResp.getData())) {
                    orgIds= new ArrayList<>(orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toSet()));
                    params.put("orgIds", orgIds);
                } else {
                    json.put("entryMny",0);
                    json.put("outMny",0);
                    json.put("allInMny",0);
                    json.put("allOutMny",0);
                    json.put("surplusMny", 0);
                    json.put("disposeMny", 0);
                    return CommonResponse.success("查询成功！", json);
                }

                //查询组织下 有总控计划的项目
                List<ControlPlanEntity> controlPlanList =controlPlanService.getAllByOrgId(orgIds);

                if(CollectionUtils.isEmpty(controlPlanList)) {
                    json.put("entryMny",0);
                    json.put("outMny",0);
                    json.put("allInMny",0);
                    json.put("allOutMny",0);
                    json.put("surplusMny", 0);
                    json.put("disposeMny", 0);
                    return CommonResponse.success("查询成功！", json);
                } else {
                    orgIds = new ArrayList<>(controlPlanList.stream().map(ControlPlanEntity::getOrgId).collect(Collectors.toSet()));
                    params.put("orgIds", orgIds);
                }
            } else {
                params.put("orgIds", Arrays.asList(new Long[]{orgId}));
            }
            params.remove("orgType");
            params.remove("orgId");
        }


        List<Long> childCategoryIds = null;
        if(StringUtils.isNotBlank(categoryGroup)) {
            List<String> categoryCode = new ArrayList<>();
            Map<String, String> tmpMap = JSONObject.parseObject(categoryGroup, Map.class);
            Map<String, List<String>> typeNameGroupCodeMap = new HashMap<>();
            List<String> codes = null;
            for(String typeName : tmpMap.keySet()) {
                codes= new ArrayList<>(Arrays.asList(tmpMap.get(typeName).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds =  categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = categoryService.getAllLeafByPids(parentCategoryIds, 1);
            childCategoryIds = childCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }
        JSONObject purchaseMny = service.getPurchaseMny(params);

        if(null == purchaseMny) {
            purchaseMny = new JSONObject();
        }
        if(null == purchaseMny.get("entryMny")) {
            purchaseMny.put("entryMny", BigDecimal.ZERO);
        }
        if(null == purchaseMny.get("outMny")) {
            purchaseMny.put("outMny", BigDecimal.ZERO);
        }
        if(null == purchaseMny.get("allInTaxMny")) {
            purchaseMny.put("allInTaxMny", BigDecimal.ZERO);
        }
        if(null == purchaseMny.get("allOutTaxMny")) {
            purchaseMny.put("allOutTaxMny", BigDecimal.ZERO);
        }

        QueryWrapper<DisposeEntity> queryWrapper = new QueryWrapper<>();
        if(null != projectId) {
            queryWrapper.eq("project_id",projectId);
        }
        if(null != orgIds) {
            queryWrapper.in("org_id", orgIds);
        }
//        if(CollectionUtils.isNotEmpty(childCategoryIds)) {
//            List<Long> disposeIds = disposeDetailService.getDispostIdsByCategoryIds(childCategoryIds);
//            if(CollectionUtils.isNotEmpty(disposeIds)) {
//                queryWrapper.in("id", disposeIds);
//            } else {
//                queryWrapper.eq("id", -999L);
//            }
//        }
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<DisposeEntity> list = disposeService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            BigDecimal  disposeMny =list.stream().map(item -> null != item.getRecMny() ? item.getRecMny() : BigDecimal.ZERO).reduce(BigDecimal.ZERO,ComputeUtil::safeAdd);
            purchaseMny.put("disposeMny",disposeMny);
        }else {
            purchaseMny.put("disposeMny",0);

        }

        return CommonResponse.success("查询详情数据成功！",purchaseMny);
    }



    @GetMapping(value = "/queryOrderList")
    @ResponseBody
    public CommonResponse<List<OrderQueryVo>> queryOrderList(@RequestParam(required = false) Map<String, Object> params) {
        if(null != params.get("categoryGroup")) {
            List<String> categoryCode = new ArrayList<>();
            Map<String, String> tmpMap = JSONObject.parseObject(params.get("categoryGroup").toString(), Map.class);
            Map<String, List<String>> typeNameGroupCodeMap = new HashMap<>();
            List<String> codes = null;
            for(String typeName : tmpMap.keySet()) {
                codes= new ArrayList<>(Arrays.asList(tmpMap.get(typeName).split(",")));
                typeNameGroupCodeMap.put(typeName, codes);
                categoryCode.addAll(codes);
            }
            List<MaterialCategoryEntity> categorys = categoryService.queryByCodes(categoryCode);
            List<Long> parentCategoryIds =  categorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            List<MaterialCategoryEntity> childCategorys = categoryService.getAllLeafByPids(parentCategoryIds, 1);
            List<Long> childCategoryIds = childCategorys.stream().map(MaterialCategoryEntity::getId).collect(Collectors.toList());
            params.put("categoryIds", childCategoryIds);
        }

        List<OrderQueryVo> list = orderDetailService.orderList(params);
        return CommonResponse.success("查询成功！", list);
    }
}
