package com.ejianc.business.zdsmaterial.plan.control.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumEntity;
import com.ejianc.business.zdsmaterial.plan.control.mapper.ControlPlanMapper;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanSumService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanDetailVO;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资总控计划
 *
 * @author generator
 *
 */
@Service("controlPlanService")
public class ControlPlanServiceImpl extends BaseServiceImpl<ControlPlanMapper, ControlPlanEntity> implements IControlPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZDS_MATERIAL_CONTROL_PLAN";//此处需要根据实际修改

    private static final String CHANGE_BILL_CODE = "ZDS_MATERIAL_CONTROL_PLAN_CHANGE";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IControlPlanDetailService detailService;

    @Autowired
    private IControlPlanSumService sumService;

    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IMaterialConjectureService materialConjectureService;

    @Override
    public ControlPlanVO saveOrUpdate(ControlPlanVO saveOrUpdateVO) {
        if (null == saveOrUpdateVO.getExeOrgId()) {
            CommonResponse<OrgVO> commonResponse = orgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (commonResponse.isSuccess() && null != commonResponse.getData()) {
                String[] split = commonResponse.getData().getInnerCode().split("\\|");
                Long exeOrgId = split.length > 1 ? Long.valueOf(split[1]) : null;
                if (null != exeOrgId) {
                    OrgVO orgVO = orgApi.getOneById(exeOrgId).getData();
                    saveOrUpdateVO.setExeOrgId(exeOrgId);
                    saveOrUpdateVO.setExeOrgCode(orgVO.getCode());
                    saveOrUpdateVO.setExeOrgName(orgVO.getName());
                }
            }
        }
        List<ControlPlanDetailVO> detailList = saveOrUpdateVO.getDetailList();
        // 赋值二级分类主键
        this.dealParentTypeId(detailList);

        if(PlanConstant.BILL_TYPE_NEW.equals(saveOrUpdateVO.getBillType())){
            // 计划编制时校验二级分类不允许重复
            this.validateParentTypeId(saveOrUpdateVO, false);
        } else {
            // 校验变更单不存在非生效态
            this.validateChange(saveOrUpdateVO);
        }
//         新增行校验编制/变更下物料属性不能重复，保证新增行物料唯一，否则只能走变更
        this.validateSame(detailList, saveOrUpdateVO.getProjectId());

        ControlPlanEntity entity = BeanMapper.map(saveOrUpdateVO, ControlPlanEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            String ruleCode = BILL_CODE;
            if(PlanConstant.BILL_TYPE_CHANGE.equals(saveOrUpdateVO.getBillType())) {
                ruleCode = CHANGE_BILL_CODE;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(ruleCode, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setCreateUserName(sessionManager.getUserContext().getUserName());
        }
        // 汇总材料分类
        String materialTypeNames = detailList.stream().filter(x->!"del".equals(x.getRowState()) && StringUtils.isNotEmpty(
                x.getMaterialTypeName())).map(x->x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        if(entity.getCreateUserId() == null){
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
        }

        //处理物资id为空 物资分类编码为空
        entity.getDetailList().stream().filter(item -> null == item.getMaterialId()).forEach(item -> item.setMaterialId(IdWorker.getId()));
        List<ControlPlanDetailEntity> emptyTypeCodeList = entity.getDetailList().stream().filter(item -> StringUtils.isBlank(item.getMaterialTypeCode())).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(emptyTypeCodeList)) {
            List<Long> materialTypeIds = new ArrayList<>(emptyTypeCodeList.stream().map(ControlPlanDetailEntity::getMaterialTypeId).collect(Collectors.toSet()));
            if(CollectionUtils.isNotEmpty(materialTypeIds)) {
                Map<Long, String> categoryCodeMap = new HashMap<>();
                List<MaterialCategoryVO> materialCategorys = materialCategoryService.getAllByIds(materialTypeIds);
                categoryCodeMap.putAll(materialCategorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getCode())));

                emptyTypeCodeList.stream().filter(item -> categoryCodeMap.containsKey(item.getMaterialTypeId()))
                        .forEach(item -> item.setMaterialTypeCode(categoryCodeMap.get(item.getMaterialTypeId())));
            }
        }

        super.saveOrUpdate(entity, false);
        // 变更回写汇总
        if(PlanConstant.BILL_TYPE_CHANGE.equals(entity.getBillType())){
            QueryParam param = new QueryParam();
            param.getParams().put("projectId", new Parameter(QueryParam.EQ, entity.getProjectId()));
            ControlPlanSumEntity sum = sumService.queryList(param).get(0);
            sum.setChangeStatus(PlanConstant.CHANGE_ING);// 变更中
            sum.setChangeId(entity.getId());
            sum.setChangeTime(entity.getCreateTime());
            sumService.saveOrUpdate(sum);
        }

        //
        if(StringUtils.isNotBlank(entity.getCurIdentifyId())){
            materialConjectureService.fillBillInfo(Collections.singleton(entity.getCurIdentifyId()), entity.getId(), entity.getBillCode(), PlanConstant.NEW_BILL_TYPE);
        }

        return BeanMapper.map(entity, ControlPlanVO.class);
    }

    @Override
    public boolean deleteByIds(List<Long> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return true;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<ControlPlanEntity> list = super.queryList(queryParam);

        List<Long> projectIds = list.stream().map(ControlPlanEntity::getProjectId).distinct().collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.IN, projectIds));
        List<ControlPlanSumEntity> sumList = sumService.queryList(param);
        Map<Long, ControlPlanSumEntity> sumMap = sumList.stream().collect(Collectors.toMap(ControlPlanSumEntity::getProjectId, x->x));

        param.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_CHANGE));
        param.getParams().put("id", new Parameter(QueryParam.NOT_IN, ids));
        List<ControlPlanEntity> lastList = super.queryList(param);
        Map<Long, ControlPlanEntity> lastMap = lastList.stream().collect(Collectors.toMap(x->x.getProjectId(), x->x,
                (v1, v2)->{return v1.getCreateTime().getTime() > v2.getCreateTime().getTime() ? v1 : v2;}));
        List<ControlPlanSumEntity> saveList = new ArrayList<>();
        // 变更回写汇总
        list.stream().filter(x->PlanConstant.BILL_TYPE_CHANGE.equals(x.getBillType())).forEach(entity->{
            ControlPlanSumEntity sum = sumMap.get(entity.getProjectId());
            ControlPlanEntity last = new ControlPlanEntity();
            if(lastMap.containsKey(entity.getProjectId())){
                last = lastMap.get(entity.getProjectId());
            }
            sum.setChangeStatus(last.getId() != null ? PlanConstant.CHANGE_OVER : PlanConstant.CHANGE_NO);// 已变更/变更中
            sum.setChangeId(last.getId());
            sum.setChangeTime(last.getCreateTime());
            saveList.add(sum);
        });
        if(CollectionUtils.isNotEmpty(saveList)){
            sumService.saveOrUpdateBatch(saveList);
        }
        super.removeByIds(ids,true);
        return true;
    }

    /**
     * 新增行校验编制/变更下物料属性不能重复，保证新增行物料唯一，否则只能走变更
     * @param detailList
     */
    private void validateSame(List<ControlPlanDetailVO> detailList, Long projectId) {
        List<ControlPlanDetailVO> checkList = detailList.stream().filter(x->!"del".equals(x.getRowState())).
                filter(x->PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())).collect(Collectors.toList());
        Map<String, List<ControlPlanDetailVO>> map = checkList.stream().collect(
                Collectors.groupingBy(x -> x.getMaterialName() + x.getUnitId() + x.getPropertyValue()));
        List<String> codeList = map.entrySet().stream().filter(x->x.getValue().size()> 1).map(x->x.getValue()).
                flatMap(Collection::stream).map(ControlPlanDetailVO::getMaterialCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(codeList)){
            throw new BusinessException("【" + StringUtils.join(codeList, ",")+ "】物料重复，请检查！");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<ControlPlanEntity> dataList = super.queryList(queryParam);
        if(CollectionUtils.isEmpty(dataList)){
            return;
        }
        List<Long> planIds = dataList.stream().map(ControlPlanEntity::getId).collect(Collectors.toList());

        //1、先查询分类下属性相同的材料
        Map<Long, List<ControlPlanDetailVO>> typeMap = checkList.stream().collect(Collectors.groupingBy(ControlPlanDetailVO::getMaterialTypeId));
        //2、判断单位项目的项是否属性相同
        QueryWrapper<ControlPlanDetailEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("plan_id", planIds);
        List<Long> ids = detailList.stream().map(ControlPlanDetailVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        query.notIn(CollectionUtils.isNotEmpty(ids), "id", ids);
        //检查统一分类下是否存在名称、单位、属性相同的明细
        query.and(q -> {
            for(Long materialTypeId : typeMap.keySet()) {
                q.or(qs -> qs.eq("material_type_id", materialTypeId).and(qss -> {
                    for(ControlPlanDetailVO m : typeMap.get(materialTypeId)) {
                        qss.or(qssi -> qssi.eq("material_name", m.getMaterialName()).
                                eq("property_value", m.getPropertyValue()).eq("unit_id", m.getUnitId()));
                    }
                    return qss;
                }));
            }
            return q;
        });
        List<ControlPlanDetailEntity> list = detailService.list(query);
        Map<String, ControlPlanDetailEntity> matchMap = list.parallelStream()
                .collect(Collectors.toMap(x -> x.getMaterialName() + x.getUnitId() + x.getPropertyValue(), x -> x, (v1,v2) -> v1));
        List<String> codes = detailList.stream().filter(x->matchMap.containsKey(x.getMaterialName() + x.getUnitId() + x.getPropertyValue())).
                map(ControlPlanDetailVO::getMaterialCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(codes)){
            throw new BusinessException("【" + StringUtils.join(codes, ",")+ "】物料已添加总控计划，不能重复添加！");
        }
    }

    // 校验变更单不存在非生效态
    private void validateChange(ControlPlanVO saveOrUpdateVO) {
        List<ControlPlanDetailVO> detailList = saveOrUpdateVO.getDetailList().stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(detailList)){
            return;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
        queryParam.getParams().put("billType", new Parameter(QueryParam.EQ, PlanConstant.BILL_TYPE_CHANGE));
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(saveOrUpdateVO.getId() != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, saveOrUpdateVO.getId()));
        }
        List<ControlPlanEntity> dataList = super.queryList(queryParam);
//        if(dataList.stream().anyMatch(x -> !"1,3".contains(String.valueOf(x.getBillState())))){
//            throw new BusinessException("项目下存在未生效变更单，不允许新增!");
//        }
//        Integer max = dataList.stream().map(ControlPlanEntity::getChangeVersion).max(Integer::compareTo).orElse(null);
//        if(max != null && saveOrUpdateVO.getChangeVersion() <= max){
//            throw new BusinessException("非最新变更单，请刷新重试!");
//        }
        if(CollectionUtils.isEmpty(dataList)){
            return;
        }
        List<Long> planIds = dataList.stream().map(x->x.getId()).collect(Collectors.toList());
        List<Long> ids = detailList.stream().map(ControlPlanDetailVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        QueryWrapper<ControlPlanDetailEntity> query = new QueryWrapper<>();
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("plan_id", planIds);
        query.notIn(CollectionUtils.isNotEmpty(ids), "id", ids);
        //检查是否存在名称、单位、属性相同的明细
        query.and(q -> {
            for(ControlPlanDetailVO m : detailList) {
                q.or(qs -> qs.eq("material_name", m.getMaterialName()).
                        eq("property_value", m.getPropertyValue()).eq("unit_id", m.getUnitId()));
            }
            return q;
        });
        List<ControlPlanDetailEntity> list = detailService.list(query);
        List<String> codeList = list.stream().map(ControlPlanDetailEntity::getMaterialCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(codeList)){
            throw new BusinessException("【" + StringUtils.join(codeList, ",") + "】物料在该项目下存在未生效变更单，不允许新增!");
        }
    }

    /**
     * 计划编制时校验二级分类不允许重复
     * @param saveOrUpdateVO
     * @param flag 是否需要查询二级分类
     */
    public Map<Long, MaterialCategoryEntity> validateParentTypeId(ControlPlanVO saveOrUpdateVO, Boolean flag) {
        List<ControlPlanDetailVO> detailList = saveOrUpdateVO.getDetailList().stream().
                filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
        Map<Long, MaterialCategoryEntity> parentMap = new HashMap<>();
        if(flag){
            parentMap = this.dealParentTypeId(detailList);// 赋值二级分类主键
        }
        Map<Long, List<ControlPlanDetailVO>> typeMap = detailList.stream().filter(x->PlanConstant.ROW_TYPE_NEW.equals(x.getRowType())
                && x.getParentMaterialTypeId() != null).collect(Collectors.groupingBy(x->x.getParentMaterialTypeId()));
        if(CollectionUtils.isEmpty(typeMap.keySet())){
            logger.info("子表二级分类主键为空，不需要校验！");
            return parentMap;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, saveOrUpdateVO.getProjectId()));
        List<ControlPlanEntity> dataList = super.queryList(queryParam);
        List<Long> ids = dataList.stream().map(ControlPlanEntity::getId).filter(x->!x.equals(saveOrUpdateVO.getId())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(ids)){
            logger.info("项目下不存在编制或变更，不需要校验！");
            return parentMap;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("parentMaterialTypeId", new Parameter(QueryParam.IN, new ArrayList<>(typeMap.keySet())));
        param.getParams().put("planId", new Parameter(QueryParam.IN, ids));
        List<ControlPlanDetailEntity> list = detailService.queryList(param);
        List<Long> typeIds = list.stream().map(ControlPlanDetailEntity::getParentMaterialTypeId).distinct().collect(Collectors.toList());
        List<String> codeList = typeMap.entrySet().stream().filter(x->typeIds.contains(x.getKey())).map(x->x.getValue()).
                flatMap(Collection::stream).map(ControlPlanDetailVO::getMaterialCode).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(codeList)){
            throw new BusinessException("【" + StringUtils.join(codeList, ",") + "】物料所属二级物料分类在该项目下已存在计划编制或变更新增，不允许重复添加！");
        }
        logger.info("校验通过!");
        return parentMap;
    }

    @Override
    public Map<Long, MaterialCategoryEntity> getParentMaterialTypeMap(List<Long> materialTypeIds){
        if(CollectionUtils.isEmpty(materialTypeIds)){
            return new HashMap<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, materialTypeIds));
        List<MaterialCategoryEntity> typeList = categoryService.queryList(param);
        Map<Long, Long> typeMap = typeList.stream().collect(Collectors.toMap(x->x.getId(),
                x->x.getInnerCode().indexOf("|") > 0 ? Long.valueOf(StringUtils.split(x.getInnerCode(),"|")[1]) : Long.valueOf(x.getInnerCode())));
        List<Long> parentIds = typeMap.values().stream().distinct().collect(Collectors.toList());
        param.getParams().put("id", new Parameter(QueryParam.IN, parentIds));
        List<MaterialCategoryEntity> parentList = categoryService.queryList(param);
        Map<Long, MaterialCategoryEntity> parentMap = parentList.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        Map<Long, MaterialCategoryEntity> result = new HashMap<>();
        for(Long materialTypeId : typeMap.keySet()){
            MaterialCategoryEntity parent = new MaterialCategoryEntity();
            if(parentMap.containsKey(typeMap.get(materialTypeId))){
                parent = parentMap.get(typeMap.get(materialTypeId));
            }
            result.put(materialTypeId, parent);
        }
        return result;
    }

    @Override
    public List<ControlPlanEntity> getAllByOrgId(List<Long> orgIds) {
        QueryWrapper<ControlPlanEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("org_id", orgIds);

        return super.list(query);
    }

    /**
     * 赋值二级分类主键
     * @param detailList
     */
    private Map<Long, MaterialCategoryEntity> dealParentTypeId(List<ControlPlanDetailVO> detailList) {
        List<Long> typeIds = detailList.stream().filter(item -> !"del".equals(item.getRowState())).
                map(ControlPlanDetailVO::getMaterialTypeId).distinct().collect(Collectors.toList());
        if(CollectionUtils.isEmpty(typeIds)){
            return new HashMap<>();
        }
        Map<Long, MaterialCategoryEntity> parentMap = this.getParentMaterialTypeMap(typeIds);
        detailList.forEach(x->{
            MaterialCategoryEntity parent = new MaterialCategoryEntity();
            if(parentMap.containsKey(x.getMaterialTypeId())){
                parent = parentMap.get(x.getMaterialTypeId());
            }
            x.setParentMaterialTypeId(parent.getId());
            x.setParentMaterialTypeCode(parent.getCode());
            x.setParentMaterialTypeName(parent.getName());
        });
        return parentMap;
    }
}
