package com.ejianc.business.zdsmaterial.pricelib.engine.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.pricelib.processor.BaseCalcProcessor;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.List;

/**
 * @Author: caojie
 * @CreateTime:2025-07-11 11:30
 * @Version: 1.0
 */
public class C3001PricingEngine extends BasePricingEngine {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public BigDecimal calcPrice(PriceLibVO priceLibVO, List<MaterialPriceCalcSubConditionVO> conditions) throws Exception {
        //获取匹配的计算规则
        MaterialPriceCalcSubConditionVO c = findMatchingCondition(priceLibVO, conditions);
        if(null == c){
            priceLibVO.setCalcContent("未计算：未匹配到计算规则！");
            return BigDecimal.ZERO;
        }

        logger.info("碳钢管道价格计算：计算规则：{}, 获取编码为：{}的公式计算处理器", JSONObject.toJSONString(c), c.getCalcCode());
        BaseCalcProcessor processor = ContextUtil.getBean(c.getCalcCode(), BaseCalcProcessor.class);
        if(null == processor) {
            logger.error("为获取到编码为：{}的公式处理器, 价格计算终止", c.getCalcCode());
            priceLibVO.setCalcContent("未计算：未获取到计算规则对应公式的处理器！");
            return BigDecimal.ZERO;
        }

        return processor.calc(priceLibVO, c);
    }
}
