/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.google.common.base.Stopwatch;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/brand/"})
public class BrandController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBrandService service;
    @Value(value="${erp.appId}")
    private String appId;
    @Value(value="${erp.secret}")
    private String secret;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Value(value="${erp.batchSize:100}")
    private String batchSize;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private IBrandRelationService relationService;
    @Autowired
    private IMaterialCategoryService categoryService;
    private final String BRAND_ERP_REQ_URL = "/cefoc/yql/getBrandList";
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private IBrandRelationService brandRelationService;

    @GetMapping(value={"refBrandData"})
    public CommonResponse<IPage<BrandVO>> refDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("brandName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BrandVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"syncErpBrands"})
    public CommonResponse<String> syncErpBrands() {
        this.logger.info("*********************\u4e2d\u7535\u56db-\u54c1\u724c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        Integer pageNum = 0;
        Integer pageSize = Integer.valueOf(this.batchSize);
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        String reqUrl = this.reqHost + "/cefoc/yql/getBrandList";
        boolean hasNext = true;
        String reqResp = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            String nowStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date());
            headers.put("appid", BrandController.toMD5(this.appId));
            headers.put("ticket", nowStr);
            headers.put("sign", BrandController.toMD5(this.secret + BrandController.toMD5(this.appId) + BrandController.toMD5(nowStr)));
            param.put("PageSize", pageSize);
            JSONObject reqJson = null;
            JSONArray pageData = null;
            pageNum = pageNum + 1;
            param.put("PageNum", pageNum);
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pageData = reqJson.getJSONArray("data");
                if (null != pageData && pageData.size() > 0) {
                    this.logger.info("\u4e2d\u7535\u56db\u54c1\u724c\u540c\u6b65\uff0c\u5904\u7406\u7b2c{}\u9875, {}\u6761\u6570\u636e", (Object)pageNum, (Object)pageData.size());
                    this.handleBrandErpPage(pageData);
                } else {
                    this.logger.info("\u4e2d\u7535\u56db\u54c1\u724c\u540c\u6b65 \u5904\u7406\u6570\u636e\u5b8c\u6210\uff01\uff01\uff01\u603b\u5171{}\u9875\u6570\u636e\uff01", (Object)pageNum);
                }
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u54c1\u724c\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                this.queueUtils.sendMq("el_sync_erp_data_job_1" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1", reqResp, null)));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u54c1\u724c\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqUrl, (Object)JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            this.queueUtils.sendMq("el_sync_erp_data_job_1" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1", reqResp, e.getMessage())));
            return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u54c1\u724c\u4fe1\u606f\u5f02\u5e38");
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u54c1\u724c\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        this.queueUtils.sendMq("el_sync_erp_data_job_1" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1")));
        return CommonResponse.success((String)"\u4e2d\u7535\u56db\u54c1\u724c\u540c\u6b65\u5b8c\u6210\uff01");
    }

    @PostMapping(value={"pageBrandPool"})
    public CommonResponse<IPage<BrandVO>> pageBrandPool(@RequestBody QueryParam param) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != param.getSearchText()) {
            params.put("searchText", param.getSearchText());
        }
        if (param.getParams().containsKey("categoryId")) {
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString()));
            List<MaterialCategoryEntity> leafCategorys = this.categoryService.getAllLeafByPids((List<Long>)categoryIds, PlanConstant.INTEGER_YES);
            List<Long> leafCategoryIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(leafCategorys)) {
                leafCategoryIds = leafCategorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
            } else {
                leafCategoryIds.add(-99L);
            }
            params.put("categoryIds", leafCategoryIds);
            param.getParams().remove("categoryId");
        }
        for (String key : param.getParams().keySet()) {
            params.put(key, ((Parameter)param.getParams().get(key)).getValue());
        }
        params.put("startLine", (param.getPageIndex() - 1) * param.getPageSize());
        params.put("pageSize", param.getPageSize());
        long total = this.service.countBrandPool(params);
        if (total == 0L) {
            Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
            pageData.setRecords(new ArrayList());
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        List<BrandVO> brandList = this.service.pageBrandPool(params);
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), total);
        pageData.setRecords(brandList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BrandVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("brandName");
        fuzzyFields.add("label");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("categoryId")) {
            List<BrandRelationEntity> relations = this.relationService.getAllByCategoryId(Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString()));
            if (CollectionUtils.isNotEmpty(relations)) {
                param.getParams().put("id", new Parameter("in", relations.stream().map(BrandRelationEntity::getBrandId).collect(Collectors.toList())));
            } else {
                param.getParams().put("id", new Parameter("eq", (Object)-999L));
            }
            param.getParams().remove("categoryId");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BrandVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private void handleBrandErpPage(JSONArray data) {
        JSONObject tmp = null;
        BrandEntity tmpBrand = null;
        HashMap<String, BrandEntity> brandSourceIdMap = new HashMap<String, BrandEntity>();
        ArrayList<BrandEntity> saveList = new ArrayList<BrandEntity>();
        for (Object obj : data) {
            tmp = (JSONObject)obj;
            tmpBrand = new BrandEntity();
            tmpBrand.setBrandName(tmp.getString("Title"));
            tmpBrand.setSourceId(tmp.getString("C_PS_BrandLibraryOID"));
            tmpBrand.setEnabled(StringUtils.isNotBlank((CharSequence)tmp.getString("IsEnable")) ? ("true".equals(tmp.getString("IsEnable").toLowerCase()) ? 1 : 0) : 1);
            tmpBrand.setSequence(null != tmp.get((Object)"Sort_ID") ? tmp.getInteger("Sort_ID") : 1);
            tmpBrand.setMemo(null != tmp.getString("Memo") ? tmp.getString("Memo") : null);
            brandSourceIdMap.put(tmpBrand.getSourceId(), tmpBrand);
        }
        List<BrandEntity> dbListBySourceId = this.service.getAllBySourceIds(new ArrayList<String>(brandSourceIdMap.keySet()));
        if (CollectionUtils.isNotEmpty(dbListBySourceId)) {
            for (BrandEntity dbEntity : dbListBySourceId) {
                tmpBrand = (BrandEntity)((Object)brandSourceIdMap.get(dbEntity.getSourceId()));
                dbEntity.setBrandName(tmpBrand.getBrandName());
                dbEntity.setEnabled(tmpBrand.getEnabled());
                dbEntity.setSequence(tmpBrand.getSequence());
                dbEntity.setMemo(tmpBrand.getMemo());
                saveList.add(dbEntity);
                brandSourceIdMap.remove(dbEntity.getSourceId());
            }
        }
        if (!brandSourceIdMap.isEmpty()) {
            saveList.addAll(brandSourceIdMap.values());
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6570\u636e-{}\u6761", (Object)saveList.size());
        this.service.saveOrUpdateBatch(saveList, saveList.size(), false);
    }

    public static String toMD5(String plainText) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] hashBytes = digest.digest(plainText.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString().toLowerCase();
    }

    @PostMapping(value={"updateBrandEnable"})
    public CommonResponse<String> updateBrandEnable(@RequestBody BrandVO brand) {
        this.service.updateRelationEnable(brand);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"pushAllToErp"})
    public CommonResponse<String> pushAllToErp(@RequestBody List<Long> ids) {
        this.logger.info("\u54c1\u724c\u4fe1\u606f\u63a8\u9001ERP-------------\u5f00\u59cb----------------");
        List<BrandVO> dbList = this.service.getAllByIds(ids);
        ArrayList<JSONObject> pushParams = new ArrayList<JSONObject>();
        JSONObject syncItem = null;
        for (BrandVO brand : dbList) {
            syncItem = new JSONObject();
            syncItem.put("C_PS_BrandLibraryOID", (Object)brand.getSourceId());
            syncItem.put("Title_ID", (Object)brand.getId());
            syncItem.put("Title", (Object)brand.getBrandName());
            syncItem.put("Sort_ID", (Object)brand.getSequence());
            syncItem.put("IsEnable", null != brand.getEnabled() ? Boolean.valueOf(1 == brand.getEnabled()) : null);
            pushParams.add(syncItem);
        }
        Map<String, String> headers = null;
        String reqUrl = this.reqHost + "/cefoc/yql/updateBrand";
        boolean haxNext = true;
        ArrayList p = new ArrayList();
        Iterator it = pushParams.iterator();
        while (it.hasNext()) {
            p.add(it.next());
            it.remove();
            if (p.size() != 1) continue;
            try {
                Stopwatch start = Stopwatch.createStarted();
                headers = ZDSInterfaceCommonUtil.getErpHeaders();
                String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(p), headers, (Integer)180000, (Integer)180000);
                this.logger.info("\u54c1\u724c\u4fe1\u606f\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(p, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
                Stopwatch stop = start.stop();
                JSONObject reqJson = JSONObject.parseObject((String)reqResp);
                p.clear();
            }
            catch (Exception e) {
                throw new BusinessException("\u54c1\u724c\u4fe1\u606f\u540c\u6b65ERP\u5f02\u5e38\uff0c", (Throwable)e);
            }
        }
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }
}

