/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.plan.conjecture.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.ConjectureEditVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureHisVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialSimpleConjectureVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialConjecture"})
public class MaterialConjectureController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialConjectureService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> saveOrUpdate(@RequestBody MaterialConjectureVO saveOrUpdateVO) {
        MaterialConjectureEntity entity = (MaterialConjectureEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialConjectureEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MaterialConjectureVO vo = (MaterialConjectureVO)BeanMapper.map((Object)((Object)entity), MaterialConjectureVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"materialConjecture"})
    @ResponseBody
    public CommonResponse<List<MaterialSimpleConjectureVO>> materialConjecture(@RequestBody List<MaterialConjectureVO> conjectureDescList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        MaterialConjectureEntity tmp = null;
        ArrayList<MaterialConjectureEntity> saveList = new ArrayList<MaterialConjectureEntity>();
        String uuid = UUID.randomUUID().toString();
        for (MaterialConjectureVO vo : conjectureDescList) {
            tmp = new MaterialConjectureEntity();
            if (null == vo.getSourceMaterialSpec()) continue;
            tmp.setSourceMaterialName(StringUtils.isNotBlank((CharSequence)vo.getSourceMaterialName()) ? vo.getSourceMaterialName() : vo.getSourceMaterialSpec());
            tmp.setSourceMaterialSpec(vo.getSourceMaterialSpec());
            tmp.setIdentificationId(uuid);
            tmp.setMateType("4");
            tmp.setIdentificationDate(new Date());
            saveList.add(tmp);
        }
        if (CollectionUtils.isEmpty(saveList)) {
            return CommonResponse.success(new ArrayList());
        }
        this.service.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);
        List<MaterialConjectureVO> result = this.service.materialConjecture(saveList, authority);
        List resultCodeList = BeanMapper.mapList(new ArrayList(result.stream().filter(item -> StringUtils.equals((CharSequence)"2", (CharSequence)item.getMateType())).collect(Collectors.toSet())), MaterialSimpleConjectureVO.class);
        return CommonResponse.success((Object)resultCodeList);
    }

    @PostMapping(value={"/saveConjecture"})
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> saveConjecture(@RequestBody ConjectureEditVO materialVO) {
        MaterialConjectureEntity entity = (MaterialConjectureEntity)((Object)this.service.selectById(materialVO.getConjectureId()));
        entity.setActualMaterialId(materialVO.getMaterialId());
        entity.setActualCategoryId(materialVO.getCategoryId());
        entity.setActualCategoryName(materialVO.getCategoryName());
        entity.setActualMaterialSpec(materialVO.getPropertyShowName());
        entity.setActualMaterialCode(materialVO.getCode());
        if (CollectionUtils.isNotEmpty((Collection)materialVO.getRelationList())) {
            JSONArray specArr = new JSONArray();
            JSONObject json = null;
            for (MaterialPropertyRelationVO s : materialVO.getRelationList()) {
                json = (JSONObject)BeanMapper.map((Object)s, JSONObject.class);
                json.put("propertyItemId", (Object)s.getPropertyItemId().toString());
                json.put("id", (Object)s.getPropertyItemId().toString());
                json.put("categoryId", (Object)s.getCategoryId().toString());
                json.put("propertyId", (Object)s.getPropertyId().toString());
                specArr.add((Object)json);
            }
            entity.setActualMaterialSpecs(specArr.toJSONString());
        }
        entity.setActualNum(materialVO.getNum());
        entity.setActualUnitId(materialVO.getUnitId());
        entity.setActualUnitName(materialVO.getUnitName());
        entity.setActualMaterialName(materialVO.getName());
        entity.setAdjustFlag(PlanConstant.INTEGER_YES);
        entity.setMateType("2");
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f!", (Object)BeanMapper.map((Object)((Object)entity), MaterialConjectureVO.class));
    }

    @PostMapping(value={"/changeLoadStatus"})
    @ResponseBody
    public CommonResponse<String> changeLoadStatus(@RequestBody List<Long> ids, @RequestParam String loadState) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"load_state", (Object)loadState);
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        update.set((Object)"update_time", (Object)new Date());
        this.service.update((Wrapper)update);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialConjectureVO> queryDetail(Long id) {
        MaterialConjectureEntity entity = (MaterialConjectureEntity)((Object)this.service.selectById(id));
        MaterialConjectureVO vo = (MaterialConjectureVO)BeanMapper.map((Object)((Object)entity), MaterialConjectureVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialConjectureVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialConjectureVO materialConjectureVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<MaterialConjectureHisVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter("ne", (Object)"adminscmm"));
        param.getParams().put("mateType", new Parameter("ne", (Object)"4"));
        param.getParams().put("conjectureMateType", new Parameter("ne", (Object)"4"));
        List page = this.service.queryList(param, false);
        ArrayList pageData = new ArrayList();
        pageData.addAll(BeanMapper.mapList((Iterable)page, MaterialConjectureHisVO.class));
        pageData.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getActualMaterialSpecs())).forEach(item -> {
            List relations = JSONArray.parseArray((String)item.getActualMaterialSpecs(), MaterialPropertyRelationVO.class);
            JSONObject propertyJson = new JSONObject();
            relations.stream().forEach(relationItem -> propertyJson.put(relationItem.getPropertyName(), (Object)new String[]{StringUtils.isNotBlank((CharSequence)relationItem.getPropertyValue()) ? relationItem.getPropertyValue() : "", relationItem.getPropertyId().toString(), null != relationItem.getPropertyItemId() ? relationItem.getPropertyItemId().toString() : ""}));
            item.setAdjustFlag("1".equals(item.getAdjustFlag()) ? "\u5df2\u4fee\u8ba2" : "\u672a\u4fee\u8ba2");
            item.setActualMaterialSpecs(propertyJson.toJSONString());
            item.setConjectureMateType("1".equals(item.getConjectureMateType()) ? "\u90e8\u5206\u5339\u914d" : ("2".equals(item.getConjectureMateType()) ? "\u5168\u90e8\u5339\u914d" : ("3".equals(item.getConjectureMateType()) ? "\u4e0d\u5339\u914d" : "\u5339\u914d\u5931\u8d25")));
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialConjecture-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialConjectureData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialConjectureVO>> refMaterialConjectureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialConjectureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

