/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.pricelib.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.erp.service.IErpMaterialPriceService;
import com.ejianc.business.zdsmaterial.erp.vo.ErpMaterialPriceVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingEngine;
import com.ejianc.business.zdsmaterial.pricelib.engine.PricingFactory;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcService;
import com.ejianc.business.zdsmaterial.pricelib.service.IMaterialPriceCalcSubConditionService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcSubConditionVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.MaterialPriceCalcVO;
import com.ejianc.business.zdsmaterial.pricelib.vo.PriceLibVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/materialPriceNew"})
public class MaterialPriceNewController {
    @Autowired
    private IMaterialConjectureService materialConjectureService;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private ConjectureManageFactory factory;
    @Value(value="${material.ai.handlerName:CJYT}")
    private String handlerName;
    @Autowired
    private IMaterialService materialService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceContractService priceContractService;
    @Autowired
    private IMaterialPriceCalcService materialPriceCalcService;
    @Autowired
    private IErpMaterialPriceService erpMaterialPriceService;
    @Autowired
    private IMaterialBasePriceContentService materialBasePriceContentService;
    @Autowired
    private IMaterialPriceCalcSubConditionService priceCalcSubConditionService;

    @PostMapping(value={"/getCategoryTree"})
    public CommonResponse<List<Map<String, Object>>> getCategoryTree(@RequestBody QueryParam param) {
        List<MaterialConjectureEntity> list;
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        if (param.getParams().containsKey("searchAI")) {
            HashMap<Long, MaterialConjectureVO> searchList = new HashMap<Long, MaterialConjectureVO>();
            searchList.putAll(this.factory.similarSearch(this.handlerName, ((Parameter)param.getParams().get("searchAI")).getValue().toString(), null, new String[0]));
            if (MapUtils.isNotEmpty(searchList)) {
                List<MaterialVO> materialVOS = this.materialService.queryDetailList(new ArrayList<Long>(searchList.keySet()), false);
                categoryIds.addAll(materialVOS.stream().map(MaterialVO::getCategoryId).collect(Collectors.toList()));
            }
            if (CollectionUtils.isEmpty(categoryIds)) {
                return CommonResponse.success(new ArrayList());
            }
        }
        if (param.getParams().containsKey("curIdentifyId") && CollectionUtils.isNotEmpty(list = this.materialConjectureService.getAllByIdentifyId(((Parameter)param.getParams().get("curIdentifyId")).getValue().toString(), null, null, null, null, null, null, null, "1"))) {
            categoryIds.addAll(list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByChildren(categoryIds);
            List<MaterialPriceCalcVO> dataList = this.materialPriceCalcService.getAllByCategoryIds(categoryIds);
            Map detailMap = dataList.stream().collect(Collectors.toMap(MaterialPriceCalcVO::getCategoryId, Function.identity()));
            categoryVOS.stream().filter(item -> detailMap.containsKey(item.getId())).forEach(item -> {
                item.setMaterialType(((MaterialPriceCalcVO)detailMap.get(item.getId())).getMaterialType());
                item.setMaterialTypeId(((MaterialPriceCalcVO)detailMap.get(item.getId())).getMaterialTypeId());
                item.setMaterialTypeName(((MaterialPriceCalcVO)detailMap.get(item.getId())).getMaterialTypeName());
                item.setEnabled(((MaterialPriceCalcVO)detailMap.get(item.getId())).getEnabled());
                item.setCalcFields(((MaterialPriceCalcVO)detailMap.get(item.getId())).getCalcFields());
            });
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)ResultAsTree.createTreeData((List)BeanMapper.mapList(categoryVOS, Map.class)));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", new ArrayList());
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<List<PriceLibVO>> queryList(@RequestBody QueryParam param) {
        AbstractCollection materialIds;
        List<Long> categoryIds = new ArrayList<Long>();
        List<Object> actualList = new ArrayList();
        QueryParam basePriceQuery = new QueryParam();
        List<PriceLibVO> priceLibList = null;
        if (param.getParams().containsKey("searchAI")) {
            HashMap<Long, MaterialConjectureVO> searchList = new HashMap<Long, MaterialConjectureVO>();
            materialIds = new ArrayList();
            searchList.putAll(this.factory.similarSearch(this.handlerName, ((Parameter)param.getParams().get("searchAI")).getValue().toString(), null, new String[0]));
            if (MapUtils.isNotEmpty(searchList)) {
                materialIds.addAll(new ArrayList(searchList.keySet()));
            } else {
                materialIds.addAll(Collections.singletonList(-9L));
            }
            param.getParams().put("materialId", Parameter.getInInstance((Object)materialIds));
            param.getParams().remove("searchAI");
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if (param.getParams().containsKey("categoryId")) {
                param.getParams().put("material_type_id", param.getParams().get("categoryId"));
                param.getParams().remove("categoryId");
            }
            for (PriceLibVO p2 : priceLibList) {
                if (searchList.containsKey(p2.getMaterialId())) {
                    p2.setSimilarCoefficient(((MaterialConjectureVO)searchList.get(p2.getMaterialId())).getSimilarCoefficient());
                }
                if (categoryIds.contains(p2.getMaterialTypeId())) continue;
                categoryIds.add(p2.getMaterialTypeId());
            }
            priceLibList.sort((v1, v2) -> ComputeUtil.safeSub(v2.getSimilarCoefficient(), v1.getSimilarCoefficient()).intValue());
            actualList.addAll(priceLibList);
            basePriceQuery.getParams().put("material_class_id", Parameter.getInInstance(categoryIds));
            if (CollectionUtils.isEmpty(priceLibList)) {
                return CommonResponse.success(new ArrayList());
            }
        }
        HashMap<String, MaterialConjectureEntity> conMap = new HashMap<String, MaterialConjectureEntity>();
        if (param.getParams().containsKey("curIdentifyId")) {
            List<MaterialConjectureEntity> list;
            materialIds = new HashSet();
            HashSet materialCode = new HashSet();
            Long categoryId = null;
            if (param.getParams().containsKey("categoryId")) {
                categoryId = Long.valueOf(((Parameter)param.getParams().get("categoryId")).getValue().toString());
                param.getParams().remove("categoryId");
                categoryIds = this.categoryService.queryChildrenIdsByPIds(Collections.singletonList(categoryId));
            }
            if (CollectionUtils.isNotEmpty(list = this.materialConjectureService.getAllByIdentifyId(((Parameter)param.getParams().get("curIdentifyId")).getValue().toString(), null, null, null, null, null, null, null, "1", categoryIds))) {
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                list.stream().forEach(arg_0 -> MaterialPriceNewController.lambda$queryList$3(conMap, (Set)((Object)materialIds), materialCode, c, arg_0));
                param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList(materialCode)));
            }
            param.getParams().remove("curIdentifyId");
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if (CollectionUtils.isEmpty(categoryIds)) {
                categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
            }
        }
        basePriceQuery.getParams().put("status", Parameter.getEqInstance((Object)"1"));
        actualList = this.fillPriceInfo(priceLibList, categoryIds, basePriceQuery, conMap);
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(categoryIds);
        HashMap<Long, MaterialCategoryVO> categoryVOMap = new HashMap<Long, MaterialCategoryVO>();
        categoryVOMap.putAll(categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = this.materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);
        actualList.parallelStream().forEach(p -> {
            try {
                Long categoryId = p.getMaterialTypeId();
                this.logger.info("p-categoryId:{}\uff0cmaterialId:{}", (Object)categoryId, (Object)p.getMaterialId());
                if (null == categoryId) {
                    this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                } else {
                    MaterialCategoryVO tmpC = (MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId());
                    if (null == tmpC) {
                        this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                        p.setAdjustedPrice(BigDecimal.ZERO);
                    } else {
                        this.logger.info("\u67e5\u8be2\u5206\u7c7bid-{},\u7f16\u7801-{}\u5bf9\u5e94\u7684\u5206\u7c7b\u5f15\u64ce", (Object)tmpC.getId(), (Object)tmpC.getCode());
                        PricingEngine engine = PricingFactory.getEngine(((MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId())).getCode());
                        if (null != engine) {
                            engine.calcPrice((PriceLibVO)p, (List)conditionMap.get(p.getMaterialTypeId()));
                        } else {
                            this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)p));
                            p.setAdjustedPrice(BigDecimal.ZERO);
                        }
                        tmpC = null;
                    }
                    categoryId = null;
                }
            }
            catch (Exception e) {
                this.logger.error("\u7269\u6599: {}\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)p));
                this.logger.error("\u7269\u6599\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if (!p.getCalcContent().contains("\u672a\u8ba1\u7b97")) {
                p.setAdjustedRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice()), p.getBaseMaterialPrice()), new BigDecimal("100")));
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", actualList);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<Long> categoryIds = new ArrayList<Long>();
        List<Object> actualList = new ArrayList();
        QueryParam basePriceQuery = new QueryParam();
        List<PriceLibVO> priceLibList = null;
        HashMap<String, MaterialConjectureEntity> conMap = new HashMap<String, MaterialConjectureEntity>();
        if (param.getParams().containsKey("searchAI")) {
            HashMap<Long, MaterialConjectureVO> searchList = new HashMap<Long, MaterialConjectureVO>();
            ArrayList<Object> materialIds = new ArrayList<Object>();
            searchList.putAll(this.factory.similarSearch(this.handlerName, ((Parameter)param.getParams().get("searchAI")).getValue().toString(), null, new String[0]));
            if (MapUtils.isNotEmpty(searchList)) {
                materialIds.addAll(new ArrayList(searchList.keySet()));
            } else {
                materialIds.addAll(Collections.singletonList(-9L));
            }
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if (param.getParams().containsKey("categoryId")) {
                param.getParams().put("material_type_id", param.getParams().get("categoryId"));
                param.getParams().remove("categoryId");
            }
            for (PriceLibVO p2 : priceLibList) {
                if (searchList.containsKey(p2.getMaterialId())) {
                    p2.setSimilarCoefficient(((MaterialConjectureVO)searchList.get(p2.getMaterialId())).getSimilarCoefficient());
                }
                if (categoryIds.contains(p2.getMaterialTypeId())) continue;
                categoryIds.add(p2.getMaterialTypeId());
            }
            priceLibList.sort((v1, v2) -> ComputeUtil.safeSub(v2.getSimilarCoefficient(), v1.getSimilarCoefficient()).intValue());
            actualList.addAll(priceLibList);
            basePriceQuery.getParams().put("material_class_id", Parameter.getInInstance(categoryIds));
        } else if (param.getParams().containsKey("curIdentifyId")) {
            HashSet materialIds = new HashSet();
            HashSet materialCode = new HashSet();
            List<MaterialConjectureEntity> list = this.materialConjectureService.getAllByIdentifyId(((Parameter)param.getParams().get("curIdentifyId")).getValue().toString(), null, null, null, null, null, null, null, "1");
            if (CollectionUtils.isNotEmpty(list)) {
                ComplexParam c = new ComplexParam();
                c.setLogic("and");
                list.stream().forEach(m -> {
                    conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), (MaterialConjectureEntity)((Object)m));
                    materialIds.add(m.getActualMaterialId());
                    materialCode.add(m.getActualMaterialCode());
                    ComplexParam c2 = new ComplexParam();
                    c2.setLogic("or");
                    c2.getParams().put("material_id", Parameter.getEqInstance((Object)m.getActualMaterialId()));
                    if (null != m.getSupplierId()) {
                        c2.getParams().put("supplier_id", Parameter.getEqInstance((Object)m.getSupplierId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    if (null != m.getBrandId()) {
                        c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                    }
                    c.getComplexParams().add(c2);
                });
                param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList(materialCode)));
            }
            param.getParams().remove("curIdentifyId");
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
            List<Long> orgIdList = this.priceContractService.queryOrgIdList();
            priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
            if (CollectionUtils.isEmpty(categoryIds)) {
                categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
            }
        }
        basePriceQuery.getParams().put("status", Parameter.getEqInstance((Object)"1"));
        actualList = this.fillPriceInfo(priceLibList, categoryIds, basePriceQuery, conMap);
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = this.materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);
        actualList.parallelStream().forEach(p -> {
            try {
                Long categoryId = p.getMaterialTypeId();
                this.logger.info("p-categoryId:{}\uff0cmaterialId:{}", (Object)categoryId, (Object)p.getMaterialId());
                if (null == categoryId) {
                    this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                } else {
                    MaterialCategoryVO tmpC = (MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId());
                    if (null == tmpC) {
                        this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u7269\u6599\u5bf9\u5e94\u5206\u7c7b\u4fe1\u606f\u5931\u8d25", (Object)JSONObject.toJSONString((Object)p));
                        p.setAdjustedPrice(BigDecimal.ZERO);
                    } else {
                        this.logger.info("\u67e5\u8be2\u5206\u7c7bid-{},\u7f16\u7801-{}\u5bf9\u5e94\u7684\u5206\u7c7b\u5f15\u64ce", (Object)tmpC.getId(), (Object)tmpC.getCode());
                        PricingEngine engine = PricingFactory.getEngine(((MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId())).getCode());
                        if (null != engine) {
                            engine.calcPrice((PriceLibVO)p, (List)conditionMap.get(p.getMaterialTypeId()));
                        } else {
                            this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)p));
                            p.setAdjustedPrice(BigDecimal.ZERO);
                        }
                        tmpC = null;
                    }
                    categoryId = null;
                }
            }
            catch (Exception e) {
                this.logger.error("\u7269\u6599: {}\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)p));
                this.logger.error("\u7269\u6599\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if (!p.getCalcContent().contains("\u672a\u8ba1\u7b97")) {
                p.setAdjustedRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice()), p.getBaseMaterialPrice()), new BigDecimal("100")));
            }
        });
        HashMap<String, List<Object>> beans = new HashMap<String, List<Object>>();
        beans.put("records", actualList);
        ExcelExport.getInstance().export("priceLib-export.xlsx", beans, response);
    }

    @PostMapping(value={"/changeLoadStatus"})
    @ResponseBody
    public CommonResponse<List<PriceLibVO>> changeLoadStatus(@RequestBody List<Long> ids, @RequestParam String loadState) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"load_state", (Object)loadState);
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        update.set((Object)"update_time", (Object)new Date());
        this.materialConjectureService.update((Wrapper)update);
        QueryParam param = new QueryParam();
        QueryParam basePriceQuery = new QueryParam();
        HashMap<String, MaterialConjectureEntity> conMap = new HashMap<String, MaterialConjectureEntity>();
        HashSet materialCodes = new HashSet();
        List list = (List)this.materialConjectureService.listByIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ComplexParam c = new ComplexParam();
            c.setLogic("and");
            list.stream().forEach(m -> {
                conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), (MaterialConjectureEntity)((Object)m));
                materialCodes.add(m.getActualMaterialCode());
                ComplexParam c2 = new ComplexParam();
                c2.setLogic("or");
                c2.getParams().put("material_id", Parameter.getEqInstance((Object)m.getActualMaterialId()));
                if (null != m.getSupplierId()) {
                    c2.getParams().put("supplier_id", Parameter.getEqInstance((Object)m.getSupplierId()));
                }
                if (null != m.getBrandId()) {
                    c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                }
                if (null != m.getBrandId()) {
                    c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
                }
                c.getComplexParams().add(c2);
            });
            param.getParams().put("materialCode", Parameter.getInInstance(new ArrayList(materialCodes)));
            param.getParams().remove("curIdentifyId");
        }
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        List<Long> orgIdList = this.priceContractService.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.priceContractService.queryPriceLibListAll(null, null, orgIdList, param);
        List<Long> categoryIds = list.stream().map(MaterialConjectureEntity::getActualCategoryId).collect(Collectors.toList());
        List<PriceLibVO> actualList = this.fillPriceInfo(priceLibList, categoryIds, basePriceQuery, conMap);
        this.calcMaterial(categoryIds, actualList);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", actualList);
    }

    private List<PriceLibVO> calcMaterial(List<Long> categoryIds, List<PriceLibVO> actualList) {
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, List<MaterialPriceCalcSubConditionVO>> conditionMap = this.materialPriceCalcService.getConditionMapByCategoryIds(categoryIds);
        actualList.parallelStream().forEach(p -> {
            try {
                PricingEngine engine = PricingFactory.getEngine(((MaterialCategoryVO)categoryVOMap.get(p.getMaterialTypeId())).getCode());
                if (null != engine) {
                    engine.calcPrice((PriceLibVO)p, (List)conditionMap.get(p.getMaterialTypeId()));
                } else {
                    this.logger.error("\u7269\u6599: {} \u83b7\u53d6\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce\u4e3a\u7a7a", (Object)JSONObject.toJSONString((Object)p));
                    p.setAdjustedPrice(BigDecimal.ZERO);
                    p.setCalcContent("\u672a\u5339\u914d\u5230\u5bf9\u5e94\u8ba1\u7b97\u5f15\u64ce");
                }
            }
            catch (Exception e) {
                this.logger.error("\u7269\u6599: {}\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)p));
                this.logger.error("\u7269\u6599\u4ef7\u683c\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                p.setCalcContent("\u4ef7\u683c\u8ba1\u7b97\u5931\u8d25");
                p.setAdjustedPrice(BigDecimal.ZERO);
            }
            if (!p.getCalcContent().contains("\u672a\u8ba1\u7b97")) {
                p.setAdjustedRatio(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(ComputeUtil.safeSub(p.getAdjustedPrice(), p.getBaseMaterialPrice()), p.getBaseMaterialPrice()), new BigDecimal("100")));
            }
        });
        return actualList;
    }

    @PostMapping(value={"/reCalc"})
    public CommonResponse<List<PriceLibVO>> reCalc(@RequestBody List<PriceLibVO> vos) {
        ArrayList<Long> categoryIds = new ArrayList<Long>(vos.stream().map(PriceLibVO::getMaterialTypeId).collect(Collectors.toSet()));
        List<MaterialCategoryVO> categoryVOS = this.categoryService.queryCategoryListByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        this.calcMaterial(categoryIds, vos);
        return CommonResponse.success((String)"\u8ba1\u7b97\u6210\u529f\uff01", vos);
    }

    public List<PriceLibVO> fillPriceInfo(List<PriceLibVO> vos, List<Long> categoryIds, QueryParam basePriceQuery, Map<String, MaterialConjectureEntity> conMap) {
        List<MaterialBasePriceContentVO> pricevos = this.materialBasePriceContentService.getLatestPrice(basePriceQuery);
        HashMap<String, List<MaterialBasePriceContentVO>> priceMap = new HashMap<String, List<MaterialBasePriceContentVO>>();
        priceMap.putAll(pricevos.stream().collect(Collectors.groupingBy(item -> item.getMaterialCode())));
        List<MaterialCategoryVO> categoryVOS = this.categoryService.getAllByIds(categoryIds);
        Map<Long, MaterialCategoryVO> categoryMap = categoryVOS.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        List<MaterialPriceCalcVO> priceCalcVOS = this.materialPriceCalcService.getAllByCategoryIds(categoryIds);
        HashMap<Long, MaterialPriceCalcVO> priceCalcVOMap = new HashMap<Long, MaterialPriceCalcVO>();
        priceCalcVOMap.putAll(priceCalcVOS.stream().collect(Collectors.toMap(item -> item.getCategoryId(), item -> item)));
        HashMap<Long, ErpMaterialPriceVO> netPriceMap = new HashMap<Long, ErpMaterialPriceVO>();
        if (CollectionUtils.isNotEmpty(priceCalcVOS)) {
            List<ErpMaterialPriceVO> erpMaterialPriceVOS = this.erpMaterialPriceService.getAllByErpMaterialIds(priceCalcVOS.stream().map(MaterialPriceCalcVO::getMaterialTypeId).collect(Collectors.toList()));
            netPriceMap.putAll(erpMaterialPriceVOS.stream().collect(Collectors.toMap(item -> item.getBaseMaterialId(), item -> item)));
        }
        MaterialConjectureEntity tmpC = null;
        ArrayList<PriceLibVO> actualList = new ArrayList<PriceLibVO>();
        PriceLibVO tmp = null;
        ArrayList<PriceLibVO> processList = new ArrayList<PriceLibVO>();
        for (PriceLibVO priceLibVO : vos) {
            if (!categoryMap.containsKey(priceLibVO.getMaterialTypeId())) continue;
            tmpC = conMap.get(priceLibVO.getMaterialId().toString() + priceLibVO.getUnitName());
            if (null != tmpC) {
                conMap.remove(priceLibVO.getMaterialCode() + priceLibVO.getUnitName());
                priceLibVO.setId(tmpC.getId());
                priceLibVO.setBrand(tmpC.getBrandName());
                priceLibVO.setBrandId(tmpC.getBrandId());
                priceLibVO.setSupplierName(tmpC.getSupplierName());
                priceLibVO.setSupplierId(tmpC.getSupplierId());
                priceLibVO.setExtParam1(tmpC.getExtParam1());
                priceLibVO.setExtParam2(tmpC.getExtParam2());
                priceLibVO.setSourceNum(tmpC.getSourceNum());
                priceLibVO.setSourceMaterialName(tmpC.getSourceMaterialName());
                priceLibVO.setSourceUnitName(tmpC.getSourceUnitName());
                priceLibVO.setSourceMaterialSpec(tmpC.getSourceMaterialSpec());
            }
            processList.add(priceLibVO);
        }
        if (!conMap.isEmpty()) {
            PriceLibVO tmpP = null;
            for (MaterialConjectureEntity c : conMap.values()) {
                if (!categoryMap.containsKey(c.getActualCategoryId())) continue;
                tmpP = new PriceLibVO();
                tmpP.setId(c.getId());
                tmpP.setMaterialId(c.getActualMaterialId());
                tmpP.setMaterialCode(c.getActualMaterialCode());
                tmpP.setMaterialName(c.getActualMaterialName());
                tmpP.setMaterialTypeId(c.getActualCategoryId());
                if (categoryMap.containsKey(c.getActualCategoryId())) {
                    tmpP.setMaterialTypeName(categoryMap.get(c.getActualCategoryId()).getName());
                }
                tmpP.setBrand(c.getBrandName());
                tmpP.setBrandId(c.getBrandId());
                tmpP.setSupplierName(c.getSupplierName());
                tmpP.setSupplierId(c.getSupplierId());
                tmpP.setSpec(c.getActualMaterialSpec());
                tmpP.setUnitName(c.getActualUnitName());
                tmpP.setUnitId(c.getActualUnitId());
                tmpP.setExtParam1(c.getExtParam1());
                tmpP.setExtParam2(c.getExtParam2());
                tmpP.setSourceNum(c.getSourceNum());
                tmpP.setSourceMaterialName(c.getSourceMaterialName());
                tmpP.setSourceUnitName(c.getSourceUnitName());
                tmpP.setSourceMaterialSpec(c.getSourceMaterialSpec());
                processList.add(tmpP);
            }
        }
        for (PriceLibVO priceLibVO : processList) {
            if (priceMap.containsKey(priceLibVO.getMaterialCode())) {
                boolean breakFlag = false;
                boolean addFlag = false;
                for (MaterialBasePriceContentVO mp : (List)priceMap.get(priceLibVO.getMaterialCode())) {
                    tmp = null;
                    if (null != priceLibVO.getSupplierId() && StringUtils.isNotBlank((CharSequence)priceLibVO.getArea())) {
                        if (mp.getSupplierId().equals(priceLibVO.getSupplierId()) && mp.getArea().equals(mp.getArea())) {
                            tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            breakFlag = true;
                        }
                    } else if (null != priceLibVO.getSupplierId()) {
                        if (priceLibVO.getSupplierId().equals(mp.getSupplierId())) {
                            tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            breakFlag = true;
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)priceLibVO.getArea())) {
                        if (StringUtils.equals((CharSequence)priceLibVO.getArea(), (CharSequence)mp.getArea()) || "\u5168\u56fd".equals(priceLibVO.getArea())) {
                            tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                            tmp.setBaseMaterialPrice(mp.getBasePrice());
                            tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                            tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                            breakFlag = true;
                        }
                    } else {
                        tmp = (PriceLibVO)BeanMapper.map((Object)priceLibVO, PriceLibVO.class);
                        tmp.setId(Long.valueOf(IdWorker.getId()));
                        tmp.setBaseMaterialPrice(mp.getBasePrice());
                        tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                        tmp.setBaseTwoMaterialPrice(mp.getBaseTwoPrice());
                    }
                    if (null == tmp) continue;
                    tmp.setId(Long.valueOf(IdWorker.getId()));
                    if (priceCalcVOMap.containsKey(tmp.getMaterialTypeId())) {
                        tmp.setBaseMaterialId(((MaterialPriceCalcVO)priceCalcVOMap.get(tmp.getMaterialTypeId())).getMaterialTypeId());
                        tmp.setBaseMaterialCode(((MaterialPriceCalcVO)priceCalcVOMap.get(tmp.getMaterialTypeId())).getMaterialType());
                        tmp.setBaseMaterialName(((MaterialPriceCalcVO)priceCalcVOMap.get(tmp.getMaterialTypeId())).getMaterialTypeName());
                    }
                    if (null != tmp.getBaseMaterialId() && netPriceMap.containsKey(tmp.getBaseMaterialId())) {
                        tmp.setBaseMaterialNetPrice(((ErpMaterialPriceVO)netPriceMap.get(tmp.getBaseMaterialId())).getPrice());
                    }
                    addFlag = true;
                    actualList.add(tmp);
                    if (!breakFlag) continue;
                    break;
                }
                if (addFlag) continue;
                if (priceCalcVOMap.containsKey(priceLibVO.getMaterialTypeId())) {
                    priceLibVO.setBaseMaterialId(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeId());
                    priceLibVO.setBaseMaterialCode(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialType());
                    priceLibVO.setBaseMaterialName(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeName());
                }
                actualList.add(priceLibVO);
                continue;
            }
            if (priceCalcVOMap.containsKey(priceLibVO.getMaterialTypeId())) {
                priceLibVO.setBaseMaterialId(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeId());
                priceLibVO.setBaseMaterialCode(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialType());
                priceLibVO.setBaseMaterialName(((MaterialPriceCalcVO)priceCalcVOMap.get(priceLibVO.getMaterialTypeId())).getMaterialTypeName());
            }
            if (null != priceLibVO.getBaseMaterialId() && netPriceMap.containsKey(priceLibVO.getBaseMaterialId())) {
                priceLibVO.setBaseMaterialNetPrice(((ErpMaterialPriceVO)netPriceMap.get(priceLibVO.getBaseMaterialId())).getPrice());
            }
            priceLibVO.setId(Long.valueOf(IdWorker.getId()));
            actualList.add(priceLibVO);
        }
        return actualList;
    }

    private static /* synthetic */ void lambda$queryList$3(Map conMap, Set materialIds, Set materialCode, ComplexParam c, MaterialConjectureEntity m) {
        conMap.put(m.getActualMaterialCode() + m.getActualUnitName(), m);
        materialIds.add(m.getActualMaterialId());
        materialCode.add(m.getActualMaterialCode());
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("material_id", Parameter.getEqInstance((Object)m.getActualMaterialId()));
        if (null != m.getSupplierId()) {
            c2.getParams().put("supplier_id", Parameter.getEqInstance((Object)m.getSupplierId()));
        }
        if (null != m.getBrandId()) {
            c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
        }
        if (null != m.getBrandId()) {
            c2.getParams().put("brand_id", Parameter.getEqInstance((Object)m.getBrandId()));
        }
        c.getComplexParams().add(c2);
    }
}

