package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 物资合同-清单明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_contract_detail")
public class ContractDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="material_serial_no")
    private String materialSerialNo; // 物资流水号
    @TableField(value="contract_id")
    private Long contractId; // 合同Id
    @TableField(value="source_contract_id")
    private String sourceContractId; // ERP合同主键
    @TableField(value="source_detail_id")
    private String sourceDetailId; // ERP合同子表id
    @TableField(value = "source_brand_id")
    private String sourceBrandId;//ERP品牌主键
    @TableField(value="brand_id")
    private Long brandId; //品牌主键
    @TableField(value="brand_name")
    private String brandName; // 品牌
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value="pur_num")
    private BigDecimal purNum; // 合同数量
    @TableField(value="detail_tax_price")
    private BigDecimal detailTaxPrice; // 合同单价(含税)
    @TableField(value="detail_price")
    private BigDecimal detailPrice; // 合同单价
    @TableField(value="detail_tax_rate")
    private BigDecimal detailTaxRate; // 税率
    @TableField(value="detail_tax_mny")
    private BigDecimal detailTaxMny; // 金额(含税)
    @TableField(value="detail_mny")
    private BigDecimal detailMny; // 金额
    @TableField(value="detail_tax")
    private BigDecimal detailTax; // 税额
    @TableField(value="detail_unit_name")
    private String detailUnitName; // 计量单位
    @TableField(value="detail_unit_id")
    private Long detailUnitId; // 计量单位id
    @TableField(value="detail_remark")
    private String detailRemark; // 备注
    @TableField(value="property_value")
    private String propertyValue; // 属性
    @TableField(value = "product_code")
    private String productCode; //产品代码
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资分类编码

    @TableField(exist = false)
    private String orderCode; // 订单编号
    @TableField(exist = false)
    private Long orderId; // 订单主键


    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }

    public String getMaterialSerialNo() {
        return materialSerialNo;
    }

    public void setMaterialSerialNo(String materialSerialNo) {
        this.materialSerialNo = materialSerialNo;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getSourceContractId() {
        return sourceContractId;
    }

    public void setSourceContractId(String sourceContractId) {
        this.sourceContractId = sourceContractId;
    }
    public String getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(String sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public BigDecimal getPurNum() {
        return purNum;
    }

    public void setPurNum(BigDecimal purNum) {
        this.purNum = purNum;
    }
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public String getDetailUnitName() {
        return detailUnitName;
    }

    public void setDetailUnitName(String detailUnitName) {
        this.detailUnitName = detailUnitName;
    }
    public Long getDetailUnitId() {
        return detailUnitId;
    }

    public void setDetailUnitId(Long detailUnitId) {
        this.detailUnitId = detailUnitId;
    }
    public String getDetailRemark() {
        return detailRemark;
    }

    public void setDetailRemark(String detailRemark) {
        this.detailRemark = detailRemark;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getSourceBrandId() {
        return sourceBrandId;
    }

    public void setSourceBrandId(String sourceBrandId) {
        this.sourceBrandId = sourceBrandId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
}
