package com.ejianc.business.zdsmaterial.erp.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * 发货单-物资清单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_delivery_detail")
public class DeliveryDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="delivery_id")
    private Long deliveryId; // 发货单Id
    @TableField(value="source_detail_id")
    private Long sourceDetailId; // 订单子表id
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资分类名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资分类id
    @TableField(value="material_serial_no")
    private String materialSerialNo; // 物资流水号
    @TableField(value="contract_id")
    private Long contractId; // 所属合同id
    @TableField(value="contract_detail_id")
    private Long contractDetailId; // 合同明细id
    @TableField(value="contract_num")
    private BigDecimal contractNum; // 合同量
    @TableField(value="order_num")
    private BigDecimal orderNum; // 订单量
    @TableField(value="delivery_num")
    private BigDecimal deliveryNum; // 本次发货数量
    @TableField(value="already_num")
    private BigDecimal alreadyNum; // 已验收量
    @TableField(value="release_num")
    private BigDecimal releaseNum; // 未验收释放量（发货单全部验收时，=发货量-已验收量，释放订单发货量）
    @TableField(value="detail_tax_price")
    private BigDecimal detailTaxPrice; // 单价（含税）
    @TableField(value="detail_price")
    private BigDecimal detailPrice; // 单价
    @TableField(value="detail_tax_rate")
    private BigDecimal detailTaxRate; // 税率
    @TableField(value="detail_tax_mny")
    private BigDecimal detailTaxMny; // 金额（含税）
    @TableField(value="detail_mny")
    private BigDecimal detailMny; // 金额
    @TableField(value="detail_tax")
    private BigDecimal detailTax; // 税额
    @TableField(value="detail_unit_name")
    private String detailUnitName; // 计量单位
    @TableField(value="detail_unit_id")
    private Long detailUnitId; // 计量单位id
    @TableField(value="property_value")
    private String propertyValue; // 属性
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "product_code")
    private String productCode;

    @TableField(value = "brand_id")
    private Long brandId; //品牌主键
    @TableField(value = "brand_name")
    private String brandName; // 品牌名称
    @TableField(value="material_type_code")
    private String materialTypeCode; // 物资分类编码

    /**
     * 来源业务单据Id
     */
    @TableField(value = "source_id")
    private String sourceId;
    /**
     * 本次回写验收量
     */
    @TableField(exist = false)
    private BigDecimal checkNum;

    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getMaterialTypeCode() {
        return materialTypeCode;
    }

    public void setMaterialTypeCode(String materialTypeCode) {
        this.materialTypeCode = materialTypeCode;
    }
    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialSerialNo() {
        return materialSerialNo;
    }

    public void setMaterialSerialNo(String materialSerialNo) {
        this.materialSerialNo = materialSerialNo;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }
    public BigDecimal getDeliveryNum() {
        return deliveryNum;
    }

    public void setDeliveryNum(BigDecimal deliveryNum) {
        this.deliveryNum = deliveryNum;
    }
    public BigDecimal getAlreadyNum() {
        return alreadyNum;
    }

    public void setAlreadyNum(BigDecimal alreadyNum) {
        this.alreadyNum = alreadyNum;
    }
    public BigDecimal getReleaseNum() {
        return releaseNum;
    }

    public void setReleaseNum(BigDecimal releaseNum) {
        this.releaseNum = releaseNum;
    }
    public BigDecimal getDetailTaxPrice() {
        return detailTaxPrice;
    }

    public void setDetailTaxPrice(BigDecimal detailTaxPrice) {
        this.detailTaxPrice = detailTaxPrice;
    }
    public BigDecimal getDetailPrice() {
        return detailPrice;
    }

    public void setDetailPrice(BigDecimal detailPrice) {
        this.detailPrice = detailPrice;
    }
    public BigDecimal getDetailTaxRate() {
        return detailTaxRate;
    }

    public void setDetailTaxRate(BigDecimal detailTaxRate) {
        this.detailTaxRate = detailTaxRate;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public String getDetailUnitName() {
        return detailUnitName;
    }

    public void setDetailUnitName(String detailUnitName) {
        this.detailUnitName = detailUnitName;
    }
    public Long getDetailUnitId() {
        return detailUnitId;
    }

    public void setDetailUnitId(Long detailUnitId) {
        this.detailUnitId = detailUnitId;
    }
    public String getPropertyValue() {
        return propertyValue;
    }

    public void setPropertyValue(String propertyValue) {
        this.propertyValue = propertyValue;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
