package com.ejianc.business.zdsmaterial.pricelib.engine;


import com.ejianc.business.zdsmaterial.pricelib.engine.impl.*;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 价格计算工厂
 *
 * @Author: caojie
 * @CreateTime:2025-07-04 13:46
 * @Version: 1.0
 */
@Component
public class PricingFactory {
    private static final Map<String, PricingEngine> engines = new HashMap<>();

    static {
        // 注册计算引擎
        //默认
        registerEngine("default", new DefaultPricingEngine());
        //电力电缆
        registerEngine("D1101", new D1101PricingEngine());
        registerEngine("D1102", new D1101PricingEngine());
        registerEngine("C3001", new C3001PricingEngine());
        registerEngine("C0301", new C0301PricingEngine());
        registerEngine("C0307", new C0307PricingEngine());
        registerEngine("C18Common", new C18CommonPricingEngine());
        registerEngine("C2504", new C2504PricingEngine());
        registerEngine("C2001", new C2001PricingEngine());
    }

    public static void registerEngine(String category, PricingEngine engine) {
        engines.put(category, engine);
    }

    public static PricingEngine getEngine(String category) {
        if(category.startsWith("C18") && category.equals(" C1854") && category.equals(" C1852")) {
            return engines.getOrDefault("C18Common", engines.get("default"));
        }
        return engines.getOrDefault(category, engines.get("default"));
    }

}
