package com.ejianc.business.zdsmaterial.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.service.IContractDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IContractService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.plan.conjecture.handler.ConjectureManageFactory;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceCheckEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceContractEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.zdsmaterial.pricelib.bean.PriceSettlementEntity;
import com.ejianc.business.zdsmaterial.pricelib.enums.OutFlagEnum;
import com.ejianc.business.zdsmaterial.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceCheckService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceContractService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.zdsmaterial.pricelib.service.IPriceSettlementService;
import com.ejianc.business.zdsmaterial.pricelib.vo.*;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.DateUtils;
import com.ejianc.business.zdsmaterial.util.ParamUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 价格库-合同明细
 *
 * @author generator
 */
@Service("priceContractService")
public class PriceContractServiceImpl extends BaseServiceImpl<PriceContractMapper, PriceContractEntity> implements IPriceContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;
    @Autowired
    private IContractDetailService contractDetailService;
    //    @Autowired
//    private IShareMaterialApi materialApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    //    @Autowired
//    private ISettlementService settlementService;
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceCheckService priceCheckService;
    @Autowired
    private IPriceSettlementService priceSettlementService;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IOrgApi iOrgApi;
//    @Autowired
//    private IAssistRmatPurchaseContractApi assistRmatPurchaseContractApi;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private ConjectureManageFactory factory;

    @Value("${material.ai.handlerName:CJYT}")
    private String handlerName;

    @Autowired
    private IMaterialBasePriceContentService basePriceContentService;

    private final Integer DEFAULT_BATCH_INIT_SIZE = 10;

    @Override
    public void savePriceContractByTimingNew(Integer startPage) {
        logger.info("========================价格库合同明细定时任务执行开始===========================");
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("id", "asc");
        queryParam.getParams().put("sealed_flag",new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
        int total = contractService.count(changeToQueryWrapper(queryParam));

        queryParam.setPageSize(DEFAULT_BATCH_INIT_SIZE);
        int totalPages = total / DEFAULT_BATCH_INIT_SIZE + ((total % DEFAULT_BATCH_INIT_SIZE == 0) ? 0 : 1);
        int page = null != startPage ? startPage : 1;
        queryParam.setPageIndex(page);
        List<ContractEntity> contractList = null;

        QueryWrapper<ContractEntity> query = null;
        boolean unFinishFlag = true;
        //由于可能合同量较大，分批处理
        for(;page <= totalPages; page++) {
            try {
                logger.info("*****价格库合同明细定时任务************* 当前处理第 "+page+" 页数据 *************价格库合同明细定时任务***** ");
                queryParam.setPageIndex(page);
                query = changeToQueryWrapper(queryParam);
                query.last(" limit " + (page - 1) * DEFAULT_BATCH_INIT_SIZE + ", " + DEFAULT_BATCH_INIT_SIZE);
                contractList = contractService.list(query);
                if(CollectionUtils.isNotEmpty(contractList)) {
                    batchInitPriceContract(contractList);
                }
            } catch (Exception e) {
                logger.error("*******价格库合同明细定时任务******异常", e);
            }
        }

        logger.info("========================价格库合同明细定时任务执行结束===========================");
    }

    private void batchInitPriceContract(List<ContractEntity> contractList) {
        logger.info("查询合同数据：{}条", null != contractList ? contractList.size() : 0);
        // 合同列表为空，不处理
        if (CollectionUtils.isEmpty(contractList)) return;

        List<ContractDetailEntity> detailList = new ArrayList<>();
        // 查询总价合同明细
        List<Long> contractIds = contractList.stream().filter(x->new Integer(2).equals(x.getPriceType())).map(ContractEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(contractIds)){
            detailList = baseMapper.getContractDetailListByContractId(contractIds);
        }
        // 查询单价合同对应订单明细
        contractIds = contractList.stream().filter(x->new Integer(1).equals(x.getPriceType())).map(ContractEntity::getId).collect(Collectors.toList());
        List<ContractDetailEntity> orderList = this.transferByOrder(contractIds);
        if(CollectionUtils.isNotEmpty(orderList)){
            detailList.addAll(orderList);
        }
        // 合同明细列表为空，不处理
        if (CollectionUtils.isEmpty(detailList)) return;

        // 查询材料内码
        List<Long> materialTypeIds = detailList.stream().map(ContractDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> categoryList = categoryService.queryCategoryListByIds(materialTypeIds);
//        logger.info("查询材料内码，查询结果：{}", JSONObject.toJSONString(categoryList));
        Map<Long, String> categoryMap = categoryList.stream().collect(Collectors.toMap(
                MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));

        // 查询项目信息
        List<Long> projectIds = contractList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse<List<ProjectPoolDTO>> projectResponse = projectSetApi.getProjectListIds(projectIds);
//        logger.info("查询项目地址，查询结果：{}", JSONObject.toJSONString(projectResponse));
        Map<Long, String> areaMap = new HashMap<>();
        Map<Long, String> areaNameMap = new HashMap<>();
        if (projectResponse.isSuccess()) {
            List<ProjectPoolDTO> projectList = projectResponse.getData();
            areaMap = projectList.stream().filter(t -> StringUtils.isNotEmpty(t.getArea())).collect(
                    Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            areaNameMap = projectList.stream().filter(t -> StringUtils.isNotEmpty(t.getAreaName())).collect(
                    Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }

        // 材料明细按合同id分组
        Map<Long, List<ContractDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getContractId));
        // 处理合同及合同明细
        // 进行插入数据组装
        List<PriceContractEntity> saveList = new ArrayList<>();
        for (ContractEntity entity : contractList) {
            List<ContractDetailEntity> list = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (ContractDetailEntity detail : list) {
                // 材料id为空不做价格库处理（大类不处理）
                if (detail.getMaterialId() == null) continue;
                PriceContractEntity vo = BeanMapper.map(entity, PriceContractEntity.class);
                vo.setArea(areaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                vo.setAreaName(areaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                vo.setSourceId(entity.getId());
                vo.setSourceType("material");

                vo.setSourceDetailId(detail.getId());
//                priceContractEntity.setTargetResultId(entity.getTargetResultId());
                // 子表信息
                vo.setMaterialId(detail.getMaterialId());
                vo.setMaterialCode(detail.getMaterialCode());
                vo.setMaterialName(detail.getMaterialName());
                vo.setMaterialTypeId(detail.getMaterialTypeId());
                vo.setMaterialTypeName(detail.getMaterialTypeName());
                vo.setInnerCode(categoryMap.get(detail.getMaterialTypeId())); // 分类内码，查询获取
                vo.setSpec(detail.getPropertyValue());
                vo.setUnitId(detail.getDetailUnitId());
                vo.setUnitName(detail.getDetailUnitName());
                vo.setBrand(detail.getBrandName());
                vo.setContractNum(detail.getPurNum());
                vo.setContractPrice(detail.getDetailPrice());
                vo.setContractMny(detail.getDetailMny());
                vo.setContractTaxRate(detail.getDetailTaxRate());
                vo.setContractTaxMny(detail.getDetailTaxMny());
                vo.setContractTaxPrice(detail.getDetailTaxPrice());
                vo.setMemo(detail.getDetailRemark());
                vo.setOrderCode(detail.getOrderCode());
                vo.setOrderId(detail.getOrderId());

//                vo.setSettlementDate(settlementDateMap.get(entity.getId())); // 最终结算日
                vo.setOutFlag(OutFlagEnum.未移除.getCode());
                vo.setId(null);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
//                vo.setVersion(null);
                vo.setDr(detail.getDr());
                vo.setBillState(PlanConstant.STRING_YES.equals(entity.getSealedFlag())? 1 : 0);
                saveList.add(vo);
            }
        }

        // 查询是否为修改
        if (CollectionUtils.isEmpty(saveList)) return;
        // 查询数据库
        QueryParam priceParam = new QueryParam();
        List<Long> sourceDetailIds = saveList.stream().map(PriceContractEntity::getSourceDetailId).collect(Collectors.toList());
        priceParam.getParams().put("sourceDetailId", new Parameter(QueryParam.IN, sourceDetailIds));
        List<PriceContractEntity> priceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty(priceList)) {
            Map<Long, PriceContractEntity> priceMap = priceList.stream().collect(Collectors.toMap(
                    PriceContractEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity entity : saveList) {
                PriceContractEntity price = priceMap.get(entity.getSourceDetailId());
                if (price != null) {
                    entity.setId(price.getId());
                    entity.setOutFlag(price.getOutFlag());
                    entity.setCreateTime(price.getCreateTime());
                    entity.setCreateUserCode(price.getCreateUserCode());
                }
            }
        }
        // 批量变更保存数据
        logger.info("入库数据：{} 条", saveList.size());
        boolean saveFlag = super.saveOrUpdateBatch(saveList, saveList.size(), false);
        logger.info("价格库入库数据：{} 条，结果：{}", saveList.size(), saveFlag);
        // 删除bill_state非1和3的数据
        // 不使用物理删除，使用逻辑删除
//        QueryWrapper<PriceContractEntity> wrapper = new QueryWrapper<>();
//        wrapper.notIn("bill_state", Arrays.asList(1,3));
//        super.remove(wrapper, false);
        // 删除dr!=0的数据
        // 删除的id
        List<Long> delIds = saveList.stream().filter(t -> t.getDr() != 0).map(PriceContractEntity::getId).collect(Collectors.toList());
        logger.info("删除数据id：{} 条", delIds.size());
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, false);
        }
    }

    /**
     * 定时处理合同价格库明细
     * 如果传入日期为空，则为初始化，处理全部合同（已提交、审批通过）明细
     *
     * @param date 日期
     */
    @Override
    public void savePriceContractByTiming(Date date) {
        logger.info("========================价格库合同明细定时任务执行开始===========================");
        QueryParam queryParam = new QueryParam();
        List<ContractEntity> contractList;
        String outLogDate = "";
        if (date != null) {
            // 日期不为空，则取大于上日日期数据
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            logger.info("执行定时任务，查询参数：{}", qDate);
            // 同时查询订单最新修改日期，防止订单数据修改未更新
            QueryParam param = new QueryParam();
            Parameter parameter = new Parameter(QueryParam.GE, outLogDate);
            param.getComplexParams().add(ParamUtil.getOrParam("create_time", "update_time", "sys_last_upd", parameter));
            List<OrderEntity> orderList = orderService.queryList(param);
            if(CollectionUtils.isNotEmpty(orderList)){
                Date createTime = orderList.stream().filter(x->null != x.getCreateTime()).min((v1, v2)->DateUtil.compareDate(v1.getCreateTime(), v2.getCreateTime())).orElse(new OrderEntity()).getCreateTime();
                Date updateTime = orderList.stream().filter(x->null != x.getUpdateTime()).min((v1, v2)->DateUtil.compareDate(v1.getUpdateTime(), v2.getUpdateTime())).orElse(new OrderEntity()).getUpdateTime();
                Date min = DateUtil.minDate(createTime, updateTime, qDate);
                outLogDate = DateUtils.transformationDefaultDate(min);
            }
            queryParam.getComplexParams().add(ParamUtil.getOrParam("create_time", "update_time", "sys_last_upd", new Parameter(QueryParam.GE, outLogDate)));
//            contractEntityList = baseMapper.getContractListByTime(qDate);
        }
        else {
            // 日期为空，默认为初始化，取提交后的数据
//            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            queryParam.getParams().put("sealed_flag",new Parameter(QueryParam.EQ, PlanConstant.STRING_YES));
        }
        contractList = contractService.queryList(queryParam, false);
        logger.info("执行日期：{}，查询合同结果：{}", outLogDate, JSONObject.toJSONString(contractList));
        // 合同列表为空，不处理
        if (CollectionUtils.isEmpty(contractList)) return;

        List<ContractDetailEntity> detailList = new ArrayList<>();
        // 查询总价合同明细
        List<Long> contractIds = contractList.stream().filter(x->new Integer(2).equals(x.getPriceType())).map(ContractEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(contractIds)){
            detailList = baseMapper.getContractDetailListByContractId(contractIds);
        }
        // 查询单价合同对应订单明细
        contractIds = contractList.stream().filter(x->new Integer(1).equals(x.getPriceType())).map(ContractEntity::getId).collect(Collectors.toList());
        List<ContractDetailEntity> orderList = this.transferByOrder(contractIds);
        if(CollectionUtils.isNotEmpty(orderList)){
            detailList.addAll(orderList);
        }
        // 合同明细列表为空，不处理
        if (CollectionUtils.isEmpty(detailList)) return;

        // 查询材料内码
        List<Long> materialTypeIds = detailList.stream().map(ContractDetailEntity::getMaterialTypeId).distinct().collect(Collectors.toList());
        List<MaterialCategoryVO> categoryList = categoryService.queryCategoryListByIds(materialTypeIds);
        logger.info("查询材料内码，查询结果：{}", JSONObject.toJSONString(categoryList));
        Map<Long, String> categoryMap = categoryList.stream().collect(Collectors.toMap(
                MaterialCategoryVO::getId, MaterialCategoryVO::getInnerCode, (key1, key2) -> key2));

        // 查询项目信息
        List<Long> projectIds = contractList.stream().map(ContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse<List<ProjectPoolDTO>> projectResponse = projectSetApi.getProjectListIds(projectIds);
        logger.info("查询项目地址，查询结果：{}", JSONObject.toJSONString(projectResponse));
        Map<Long, String> areaMap = new HashMap<>();
        Map<Long, String> areaNameMap = new HashMap<>();
        if (projectResponse.isSuccess()) {
            List<ProjectPoolDTO> projectList = projectResponse.getData();
            areaMap = projectList.stream().filter(t -> StringUtils.isNotEmpty(t.getArea())).collect(
                    Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            areaNameMap = projectList.stream().filter(t -> StringUtils.isNotEmpty(t.getAreaName())).collect(
                    Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }

//        // 查询最终结算日
//        QueryParam settleParam = new QueryParam();
//        settleParam.getParams().put("contract_id", new Parameter(QueryParam.IN, contractIdList));
//        settleParam.getParams().put("signature_type", new Parameter(QueryParam.EQ, 1));
//        settleParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays
//                .asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
//                        BillStateEnum.PASSED_STATE.getBillStateCode())));
//        List<SettlementEntity> settlementEntityList = settlementService.queryList(settleParam, false);
//        Map<Long, Date> settlementDateMap = new HashMap<>();
//        if (CollectionUtils.isNotEmpty(settlementEntityList)) {
//            settlementDateMap = settlementEntityList.stream().collect(Collectors.toMap(SettlementEntity::getContractId,
//                    SettlementEntity::getSettlementDate, (key1, key2) -> key2));
//        }

        // 材料明细按合同id分组
        Map<Long, List<ContractDetailEntity>> detailMap = detailList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getContractId));
        // 处理合同及合同明细
        // 进行插入数据组装
        List<PriceContractEntity> saveList = new ArrayList<>();
        for (ContractEntity entity : contractList) {
            List<ContractDetailEntity> list = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(list)) continue;
            for (ContractDetailEntity detail : list) {
                // 材料id为空不做价格库处理（大类不处理）
                if (detail.getMaterialId() == null) continue;
                PriceContractEntity vo = BeanMapper.map(entity, PriceContractEntity.class);
                vo.setArea(areaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                vo.setAreaName(areaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                vo.setSourceId(entity.getId());
                vo.setSourceType("material");

                vo.setSourceDetailId(detail.getId());
//                priceContractEntity.setTargetResultId(entity.getTargetResultId());
                // 子表信息
                vo.setMaterialId(detail.getMaterialId());
                vo.setMaterialCode(detail.getMaterialCode());
                vo.setMaterialName(detail.getMaterialName());
                vo.setMaterialTypeId(detail.getMaterialTypeId());
                vo.setMaterialTypeName(detail.getMaterialTypeName());
                vo.setInnerCode(categoryMap.get(detail.getMaterialTypeId())); // 分类内码，查询获取
                vo.setSpec(detail.getPropertyValue());
                vo.setUnitId(detail.getDetailUnitId());
                vo.setUnitName(detail.getDetailUnitName());
                vo.setBrand(detail.getBrandName());
                vo.setContractNum(detail.getPurNum());
                vo.setContractPrice(detail.getDetailPrice());
                vo.setContractMny(detail.getDetailMny());
                vo.setContractTaxRate(detail.getDetailTaxRate());
                vo.setContractTaxMny(detail.getDetailTaxMny());
                vo.setContractTaxPrice(detail.getDetailTaxPrice());
                vo.setMemo(detail.getDetailRemark());
                vo.setOrderCode(detail.getOrderCode());
                vo.setOrderId(detail.getOrderId());

//                vo.setSettlementDate(settlementDateMap.get(entity.getId())); // 最终结算日
                vo.setOutFlag(OutFlagEnum.未移除.getCode());
                vo.setId(null);
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setUpdateTime(null);
                vo.setUpdateUserCode(null);
//                vo.setVersion(null);
                vo.setDr(detail.getDr());
                vo.setBillState(PlanConstant.STRING_YES.equals(entity.getSealedFlag())? 1 : 0);
                saveList.add(vo);
            }
        }

//        //获取周转材采购合同明细数据
//        logger.info("获取周转材数据前数据条数：" + saveEntityList.size());
//
//        //获取周转材采购数据
//        CommonResponse<List<PriceContractVO>> corpRentResponse = assistRmatPurchaseContractApi.getPriceContractDataByAssistRmatPurchase(date != null ? "1" : "0");
//        logger.info("获取周转材采购合同数据，查询结果：{}", JSONObject.toJSONString(corpRentResponse));
//        if (corpRentResponse.isSuccess()) {
//            List<PriceContractVO> corpRentContractList = corpRentResponse.getData();
//            saveEntityList.addAll(BeanMapper.mapList(corpRentContractList, PriceContractEntity.class));
//        }
//        logger.info("获取周转材数据后数据条数：" + saveEntityList.size());

        // 查询是否为修改
        if (CollectionUtils.isEmpty(saveList)) return;
        // 查询数据库
        QueryParam priceParam = new QueryParam();
        List<Long> sourceDetailIds = saveList.stream().map(PriceContractEntity::getSourceDetailId).collect(Collectors.toList());
        priceParam.getParams().put("sourceDetailId", new Parameter(QueryParam.IN, sourceDetailIds));
        List<PriceContractEntity> priceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty(priceList)) {
            Map<Long, PriceContractEntity> priceMap = priceList.stream().collect(Collectors.toMap(
                    PriceContractEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity entity : saveList) {
                PriceContractEntity price = priceMap.get(entity.getSourceDetailId());
                if (price != null) {
                    entity.setId(price.getId());
                    entity.setOutFlag(price.getOutFlag());
                    entity.setCreateTime(price.getCreateTime());
                    entity.setCreateUserCode(price.getCreateUserCode());
                }
            }
        }
        // 批量变更保存数据
        logger.info("入库数据：{}", JSONObject.toJSONString(saveList));
        super.saveOrUpdateBatch(saveList);
        // 删除bill_state非1和3的数据
        // 不使用物理删除，使用逻辑删除
//        QueryWrapper<PriceContractEntity> wrapper = new QueryWrapper<>();
//        wrapper.notIn("bill_state", Arrays.asList(1,3));
//        super.remove(wrapper, false);
        // 删除dr!=0的数据
        // 删除的id
        List<Long> delIds = saveList.stream().filter(t -> t.getDr() != 0).map(PriceContractEntity::getId).collect(Collectors.toList());
        logger.info("删除数据id：{}",JSONObject.toJSONString(delIds));
        if (CollectionUtils.isNotEmpty(delIds)) {
            super.removeByIds(delIds, false);
        }
        logger.info("========================价格库合同明细定时任务执行结束===========================");
    }

    /**
     * 查询单价合同对应订单明细
     * @param contractIds
     * @return
     */
    private List<ContractDetailEntity> transferByOrder(List<Long> contractIds) {
        if(CollectionUtils.isEmpty(contractIds)){
            return new ArrayList<>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.IN, contractIds));
        List<OrderEntity> orderList = orderService.queryList(param);
        if(CollectionUtils.isEmpty(orderList)){
            return new ArrayList<>();
        }
        Map<Long, OrderEntity> map = orderList.stream().collect(Collectors.toMap(x->x.getId(), x->x));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter(QueryParam.IN, new ArrayList<>(map.keySet())));
        List<OrderDetailEntity> detailList = orderDetailService.queryList(queryParam);
        if(CollectionUtils.isEmpty(orderList)){
            return new ArrayList<>();
        }
        List<ContractDetailEntity> result = new ArrayList<>();
        for(OrderDetailEntity detail : detailList){
            ContractDetailEntity vo = new ContractDetailEntity();
            OrderEntity order = map.get(detail.getOrderId());
            vo.setContractId(order.getContractId());
            vo.setOrderCode(order.getBillCode());
            vo.setOrderId(order.getId());

            vo.setId(detail.getId());
            vo.setDr(detail.getDr());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setPropertyValue(detail.getPropertyValue());
            vo.setProductCode(detail.getProductCode());
            vo.setDetailUnitId(detail.getDetailUnitId());
            vo.setDetailUnitName(detail.getDetailUnitName());
            vo.setBrandId(detail.getBrandId());
            vo.setBrandName(detail.getBrandName());
            vo.setPurNum(detail.getDetailNum());
            vo.setDetailPrice(detail.getDetailPrice());
            vo.setDetailTaxPrice(detail.getDetailTaxPrice());
            vo.setDetailMny(detail.getDetailMny());
            vo.setDetailTaxMny(detail.getDetailTaxMny());
            vo.setDetailTax(detail.getDetailTax());
            vo.setDetailTaxRate(detail.getDetailTaxRate());
            vo.setDetailRemark(detail.getMemo());
            result.add(vo);
        }
        return result;
    }

    /**
     * 查询价格库汇总信息
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        Map<Long, MaterialConjectureVO> searchList = new HashMap<>();
        if(param.getParams().containsKey("searchAI")) {
            List<Long> materialIds = null;
            searchList.putAll(factory.similarSearch(handlerName, param.getParams().get("searchAI").getValue().toString(), null, new String[0]));
            if(MapUtils.isNotEmpty(searchList)) {
                materialIds = new ArrayList<>(searchList.keySet());
            } else {
                materialIds = Collections.singletonList(-9L);
            }
            param.getParams().put("materialId", Parameter.getInInstance(materialIds));
            param.getParams().remove("searchAI");
        }

        // 初始化参数
        logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        } else {
            throw new BusinessException("查询日期不能为空");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        if(param.getParams().containsKey("searchAI") && !searchList.isEmpty()) {
            for(PriceLibVO p :priceLibList) {
                if(searchList.containsKey(p.getMaterialId())) {
                    p.setSimilarCoefficient(searchList.get(p.getMaterialId()).getSimilarCoefficient());
                }
            }
            priceLibList.sort((v1, v2) -> ComputeUtil.safeSub(v2.getSimilarCoefficient(), v1.getSimilarCoefficient()).intValue());
        }
        logger.info("查询价格库，返回：{}", JSONObject.toJSONString(priceLibList));


        //获取所有物料
        Map<String, List<MaterialBasePriceContentVO>> priceMap = new HashMap<>();
        List<String> materialCodes = new ArrayList<>(priceLibList.stream().map(PriceLibVO::getMaterialCode).collect(Collectors.toSet()));
        if(CollectionUtils.isNotEmpty(materialCodes)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("materialCode", Parameter.getInInstance(materialCodes));
            queryParam.getParams().put("status", Parameter.getEqInstance("1"));

            List<MaterialBasePriceContentVO> basePriceContentVOS = basePriceContentService.getLatestPrice(queryParam);
            if(CollectionUtils.isNotEmpty(basePriceContentVOS)) {
                priceMap = basePriceContentVOS.stream().collect(Collectors.groupingBy(MaterialBasePriceContentVO::getMaterialCode));
            }
        }

        List<PriceLibVO> actualList = new ArrayList<>();
        PriceLibVO tmp = null;
        for(PriceLibVO p :priceLibList) {
            if(priceMap.containsKey(p.getMaterialCode())) {
                for(MaterialBasePriceContentVO mp : priceMap.get(p.getMaterialCode())) {
                    tmp = BeanMapper.map(p, PriceLibVO.class);
                    tmp.setId(IdWorker.getId());
                    //设置品牌等信息
                    tmp.setBrand(mp.getBrandName());
                    tmp.setSupplierName(mp.getSupplierName());
                    tmp.setArea(mp.getArea());
                    tmp.setAreaName(mp.getAreaName());
                    tmp.setBaseMaterialPrice(mp.getBasePrice());
                    tmp.setBaseMaterialUnitPrice(mp.getBaseOriginPrice());
                    actualList.add(tmp);
                }
            } else {
                actualList.add(p);
            }
        }

        IPage<PriceLibVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), actualList.size());

        // 进行分页处理
        pageDate.setRecords(actualList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).map(item -> {
                    if(searchList.containsKey(item.getMaterialId())) {
                        item.setSimilarCoefficient(searchList.get(item.getMaterialId()).getSimilarCoefficient());
                    }
                    return item;
                }).collect(Collectors.toList()));
        return pageDate;
    }

    /**
     * 查询价格库汇总信息
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public List<PriceLibVO> queryPriceLibListByTimeExcel(QueryParam param) {
        // 初始化参数
        logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        }
        else {
            throw new BusinessException("查询日期不能为空");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList;
    }

    /**
     * 根据材料id查询价格库信息
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceLibList)) throw new BusinessException("查询详情失败！");
        return priceLibList.get(0);
    }

    /**
     * 查询价格库信息（无权限）
     *
     * @param startDate      开始日期
     * @param endDate        结束日期
     * @param materialTypeId 材料分类id
     * @return 查询结果
     */
    @Override
    public List<PriceLibVO> queryPriceLibList(Date startDate, Date endDate, String materialTypeId) {
        QueryParam queryParam = new QueryParam();
//        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, materialTypeId));
        if (StringUtils.isNotEmpty(materialTypeId)) {
            String[] materialTypeIdList = materialTypeId.split(",");
//            queryParam.getParams().put("materialTypeId", new Parameter(QueryParam.IN, materialTypeIdList));
            ComplexParam c1 = new ComplexParam();
            c1.setLogic(ComplexParam.AND);
            for (String str : materialTypeIdList) {
                ComplexParam c2 = new ComplexParam();
                c2.setLogic(ComplexParam.OR);
                c2.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, str));
                c1.getComplexParams().add(c2);
            }
            queryParam.getComplexParams().add(c1);
        }
        return this.queryPriceLibListAll(startDate, endDate, null, queryParam);
    }

    /**
     * 根据材料id查询对应的价格库合同明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate",QueryParam.DESC);
            param.getOrderMap().put("contractMny",QueryParam.DESC);
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        List<PriceContractVO> voList;
        IPage<PriceContractVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) return pageDate;
        voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
//        voList.sort(Comparator.comparing(PriceContractVO::getSignDate).reversed()
//                .thenComparing(PriceContractVO::getContractMny).reversed().reversed());
//        voList.sort(Comparator.comparing(PriceContractVO::getSignDate).reversed());
        // 处理URL
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            int targetType = vo.getTargetResultId() == null ? 1 : 0;
            String url = "/ejc-zdsmaterial-frontend/#/contract/card?id="
                    + vo.getSourceId() + "&supplementFlag=" + vo.getSupplementFlag()
                    + "&performanceStatus=" + vo.getPerformanceStatus() + "&targetType=" + targetType;
//            if (MaterialContractTypeEnum.混凝土.getCode().equals(vo.getContractType())) {
//                url = "/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id="
//                        + vo.getSourceId() + "&supplementFlag=" + vo.getSupplementFlag()
//                        + "&performanceStatus=" + vo.getPerformanceStatus() + "&targetType=" + targetType;
//            }
            String orderUrl = null;
            if(null != vo.getOrderId()){
                orderUrl = "/ejc-zdsmaterial-frontend/#/order/card?id=" + vo.getOrderId();
            }
            if (myOrgList.contains(vo.getOrgId())) {
                vo.setContractUrl(url);
                vo.setOrderUrl(orderUrl);
            }
        }
        // 进行分页处理
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    /**
     * 根据材料id查询对应的价格库验收明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<PriceCheckVO> queryPriceCheckListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("checkDate",QueryParam.DESC);
            param.getOrderMap().put("checkMny",QueryParam.DESC);
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceCheckEntity> list = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        List<PriceCheckVO> voList;
        IPage<PriceCheckVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        if (CollectionUtils.isEmpty(list)) return pageDate;
        voList = BeanMapper.mapList(list, PriceCheckVO.class);
//        voList.sort(Comparator.comparing(PriceCheckVO::getCheckDate).reversed()
//                .thenComparing(PriceCheckVO::getCheckMny).reversed().reversed());
        // 处理URL
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceCheckVO vo : voList) {
            String url = "/ejc-zdsmaterial-frontend/#/accept/card?id=" + vo.getSourceId();
//            // 验收类型（0-消耗材有合同验收，1-消耗材无合同验收,2-混凝土有合同验收,3-混凝土无合同验收）
//            if (vo.getCheckType() == 0) {
//                url = "/ejc-zdsmaterial-frontend/#/check/contractCard?id=" + vo.getSourceId();
//            }
//            else if (vo.getCheckType() == 1) {
//                url = "/ejc-zdsmaterial-frontend/#/check/card?id=" + vo.getSourceId();
//            }
//            else if (vo.getCheckType() == 2) {
//                url = "/ejc-zdsmaterial-frontend/#/concreteCheck/contractCard?id=" + vo.getSourceId();
//            }
//            else if (vo.getCheckType() == 3) {
//                url = "/ejc-zdsmaterial-frontend/#/concreteCheck/card?id=" + vo.getSourceId();
//            }
            if (myOrgList.contains(vo.getOrgId())) {
                vo.setCheckUrl(url);
            }
        }
        // 进行分页处理
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    /**
     * 根据材料id查询对应的价格库结算明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<PriceSettlementVO> queryPriceSettleListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("settlementDate",QueryParam.DESC);
            param.getOrderMap().put("settleMny",QueryParam.DESC);
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceSettlementEntity> list = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        List<PriceSettlementVO> voList;
        IPage<PriceSettlementVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), list.size());
        if (CollectionUtils.isEmpty(list)) return pageDate;
        // 相同结算单、相同材料、相同单价、相同税率合并
        // 按照结算单id分组
        Map<String, PriceSettlementEntity> map = new HashMap<>();
        for (PriceSettlementEntity entity : list) {
            String key = String.valueOf(entity.getSourceId()) + entity.getMaterialId() +
                    entity.getSettlePrice() + entity.getSettleTaxRate();
            if (map.containsKey(key)) {
                PriceSettlementEntity value = map.get(key);
                value.setSettleNum(value.getSettleNum().add(entity.getSettleNum()));
                value.setSettleMny(value.getSettleMny().add(entity.getSettleMny()));
                value.setSettleTaxMny(value.getSettleTaxMny().add(entity.getSettleTaxMny()));
                value.setMemo(value.getMemo() + "," + value.getMemo());
            }
            else {
                map.put(key, entity);
            }
        }
        voList = BeanMapper.mapList(new ArrayList<>(map.values()), PriceSettlementVO.class);
        pageDate.setTotal(voList.size());
//        voList.sort(Comparator.comparing(PriceSettlementVO::getSettlementDate).reversed()
//                .thenComparing(PriceSettlementVO::getSettleMny).reversed().reversed());
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceSettlementVO vo : voList) {
            // 类型（0-物资采购结算单，1-混凝土结算单）
            String url = null;
            if (vo.getSettlementType() == 0) {
                if (vo.getContractId() == null) {
                    url = "/ejc-promaterial-frontend/#/settlementList/settlementNoCard?id=" + vo.getSourceId();
                }
                else {
                    url = "/ejc-promaterial-frontend/#/settlementList/settlementCard?id=" + vo.getSourceId();
                }
            }
            else if (vo.getSettlementType() == 1) {
                if (vo.getContractId() == null) {
                    url = "/ejc-promaterial-frontend/#/concreteSettlementList/settlementNoCard?id=" + vo.getSourceId();
                }
                else {
                    url = "/ejc-promaterial-frontend/#/concreteSettlementList/settlementCard?id=" + vo.getSourceId();
                }
            }
            if (myOrgList.contains(vo.getOrgId())) {
                vo.setSettleUrl(url);
            }
        }
        // 进行分页处理
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    /**
     * 查询价格趋势图
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceTrendVo> rtnList;
        // list转Map，同一天只会有一个价格
        Map<String, PriceTrendVo> trendMap = new HashMap<>();
        // 查询价格库合同明细
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream()
                    .collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List<BigDecimal> priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List<BigDecimal> taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = ComputeUtil.safeAdd(num, entity.getContractNum());
                    mny = ComputeUtil.safeAdd(mny,entity.getContractMny());
                    taxMny = ComputeUtil.safeAdd(taxMny,entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                    taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                }
                PriceTrendVo vo;
                String dateStr = DateUtils.transformationDefaultDate(entry.getKey());
                if (trendMap.containsKey(dateStr)) {
                    vo = trendMap.get(dateStr);
                }
                else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractMinPrice(Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractTaxMinPrice(Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        // map转list
        rtnList = new ArrayList<>(trendMap.values());
        // 按照日期排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    /**
     * 查询验收价格趋势图
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public List<PriceTrendVo> queryPriceTrendCheckList(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceTrendVo> rtnList;
        // list转Map，同一天只会有一个价格
        Map<String, PriceTrendVo> trendMap = new HashMap<>();
        List<PriceCheckEntity> checkList = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(checkList)) {
            Map<Date, List<PriceCheckEntity>> priceCheckMap = checkList.stream()
                    .collect(Collectors.groupingBy(PriceCheckEntity::getCheckDate));
            for (Map.Entry<Date, List<PriceCheckEntity>> entry : priceCheckMap.entrySet()) {
                List<PriceCheckEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceCheckEntity priceCheckEntity = list.get(0);
                List<BigDecimal> priceList = list.stream().map(PriceCheckEntity::getCheckPrice).collect(Collectors.toList());
                List<BigDecimal> taxPriceList = list.stream().map(PriceCheckEntity::getCheckTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceCheckEntity entity : list) {
                    num = num.add(entity.getCheckNum());
                    mny = mny.add(entity.getCheckMny());
                    taxMny = taxMny.add(entity.getCheckTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                    taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                }
                PriceTrendVo vo;
                String dateStr = DateUtils.transformationDefaultDate(entry.getKey());
                if (trendMap.containsKey(dateStr)) {
                    vo = trendMap.get(dateStr);
                }
                else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setCheckPrice(priceCheckEntity.getCheckPrice());
                vo.setCheckTaxPrice(priceCheckEntity.getCheckTaxPrice());
                vo.setCheckNum(num);
                vo.setCheckAvgPrice(avgPrice);
                vo.setCheckMaxPrice(Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setCheckMinPrice(Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setCheckTaxAvgPrice(taxAvgPrice);
                vo.setCheckTaxMaxPrice(Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setCheckTaxMinPrice(Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setPriceDate(dateStr);
            }
        }
        // map转list
        rtnList = new ArrayList<>(trendMap.values());
        // 按照日期排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    /**
     * 查询结算价格趋势图
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public List<PriceTrendVo> queryPriceTrendSettleList(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceTrendVo> rtnList;
        // list转Map，同一天只会有一个价格
        Map<String, PriceTrendVo> trendMap = new HashMap<>();
        // 查询结算信息
        List<PriceSettlementEntity> settleList = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(settleList)) {
            Map<Date, List<PriceSettlementEntity>> settleMap = settleList.stream()
                    .collect(Collectors.groupingBy(PriceSettlementEntity::getSettlementDate));
            for (Map.Entry<Date, List<PriceSettlementEntity>> entry : settleMap.entrySet()) {
                List<PriceSettlementEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceSettlementEntity settlementEntity = list.get(0);
                List<BigDecimal> priceList = list.stream().map(PriceSettlementEntity::getSettlePrice).collect(Collectors.toList());
                List<BigDecimal> taxPriceList = list.stream().map(PriceSettlementEntity::getSettleTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceSettlementEntity entity : list) {
                    num = num.add(entity.getSettleNum());
                    mny = mny.add(entity.getSettleMny());
                    taxMny = taxMny.add(entity.getSettleTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                    taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                }
                PriceTrendVo vo;
                String dateStr = DateUtils.transformationDefaultDate(entry.getKey());
                if (trendMap.containsKey(dateStr)) {
                    vo = trendMap.get(dateStr);
                }
                else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setSettlePrice(settlementEntity.getSettlePrice());
                vo.setSettleTaxPrice(settlementEntity.getSettleTaxPrice());
                vo.setSettleNum(num);
                vo.setSettleAvgPrice(avgPrice);
                vo.setSettleMaxPrice(Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setSettleMinPrice(Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setSettleTaxAvgPrice(taxAvgPrice);
                vo.setSettleTaxMaxPrice(Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setSettleTaxMinPrice(Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setPriceDate(dateStr);
            }
        }
        // map转list
        rtnList = new ArrayList<>(trendMap.values());
        // 按照日期排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    /**
     * 移除合同明细
     *
     * @param id 明细id
     */
    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = super.selectById(id);
        if (entity == null) throw new BusinessException("明细不存在");
        entity.setOutFlag(OutFlagEnum.已移除.getCode());
        super.saveOrUpdate(entity, false);
    }

    /**
     * 移除验收明细
     *
     * @param id 明细id
     */
    @Override
    public void removePriceCheckDetail(Long id) {
        PriceCheckEntity entity = priceCheckService.selectById(id);
        if (entity == null) throw new BusinessException("明细不存在");
        entity.setOutFlag(OutFlagEnum.已移除.getCode());
        priceCheckService.saveOrUpdate(entity, false);
    }

    /**
     * 移除结算明细
     *
     * @param id 明细id
     */
    @Override
    public void removePriceSettleDetail(Long id) {
        PriceSettlementEntity entity = priceSettlementService.selectById(id);
        if (entity == null) throw new BusinessException("明细不存在");
        entity.setOutFlag(OutFlagEnum.已移除.getCode());
        priceSettlementService.saveOrUpdate(entity, false);
    }

    /**
     * 校验查询条件
     *
     * @param param 查询条件
     * @return 日期
     */
    private Map<String, Date> checkQueryParam(QueryParam param) {
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        }
        else {
            throw new BusinessException("查询日期不能为空");
        }
        if (!paramMap.containsKey("materialId")) {
            throw new BusinessException("查询材料不能为空！");
        }
        Map<String, Date> rtnMap = new HashMap<>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    /**
     * 查询价格库信息(参照查询列表查询都走此方法)
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param orgIdList 查询结果
     * @param param     查询条件
     * @return 查询结果
     */
    @Override
    public List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList,
                                                 QueryParam param) {

        // 查询合同信息
//        priceLibList.addAll(this.queryPriceContractGroupByMaterialId(priceLibList, startDate, orgIdList, param));
//        priceLibList.addAll(this.queryPriceCheckGroupByMaterialId(priceLibList, startDate, endDate, orgIdList,
//        param));
//        priceLibList.addAll(this.queryPriceSettlementGroupByMaterialId(priceLibList, startDate, endDate, orgIdList,
//        param));
        Map<Long, PriceLibVO> map = new HashMap<>();
        this.queryPriceContractGroupByMaterialId(map, startDate, orgIdList, param);
        logger.info("查询合同后结果：{}", JSONObject.toJSONString(map));
        this.queryPriceCheckGroupByMaterialId(map, startDate, endDate, orgIdList, param);
        logger.info("查询验收后结果：{}", JSONObject.toJSONString(map));
        this.queryPriceSettlementGroupByMaterialId(map, startDate, endDate, orgIdList, param);
        logger.info("查询结算后结果：{}", JSONObject.toJSONString(map));
        this.queryPriceGuide(map);
        logger.info("查询指导价后结果：{}", JSONObject.toJSONString(map));
        List<PriceLibVO> priceLibList = new ArrayList<>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
//            priceLibList.sort(Comparator.comparing(PriceLibVO::getMaterialName, Comparator.nullsLast(String::compareTo)));
            priceLibList.sort(Comparator.comparing(PriceLibVO::getMaterialCode, Comparator.nullsLast(String::compareTo)));
        }
        logger.info("查询后结果：{}", JSONObject.toJSONString(priceLibList));
        return priceLibList;
    }

    /**
     * 查询符合条件的价格库合同明细
     *
     * @param startDate 开始日期
     * @param orgIdList 权限列表
     * @param param     查询参数
     * @return 查询结果
     */
    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList,
                                                             QueryParam param) {
        // 截止到当前日期状态为履约中的合同+已终止、已结束的合同取对应最终结算日期大于等于开始日期的合同
        QueryParam contractParam = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter(QueryParam.EQ, OutFlagEnum.未移除.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty(param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
//        ComplexParam c1 = new ComplexParam();
//        c1.setLogic(ComplexParam.AND);
//        // 履约中
//        ComplexParam c2 = new ComplexParam();
//        c2.setLogic(ComplexParam.OR);
//        c2.getParams().put("performance_status", new Parameter(QueryParam.EQ, 2));
//        c1.getComplexParams().add(c2);
//        // 已终止+已结束  最终结算日期大于等于开始日期的合同
//        ComplexParam c3 = new ComplexParam();
//        c3.setLogic(ComplexParam.OR);
//        c3.getParams().put("performance_status", new Parameter(QueryParam.IN, Arrays.asList(3, 6)));
//        c3.getParams().put("settlement_date", new Parameter(QueryParam.GE, startDate));
//        c1.getComplexParams().add(c3);
//        contractParam.getComplexParams().add(c1);
        logger.info("查询合同价格库，查询参数：{}", JSONObject.toJSONString(contractParam));
        return super.queryList(contractParam, false);
    }

    public BigDecimal getHighFrequencyPrice(List<BigDecimal> priceList){
        HashMap<BigDecimal,Integer> map = Maps.newHashMap();
        Integer MaxNum = 0;
        BigDecimal HighFrequencyPrice = null;
        for(BigDecimal price:priceList){
            if(map.containsKey(price)){
                Integer num = map.get(price)+1;
                map.put(price,num);
                if(num>MaxNum){
                    MaxNum = num;
                    HighFrequencyPrice = price;
                }
            }else{
                map.put(price,1);
            }
        }
        return HighFrequencyPrice;
    }
    /**
     * 查询符合条件的价格库验收明细
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param orgIdList 权限列表
     * @param param     查询参数
     * @return 查询结果
     */
    private List<PriceCheckEntity> queryPriceCheckList(Date startDate, Date endDate,
                                                       List<Long> orgIdList, QueryParam param) {
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        queryParam.setSearchText(param.getSearchText());
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("outFlag", new Parameter(QueryParam.EQ, OutFlagEnum.未移除.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        }
        if (param != null) {
            queryParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty(param.getComplexParams())) {
                queryParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                queryParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        if(null != startDate && null != endDate) {
            String sb = DateUtils.transformationDefaultDate(startDate) + "," +
                    DateUtils.transformationDefaultDate(endDate);
            queryParam.getParams().put("checkDate", new Parameter(QueryParam.BETWEEN, sb));
        }

        logger.info("查询验收价格库，查询参数：{}", JSONObject.toJSONString(queryParam));
        return priceCheckService.queryList(queryParam, false);
    }

    /**
     * 查询价格库验收信息
     *
     * @param libMap    价格库列表
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param orgIdList 权限列表
     * @return 查询结果
     */
    private void queryPriceCheckGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate,
                                                  Date endDate, List<Long> orgIdList, QueryParam param) {
        List<PriceCheckEntity> checkList = this.queryPriceCheckList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(checkList)) return;
        // 按照材料Id分组
        Map<Long, List<PriceCheckEntity>> priceCheckMap = checkList.stream()
                .collect(Collectors.groupingBy(PriceCheckEntity::getMaterialId));
        // 按照材料Id分组(每个材料只有一行)
        // 汇总信息
        for (Map.Entry<Long, List<PriceCheckEntity>> entry : priceCheckMap.entrySet()) {
            Long key = entry.getKey();
            List<PriceCheckEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().filter(item -> null != item.getCheckPrice()).map(PriceCheckEntity::getCheckPrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().filter(item -> null != item.getCheckTaxPrice()).map(PriceCheckEntity::getCheckTaxPrice).collect(Collectors.toList());
            // 获取高频单价
            BigDecimal highFrequencyPrice =   getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice =   getHighFrequencyPrice(taxPriceList);
            PriceCheckEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO; // 数量
            BigDecimal mny = BigDecimal.ZERO; // 金额(无税)
            BigDecimal taxRate = BigDecimal.ZERO; // 税率
            BigDecimal taxMny = BigDecimal.ZERO; // 金额(含税)
            BigDecimal avgPrice = BigDecimal.ZERO; // 合同均价(无税)
            // 合同最高价(无税)
            BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价(无税)
            BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String priceArea = minPrice + "-" + maxPrice; // 合同价格区间（无税）
            BigDecimal taxAvgPrice = BigDecimal.ZERO; // 合同均价（含税）
            // 合同最高价（含税）
            BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价（含税）
            BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice; // 合同价格区间（含税）
            for (PriceCheckEntity entity : value) {
                num = num.add(entity.getCheckNum()==null?BigDecimal.ZERO:entity.getCheckNum());
                mny = mny.add(entity.getCheckMny()==null?BigDecimal.ZERO:entity.getCheckMny());
                taxMny = taxMny.add(entity.getCheckTaxMny()==null?BigDecimal.ZERO:entity.getCheckTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            PriceLibVO priceLibVO;
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            }
            else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setCheckNum(num);
            priceLibVO.setCheckMny(mny);
            priceLibVO.setCheckTaxRate(taxRate);
            priceLibVO.setCheckTaxMny(taxMny);
            priceLibVO.setCheckAvgPrice(avgPrice);
            priceLibVO.setCheckMaxPrice(maxPrice);
            priceLibVO.setCheckMinPrice(minPrice);
            priceLibVO.setCheckPriceArea(priceArea);
            priceLibVO.setCheckTaxAvgPrice(taxAvgPrice);
            priceLibVO.setCheckTaxMaxPrice(taxMaxPrice);
            priceLibVO.setCheckTaxMinPrice(taxMinPrice);
            priceLibVO.setCheckTaxPriceArea(taxPriceArea);
            priceLibVO.setCheckHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setCheckHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setCheckTax(taxMny.subtract(mny));
        }
    }

    /**
     * 查询符合条件的价格库结算信息
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param orgIdList 权限列表
     * @param param     查询参数
     * @return 查询结果
     */
    private List<PriceSettlementEntity> queryPriceSettlementList(Date startDate, Date endDate,
                                                                 List<Long> orgIdList, QueryParam param) {
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("areaName");
        queryParam.setSearchText(param.getSearchText());
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("outFlag", new Parameter(QueryParam.EQ, OutFlagEnum.未移除.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        }
        if (param != null) {
            queryParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty(param.getComplexParams())) {
                queryParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                queryParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        if(null != startDate && null != endDate) {
            String sb = DateUtils.transformationDefaultDate(startDate) + "," +
                    DateUtils.transformationDefaultDate(endDate);
            queryParam.getParams().put("settlementDate", new Parameter(QueryParam.BETWEEN, sb));
        }

        logger.info("查询结算价格库，查询参数：{}", JSONObject.toJSONString(queryParam));
        return priceSettlementService.queryList(queryParam, false);
    }

    /**
     * 查询价格库结算信息
     *
     * @param libMap    价格库列表
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param orgIdList 权限列表
     * @return 查询结果
     */
    private void queryPriceSettlementGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate,
                                                       Date endDate, List<Long> orgIdList, QueryParam param) {
        List<PriceSettlementEntity> settleList = this.queryPriceSettlementList(startDate, endDate, orgIdList, param);
        if (CollectionUtils.isEmpty(settleList)) return;
        // 按照材料Id分组
        Map<Long, List<PriceSettlementEntity>> priceCheckMap = settleList.stream()
                .collect(Collectors.groupingBy(PriceSettlementEntity::getMaterialId));
        // 按照材料Id分组(每个材料只有一行)
        // 汇总信息
        for (Map.Entry<Long, List<PriceSettlementEntity>> entry : priceCheckMap.entrySet()) {
            Long key = entry.getKey();
            List<PriceSettlementEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().map(PriceSettlementEntity::getSettlePrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().map(PriceSettlementEntity::getSettleTaxPrice).collect(Collectors.toList());
            // 获取高频单价
            BigDecimal highFrequencyPrice =   getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice =   getHighFrequencyPrice(taxPriceList);
            PriceSettlementEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO; // 数量
            BigDecimal mny = BigDecimal.ZERO; // 金额(无税)
            BigDecimal taxRate = BigDecimal.ZERO; // 税率
            BigDecimal taxMny = BigDecimal.ZERO; // 金额(含税)
            BigDecimal avgPrice = BigDecimal.ZERO; // 合同均价(无税)
            // 合同最高价(无税)
            BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价(无税)
            BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String priceArea = minPrice + "-" + maxPrice; // 合同价格区间（无税）
            BigDecimal taxAvgPrice = BigDecimal.ZERO; // 合同均价（含税）
            // 合同最高价（含税）
            BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价（含税）
            BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice; // 合同价格区间（含税）
            for (PriceSettlementEntity entity : value) {
                num = ComputeUtil.safeAdd(num, entity.getSettleNum());
                mny = ComputeUtil.safeAdd(mny,entity.getSettleMny());
                taxMny = ComputeUtil.safeAdd(taxMny,entity.getSettleTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = ComputeUtil.safeDiv(mny, num).setScale(4, BigDecimal.ROUND_HALF_UP); //.divide(, 4, BigDecimal.ROUND_HALF_UP);
                taxAvgPrice = ComputeUtil.safeDiv(taxMny, num).setScale(4, BigDecimal.ROUND_HALF_UP);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            PriceLibVO priceLibVO;
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            }
            else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setSettleNum(num);
            priceLibVO.setSettleMny(mny);
            priceLibVO.setSettleTaxRate(taxRate);
            priceLibVO.setSettleTaxMny(taxMny);
            priceLibVO.setSettleAvgPrice(avgPrice);
            priceLibVO.setSettleMaxPrice(maxPrice);
            priceLibVO.setSettleMinPrice(minPrice);
            priceLibVO.setSettlePriceArea(priceArea);
            priceLibVO.setSettleTaxAvgPrice(taxAvgPrice);
            priceLibVO.setSettleTaxMaxPrice(taxMaxPrice);
            priceLibVO.setSettleTaxMinPrice(taxMinPrice);
            priceLibVO.setSettleTaxPriceArea(taxPriceArea);
            priceLibVO.setSettleHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setSettleHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setSettleTax(taxMny.subtract(mny));
        }
    }

    /**
     * 查询物资指导价
     *
     * @param libMap 价格库信息
     */
    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) return;
        List<Long> materialIdList = new ArrayList<>(libMap.keySet());
        List<PriceGuideDetailEntity> list = priceGuideDetailService.queryPriceGuideDetailByMaterialIds(materialIdList);
        if (CollectionUtils.isEmpty(list)) return;
        Map<Long, PriceGuideDetailEntity> guideMap = list.stream().collect(Collectors
                .toMap(PriceGuideDetailEntity::getMaterialId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long materialId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (guideMap.containsKey(materialId)) {
                PriceGuideDetailEntity guide = guideMap.get(materialId);
                BigDecimal min = guide.getMinMny() == null ? BigDecimal.ZERO : guide.getMinMny();
                BigDecimal max = guide.getMaxMny() == null ? BigDecimal.ZERO : guide.getMaxMny();
                min = min.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                max = max.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                vo.setGuidePriceArea(min + "-" + max);
            }
        }
    }

    /**
     * 查询组织权限
     *
     * @return 权限列表
     */
    @Override
    public List<Long> queryOrgIdList() {
        CommonResponse<List<Long>> orgIdListResponse = priceDepotPowerSetApi
                .queryOrgList(InvocationInfoProxy.getOrgId());
        logger.info("查询组织权限，查询结果：{}", JSONObject.toJSONString(orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("查询组织权限失败:" + orgIdListResponse.getMsg());
        }
        return orgIdListResponse.getData();
    }

    /**
     * 查询当前组织本下
     * @return 组织本下list
     */
    private List<Long> getMyOrgList() {
        CommonResponse<List<OrgVO>> orgVOResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<OrgVO> orgVOList = orgVOResp.getData();
        if (CollectionUtils.isNotEmpty(orgVOList)) {
            return orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }

    /**
     * 计算税率（（含税/无税 - 1）*100）
     *
     * @param taxMny 含税金额
     * @param mny    无税金额
     * @return 税率
     */
    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, BigDecimal.ROUND_HALF_UP).subtract(BigDecimal.ONE).multiply(b);
    }

    /**
     * 查询合同价格库信息
     *
     * @param libMap    价格库组装列表
     * @param startDate 开始日期
     * @param orgIdList 权限列表
     * @return 合同价格库列表
     */
    private void queryPriceContractGroupByMaterialId(Map<Long, PriceLibVO> libMap, Date startDate,
                                                     List<Long> orgIdList, QueryParam param) {
        // 截止到当前日期状态为履约中的合同+已终止、已结束的合同取对应最终结算日期大于等于开始日期的合同
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
//        logger.info("priceContractList-----"+JSONObject.toJSONString(priceContractList));
        if (CollectionUtils.isEmpty(priceContractList)) return;
        // 按照材料Id分组
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream()
                .collect(Collectors.groupingBy(PriceContractEntity::getMaterialId));
//        logger.info("priceContractMap-----"+JSONObject.toJSONString(priceContractMap));
        // 按照材料Id分组(每个材料只有一行)
//        Map<Long, List<PriceLibVO>> libMap = priceLibList.stream()
//                .collect(Collectors.groupingBy(PriceLibVO::getMaterialId));
        // 汇总信息
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().filter(item -> null != item.getContractPrice()).map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().filter(item -> null != item.getContractTaxPrice()).map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            if(key==1501897401892007938L){
                logger.info("单价-----"+JSONObject.toJSONString(priceList));
                logger.info("含税单价-----"+JSONObject.toJSONString(taxPriceList));
            }
            // 获取高频单价
            BigDecimal highFrequencyPrice =   getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice =   getHighFrequencyPrice(taxPriceList);

            if(key==1501897401892007938L){
                logger.info("高频单价-----"+JSONObject.toJSONString(highFrequencyPrice));
                logger.info("高频含税单价-----"+JSONObject.toJSONString(highFrequencyTaxPrice));
            }
            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO; // 数量
            BigDecimal mny = BigDecimal.ZERO; // 金额(无税)
            BigDecimal taxRate = BigDecimal.ZERO; // 税率
            BigDecimal taxMny = BigDecimal.ZERO; // 金额(含税)
            BigDecimal avgPrice = BigDecimal.ZERO; // 合同均价(无税)
            // 合同最高价(无税)
            BigDecimal maxPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
            // 合同最低价(无税)
            BigDecimal minPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
            String priceArea = minPrice + "-" + maxPrice; // 合同价格区间（无税）
            BigDecimal taxAvgPrice = BigDecimal.ZERO; // 合同均价（含税）
            // 合同最高价（含税）
            BigDecimal taxMaxPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
            // 合同最低价（含税）
            BigDecimal taxMinPrice = CollectionUtils.isNotEmpty(priceList) ? Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP) : BigDecimal.ZERO;
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice; // 合同价格区间（含税）
            for (PriceContractEntity entity : value) {
                num = ComputeUtil.safeAdd(num,entity.getContractNum());
                mny = ComputeUtil.safeAdd(mny,entity.getContractMny());
                taxMny = ComputeUtil.safeAdd(taxMny,entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            PriceLibVO priceLibVO;
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            }
            else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setMaterialId(priceContract.getMaterialId());
                priceLibVO.setMaterialCode(priceContract.getMaterialCode());
                priceLibVO.setMaterialName(priceContract.getMaterialName());
                priceLibVO.setMaterialTypeId(priceContract.getMaterialTypeId());
                priceLibVO.setMaterialTypeName(priceContract.getMaterialTypeName());
                priceLibVO.setSpec(priceContract.getSpec());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setInnerCode(priceContract.getInnerCode());
                libMap.put(priceContract.getMaterialId(), priceLibVO);
            }
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
            priceLibVO.setContractHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setContractHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setContractTax(taxMny.subtract(mny));
        }
    }
}
