/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.accept.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.accept.AcceptVO;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.accept.service.IAcceptService;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.business.zdsstore.api.IStoreManageApi;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.business.zdssupplier.sub.api.ISubSupplierApi;
import com.ejianc.business.zdssupplier.sub.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="accept")
public class AcceptBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAcceptService service;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExpenseAccountDetailService expenseAccountDetailService;
    @Autowired
    private IMatSupplierApi matSupplierApi;
    @Autowired
    private ISubSupplierApi subSupplierApi;
    public static final String BILL_TYPE_OTHER_ACCEPT = "EJCBT202312000020";
    public static final String BILL_TYPE_ACCEPT = "EJCBT202312000001";
    public static final String PC_URL_OTHER_ACCEPT = "ejc-zdsmaterial-frontend/#/otherAccept/card";
    public static final String PC_URL_ACCEPT = "ejc-zdsmaterial-frontend/#/acceptList/acceptCard";
    @Autowired
    private IMaterialService materialService;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isEmpty(entity.getDetailList())) {
            return CommonResponse.error((String)"\u660e\u7ec6\u4e3a\u7a7a\uff0c\u5f53\u524d\u5355\u636e\u4e0d\u80fd\u63d0\u4ea4\uff01");
        }
        if ("2".equals(entity.getAcceptMaterialType())) {
            Map<Long, BigDecimal> nums = entity.getDetailList().stream().collect(Collectors.toMap(detail -> detail.getSourceDetailId(), detail -> detail.getDetailNum()));
            String msg = this.expenseAccountDetailService.handleAcceptNum(entity.getOrderBillId(), nums, true);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.logger.error("\u96f6\u661f\u6750\u6599\u5165\u5e93id-{} \u56de\u5199\u62a5\u9500\u5355id:{} \u660e\u7ec6 \u5360\u7528\u5165\u5e93\u91cf\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{entity.getId(), entity.getOrderBillId(), msg});
                return CommonResponse.error((String)msg);
            }
        } else {
            MatSupplierVO supplier;
            CommonResponse supplierResp;
            if (entity.getSourceType() == 0 || entity.getSourceType() == 1) {
                supplierResp = this.matSupplierApi.getOneById(entity.getSupplierId());
                if (!supplierResp.isSuccess()) {
                    this.logger.error("\u9a8c\u6536\u5355\u63d0\u4ea4-{}\u5931\u8d25\uff0c\u6839\u636eid-{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25,{}", new Object[]{entity.getId(), entity.getSupplierId(), JSONObject.toJSONString((Object)supplierResp)});
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u65b9\u4fe1\u606f\u5931\u8d25");
                }
                supplier = (MatSupplierVO)supplierResp.getData();
                if ("0".equals(supplier.getCoordination())) {
                    this.logger.error("\u9a8c\u6536\u5355\u63d0\u4ea4-{}\u5931\u8d25\uff0c\u4f9b\u5e94\u5546id-{}\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7", (Object)entity.getId(), (Object)entity.getSupplierId());
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u9a8c\u6536\u5355\u5bf9\u5e94\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7\uff01");
                }
            }
            if (entity.getAcceptType() == 1) {
                if (null == entity.getSubcontractorId()) {
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u9009\u62e9\u5206\u5305\u5408\u540c");
                }
                supplierResp = this.subSupplierApi.getOneById(entity.getSubcontractorId());
                if (!supplierResp.isSuccess()) {
                    this.logger.error("\u9a8c\u6536\u5355\u63d0\u4ea4-{}\u5931\u8d25\uff0c\u6839\u636eid-{}\u83b7\u53d6\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25,{}", new Object[]{entity.getId(), entity.getSubcontractorId(), JSONObject.toJSONString((Object)supplierResp)});
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5206\u5305\u5546\u4fe1\u606f\u5931\u8d25");
                }
                supplier = (SupplierVO)supplierResp.getData();
                if ("0".equals(supplier.getCoordination())) {
                    this.logger.error("\u9a8c\u6536\u5355\u63d0\u4ea4-{}\u5931\u8d25\uff0c\u4f9b\u5e94\u5546id-{}\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7", (Object)entity.getId(), (Object)entity.getSubcontractorId());
                    return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u9a8c\u6536\u5355\u5bf9\u5e94\u5206\u5305\u5546\u8054\u7cfb\u4eba\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7\uff01");
                }
            }
        }
        return CommonResponse.success();
    }

    public void returnDeliveryOrOrder(AcceptEntity entity, Integer sourceType, Boolean status) {
        for (AcceptDetailEntity detail : entity.getDetailList()) {
            detail.setCheckNum(detail.getDetailNum());
        }
        if (sourceType == 0) {
            if (null != entity.getId() && status.booleanValue()) {
                AcceptEntity accept = (AcceptEntity)((Object)this.service.selectById(entity.getId()));
                List<AcceptDetailEntity> detailList = accept.getDetailList();
                Map<Long, AcceptDetailEntity> collect = detailList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
                List<AcceptDetailEntity> detailList1 = entity.getDetailList();
                if (!collect.isEmpty()) {
                    for (AcceptDetailEntity detail : detailList1) {
                        if (!collect.containsKey(detail.getId()) || "del".equals(detail.getRowState())) continue;
                        BigDecimal detailNum = detail.getDetailNum();
                        BigDecimal detailNum1 = collect.get(detail.getId()).getDetailNum();
                        detail.setCheckNum(ComputeUtil.safeSub((BigDecimal)detailNum, (BigDecimal)detailNum1));
                    }
                }
            }
            this.deliveryService.returnDeliveryOrOrder(entity, status);
        } else if (sourceType == 1) {
            this.orderService.returnHandAcceptNum(entity, status);
        }
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        AcceptEntity checkEntity = (AcceptEntity)((Object)this.service.selectById(billId));
        if ("2".equals(checkEntity.getAcceptMaterialType())) {
            Map<Long, BigDecimal> nums = checkEntity.getDetailList().stream().collect(Collectors.toMap(detail -> detail.getSourceDetailId(), detail -> detail.getDetailNum()));
            String msg = this.expenseAccountDetailService.handleAcceptNum(checkEntity.getOrderBillId(), nums, false);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.logger.error("\u96f6\u661f\u6750\u6599\u5165\u5e93id-{} \u56de\u5199\u62a5\u9500\u5355id:{} \u660e\u7ec6 \u91ca\u653e\u5165\u5e93\u91cf\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{checkEntity.getId(), checkEntity.getOrderBillId(), msg});
                return CommonResponse.error((String)msg);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(billId));
        this.service.saveBillEffect(entity);
        if (entity.getAcceptType() == 1 && entity.getSubcontractorId() != null) {
            this.service.pushSubReturn(entity, InvocationInfoProxy.getUserid(), entity.getAcceptType() != 1);
        } else if (!"2".equals(entity.getAcceptMaterialType())) {
            if (entity.getSupplierId() != null) {
                this.service.pushSubAccept(entity, InvocationInfoProxy.getUserid(), entity.getAcceptType() != 1);
            } else {
                this.service.inToStore(entity, true, InvocationInfoProxy.getUserid());
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            this.pushMaterial(entity);
        }
        return CommonResponse.success();
    }

    private void pushMaterial(AcceptEntity entity) {
        try {
            List<Long> materialIds = entity.getDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<MaterialVO> materialDbList = this.materialService.queryDetailList(materialIds, false);
            Map<Long, MaterialVO> dbMap = materialDbList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
            ArrayList<MaterialVO> addList = new ArrayList<MaterialVO>();
            for (AcceptDetailEntity detail : entity.getDetailList()) {
                if (dbMap.containsKey(detail.getMaterialId())) continue;
                addList.add(this.generateNewMaterial(detail, entity));
            }
            if (CollectionUtils.isNotEmpty(addList)) {
                List<MaterialVO> addResp = this.materialService.addNewMaterialsFromBill(addList);
                Map<String, List<MaterialVO>> map = addResp.stream().collect(Collectors.groupingBy(s -> s.getName() + '-' + (StringUtils.isNotBlank((CharSequence)s.getPropertyShowName()) ? s.getPropertyShowName() : "") + '-' + s.getUnitId()));
                for (AcceptDetailEntity detail : entity.getDetailList()) {
                    String key = detail.getMaterialName() + "-" + (StringUtils.isNotBlank((CharSequence)detail.getPropertyValue()) ? detail.getPropertyValue() : "") + "-" + detail.getDetailUnitId();
                    if (!map.containsKey(key)) continue;
                    MaterialVO materialVOS1 = map.get(key).get(0);
                    detail.setMaterialId(materialVOS1.getId());
                    detail.setMaterialCode(materialVOS1.getCode());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u7269\u8d44\u9a8c\u6536id-{}\u7269\u6599\u63a8\u9001\u6863\u6848\u5e93\u5f02\u5e38", (Object)entity.getId());
            this.logger.error("\u7269\u8d44\u9a8c\u6536\u7269\u6599\u63a8\u9001\u6863\u6848\u5e93\u5f02\u5e38", (Throwable)e);
            entity.setNewMatFlag(3);
        }
    }

    private MaterialVO generateNewMaterial(AcceptDetailEntity data, AcceptEntity accept) {
        MaterialVO vo = new MaterialVO();
        vo.setId(data.getMaterialId());
        vo.setCode(data.getMaterialCode());
        vo.setName(data.getMaterialName());
        vo.setCategoryId(data.getMaterialTypeId());
        vo.setCategoryCode(data.getMaterialTypeCode());
        vo.setCategoryName(data.getMaterialTypeName());
        vo.setUnitId(data.getDetailUnitId());
        vo.setUnitName(data.getDetailUnitName());
        vo.setProductCode(data.getProductCode());
        vo.setEnabled(ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        vo.setBlockedFlag(ZDSMaterialCommonEnums.\u5c01\u5b58_\u6b63\u5e38.getCode());
        vo.setSystemId("sys");
        vo.setSourceId(String.valueOf(data.getId()));
        vo.setPropertyShowName(data.getPropertyValue());
        vo.setRelationList(new ArrayList());
        ArrayList<MaterialSourceVO> sourceList = new ArrayList<MaterialSourceVO>();
        MaterialSourceVO materialSourceVO = new MaterialSourceVO();
        materialSourceVO.setMaterialId(data.getMaterialId());
        materialSourceVO.setBillType(AcceptVO.\u5176\u4ed6\u6536\u5355.equals(accept.getSourceType()) ? BILL_TYPE_OTHER_ACCEPT : BILL_TYPE_ACCEPT);
        materialSourceVO.setBillTypeName(AcceptVO.\u5176\u4ed6\u6536\u5355.equals(accept.getSourceType()) ? "\u81ea\u5236\u5165\u5e93" : "\u7269\u8d44\u9a8c\u6536");
        materialSourceVO.setSourceBillCode(accept.getBillCode());
        materialSourceVO.setSourcePid(accept.getId());
        materialSourceVO.setSourceDetailId(data.getId());
        materialSourceVO.setSourceBillPcUrl(this.baseHost + (AcceptVO.\u5176\u4ed6\u6536\u5355.equals(accept.getSourceType()) ? PC_URL_OTHER_ACCEPT : PC_URL_ACCEPT));
        materialSourceVO.setSourceCreateUserCode(accept.getCreateUserCode());
        materialSourceVO.setSourceCreateUserName(accept.getCreateUserName());
        materialSourceVO.setSourceCreateTime(accept.getCreateTime());
        materialSourceVO.setSourceCreateTime(accept.getCreateTime());
        materialSourceVO.setSourceOrgName(accept.getOrgName());
        sourceList.add(materialSourceVO);
        vo.setSourceList(sourceList);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        String s;
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        AcceptEntity checkEntity = (AcceptEntity)((Object)this.service.selectById(billId));
        if (!"2".equals(checkEntity.getAcceptMaterialType())) {
            this.returnDeliveryOrOrder(checkEntity, checkEntity.getSourceType(), false);
        } else {
            Map<Long, BigDecimal> nums = checkEntity.getDetailList().stream().collect(Collectors.toMap(detail -> detail.getSourceDetailId(), detail -> detail.getDetailNum()));
            String msg = this.expenseAccountDetailService.handleAcceptNum(checkEntity.getOrderBillId(), nums, false);
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                this.logger.error("\u96f6\u661f\u6750\u6599\u5165\u5e93id-{} \u56de\u5199\u62a5\u9500\u5355id:{} \u660e\u7ec6 \u91ca\u653e\u5165\u5e93\u91cf\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{checkEntity.getId(), checkEntity.getOrderBillId(), msg});
                return CommonResponse.error((String)msg);
            }
        }
        if (checkEntity.getSourceType() == 0 || checkEntity.getSourceType() == 1) {
            if (!"2".equals(checkEntity.getAcceptMaterialType())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"contract_id", (Object)checkEntity.getContractId());
                queryWrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
                int count = this.service.count((Wrapper)queryWrapper);
                if (count > 0) {
                    throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u6709\u5b58\u5728\u4e00\u4e2a\u81ea\u7531\u6001\u7684\u9a8c\u6536\u5355!");
                }
            }
            QueryWrapper queryWrapper1 = new QueryWrapper();
            if (checkEntity.getSourceType() == 0 || "2".equals(checkEntity.getAcceptMaterialType())) {
                queryWrapper1.eq((Object)"order_bill_id", (Object)checkEntity.getOrderBillId());
            } else {
                queryWrapper1.eq((Object)"delivery_bill_id", (Object)checkEntity.getDeliveryBillId());
            }
            queryWrapper1.eq((Object)"source_type", (Object)checkEntity.getSourceType());
            queryWrapper1.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
            queryWrapper1.orderByDesc((Object)"create_time");
            List list = this.service.list((Wrapper)queryWrapper1);
            if (!((AcceptEntity)((Object)list.get(0))).getId().equals(checkEntity.getId())) {
                throw new BusinessException("\u6700\u65b0\u7684\u5355\u636e\u624d\u53ef\u4ee5\u64a4\u56de!");
            }
        }
        if (!"2".equals(checkEntity.getAcceptMaterialType())) {
            if (checkEntity.getMaterialSignatureStatus() == 1) {
                return CommonResponse.error((String)"\u4f9b\u65b9\u5df2\u7b7e\u5b57,\u65e0\u6cd5\u64a4\u56de!");
            }
            s = this.service.deletePickReturnBill(checkEntity);
            if (StringUtils.isNotBlank((CharSequence)s)) {
                return CommonResponse.error((String)s);
            }
        }
        if (checkEntity.getSignatureStatus() == 1) {
            return CommonResponse.error((String)"\u5206\u5305\u5546\u5df2\u7b7e\u5b57,\u65e0\u6cd5\u64a4\u56de!");
        }
        if (checkEntity.getSourceType() == 2 && StringUtils.isNotBlank((CharSequence)(s = this.service.deleteReturnBill(checkEntity)))) {
            return CommonResponse.error((String)s);
        }
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AcceptEntity entity = (AcceptEntity)((Object)this.service.selectById(billId));
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(billId);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setSourceId(entity.getId());
        storeManageVO.setStoreId(entity.getStoreId());
        if (entity.getAcceptType() == 0) {
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
        } else {
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
        }
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
        this.logger.info("\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
        CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.logger.info("xhc\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        if (entity.getSourceType() == 0) {
            if (0 == entity.getFinalAcceptFlag() && 0 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getCode());
            } else if (1 == entity.getFinalAcceptFlag() && 1 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getCode());
            } else if (0 == entity.getFinalAcceptFlag() && 1 == entity.getCloseDelivery()) {
                this.deliveryService.updateAcceptStatus(entity.getDeliveryBillId(), DeliveryAcceptStatusEnums.\u9a8c\u6536\u4e2d.getCode());
                this.deliveryDetailService.updateDeliveryResNum(entity, false);
            }
        }
        if (entity.getSourceType() == 0 || entity.getSourceType() == 1) {
            DeliveryEntity deliveryEntity;
            String s;
            if (entity.getSourceType() == 0 && StringUtils.isNotBlank((CharSequence)(s = this.deliveryService.updateSupDelivery(deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryBillId())))))) {
                throw new BusinessException(s);
            }
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(entity.getOrderBillId()));
            String supBusiness = this.orderService.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class));
            if (StringUtils.isNotBlank((CharSequence)supBusiness)) {
                throw new BusinessException(supBusiness);
            }
        }
        entity.setEffectDate(null);
        entity.setApproveUserId(null);
        entity.setApproveUserName(null);
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }
}

