/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.order.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cloudstore.apply.service.IOperationLogService;
import com.ejianc.business.zdsmaterial.cloudstore.constants.AllotOrderBusinessStatusEnums;
import com.ejianc.business.zdsmaterial.cloudstore.order.bean.AllotOrderEntity;
import com.ejianc.business.zdsmaterial.cloudstore.order.bean.AllotOrderOperationRecordEntity;
import com.ejianc.business.zdsmaterial.cloudstore.order.mapper.AllotOrderOperationRecordMapper;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderOperationRecordService;
import com.ejianc.business.zdsmaterial.cloudstore.order.service.IAllotOrderService;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderOperationRecordVO;
import com.ejianc.business.zdsmaterial.cloudstore.order.vo.AllotOrderVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="allotOrderOperationRecordService")
public class AllotOrderOperationRecordServiceImpl
extends BaseServiceImpl<AllotOrderOperationRecordMapper, AllotOrderOperationRecordEntity>
implements IAllotOrderOperationRecordService,
IOperationLogService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotOrderService allotOrderService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public void handleOperationLog(String reqParam, AllotOrderOperationRecordVO recordVO) {
        this.logger.info("\u8ba2\u5355\u64cd\u4f5c\u8bb0\u5f55\uff0c\u53c2\u6570\uff1a{}, recordVo\uff1a{}", (Object)reqParam, (Object)JSONObject.toJSONString((Object)recordVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        JSONArray params = JSONObject.parseArray((String)reqParam);
        AllotOrderEntity allotOrder = null;
        StringBuilder sp = new StringBuilder();
        UserContext user = this.sessionManager.getUserContext();
        if ("\u8ba2\u5355\u63d0\u4ea4\u5ba1\u6279".equals(recordVO.getEvent()) || "\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7".equals(recordVO.getEvent()) || "\u8c03\u51fa\u65b9\u8ba2\u5355\u5ba1\u6279\u9a73\u56de".equals(recordVO.getEvent())) {
            allotOrder = (AllotOrderEntity)((Object)this.allotOrderService.selectById(params.getLong(0)));
            sp.append("\u8c03\u51fa\u65b9\u3010\u4eba\u5458\uff1a").append(user.getEmployeeName()).append("\uff0c\u7f16\u53f7\uff1a").append(user.getUserCode()).append("\u3011").append(recordVO.getEvent());
            recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_OUT);
        } else {
            AllotOrderVO orderVo = (AllotOrderVO)params.getObject(0, AllotOrderVO.class);
            allotOrder = (AllotOrderEntity)((Object)this.allotOrderService.selectById(orderVo.getId()));
            switch (recordVO.getEvent()) {
                case "\u8c03\u62e8\u8ba2\u5355\u7f16\u8f91/\u5165\u5e93\u7f16\u8f91": {
                    if (orderVo.getOprType().equals("saveEdit")) {
                        recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_OUT);
                        sp.append("\u8ba2\u5355\u8c03\u51fa\u65b9\u3010\u4eba\u5458\uff1a").append(user.getEmployeeName()).append("\uff0c\u7f16\u53f7\uff1a").append(user.getUserCode()).append("\u3011\u7f16\u8f91\u8ba2\u5355\u5e76\u63a8\u9001\u8c03\u5165\u65b9\u786e\u8ba4");
                        break;
                    }
                    recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_IN);
                    sp.append("\u8ba2\u5355\u8c03\u5165\u65b9\u3010\u4eba\u5458\uff1a").append(user.getEmployeeName()).append("\uff0c\u7f16\u53f7\uff1a").append(user.getUserCode()).append("\u3011\u5165\u5e93\u7f16\u8f91\u4fdd\u5b58");
                    break;
                }
                case "\u8c03\u5165/\u51fa\u65b9\u8c03\u62e8\u8ba2\u5355\u53d6\u6d88": {
                    recordVO.setOprUseType(AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u6d3d\u5546\u5f85\u786e\u8ba4.getCode().equals(orderVo.getBusinessStatus()) || AllotOrderBusinessStatusEnums.\u8c03\u5165\u65b9\u5f85\u6536\u8d27.getCode().equals(orderVo.getBusinessStatus()) ? AllotOrderOperationRecordVO.OPR_USER_TYPE_IN : AllotOrderOperationRecordVO.OPR_USER_TYPE_OUT);
                    sp.append(recordVO.getOprUseType() == 2 ? "\u8ba2\u5355\u8c03\u5165\u65b9\u3010\u4eba\u5458\uff1a" : "\u8ba2\u5355\u8c03\u51fa\u65b9\u3010\u4eba\u5458\uff1a").append(user.getEmployeeName()).append("\uff0c\u7f16\u53f7\uff1a").append(user.getUserCode()).append("\u3011\u53d6\u6d88\u8ba2\u5355");
                    break;
                }
                case "\u8c03\u5165\u65b9\u8c03\u62e8\u8ba2\u5355\u786e\u8ba4": {
                    sp.append("\u8ba2\u5355\u8c03\u5165\u65b9\u3010\u4eba\u5458\uff1a").append(user.getEmployeeName()).append("\uff0c\u7f16\u53f7\uff1a").append(user.getUserCode()).append("\u786e\u8ba4\u8ba2\u5355");
                    recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_IN);
                    break;
                }
                default: {
                    recordVO.setOprUseType(AllotOrderOperationRecordVO.OPR_USER_TYPE_IN);
                    sp.append("\u8ba2\u5355\u8c03\u5165\u65b9\u3010\u4eba\u5458\uff1a").append(user.getEmployeeName()).append("\uff0c\u7f16\u53f7\uff1a").append(user.getUserCode()).append("\u3011\u6536\u8d27\u5165\u5e93");
                }
            }
        }
        recordVO.setOprUserCode(user.getUserCode());
        recordVO.setOprUserName(user.getUserName());
        recordVO.setOrderId(allotOrder.getId());
        recordVO.setOrderCode(allotOrder.getBillCode());
        recordVO.setBeforeBusinessStatus(allotOrder.getBusinessStatus());
        recordVO.setOprDesc(sp.toString());
        super.saveOrUpdate(BeanMapper.map((Object)recordVO, AllotOrderOperationRecordEntity.class), false);
        this.logger.info("\u8ba2\u5355[id-{},billCode-{}]\u64cd\u4f5c\u8bb0\u5f55\u66f4\u65b0\u6210\u529f\uff01", (Object)recordVO.getOrderId(), (Object)recordVO.getOrderCode());
    }
}

