/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.cloudstore.shelf.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.bean.GoodsEntity;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.service.IGoodsService;
import com.ejianc.business.zdsmaterial.cloudstore.shelf.vo.GoodsVO;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsstore.api.IStoreApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"goods"})
public class GoodsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IStoreApi storeApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IGoodsService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<GoodsVO> saveOrUpdate(@RequestBody GoodsVO saveOrUpdateVO) {
        GoodsEntity entity = (GoodsEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, GoodsEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<GoodsVO> queryDetail(Long id) {
        GoodsEntity entity = (GoodsEntity)((Object)this.service.selectById(id));
        GoodsVO vo = (GoodsVO)BeanMapper.map((Object)((Object)entity), GoodsVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<GoodsVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (GoodsVO goodsVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("productCode");
        fuzzyFields.add("propertyValue");
        fuzzyFields.add("brandName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("sellUserName");
        fuzzyFields.add("corpName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        List orgIds = orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIds)) {
            param.getParams().put("orgId", new Parameter("in", orgIds));
        }
        this.transferQueryParam(param);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private String transferQueryParam(QueryParam param) {
        String type = "goods";
        if (param.getParams().containsKey("type")) {
            type = String.valueOf(((Parameter)param.getParams().get("type")).getValue());
            param.getParams().remove("type");
        } else {
            param.getParams().remove("orgId");
        }
        Integer status = PlanConstant.GOODS_STATUS_ON;
        Integer storeType = PlanConstant.STORE_TYPE_PROJECT;
        if ("orgOn".equals(type)) {
            status = PlanConstant.GOODS_STATUS_ON;
            storeType = PlanConstant.STORE_TYPE_ORG;
        } else if ("orgOut".equals(type)) {
            status = PlanConstant.GOODS_STATUS_OUT;
            storeType = PlanConstant.STORE_TYPE_ORG;
        } else if ("projectOn".equals(type)) {
            status = PlanConstant.GOODS_STATUS_ON;
            storeType = PlanConstant.STORE_TYPE_PROJECT;
        } else if ("projectOut".equals(type)) {
            status = PlanConstant.GOODS_STATUS_OUT;
            storeType = PlanConstant.STORE_TYPE_PROJECT;
        }
        param.getParams().put("status", new Parameter("eq", (Object)status));
        if (!type.equals("goods")) {
            param.getParams().put("storeType", new Parameter("eq", (Object)storeType));
        }
        if (param.getParams().containsKey("isMyGoods")) {
            String isMyGoods = String.valueOf(((Parameter)param.getParams().get("isMyGoods")).getValue());
            param.getParams().remove("isMyGoods");
            if (isMyGoods.contains("0") && isMyGoods.contains("1")) {
                param.getParams().remove("sellUserId");
            } else if (isMyGoods.contains("0")) {
                param.getParams().put("sellUserId", new Parameter("ne", (Object)InvocationInfoProxy.getUserid()));
            } else if (isMyGoods.contains("1")) {
                param.getParams().put("sellUserId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
            }
        }
        if (param.getParams().containsKey("range")) {
            String range = String.valueOf(((Parameter)param.getParams().get("range")).getValue());
            param.getParams().remove("range");
            List<Long> cloudStoreIds = this.queryCloudStoreByOrg(InvocationInfoProxy.getOrgId());
            if (CollectionUtils.isNotEmpty(cloudStoreIds)) {
                if (range.contains("this") && range.contains("other")) {
                    param.getParams().remove("cloudStoreId");
                } else if (range.contains("this")) {
                    param.getParams().put("cloudStoreId", new Parameter("in", cloudStoreIds));
                } else if (range.contains("other")) {
                    param.getParams().put("cloudStoreId", new Parameter("not_in", cloudStoreIds));
                }
            } else if (range.contains("other")) {
                param.getParams().remove("cloudStoreId");
            } else if (range.contains("this")) {
                param.getParams().put("0", new Parameter("eq", (Object)1));
            }
            param.getParams().remove("orgId");
        }
        return type;
    }

    private List<Long> queryCloudStoreByOrg(Long orgId) {
        CommonResponse resp = this.storeApi.queryCloudStoreByOrg(orgId);
        List<Long> cloudStoreIds = new ArrayList<Long>();
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            cloudStoreIds = ((List)resp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return cloudStoreIds;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialTypeCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("productCode");
        fuzzyFields.add("propertyValue");
        fuzzyFields.add("brandName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("sellUserName");
        fuzzyFields.add("corpName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String type = this.transferQueryParam(param);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, GoodsVO.class);
        voList.forEach(e -> e.setAttrFlagName((String)PlanConstant.ATTR_FLAG.get(e.getAttrFlag())));
        beans.put("records", voList);
        if ("orgOn".equals(type) || "orgOut".equals(type)) {
            ExcelExport.getInstance().export("Goods-org-export.xlsx", beans, response);
        } else if ("projectOn".equals(type) || "projectOut".equals(type)) {
            ExcelExport.getInstance().export("Goods-project-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("Goods-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refGoodsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<GoodsVO>> refGoodsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), GoodsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateStatus(@RequestBody List<GoodsVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)true);
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List list = this.service.queryList(param);
        for (GoodsEntity entity : list) {
            entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
            entity.setLowerType(PlanConstant.OUT_TYPE_HAND);
            entity.setLowerId(InvocationInfoProxy.getUserid());
            entity.setLowerName(this.sessionManager.getUserContext().getUserName());
            entity.setLowerCode(InvocationInfoProxy.getUsercode());
            entity.setLowerTime(DateFormater.getCurrentDate());
            entity.setLowerNum(entity.getSurplusNum());
            entity.setSurplusNum(null);
            if (!ComputeUtil.isNotEmpty((BigDecimal)entity.getAllotNum()).booleanValue()) continue;
            throw new BusinessException("\u3010" + entity.getMaterialCode() + "+" + entity.getMaterialName() + "+" + entity.getPropertyValue() + "\u3011\u5b58\u5728\u4ea4\u6613\u4e2d\u7684\u8ba2\u5355,\u4e0d\u5141\u8bb8\u4e0b\u67b6\uff01");
        }
        this.service.saveOrUpdateBatch(list);
        this.service.inOutStoreRollback(list);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)true);
    }
}

