/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountService;
import com.ejianc.business.zdsmaterial.erp.vo.ExpenseAccountVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/expenseAccount"})
public class ExpenseAccountController {
    private final String ERP_EXPENSE_ACCOUNT_SYNC_URL = "/cefoc/yql/getFMPayment";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IExpenseAccountService service;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;
    @Autowired
    private IExpenseAccountDetailService detailService;
    @Autowired
    private IBrandService brandService;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;

    @GetMapping(value={"refExpenseAccountData"})
    public CommonResponse<IPage<ExpenseAccountVO>> refExpenseAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject paramJson;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("orgCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("payee");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Map params = param.getParams();
        params.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        params.put("allAcceptedFlag", new Parameter("eq", (Object)PlanConstant.INTEGER_NO));
        params.put("status", new Parameter("eq", (Object)"2"));
        if (StringUtils.isNotBlank((CharSequence)condition) && (paramJson = JSONObject.parseObject((String)condition)).containsKey((Object)"projectId")) {
            params.put("projectId", new Parameter("eq", paramJson.get((Object)"projectId")));
        }
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ExpenseAccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"syncErpExpenseAccount"})
    public CommonResponse<String> syncErpExpenseAccount(@RequestBody Map<String, String> params) {
        Object endDateStr;
        this.logger.info("*********************\u4e2d\u7535\u56db-\u62a5\u9500\u5355\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u5f00\u59cb*********************");
        boolean noDate = null != params && null != params.get("noDate") ? "true".equals(params.get("noDate")) : false;
        String reqDateStr = null;
        String reqResp = null;
        HashMap<String, String> param = new HashMap<String, String>();
        JSONObject reqJson = null;
        Object pageData = null;
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/getFMPayment";
        Integer reqErrorTimes = null != params && null != params.get("reqErrorTimes") ? Integer.valueOf(params.get("reqErrorTimes")) : 0;
        if (!noDate) {
            reqDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)new Date());
            String startDateStr = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)DateUtils.addDays((Date)new Date(), (int)-2)) + " 00:00:00";
            endDateStr = reqDateStr + " 23:59:59";
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", (String)endDateStr);
        }
        if (null != params.get("startDate")) {
            param.put("BeginDateTime", params.get("startDate"));
        }
        if (null != params.get("endDate")) {
            param.put("EndDateTime", params.get("endDate"));
        }
        if (null != params.get("projectCode") && StringUtils.isNotBlank((CharSequence)params.get("projectCode"))) {
            CommonResponse projectResp = this.projectPoolApi.getOneByCode(params.get("projectCode"));
            if (!projectResp.isSuccess()) {
                this.logger.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01", (Object)params.get("projectCode"));
                return CommonResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null == projectResp.getData()) {
                this.logger.error("\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801-{}\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object)params.get("projectCode"));
                return CommonResponse.error((String)"\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            reqUrl = reqUrl + "?ProjectOID=" + ((ProjectPoolSetVO)projectResp.getData()).getSourceId();
            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }
        try {
            Map<String, String> headers = null;
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(param), headers, (Integer)180000, (Integer)180000);
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                this.handleErpExpenseAccountData(reqJson);
            } else {
                this.logger.error("\u8bf7\u6c42\u4e2d\u7535\u56db\u83b7\u53d6\u62a5\u9500\u5355\u7ed3\u679c\u8fd4\u56de\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp});
                this.queueUtils.sendMq("el_sync_erp_data_job_" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1", reqResp, null)));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e2d\u7535\u56db\u62a5\u9500\u5355\u4fe1\u606f\u5f02\u5e38, \u8bf7\u6c42\u5730\u5740\uff1a{}, \u8bf7\u6c42\u53c2\u6570\uff1a{},e:", new Object[]{reqUrl, JSONObject.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), e});
            this.queueUtils.sendMq("el_sync_erp_data_job_" + this.profile, JSONObject.toJSONString((Object)new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), "1", reqResp, e.getMessage())));
            endDateStr = reqErrorTimes;
            Integer n = reqErrorTimes = Integer.valueOf(reqErrorTimes + 1);
            if (reqErrorTimes >= 5) {
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u62a5\u9500\u5355\u4fe1\u606f\u5f02\u5e38");
            }
            try {
                this.logger.info("\u540c\u6b65\u4e2d\u7535\u56db\u62a5\u9500\u5355\u4fe1\u606f\u5f02\u5e38\uff0c5s\u540e\u91cd\u8bd5.........,");
                Thread.sleep(5000L);
                HashMap<String, String> reqParam = new HashMap<String, String>();
                reqParam.put("reqErrorTimes", reqErrorTimes + "");
                reqParam.put("noDate", noDate + "");
                return this.syncErpExpenseAccount(reqParam);
            }
            catch (Exception e1) {
                this.logger.error("\u91cd\u542f\u4e2d\u7535\u56db\u94f6\u884c\u652f\u884c\u540c\u6b65\u63a5\u53e3\u5f02\u5e38,", (Throwable)e1);
                return CommonResponse.error((String)"\u540c\u6b65\u4e2d\u7535\u56db\u94f6\u884c\u4fe1\u606f\u5f02\u5e38");
            }
        }
        this.logger.info("*********************\u4e2d\u7535\u56db-\u62a5\u9500\u5355\u4fe1\u606f\u540c\u6b65\u4efb\u52a1 \u7ed3\u675f*********************");
        return CommonResponse.success((String)"\u62a5\u9500\u5355\u4fe1\u606f\u540c\u6b65\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01");
    }

    private void handleErpExpenseAccountData(JSONObject reqJson) {
        CommonResponse poolResp;
        List<BrandEntity> dbBrands;
        HashMap<String, ExpenseAccountEntity> sourceMap = new HashMap<String, ExpenseAccountEntity>();
        JSONArray paymentList = reqJson.getJSONArray("PaymentList");
        this.logger.info("\u5f85\u5904\u7406\u4e3b\u8868\u6570\u636e\uff1a{}", (Object)(null != paymentList ? paymentList.size() : 0));
        JSONObject tmp = null;
        ExpenseAccountEntity expenseAccountEntity = null;
        ExpenseAccountDetailEntity tempDetail = null;
        ArrayList<ExpenseAccountEntity> saveMainList = new ArrayList<ExpenseAccountEntity>();
        ArrayList<ExpenseAccountEntity> updateMainList = new ArrayList<ExpenseAccountEntity>();
        ArrayList<ExpenseAccountDetailEntity> saveSubList = new ArrayList<ExpenseAccountDetailEntity>();
        HashSet<String> projectSids = new HashSet<String>();
        HashSet<String> brandSids = new HashSet<String>();
        if (CollectionUtils.isEmpty((Collection)paymentList)) {
            this.logger.info("\u83b7\u53d6\u4e2d\u7535\u56db\u62a5\u9500\u5355\u4fe1\u606f\u5b8c\u6210\uff0c\u672c\u6b21\u5f85\u5904\u7406\u4e3b\u8868\u6570\u636e\u4e3a\u7a7a\uff01");
            return;
        }
        for (Object obj : paymentList) {
            tmp = (JSONObject)obj;
            expenseAccountEntity = new ExpenseAccountEntity();
            expenseAccountEntity.setSourceId(tmp.getString("C_PS_FMPaymentOID").toLowerCase());
            expenseAccountEntity.setProjectCode(tmp.getString("Account_Project_id"));
            expenseAccountEntity.setProjectSid(tmp.getString("Account_Project_Sid"));
            expenseAccountEntity.setPayee(tmp.getString("Payee"));
            expenseAccountEntity.setBillCode(tmp.getString("ma_id"));
            expenseAccountEntity.setStatus(tmp.getString("Status"));
            expenseAccountEntity.setApprMny(tmp.getBigDecimal("ApprMoney"));
            expenseAccountEntity.setAllAcceptedFlag("0");
            projectSids.add(expenseAccountEntity.getProjectSid());
            sourceMap.put(expenseAccountEntity.getSourceId(), expenseAccountEntity);
        }
        JSONArray paymentList_SubD = reqJson.getJSONArray("PaymentList_SubD");
        this.logger.info("\u5f85\u5904\u7406\u5b50\u8868\u6570\u636e\uff1a{}", (Object)(null != paymentList_SubD ? paymentList_SubD.size() : 0));
        HashSet<String> materialSerialNo = new HashSet<String>();
        HashSet<String> sourceDetailIds = new HashSet<String>();
        ArrayList tmpDetailList = new ArrayList();
        Map<Object, Object> projectSourceMap = new HashMap();
        if (null != paymentList_SubD) {
            for (Object obj : paymentList_SubD) {
                tmp = (JSONObject)obj;
                tempDetail = new ExpenseAccountDetailEntity();
                if (StringUtils.isBlank((CharSequence)tmp.getString("BrandSid")) || tmp.getBigDecimal("PurchaseAmount").compareTo(BigDecimal.ZERO) == 0) {
                    this.logger.info("\u62a5\u9500\u5355\u660e\u7ec6\u54c1\u724c\u6216\u6570\u91cf\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5165\u5e93\uff1a{}", (Object)tmp.toString());
                    continue;
                }
                if (null == tmp.get((Object)"ListMaterialCode") || !tmp.getString("ListMaterialCode").startsWith("pd-")) {
                    this.logger.info("\u62a5\u9500\u5355\u660e\u7ec6\u975e\u6765\u6e90\u4e8eEL\u91c7\u8d2d\u8ba1\u5212\uff0c\u8df3\u8fc7\u5165\u5e93\uff1a{}", (Object)tmp.toString());
                    continue;
                }
                tempDetail.setSourceDetailId(tmp.getString("C_PS_FMPayment_SubDOID").toLowerCase());
                tempDetail.setSourceId(tmp.getString("FMPayment_FK").toLowerCase());
                tempDetail.setMemo(tmp.getString("Memo"));
                tempDetail.setSumpoint(tmp.getBigDecimal("sumpoint"));
                tempDetail.setPurchaseNum(tmp.getBigDecimal("PurchaseAmount"));
                tempDetail.setDetailTaxPrice(tmp.getBigDecimal("PurchasePrice"));
                tempDetail.setDetailPrice(tmp.getBigDecimal("PurchasePrice"));
                tempDetail.setDetailTaxMny(ComputeUtil.safeMultiply(tempDetail.getDetailTaxPrice(), tempDetail.getPurchaseNum()));
                tempDetail.setDetailMny(tempDetail.getDetailTaxMny());
                tempDetail.setMaterialSerialNo(tmp.getString("ListMaterialCode"));
                tempDetail.setBrandName(tmp.getString("Brand"));
                tempDetail.setBrandSid(tmp.getString("BrandSid"));
                brandSids.add(tempDetail.getBrandSid());
                if (!sourceMap.containsKey(tempDetail.getSourceId())) {
                    this.logger.info("\u62a5\u9500\u5355\u660e\u7ec6\u975e\u65e0\u5bf9\u5e94\u4e3b\u8868\u4fe1\u606f\uff0c\u8df3\u8fc7\u5165\u5e93\uff1a{}", (Object)tmp.toString());
                    continue;
                }
                ((ExpenseAccountEntity)((Object)sourceMap.get(tempDetail.getSourceId()))).getDetailList().add(tempDetail);
                sourceDetailIds.add(tempDetail.getSourceDetailId());
                materialSerialNo.add(tempDetail.getMaterialSerialNo());
            }
        }
        List<ExpenseAccountEntity> dbList = this.service.getAllBySourceIds(new ArrayList<String>(sourceMap.keySet()));
        List<ExpenseAccountDetailEntity> dbDetailList = this.detailService.getAllBySourceDetailIds(new ArrayList<String>(sourceDetailIds));
        HashMap<String, BrandEntity> brandSidMap = new HashMap<String, BrandEntity>();
        if (CollectionUtils.isNotEmpty(brandSids) && CollectionUtils.isNotEmpty(dbBrands = this.brandService.getAllBySourceIds(new ArrayList<String>(brandSids)))) {
            brandSidMap.putAll(dbBrands.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
        }
        if (!(poolResp = this.projectPoolApi.getAllBySourceIds(new ArrayList(projectSids))).isSuccess()) {
            throw new BusinessException("\u540c\u6b65\u5931\u8d25\uff0c\u6839\u636eERP\u9879\u76ee\u4e3b\u952e\u83b7\u53d6\u5339\u914d\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        projectSourceMap = ((List)poolResp.getData()).stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
        HashMap<String, ExpenseAccountDetailEntity> dbDetailMap = new HashMap<String, ExpenseAccountDetailEntity>();
        if (CollectionUtils.isNotEmpty(dbDetailList)) {
            dbDetailMap.putAll(dbDetailList.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item)));
        }
        Map<Object, Object> planDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(materialSerialNo)) {
            List<PurchasePlanDetailVO> planDetails = this.purchasePlanDetailService.findAllByMaterialNos(new ArrayList<String>(materialSerialNo));
            planDetailMap = planDetails.stream().collect(Collectors.toMap(item -> item.getMaterialSerialNo(), item -> item));
        }
        PurchasePlanDetailVO tmpPlanDetail = null;
        if (CollectionUtils.isNotEmpty(dbList)) {
            for (ExpenseAccountEntity dbEntity : dbList) {
                expenseAccountEntity = (ExpenseAccountEntity)((Object)sourceMap.get(dbEntity.getSourceId()));
                if (null == expenseAccountEntity) continue;
                dbEntity.setStatus(expenseAccountEntity.getStatus());
                dbEntity.setPayee(expenseAccountEntity.getPayee());
                dbEntity.setBillCode(expenseAccountEntity.getBillCode());
                dbEntity.setApprMny(expenseAccountEntity.getApprMny());
                updateMainList.add(dbEntity);
                for (ExpenseAccountDetailEntity detail : expenseAccountEntity.getDetailList()) {
                    if (dbDetailMap.containsKey(detail.getSourceDetailId()) || !planDetailMap.containsKey(detail.getMaterialSerialNo())) continue;
                    detail.setPid(dbEntity.getId());
                    if (brandSidMap.containsKey(detail.getBrandSid())) {
                        detail.setBrandName(((BrandEntity)((Object)brandSidMap.get(detail.getBrandSid()))).getBrandName());
                        detail.setBrandId(((BrandEntity)((Object)brandSidMap.get(detail.getBrandSid()))).getId());
                    }
                    tmpPlanDetail = (PurchasePlanDetailVO)planDetailMap.get(detail.getMaterialSerialNo());
                    detail.setMaterialId(tmpPlanDetail.getMaterialId());
                    detail.setMaterialCode(tmpPlanDetail.getMaterialCode());
                    detail.setMaterialName(tmpPlanDetail.getMaterialName());
                    detail.setMaterialTypeId(tmpPlanDetail.getMaterialTypeId());
                    detail.setMaterialTypeName(tmpPlanDetail.getMaterialTypeName());
                    detail.setMaterialTypeCode(tmpPlanDetail.getMaterialTypeCode());
                    detail.setDetailUnitId(tmpPlanDetail.getUnitId());
                    detail.setDetailUnitName(tmpPlanDetail.getUnitName());
                    detail.setPropertyValue(tmpPlanDetail.getPropertyValue());
                    detail.setProductCode(tmpPlanDetail.getProductCode());
                    detail.setAcceptedNum(BigDecimal.ZERO);
                    saveSubList.add(detail);
                }
                sourceMap.remove(dbEntity.getSourceId());
            }
        }
        if (!sourceMap.isEmpty()) {
            for (ExpenseAccountEntity e : sourceMap.values()) {
                e.setId(IdWorker.getId());
                boolean saveFlag = false;
                if (projectSourceMap.containsKey(e.getProjectSid())) {
                    e.setProjectCode(((ProjectPoolSetVO)projectSourceMap.get(e.getProjectSid())).getCode());
                    e.setProjectName(((ProjectPoolSetVO)projectSourceMap.get(e.getProjectSid())).getName());
                    e.setProjectId(((ProjectPoolSetVO)projectSourceMap.get(e.getProjectSid())).getId());
                }
                if (CollectionUtils.isNotEmpty(e.getDetailList())) {
                    for (ExpenseAccountDetailEntity detail : e.getDetailList()) {
                        detail.setPid(e.getId());
                        if (!planDetailMap.containsKey(detail.getMaterialSerialNo())) {
                            this.logger.info("\u62a5\u9500\u5355\u660e\u7ec6\u3010{}\u3011 \u975e\u6765\u6e90\u4e8eEL\u91c7\u8d2d\u8ba1\u5212\uff0c\u8df3\u8fc7\u5165\u5e93~", (Object)JSONObject.toJSONString((Object)((Object)detail)));
                            continue;
                        }
                        tmpPlanDetail = (PurchasePlanDetailVO)planDetailMap.get(detail.getMaterialSerialNo());
                        detail.setMaterialId(tmpPlanDetail.getMaterialId());
                        detail.setMaterialCode(tmpPlanDetail.getMaterialCode());
                        detail.setMaterialName(tmpPlanDetail.getMaterialName());
                        detail.setMaterialTypeId(tmpPlanDetail.getMaterialTypeId());
                        detail.setMaterialTypeName(tmpPlanDetail.getMaterialTypeName());
                        detail.setMaterialTypeCode(tmpPlanDetail.getMaterialTypeCode());
                        detail.setDetailUnitId(tmpPlanDetail.getUnitId());
                        detail.setDetailUnitName(tmpPlanDetail.getUnitName());
                        detail.setPropertyValue(tmpPlanDetail.getPropertyValue());
                        detail.setProductCode(tmpPlanDetail.getProductCode());
                        detail.setAcceptedNum(BigDecimal.ZERO);
                        if (brandSidMap.containsKey(detail.getBrandSid())) {
                            detail.setBrandName(((BrandEntity)((Object)brandSidMap.get(detail.getBrandSid()))).getBrandName());
                            detail.setBrandId(((BrandEntity)((Object)brandSidMap.get(detail.getBrandSid()))).getId());
                            saveSubList.add(detail);
                        }
                        saveFlag = true;
                    }
                    if (!saveFlag) {
                        this.logger.info("\u62a5\u9500\u5355\uff1a{}\u53ef\u4fdd\u5b58\u5b50\u8868\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5165\u5e93~", (Object)JSONObject.toJSONString((Object)((Object)e)));
                    }
                    saveMainList.add(e);
                    continue;
                }
                this.logger.info("\u62a5\u9500\u5355\uff1a{}\u53ef\u4fdd\u5b58\u5b50\u8868\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5165\u5e93~", (Object)JSONObject.toJSONString((Object)((Object)e)));
            }
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u62a5\u9500\u5355\u4e3b\u8868\uff1a{}\u6761", (Object)saveMainList.size());
        if (CollectionUtils.isNotEmpty(saveMainList)) {
            this.service.saveOrUpdateBatch(saveMainList, saveMainList.size(), false);
        }
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u62a5\u9500\u5355\u4e3b\u8868: {}\u6761", (Object)updateMainList.size());
        if (CollectionUtils.isNotEmpty(updateMainList)) {
            this.service.saveOrUpdateBatch(updateMainList, updateMainList.size(), false);
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u62a5\u9500\u5355\u5b57\u8868\uff1a{}\u6761", (Object)saveSubList.size());
        if (CollectionUtils.isNotEmpty(saveSubList)) {
            this.detailService.saveOrUpdateBatch(saveSubList, saveSubList.size(), false);
        }
    }
}

