/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.controller.api;

import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zdsBrand"})
public class BrandApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBrandService service;

    @PostMapping(value={"/getAllByIds"})
    CommonResponse<List<BrandVO>> getAllByIds(@RequestBody List<Long> ids) {
        List<BrandVO> resp = this.service.getAllByIds(ids);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"/getAllMapBySourceIds"})
    CommonResponse<Map<String, BrandVO>> getAllMapBySourceIds(@RequestBody List<String> sourceIds) {
        List<BrandEntity> dbList;
        HashMap<String, BrandVO> resp = new HashMap<String, BrandVO>();
        if (CollectionUtils.isNotEmpty(sourceIds) && CollectionUtils.isNotEmpty(dbList = this.service.getAllBySourceIds(sourceIds))) {
            List vos = BeanMapper.mapList(dbList, BrandVO.class);
            for (BrandVO v : vos) {
                resp.put(v.getSourceId(), v);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"/getAllMapByNames"})
    CommonResponse<Map<String, BrandVO>> getAllMapByNames(@RequestBody List<String> names) {
        HashMap<String, BrandVO> resp = new HashMap<String, BrandVO>();
        if (CollectionUtils.isNotEmpty(names)) {
            resp.putAll(this.service.getAllVoMapByNames(names));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }
}

