/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandApplyDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandApplyEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationFlowEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandApplyService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationFlowService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="brandApply")
public class BrandApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBrandApplyService service;
    @Autowired
    SessionManager sessionManager;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IMatSupplierManagerService matSupplierManagerService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IUserApi userApi;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IBrandRelationService relationService;
    @Autowired
    private IBrandRelationFlowService relationFlowService;
    private final String APPLY_PC_URL = "ejc-zdsmaterial-frontend/#/brandApply/card?id=";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        BrandApplyEntity e = (BrandApplyEntity)((Object)this.service.selectById(billId));
        String msg = this.doValidDate(e);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        UserContext user = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(user.getUserCode());
        e.setCommitUserName(user.getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BrandApplyEntity e = (BrandApplyEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            String msg = this.doValidDate(e);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return CommonResponse.error((String)msg);
            }
            UserContext user = this.sessionManager.getUserContext();
            e.setCommitDate(new Date());
            e.setCommitUserCode(user.getUserCode());
            e.setCommitUserName(user.getUserName());
        }
        this.pushToArrchive(e);
        e.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public void pushToArrchive(BrandApplyEntity e) {
        List<BrandRelationEntity> dbRelations;
        ArrayList<BrandEntity> saveBrandList = new ArrayList<BrandEntity>();
        ArrayList<BrandRelationEntity> saveRelations = new ArrayList<BrandRelationEntity>();
        Set brandNames = e.getDetailList().stream().map(BrandApplyDetailEntity::getBrandName).collect(Collectors.toSet());
        Map<String, BrandEntity> dbBrands = this.brandService.getAllByNames(new ArrayList<String>(brandNames));
        if (MapUtils.isNotEmpty(dbBrands)) {
            throw new BusinessException("\u54c1\u724c\u3010" + dbBrands.keySet().stream().collect(Collectors.joining("\u3001")) + "\u3011\u5df2\u5728\u5e93,\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\uff01");
        }
        BrandEntity brand = null;
        HashMap<String, BrandEntity> brandNameMap = new HashMap<String, BrandEntity>();
        for (BrandApplyDetailEntity bp : e.getDetailList()) {
            if (brandNames.contains(bp.getBrandName())) {
                brand = this.generateBrandInfo(bp);
                brandNames.remove(bp.getBrandName());
                saveBrandList.add(brand);
                brandNameMap.put(brand.getBrandName(), brand);
            }
            brand = (BrandEntity)((Object)brandNameMap.get(bp.getBrandName()));
            BrandRelationEntity relation = new BrandRelationEntity();
            relation.setBrandId(brand.getId());
            relation.setBrandName(brand.getBrandName());
            relation.setBrandSid(brand.getSourceId());
            relation.setMaterialTypeCode(bp.getMaterialTypeCode());
            relation.setMaterialTypeId(bp.getMaterialTypeId());
            relation.setMaterialTypeName(bp.getMaterialTypeName());
            relation.setMaterialTypeSid(bp.getMaterialTypeSid());
            relation.setMaterialTypePid(bp.getMaterialTypePid());
            relation.setMaterialTypePname(bp.getMaterialTypePname());
            relation.setMaterialTypePsid(bp.getMaterialTypePsid());
            relation.setId(IdWorker.getId());
            relation.setSourceId(ZDSInterfaceCommonUtil.changeLongToGUID(relation.getId()));
            relation.setBrandEnabled(1);
            relation.setSupplierName(bp.getSupplierName());
            relation.setSupplierId(bp.getSupplierId());
            relation.setSupplierCode(bp.getSupplierCode());
            relation.setRelationEnabled(PlanConstant.INTEGER_NO);
            relation.setDbSupplierFlag(bp.getDbSupplierFlag());
            relation.setPushErpFlag(PlanConstant.INTEGER_NO);
            relation.setSupplierSid(bp.getSupplierSid());
            relation.setBrandSequence(0);
            relation.setBrandLabel(null);
            relation.setDelFlag("0");
            relation.setSourceMainId(e.getId());
            relation.setSourceDetailId(bp.getId());
            relation.setSupplierCharacter("0");
            saveRelations.add(relation);
            BrandRelationFlowEntity flow = new BrandRelationFlowEntity();
            flow.setBillPcUrl(this.BASE_HOST + "ejc-zdsmaterial-frontend/#/brandApply/card?id=" + e.getId());
            flow.setOperateTime(e.getCreateTime());
            flow.setOperateType("\u54c1\u724c\u65b0\u589e");
            flow.setOperateUserCode(e.getApplyUserCode());
            flow.setOperateUserId(e.getApplyUserId());
            flow.setOperateUserName(e.getApplyUserName());
            flow.setRelationId(relation.getId());
            flow.setSourceBillId(e.getId());
            flow.setSourceBillDetailId(bp.getId());
            relation.getDetailList().add(flow);
        }
        if (CollectionUtils.isNotEmpty(saveRelations) && CollectionUtils.isNotEmpty(dbRelations = this.relationService.checkRelation(saveRelations))) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c" + dbRelations.stream().map(r -> "\u3010\u7269\u6599\u5206\u7c7b\u3011" + r.getMaterialTypeName() + ",\u3010\u7269\u6599\u5206\u7c7b\u7f16\u7801\u3011" + r.getMaterialTypeCode() + ",\u3010\u54c1\u724c\u3011" + r.getBrandName()).collect(Collectors.joining("\u3001")) + "\u5df2\u5b58\u5728\uff01");
        }
        this.logger.info("\u54c1\u724c\u7533\u8bf7id-{}\u751f\u6548\uff0c\u65b0\u589e\u54c1\u724c-{}\u6761", (Object)e.getId(), (Object)saveBrandList.size());
        if (CollectionUtils.isNotEmpty(saveBrandList)) {
            this.brandService.saveOrUpdateBatch(saveBrandList, saveBrandList.size(), false);
            this.brandService.pushBrandToErp(new DataPushErpParam(BeanMapper.mapList(saveRelations, BrandRelationVO.class), e.getApplyUserId(), "brandAdd", "EJCBT202408000001"));
        }
        this.logger.info("\u54c1\u724c\u7533\u8bf7id-{}\u751f\u6548\uff0c\u65b0\u589e\u54c1\u724c\u5173\u7cfb-{}\u6761", (Object)e.getId(), (Object)saveRelations.size());
        if (CollectionUtils.isNotEmpty(saveRelations)) {
            List saveFlows = saveRelations.stream().flatMap(item -> item.getDetailList().stream()).collect(Collectors.toList());
            this.logger.info("\u672c\u6b21\u4fdd\u5b58\u54c1\u724c\u5173\u7cfb\u6d41\u6c34\uff1a{}\u6761", (Object)saveFlows.size());
            if (CollectionUtils.isNotEmpty(saveFlows)) {
                this.relationFlowService.saveOrUpdateBatch(saveFlows, saveFlows.size(), false);
            }
            this.relationService.saveOrUpdateBatch(saveRelations, saveBrandList.size(), false);
            this.relationService.syncRelationToErp(new DataPushErpParam(BeanMapper.mapList(saveRelations, BrandRelationVO.class), e.getApplyUserId(), "brandRelationAdd", "EJCBT202408000001"));
        }
    }

    private BrandEntity generateBrandInfo(BrandApplyDetailEntity bp) {
        BrandEntity brand = new BrandEntity();
        brand.setId(IdWorker.getId());
        brand.setSourceId(ZDSInterfaceCommonUtil.changeLongToGUID(brand.getId()));
        brand.setBrandName(bp.getBrandName());
        brand.setSourceType("2");
        brand.setEnabled(PlanConstant.INTEGER_YES);
        brand.setSequence(0);
        brand.setApproveUserId(bp.getApproveUserId());
        brand.setApproveUserCode(bp.getApproveUserCode());
        brand.setApproveUserName(bp.getApproveUserName());
        brand.setApproveUserSid(bp.getApproveUserSid());
        brand.setApplyDetailId(bp.getId());
        brand.setApplyId(bp.getApplyId());
        brand.setRelationEnabled(PlanConstant.INTEGER_NO);
        return brand;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private String doValidDate(BrandApplyEntity e) {
        if (CollectionUtils.isEmpty(e.getDetailList())) {
            return "\u64cd\u4f5c\u5931\u8d25\uff0c\u54c1\u724c\u4fe1\u606f\u4e3a\u7a7a";
        }
        String msg = this.setBrandApproveUser(e);
        BrandApplyDetailEntity brand = e.getDetailList().get(0);
        if (null == brand.getApproveUserId()) {
            return "\u64cd\u4f5c\u5931\u8d25\uff0c[\u7269\u6599\u5206\u7c7b\u540d\u79f0\uff1a" + brand.getMaterialTypeName() + ",\u54c1\u724c\uff1a" + brand.getBrandName() + "]\u65e0\u5bf9\u5e94\u5ba1\u6838\u4eba\uff01";
        }
        return msg;
    }

    private String setBrandApproveUser(BrandApplyEntity e) {
        ArrayList<Long> materialTypeIds = new ArrayList<Long>(e.getDetailList().stream().map(BrandApplyDetailEntity::getMaterialTypeId).collect(Collectors.toSet()));
        List<MaterialCategoryVO> categorys = this.materialCategoryService.getAllByIds(materialTypeIds);
        ArrayList<Long> categoryPids = new ArrayList<Long>(categorys.stream().map(MaterialCategoryVO::getParentId).collect(Collectors.toSet()));
        List<MatSupplierManagerEntity> dbList = this.matSupplierManagerService.getAllByCategoryIds(categorys.stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty(dbList)) {
            return "\u64cd\u4f5c\u5931\u8d25\uff0c\u54c1\u724c\u5bf9\u5e94\u5206\u7c7b\u672a\u8bbe\u7f6e\u5ba1\u6838\u4eba\uff01";
        }
        List<MaterialCategoryVO> categtoryParents = this.materialCategoryService.getAllByIds(categoryPids);
        Map<Long, MaterialCategoryVO> categtoryParentsMap = categtoryParents.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, MaterialCategoryVO> categtoryMap = categorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        HashMap managerMap = new HashMap();
        dbList.stream().forEach(item -> managerMap.put(item.getCategoryId(), item));
        MatSupplierManagerEntity approveUser = null;
        StringBuilder sp = new StringBuilder();
        for (BrandApplyDetailEntity brand : e.getDetailList()) {
            approveUser = (MatSupplierManagerEntity)((Object)managerMap.get(brand.getMaterialTypeId()));
            if (null != approveUser) {
                brand.setApproveUserCode(approveUser.getManagerCode());
                brand.setApproveUserId(approveUser.getManagerId());
            } else {
                sp.append("[\u7269\u6599\u5206\u7c7b\u540d\u79f0]\uff1a").append(brand.getMaterialTypeName()).append(", [\u5206\u7c7b\u7f16\u7801]\uff1a").append(brand.getMaterialTypeCode()).append(", [\u54c1\u724c]\uff1a").append(brand.getBrandName()).append("\u3001");
            }
            brand.setMaterialTypePid(categtoryMap.get(brand.getMaterialTypeId()).getParentId());
            brand.setMaterialTypePsid(categtoryParentsMap.get(categtoryMap.get(brand.getMaterialTypeId()).getParentId()).getSourceId());
            if (!StringUtils.isBlank((CharSequence)brand.getMaterialTypePname())) continue;
            brand.setMaterialTypePsid(categtoryParentsMap.get(categtoryMap.get(brand.getMaterialTypeId()).getParentId()).getName());
        }
        Set<String> userIdSet = e.getDetailList().stream().filter(item -> null != item.getApproveUserId()).map(item -> item.getApproveUserId().toString()).collect(Collectors.toSet());
        CommonResponse userResp = this.userApi.queryListByIds(userIdSet.toArray(new String[userIdSet.size()]));
        if (!userResp.isSuccess() || null == userResp.getData()) {
            this.logger.error("\u67e5\u8be2\u54c1\u724c\u5206\u7c7b\u5ba1\u6838\u4ebaids-{}\u4fe1\u606f\u5931\u8d25, {}", (Object)JSONObject.toJSONString(userIdSet), (Object)JSONObject.toJSONString((Object)userResp));
            return "\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u5ba1\u6838\u4eba\u4fe1\u606f\u5931\u8d25\uff01";
        }
        Map userMap = ((List)userResp.getData()).stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
        e.getDetailList().stream().filter(item -> null != item.getApproveUserId()).forEach(item -> {
            if (userMap.containsKey(item.getApproveUserId())) {
                item.setApproveUserSid(((UserVO)userMap.get(item.getApproveUserId())).getSourceId());
                item.setApproveUserName(((UserVO)userMap.get(item.getApproveUserId())).getUserName());
            }
        });
        return null;
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        JSONArray resp = new JSONArray();
        BrandApplyEntity e = (BrandApplyEntity)((Object)this.service.selectById(billId));
        String msg = this.setBrandApproveUser(e);
        BrandApplyDetailEntity brand = e.getDetailList().get(0);
        if (null == brand.getApproveUserId()) {
            return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c[\u7269\u6599\u5206\u7c7b\u540d\u79f0\uff1a" + brand.getMaterialTypeName() + ",\u54c1\u724c\uff1a" + brand.getBrandName() + "]\u65e0\u5bf9\u5e94\u5ba1\u6838\u4eba\uff01"));
        }
        JSONObject apprUser = new JSONObject();
        apprUser.put("userId", (Object)brand.getApproveUserId());
        apprUser.put("userName", (Object)brand.getApproveUserName());
        resp.add((Object)apprUser);
        return CommonResponse.success((Object)resp);
    }
}

