/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.asynchandler.bean.MaPushErpRecordsEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationEntity;
import com.ejianc.business.zdsmaterial.erp.bean.BrandRelationFlowEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.BrandRelationMapper;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationFlowService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.vo.BrandRelationVO;
import com.ejianc.business.zdsmaterial.erp.vo.BrandVO;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.business.zdssupplier.cons.PlanConstant;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierMaterialInfoApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierMaterialInfoVO;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.base.Stopwatch;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="brandRelationService")
public class BrandRelationServiceImpl
extends BaseServiceImpl<BrandRelationMapper, BrandRelationEntity>
implements IBrandRelationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BrandRelationMapper mapper;
    @Value(value="${erp.reqHost}")
    private String reqHost;
    @Autowired
    private QueueUtils queueUtils;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Lazy
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IBrandRelationFlowService relationFlowService;
    @Autowired
    private IMatSupplierApi supplierApi;
    @Autowired
    private IMatSupplierMaterialInfoApi matSupplierMaterialInfoApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    private final String CHECK_ERP_RELATION_URL = "/cefoc/yql/getBrandLibraryRelationList";

    @Override
    public List<BrandRelationEntity> checkRelation(List<BrandRelationEntity> saveRelations) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.and(q -> {
            saveRelations.stream().forEach(r -> q.or(iq -> (QueryWrapper)((QueryWrapper)iq.eq((Object)"material_type_id", (Object)r.getMaterialTypeId())).eq((Object)"brand_id", (Object)r.getBrandId())));
            return q;
        });
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandRelationEntity> getAllByCategoryId(Long categoryId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"material_type_id", (Object)categoryId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandRelationEntity> getByBrandId(Long brandId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"brand_id", (Object)brandId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandRelationEntity> getAllByIds(List<Long> ids) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    @Async(value="maContextCommonTask")
    public void syncRelationToErp(DataPushErpParam pushParam) {
        this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u63a8\u9001ERP-------------\u5f00\u59cb----------------");
        this.logger.info("\u672c\u6b21\u63a8\u9001ERP\u54c1\u724c\u4fe1\u606f\uff1a{}, \u63a8\u9001\u7c7b\u578b: {}", (Object)JSONObject.toJSONString((Object)pushParam.getPushData()), (Object)pushParam.getBillType());
        CommonResponse userResp = this.userApi.findUserByUserId(pushParam.getOperatorId());
        if (!userResp.isSuccess() || null == userResp.getData()) {
            this.logger.error("\u67e5\u8be2\u4eba\u5458id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)pushParam.getOperatorId(), (Object)JSONObject.toJSONString((Object)userResp));
            throw new BusinessException("\u67e5\u8be2\u64cd\u4f5c\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        UserVO operator = (UserVO)userResp.getData();
        List<Long> brandIds = pushParam.getPushData().stream().map(BrandRelationVO::getBrandId).collect(Collectors.toList());
        List<BrandVO> brandList = this.brandService.getAllByIds(brandIds);
        HashMap<Long, BrandVO> brandMap = new HashMap<Long, BrandVO>();
        for (BrandVO brand : brandList) {
            brandMap.put(brand.getId(), brand);
        }
        List sourceDetailList = pushParam.getPushData().stream().filter(item -> null != item.getSourceDetailId()).map(item -> item.getSourceDetailId()).collect(Collectors.toList());
        HashMap<Long, MatSupplierMaterialInfoVO> infoIdMap = new HashMap<Long, MatSupplierMaterialInfoVO>();
        HashMap<String, Object> infoMaterialBrandMap = new HashMap<String, Object>();
        HashMap<Long, ProjectPoolSetVO> projectMap = new HashMap<Long, ProjectPoolSetVO>();
        List supplierIds = pushParam.getPushData().stream().map(BrandRelationVO::getSupplierId).collect(Collectors.toList());
        CommonResponse supplierInfos = this.supplierApi.getAllByIds(supplierIds);
        HashMap<Long, MatSupplierVO> supplierMap = new HashMap<Long, MatSupplierVO>();
        if (supplierInfos.isSuccess()) {
            List supplierList = (List)supplierInfos.getData();
            supplierMap.putAll(supplierList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
        } else {
            this.logger.error("******* \u6839\u636e\u4f9b\u5e94\u5546id-{}\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString(supplierIds), (Object)JSONObject.toJSONString((Object)supplierInfos));
        }
        if (CollectionUtils.isNotEmpty(sourceDetailList)) {
            CommonResponse matInfoResp = this.matSupplierMaterialInfoApi.getAllBySupplierIds(supplierIds);
            if (!matInfoResp.isSuccess()) {
                this.logger.error("\u67e5\u8be2\u5bf9\u5e94\u4f9b\u5e94\u5546\u4f9b\u8d27\u5185\u5bb9\u5217\u8868\uff0c\u4f9b\u5e94\u5546ids-{}\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString(sourceDetailList), (Object)JSONObject.toJSONString((Object)matInfoResp));
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)matInfoResp.getData()))) {
                HashSet<Long> projectIds = new HashSet<Long>();
                for (Object info : (List)matInfoResp.getData()) {
                    infoIdMap.put(info.getId(), (MatSupplierMaterialInfoVO)info);
                    if (null != info.getMaterialId() && StringUtils.isNotBlank((CharSequence)info.getBrandId())) {
                        if (infoMaterialBrandMap.containsKey(info.getMaterialId().toString() + info.getBrandId()) && DateUtil.compareDate(info.getTerminalTime(), ((MatSupplierMaterialInfoVO)infoMaterialBrandMap.get(info.getMaterialId().toString() + info.getBrandId())).getTerminalTime()) > 1) {
                            infoMaterialBrandMap.put(info.getMaterialId().toString() + info.getBrandId(), info);
                        } else {
                            infoMaterialBrandMap.put(info.getMaterialId().toString() + info.getBrandId(), info);
                        }
                    }
                    if (null == info.getAffiliatedProjectId()) continue;
                    projectIds.add(info.getAffiliatedProjectId());
                }
                if (CollectionUtils.isNotEmpty(projectIds)) {
                    CommonResponse projectResp = this.projectPoolApi.queryProjectsByIds(new ArrayList(projectIds));
                    if (!projectResp.isSuccess()) {
                        this.logger.error("\u67e5\u8be2\u5bf9\u5e94\u4f9b\u5e94\u5546\u4f9b\u8d27\u5185\u5bb9\u5173\u8054\u9879\u76ee\u5217\u8868ids-{}\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString(projectIds), (Object)JSONObject.toJSONString((Object)projectResp));
                    } else if (CollectionUtils.isNotEmpty((Collection)((Collection)projectResp.getData()))) {
                        for (ProjectPoolSetVO project : (List)projectResp.getData()) {
                            projectMap.put(project.getId(), project);
                        }
                    }
                }
            }
        }
        String pushResult = null;
        String reqUrl = this.reqHost + ("brandRelationAdd".equals(pushParam.getPushType()) ? "/cefoc/yql/addBrandLibraryRelation" : "/cefoc/yql/upBrandLibraryRelation");
        MaPushErpRecordsEntity record = new MaPushErpRecordsEntity();
        record.setData(JSONObject.toJSONString((Object)pushParam.getPushData()));
        record.setOperatorId(pushParam.getOperatorId());
        record.setOperatorName(operator.getUserName());
        record.setBillType(pushParam.getBillType());
        record.setPushDate(new Date());
        record.setUrl(reqUrl);
        ArrayList<JSONObject> pushParams = new ArrayList<JSONObject>();
        JSONObject syncItem = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        MatSupplierMaterialInfoVO material = null;
        for (BrandRelationVO relation : pushParam.getPushData()) {
            if (!com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_YES.equals(relation.getDbSupplierFlag())) {
                this.logger.info("\u4f9b\u5e94\u5546-{}\u4e0d\u5728\u5e93\uff0c\u54c1\u724c\u5173\u7cfbid-{}\u8df3\u8fc7\u63a8\u9001\uff01", (Object)relation.getSupplierName(), (Object)relation.getId());
                continue;
            }
            syncItem = new JSONObject();
            syncItem.put("C_PS_BrandLibraryRelationOID", (Object)relation.getSourceId());
            syncItem.put("SYS_Deleted", (Object)(StringUtils.isNotBlank((CharSequence)relation.getDelFlag()) ? "1".equals(relation.getDelFlag()) : (null != relation.getRelationEnabled() ? Boolean.valueOf(relation.getRelationEnabled() != 1) : null)));
            syncItem.put("SYS_Created", (Object)sdf.format(relation.getCreateTime()));
            syncItem.put("SYS_LAST_UPD", null != relation.getUpdateTime() ? sdf.format(relation.getUpdateTime()) : null);
            syncItem.put("Enabled", (Object)(null != relation.getBrandEnabled() ? 1 == relation.getBrandEnabled() : (brandMap.containsKey(relation.getBrandId()) ? Boolean.valueOf(1 == ((BrandVO)brandMap.get(relation.getBrandId())).getRelationEnabled()) : null)));
            syncItem.put("BrandSid", (Object)relation.getBrandSid());
            syncItem.put("Memo", (Object)relation.getMemo());
            syncItem.put("CategorySid", (Object)relation.getMaterialTypeSid());
            syncItem.put("CategoryName", (Object)relation.getMaterialTypeName());
            syncItem.put("CategoryTwoSid", (Object)relation.getMaterialTypePsid());
            syncItem.put("CategoryTwoName", (Object)relation.getMaterialTypePname());
            if (!(StringUtils.isNotBlank((CharSequence)relation.getSupplierSid()) || supplierMap.containsKey(relation.getSupplierId()) && StringUtils.isNotBlank((CharSequence)((MatSupplierVO)supplierMap.get(relation.getSupplierId())).getThirdSourceId()))) {
                this.logger.error("\u4f9b\u5e94\u5546SID\u4e3a\u7a7a\uff0c\u54c1\u724c\u5173\u7cfb-{}\u63a8\u9001\u8df3\u8fc7", (Object)relation.getId());
                record.setBeforePushSupInfo("\u4f9b\u5e94\u5546SID\u4e3a\u7a7a\uff0c\u54c1\u724c\u5173\u7cfb-" + relation.getId().toString() + "\u63a8\u9001\u8df3\u8fc7");
                continue;
            }
            syncItem.put("SupplierSid", (Object)(StringUtils.isNotBlank((CharSequence)relation.getSupplierSid()) ? relation.getSupplierSid() : ((MatSupplierVO)supplierMap.get(relation.getSupplierId())).getThirdSourceId()));
            syncItem.put("SupplierCharacter", (Object)relation.getSupplierCharacter());
            syncItem.put("ApprHuman_sid", (Object)operator.getSourceId());
            syncItem.put("ApprHuman", (Object)operator.getUserName());
            if (infoIdMap.containsKey(relation.getSourceDetailId())) {
                material = (MatSupplierMaterialInfoVO)infoIdMap.get(relation.getSourceDetailId());
            }
            if (null == material && supplierMap.size() == 1) {
                material = (MatSupplierMaterialInfoVO)infoMaterialBrandMap.get(relation.getMaterialTypeId().toString() + relation.getBrandId());
            }
            if (null != material) {
                this.logger.info("materialInfo:{}", (Object)JSONObject.toJSONString((Object)material));
                syncItem.put("PropertyCode", StringUtils.isNotBlank((CharSequence)material.getPropertyValue()) ? (PlanConstant.EL_TO_ERP_MAT_MATERIAL_PROPERTY.containsKey(material.getPropertyValue()) ? PlanConstant.EL_TO_ERP_MAT_MATERIAL_PROPERTY.get(material.getPropertyValue()) : material.getPropertyValue()) : null);
                if (null != material.getAffiliatedProjectId()) {
                    syncItem.put("AffiliatedProject", (Object)material.getAffiliatedProjectName());
                    if (projectMap.containsKey(material.getAffiliatedProjectId())) {
                        syncItem.put("AccountingProjectSet_FK", (Object)((ProjectPoolSetVO)projectMap.get(material.getAffiliatedProjectId())).getSourceId());
                    }
                }
            } else if ("0".equals(relation.getSupplierCharacter())) {
                syncItem.put("PropertyCode", (Object)"0");
            }
            pushParams.add(syncItem);
        }
        if (CollectionUtils.isEmpty(pushParams)) {
            this.logger.error("\u53ef\u63a8\u9001\u54c1\u724c\u5173\u7cfb\u4e3a\u7a7a\uff0c\u63a8\u9001\u4efb\u52a1\u7ed3\u675f\uff01");
            record.setPushResult("\u53ef\u63a8\u9001\u54c1\u724c\u5173\u7cfb\u4e3a\u7a7a\uff0c\u63a8\u9001\u4efb\u52a1\u7ed3\u675f\uff01");
            record.setSucFlag("0");
            this.updateRelationPushFlag(pushParam.getPushData().stream().map(BaseVO::getId).collect(Collectors.toList()), pushResult);
            this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)record)));
            return;
        }
        Map<String, String> headers = null;
        try {
            Stopwatch start = Stopwatch.createStarted();
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(pushParams), headers, (Integer)180000, (Integer)180000);
            this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(pushParams, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
            Stopwatch stop = start.stop();
            record.setErpResult(reqResp);
            record.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
            this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u63a8\u9001ERP\u8017\u65f6\uff1a{}\u79d2", (Object)record.getErpHandleSeconds());
            JSONObject reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                pushResult = "1";
            } else {
                pushResult = "0";
                record.setFailType("ERP\u6570\u636e\u5904\u7406\u5931\u8d25\uff01");
                if (!"brandRelationAdd".equals(pushParam.getPushType())) {
                    this.checkAndRePush(pushParams);
                }
            }
            record.setSucFlag(pushResult);
        }
        catch (Exception e) {
            this.logger.error("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u540c\u6b65ERP\u5f02\u5e38\uff0c", (Throwable)e);
            record.setSucFlag("0");
            pushResult = "0";
            record.setFailType("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u540c\u6b65ERP\uff0c\u8bf7\u6c42\u5f02\u5e38\uff01");
        }
        this.updateRelationPushFlag(pushParam.getPushData().stream().map(BaseVO::getId).collect(Collectors.toList()), pushResult);
        this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)record)));
        this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u63a8\u9001ERP-------------\u7ed3\u675f----------------");
    }

    private void checkAndRePush(List<JSONObject> pushParams) {
        this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f  \u68c0\u6d4b \u5e76 \u63a8\u9001ERP-------------\u5f00\u59cb----------------");
        this.logger.info("\u672c\u6b21\u68c0\u6d4b\u5e76\u91cd\u63a8ERP\u54c1\u724c\u4fe1\u606f\uff1a{}, \u63a8\u9001\u7c7b\u578b: {}", (Object)JSONObject.toJSONString(pushParams));
        MaPushErpRecordsEntity record = new MaPushErpRecordsEntity();
        record.setData(JSONObject.toJSONString(pushParams));
        record.setPushDate(new Date());
        record.setBeforePushSupInfo("\u54c1\u724c\u5173\u7cfb\u68c0\u67e5\u91cd\u65b0\u63a8\u9001\u3002\u3002\u3002\u3002");
        record.setUrl(this.reqHost + "/cefoc/yql/upBrandLibraryRelation");
        String reqParams = pushParams.stream().map(item -> item.getString("C_PS_BrandLibraryRelationOID")).collect(Collectors.joining(","));
        Map<String, String> headers = null;
        JSONObject reqJson = null;
        String pushResult = null;
        try {
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            String queryUrl = this.reqHost + "/cefoc/yql/getBrandLibraryRelationList" + "?inputStr=" + reqParams;
            String reqResp = HttpTookit.postByJson((String)queryUrl, (String)JSONObject.toJSONString((Object)new JSONObject()), headers, (Integer)180000, (Integer)180000);
            this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606fERP\u67e5\u8be2\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{queryUrl, reqParams, reqResp});
            reqJson = JSONObject.parseObject((String)reqResp);
            if ("ok".equals(reqJson.getString("status"))) {
                Stopwatch stop;
                Stopwatch start;
                JSONArray relationArr = reqJson.getJSONArray("data");
                List relationSids = relationArr.stream().map(item -> ((JSONObject)item).getString("C_PS_BrandLibraryRelationOID")).collect(Collectors.toList());
                ArrayList<JSONObject> addList = new ArrayList<JSONObject>();
                ArrayList<JSONObject> updateList = new ArrayList<JSONObject>();
                for (JSONObject relationJson : pushParams) {
                    if (relationSids.contains(relationJson.getString("C_PS_BrandLibraryRelationOID"))) {
                        updateList.add(relationJson);
                        continue;
                    }
                    addList.add(relationJson);
                }
                this.logger.info("\u672c\u6b21\u68c0\u6d4b\u540e\uff0c\u65b0\u589e\u54c1\u724c\u5173\u7cfb{}\u6761", (Object)addList.size());
                if (CollectionUtils.isNotEmpty(addList)) {
                    MaPushErpRecordsEntity newRecord = (MaPushErpRecordsEntity)((Object)BeanMapper.map((Object)((Object)record), MaPushErpRecordsEntity.class));
                    headers = ZDSInterfaceCommonUtil.getErpHeaders();
                    start = Stopwatch.createStarted();
                    reqResp = HttpTookit.postByJson((String)(this.reqHost + "/cefoc/yql/addBrandLibraryRelation"), (String)JSONObject.toJSONString(addList), headers, (Integer)180000, (Integer)180000);
                    this.logger.info("\u54c1\u724c\u5173\u7cfb\u65b0\u589e\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{this.reqHost + "/cefoc/yql/addBrandLibraryRelation", JSONObject.toJSONString(addList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
                    stop = start.stop();
                    newRecord.setErpResult(reqResp);
                    newRecord.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
                    this.logger.info("\u54c1\u724c\u5173\u7cfb\u65b0\u589e\u63a8\u9001ERP\u8017\u65f6\uff1a{}\u79d2", (Object)record.getErpHandleSeconds());
                    reqJson = JSONObject.parseObject((String)reqResp);
                    if ("ok".equals(reqJson.getString("status"))) {
                        pushResult = "1";
                    } else {
                        pushResult = "0";
                        newRecord.setFailType("ERP\u6570\u636e\u5904\u7406\u5931\u8d25\uff01");
                    }
                    newRecord.setSucFlag(pushResult);
                    this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)newRecord)));
                }
                this.logger.info("\u672c\u6b21\u68c0\u6d4b\u540e\uff0c\u66f4\u65b0\u54c1\u724c\u5173\u7cfb{}\u6761", (Object)updateList.size());
                if (CollectionUtils.isNotEmpty(updateList)) {
                    MaPushErpRecordsEntity updateRecord = (MaPushErpRecordsEntity)((Object)BeanMapper.map((Object)((Object)record), MaPushErpRecordsEntity.class));
                    headers = ZDSInterfaceCommonUtil.getErpHeaders();
                    start = Stopwatch.createStarted();
                    reqResp = HttpTookit.postByJson((String)(this.reqHost + "/cefoc/yql/upBrandLibraryRelation"), (String)JSONObject.toJSONString(updateList), headers, (Integer)180000, (Integer)180000);
                    this.logger.info("\u54c1\u724c\u5173\u7cfb\u66f4\u65b0\u63a8\u9001ERP\uff1aurl-{}, \u53c2\u6570\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", new Object[]{this.reqHost + "/cefoc/yql/upBrandLibraryRelation", JSONObject.toJSONString(updateList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
                    stop = start.stop();
                    updateRecord.setErpResult(reqResp);
                    updateRecord.setErpHandleSeconds(stop.elapsed(TimeUnit.SECONDS));
                    this.logger.info("\u54c1\u724c\u5173\u7cfb\u66f4\u65b0\u63a8\u9001ERP\u8017\u65f6\uff1a{}\u79d2", (Object)record.getErpHandleSeconds());
                    reqJson = JSONObject.parseObject((String)reqResp);
                    if ("ok".equals(reqJson.getString("status"))) {
                        pushResult = "1";
                    } else {
                        pushResult = "0";
                        updateRecord.setFailType("ERP\u6570\u636e\u5904\u7406\u5931\u8d25\uff01");
                    }
                    updateRecord.setSucFlag(pushResult);
                    this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)record)));
                }
            } else {
                this.logger.error("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u540c\u6b65ERP\u5931\u8d25\uff0c{}", (Object)reqResp);
                record.setSucFlag("0");
                record.setFailType("\u54c1\u724c\u5173\u7cfb\u4fe1\u606fERP\u67e5\u8be2\uff0c\u8bf7\u6c42\u5931\u8d25");
                this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)record)));
            }
        }
        catch (Exception e) {
            this.logger.error("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u540c\u6b65ERP\u5f02\u5e38\uff0c", (Throwable)e);
            record.setSucFlag("0");
            record.setFailType("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f\u540c\u6b65ERP\uff0c\u8bf7\u6c42\u5f02\u5e38\uff01");
            this.queueUtils.sendMq("ma_push_erp_record_" + this.profile, JSONObject.toJSONString((Object)((Object)record)));
        }
        this.logger.info("\u54c1\u724c\u5173\u7cfb\u4fe1\u606f  \u68c0\u6d4b \u5e76 \u63a8\u9001ERP-------------\u7ed3\u675f----------------");
    }

    @Override
    public List<BrandRelationEntity> getAllByCategoryIds(List<Long> categoryIds, String brandName, String supplierName) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"material_type_id", categoryIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        if (StringUtils.isNotBlank((CharSequence)brandName)) {
            query.like((Object)"brand_name", (Object)brandName);
        }
        if (StringUtils.isNotBlank((CharSequence)supplierName)) {
            query.like((Object)"supplier_name", (Object)supplierName);
        }
        query.orderByAsc((Object[])new String[]{"material_type_code", "brand_name", "supplier_name"});
        return super.list((Wrapper)query);
    }

    @Override
    public String saveOrUpdateRelations(List<BrandRelationVO> relations) {
        List<BrandRelationEntity> supplierRelations = this.getAllBySupplierId(relations.get(0).getSupplierId());
        ArrayList<Long> categoryIds = new ArrayList<Long>(relations.stream().map(BrandRelationVO::getMaterialTypeId).collect(Collectors.toSet()));
        boolean generateFlow = relations.get(0).isGenerateFlowFlag();
        Long operator = relations.get(0).getOperatorId();
        String operateType = relations.get(0).getOperateType();
        List<MaterialCategoryVO> categorys = this.categoryService.getAllByIds(categoryIds);
        ArrayList<Long> categoryPids = new ArrayList<Long>(categorys.stream().map(MaterialCategoryVO::getParentId).collect(Collectors.toSet()));
        List<MaterialCategoryVO> categtoryParents = this.categoryService.getAllByIds(categoryPids);
        Map<Long, MaterialCategoryVO> categtoryParentsMap = categtoryParents.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, MaterialCategoryVO> categtoryMap = categorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<Long, BrandRelationVO> relationMap = relations.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item));
        Map<String, List<BrandRelationVO>> relationKeyMap = null;
        ArrayList<Long> brandIds = new ArrayList<Long>(relations.stream().map(BrandRelationVO::getBrandId).collect(Collectors.toSet()));
        List<BrandVO> brandList = this.brandService.getAllByIds(brandIds);
        Map<Long, BrandVO> brandMap = brandList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        ArrayList<BrandRelationEntity> saveList = new ArrayList<BrandRelationEntity>();
        ArrayList<BrandRelationEntity> updateList = new ArrayList<BrandRelationEntity>();
        ArrayList<BrandRelationEntity> delList = new ArrayList<BrandRelationEntity>();
        BrandRelationVO tmp = null;
        MaterialCategoryVO category = null;
        MaterialCategoryVO categoryP = null;
        BrandVO brand = null;
        BrandRelationEntity relation = null;
        ArrayList<BrandRelationFlowEntity> flowList = new ArrayList<BrandRelationFlowEntity>();
        Long operatorId = relations.get(0).getOperatorId();
        UserVO user = null;
        if (null != operatorId) {
            CommonResponse userResp = this.userApi.findUserByUserId(operatorId);
            if (!userResp.isSuccess() || null == userResp.getData()) {
                this.logger.error("\u67e5\u8be2\u4eba\u5458id-{}\u4fe1\u606f\u5931\u8d25", (Object)operatorId);
            } else {
                user = (UserVO)userResp.getData();
            }
        }
        HashMap<Long, MatSupplierMaterialInfoVO> supplierMaterialMap = new HashMap<Long, MatSupplierMaterialInfoVO>();
        HashMap<String, List<MatSupplierMaterialInfoVO>> supplierMaterialBrandMap = new HashMap<String, List<MatSupplierMaterialInfoVO>>();
        if (StringUtils.isNotBlank((CharSequence)relations.get(0).getSupplierSid()) && null != relations.get(0).getSupplierId()) {
            CommonResponse supplierResp = this.supplierApi.getOneById(relations.get(0).getSupplierId());
            if (!supplierResp.isSuccess() || null == supplierResp.getData()) {
                this.logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546id-{}\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)supplierResp));
            } else {
                MatSupplierVO supplierVO = (MatSupplierVO)supplierResp.getData();
                relations.forEach(r -> r.setSupplierSid(supplierVO.getThirdSourceId()));
                supplierMaterialMap.putAll(supplierVO.getMaterialInfoList().stream().collect(Collectors.toMap(item -> item.getId(), item -> item)));
            }
        }
        BrandRelationEntity upDbRelation = null;
        if (CollectionUtils.isNotEmpty(supplierRelations)) {
            Iterator<BrandRelationEntity> it = supplierRelations.iterator();
            while (it.hasNext()) {
                relation = null;
                tmp = null;
                upDbRelation = it.next();
                if (null == upDbRelation.getSourceDetailId() || !relationMap.containsKey(upDbRelation.getSourceDetailId())) continue;
                relation = upDbRelation;
                tmp = relationMap.get(upDbRelation.getSourceDetailId());
                supplierMaterialMap.remove(upDbRelation.getSourceDetailId());
                upDbRelation.setPushErpFlag(com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_NO);
                upDbRelation.setMaterialTypeId(tmp.getMaterialTypeId());
                category = categtoryMap.get(upDbRelation.getMaterialTypeId());
                upDbRelation.setMaterialTypeCode(category.getCode());
                upDbRelation.setMaterialTypeName(category.getName());
                upDbRelation.setMaterialTypeSid(category.getSourceId());
                categoryP = categtoryParentsMap.get(category.getParentId());
                upDbRelation.setMaterialTypePid(categoryP.getId());
                upDbRelation.setMaterialTypePname(categoryP.getName());
                upDbRelation.setMaterialTypePsid(categoryP.getSourceId());
                brand = brandMap.get(tmp.getBrandId());
                upDbRelation.setBrandId(brand.getId());
                upDbRelation.setBrandName(brand.getBrandName());
                upDbRelation.setBrandSid(brand.getSourceId());
                upDbRelation.setSupplierName(tmp.getSupplierName());
                upDbRelation.setSupplierCode(tmp.getSupplierCode());
                upDbRelation.setSupplierSid(tmp.getSupplierSid());
                upDbRelation.setSupplierCharacter(tmp.getSupplierCharacter());
                upDbRelation.setBrandLabel(null);
                upDbRelation.setDbSupplierFlag(com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_YES);
                updateList.add(upDbRelation);
                relationMap.remove(upDbRelation.getSourceDetailId());
                it.remove();
            }
            supplierMaterialBrandMap.putAll(supplierMaterialMap.values().stream().collect(Collectors.groupingBy(item -> item.getMaterialId().toString() + item.getBrandId())));
            MatSupplierMaterialInfoVO tmpInfo = null;
            relationKeyMap = relations.stream().collect(Collectors.groupingBy(item -> item.getMaterialTypeId().toString() + item.getBrandId().toString()));
            List<BrandRelationVO> tmpRelationList = null;
            for (BrandRelationEntity dbRelation : supplierRelations) {
                BrandRelationFlowEntity flow;
                relation = null;
                tmp = null;
                if (null == relation && relationKeyMap.containsKey(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString())) {
                    relation = dbRelation;
                    tmpRelationList = relationKeyMap.get(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString());
                    if (CollectionUtils.isNotEmpty(tmpRelationList)) {
                        tmp = tmpRelationList.get(0);
                        tmpRelationList.remove(tmp);
                        if (tmpRelationList.isEmpty()) {
                            relationKeyMap.remove(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString());
                        }
                    }
                }
                if (supplierMaterialBrandMap.containsKey(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString()) && CollectionUtils.isNotEmpty((Collection)((Collection)supplierMaterialBrandMap.get(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString())))) {
                    tmpInfo = (MatSupplierMaterialInfoVO)((List)supplierMaterialBrandMap.get(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString())).get(0);
                    ((List)supplierMaterialBrandMap.get(dbRelation.getMaterialTypeId().toString() + dbRelation.getBrandId().toString())).remove(tmpInfo);
                }
                if (null == tmp) {
                    dbRelation.setDelFlag("1");
                    delList.add(dbRelation);
                    continue;
                }
                if ("1".equals(tmp.getDelFlag())) {
                    dbRelation.setDelFlag("1");
                    delList.add(dbRelation);
                } else {
                    dbRelation.setPushErpFlag(com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_NO);
                    dbRelation.setMaterialTypeId(tmp.getMaterialTypeId());
                    category = categtoryMap.get(dbRelation.getMaterialTypeId());
                    dbRelation.setMaterialTypeCode(category.getCode());
                    dbRelation.setMaterialTypeName(category.getName());
                    dbRelation.setMaterialTypeSid(category.getSourceId());
                    categoryP = categtoryParentsMap.get(category.getParentId());
                    dbRelation.setMaterialTypePid(categoryP.getId());
                    dbRelation.setMaterialTypePname(categoryP.getName());
                    dbRelation.setMaterialTypePsid(categoryP.getSourceId());
                    brand = brandMap.get(tmp.getBrandId());
                    dbRelation.setBrandId(brand.getId());
                    dbRelation.setBrandName(brand.getBrandName());
                    dbRelation.setBrandSid(brand.getSourceId());
                    dbRelation.setSupplierName(tmp.getSupplierName());
                    dbRelation.setSupplierCode(tmp.getSupplierCode());
                    dbRelation.setSupplierSid(tmp.getSupplierSid());
                    dbRelation.setSupplierCharacter(tmp.getSupplierCharacter());
                    dbRelation.setBrandLabel(null);
                    dbRelation.setDbSupplierFlag(com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_YES);
                    if (null != tmpInfo) {
                        dbRelation.setSourceDetailId(tmpInfo.getId());
                    }
                    updateList.add(dbRelation);
                }
                if (null != tmp) {
                    if (CollectionUtils.isNotEmpty((Collection)tmp.getDetailList())) {
                        flowList.addAll(BeanMapper.mapList((Iterable)tmp.getDetailList(), BrandRelationFlowEntity.class));
                    } else if (generateFlow) {
                        flow = new BrandRelationFlowEntity();
                        flow.setSourceBillId(tmp.getSourceMainId());
                        flow.setSourceBillDetailId(tmp.getSourceDetailId());
                        flow.setRelationId(relation.getId());
                        flow.setOperateTime(new Date());
                        flow.setOperateUserId(operator);
                        flow.setOperateType(operateType + "-\u66f4\u65b0\u54c1\u724c\u5173\u7cfb");
                        flow.setBillPcUrl(tmp.getPcUrl());
                        if (null != user) {
                            flow.setOperateUserCode(user.getUserCode());
                            flow.setOperateUserName(user.getUserName());
                        }
                        flowList.add(flow);
                    }
                } else if (null != relation && generateFlow) {
                    flow = new BrandRelationFlowEntity();
                    flow.setSourceBillId(relation.getSourceMainId());
                    flow.setSourceBillDetailId(relation.getSourceDetailId());
                    flow.setRelationId(relation.getId());
                    flow.setOperateTime(new Date());
                    flow.setOperateUserId(operator);
                    flow.setOperateType(operateType + "-\u5220\u9664\u54c1\u724c\u5173\u7cfb");
                    if (null != user) {
                        flow.setOperateUserCode(user.getUserCode());
                        flow.setOperateUserName(user.getUserName());
                    }
                    flowList.add(flow);
                }
                relationMap.remove(tmp.getSourceDetailId());
            }
        }
        if (MapUtils.isNotEmpty(relationMap)) {
            for (BrandRelationVO newRelation : relationMap.values()) {
                relation = new BrandRelationEntity();
                relation.setPushErpFlag(com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_NO);
                relation.setMaterialTypeId(newRelation.getMaterialTypeId());
                category = categtoryMap.get(relation.getMaterialTypeId());
                relation.setMaterialTypeCode(category.getCode());
                relation.setMaterialTypeName(category.getName());
                relation.setMaterialTypeSid(category.getSourceId());
                categoryP = categtoryParentsMap.get(category.getParentId());
                relation.setMaterialTypePid(categoryP.getId());
                relation.setMaterialTypePname(categoryP.getName());
                relation.setMaterialTypePsid(categoryP.getSourceId());
                brand = brandMap.get(newRelation.getBrandId());
                if (null == brand) {
                    this.logger.info("\u4f9b\u5e94\u5546id-{}\u5bf9\u5e94\u54c1\u724c\u3010id-{},brandName-{}\u3011\u4fe1\u606f\u65e0\u5339\u914d\u4fe1\u606f\u6216\u5df2\u88ab\u5220\u9664", new Object[]{newRelation.getSupplierId(), newRelation.getBrandId(), newRelation.getBrandName()});
                    continue;
                }
                relation.setBrandId(brand.getId());
                relation.setBrandName(brand.getBrandName());
                relation.setBrandSid(brand.getSourceId());
                relation.setBrandLabel(null);
                relation.setDbSupplierFlag(com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_YES);
                relation.setRelationEnabled(com.ejianc.business.zdsmaterial.cons.PlanConstant.INTEGER_YES);
                relation.setSupplierId(newRelation.getSupplierId());
                relation.setSupplierSid(newRelation.getSupplierSid());
                relation.setSupplierCode(newRelation.getSupplierCode());
                relation.setSupplierName(newRelation.getSupplierName());
                relation.setSourceMainId(newRelation.getSourceMainId());
                relation.setSourceDetailId(newRelation.getSourceDetailId());
                relation.setId(IdWorker.getId());
                relation.setSourceId(ZDSInterfaceCommonUtil.changeLongToGUID(relation.getId()));
                relation.setSupplierCharacter(newRelation.getSupplierCharacter());
                if (CollectionUtils.isNotEmpty((Collection)newRelation.getDetailList())) {
                    flowList.addAll(BeanMapper.mapList((Iterable)newRelation.getDetailList(), BrandRelationFlowEntity.class));
                } else if (generateFlow) {
                    BrandRelationFlowEntity flow = new BrandRelationFlowEntity();
                    flow.setSourceBillId(newRelation.getSourceMainId());
                    flow.setSourceBillDetailId(newRelation.getSourceDetailId());
                    flow.setRelationId(relation.getId());
                    flow.setOperateTime(new Date());
                    flow.setOperateUserId(newRelation.getOperatorId());
                    flow.setOperateType(newRelation.getOperateType() + "-\u65b0\u589e\u54c1\u724c\u5173\u7cfb");
                    flow.setBillPcUrl(newRelation.getPcUrl());
                    if (null != user) {
                        flow.setOperateUserCode(user.getUserCode());
                        flow.setOperateUserName(user.getUserName());
                    }
                    flowList.add(flow);
                }
                saveList.add(relation);
            }
        }
        String billType = relations.get(0).getBillType();
        this.logger.info("\u672c\u6b21\u65b0\u589e\u4f9b\u5e94\u5546\u54c1\u724c\u5173\u7cfb\uff1a{}\u6761", (Object)saveList.size());
        if (CollectionUtils.isNotEmpty(saveList)) {
            super.saveOrUpdateBatch(saveList, saveList.size(), false);
            List syncList = saveList.stream().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(syncList)) {
                this.queueUtils.sendMq("data_push_erp_queue_" + this.profile, JSONObject.toJSONString((Object)new DataPushErpParam(BeanMapper.mapList(syncList, BrandRelationVO.class), operatorId, "brandRelationAdd", billType)));
            }
        }
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u4f9b\u5e94\u5546\u54c1\u724c\u5173\u7cfb\uff1a{}\u6761", (Object)updateList.size());
        if (CollectionUtils.isNotEmpty(updateList)) {
            super.saveOrUpdateBatch(updateList, updateList.size(), false);
            this.queueUtils.sendMq("data_push_erp_queue_" + this.profile, JSONObject.toJSONString((Object)new DataPushErpParam(BeanMapper.mapList(updateList, BrandRelationVO.class), operatorId, "brandRelationChange", billType)));
        }
        this.logger.info("\u672c\u6b21\u5220\u9664\u4f9b\u5e94\u5546\u54c1\u724c\u5173\u7cfb\uff1a{}\u6761", (Object)delList.size());
        if (CollectionUtils.isNotEmpty(delList)) {
            super.removeByIds((Collection)delList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            this.queueUtils.sendMq("data_push_erp_queue_" + this.profile, JSONObject.toJSONString((Object)new DataPushErpParam(BeanMapper.mapList(delList, BrandRelationVO.class), operatorId, "brandRelationChange", billType)));
        }
        this.logger.info("\u672c\u6b21\u4fdd\u5b58\u6d41\u6c34\uff1a{}\u6761", (Object)flowList.size());
        if (CollectionUtils.isNotEmpty(flowList)) {
            this.relationFlowService.saveOrUpdateBatch(flowList, flowList.size(), false);
        }
        return null;
    }

    @Override
    public List<BrandRelationEntity> getAllBySupplierId(Long supplierId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"supplier_id", (Object)supplierId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        return super.list((Wrapper)query);
    }

    @Override
    public List<BrandRelationEntity> getTerminatedRelations() {
        return this.mapper.getTerminatedRelations();
    }

    private void updateRelationPushFlag(List<Long> ids, String pushResult) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", ids);
        update.set((Object)"push_erp_flag", (Object)pushResult);
        super.update((Wrapper)update);
    }

    private void initContext(Long userId) {
        String initContextUrl = this.environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId=" + userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        try {
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if (null != userContext) {
                    authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                }
                if (authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                    InvocationInfoProxy.setParameter((String)"authority", (String)authtoken.toString());
                }
                if (null != userContext) {
                    InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

