/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.enums.DeliveryAcceptStatusEnums;
import com.ejianc.business.zdsmaterial.erp.mapper.DeliveryDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IDeliveryService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deliveryDetailService")
public class DeliveryDetailServiceImpl
extends BaseServiceImpl<DeliveryDetailMapper, DeliveryDetailEntity>
implements IDeliveryDetailService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private DeliveryDetailMapper mapper;

    @Override
    public void updateDeliveryResNum(AcceptEntity entity, boolean flag) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"delivery_id", (Object)entity.getDeliveryBillId());
        List list = super.list((Wrapper)queryWrapper);
        HashMap<Long, BigDecimal> returnOrderMap = new HashMap<Long, BigDecimal>();
        BigDecimal deliveryTaxMny = BigDecimal.ZERO;
        BigDecimal deliveryMny = BigDecimal.ZERO;
        for (DeliveryDetailEntity detail : list) {
            BigDecimal alreadyNum;
            BigDecimal decimal = BigDecimal.ZERO;
            if (flag) {
                BigDecimal deliveryNum = detail.getDeliveryNum();
                alreadyNum = detail.getAlreadyNum();
                decimal = ComputeUtil.safeSub((BigDecimal)deliveryNum, (BigDecimal)alreadyNum);
                returnOrderMap.put(detail.getSourceDetailId(), decimal);
                BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)alreadyNum, (BigDecimal)detail.getDetailTaxPrice());
                BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)alreadyNum, (BigDecimal)detail.getDetailPrice());
                BigDecimal tax = ComputeUtil.safeSub((BigDecimal)taxMny, (BigDecimal)mny);
                detail.setDetailTaxMny(taxMny);
                detail.setDetailMny(mny);
                detail.setDetailTax(tax);
                deliveryTaxMny = ComputeUtil.safeAdd((BigDecimal)deliveryTaxMny, (BigDecimal)taxMny);
                deliveryMny = ComputeUtil.safeAdd((BigDecimal)deliveryMny, (BigDecimal)mny);
            } else {
                returnOrderMap.put(detail.getSourceDetailId(), detail.getReleaseNum());
                BigDecimal releaseNum = detail.getReleaseNum();
                alreadyNum = detail.getAlreadyNum();
                BigDecimal decimal1 = ComputeUtil.safeAdd((BigDecimal)releaseNum, (BigDecimal)alreadyNum);
                BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)decimal1, (BigDecimal)detail.getDetailTaxPrice());
                BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)decimal1, (BigDecimal)detail.getDetailPrice());
                BigDecimal tax = ComputeUtil.safeSub((BigDecimal)taxMny, (BigDecimal)mny);
                detail.setDetailTaxMny(taxMny);
                detail.setDetailMny(mny);
                detail.setDetailTax(tax);
                deliveryTaxMny = ComputeUtil.safeAdd((BigDecimal)deliveryTaxMny, (BigDecimal)taxMny);
                deliveryMny = ComputeUtil.safeAdd((BigDecimal)deliveryMny, (BigDecimal)mny);
            }
            detail.setReleaseNum(decimal);
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)entity.getDeliveryBillId());
        updateWrapper.set((Object)"delivery_tax_mny", (Object)deliveryTaxMny);
        updateWrapper.set((Object)"delivery_mny", (Object)deliveryMny);
        this.deliveryService.update((Wrapper)updateWrapper);
        this.orderDetailService.returnDeliveryNum(returnOrderMap, flag);
        super.saveOrUpdateBatch((Collection)list);
    }

    @Override
    public boolean returnAlreadyNum(AcceptEntity entity, boolean addFlag) {
        HashMap<Long, AcceptDetailEntity> detailNumMapNew = new HashMap<Long, AcceptDetailEntity>();
        for (AcceptDetailEntity detail : entity.getDetailList()) {
            detailNumMapNew.put(detail.getSourceDetailId(), detail);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", detailNumMapNew.keySet());
        List list = super.list((Wrapper)queryWrapper);
        for (DeliveryDetailEntity detail : list) {
            BigDecimal decimal;
            if (!detailNumMapNew.containsKey(detail.getId())) continue;
            BigDecimal checkNum = decimal = ((AcceptDetailEntity)((Object)detailNumMapNew.get(detail.getId()))).getCheckNum();
            BigDecimal alreadyNum = detail.getAlreadyNum();
            if (addFlag) {
                if ("del".equals(((AcceptDetailEntity)((Object)detailNumMapNew.get(detail.getId()))).getRowState())) {
                    checkNum = ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)decimal);
                    alreadyNum = ComputeUtil.safeSub((BigDecimal)alreadyNum, (BigDecimal)decimal);
                } else {
                    alreadyNum = ComputeUtil.safeAdd((BigDecimal)alreadyNum, (BigDecimal)decimal);
                    checkNum = decimal;
                }
            } else {
                alreadyNum = ComputeUtil.safeSub((BigDecimal)alreadyNum, (BigDecimal)decimal);
                checkNum = decimal;
            }
            detail.setCheckNum(checkNum);
            detail.setAlreadyNum(alreadyNum);
        }
        DeliveryEntity deliveryEntity = new DeliveryEntity();
        deliveryEntity.setDetailList(list);
        deliveryEntity.setOrderId(entity.getOrderBillId());
        this.orderService.returnAcceptedNum(deliveryEntity, addFlag);
        super.saveOrUpdateBatch((Collection)list);
        return true;
    }

    @Override
    public void checkAcceptStatus(Long id) {
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        List<DeliveryDetailEntity> detailList = deliveryEntity.getDetailList();
        boolean allFlag = false;
        for (DeliveryDetailEntity detail : detailList) {
            if (!ComputeUtil.isGreaterThan((BigDecimal)detail.getAlreadyNum(), (BigDecimal)BigDecimal.ZERO)) continue;
            allFlag = true;
            break;
        }
        if (allFlag) {
            this.deliveryService.updateAcceptStatus(id, DeliveryAcceptStatusEnums.\u5206\u6279\u9a8c\u6536.getCode());
        } else {
            this.deliveryService.updateAcceptStatus(id, DeliveryAcceptStatusEnums.\u5f85\u9a8c\u6536.getCode());
        }
    }

    @Override
    public List<DeliveryDetailEntity> getAllByDeliveryId(Long deliveryId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"delivery_id", (Object)deliveryId);
        return super.list((Wrapper)query);
    }

    @Override
    public void deleteByDeliveryId(Long deliveryId) {
        this.mapper.deleteByDeliveryId(deliveryId);
    }
}

