/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.erp.bean.FeedbackDetailFileEntity;
import com.ejianc.business.zdsmaterial.erp.bean.FeedbackEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.FeedbackMapper;
import com.ejianc.business.zdsmaterial.erp.service.IFeedbackService;
import com.ejianc.business.zdsmaterial.erp.vo.FeedbackVO;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.business.zdsmaterial.util.PushFileUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="feedbackService")
public class FeedbackServiceImpl
extends BaseServiceImpl<FeedbackMapper, FeedbackEntity>
implements IFeedbackService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PushFileUtil pushFileUtil;

    @Override
    public JSONObject saveSyncBill(JSONObject reqData) {
        String transData = reqData.getString("transData");
        this.logger.info("\u63a5\u6536\u5230\u4f9b\u65b9\u63a8\u9001\u610f\u89c1\u53cd\u9988\u5355\uff1a{}>>>>>>>>>>>>>>>>>>>>>>>>", (Object)transData);
        FeedbackVO vo = (FeedbackVO)JSONObject.parseObject((String)transData, FeedbackVO.class);
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter("eq", (Object)vo.getId()));
        List list = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)list));
        }
        FeedbackEntity saveEntity = (FeedbackEntity)((Object)BeanMapper.map((Object)vo, FeedbackEntity.class));
        saveEntity.setSourceId(saveEntity.getId());
        saveEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
        CommonUtils.clearInvalidData(saveEntity);
        for (FeedbackDetailFileEntity detail : saveEntity.getDetailFileList()) {
            detail.setSourceId(detail.getPid());
            detail.setSourceDetailId(detail.getId());
            CommonUtils.clearInvalidData(detail);
            detail.setId(IdWorker.getId());
            Long fileId = this.pushFileUtil.uploadFileFormNet("EJCBT202405000001", detail.getId(), "file01", detail.getAttachmentId());
            detail.setAttachmentId(fileId);
        }
        super.saveOrUpdate((Object)saveEntity, false);
        this.logger.info("\u4f9b\u65b9\u63a8\u9001\u610f\u89c1\u53cd\u9988\u5355\u4fdd\u5b58\u6210\u529f\uff1a{}>>>>>>>>>>>>>>>>>>>>>>>>", (Object)saveEntity.getId());
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)BeanMapper.map((Object)((Object)saveEntity), FeedbackVO.class)));
    }
}

