/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.erp.bean.ContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ContractEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.enums.OrderDeliveryStatusEnums;
import com.ejianc.business.zdsmaterial.erp.mapper.OrderMapper;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderDetailVO;
import com.ejianc.business.zdsmaterial.erp.vo.OrderVO;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdssupplier.material.api.IMatSupplierApi;
import com.ejianc.business.zdssupplier.material.vo.MatSupplierVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="orderService")
public class OrderServiceImpl
extends BaseServiceImpl<OrderMapper, OrderEntity>
implements IOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZDS-ORD";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IOrderDetailService detailService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IMaterialCategoryService categoryService;
    private final String OPERATE = "orderBill";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private OrderMapper mapper;
    @Autowired
    private IEmployeeApi employeeApi;
    private final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supOrder/syncOrder";
    private final String UPDATE_STATUS_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/supOrder/syncUpdateFreezeStatus";
    private final String ORDER_CHECK_CODE = "P-lk3to00003";
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IMatSupplierApi matSupplierApi;

    @Override
    public OrderVO getOneBySourceContractId(String sourceOrderId) {
        OrderVO resp = new OrderVO();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"source_order_id", (Object)sourceOrderId);
        OrderEntity e = (OrderEntity)((Object)super.getOne((Wrapper)query));
        if (null != e) {
            e.setDetailList(this.detailService.getAllByOrderId(e.getId()));
            resp = (OrderVO)BeanMapper.map((Object)((Object)e), OrderVO.class);
        }
        return resp;
    }

    @Override
    public void saveByContracts(List<ContractEntity> saveList) {
        ArrayList<OrderEntity> orderList = new ArrayList<OrderEntity>();
        ArrayList<OrderDetailEntity> detailList = new ArrayList<OrderDetailEntity>();
        OrderEntity tmp = null;
        for (ContractEntity c : saveList) {
            if (!ZDSMaterialCommonEnums.\u603b\u4ef7\u5408\u540c.getCode().equals(c.getPriceType()) || null == (tmp = this.generateOrder(c))) continue;
            orderList.add(tmp);
            detailList.addAll(tmp.getDetailList());
        }
        if (CollectionUtils.isNotEmpty(orderList)) {
            super.saveOrUpdateBatch(orderList, orderList.size(), false);
        }
        if (CollectionUtils.isNotEmpty(detailList)) {
            this.detailService.saveOrUpdateBatch(detailList, detailList.size(), false);
        }
    }

    @Override
    public OrderEntity updateFreezeStatus(OrderVO saveOrUpdateVO) {
        OrderEntity orderEntity = (OrderEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        orderEntity.setFreezeStatus(saveOrUpdateVO.getFreezeStatus());
        super.updateById((Object)orderEntity);
        OrderVO orderVO = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
        this.syncUpdateFreezeStatus(orderVO);
        return orderEntity;
    }

    @Override
    public List<Long> getCanSyncOrderIdsBySupplierId(Long supplierId) {
        return this.mapper.getCanSyncOrderIdsBySupplierId(supplierId);
    }

    @Override
    public void cancelOrderByContractId(List<Long> mainContractIds) {
        QueryWrapper update = new QueryWrapper();
        update.in((Object)"contract_id", mainContractIds);
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)update);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            this.cancelOrderList(dbList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public void cancelOrderList(List<Long> orderIds) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", orderIds);
        update.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        update.set((Object)"dr", (Object)1);
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"memo", (Object)"ERP-\u5408\u540c\u4f5c\u5e9f\u5220\u9664");
        super.update((Wrapper)update);
        this.detailService.cancelByOrderIds(orderIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncUpdateFreezeStatus(OrderVO orderVO) {
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "orderBill::" + orderVO.getId().toString();
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355\u6682\u505c\u72b6\u6001-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)orderVO.getId(), (Object)ejcCloudSystemCode.getMsg());
            return "\u63a8\u9001\u8ba2\u5355\u6682\u505c\u72b6\u6001\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
        }
        orderVO.setSourceSystemId((String)ejcCloudSystemCode.getData());
        orderVO.setSourceId(orderVO.getId().toString());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("transData", JSONObject.toJSONString((Object)orderVO));
        HashMap files = new HashMap();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"orderBill", (int)600);
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/supOrder/syncUpdateFreezeStatus", paramMap, orderVO.getSupplierId().toString(), files);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u63a8\u9001\u8ba2\u5355\u6682\u505c\u72b6\u6001id-{}\u5931\u8d25, {}", new Object[]{orderVO.getSupplierId(), orderVO.getId(), billPushResp.getMsg()});
                    msg = "\u8ba2\u5355\u6682\u505c\u72b6\u6001\u5931\u8d25\uff0c\u4f9b\u65b9\u5904\u7406\u8ba2\u5355\u6682\u505c\u72b6\u6001\u5931\u8d25";
                }
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u8ba2\u5355\u6682\u505c\u72b6\u6001id-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{orderVO.getId(), orderVO.getSupplierId(), syncReqResp.getMsg()});
                msg = "\u53d1\u9001\u8bf7\u6c42\u8ba2\u5355\u6682\u505c\u72b6\u6001\u5931\u8d25";
            }
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355\u6682\u505c\u72b6\u6001id-{}\u63a8\u9001\u4f9b\u65b9\u8ba2\u5355\u6682\u505c\u72b6\u6001\uff0c", (Object)orderVO.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u6682\u505c\u72b6\u6001\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "orderBill");
        }
        return msg;
    }

    private OrderEntity generateOrder(ContractEntity contract) {
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setId(IdWorker.getId());
        orderEntity.setFreezeStatus(1);
        orderEntity.setApprovedTaxMny(BigDecimal.ZERO);
        orderEntity.setBalanceTaxMny(contract.getBalanceTaxMny());
        orderEntity.setContractPriceType(ZDSMaterialCommonEnums.\u603b\u4ef7\u5408\u540c.getCode());
        orderEntity.setSourceOrderCode(contract.getContractCode());
        orderEntity.setSourceContractId(contract.getSourceContractId());
        orderEntity.setContractId(contract.getId());
        orderEntity.setContractCode(contract.getContractCode());
        orderEntity.setContractName(contract.getContractName());
        orderEntity.setContractPriceType(contract.getPriceType());
        orderEntity.setSupplierId(contract.getSupplierId());
        orderEntity.setSupplierCode(contract.getSupplierCode());
        orderEntity.setSupplierName(contract.getSupplierName());
        orderEntity.setSupplierManagerSupId(contract.getSupplierManagerSupId());
        orderEntity.setSupplierLinkerId(contract.getSupplierManagerId());
        orderEntity.setSupplierLinkerSid(contract.getSupplierManagerSid());
        orderEntity.setSupplierLinkName(contract.getSupplierManagerName());
        orderEntity.setSupplierLinkPhone(contract.getSupplierManagerPhone());
        orderEntity.setProjectId(contract.getProjectId());
        orderEntity.setProjectCode(contract.getProjectCode());
        orderEntity.setProjectName(contract.getProjectName());
        orderEntity.setOrgId(contract.getOrgId());
        orderEntity.setOrgCode(contract.getOrgCode());
        orderEntity.setOrgName(contract.getOrgName());
        orderEntity.setParentOrgId(contract.getParentOrgId());
        orderEntity.setParentOrgCode(contract.getParentOrgCode());
        orderEntity.setParentOrgName(contract.getParentOrgName());
        orderEntity.setEnableStatus(contract.getEnableStatus());
        orderEntity.setDeliveryDate(contract.getDeliveryDate());
        orderEntity.setAcceptorId(contract.getMasterPorterId());
        orderEntity.setAcceptorCode(contract.getMasterPorterCode());
        orderEntity.setAcceptorName(contract.getMasterPorterName());
        orderEntity.setAcceptorLinkPhone(contract.getLinkPhone());
        orderEntity.setDeliveryAddress(contract.getDeliveryAddress());
        orderEntity.setDeliveryRemark(contract.getDeliveryRemark());
        orderEntity.setRemark(contract.getRemark());
        orderEntity.setPurchaseUserId(contract.getEmployeeId());
        orderEntity.setPurchaseUserCode(contract.getEmployeeCode());
        orderEntity.setPurchaseUserName(contract.getEmployeeName());
        orderEntity.setPurchaseUserLinkPhone(contract.getEmployeePhone());
        orderEntity.setOrderMny(contract.getMny());
        orderEntity.setOrderTaxMny(contract.getTaxMny());
        orderEntity.setDeliveredMny(BigDecimal.ZERO);
        orderEntity.setDeliveredTaxMny(BigDecimal.ZERO);
        orderEntity.setHandAcceptMny(BigDecimal.ZERO);
        orderEntity.setHandAcceptTaxMny(BigDecimal.ZERO);
        orderEntity.setTotalAcceptMny(BigDecimal.ZERO);
        orderEntity.setTotalAcceptTaxMny(BigDecimal.ZERO);
        orderEntity.setDeliveryStatus(OrderDeliveryStatusEnums.\u5f85\u53d1\u8d27.getCode());
        orderEntity.setSignatureStatus(ZDSMaterialCommonEnums.\u7b7e\u7ae0\u786e\u8ba4\u72b6\u6001_\u672a\u7b7e\u5b57.getCode());
        OrderDetailEntity orderDetail = null;
        for (ContractDetailEntity contractDetail : contract.getDetailList()) {
            if (StringUtils.isBlank((CharSequence)contractDetail.getMaterialSerialNo()) || !contractDetail.getMaterialSerialNo().contains("pd-")) {
                this.logger.info("\u5408\u540c-\u3010id-{}\uff0ccode-{}\u3011\u5bf9\u5e94\u660e\u7ec6[{}]\u7269\u8d44\u6d41\u6c34\u53f7\u4e3a\u7a7a\u6216\u975e\u6765\u6e90\u4e8e\u91c7\u8d2d\u8ba1\u5212\uff0c\u8df3\u8fc7\u751f\u6210\u8ba2\u5355\u660e\u7ec6\uff01", new Object[]{contract.getId(), contract.getContractCode(), contractDetail});
                continue;
            }
            if (null == contractDetail.getPurNum() || BigDecimal.ZERO.compareTo(contractDetail.getPurNum()) == 1) {
                this.logger.info("\u5408\u540c-\u3010id-{}\uff0ccode-{}\u3011\u5bf9\u5e94\u660e\u7ec6[{}]\u6570\u91cf\u4e3a\u7a7a\u6216\u4e3a0\uff0c\u8df3\u8fc7\u751f\u6210\u8ba2\u5355\u660e\u7ec6\uff01", new Object[]{contract.getId(), contract.getContractCode(), contractDetail});
                continue;
            }
            if (null == contractDetail.getBrandId()) {
                this.logger.info("\u5408\u540c-\u3010id-{}\uff0ccode-{}\u3011\u5bf9\u5e94\u660e\u7ec6[{}]\u54c1\u724c\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u751f\u6210\u8ba2\u5355\u660e\u7ec6\uff01", new Object[]{contract.getId(), contract.getContractCode(), contractDetail});
                continue;
            }
            orderDetail = new OrderDetailEntity();
            orderDetail.setContractDetailId(contractDetail.getId());
            orderDetail.setSourceContractDetailId(contractDetail.getSourceDetailId());
            orderDetail.setSourceContractId(contract.getSourceContractId());
            orderDetail.setContractNum(contractDetail.getPurNum());
            orderDetail.setDetailNum(contractDetail.getPurNum());
            orderDetail.setHandAcceptNum(BigDecimal.ZERO);
            orderDetail.setDeliveredNum(BigDecimal.ZERO);
            orderDetail.setAcceptedNum(BigDecimal.ZERO);
            orderDetail.setMaterialSerialNo(contractDetail.getMaterialSerialNo());
            orderDetail.setMaterialTypeId(contractDetail.getMaterialTypeId());
            orderDetail.setMaterialTypeName(contractDetail.getMaterialTypeName());
            orderDetail.setMaterialTypeCode(contractDetail.getMaterialTypeCode());
            orderDetail.setMaterialId(contractDetail.getMaterialId());
            orderDetail.setMaterialCode(contractDetail.getMaterialCode());
            orderDetail.setMaterialName(contractDetail.getMaterialName());
            orderDetail.setDetailPrice(contractDetail.getDetailPrice());
            orderDetail.setDetailTaxPrice(contractDetail.getDetailTaxPrice());
            orderDetail.setDetailMny(contractDetail.getDetailMny());
            orderDetail.setDetailTaxMny(contractDetail.getDetailTaxMny());
            orderDetail.setDetailTaxRate(contractDetail.getDetailTaxRate());
            orderDetail.setDetailTax(contractDetail.getDetailTax());
            orderDetail.setDetailUnitId(contractDetail.getDetailUnitId());
            orderDetail.setDetailUnitName(contractDetail.getDetailUnitName());
            orderDetail.setMemo(contractDetail.getDetailRemark());
            orderDetail.setProductCode(contractDetail.getProductCode());
            orderDetail.setPropertyValue(contractDetail.getPropertyValue());
            orderDetail.setBrandId(contractDetail.getBrandId());
            orderDetail.setBrandName(contractDetail.getBrandName());
            orderDetail.setId(IdWorker.getId());
            orderDetail.setOrderId(orderEntity.getId());
            orderDetail.setRowState("add");
            orderEntity.getDetailList().add(orderDetail);
        }
        if (CollectionUtils.isEmpty(orderEntity.getDetailList())) {
            this.logger.info("\u5408\u540c-[id-{},code-{}]\u53ef\u751f\u6210\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff0c\u4e0d\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\uff01\uff01\uff01\uff01\uff01", (Object)contract.getId(), (Object)contract.getContractCode());
            return null;
        }
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class)));
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        orderEntity.setBillCode((String)billCode.getData());
        String msg = this.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class));
        orderEntity.setBillPushFlag(StringUtils.isNotBlank((CharSequence)msg) ? "sucPushed" : "unSucPush");
        return orderEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveByContract(ContractEntity contract, boolean addFlag) {
        String msg;
        OrderEntity orderEntity = null;
        if (addFlag) {
            orderEntity = new OrderEntity();
            orderEntity.setId(IdWorker.getId());
            orderEntity.setSourceContractId(contract.getSourceContractId());
            orderEntity.setContractId(contract.getId());
            orderEntity.setContractCode(contract.getBillCode());
            orderEntity.setContractName(contract.getContractName());
            orderEntity.setContractPriceType(contract.getPriceType());
            orderEntity.setSupplierId(contract.getSupplierId());
            orderEntity.setSupplierCode(contract.getSupplierCode());
            orderEntity.setSupplierName(contract.getSupplierName());
            orderEntity.setSupplierLinkName(contract.getSupplierManagerName());
            orderEntity.setSupplierLinkPhone(contract.getSupplierManagerPhone());
            orderEntity.setProjectId(contract.getProjectId());
            orderEntity.setProjectCode(contract.getProjectCode());
            orderEntity.setProjectName(contract.getProjectName());
            orderEntity.setOrgId(contract.getOrgId());
            orderEntity.setOrgCode(contract.getOrgCode());
            orderEntity.setOrgName(contract.getOrgName());
            orderEntity.setParentOrgId(contract.getParentOrgId());
            orderEntity.setParentOrgCode(contract.getParentOrgCode());
            orderEntity.setParentOrgName(contract.getParentOrgName());
            orderEntity.setEnableStatus(contract.getEnableStatus());
            orderEntity.setDeliveryDate(contract.getDeliveryDate());
            orderEntity.setAcceptorId(contract.getMasterPorterId());
            orderEntity.setAcceptorCode(contract.getMasterPorterCode());
            orderEntity.setAcceptorName(contract.getMasterPorterName());
            orderEntity.setAcceptorLinkPhone(contract.getLinkPhone());
            orderEntity.setDeliveryAddress(contract.getDeliveryAddress());
            orderEntity.setDeliveryRemark(contract.getDeliveryRemark());
            orderEntity.setRemark(contract.getRemark());
            orderEntity.setPurchaseUserId(contract.getEmployeeId());
            orderEntity.setPurchaseUserCode(contract.getEmployeeCode());
            orderEntity.setPurchaseUserName(contract.getEmployeeName());
            orderEntity.setPurchaseUserLinkPhone(contract.getEmployeePhone());
            orderEntity.setOrderMny(contract.getMny());
            orderEntity.setOrderTaxMny(contract.getTaxMny());
            orderEntity.setDeliveredMny(BigDecimal.ZERO);
            orderEntity.setDeliveredTaxMny(BigDecimal.ZERO);
            orderEntity.setHandAcceptMny(BigDecimal.ZERO);
            orderEntity.setHandAcceptTaxMny(BigDecimal.ZERO);
            orderEntity.setTotalAcceptMny(BigDecimal.ZERO);
            orderEntity.setTotalAcceptTaxMny(BigDecimal.ZERO);
            orderEntity.setDeliveryStatus(OrderDeliveryStatusEnums.\u5f85\u53d1\u8d27.getCode());
            orderEntity.setSignatureStatus(ZDSMaterialCommonEnums.\u7b7e\u7ae0\u786e\u8ba4\u72b6\u6001_\u672a\u7b7e\u5b57.getCode());
            OrderDetailEntity orderDetail = null;
            for (ContractDetailEntity contractDetail : contract.getDetailList()) {
                orderDetail = new OrderDetailEntity();
                orderDetail.setContractDetailId(contractDetail.getId());
                orderDetail.setSourceContractDetailId(contractDetail.getSourceDetailId());
                orderDetail.setSourceContractId(contract.getSourceContractId());
                orderDetail.setContractNum(contractDetail.getPurNum());
                orderDetail.setDetailNum(contractDetail.getPurNum());
                orderDetail.setHandAcceptNum(BigDecimal.ZERO);
                orderDetail.setDeliveredNum(BigDecimal.ZERO);
                orderDetail.setAcceptedNum(BigDecimal.ZERO);
                orderDetail.setMaterialSerialNo(contractDetail.getMaterialSerialNo());
                orderDetail.setMaterialTypeId(contractDetail.getMaterialTypeId());
                orderDetail.setMaterialTypeName(contractDetail.getMaterialTypeName());
                orderDetail.setMaterialTypeCode(contractDetail.getMaterialTypeCode());
                orderDetail.setMaterialId(contractDetail.getMaterialId());
                orderDetail.setMaterialCode(contractDetail.getMaterialCode());
                orderDetail.setMaterialName(contractDetail.getMaterialName());
                orderDetail.setDetailPrice(contractDetail.getDetailPrice());
                orderDetail.setDetailTaxPrice(contractDetail.getDetailTaxPrice());
                orderDetail.setDetailMny(contractDetail.getDetailMny());
                orderDetail.setDetailTaxMny(contractDetail.getDetailTaxMny());
                orderDetail.setDetailTaxRate(contractDetail.getDetailTaxRate());
                orderDetail.setDetailTax(contractDetail.getDetailTax());
                orderDetail.setDetailUnitId(contractDetail.getDetailUnitId());
                orderDetail.setDetailUnitName(contractDetail.getDetailUnitName());
                orderDetail.setMemo(contractDetail.getDetailRemark());
                orderDetail.setProductCode(contractDetail.getProductCode());
                orderDetail.setPropertyValue(contractDetail.getPropertyValue());
                orderDetail.setBrandId(contractDetail.getBrandId());
                orderDetail.setBrandName(contractDetail.getBrandName());
                orderDetail.setId(IdWorker.getId());
                orderDetail.setOrderId(orderEntity.getId());
                orderDetail.setRowState("add");
                orderEntity.getDetailList().add(orderDetail);
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)((BaseVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class)));
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            orderEntity.setBillCode((String)billCode.getData());
        } else {
            orderEntity = this.selectByContractId(contract.getId());
            if (null == orderEntity) {
                this.logger.error("\u6839\u636e\u5408\u540cId-[{}]\u627e\u4e0d\u5230\u5339\u914d\u7684\u8ba2\u5355\u4fe1\u606f\uff01", (Object)contract.getId());
                throw new BusinessException("\u4e0d\u5b58\u5728\u5408\u540c\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f");
            }
        }
        orderEntity.setBillPushFlag(StringUtils.isNotBlank((CharSequence)(msg = this.pushToSupBusiness((OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class)))) ? "sucPushed" : "unSucPush");
        super.saveOrUpdate((Object)orderEntity, false);
    }

    public void orderCheck(OrderEntity orderEntity) {
        CommonResponse response = this.paramConfigApi.getByCode("P-lk3to00003");
        if (!response.isSuccess() || response.getData() == null) {
            this.logger.error("\u83b7\u53d6\u8ba2\u5355\u91cf\u8fbe\u603b\u63a7\u91cf\u767e\u5206\u6bd4\u9884\u8b66\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c{}\uff0c\u8df3\u8fc7\u9884\u8b66\u4efb\u52a1\u6267\u884c\u3002\u3002\u3002", (Object)JSONObject.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            return;
        }
        BigDecimal percent = new BigDecimal(((ParamRegisterSetVO)response.getData()).getValueData());
        this.logger.info("\u5f53\u524d\u8ba2\u5355\u91cf\u8fbe\u603b\u63a7\u91cf{}%\u65f6\u53d1\u9001\u6d88\u606f", (Object)((ParamRegisterSetVO)response.getData()).getValueData());
        List<Map<String, Object>> detailPercent = this.mapper.getOrderDetailPercent(orderEntity.getProjectId());
        if (CollectionUtils.isNotEmpty(detailPercent)) {
            detailPercent = detailPercent.stream().filter(item -> BigDecimal.ZERO.compareTo(new BigDecimal(item.get("controlNum").toString())) < 1 && percent.compareTo(new BigDecimal(item.get("percent").toString())) >= 0).collect(Collectors.toList());
            StringBuffer sp = new StringBuffer();
            if (CollectionUtils.isNotEmpty(detailPercent)) {
                List empList;
                detailPercent.stream().forEach(item -> sp.append("\u6750\u6599\u5206\u7c7b\u3010").append(item.get("material_type_name")).append("\u3011\uff0c\u6750\u6599\u7f16\u7801\u3010").append(item.get("material_code")).append("\u3011\uff0c\u6750\u6599\u540d\u79f0\u3010").append(item.get("material_name")).append("\u3011\uff0c\u603b\u63a7\u8ba1\u5212\u91cf\u3010").append(item.get("controlNum")).append("\u3011\uff0c\u8ba2\u5355\u91cf\u3010").append(item.get("orderNum")).append("\u3011\uff0c\u5df2\u8fbe").append(new BigDecimal(item.get("orderNum").toString()).setScale(2, 4)).append("%\uff1b"));
                CommonResponse prjResp = this.projectPoolApi.getById(orderEntity.getProjectId());
                if (!prjResp.isSuccess() || null == prjResp.getData()) {
                    this.logger.error("\u8ba2\u5355\u8d85\u91cf\u9884\u8b66\u4fe1\u606f\u53d1\u9001\uff0c\u83b7\u53d6\u9879\u76eeid-{}\u4fe1\u606f\u5931\u8d25, {}", (Object)orderEntity.getProjectId(), (Object)JSONObject.toJSONString((Object)prjResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
                ArrayList<String> recUserIds = new ArrayList<String>();
                ProjectPoolSetVO project = (ProjectPoolSetVO)prjResp.getData();
                if (null != project.getProjectManagementId()) {
                    recUserIds.add(project.getProjectManagementId().toString());
                }
                ArrayList<String> postNames = new ArrayList<String>();
                postNames.add("\u91c7\u8d2d\u5de5\u7a0b\u5e08");
                CommonResponse empResp = this.employeeApi.queryByPostNamesAndOrgIds(postNames, Arrays.asList(orderEntity.getOrgId()));
                if (!empResp.isSuccess()) {
                    this.logger.error("\u8ba2\u5355\u8d85\u91cf\u9884\u8b66\u4fe1\u606f\u53d1\u9001\uff0c\u6839\u636e\u5c97\u4f4dnames-[{}]\u83b7\u53d6\u7ec4\u7ec7id-{}\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25, {}", new Object[]{StringUtils.join(postNames, (String)","), orderEntity.getOrgId(), JSONObject.toJSONString((Object)prjResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat})});
                }
                if (CollectionUtils.isEmpty((Collection)(empList = (List)empResp.getData()))) {
                    this.logger.error("\u8ba2\u5355\u8d85\u91cf\u9884\u8b66\u4fe1\u606f\u53d1\u9001\uff0c\u6839\u636e\u5c97\u4f4dnames-[{}]\u83b7\u53d6\u7ec4\u7ec7id-{}\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a", (Object)StringUtils.join(postNames, (String)","), (Object)orderEntity.getOrgId());
                } else {
                    empList.stream().forEach(emp -> recUserIds.add(emp.getUserId().toString()));
                }
                if (CollectionUtils.isEmpty(recUserIds)) {
                    this.logger.error("\u8ba2\u5355\u8d85\u91cf\u9884\u8b66\u4fe1\u606f\u53d1\u9001\u5931\u8d25\uff0c\u9879\u76ee\u4e0b\u91c7\u8d2d\u5de5\u7a0b\u5e08\u3001\u9879\u76ee\u7ecf\u7406\u5bf9\u5e94\u4eba\u5458\u5217\u8868\u4e3a\u7a7a");
                    return;
                }
                PushMsgParameter parameter = new PushMsgParameter();
                parameter.setContent(sp.substring(0, sp.length() - 1) + " \u8bf7\u77e5\u6089\uff01");
                parameter.setSubject("\u8ba2\u5355\u8d85\u91cf\u9884\u8b66");
                parameter.setReceivers(recUserIds.toArray(new String[recUserIds.size()]));
                this.sendMsg(parameter, orderEntity.getId(), "\u8ba2\u5355\u91cf\u8fbe\u603b\u63a7\u91cfX%\u9884\u8b66\uff0c\u53d1\u9001\u3001\u5de5\u7a0b\u5e08\u3001\u91c7\u8d2d\u3001\u9879\u76ee\u7ecf\u7406\u53d1\u9001\u6d88\u606f");
            }
        }
    }

    public void sendMsg(PushMsgParameter parameter, Long allotOrderId, String oprMsg) {
        parameter.setSaveFlag(true);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setMsgType("notice");
        parameter.setChannel(new String[]{"sys", "email"});
        CommonResponse sendResp = this.pushMessageApi.pushMessage(parameter);
        if (!sendResp.isSuccess()) {
            this.logger.error("\u8ba2\u5355id-{}\u8d85\u91cf\u9884\u8b66\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c{}", new Object[]{allotOrderId, oprMsg, JSONObject.toJSONString((Object)sendResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue})});
        } else {
            this.logger.info("\u8ba2\u5355id-{}\u8d85\u91cf\u9884\u8b66\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01", (Object)allotOrderId, (Object)oprMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String pushToSupBusiness(OrderVO orderVO) {
        List<Long> categoryIds;
        List<MaterialCategoryVO> categoryEntities;
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = "orderBill::" + orderVO.getId().toString();
        if (CollectionUtils.isEmpty((Collection)orderVO.getDetailList())) {
            msg = "\u63a8\u9001\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u5b57\u8868\u4e3a\u7a7a\uff01";
        }
        if ((categoryEntities = this.categoryService.queryCategoryListByIds(categoryIds = orderVO.getDetailList().stream().map(OrderDetailVO::getMaterialTypeId).collect(Collectors.toList()))).stream().filter(item -> ZDSMaterialCommonEnums.\u534f\u540c\u9a8c\u6536_\u662f.getCode().equals(item.getCoordinationFlag())).count() == 0L) {
            this.logger.info("\u8ba2\u5355\u3010id-{}\u3011\u4e0d\u5b58\u5728\u9700\u8981\u534f\u540c\u9a8c\u6536\u5355\u7684\u660e\u7ec6\uff0c\u4e0d\u63a8\u9001\u4f9b\u65b9\uff01", (Object)orderVO.getId().toString());
            return msg;
        }
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)orderVO.getId(), (Object)ejcCloudSystemCode.getMsg());
            return "\u63a8\u9001\u8ba2\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25";
        }
        CommonResponse supplierResp = this.matSupplierApi.getOneById(orderVO.getSupplierId());
        if (!supplierResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355-{}\u5931\u8d25\uff0c\u6839\u636eid-{}\u83b7\u53d6\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25,{}", new Object[]{orderVO.getId(), orderVO.getSupplierId(), JSONObject.toJSONString((Object)supplierResp)});
            return "\u63a8\u9001\u8ba2\u5355\u5931\u8d25\uff0c\u83b7\u53d6\u4f9b\u65b9\u4fe1\u606f\u5931\u8d25";
        }
        MatSupplierVO supplier = (MatSupplierVO)supplierResp.getData();
        if ("0".equals(supplier.getCoordination())) {
            this.logger.error("\u63a8\u9001\u8ba2\u5355-{}\u5931\u8d25\uff0c\u4f9b\u5e94\u5546id-{}\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7", (Object)orderVO.getId(), (Object)orderVO.getSupplierId());
            return "\u63a8\u9001\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u5bf9\u5e94\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u672a\u5f00\u901a\u534f\u540c\u8d26\u53f7\uff01";
        }
        orderVO.setSourceSystemId((String)ejcCloudSystemCode.getData());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("transData", JSONObject.toJSONString((Object)orderVO));
        HashMap files = new HashMap();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"orderBill", (int)600);
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/ejc-zdssupbusiness-web/openapi/supOrder/syncOrder", paramMap, orderVO.getSupplierId().toString(), files);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    String string = msg;
                    return string;
                }
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u8ba2\u5355id-{}\u5931\u8d25, {}", new Object[]{orderVO.getSupplierId(), orderVO.getId(), billPushResp.getMsg()});
                msg = "\u63a8\u9001\u8ba2\u5355\u5931\u8d25\uff0c\u4f9b\u65b9\u5904\u7406\u63a8\u9001\u8ba2\u5355\u5931\u8d25";
            } else {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u7ed3\u7b97\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{orderVO.getId(), orderVO.getSupplierId(), syncReqResp.getMsg()});
                msg = "\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u8ba2\u5355\u5931\u8d25";
            }
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355id-{}\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c", (Object)orderVO.getId(), (Object)e);
            msg = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba2\u5355\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "orderBill");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supOrderSync(OrderVO orderVO) {
        Long orderId = Long.valueOf(orderVO.getSourceId());
        Jedis jedis = null;
        boolean locked = false;
        String key = "orderBill::" + orderId.toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"orderBill", (int)600);
            OrderEntity order = (OrderEntity)((Object)super.selectById((Serializable)orderId));
            if (!order.getSignatureStatus().equals(orderVO.getSignatureStatus())) {
                order.setSignatureStatus(orderVO.getSignatureStatus());
                order.setSignTime(orderVO.getSignTime());
                order.setSignUserId(orderVO.getSignUserId());
                order.setSignUserName(orderVO.getSignUserName());
                order.setSignUserPhone(orderVO.getSignUserPhone());
            } else {
                order.setDeliveryStatus(orderVO.getDeliveryStatus());
                order.setDeliveredMny(orderVO.getDeliveredMny());
                order.setDeliveredTaxMny(orderVO.getDeliveredTaxMny());
                Map<String, OrderDetailVO> orderDetailVOMap = orderVO.getDetailList().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));
                order.getDetailList().stream().filter(item -> orderDetailVOMap.containsKey(item.getId().toString())).forEach(detail -> detail.setDeliveredNum(((OrderDetailVO)orderDetailVOMap.get(detail.getId().toString())).getDeliveredNum()));
            }
            order.setFreezeStatus(1);
            super.saveOrUpdate((Object)order, false);
        }
        catch (Exception e) {
            this.logger.error("\u8ba2\u5355id-{}\u786e\u8ba4\u72b6\u6001\u540c\u6b65\u5f02\u5e38\uff0c", (Object)orderId, (Object)e);
        }
        finally {
            this.releaseLock(jedis, locked, key, "orderBill");
        }
    }

    @Override
    public void returnHandAcceptNum(AcceptEntity entity, Boolean status) {
        this.detailService.returnHandAcceptNum(entity, status);
        this.totalAcceptMny(entity.getOrderBillId());
    }

    public void totalAcceptMny(Long orderBillId) {
        OrderEntity order = (OrderEntity)((Object)super.selectById((Serializable)orderBillId));
        List<OrderDetailEntity> detailList = order.getDetailList();
        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalTaxMny = BigDecimal.ZERO;
        BigDecimal totalHandMny = BigDecimal.ZERO;
        BigDecimal totalHandTaxMny = BigDecimal.ZERO;
        for (OrderDetailEntity detail : detailList) {
            BigDecimal handAcceptNum = detail.getHandAcceptNum();
            BigDecimal acceptedNum = detail.getAcceptedNum();
            BigDecimal detailTaxPrice = detail.getDetailTaxPrice();
            BigDecimal detailPrice = detail.getDetailPrice();
            BigDecimal mny = ComputeUtil.safeMultiply((BigDecimal)acceptedNum, (BigDecimal)detailPrice);
            BigDecimal taxMny = ComputeUtil.safeMultiply((BigDecimal)acceptedNum, (BigDecimal)detailTaxPrice);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)mny);
            totalTaxMny = ComputeUtil.safeAdd((BigDecimal)totalTaxMny, (BigDecimal)taxMny);
            BigDecimal mny1 = ComputeUtil.safeMultiply((BigDecimal)handAcceptNum, (BigDecimal)detailPrice);
            BigDecimal taxMny1 = ComputeUtil.safeMultiply((BigDecimal)handAcceptNum, (BigDecimal)detailTaxPrice);
            totalHandMny = ComputeUtil.safeAdd((BigDecimal)totalHandMny, (BigDecimal)mny1);
            totalHandTaxMny = ComputeUtil.safeAdd((BigDecimal)totalHandTaxMny, (BigDecimal)taxMny1);
        }
        order.setTotalAcceptMny(totalMny);
        order.setTotalAcceptTaxMny(totalTaxMny);
        order.setHandAcceptMny(totalHandMny);
        order.setHandAcceptTaxMny(totalHandTaxMny);
        super.saveOrUpdate((Object)order);
    }

    @Override
    public void returnAcceptedNum(DeliveryEntity deliveryEntity, boolean addFlag) {
        this.detailService.returnAcceptedNum(deliveryEntity.getDetailList(), addFlag);
        this.totalAcceptMny(deliveryEntity.getOrderId());
    }

    @Override
    public List<OrderEntity> getBySourceIds(List<String> sourceIds) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"source_id", sourceIds);
        return super.list((Wrapper)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    private OrderEntity selectByContractId(Long contractId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        return (OrderEntity)((Object)super.getOne((Wrapper)query));
    }
}

