/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/matSupManager/"})
public class MatSupplierManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMatSupplierManagerService service;
    @Autowired
    private IMaterialCategoryService categoryService;
    @Autowired
    private IEmployeeApi employeeApi;
    private final String MATERIAL_MANAGER_SYNC_TO_ERP_URL = "/cefoc/yql/ReceiveC_SD_GoodsTypeSubBList";

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<String> saveOrUpdateManagers(@RequestBody List<MatSupplierManagerVO> vos) {
        ArrayList saveList = new ArrayList();
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> empIds = vos.stream().map(MatSupplierManagerVO::getManagerId).collect(Collectors.toList());
            MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.categoryService.getById(vos.get(0).getCategoryId()));
            List<Long> existsEmpIds = this.service.getAllByCategoryIdAndEmpIds(category.getId(), empIds);
            vos.stream().filter(item -> !existsEmpIds.contains(item.getManagerId())).forEach(item -> {
                item.setCategoryName(category.getName());
                item.setCategoryInnerCode(category.getInnerCode());
                if (null == item.getId()) {
                    item.setId(Long.valueOf(IdWorker.getId()));
                }
                saveList.add(item);
            });
        }
        if (CollectionUtils.isNotEmpty(saveList)) {
            List saveEntityList = BeanMapper.mapList(saveList, MatSupplierManagerEntity.class);
            this.service.saveOrUpdateBatch(saveEntityList, saveEntityList.size(), false);
            boolean syncResult = this.syncToErp(saveEntityList, PlanConstant.INTEGER_YES);
            if (!syncResult) {
                CommonResponse.success((String)"\u64cd\u4f5c\u5931\u8d25, \u5ba1\u6838\u4eba\u4fe1\u606f\u63a8\u9001ERP\u7cfb\u7edf\u5931\u8d25\uff01");
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"syncToErp"})
    public CommonResponse<String> syncToErpServ(@RequestBody List<Long> syncIds, @RequestParam(required=false) Integer enableStatus) {
        List<MatSupplierManagerEntity> delList = this.service.getAllByIds(syncIds);
        if (CollectionUtils.isNotEmpty(delList)) {
            this.syncToErp(delList, null != enableStatus ? enableStatus : PlanConstant.INTEGER_NO);
        }
        return CommonResponse.success();
    }

    private boolean syncToErp(List<MatSupplierManagerEntity> saveEntityList, Integer enableStatus) {
        this.logger.info("***********************\u7269\u8d44\u5ba1\u6838\u4eba\u63a8\u9001ERP\u4efb\u52a1\u542f\u52a8\uff0c\u672c\u6b21\u5f85\u63a8\u9001\u6570\u636e\uff1a{}\u6761****************************************", (Object)saveEntityList.size());
        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + "/cefoc/yql/ReceiveC_SD_GoodsTypeSubBList";
        Map<String, String> headers = null;
        String reqResp = null;
        try {
            List empIds = saveEntityList.stream().map(MatSupplierManagerEntity::getManagerId).collect(Collectors.toList());
            CommonResponse userResp = this.employeeApi.getByIds(empIds);
            if (!userResp.isSuccess()) {
                this.logger.error("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001\u4efb\u52a1\u6267\u884cERP\u5931\u8d25\uff0c\u6839\u636e\u7528\u6237Id\u5217\u8868-[{}]\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c", (Object)JSONObject.toJSONString(empIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), (Object)JSONObject.toJSONString((Object)userResp, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return false;
            }
            if (CollectionUtils.isEmpty((Collection)((Collection)userResp.getData()))) {
                this.logger.error("\u4e34\u65f6\u6863\u6848\u5ba1\u6838\u4eba\u63a8\u9001\u4efb\u52a1\u6267\u884cERP\u5931\u8d25\uff0c\u6839\u636e\u7528\u6237Id\u5217\u8868-[{}]\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c", (Object)JSONObject.toJSONString(empIds, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                return false;
            }
            Map<Long, String> userSourceMap = ((List)userResp.getData()).stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getSourceId())).collect(Collectors.toMap(item -> item.getId(), item -> item.getSourceId()));
            List<Long> categoryIds = saveEntityList.stream().map(MatSupplierManagerEntity::getCategoryId).collect(Collectors.toList());
            List<MaterialCategoryVO> categorys = this.categoryService.getAllByIds(categoryIds);
            Map<Long, String> categorySourceMap = categorys.stream().collect(Collectors.toMap(item -> item.getId(), item -> item.getSourceId()));
            ArrayList syncDataList = new ArrayList();
            HashMap<String, Object> tmp = null;
            for (MatSupplierManagerEntity syncItem : saveEntityList) {
                tmp = new HashMap<String, Object>();
                if (!userSourceMap.containsKey(syncItem.getManagerId())) {
                    this.logger.info("\u7269\u8d44\u5206\u7c7b\u5ba1\u6838\u4eba\u3010{}\u3011\u5bf9\u5e94\u5ba1\u6838\u4ebaSID\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u63a8\u9001ERP\u7cfb\u7edf", (Object)JSONObject.toJSONString((Object)((Object)syncItem), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                    continue;
                }
                tmp.put("Title_ID", syncItem.getManagerCode());
                tmp.put("Title", syncItem.getManagerName());
                tmp.put("Title_Sid", userSourceMap.get(syncItem.getManagerId()));
                tmp.put("GoodsType_FK", categorySourceMap.get(syncItem.getCategoryId()));
                tmp.put("C_SD_GoodsTypeSubBOID", ZDSInterfaceCommonUtil.changeLongToGUID(syncItem.getId()));
                tmp.put("YQL_SID", syncItem.getId().toString());
                tmp.put("IsEnable", enableStatus);
                tmp.put("Sort_ID", 0);
                tmp.put("Memo", "");
                tmp.put("SYS_Deleted", PlanConstant.INTEGER_YES.equals(enableStatus) ? PlanConstant.INTEGER_NO : PlanConstant.INTEGER_YES);
                syncDataList.add(tmp);
            }
            if (CollectionUtils.isEmpty(syncDataList)) {
                this.logger.info("\u672c\u6b21\u53ef\u63a8\u9001\u7269\u8d44\u5206\u7c7b\u5ba1\u6838\u4eba\u5217\u8868\u4e3a\u7a7a\uff0c\u7269\u8d44\u5ba1\u6838\u4eba\u63a8\u9001\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002\u3002\u3002\u3002");
                return true;
            }
            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson((String)reqUrl, (String)JSONObject.toJSONString(syncDataList), headers, (Integer)180000, (Integer)180000);
            JSONObject syncResultJson = JSONObject.parseObject((String)reqResp);
            if (!"ok".equals(syncResultJson.getString("Status"))) {
                this.logger.error("\u7269\u8d44\u5ba1\u6838\u4eba\u63a8\u9001ERP\u5931\u8d25\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c-{}", new Object[]{reqUrl, JSONObject.toJSONString(saveEntityList), JSONObject.toJSONString(headers, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp});
                return false;
            }
            this.logger.error("\u7269\u8d44\u5ba1\u6838\u4eba\u63a8\u9001ERP\uff0c\u8bf7\u6c42\u7ed3\u679c\u8fd4\u56de\u6210\u529f\uff0c\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)syncResultJson.getString("info"));
        }
        catch (Exception e) {
            this.logger.error("\u7269\u8d44\u5ba1\u6838\u4eba\u63a8\u9001ERP\u5f02\u5e38\uff0c\uff1a\u8bf7\u6c42\u5730\u5740-{},\u53c2\u6570-{},header-{},\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(saveEntityList), JSONObject.toJSONString(headers, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}), reqResp, e});
        }
        return true;
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MatSupplierManagerVO> vos) {
        List<Long> delIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<MatSupplierManagerEntity> delList = this.service.getAllByIds(delIds);
        if (CollectionUtils.isNotEmpty(delList)) {
            this.syncToErp(delList, PlanConstant.INTEGER_NO);
        }
        this.service.removeByIds(delIds, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"queryCategoryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryCategoryList(@RequestBody QueryParam param) {
        return CommonResponse.success((Object)this.service.queryCategoryList(param));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MatSupplierManagerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("managerName");
        fuzzyFields.add("managerCode");
        fuzzyFields.add("managerPostName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MatSupplierManagerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<MatSupplierManagerVO> exportList = this.service.getExportList();
        HashMap<String, List<MatSupplierManagerVO>> beans = new HashMap<String, List<MatSupplierManagerVO>>();
        beans.put("records", exportList);
        ExcelExport.getInstance().export("MatSupManager-export.xlsx", beans, response);
    }
}

