/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import com.ejianc.business.zdsmaterial.material.service.ICommonSNService;
import com.ejianc.business.zdsmaterial.material.service.IInvalidMatExaminerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialPropertyRelationService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialSourceService;
import com.ejianc.business.zdsmaterial.material.vo.ExportColVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialImportFieldVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialSourceVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialVO;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"material"})
public class MaterialController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_TYPE_CODE = "EJCBT202311000003";
    @Autowired
    private IMaterialService service;
    @Autowired
    private ICommonSNService commonSNService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;
    @Autowired
    private IMaterialCategoryPropertyService propertyService;
    @Autowired
    private IMaterialPropertyRelationService relationService;
    @Autowired
    private IMaterialCategoryPropertySubItemService propertySubItemService;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IUnitApi unitApi;
    @Autowired
    private IMaterialSourceService materialSourceService;
    @Autowired
    private IInvalidMatExaminerService invalidMatExaminerService;
    private final String propertySeperator = "\uff1b";
    private final String propertyNameValueSep = "\uff1a";
    private final String CATEGORY_IMPORT_TEMPLATE_FIELDS_PREFIX = "category_import_fields::";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<MaterialVO>> saveOrUpdate(@RequestBody List<MaterialVO> saveOrUpdateVOs) {
        List<MaterialVO> repeatList;
        List<MaterialVO> codeDbList;
        ArrayList<MaterialVO> resp = new ArrayList<MaterialVO>();
        HashMap<String, MaterialVO> materialCode = new HashMap<String, MaterialVO>();
        HashSet<String> repeatMaterialCode = new HashSet<String>();
        HashSet<Long> materialIds = new HashSet<Long>();
        ArrayList<MaterialVO> unCodeList = new ArrayList<MaterialVO>();
        CommonResponse<String> checkResp = this.materialPreCheck(saveOrUpdateVOs, materialCode, repeatMaterialCode, materialIds, unCodeList);
        if (null != checkResp) {
            return checkResp;
        }
        if (MapUtils.isNotEmpty(materialCode) && CollectionUtils.isNotEmpty(codeDbList = this.service.getByCodes(new ArrayList<String>(materialCode.keySet())))) {
            repeatMaterialCode.addAll(codeDbList.stream().filter(item -> !item.getId().equals(((MaterialVO)materialCode.get(item.getCode())).getId())).map(MaterialVO::getCode).collect(Collectors.toSet()));
            if (repeatMaterialCode.size() > 0) {
                return CommonResponse.error((String)("\u7269\u8d44\u7f16\u7801\u3010" + StringUtils.join(repeatMaterialCode, (String)",") + "\u3011\u91cd\u590d"));
            }
        }
        if (CollectionUtils.isNotEmpty(repeatList = this.service.checkUnitAndProperty(saveOrUpdateVOs, true))) {
            if (repeatList.stream().filter(r -> ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode().equals(r.getValidFlag())).count() == 0L) {
                repeatList.stream().forEach(r -> r.setValidFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode()));
                this.service.saveOrUpdateBatch(BeanMapper.mapList(repeatList, MaterialEntity.class));
                resp.addAll(repeatList);
                Set repeatKey = repeatList.stream().map(item -> item.getName() + item.getUnitId().toString() + (StringUtils.isNotBlank((CharSequence)item.getPropertyShowName()) ? item.getPropertyShowName() : "")).collect(Collectors.toSet());
                saveOrUpdateVOs = saveOrUpdateVOs.stream().filter(r -> !repeatKey.contains(r.getName() + r.getUnitId().toString() + r.getPropertyShowName())).collect(Collectors.toList());
                repeatList.clear();
            }
            if (CollectionUtils.isNotEmpty(repeatList)) {
                String tip = repeatList.stream().filter(r -> ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode().equals(r.getValidFlag())).map(material -> {
                    StringBuilder sp = new StringBuilder();
                    return sp.append("\u540d\u79f0\uff1a").append(material.getName()).append(", \u5355\u4f4d\uff1a").append(material.getUnitName()).append(", \u5c5e\u6027\uff1a").append(material.getPropertyShowName()).toString();
                }).collect(Collectors.joining("; "));
                return CommonResponse.error((String)("\u7269\u8d44\u3010" + tip + "\u3011\u5206\u7c7b\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0"));
            }
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVOs)) {
            if (null != saveOrUpdateVOs.get(0).getId()) {
                CommonResponse quoteResp = this.billTypeApi.checkQuotes(BILL_TYPE_CODE, new ArrayList<Long>(materialIds));
                if (!quoteResp.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u7269\u8d44\u5f15\u7528\u60c5\u51b5\u5931\u8d25");
                }
                ArrayList<Long> quoteMaterialIds = new ArrayList<Long>();
                Map quoteResult = (Map)quoteResp.getData();
                this.logger.debug("*****\u67e5\u8be2\u5230\u7269\u8d44\u5f15\u7528\u60c5\u51b5****\uff1a{}", (Object)JSONObject.toJSONString((Object)quoteResult));
                for (String billId : quoteResult.keySet()) {
                    if (!"true".equals(quoteResult.get(billId))) continue;
                    quoteMaterialIds.add(Long.valueOf(billId));
                }
                if (CollectionUtils.isNotEmpty(quoteMaterialIds)) {
                    StringBuilder repeatTip = new StringBuilder();
                    saveOrUpdateVOs.stream().filter(item -> quoteMaterialIds.contains(item.getId())).forEach(material -> repeatTip.append("\u540d\u79f0\uff1a").append(material.getName()).append("\uff0c\u5355\u4f4d\uff1a").append(material.getUnitName()).append("\uff0c\u5c5e\u6027\uff1a").append(material.getPropertyShowName()).append("\uff1b"));
                    return CommonResponse.error((String)("\u7269\u8d44\u3010" + repeatTip.substring(0, repeatTip.length() - 1) + "\u3011\u88ab\u5f15\u7528\uff0c\u4fee\u6539\u5931\u8d25"));
                }
            }
            List<MaterialVO> saveVos = this.service.saveOrUpdateMaterials(saveOrUpdateVOs);
            resp.addAll(saveVos);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", resp);
    }

    @PostMapping(value={"/materialCheck"})
    public CommonResponse<List<MaterialVO>> materialCheck(@RequestBody List<MaterialVO> checkVos, @RequestParam(required=false, defaultValue="false") boolean generateCode) {
        List<MaterialVO> resp = this.service.materialCheck(checkVos, generateCode);
        resp.stream().filter(item -> item.isMatchFlag()).forEach(matchVo -> matchVo.setMatchFlag(ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode().equals(matchVo.getValidFlag())));
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"/generateMaterialCodeBatch"})
    public CommonResponse<List<String>> generateMaterialCodeBatch(@RequestParam String categoryCode, @RequestParam int num) {
        return CommonResponse.success(this.service.generateMaterialCodeBatch(categoryCode, num));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialVO> queryDetail(Long id) {
        MaterialEntity entity = (MaterialEntity)((Object)this.service.selectById(id));
        MaterialVO vo = (MaterialVO)BeanMapper.map((Object)((Object)entity), MaterialVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialVO>> queryDetailList(Long[] ids, boolean queryRelations) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", this.service.queryDetailList(Arrays.asList(ids), queryRelations));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        CommonResponse quoteResp = this.billTypeApi.checkQuotes(BILL_TYPE_CODE, ids);
        if (!quoteResp.isSuccess()) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u7269\u8d44\u6863\u6848\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\u60c5\u51b5\u5931\u8d25\uff01");
        }
        Map quoteResult = (Map)quoteResp.getData();
        ArrayList<Long> quoteMaterialIds = new ArrayList<Long>();
        for (String billId : quoteResult.keySet()) {
            if (!"true".equals(quoteResult.get(billId))) continue;
            quoteMaterialIds.add(Long.valueOf(billId));
        }
        if (CollectionUtils.isNotEmpty(quoteMaterialIds)) {
            List<MaterialVO> vos = this.service.queryDetailList(quoteMaterialIds, false);
            StringBuilder sp = new StringBuilder();
            sp.append("\u5220\u9664\u5931\u8d25\uff0c\u7269\u8d44[");
            vos.stream().forEach(material -> sp.append("\u540d\u79f0\uff1a").append(material.getName()).append("\uff0c\u7f16\u7801\uff1a").append(material.getCode()).append(";"));
            return CommonResponse.error((String)(sp.substring(0, sp.length() - 1) + "]\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff01"));
        }
        this.service.deleteBatch(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        HashMap<String, Object> pageParams = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty((Map)param.getOrderMap())) {
            for (String key : param.getOrderMap().keySet()) {
                pageParams.put("orderKey", key);
                pageParams.put("orderType", "desc".equals(param.getOrderMap().get(key)) ? "desc" : "asc");
            }
        }
        boolean loadSourceList = null != param.getParams().get("sourceList");
        param.getParams().remove("sourceList");
        pageParams.put("searchText", param.getSearchText());
        pageParams.put("pageSize", param.getPageSize());
        pageParams.put("startLine", (param.getPageIndex() - 1 < 0 ? 0 : param.getPageIndex() - 1) * param.getPageSize());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        fuzzyFields.add("description");
        fuzzyFields.add("categoryCode");
        fuzzyFields.add("categoryName");
        pageParams.put("tenantId", InvocationInfoProxy.getTenantid());
        Map params = param.getParams();
        HashMap<String, String> propertyFilterParam = new HashMap<String, String>();
        HashMap<String, String> propertyNameParam = new HashMap<String, String>();
        List<Long> invalidMatCategoryIds = null;
        for (String key : params.keySet()) {
            if (key.indexOf("p@@") < 0) {
                pageParams.put(key, ((Parameter)params.get(key)).getValue().toString());
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)((Parameter)params.get(key)).getValue().toString())) continue;
            propertyFilterParam.put(key.split("@@")[2], ((Parameter)params.get(key)).getValue().toString());
        }
        if (null != params.get("validFlag") && ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u5426.getCode().equals(Integer.valueOf(((Parameter)params.get("validFlag")).getValue().toString()))) {
            invalidMatCategoryIds = this.invalidMatExaminerService.getLastCategoryIdsByEmpId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        }
        if (null != invalidMatCategoryIds && invalidMatCategoryIds.isEmpty()) {
            resp.put("total", (Object)0);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
        }
        if (null != params.get("hasNewPropertyVal")) {
            List<Long> hasNewPropertyItemMaterialIds = this.relationService.validMaterialHasNewPropertyItem(null);
            if ("1".equals(((Parameter)params.get("hasNewPropertyVal")).getValue().toString())) {
                pageParams.remove("hasNewPropertyVal");
                pageParams.put("includeIds", hasNewPropertyItemMaterialIds);
            } else {
                pageParams.put("excludeIds", hasNewPropertyItemMaterialIds);
            }
            params.remove("hasNewPropertyVal");
            pageParams.remove("hasNewPropertyVal");
        }
        if (null != params.get("categoryId")) {
            Long categoryId = Long.valueOf(((Parameter)params.get("categoryId")).getValue().toString());
            if (null != invalidMatCategoryIds && !invalidMatCategoryIds.contains(categoryId)) {
                resp.put("total", (Object)0);
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
            }
            MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.materialCategoryService.selectById(categoryId));
            if (ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027_\u662f.getCode().equals(category.getPropertyFlag())) {
                List<MaterialCategoryPropertyVO> properties = this.propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
                ArrayList propertyMap = new ArrayList();
                HashMap<String, String> m = null;
                for (MaterialCategoryPropertyVO p : properties) {
                    m = new HashMap<String, String>();
                    m.put("key", "p@@" + p.getName() + "@@" + p.getId());
                    m.put("title", p.getName());
                    propertyNameParam.put(p.getName(), "p@@" + p.getName() + "@@" + p.getId());
                    propertyMap.add(m);
                }
                resp.put("propertyList", propertyMap);
                HashMap<String, Object> matchParam = new HashMap<String, Object>();
                matchParam.put("categoryId", categoryId);
                matchParam.put("matchPropertys", propertyFilterParam);
                List<Long> materialIds = this.relationService.matchedMaterialIdsByPropertyVal(matchParam);
                if (CollectionUtils.isEmpty(materialIds)) {
                    resp.put("total", (Object)0);
                    return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
                }
                pageParams.remove("categoryId");
                pageParams.put("ids", materialIds);
            } else {
                List<MaterialCategoryVO> categorys = this.materialCategoryService.queryAllByPid(categoryId, null);
                pageParams.remove("categoryId");
                pageParams.put("categoryIds", categorys.stream().map(BaseVO::getId).collect(Collectors.toList()));
            }
        } else if (null != invalidMatCategoryIds) {
            pageParams.put("categoryIds", invalidMatCategoryIds);
        }
        if (null != params.get("enabled") && "-1".equals(((Parameter)params.get("enabled")).getValue().toString())) {
            pageParams.remove("enabled");
        }
        if (null != params.get("blockedFlag") && "-1".equals(((Parameter)params.get("blockedFlag")).getValue().toString())) {
            pageParams.remove("blockedFlag");
        }
        pageParams.put("validFlag", null == params.get("validFlag") ? ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode() : ((Parameter)params.get("validFlag")).getValue().toString());
        Long count = this.service.pageCount(pageParams);
        if (count > 0L) {
            List<MaterialVO> vos = this.service.queryPage(pageParams);
            if (loadSourceList) {
                this.loadSourceList(vos);
            }
            if (null != resp.get((Object)"propertyList")) {
                List dataList = JSONArray.parseArray((String)JSONObject.toJSONString(vos), JSONObject.class);
                for (JSONObject data : dataList) {
                    if (!StringUtils.isNotBlank((CharSequence)data.getString("propertyShowName"))) continue;
                    for (String p : data.getString("propertyShowName").split("\uff1b")) {
                        if (!propertyNameParam.containsKey(p.split("\uff1a")[0])) continue;
                        data.put((String)propertyNameParam.get(p.split("\uff1a")[0]), (Object)p.split("\uff1a")[1]);
                    }
                }
                resp.put("records", (Object)dataList);
            } else {
                if (loadSourceList && CollectionUtils.isNotEmpty(vos)) {
                    this.loadSourceList(vos);
                }
                resp.put("records", vos);
            }
        } else {
            resp.put("records", new ArrayList());
        }
        resp.put("total", (Object)count);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    private void loadSourceList(List<MaterialVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> materialids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            List<MaterialSourceVO> sourceVOS = this.materialSourceService.getAllByMaterialIds(materialids);
            List<Long> hasNewPropertyItemMaterialIds = this.relationService.validMaterialHasNewPropertyItem(materialids);
            Map groupByMaterialId = sourceVOS.stream().collect(Collectors.groupingBy(MaterialSourceVO::getMaterialId, Collectors.toList()));
            vos.stream().forEach(materiail -> {
                if (groupByMaterialId.containsKey(materiail.getId())) {
                    materiail.setSourceList((List)groupByMaterialId.get(materiail.getId()));
                }
                materiail.setHasNewPropertyValStr(hasNewPropertyItemMaterialIds.contains(materiail.getId()) ? "\u662f" : "\u5426");
            });
        }
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws Exception {
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        Map params = param.getParams();
        String exportFileName = "Material-export.xlsx";
        boolean propertyFlag = false;
        File exportExcel = null;
        ArrayList<ExportColVO> fields = new ArrayList<ExportColVO>();
        HashMap propertyNameMap = new HashMap();
        if (null == params.get("validFlag")) {
            params.put("validFlag", new Parameter("eq", (Object)ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode()));
        }
        if (null != params.get("categoryId")) {
            Long categoryId = Long.valueOf(((Parameter)params.get("categoryId")).getValue().toString());
            MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.materialCategoryService.selectById(categoryId));
            if (ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027_\u662f.getCode().equals(category.getPropertyFlag())) {
                propertyFlag = true;
                exportFileName = "Material-dynamic-export2.xlsx";
                List<MaterialCategoryPropertyVO> properties = this.propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
                fields.add(new ExportColVO("\u7269\u8d44\u5206\u7c7b", "categoryName"));
                fields.add(new ExportColVO("\u7269\u8d44\u7f16\u7801", "code"));
                fields.add(new ExportColVO("\u7269\u8d44\u540d\u79f0", "name"));
                fields.add(new ExportColVO("\u8ba1\u91cf\u5355\u4f4d", "unitName"));
                boolean idx = false;
                properties.stream().forEach(property -> {
                    propertyNameMap.put(property.getName(), "p" + (fields.size() + 1));
                    fields.add(new ExportColVO(property.getName(), "p" + (fields.size() + 1)));
                });
                fields.add(new ExportColVO("\u72b6\u6001", "enabledStr"));
                fields.add(new ExportColVO("\u5c01\u5b58\u72b6\u6001", "blockedFlagStr"));
            } else {
                List<MaterialCategoryVO> categorys = this.materialCategoryService.queryAllByPid(categoryId, null);
                params.put("categoryId", new Parameter("in", categorys.stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, MaterialVO.class);
        vos.parallelStream().forEach(item -> {
            item.setEnabledStr(item.getEnabled() == 1 ? "\u542f\u7528" : "\u505c\u7528");
            item.setBlockedFlagStr(item.getBlockedFlag() == 1 ? "\u5c01\u5b58" : "\u6b63\u5e38");
        });
        HashMap<String, Object> beans = new HashMap<String, Object>();
        if (propertyFlag) {
            List dataList = BeanMapper.mapList((Iterable)vos, JSONObject.class);
            dataList.stream().forEach(data -> {
                if (StringUtils.isNotBlank((CharSequence)data.getString("propertyShowName"))) {
                    for (String p : data.getString("propertyShowName").split("\uff1b")) {
                        data.put((String)propertyNameMap.get(p.split("\uff1a")[0]), (Object)p.split("\uff1a")[1]);
                    }
                }
            });
            beans.put("records", dataList);
            try {
                exportExcel = File.createTempFile("\u7269\u8d44\u6863\u6848\u5217\u8868", "xlsx");
                ClassPathResource resource = new ClassPathResource("excel/Material-dynamic-export.xlsx");
                XSSFWorkbook workbook = new XSSFWorkbook(resource.getInputStream());
                MaterialController.prepareExportExcel((Workbook)workbook, fields, new FileOutputStream(exportExcel));
                this.export(new FileInputStream(exportExcel), beans, response, null);
            }
            catch (Exception e) {
                this.logger.error("\u7269\u8d44\u6863\u6848\u5bfc\u51fa\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u7269\u8d44\u6863\u6848\u5bfc\u51fa\u5931\u8d25");
            }
            finally {
                if (null != exportExcel) {
                    exportExcel.deleteOnExit();
                }
            }
        } else {
            beans.put("records", vos);
            ExcelExport.getInstance().exportWithTrans(exportFileName, beans, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(InputStream is, Map<String, Object> data, HttpServletResponse response, String excelExportTitle) {
        XLSTransformer transformer = new XLSTransformer();
        ServletOutputStream outputStream = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            data.put("dateFormat", dateFormat);
            data.put("timeFormat", timeFormat);
            outputStream = response.getOutputStream();
            Workbook workbook = transformer.transformXLS(is, data);
            if (StringUtils.isNotBlank((CharSequence)excelExportTitle)) {
                workbook.getSheetAt(0).getRow(0).getCell(0).setCellValue(excelExportTitle);
            }
            workbook.write((OutputStream)outputStream);
        }
        catch (Exception var19) {
            var19.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException var18) {
                    var18.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/refMaterialData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialVO>> refMaterialData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("validFlag", new Parameter("eq", (Object)ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/refMaterialList"})
    public CommonResponse<JSONObject> refMaterialList(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject, @RequestParam(required=false) String searchText) {
        JSONObject resp = new JSONObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pageSize", pageSize);
        params.put("startLine", (pageNumber - 1 < 0 ? 0 : pageNumber - 1) * pageSize);
        params.put("searchText", searchText);
        Long categoryId = null;
        List<MaterialCategoryPropertyVO> propertyList = null;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            categoryId = Long.parseLong(relyCondition.split("=")[1]);
        }
        if (null != categoryId) {
            List<Long> categoryIds = new ArrayList<Long>();
            MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.materialCategoryService.selectById(categoryId));
            if (Integer.valueOf(0).equals(category.getPropertyFlag())) {
                List<MaterialCategoryVO> materialCategoryVos = this.materialCategoryService.queryAllByPid(categoryId, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
                if (CollectionUtils.isEmpty(materialCategoryVos)) {
                    return CommonResponse.error((String)"\u5f53\u524d\u5206\u7c7b\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff01");
                }
                categoryIds = materialCategoryVos.stream().map(BaseVO::getId).collect(Collectors.toList());
            } else {
                propertyList = this.propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
                resp.put("gridHeaders", this.generateGridHeader(propertyList));
                categoryIds.add(categoryId);
            }
            params.put("categoryIds", categoryIds);
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            Map json = (Map)JSONObject.parseObject((String)searchObject, Map.class);
            for (String key : json.keySet()) {
                if (key.contains("p_")) {
                    propertyMap.put(key.replace("p_", ""), json.get(key).toString());
                    continue;
                }
                params.put(key, json.get(key));
            }
        }
        if (MapUtils.isNotEmpty(propertyMap)) {
            params.put("property", propertyMap);
        }
        params.put("enabled", ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        params.put("validFlag", ZDSMaterialCommonEnums.\u7269\u8d44\u662f\u5426\u751f\u6548_\u662f.getCode());
        long count = this.service.countMaterial(params);
        resp.put("total", (Object)count);
        resp.put("pageSize", (Object)(pageSize + ""));
        resp.put("current", (Object)(pageNumber + ""));
        if (count == 0L) {
            resp.put("records", new ArrayList());
            return CommonResponse.success((Object)resp);
        }
        List<MaterialVO> materialList = this.service.pageList(params);
        List dataList = BeanMapper.mapList(materialList, JSONObject.class);
        if (CollectionUtils.isNotEmpty(propertyList)) {
            Map<String, Long> propertyNameIdMap = propertyList.stream().collect(Collectors.toMap(item -> item.getName(), item -> item.getId()));
            dataList.parallelStream().filter(item -> null != item.get((Object)"propertyShowName")).forEach(item -> {
                String[] materialProperty = item.getString("propertyShowName").split("\uff1b");
                String[] pnv = null;
                for (String p : materialProperty) {
                    pnv = p.split("\uff1a");
                    item.put("p_" + propertyNameIdMap.get(pnv[0]), (Object)pnv[1]);
                }
            });
        }
        resp.put("records", (Object)dataList);
        return CommonResponse.success((Object)resp);
    }

    private List<ReferShowfieldVO> generateGridHeader(List<MaterialCategoryPropertyVO> properties) {
        ArrayList<ReferShowfieldVO> resp = new ArrayList<ReferShowfieldVO>();
        resp.add(this.createReferField("\u7269\u8d44\u5206\u7c7b", 1L, "categoryName", true, true, 1, false));
        resp.add(this.createReferField("\u7269\u8d44\u5206\u7c7b\u7f16\u7801", 2L, "categoryCode", false, false, 2, false));
        resp.add(this.createReferField("\u7269\u8d44\u5206\u7c7b\u7f16\u7801", 3L, "categoryId", false, false, 3, false));
        resp.add(this.createReferField("\u7269\u8d44\u7f16\u53f7", 4L, "code", true, true, 4, false));
        resp.add(this.createReferField("\u7269\u8d44\u540d\u79f0", 5L, "name", true, true, 5, false));
        resp.add(this.createReferField("\u7269\u8d44id", 6L, "id", false, false, 6, false));
        resp.add(this.createReferField("\u5355\u4f4dId", 7L, "unitId", false, false, 7, false));
        resp.add(this.createReferField("\u5355\u4f4d", 8L, "unitName", true, true, 8, true));
        resp.add(this.createReferField("\u4ea7\u54c1\u4ee3\u7801", 9L, "productCode", true, true, 9, true));
        int sequence = 9;
        for (MaterialCategoryPropertyVO property : properties) {
            resp.add(this.createReferField(property.getName(), property.getId(), "p_" + property.getId(), true, true, ++sequence, true));
        }
        return resp;
    }

    private ReferShowfieldVO createReferField(String fieldName, Long fieldId, String fieldCode, boolean pcShow, boolean mobileShow, int sequence, boolean filter) {
        ReferShowfieldVO field = new ReferShowfieldVO();
        field.setId(fieldId);
        field.setAlign("center");
        field.setCode(fieldCode);
        field.setName(fieldName);
        field.setReferId("999999L");
        field.setFormat("sys");
        field.setWidth(Integer.valueOf(110));
        field.setHidden(!pcShow);
        field.setMobileShow(mobileShow);
        field.setInnerFilter(filter);
        field.setType("string");
        field.setShowOrder(Integer.valueOf(sequence));
        return field;
    }

    @RequestMapping(value={"/updateEnabledStatus"}, method={RequestMethod.POST})
    public CommonResponse<String> updateEnabled(@RequestBody MaterialVO saveOrUpdateVO) {
        MaterialEntity dbEntity = (MaterialEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
        if (ZDSMaterialCommonEnums.\u5c01\u5b58_\u5c01\u5b58.getCode().equals(dbEntity.getBlockedFlag())) {
            return CommonResponse.error((String)"\u7269\u8d44\u660e\u7ec6\u5c01\u5b58\uff0c\u542f\u7528\u5931\u8d25\uff01");
        }
        if (ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode().equals(saveOrUpdateVO.getEnabled())) {
            List<MaterialCategoryPropertyVO> propertyVOS = this.propertyService.getAllByCategoryId(dbEntity.getCategoryId(), ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            Set propertyIdS = propertyVOS.stream().map(BaseVO::getId).collect(Collectors.toSet());
            Set materialpropertyIds = dbEntity.getRelationList().stream().map(item -> item.getPropertyId()).collect(Collectors.toSet());
            if (propertyIdS.size() < materialpropertyIds.size()) {
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6750\u6599\u5c5e\u6027\u591a\u4e8e\u4e8e\u5206\u7c7b\u4e0b\u5c5e\u6027\uff0c\u8bf7\u7ef4\u62a4");
            }
            List needChooseRequreidPropertys = propertyVOS.stream().filter(p -> ZDSMaterialCommonEnums.\u5c5e\u6027\u662f\u5426\u5fc5\u9009_\u662f.getCode().equals(p.getRequiredFlag()) && !materialpropertyIds.contains(p.getId())).map(MaterialCategoryPropertyVO::getName).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(needChooseRequreidPropertys)) {
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5c5e\u6027\u5206\u7c7b[" + StringUtils.join(needChooseRequreidPropertys, (String)"\u3001") + "]\u4e3a\u5fc5\u9009\uff0c\u8bf7\u8bbe\u7f6e\u5c5e\u6027\u503c\uff01"));
            }
            String msg = this.relationService.checkMaterialPropertyValue(saveOrUpdateVO.getId());
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c" + msg));
            }
        }
        dbEntity.setEnabled(saveOrUpdateVO.getEnabled());
        this.service.saveOrUpdate((Object)dbEntity, false);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/download"})
    public void download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletOutputStream outputStream = null;
        Long categoryId = Long.valueOf(request.getParameter("categoryId"));
        List<MaterialCategoryPropertyVO> propertyList = this.propertyService.getAllByCategoryId(categoryId, ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        ClassPathResource resource = new ClassPathResource("excel/zdsmaterial-import.xlsx");
        XSSFWorkbook workbook = new XSSFWorkbook(resource.getInputStream());
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("\u7269\u6599\u7f16\u7801");
        fields.add("\u7269\u6599\u540d\u79f0*");
        fields.add("\u8ba1\u91cf\u5355\u4f4d*");
        if (!CollectionUtils.isNotEmpty(propertyList)) {
            throw new BusinessException("\u8be5\u5206\u7c7b\u672a\u8bbe\u7f6e\u5c5e\u6027");
        }
        propertyList.stream().forEach(property -> fields.add(property.getRequiredFlag() == 1 ? property.getName() + "*" : property.getName()));
        this.cacheManager.set("category_import_fields::" + categoryId.toString(), (Serializable)((Object)JSONObject.toJSONString(propertyList)));
        fields.add("\u5907\u6ce8");
        try {
            outputStream = response.getOutputStream();
            this.prepareExcel((Workbook)workbook, fields, (OutputStream)outputStream);
        }
        catch (Exception e) {
            this.logger.error("\u660e\u7ec6\u5bfc\u5165\u6a21\u677f\u51c6\u5907\u5f02\u5e38 : ", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    this.logger.error("\u8d44\u6e90\u91ca\u653e\u5f02\u5e38 : ", (Throwable)e);
                }
            }
        }
    }

    public static void prepareExportExcel(Workbook workbook, List<ExportColVO> fields, OutputStream out) throws Exception {
        Sheet sheet = workbook.getSheetAt(0);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fields.size() - 1));
        Row titleRow = sheet.createRow(1);
        titleRow.setHeight(Integer.valueOf(500).shortValue());
        Row fieldRow = sheet.createRow(3);
        fieldRow.setHeight(Integer.valueOf(600).shortValue());
        Cell titleCol = null;
        Cell fieldCol = null;
        XSSFCellStyle cell1Style = (XSSFCellStyle)workbook.createCellStyle();
        cell1Style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell1Style.setAlignment(HorizontalAlignment.CENTER);
        cell1Style.setVerticalAlignment(VerticalAlignment.CENTER);
        cell1Style.setBorderTop(BorderStyle.THIN);
        cell1Style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderRight(BorderStyle.THIN);
        cell1Style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderBottom(BorderStyle.THIN);
        cell1Style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderLeft(BorderStyle.THIN);
        cell1Style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        XSSFFont blackFont = (XSSFFont)workbook.createFont();
        blackFont.setColor(IndexedColors.BLACK.getIndex());
        blackFont.setFontName("\u7b49\u7ebf");
        blackFont.setFontHeightInPoints((short)16);
        XSSFFont redFont = (XSSFFont)workbook.createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        redFont.setFontName("\u7b49\u7ebf");
        redFont.setFontHeightInPoints((short)16);
        CellStyle defaultCellStyle = workbook.createCellStyle();
        defaultCellStyle.setDataFormat(workbook.createDataFormat().getFormat("@"));
        int idx = 0;
        for (ExportColVO col : fields) {
            titleCol = titleRow.createCell(idx);
            fieldCol = fieldRow.createCell(idx);
            cell1Style.setFont((Font)blackFont);
            titleCol.setCellStyle((CellStyle)cell1Style);
            fieldCol.setCellStyle((CellStyle)cell1Style);
            titleCol.setCellValue(col.getTitle());
            fieldCol.setCellValue("${bean." + col.getTableFiled() + "}");
            sheet.autoSizeColumn(idx);
            sheet.setDefaultColumnStyle(idx, defaultCellStyle);
            int columnWidth = sheet.getColumnWidth(idx) + 2000;
            sheet.setColumnWidth(idx, columnWidth);
            ++idx;
        }
        workbook.write(out);
    }

    private void prepareExcel(Workbook workbook, List<String> fields, OutputStream out) throws Exception {
        Sheet sheet = workbook.getSheetAt(0);
        Row row = sheet.createRow(0);
        Cell c = null;
        XSSFCellStyle cell1Style = (XSSFCellStyle)workbook.createCellStyle();
        cell1Style.setFillForegroundColor(new XSSFColor(new byte[]{-58, -32, -76}));
        cell1Style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cell1Style.setAlignment(HorizontalAlignment.CENTER);
        cell1Style.setVerticalAlignment(VerticalAlignment.CENTER);
        cell1Style.setBorderTop(BorderStyle.THIN);
        cell1Style.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderRight(BorderStyle.THIN);
        cell1Style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderBottom(BorderStyle.THIN);
        cell1Style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cell1Style.setBorderLeft(BorderStyle.THIN);
        cell1Style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        XSSFFont blackFont = (XSSFFont)workbook.createFont();
        blackFont.setColor(IndexedColors.BLACK.getIndex());
        blackFont.setFontName("\u7b49\u7ebf");
        blackFont.setFontHeightInPoints((short)16);
        XSSFFont redFont = (XSSFFont)workbook.createFont();
        redFont.setColor(IndexedColors.RED.getIndex());
        redFont.setFontName("\u7b49\u7ebf");
        redFont.setFontHeightInPoints((short)16);
        CellStyle defaultCellStyle = workbook.createCellStyle();
        defaultCellStyle.setDataFormat(workbook.createDataFormat().getFormat("@"));
        int idx = 0;
        int requireIndex = -1;
        for (String field : fields) {
            c = row.createCell(idx);
            cell1Style.setFont((Font)blackFont);
            c.setCellStyle((CellStyle)cell1Style);
            c.setCellValue(field);
            requireIndex = field.indexOf("*");
            if (requireIndex >= 0) {
                c.getRichStringCellValue().applyFont(requireIndex, requireIndex + 1, (Font)redFont);
            }
            sheet.autoSizeColumn(idx);
            sheet.setDefaultColumnStyle(idx, defaultCellStyle);
            int columnWidth = sheet.getColumnWidth(idx) + 2000;
            sheet.setColumnWidth(idx, columnWidth);
            ++idx;
        }
        workbook.write(out);
    }

    @PostMapping(value={"/excelImport"})
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String categoryIdStr = request.getParameter("categoryId");
        MaterialCategoryEntity category = (MaterialCategoryEntity)((Object)this.materialCategoryService.selectById(Long.valueOf(categoryIdStr)));
        if (null == category) {
            return CommonResponse.error((String)"\u6ca1\u6709\u5339\u914d\u7684\u7269\u6599\u660e\u7ec6\u5206\u7c7b\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)categoryIdStr)) {
            return CommonResponse.error((String)"\u7269\u6599\u660e\u7ec6\u6821\u9a8c\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u6240\u5c5e\u5206\u7c7b\u4fe1\u606f");
        }
        String fieldsJson = (String)((Object)this.cacheManager.get("category_import_fields::" + categoryIdStr));
        if (StringUtils.isBlank((CharSequence)fieldsJson)) {
            return CommonResponse.error((String)"\u83b7\u53d6\u5bfc\u5165\u7269\u6599\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u8fdb\u884c\u5bfc\u5165");
        }
        List importPropertys = JSONArray.parseArray((String)fieldsJson, MaterialCategoryPropertyVO.class);
        List<MaterialCategoryPropertyVO> propertys = this.propertyService.queryByIds(importPropertys.stream().map(BaseVO::getId).collect(Collectors.toList()));
        HashMap propertyNameMap = new HashMap();
        HashMap propertyIdNameMap = new HashMap();
        ArrayList<MaterialImportFieldVO> fields = new ArrayList<MaterialImportFieldVO>();
        fields.add(new MaterialImportFieldVO("\u7269\u6599\u7f16\u7801", "code", Boolean.valueOf(false), Boolean.valueOf(true)));
        fields.add(new MaterialImportFieldVO("\u7269\u6599\u540d\u79f0", "name", Boolean.valueOf(true)));
        fields.add(new MaterialImportFieldVO("\u8ba1\u91cf\u5355\u4f4d", "unitName", Boolean.valueOf(true)));
        propertys.stream().forEach(property -> {
            fields.add(new MaterialImportFieldVO(property.getName(), property.getName(), Boolean.valueOf(ZDSMaterialCommonEnums.\u5c5e\u6027\u662f\u5426\u5fc5\u9009_\u662f.getCode().equals(property.getRequiredFlag())), Boolean.valueOf(false), Boolean.valueOf(true)));
            propertyNameMap.put(property.getName(), property);
            propertyIdNameMap.put(property.getId(), property.getName());
        });
        fields.add(new MaterialImportFieldVO("\u5907\u6ce8", "remark", Boolean.valueOf(false)));
        List<MaterialCategoryPropertySubItemVO> propertyItems = this.propertySubItemService.getAllByCategoryId(Long.valueOf(categoryIdStr));
        Map propertyItemMap = propertyItems.stream().collect(Collectors.groupingBy(item -> {
            this.logger.info("{},{}", (Object)item.getPropertyId(), (Object)JSONObject.toJSONString(propertyIdNameMap.get(item.getPropertyId())));
            return (String)propertyIdNameMap.get(item.getPropertyId());
        }, Collectors.toMap(MaterialCategoryPropertySubItemVO::getName, Function.identity())));
        ArrayList<JSONObject> processList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> errorList = new ArrayList<JSONObject>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u7269\u6599\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            if (((List)result.get(0)).size() != fields.size()) {
                return CommonResponse.error((String)"\u7269\u6599\u660e\u7ec6\u5bfc\u5165\u5b57\u6bb5\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
            }
            HashMap codeMapCache = new HashMap();
            HashMap<String, JSONObject> nameUnitPropertyCheck = new HashMap<String, JSONObject>();
            HashSet<String> unitNames = new HashSet<String>();
            JSONObject importVo = null;
            MaterialImportFieldVO tmpField = null;
            Map propertyItemNameMap = null;
            MaterialPropertyRelationVO relation = null;
            MaterialCategoryPropertyVO property2 = null;
            MaterialCategoryPropertySubItemVO propertySubItem = null;
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                importVo = new JSONObject();
                importVo.put("isValid", (Object)true);
                importVo.put("relationList", new ArrayList());
                importVo.put("categoryId", (Object)Long.valueOf(categoryIdStr));
                importVo.put("categoryCode", (Object)category.getCode());
                importVo.put("categoryName", (Object)category.getName());
                for (int vi = 0; vi < datas.size(); ++vi) {
                    tmpField = (MaterialImportFieldVO)fields.get(vi);
                    importVo.put(tmpField.getFieldCode(), StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(vi))) ? ((String)datas.get(vi)).trim() : null);
                    if (tmpField.getRequired().booleanValue() && StringUtils.isBlank((CharSequence)((CharSequence)datas.get(vi)))) {
                        importVo.put("importMsg", (Object)(tmpField.getFieldName() + "\u4e3a\u7a7a\uff01"));
                        errorList.add(importVo);
                        importVo.put("isValid", (Object)false);
                        continue;
                    }
                    if (importVo.getBoolean("isValid").booleanValue() && tmpField.getRepeatCheck().booleanValue() && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(vi)))) {
                        if (codeMapCache.containsKey(datas.get(vi))) {
                            importVo.put("importMsg", (Object)(tmpField.getFieldName() + "\u91cd\u590d\uff01"));
                            errorList.add(importVo);
                            importVo.put("isValid", (Object)false);
                            continue;
                        }
                        codeMapCache.put(datas.get(vi), importVo);
                    }
                    if (!importVo.getBoolean("isValid").booleanValue() || !tmpField.getPropertyField().booleanValue() || !StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(vi)))) continue;
                    property2 = (MaterialCategoryPropertyVO)propertyNameMap.get(tmpField.getFieldCode());
                    propertyItemNameMap = propertyItemMap.get(tmpField.getFieldCode());
                    if (null == propertyItemNameMap) {
                        return CommonResponse.error((String)"\u7269\u6599\u660e\u7ec6\u5bfc\u5165\u5b57\u6bb5\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
                    }
                    propertySubItem = (MaterialCategoryPropertySubItemVO)propertyItemNameMap.get(datas.get(vi));
                    if (null == propertySubItem) {
                        importVo.put("importMsg", (Object)("\u5c5e\u6027\u5206\u7c7b\u3010" + tmpField.getFieldName() + "\u3011\u4e0b\u6ca1\u6709\u8bbe\u7f6e\u5c5e\u6027\u503c\uff1a\u3010" + (String)datas.get(vi) + "\u3011"));
                        errorList.add(importVo);
                        importVo.put("isValid", (Object)false);
                        continue;
                    }
                    relation = new MaterialPropertyRelationVO();
                    relation.setCategoryId(category.getId());
                    relation.setPropertySequence(property2.getSequence());
                    relation.setPropertyName(property2.getName());
                    relation.setPropertyId(property2.getId());
                    relation.setPropertyItemId(propertySubItem.getId());
                    if (ZDSMaterialCommonEnums.\u5c5e\u6027\u5206\u7c7b\u662f\u5426\u542f\u7528\u4ea7\u54c1\u4ee3\u7801_\u662f.getCode().equals(property2.getProductCodeFlag()) && StringUtils.isNotBlank((CharSequence)propertySubItem.getProductCode())) {
                        importVo.put("productCode", (Object)(null != importVo.getString("productCode") ? importVo.getString("productCode") + propertySubItem.getProductCode() : propertySubItem.getProductCode()));
                    }
                    relation.setPropertyValue((String)datas.get(vi));
                    importVo.getJSONArray("relationList").add((Object)relation);
                    importVo.put("propertyAndValue", (Object)(tmpField.getFieldName() + "\uff1a" + (String)datas.get(vi)));
                    importVo.put("propertyShowName", (Object)(null != importVo.get((Object)"propertyShowName") ? importVo.getString("propertyShowName") + "\uff1b" + importVo.getString("propertyAndValue") : importVo.getString("propertyAndValue")));
                }
                if (!importVo.getBoolean("isValid").booleanValue()) continue;
                if (nameUnitPropertyCheck.containsKey(importVo.getString("name") + importVo.getString("unitName") + importVo.getString("propertyShowName"))) {
                    importVo.put("importMsg", (Object)"\u5b58\u5728\u3010\u540d\u79f0+\u5355\u4f4d+\u5c5e\u6027\u3011\u91cd\u590d\u7684\u7269\u6599\u660e\u7ec6\uff01");
                    errorList.add(importVo);
                    continue;
                }
                nameUnitPropertyCheck.put(importVo.getString("name") + importVo.getString("unitName") + importVo.getString("propertyShowName"), importVo);
                importVo.put("id", (Object)IdWorker.getId());
                unitNames.add(importVo.getString("unitName"));
                processList.add(importVo);
            }
            if (ListUtil.isNotEmpty(processList)) {
                CommonResponse unitResp;
                List<MaterialVO> codeList;
                if (MapUtils.isNotEmpty(codeMapCache) && CollectionUtils.isNotEmpty(codeList = this.service.getByCodes(new ArrayList<String>(codeMapCache.keySet())))) {
                    for (MaterialVO repeatCode : codeList) {
                        importVo = (JSONObject)codeMapCache.get(repeatCode.getCode());
                        codeMapCache.remove(repeatCode.getCode());
                        processList.remove(importVo);
                        importVo.put("importMsg", (Object)"\u7f16\u7801\u91cd\u590d\uff01");
                        errorList.add(importVo);
                    }
                }
                if (!(unitResp = this.unitApi.findAllEnabledList(new ArrayList(unitNames))).isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)unitResp));
                    throw new BusinessException("\u67e5\u8be2\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff01");
                }
                Map unitNameMap = ((List)unitResp.getData()).stream().collect(Collectors.toMap(UnitShareVO::getUnitName, Function.identity()));
                Iterator ite = processList.iterator();
                while (ite.hasNext()) {
                    importVo = (JSONObject)ite.next();
                    if (!unitNameMap.containsKey(importVo.getString("unitName"))) {
                        importVo.put("importMsg", (Object)"\u6ca1\u6709\u5339\u914d\u7684\u5355\u4f4d\uff01");
                        errorList.add(importVo);
                        ite.remove();
                        continue;
                    }
                    importVo.put("unitId", (Object)((UnitShareVO)unitNameMap.get(importVo.getString("unitName"))).getId());
                }
                List checkVos = BeanMapper.mapList(processList, MaterialVO.class);
                List<MaterialVO> repeatVos = this.service.checkUnitAndProperty(checkVos, false);
                if (CollectionUtils.isNotEmpty(repeatVos)) {
                    List repeatList = repeatVos.stream().map(repeat -> (JSONObject)nameUnitPropertyCheck.get(repeat.getName() + repeat.getUnitName() + (StringUtils.isNotBlank((CharSequence)repeat.getPropertyShowName()) ? repeat.getPropertyShowName() : ""))).collect(Collectors.toList());
                    repeatList.stream().forEach(item -> {
                        item.put("importMsg", (Object)"\u5b58\u5728\u3010\u540d\u79f0+\u5355\u4f4d+\u5c5e\u6027\u3011\u91cd\u590d\u7684\u7269\u6599\u660e\u7ec6\uff01");
                        errorList.add((JSONObject)item);
                        processList.remove(item);
                    });
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", processList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @PostMapping(value={"/saveExcelImportMaterial"})
    public CommonResponse<String> saveExcelImportMaterial(@RequestBody List<MaterialVO> saveImportVos) {
        if (ListUtil.isEmpty(saveImportVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        this.service.saveExcelImport(saveImportVos);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @PostMapping(value={"/delInvalidMaterial"})
    public CommonResponse<String> delInvalidMaterial(@RequestBody List<Long> ids) {
        this.service.delInvalidMaterial(ids);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/materialBatchValid"})
    public CommonResponse<String> materialBatchValid(@RequestBody List<Long> ids) {
        String msg = this.service.beforeValidCheck(ids);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        this.service.materialBatchValid(ids);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private CommonResponse<String> materialPreCheck(List<MaterialVO> saveOrUpdateVOs, Map<String, MaterialVO> materialCode, Set<String> repeatMaterialCode, Set<Long> materialIds, List<MaterialVO> unCodeList) {
        HashSet<String> repeatNamePropertyUnitCheck = new HashSet<String>();
        HashSet<String> repeatNamePropertyUnit = new HashSet<String>();
        StringBuilder spc = new StringBuilder();
        StringBuilder requireSpc = new StringBuilder();
        saveOrUpdateVOs.stream().forEach(material -> {
            if (StringUtils.isBlank((CharSequence)material.getCode())) {
                unCodeList.add((MaterialVO)material);
            }
        });
        if (CollectionUtils.isNotEmpty(unCodeList)) {
            this.service.generateMaterialCodeBatchNew(unCodeList);
        }
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"code", new ArrayList(unCodeList.stream().map(MaterialVO::getCode).collect(Collectors.toSet())));
        query.in((Object)"dr", new Object[]{BaseVO.DR_UNDELETE});
        query.in((Object)"blocked_flag", new Object[]{1});
        List dbList = this.service.list((Wrapper)query);
        Object repeatVo = null;
        HashMap<String, MaterialVO> materialCodeMap = new HashMap<String, MaterialVO>();
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            List vos = BeanMapper.mapList((Iterable)dbList, MaterialVO.class);
            materialCodeMap.putAll(vos.stream().collect(Collectors.toMap(MaterialVO::getCode, item -> item)));
        }
        List<MaterialCategoryPropertyVO> categoryPropertys = this.propertyService.getAllByCategoryId(saveOrUpdateVOs.get(0).getCategoryId(), ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
        Map<Long, MaterialCategoryPropertyVO> requiredPropertyMap = categoryPropertys.stream().filter(property -> ZDSMaterialCommonEnums.\u5c5e\u6027\u662f\u5426\u5fc5\u9009_\u662f.getCode().equals(property.getRequiredFlag())).collect(Collectors.toMap(BaseVO::getId, item -> item));
        MaterialVO dbVo = null;
        for (MaterialVO material2 : saveOrUpdateVOs) {
            if (spc.length() > 0) {
                spc.delete(0, spc.length());
            }
            if (null != (dbVo = materialCode.get(material2.getCode()))) {
                if (!StringUtils.equals((CharSequence)(material2.getName() + material2.getUnitName() + (StringUtils.isNotBlank((CharSequence)material2.getPropertyShowName()) ? material2.getPropertyShowName() : "")), (CharSequence)(dbVo.getName() + dbVo.getUnitName() + (StringUtils.isNotBlank((CharSequence)dbVo.getPropertyShowName()) ? dbVo.getPropertyShowName() : "")))) {
                    return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u7f16\u7801[" + material2.getCode() + "]\u76f8\u540c\uff0c\u5355\u4f4d/\u89c4\u683c\u578b\u53f7\u4e0d\u540c\u7684\u7269\u6599\uff01"));
                }
                repeatMaterialCode.add(material2.getCode());
            }
            if (null != (dbVo = (MaterialVO)materialCodeMap.get(material2.getCode())) && !StringUtils.equals((CharSequence)(material2.getName() + material2.getUnitName() + (StringUtils.isNotBlank((CharSequence)material2.getPropertyShowName()) ? material2.getPropertyShowName() : "")), (CharSequence)(dbVo.getName() + dbVo.getUnitName() + (StringUtils.isNotBlank((CharSequence)dbVo.getPropertyShowName()) ? dbVo.getPropertyShowName() : "")))) {
                return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u7f16\u7801[" + material2.getCode() + "]\u76f8\u540c\uff0c\u5355\u4f4d/\u89c4\u683c\u578b\u53f7\u4e0d\u540c\u7684\u7269\u6599\uff01"));
            }
            materialCode.put(material2.getCode(), material2);
            if (null != material2.getId()) {
                materialIds.add(material2.getId());
            }
            spc.append("\u540d\u79f0\uff1a").append(material2.getName()).append("\uff0c\u5355\u4f4d\uff1a").append(material2.getUnitName()).append("\uff0c\u5c5e\u6027\uff1a").append(material2.getPropertyShowName());
            if (!repeatNamePropertyUnitCheck.contains(spc.toString())) {
                repeatNamePropertyUnitCheck.add(spc.toString());
            } else {
                repeatNamePropertyUnit.add(spc.toString());
            }
            if (!CollectionUtils.isNotEmpty((Collection)material2.getRelationList()) || !MapUtils.isNotEmpty(requiredPropertyMap)) continue;
            Set<Long> requiredIds = requiredPropertyMap.keySet();
            requiredIds.removeAll(material2.getRelationList().stream().map(MaterialPropertyRelationVO::getPropertyId).collect(Collectors.toList()));
            if (!CollectionUtils.isNotEmpty(requiredIds)) continue;
            requireSpc.append("\u540d\u79f0\uff1a").append(material2.getName()).append("\uff0c\u5355\u4f4d\uff1a").append(material2.getUnitName()).append("\u5c5e\u6027\uff1a\u3010");
            for (Long propertyId : requiredIds) {
                requireSpc.append(requiredPropertyMap.get(propertyId)).append("\u3001");
            }
            requireSpc.append(requiredPropertyMap.values().stream().filter(item -> requiredIds.contains(item.getId())).map(MaterialCategoryPropertyVO::getName).collect(Collectors.joining("\u3001"))).append("]\u3001");
        }
        if (repeatMaterialCode.size() > 0) {
            return CommonResponse.error((String)("\u7269\u8d44\u7f16\u7801\u3010" + StringUtils.join(repeatMaterialCode, (String)",") + "\u3011\u91cd\u590d"));
        }
        if (repeatNamePropertyUnit.size() > 0) {
            return CommonResponse.error((String)("\u5b58\u5728\u91cd\u590d\u7684\u7269\u8d44\uff1a\u3010" + spc.toString() + "\u3011"));
        }
        return null;
    }

    @PostMapping(value={"/saveFromInvalidMaterial"})
    public CommonResponse<List<MaterialVO>> saveFromInvalidMaterial(@RequestBody List<MaterialVO> saveOrUpdateVOs) {
        CommonResponse<String> checkResp = this.materialPreCheck(saveOrUpdateVOs, new HashMap<String, MaterialVO>(), new HashSet<String>(), new HashSet<Long>(), new ArrayList<MaterialVO>());
        if (null != checkResp) {
            return checkResp;
        }
        List<MaterialVO> resp = this.service.saveFromInvalidMaterial(saveOrUpdateVOs);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", resp);
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImportInfo(request, response);
    }

    @GetMapping(value={"/handleAdd"})
    public void handleAdd() {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.isNull((Object)"source_id");
        query.last(" limit 1");
        while (flag) {
            MaterialEntity material = (MaterialEntity)((Object)this.service.getOne((Wrapper)query));
            if (null != material) {
                this.service.handAdd(material);
                continue;
            }
            flag = false;
        }
    }
}

