/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.controller.api;

import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MatSupplierManagerEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatSupplierManagerService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.vo.MatSupplierManagerVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/zdsMatSupManagerApi/"})
public class MatSupManagerApi {
    @Autowired
    private IMatSupplierManagerService matSupplierManagerService;
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @GetMapping(value={"getCategoryIdsByUseId"})
    public CommonResponse<List<Long>> getCategoryIdsByUseId(@RequestParam Long userId) {
        List<MaterialCategoryEntity> categorys;
        List<Object> resp = new ArrayList();
        List<MatSupplierManagerEntity> entityList = this.matSupplierManagerService.getAllByUserId(userId);
        if (CollectionUtils.isNotEmpty(entityList) && CollectionUtils.isNotEmpty(categorys = this.materialCategoryService.getAllLeafByPids(entityList.stream().map(MatSupplierManagerEntity::getCategoryId).collect(Collectors.toList()), ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode()))) {
            resp = categorys.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        return CommonResponse.success(resp);
    }

    @GetMapping(value={"getAllByCategoryIds"})
    public CommonResponse<List<MatSupplierManagerVO>> getAllByCategoryIds(@RequestParam List<Long> categoryIds) {
        List<MatSupplierManagerEntity> dbList;
        List resp = new ArrayList();
        List<MaterialCategoryVO> categorys = this.materialCategoryService.queryCategoryListByChildren(categoryIds);
        if (CollectionUtils.isNotEmpty(categorys) && CollectionUtils.isNotEmpty(dbList = this.matSupplierManagerService.getAllByCategoryIds(categorys.stream().map(BaseVO::getId).collect(Collectors.toList())))) {
            resp = BeanMapper.mapList(dbList, MatSupplierManagerVO.class);
        }
        return CommonResponse.success(resp);
    }
}

