/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.ErpInvoiceEntity;
import com.ejianc.business.zdsmaterial.erp.service.IErpInvoiceService;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceDetailEntity;
import com.ejianc.business.zdsmaterial.material.bean.MatInvoiceEntity;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceDetailService;
import com.ejianc.business.zdsmaterial.material.service.IMatInvoiceService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="matInvoice")
public class MatInvoiceBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMatInvoiceService matInvoiceService;
    @Autowired
    private IMatInvoiceDetailService matInvoiceDetailService;
    @Autowired
    private IErpInvoiceService erpInvoiceService;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return this.checkInvoiceState(billId);
    }

    private CommonResponse<String> checkInvoiceState(Long billId) {
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)this.matInvoiceService.selectById(billId));
        if (PlanConstant.SOURCE_TYPE_SUPPLIER.equals(entity.getSourceType())) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"source_id", (Object)entity.getSourceId());
            query.eq((Object)"sign_state", (Object)"1");
            query.ne((Object)"id", (Object)entity.getId());
            query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()});
            List dbList = this.matInvoiceService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                this.logger.error("\u91c7\u8d2d\u53d1\u7968\u767b\u8bb0\u5355\u636e-{}id-{}\u786e\u8ba4\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u590d\u53d1\u7968\u53f7\u4e14\u5ba1\u6838\u4e2d/\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3010ids-{}\u3011", (Object)entity.getId(), (Object)StringUtils.join((Iterable)dbList.stream().map(BaseEntity::getId).collect(Collectors.toSet()), (String)","));
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5b58\u5728\u53d1\u7968\u53f7\u76f8\u540c\u4e14\u5df2\u63d0\u4ea4\u5ba1\u6838\u7684\u5355\u636e\u3010" + StringUtils.join((Iterable)dbList.stream().map(MatInvoiceEntity::getBillCode).collect(Collectors.toSet()), (String)",") + "\u3011");
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            LambdaUpdateWrapper update;
            ArrayList<String> numbers = new ArrayList<String>(entity.getDetailList().stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getInvoiceNumber())).map(MatInvoiceDetailEntity::getInvoiceNumber).collect(Collectors.toSet()));
            if (CollectionUtils.isNotEmpty(numbers)) {
                List<ErpInvoiceEntity> list = this.erpInvoiceService.getAllByInvoiceNums(numbers);
                this.logger.info("\u91c7\u8d2d: \u6839\u636e\u53d1\u7968\u53f7\uff1a{}, EL\u67e5\u8be2\u5230\u53d1\u7968\u6570\uff1a{}", (Object)JSONObject.toJSONString(numbers), (Object)list.size());
                HashSet<String> quoteNumList = new HashSet<String>();
                for (ErpInvoiceEntity e : list) {
                    this.logger.info("\u91c7\u8d2d\u53d1\u7968id-{},number-{}, ERP\u5f15\u7528\u6807\u8bc6\uff1a{}", new Object[]{e.getId(), e.getNumber(), e.getErpQuoteFlag()});
                    if (!"1".equals(e.getErpQuoteFlag())) continue;
                    quoteNumList.add(e.getNumber());
                }
                if (CollectionUtils.isNotEmpty(quoteNumList)) {
                    return CommonResponse.error((String)("\u64cd\u4f5c\u5931\u8d25\uff0c\u53f7\u7801\u4e3a[" + quoteNumList.stream().collect(Collectors.joining(",")) + "]\u7684\u53d1\u7968\u5df2\u88ab\u5f15\u7528"));
                }
            }
            List invIdList = entity.getDetailList().stream().map(MatInvoiceDetailEntity::getErpId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(ErpInvoiceEntity::getSourceId, invIdList);
            List invoiceEntities = this.erpInvoiceService.list((Wrapper)queryWrapper);
            HashSet<String> rightSet = new HashSet<String>();
            HashSet<String> errSet = new HashSet<String>();
            HashSet<String> errNumSet = new HashSet<String>();
            if (CollectionUtils.isNotEmpty((Collection)invoiceEntities)) {
                for (ErpInvoiceEntity invoiceEntity : invoiceEntities) {
                    if ("0".equals(invoiceEntity.getStatusCode())) {
                        rightSet.add(invoiceEntity.getSourceId());
                        continue;
                    }
                    errSet.add(invoiceEntity.getSourceId());
                    errNumSet.add(invoiceEntity.getNumber());
                }
            }
            for (String id : invIdList) {
                if (rightSet.contains(id)) continue;
                errSet.add(id);
            }
            CommonResponse projectResp = this.projectPoolApi.getById(entity.getProjectId());
            if (!projectResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u9879\u76eeId-{}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)entity.getProjectId(), (Object)JSONObject.toJSONString((Object)projectResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u6240\u5c5e\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            ProjectPoolSetVO project = (ProjectPoolSetVO)projectResp.getData();
            if (null == project.getChiefAccountantId()) {
                return CommonResponse.error((String)("\u9879\u76ee\u3010" + entity.getProjectName() + "\u3011\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4e3b\u7ba1\u4f1a\u8ba1\u4fe1\u606f\uff01"));
            }
            CommonResponse empResp = this.employeeApi.getById(project.getChiefAccountantId());
            if (!empResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u4eba\u5458Id-{}\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)project.getChiefAccountantId(), (Object)JSONObject.toJSONString((Object)empResp));
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4e3b\u7ba1\u4f1a\u8ba1\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
            }
            EmployeeVO emp = (EmployeeVO)empResp.getData();
            if (null == emp) {
                return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u9879\u76ee\u5bf9\u5e94\u7684\u4e3b\u7ba1\u4f1a\u8ba1\u4fe1\u606f\uff01");
            }
            LambdaUpdateWrapper mainUpdate = new LambdaUpdateWrapper();
            mainUpdate.eq(BaseEntity::getId, (Object)entity.getId());
            mainUpdate.set(MatInvoiceEntity::getChiefAccountantId, (Object)emp.getId());
            mainUpdate.set(MatInvoiceEntity::getChiefAccountantName, (Object)emp.getName());
            this.matInvoiceService.update((Wrapper)mainUpdate);
            if (CollectionUtils.isNotEmpty(rightSet)) {
                update = new LambdaUpdateWrapper();
                update.in(MatInvoiceDetailEntity::getErpId, new ArrayList(rightSet));
                update.set(MatInvoiceDetailEntity::getInvoiceState, (Object)"\u6b63\u5e38");
                this.matInvoiceDetailService.update((Wrapper)update);
            }
            if (CollectionUtils.isNotEmpty(errSet)) {
                update = new LambdaUpdateWrapper();
                update.in(MatInvoiceDetailEntity::getErpId, new ArrayList(errSet));
                update.set(MatInvoiceDetailEntity::getInvoiceState, (Object)"\u5f02\u5e38");
                this.matInvoiceDetailService.update((Wrapper)update);
                return CommonResponse.error((String)("\u53f7\u7801\u4e3a[" + StringUtils.join(errNumSet, (String)",") + "]\u7684\u53d1\u7968\u72b6\u6001\u4e0d\u662f\u6b63\u5e38\u72b6\u6001\uff0c\u65e0\u6cd5\u542f\u52a8\u6d41\u7a0b\uff01"));
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        MatInvoiceEntity e = (MatInvoiceEntity)((Object)this.matInvoiceService.selectById(billId));
        UserContext user = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(user.getUserCode());
        e.setCommitUserCode(user.getUserName());
        this.matInvoiceService.saveOrUpdate((Object)e, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        MatInvoiceEntity e = (MatInvoiceEntity)((Object)this.matInvoiceService.selectById(billId));
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        if (PlanConstant.SOURCE_TYPE_SUPPLIER.equals(e.getSourceType())) {
            updateWrapper.set(MatInvoiceEntity::getSignState, (Object)"0");
        }
        updateWrapper.set(MatInvoiceEntity::getCommitDate, null);
        updateWrapper.set(MatInvoiceEntity::getCommitUserCode, null);
        updateWrapper.set(MatInvoiceEntity::getCommitUserName, null);
        updateWrapper.set(MatInvoiceEntity::getFinalApproveUserId, null);
        updateWrapper.set(MatInvoiceEntity::getFinalApproveUserName, null);
        updateWrapper.set(MatInvoiceEntity::getFinalApproveUserCode, null);
        this.matInvoiceService.update((Wrapper)updateWrapper);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.UNCOMMITED_STATE.getBillStateCode().equals(state)) {
            return this.checkInvoiceState(billId);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        MatInvoiceEntity e = (MatInvoiceEntity)((Object)this.matInvoiceService.selectById(billId));
        UserContext user = this.sessionManager.getUserContext();
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(user.getUserCode());
            e.setCommitUserCode(user.getUserName());
        }
        e.setEffectiveDate(new Date());
        e.setFinalApproveUserId(user.getUserId());
        e.setFinalApproveUserName(user.getUserName());
        e.setFinalApproveUserCode(user.getUserCode());
        this.matInvoiceService.saveOrUpdate((Object)e, false);
        this.matInvoiceService.syncToErp(billId, user.getUserId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other) {
        MatInvoiceEntity entity = (MatInvoiceEntity)((Object)this.matInvoiceService.selectById(billId));
        CommonResponse projectResp = this.projectPoolApi.getById(entity.getProjectId());
        if (!projectResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u9879\u76eeId-{}\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)entity.getProjectId(), (Object)JSONObject.toJSONString((Object)projectResp));
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u6240\u5c5e\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ProjectPoolSetVO project = (ProjectPoolSetVO)projectResp.getData();
        if (null == project.getChiefAccountantId()) {
            return CommonResponse.error((String)("\u9879\u76ee\u3010" + entity.getProjectName() + "\u3011\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u4e3b\u7ba1\u4f1a\u8ba1\u4fe1\u606f\uff01"));
        }
        JSONArray resp = new JSONArray();
        CommonResponse empResp = this.employeeApi.getById(project.getChiefAccountantId());
        if (!empResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u4eba\u5458Id-{}\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)project.getChiefAccountantId(), (Object)JSONObject.toJSONString((Object)empResp));
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4e3b\u7ba1\u4f1a\u8ba1\u4eba\u5458\u4fe1\u606f\u5931\u8d25\uff01");
        }
        EmployeeVO emp = (EmployeeVO)empResp.getData();
        JSONObject obj = new JSONObject();
        obj.put("userId", (Object)emp.getId());
        obj.put("userName", (Object)emp.getName());
        resp.add((Object)obj);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resp);
    }
}

