/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceContentEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialBasePriceEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialBasePriceMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceContentService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialBasePriceService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceContentVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialBasePriceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialBasePriceService")
public class MaterialBasePriceServiceImpl
extends BaseServiceImpl<MaterialBasePriceMapper, MaterialBasePriceEntity>
implements IMaterialBasePriceService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BASE-PRICE-IMPORT";
    @Autowired
    private IMaterialBasePriceContentService materialBasePriceContentService;

    @Override
    public CommonResponse<MaterialBasePriceVO> saves(MaterialBasePriceVO saveOrUpdateVO) {
        MaterialBasePriceEntity entity2;
        List materialBasePriceContentList = saveOrUpdateVO.getMaterialBasePriceContentList();
        List collect = materialBasePriceContentList.stream().map(MaterialBasePriceContentVO::getMaterialId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        if (CollectionUtils.isNotEmpty(collect)) {
            queryParam.getParams().put("materialId", new Parameter("in", collect));
            queryParam.getParams().put("areaName", new Parameter("eq", (Object)saveOrUpdateVO.getAreaName()));
            queryParam.getParams().put("brandName", new Parameter("eq", (Object)saveOrUpdateVO.getBrandName()));
            queryParam.getParams().put("supplierName", new Parameter("eq", (Object)saveOrUpdateVO.getSupplierName()));
            queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
            queryParam.getParams().put("status", new Parameter("eq", (Object)1));
            List materialBasePriceContentEntities = this.materialBasePriceContentService.queryList(queryParam);
            HashMap map = new HashMap();
            materialBasePriceContentEntities.forEach(entity -> {
                if (!map.containsKey(entity.getMaterialId())) {
                    map.put(entity.getMaterialId(), entity);
                } else if (((MaterialBasePriceContentEntity)((Object)((Object)map.get(entity.getMaterialId())))).getPublishDate().after(entity.getPublishDate())) {
                    map.put(entity.getMaterialId(), entity);
                }
            });
            materialBasePriceContentList.forEach(vo -> {
                Long materialId = vo.getMaterialId();
                if (map.containsKey(materialId) && ((MaterialBasePriceContentEntity)((Object)((Object)map.get(materialId)))).getPublishDate().after(vo.getPublishDate())) {
                    throw new BusinessException("\u5df2\u5b58\u5728\u665a\u4e8e" + vo.getMaterialName() + "\u8be5\u65e5\u671f\u7684\u6570\u636e");
                }
            });
        }
        if ((entity2 = (MaterialBasePriceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MaterialBasePriceEntity.class))).getId() == null || entity2.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity2.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(entity2.getMaterialBasePriceContentList())) {
            entity2.getMaterialBasePriceContentList().parallelStream().forEach(detail -> {
                detail.setBrandId(entity2.getBrandId());
                detail.setBrandName(entity2.getBrandName());
                detail.setSupplierCode(entity2.getSupplierCode());
                detail.setSupplierId(entity2.getSupplierId());
                detail.setSupplierName(entity2.getSupplierName());
                detail.setArea(entity2.getArea());
                detail.setAreaName(entity2.getAreaName());
            });
        }
        super.saveOrUpdate((Object)entity2, false);
        MaterialBasePriceVO vo2 = (MaterialBasePriceVO)BeanMapper.map((Object)((Object)entity2), MaterialBasePriceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo2);
    }

    @Override
    @Transactional
    public CommonResponse<String> changeStatus(MaterialBasePriceVO saveOrUpdateVO) {
        Long id = saveOrUpdateVO.getId();
        Integer status = saveOrUpdateVO.getStatus();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"status", (Object)status);
        updateWrapper.eq((Object)"id", (Object)id);
        super.update((Wrapper)updateWrapper);
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"status", (Object)status);
        wrapper.in((Object)"baseprice_id", new Object[]{id});
        this.materialBasePriceContentService.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u72b6\u6001\u6210\u529f\uff01");
    }
}

