/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertyEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategoryPropertyMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialPropertyRelationService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="materialCategoryPropertyService")
public class MaterialCategoryPropertyServiceImpl
extends BaseServiceImpl<MaterialCategoryPropertyMapper, MaterialCategoryPropertyEntity>
implements IMaterialCategoryPropertyService {
    @Autowired
    private IMaterialCategoryPropertySubItemService detailService;
    @Autowired
    private IMaterialPropertyRelationService relationService;
    @Lazy
    @Autowired
    private IMaterialCategoryService materialCategoryService;

    @Override
    public List<MaterialCategoryPropertyVO> getAllByCategoryId(Long categoryId, Integer enabled) {
        List<Object> resp = new ArrayList<MaterialCategoryPropertyVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"category_id", (Object)categoryId);
        if (null != enabled) {
            query.eq((Object)"enabled", (Object)enabled);
        }
        query.orderByAsc((Object)"sequence");
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, MaterialCategoryPropertyVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialCategoryPropertyVO> getAllPropertiesAndValue(Long categoryId, Integer enabled, Boolean includeUnValid) {
        List<MaterialCategoryPropertyVO> properties = this.getAllByCategoryId(categoryId, enabled);
        List<MaterialCategoryPropertySubItemVO> values = this.detailService.getAllByCategoryId(categoryId, includeUnValid);
        HashMap<String, List<MaterialCategoryPropertySubItemVO>> propertyValueMap = new HashMap<String, List<MaterialCategoryPropertySubItemVO>>();
        if (CollectionUtils.isNotEmpty(values)) {
            propertyValueMap.putAll(values.stream().collect(Collectors.groupingBy(item -> item.getPropertyId().toString())));
        }
        properties.stream().filter(property -> propertyValueMap.containsKey(property.getId().toString())).forEach(property -> property.setItemList((List)propertyValueMap.get(property.getId().toString())));
        return properties;
    }

    @Override
    public List<MaterialCategoryPropertyVO> getAllPropertiesAndValueHaveUnit(Long categoryId, Integer enabled, Boolean includeUnValid) {
        List<MaterialCategoryPropertyVO> properties = this.getAllPropertiesAndValue(categoryId, enabled, includeUnValid);
        if (null != categoryId) {
            List<MaterialCategoryEntity> categoryEntityList = this.materialCategoryService.getParentsByChildId(categoryId);
            if (CollectionUtils.isNotEmpty(categoryEntityList = categoryEntityList.stream().filter(item -> null != item.getMainUnitId()).sorted(Comparator.comparing(MaterialCategoryEntity::getInnerCode).reversed()).collect(Collectors.toList()))) {
                MaterialCategoryPropertyVO materialCategoryPropertyVO = new MaterialCategoryPropertyVO();
                materialCategoryPropertyVO.setId(Long.valueOf(1L));
                materialCategoryPropertyVO.setCategoryId(categoryId);
                materialCategoryPropertyVO.setCode(categoryEntityList.get(0).getMainUnitId().toString());
                materialCategoryPropertyVO.setName(categoryEntityList.get(0).getMainUnitName());
                properties.add(materialCategoryPropertyVO);
            }
        }
        return properties;
    }

    @Override
    public String checkQuote(List<Long> propertyIds) {
        List<MaterialPropertyRelationVO> relations = this.relationService.getAllByPropertyIds(propertyIds);
        if (CollectionUtils.isNotEmpty(relations)) {
            Set quotePropertyIds = relations.stream().map(MaterialPropertyRelationVO::getPropertyId).collect(Collectors.toSet());
            QueryWrapper query = new QueryWrapper();
            query.select(new String[]{"name"});
            query.in((Object)"id", quotePropertyIds);
            List names = super.listObjs((Wrapper)query);
            return "\u5c5e\u6027\u3010" + names.stream().map(item -> item.toString()).collect(Collectors.joining(",")) + "\u3011\u88ab\u5f15\u7528";
        }
        return null;
    }

    @Override
    public List<MaterialCategoryPropertyVO> queryByIds(List<Long> ids) {
        List<Object> resp = new ArrayList<MaterialCategoryPropertyVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.orderByAsc((Object)"sequence");
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            resp = BeanMapper.mapList((Iterable)eList, MaterialCategoryPropertyVO.class);
        }
        return resp;
    }

    @Override
    public Map<Long, List<MaterialCategoryPropertyVO>> getAllByCategoryIds(List<Long> categoryIds) {
        HashMap<Long, List<MaterialCategoryPropertyVO>> result = new HashMap<Long, List<MaterialCategoryPropertyVO>>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.orderByAsc((Object)"sequence");
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            result.putAll(BeanMapper.mapList((Iterable)eList, MaterialCategoryPropertyVO.class).stream().collect(Collectors.groupingBy(MaterialCategoryPropertyVO::getCategoryId, Collectors.toList())));
        }
        return result;
    }

    @Override
    public Map<Long, List<MaterialCategoryPropertyVO>> getAllByCategoryIds(List<Long> categoryIds, Integer enabled) {
        HashMap<Long, List<MaterialCategoryPropertyVO>> result = new HashMap<Long, List<MaterialCategoryPropertyVO>>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.eq((Object)"enabled", (Object)enabled);
        query.orderByAsc((Object)"sequence");
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            result.putAll(BeanMapper.mapList((Iterable)eList, MaterialCategoryPropertyVO.class).stream().collect(Collectors.groupingBy(MaterialCategoryPropertyVO::getCategoryId, Collectors.toList())));
        }
        return result;
    }
}

