/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSMaterialCommonEnums;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryPropertySubItemEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialCategoryPropertySubItemMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertyService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryPropertySubItemService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertySubItemVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialCategoryPropertyVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialCategoryPropertySubItemService")
public class MaterialCategoryPropertySubItemServiceImpl
extends BaseServiceImpl<MaterialCategoryPropertySubItemMapper, MaterialCategoryPropertySubItemEntity>
implements IMaterialCategoryPropertySubItemService {
    @Autowired
    private MaterialCategoryPropertySubItemMapper mapper;
    @Autowired
    private IMaterialCategoryPropertyService materialCategoryPropertyService;

    @Override
    public List<MaterialCategoryPropertySubItemVO> getAllByCategoryId(Long categoryId) {
        return this.getAllByCategoryId(categoryId, false);
    }

    @Override
    public List<MaterialCategoryPropertySubItemVO> getAllByCategoryId(Long categoryId, Boolean includeUnValid) {
        List<MaterialCategoryPropertyVO> pList = this.materialCategoryPropertyService.getAllByCategoryId(categoryId, 1);
        List propertyIds = pList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<Object> resp = new ArrayList<MaterialCategoryPropertySubItemVO>();
        if (CollectionUtils.isNotEmpty(propertyIds)) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"category_id", (Object)categoryId);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            query.eq((Object)"enabled", (Object)ZDSMaterialCommonEnums.\u505c\u542f\u7528_\u542f\u7528.getCode());
            query.in((Object)"property_id", propertyIds);
            if (null != includeUnValid) {
                if (!includeUnValid.booleanValue()) {
                    query.eq((Object)"valid_flag", (Object)ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u662f.getCode());
                } else {
                    query.and(q -> (QueryWrapper)((QueryWrapper)q.eq((Object)"valid_flag", (Object)ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u662f.getCode())).or(qi -> (QueryWrapper)((QueryWrapper)qi.eq((Object)"valid_flag", (Object)ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u5426.getCode())).like((Object)"related_user_ids", (Object)InvocationInfoProxy.getUserid())));
                }
            }
            query.orderByAsc((Object)"sequence");
            List eList = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)eList)) {
                resp = BeanMapper.mapList((Iterable)eList, MaterialCategoryPropertySubItemVO.class);
            }
        }
        return resp;
    }

    @Override
    public List<Long> getInValidPropertyItemIds(List<Long> materialIds) {
        return this.mapper.getInValidPropertyItemIds(materialIds);
    }

    @Override
    public void validPropertyItems(List<Long> getInValidPropertyItemIds) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", getInValidPropertyItemIds);
        update.set((Object)"valid_flag", (Object)ZDSMaterialCommonEnums.\u5206\u7c7b\u8bbe\u7f6e\u5c5e\u6027\u503c\u662f\u5426\u751f\u6548_\u662f.getCode());
        update.set((Object)"update_time", (Object)new Date());
        update.set((Object)"update_user_code", (Object)InvocationInfoProxy.getUsercode());
        super.update((Wrapper)update);
    }

    @Override
    public List<MaterialCategoryPropertySubItemVO> searchList(MaterialCategoryPropertySubItemVO searchVO) {
        return this.mapper.searchList(searchVO);
    }

    @Override
    public Map<Long, List<MaterialCategoryPropertySubItemVO>> getAllByCategoryIds(List<Long> categoryIds) {
        HashMap<Long, List<MaterialCategoryPropertySubItemVO>> result = new HashMap<Long, List<MaterialCategoryPropertySubItemVO>>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.orderByAsc((Object)"sequence");
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            result.putAll(BeanMapper.mapList((Iterable)eList, MaterialCategoryPropertySubItemVO.class).stream().collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId, Collectors.toList())));
        }
        return result;
    }

    @Override
    public Map<Long, List<MaterialCategoryPropertySubItemVO>> getAllByCategoryIds(List<Long> categoryIds, Integer enabled) {
        HashMap<Long, List<MaterialCategoryPropertySubItemVO>> result = new HashMap<Long, List<MaterialCategoryPropertySubItemVO>>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"category_id", categoryIds);
        query.eq((Object)"enabled", (Object)enabled);
        query.orderByAsc((Object)"sequence");
        List eList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)eList)) {
            result.putAll(BeanMapper.mapList((Iterable)eList, MaterialCategoryPropertySubItemVO.class).stream().collect(Collectors.groupingBy(MaterialCategoryPropertySubItemVO::getPropertyId, Collectors.toList())));
        }
        return result;
    }

    @Override
    public List<MaterialCategoryPropertySubItemEntity> queryByNames(ArrayList<String> names, Long propertyId) {
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"name", names);
        if (null != propertyId) {
            query.eq((Object)"property_id", (Object)propertyId);
        }
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        return super.list((Wrapper)query);
    }

    @Override
    public void updatePropertyItemsValidFlag(List<Long> validPropertyValIds, Integer code) {
        UpdateWrapper update = new UpdateWrapper();
        update.in((Object)"id", validPropertyValIds);
        update.set((Object)"valid_flag", (Object)code);
        super.update((Wrapper)update);
    }
}

