/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.material.bean.MaterialPropertyRelationEntity;
import com.ejianc.business.zdsmaterial.material.mapper.MaterialPropertyRelationMapper;
import com.ejianc.business.zdsmaterial.material.service.IMaterialPropertyRelationService;
import com.ejianc.business.zdsmaterial.material.vo.MaterialPropertyRelationVO;
import com.ejianc.business.zdsmaterial.material.vo.MaterialRelationAiVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialPropertyRelationService")
public class MaterialPropertyRelationServiceImpl
extends BaseServiceImpl<MaterialPropertyRelationMapper, MaterialPropertyRelationEntity>
implements IMaterialPropertyRelationService {
    @Autowired
    private MaterialPropertyRelationMapper mapper;

    @Override
    public void deleteByMaterialIds(List<Long> materialIds) {
        this.mapper.deleteByMaterialIds(materialIds);
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByMaterialIds(List<Long> ids) {
        List<Object> resp = new ArrayList<MaterialPropertyRelationVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"material_id", ids);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, MaterialPropertyRelationVO.class);
        }
        return resp;
    }

    @Override
    public List<Long> matchedMaterialIdsByPropertyVal(Map<String, Object> propertyFilterParam) {
        return this.mapper.matchedMaterialIdsByPropertyVal(propertyFilterParam);
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByPropertyIds(List<Long> propertyIds) {
        List<Object> resp = new ArrayList<MaterialPropertyRelationVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"property_id", propertyIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, MaterialPropertyRelationVO.class);
        }
        return resp;
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByPropertyValueIds(List<Long> propertyValueIds) {
        List<Object> resp = new ArrayList<MaterialPropertyRelationVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"property_item_id", propertyValueIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, MaterialPropertyRelationVO.class);
        }
        return resp;
    }

    @Override
    public String checkMaterialPropertyValue(Long materialId) {
        String msg = null;
        List<String> propertyNames = this.mapper.checkMaterialPropertyValue(materialId);
        if (CollectionUtils.isNotEmpty(propertyNames)) {
            msg = "\u6750\u6599\u5c5e\u6027\uff1a" + propertyNames.stream().collect(Collectors.joining(",")) + "\u4e0e\u5206\u7c7b\u4e0b\u5c5e\u6027\u503c\u4e0d\u5339\u914d";
        }
        return msg;
    }

    @Override
    public List<MaterialPropertyRelationVO> getAllByCategoryId(Long categoryId) {
        List<Object> resp = new ArrayList<MaterialPropertyRelationVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"category_id", (Object)categoryId);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, MaterialPropertyRelationVO.class);
        }
        return resp;
    }

    @Override
    public List<Long> validMaterialHasNewPropertyItem(List<Long> materialIds) {
        return this.mapper.validMaterialHasNewPropertyItem(materialIds);
    }

    @Override
    public List<MaterialRelationAiVO> getAiRelationsByMaterialIds(List<Long> materialIds) {
        return this.mapper.getAiRelationsByMaterialIds(materialIds);
    }
}

