/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.out.service.impl;

import com.ejianc.business.zdsmaterial.out.bean.DisposeDetailEntity;
import com.ejianc.business.zdsmaterial.out.bean.DisposeEntity;
import com.ejianc.business.zdsmaterial.out.service.IDisposeService;
import com.ejianc.business.zdsmaterial.out.vo.DisposeVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dispose")
public class DisposeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IDisposeService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(billId));
        this.service.inOutStore(entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(billId));
        this.service.inOutStoreRollback(entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(billId));
        this.service.validateStoreNum((DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class));
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            this.service.inOutStore(entity, false);
            this.service.inOutStore(entity, true);
        } else {
            this.service.inOutStore(entity, true);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(billId));
        List<DisposeDetailEntity> detailList = entity.getDisposeDetailList();
        for (DisposeDetailEntity vo : detailList) {
            vo.setActualTaxMny(null);
            vo.setActualMny(null);
        }
        entity.setActualDisposeMny(null);
        entity.setActualDisposeTaxMny(null);
        this.service.saveOrUpdate((Object)entity, false);
        this.service.inOutStoreRollback(entity, true);
        this.service.inOutStoreRollback(entity, false);
        return CommonResponse.success();
    }
}

